untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3okVGJgYNT9mSYZiIcz1guKWI6HHlf/h44OIAZ7Re7AiI2pbKnuiShyXe3jjmjI4J6VfxSBUmrq07v7a58Cl8gE=

OpenBSD 6.7 errata 001, May 19, 2020:

An out-of-bounds index access in wscons(4) can cause a kernel crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 001_wscons.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/wscons/wsdisplay.c
===================================================================
RCS file: /cvs/src/sys/dev/wscons/wsdisplay.c,v
retrieving revision 1.138
diff -u -p -u -r1.138 wsdisplay.c
--- sys/dev/wscons/wsdisplay.c	26 Apr 2020 11:31:07 -0000	1.138
+++ sys/dev/wscons/wsdisplay.c	10 May 2020 21:04:49 -0000
@@ -1261,7 +1261,7 @@ wsdisplay_internal_ioctl(struct wsdispla
 
 	case WSDISPLAYIO_GETSCREENTYPE:
 #define d ((struct wsdisplay_screentype *)data)
-		if (d->idx >= sc->sc_scrdata->nscreens)
+		if (d->idx < 0 || d->idx >= sc->sc_scrdata->nscreens)
 			return(EINVAL);
 
 		d->nidx = sc->sc_scrdata->nscreens;
Index: sys/dev/wscons/wsemulconf.c
===================================================================
RCS file: /cvs/src/sys/dev/wscons/wsemulconf.c,v
retrieving revision 1.9
diff -u -p -u -r1.9 wsemulconf.c
--- sys/dev/wscons/wsemulconf.c	14 Mar 2015 03:38:50 -0000	1.9
+++ sys/dev/wscons/wsemulconf.c	10 May 2020 21:04:49 -0000
@@ -78,7 +78,7 @@ wsemul_pick(const char *name)
 const char *
 wsemul_getname(int idx)
 {
-	if (idx >= nitems(wsemul_conf) - 1)
+	if (idx < 0 || idx >= nitems(wsemul_conf) - 1)
 		return (NULL);
 	return (wsemul_conf[idx]->name);
 }
