untrusted comment: verify with openbsd-71-base.pub
RWR2eHwZTOEiTce84MsuJhhlLfqvRMd6WAQU4GmiW4nPtX50jAfuk3OnP3+UcIGkzq7opISKQ076MmUWrkTtrv0H8tfylHTJ2A8=

OpenBSD 7.1 errata 021, January 21, 2023:

vmd(8) exposed unsupported cpuid feature flags to guests.

Apply by doing:
    signify -Vep /etc/signify/openbsd-71-base.pub -x 021_vmd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install vmd:
    cd /usr/src/usr.sbin/vmd
    make obj
    make
    make install

Index: usr.sbin/vmd/vmd.c
===================================================================
RCS file: /cvs/src/usr.sbin/vmd/vmd.c,v
retrieving revision 1.130
diff -u -p -u -r1.130 vmd.c
--- usr.sbin/vmd/vmd.c	1 Mar 2022 21:46:19 -0000	1.130
+++ usr.sbin/vmd/vmd.c	19 Jan 2023 16:24:46 -0000
@@ -642,8 +642,9 @@ vmd_check_vmh(struct vm_dump_header *vmh
 				    code, leaf);
 				return (-1);
 			}
-			if ((vmh->vmh_cpuids[i].c & c & VMM_SEFF0ECX_MASK) !=
-			    (vmh->vmh_cpuids[i].c & VMM_SEFF0ECX_MASK)) {
+#define VMM_SEFF0ECX_MASK_T (SEFF0ECX_UMIP)
+			if ((vmh->vmh_cpuids[i].c & c & VMM_SEFF0ECX_MASK_T) !=
+			    (vmh->vmh_cpuids[i].c & VMM_SEFF0ECX_MASK_T)) {
 				log_debug("%s: incompatible cpu features "
 				    "code: 0x%x leaf: 0x%x  reg: d", __func__,
 				    code, leaf);
