/*                             */
/*  Pathes to the programs     */
/*                             */

#define TEXPATH		"/home/bin/virtex"
/* (there must be symbolic links from virtex to your format-files  */
/*  in this directory too.                                         */
/*    e.g.:       ln -s /home/bin/virtex /home/bin/myformat        */
/*  change the names of the format-files below ( texprogs[2][5] )  */
/*  to fit to your system.                                         */

#define EDITORPATH	"/usr/openwin/bin/textedit"
#define EDITOR		"textedit"

#define XDVIPATH	"/home/bin/xdvi"
#define XDVI		"xdvi"

#define	TEXXPATH	"/home/bin/texx"
#define	TEXX		"texx"

#define GHOSTVIEWPATH	"/home/bin/ghostview"
#define GHOSTVIEW	"ghostview"

#define GSPREVIEWPATH	"/home/bin/gspreview"
#define GSPREVIEW	"gspreview"

#define DVIPSPATH	"/home/bin/dvips"
#define DVIPS		"dvips"

#define GSPATH		"/home/bin/gs"
#define GS		"gs"

#define BIBTEXPATH	"/home/bin/bibtex"
#define BIBTEX		"bibtex"

#define MAKEINDEXPATH	"/home/bin/makeindex"
#define MAKEINDEX	"makeindex"

#define DVILJ2PPATH	"/home/bin/dvilj2p"
#define DVILJ2P		"dvilj2p"

#define DVILJ4PATH	"/home/bin/dvilj4"
#define DVILJ4		"dvilj4"

#define PLAYPATH	"/home/bin/play"
#define PLAY		"play"
#define SOUND_GONG		"/home/TeX/TeXshell/gong.au"
#define SOUND_SPACEMUSIC	"/home/TeX/TeXshell/spacemusic.au"

#define XFIGPATH	"/home/bin/xfig"

#define COPYPATH	"/usr/bin/cp"
#define COPY		"cp"

#ifdef linux
#define PRINTERPATH	"/usr/bin/lpr"
#define QUEUEPATH	"/usr/bin/lpq"
#define QUEUE		"lpq"
#else
#define PRINTERPATH	"/usr/ucb/lpr"
#define QUEUEPATH	"/usr/ucb/lpq"
#define QUEUE		"lpq"
#endif

#define HELPFILE	"/home/TeX/TeXshell/XTeXshell.help"

#define VORLAGE1_TEX_DEFAULT	"/home/TeX/lib/texinput/IfM/rubbrief.muster"
#define VORLAGE1_TEX_USER	".rubbrief.muster"
#define VORLAGE1_LATEX_DEFAULT	"/home/TeX/lib/texinput/IfM/rubletter.muster"
#define VORLAGE1_LATEX_USER	".rubletter.muster"
#define VORLAGE2_TEX_DEFAULT	"/home/TeX/lib/texinput/IfM/rubfax.muster"
#define VORLAGE2_TEX_USER	".rubfax.muster"
#define VORLAGE2_LATEX_DEFAULT	"/home/TeX/lib/texinput/IfM/rubtelefax.muster"
#define VORLAGE2_LATEX_USER	".rubtelefax.muster"


/*                             */
/* Arguments of program calls: */
/*                             */

#define DESKJET	2
#define	MAXDEVICES 3

static char	*printername[]	= {"hpIIIp","hpIV","deskjet"};
static char	*printer_args[5]= {"lpr","-h","-P",0,0};

static char	*GS_devices[]={"-sDEVICE=ljet3","-sDEVICE=ljet4","-sDEVICE=cdj550"};
static char	*GS_args[]   ={"gs","-q",0,"-sPAPERSIZE=a4","-dDESKFONTS",
			       "-dNOPAUSE","-sOutputFile=-","-",0	};

static char	*dvipsargs[]={"dvips","-D300","-D600","-Z",
			      "-A","-B","-tlandscape","-ta4","-f"};

static char	*pclargs[]={"dvilj2p","dvilj4","-D1","-D2","-D","-l","-e-"};

static char	*xfigargs[]={"xfig","-me","-sp","-te","-e","pstex_t",0};

static char	*texprogs[2][5]=
			{"gplain","glatex","nfss2tx","nfss2ltx","",	/*german */
			 "tex",	  "latex", "nfss1tx","nfss2ltx",""  };	/*english*/
/* Format 1 and 3 need to bo plain TeX Formats,                    */
/* Format 2 and 4 need to be LaTex Formats, 5 is your own choice.  */


/*                             */
/* Text on Buttons             */
/*                             */

/* Print Popup: */
char *printzweiseitigs[] = { "odd" , "even" };
char *printresolutions[]   = { "300" , "600" };
char *printlanguages[] = { "PCL" , "Postscript" };
char *printdevices[]   = { "HP IIIp", "HP IV", "HP Deskjet", "File" };

/* TeX Properties POPUP: */
char *formats[5]	= {"plain","LaTeX","plain NFSS2","LaTeX NFSS2",""};
char *languages[]	= {"german","english","chinese","russian"};
char *utilprogs[]	= {"BiBTeX","MakeIndex"};
char *runs[]		= {"1","2","3"};
char *resolutions[]	= {"101","118","300","360","600",""};
char *previewers[]	= {"Xdvi","TeXX","Ghostview","GS Preview"};
char *shrinks[]		= {"1","2","3","4"};
char *displays[]	= {"1-page","2-pages"};

/* Load File POPUP: */
char *document_Vorlages[]   = {"keine","RUB Brief","RUB Fax","File ..."};
