/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "recode.h"
#include "str_fun.h"
#include "initial.h"
#include "refs.h"
#include "rglobal.h"
#include "interf.h"
#include "fl_ut.h"

#define TEMP_FILE_NAME "cp850-l1.tmp"
#define ZEILE_LEN 62000L


 char infile_name[PFAD_LEN+1];
 char temp_file_name[PFAD_LEN+1];

 // extern config_set one_config_set;
 // extern char wrtxtbu[WRTXTBU_LEN+1];

 char * zeile;
 int uebersetzen(void);



int main(int argc, char * argv[])
{
   if (argc==1)
   {
     printf("\ncp850-to-latin1 -- converts a text file from cp850 to latin-1 encoding\n\n"
            "Usage:\n"
            "   cp850-to-latin1 file\n");
#ifdef REFS_USES_LINUXGCC
     printf("\n");
#endif
     return 0;
   } else 
   {
      strlimcpy(infile_name,argv[1],PFAD_LEN);
      if (!isfile(infile_name))
      {
         printf("\nError: cannot open `%s'\n",infile_name);
#ifdef REFS_USES_LINUXGCC
         printf("\n");
#endif
         return 1;
      } else
      {
         printf("\nProcessing `%s'\n",infile_name);
#ifdef REFS_USES_LINUXGCC
         printf("\n");
#endif
      }
   }
   strlimcpy(temp_file_name,TEMP_FILE_NAME,PFAD_LEN);
   if ((zeile = (char *) malloc((ZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      printf("\nError: memory allocation failed\n");
      return 1;
#ifdef REFS_USES_LINUXGCC
      printf("\n");
#endif
   }
   uebersetzen();
   free(zeile);
   return 0;
}


int uebersetzen(void)
{
   FILE * fpin;
   FILE * fpout;
   long i;
   i = 0;
   if ((fpin=fopen(infile_name,"r"))==NULL)
   {
       printf("\nError: cannot read %s\n",infile_name);
       exit(1);
   }
   if ((fpout=fopen(temp_file_name,"w"))==NULL)
   {
       printf("\nError: cannot write %s\n",temp_file_name);
       exit(1);
   }
   while (fgets(zeile,ZEILE_LEN,fpin)!=NULL)
   {
       i++;
       if (strlen(zeile) >= ZEILE_LEN - 1)
       {
          printf("\nError: line %li too long\n",i);
          fclose(fpin);
          fclose(fpout);
          exit(1);
#ifdef REFS_USES_LINUXGCC
          printf("\n");
#endif
       }
       cp850_to_latin1(zeile);
       fprintf(fpout,"%s",zeile);
   }
   
   fclose(fpin);
   fclose(fpout);
   remove(infile_name);
   rename(temp_file_name,infile_name);
   return 1;
}

