/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   expo_fun.c: export records into archive files, write records into forms 
   (for editing data), write empty forms.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "refs.h"
#include "expo_fun.h"
#include "ix01_fun.h"
#include "ix02_fun.h"
#include "ix03_fun.h"
#include "ix04_fun.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "bbf_fun.h"
#include "sortbbf1.h"
#include "initial.h"
#include "interf.h"
 
 
#define REFZAHL_LEN 9
#define TEXTZEILEN_LEN 65
#define TXTBUF_SIZE 15000
#define BBTBUF_SIZE 4000
#define ABS_ZEILE_LEN 30600

 extern char textpfad[PFAD_LEN+1];
 extern char rdbpfad[PFAD_LEN+1];

 extern char journal_pix_name[PFAD_LEN + 1];
 extern char journal_name[PFAD_LEN + 1];
 extern char desc_name[PFAD_LEN + 1];
 extern char book_name[PFAD_LEN + 1];
 extern char autorjl_name[PFAD_LEN + 1];
 extern char autorbu_name[PFAD_LEN + 1];
 extern char quell_pix_name[PFAD_LEN + 1];
 extern char quell_name[PFAD_LEN + 1];
 extern char stichw_name[PFAD_LEN + 1];
 extern char stichw_pix_name[PFAD_LEN + 1];
 static char txt_name[PFAD_LEN + 1]; /* name of archive file */
 static char temporaer1[PFAD_LEN + 1];
 static char temporaer2[PFAD_LEN + 1];
 static char bbt_name[PFAD_LEN + 1];
 extern char abstr_dat_name[PFAD_LEN + 1];
 extern char abstr_pix_name[PFAD_LEN + 1];
 
 static char haupt_schluessel[KENNZIFFER_LEN + 1];
 static char txt_buf[TXTBUF_SIZE + 1];
 static char bbt_buf[BBTBUF_SIZE + 1];
  extern char wrtxtbu[WRTXTBU_LEN+1];
 
 extern FILE * ix01file;
 extern FILE * ix02file;
 extern FILE * ix03file;
 extern FILE * ix04file;
 extern FILE * fpjournal;
 extern FILE * fpdesc;
 extern FILE * fpbuch;
 extern FILE * fpautorjl;
 extern FILE * fpautorbu;
 extern FILE * fpsource;
 extern FILE * fpstichw;
 extern FILE * fpabs;

 static FILE * fpbbt;
 static FILE * fptxt;
 static char * au_zeile;
 static char * ed_zeile;
 static char * ex_au_zeile;
 static char * abs_zeile;
 static char * desc_zeile;
 
 extern config_set one_config_set;
 
 extern journal_rec            one_journal_rec;
 extern desc_rec               one_desc_rec;
 extern buch_rec               one_buch_rec;
 extern quell_rec              one_quell_rec;
 extern refspix_rec            ix01rec;
 extern quellpix_rec           ix02rec;
 extern keylistpix_rec         ix03rec;
 extern author_rec             one_aued_rec;
 static bbatchtable_rec        one_bbt_rec;
 extern keylist_rec            one_stichw_rec;
 extern abstr_rec              one_abstr_rec;
 extern abstrpix_rec           ix04rec;

 static int eigene_kennziff;
   /*
    1: Die Kennziffern der Datenbank werden in das Archiv
       uebernommen
    2: Es werden eigene fortlaufende Kennziffern zugewiesen
   */
 static long erste_kennziff;

 static int getfilenames(void);
 static int dateien_oeffnen_expo_fun(const char * code);
 static void dateien_schliessen_expo_fun(const char * code);
 static int machlist_expo_fun(void);
 static void compile_j1(void);
 static void compile_j2(void);
 static void compile_b1(void);
 static void compile_b2(void);
 static void compile_b3(void);
 static void compile_m1(void);
 static void compile_m2(void);
 static void compile_aued(FILE * fpaued, char * auedstring, long zeiger, char * separator);
 static void compile_desc(char * desc_zeile, long zeiger, char * separator);
 static void journal_archivieren(void);
 static void stichw_archivieren(void);
 static int add_abstract(char * kennziffer);
 static int expo_fun_speicher_allokieren(void);
 static int expo_fun_speicher_freigeben(void);
    
 static int machlist_expo_fun_formular(char * kennziffer);
 static void compile_j1_formular(char * kz);
 static void compile_j2_formular(char * kz);
 static void compile_b1_formular(char * kz);
 static void compile_b2_formular(char * kz);
 static void compile_b3_formular(char * kz);
 static void compile_m1_formular(char * kz);
 static void compile_m2_formular(char * kz);
 static int add_abstract_formular(char * kennziffer);

 static void compile_j1_leer_formular(char * kz_proposed);
 static void compile_j2_leer_formular(char * kz_proposed);
 static void compile_b1_leer_formular(char * kz_proposed);
 static void compile_b2_leer_formular(char * kz_proposed);
 static void compile_b3_leer_formular(char * kz_proposed);
 static void compile_m1_leer_formular(char * kz_proposed);
 static void compile_m2_leer_formular(char * kz_proposed);
    
 static int fcode;
     /* Funktion-Code
        1: komplett
        2: keine keywords, journal names
     */
 
int expo_fun_main(void)
{
     static char ein[INPUT_BU_LEN+1];

     strlimcpy(temporaer1,rdbpfad,PFAD_LEN);
     strlimcat(temporaer1,"_$.BBT",PFAD_LEN);
     strlimcpy(temporaer2,rdbpfad,PFAD_LEN);
     strlimcat(temporaer2,"_$$.BBT",PFAD_LEN);

     wrtxt("\nMenu: Archive with/without keywords thesaurus/journal names [c/e/q]?\n");
     strcpy(ein,"menu");
     fcode = menu_wahl(ein,
          "[c] write a complete archive with records, journal names and keywords\n"
          "[e] write an archive for exchange (no keywords thesaurus/journal names)\n"
          "[q] quit"
          );
     if  (fcode==3)  
     {
        wrtxt("\n(Export aborted)\n");
        return 0;
     }
     if (!getfilenames()) 
     { 
        return 0;
     }
     if (expo_fun_speicher_allokieren()==0)
     {
        fprintf(stderr,"\nProblem: Unable to allocate sufficient memory in function\n"
                "`expo_fun_speicher_allokieren()'\n");
        exit(1);
     }
     if (dateien_oeffnen_expo_fun("archive"))
     {
       machlist_expo_fun();
       dateien_schliessen_expo_fun("archive");
     }
     if (isfile(temporaer1)) remove(temporaer1);
     if (isfile(temporaer2)) remove(temporaer2);

     expo_fun_speicher_freigeben();
     return 1;
}

int expo_formular_main(char * kennziffer)
{
     int mach_ok;
     
     mach_ok = 0;
     
     if (expo_fun_speicher_allokieren()==0)
     {
        fprintf(stderr,"\nProblem: Unable to allocate sufficient memory in function\n"
                "`expo_fun_speicher_allokieren()'\n");
        exit(1);
     }
     strlimcpy(txt_name,textpfad,PFAD_LEN);
     strlimcat(txt_name,one_config_set.form_name,PFAD_LEN);
     if (dateien_oeffnen_expo_fun("form"))
     {
        mach_ok = machlist_expo_fun_formular(kennziffer); 
        dateien_schliessen_expo_fun("form");
     }
     if (mach_ok==1)
     {
       sprintf(wrtxtbu,"\n(Form for editing reference `%s' written "
         "into `%s')\n",
         kennziffer,one_config_set.form_name);
       wrtxt(wrtxtbu);
       load_file_yn(txt_name);
     }
     else
     {
        sprintf(wrtxtbu,"\n(Problem: unable to find reference number or to write `%s')\n",
          one_config_set.form_name);
       wrtxt(wrtxtbu);
     }
     /* next line new 2. Feb. 2003  */
     expo_fun_speicher_freigeben();
     return 1;
}

int expo_leer_formular_main(char * dokumenttyp, char * kennziff)
{
   strlimcpy(txt_name,textpfad,PFAD_LEN);
   strlimcat(txt_name,one_config_set.form_name,PFAD_LEN);
   if ((fptxt=fopen(txt_name,"w"))==NULL)
   {
     sprintf(wrtxtbu,"\nProblem: unable to open %s for writing\n",txt_name);
     wrtxt(wrtxtbu);
     return 0;
   }
   if (!logdatei_oeffnen())
   {
     sprintf(wrtxtbu,"\nProblem: cannot write log file\n");
     wrtxt(wrtxtbu);
     fclose(fptxt);
     return 0;
   } 
   if (strcmp(dokumenttyp,"j1")==0)
   {
     compile_j1_leer_formular(kennziff);
     sprintf(wrtxtbu,"Empty form (j1) written with reference "
       "number `%s'",kennziff);
     logdatei_schreiben(wrtxtbu);
   }
   if (strcmp(dokumenttyp,"j2")==0)
   {
     compile_j2_leer_formular(kennziff); 
     sprintf(wrtxtbu,"Empty form (j2) written with reference "
       "number `%s'",kennziff);
     logdatei_schreiben(wrtxtbu);
   }
   else if (strcmp(dokumenttyp,"b1")==0)
   {
     compile_b1_leer_formular(kennziff); 
     sprintf(wrtxtbu,"Empty form (b1) written with reference "
       "number `%s'",kennziff);
     logdatei_schreiben(wrtxtbu);
   }
   else if (strcmp(dokumenttyp,"b2")==0)
   {
     compile_b2_leer_formular(kennziff); 
     sprintf(wrtxtbu,"Empty form (b2) written with reference "
       "number `%s'",kennziff);
     logdatei_schreiben(wrtxtbu);
   }
   else if (strcmp(dokumenttyp,"b3")==0)
   {
     compile_b3_leer_formular(kennziff); 
     sprintf(wrtxtbu,"Empty form (b3) written with reference "
       "number `%s'",kennziff);
     logdatei_schreiben(wrtxtbu);
   }
   else if (strcmp(dokumenttyp,"m1")==0)
   {
     compile_m1_leer_formular(kennziff); 
     sprintf(wrtxtbu,"Empty form (m1) written with reference "
       "number `%s'",kennziff);
     logdatei_schreiben(wrtxtbu);
   }
   else if (strcmp(dokumenttyp,"m2")==0)
   {
     compile_m2_leer_formular(kennziff); 
     sprintf(wrtxtbu,"Empty form (m2) written with reference "
       "number `%s'",kennziff);
     logdatei_schreiben(wrtxtbu);
   }
   fclose(fptxt);
   /* next line to be included in v4.0c */
   logdatei_schliessen();
   sprintf(wrtxtbu,"\n(Empty form for `%s' written into `%s')\n",
     dokumenttyp,one_config_set.form_name);
   wrtxt(wrtxtbu);
   load_file_yn(txt_name);
   return 1;
}

static int getfilenames(void)
{
  int taste;
  static char ein[INPUT_BU_LEN+1];
  do
  {
    ein_zeile(ein,
        "Please enter archive file name, (`.arr' will be appended)",
        INPUT_BU_LEN);
    if (strlen(ein)==0)
    {
        wrtxt("\n(Export aborted: no file name for archive)\n");
        return 0;
    }
    if (!isvalidfilename(ein))
    {
        continue;
    } else
    {
        break;
    }
  } while (1);
  strlimcpy(txt_name,textpfad,PFAD_LEN);
  strlimcat(txt_name,ein,PFAD_LEN);
  strlimcat(txt_name,".arr",PFAD_LEN);
  sprintf(wrtxtbu,"\nArchive file name is `%s'\n",txt_name);
  wrtxt(wrtxtbu);
  if (isfile(txt_name))
  {
        strcpy(ein,"menu");
        wrtxt("\nMenu: overwrite existing archive [y/n]?\n");
        taste = menu_wahl(ein,
          "[y] yes, existing archive file will be lost\n"
          "[n] no, do not overwrite");
        if (taste==2)
        {
           wrtxt("\n(Export aborted)\n");
           return 0;
        }
  }
  taste = datei_suchen_mit_pfad("*.bbt",
                                 rdbpfad,
                                 bbt_name);
  if (taste)
  {
     int sortiert_ok;
     char kennz_alt[KENNZIFFER_LEN + 1];
     long i, anzahl_records;
     sortiert_ok = 1;

     strcpy(kennz_alt,"");

     if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
     {
          fprintf(stderr,"\nProblem: cannor read %s\n",bbt_name);
          exit(1);
     }
     fseek(fpbbt,0L,SEEK_END);
     anzahl_records = ftell(fpbbt) / sizeof(one_bbt_rec) - 1;
     rewind(fpbbt);
     for (i=0;i<=anzahl_records;i++)
     {
         if (fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt)==0)
         {
             sprintf(wrtxtbu,"\nERROR: at least one record in `%s' "
               "has not been read\n",
                bbt_name);
             wrtxt(wrtxtbu);
         }
         if (strcmp(kennz_alt,one_bbt_rec.kennziffer)>=0)
         {
            sortiert_ok = 0;
            wrtxt("\nBBT file will be sorted\n");
            break;
         }
         strcpy(kennz_alt,one_bbt_rec.kennziffer);
     }
     fclose (fpbbt);

     if (sortiert_ok)
     {
         return 1;
     }
     else
     {
        if (isfile(temporaer1)) remove(temporaer1);
        if (isfile(temporaer2)) remove(temporaer2);
        sprintf(wrtxtbu,"\n(File `%s')\n",bbt_name);
        wrtxt(wrtxtbu);
        domergebbf1(bbt_name,temporaer1);
        wrtxt("\n(Removing duplicate reference numbers)\n");
        dupl_ex_bbf(temporaer1,temporaer2);
        strcpy(bbt_name,temporaer2); /* verstehe ich nicht! umbenennen!! */
        /* 
         * lieber doch lassen! Mit diesem Trick bleibt die urspruengliche BBT
         * Datei unberuehrt
         */
        return 1;
     }
  }
  else
  {
     wrtxt("\n(Export aborted: no BBT-file selected)\n");
     return 0;
  }
  return 1;
}


static int dateien_oeffnen_expo_fun(const char * code)
{
  if (filesize(journal_pix_name)==0)
  {
    wrtxt("\nProblem: main index file is empty\n");
    return 0;
  }

  if ((fpjournal=fopen(journal_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nProblem: cannot read %s\n",journal_name);
    wrtxt(wrtxtbu);
    return 0;
  }
  if ((fpdesc=fopen(desc_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nProblem: cannot read %s\n",desc_name);
    wrtxt(wrtxtbu);
    fclose(fpjournal);
    return 0;
  }

  if ((fpbuch=fopen(book_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nProblem: cannot read %s\n",book_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    return 0;
  }
  if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nProblem: cannot read %s\n",autorjl_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    return 0;
  }
  if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nProblem: cannot read %s\n",autorbu_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    return 0;
  }

  if ((fpabs=fopen(abstr_dat_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nProblem: cannot read %s\n",abstr_dat_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    return 0;
  }

  if (strcmp(code,"archive")==0)
  {
    if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
    {
      sprintf(wrtxtbu,"\nProblem: cannot read %s\n",bbt_name);
      wrtxt(wrtxtbu);
      fclose(fpdesc);
      fclose(fpjournal);
      fclose(fpbuch);
      fclose(fpautorjl);
      fclose(fpautorbu);
      fclose(fpabs);
      return 0;
    }
    if (setvbuf(fpbbt,bbt_buf,_IOFBF,BBTBUF_SIZE)!=0)
    {
      wrtxt("\nProblem: Cannot allocate memory for fpbbt\n");
      fclose(fpdesc);
      fclose(fpjournal);
      fclose(fpbuch);
      fclose(fpautorjl);
      fclose(fpautorbu);
      fclose(fpabs);
      fclose(fpbbt);
      return 0;
    }
  }

  if ((fpsource=fopen(quell_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nProblem: cannot read %s\n",quell_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpabs);
    if (strcmp(code,"archive")==0)
    {
       fclose(fpbbt);
    }
    return 0;
  }

  if ((fpstichw=fopen(stichw_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nProblem: cannot read %s\n",stichw_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpabs);
    if (strcmp(code,"archive")==0)
    {
       fclose(fpbbt);
    }
    fclose(fpsource);
    return 0;
  }

  if ((fptxt=fopen(txt_name,"w"))==NULL)
  {
    sprintf(wrtxtbu,"\nProblem: unable to open %s for writing\n",txt_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpabs);
    if (strcmp(code,"archive")==0)
    {
       fclose(fpbbt);
    }
    fclose(fpsource);
    fclose(fpstichw);
    return 0;
  }
  if (setvbuf(fptxt,txt_buf,_IOFBF,TXTBUF_SIZE)!=0)
  {
    wrtxt("\nProblem: Cannot allocate memory for fptxt\n");
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpabs);
    if (strcmp(code,"archive")==0)
    {
       fclose(fpbbt);
    }
    fclose(fpsource);
    fclose(fpstichw);
    fclose(fptxt);
    return 0;
  }
  if (!logdatei_oeffnen())
  {
    sprintf(wrtxtbu,"\nProblem: cannot write log file\n");
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpabs);
    if (strcmp(code,"archive")==0)
    {
       fclose(fpbbt);
    }
    fclose(fpsource);
    fclose(fpstichw);
    fclose(fptxt);
    return 0;
  }

  return 1;
}

static void dateien_schliessen_expo_fun(const char * code)
{
   fclose(fpjournal);
   fclose(fpdesc);
   fclose(fpbuch);
   fclose(fpautorjl);
   fclose(fpautorbu);
   fclose(fpabs);
   if (strcmp(code,"archive")==0)
   {
      fclose(fpbbt);
   }
   fclose(fpsource);
   fclose(fpstichw);
   fclose(fptxt);
   logdatei_schliessen();
}

static int machlist_expo_fun(void)
{
   long i, j, byte_zeiger, rec_zeiger, anzahl_records;
   static int taste, ok;
   char zahl[REFZAHL_LEN+1];
   int schleifeok;
   static char ein[INPUT_BU_LEN+1];

   fseek(fpbbt,0L,SEEK_END);
   byte_zeiger = ftell(fpbbt);
   anzahl_records = byte_zeiger/sizeof(one_bbt_rec);
   anzahl_records--;

   strcpy(zahl,"000000001");
   if (anzahl_records==-1)
   {
      wrtxt("Current BBT-file is empty\n");
      return 0;
   }

   erste_kennziff = 1;
    /* Die Variable sollte stets einen definierten Wert haben */

   wrtxt("\nMenu: original or new reference numbers [o/n/q]?\n");
   strcpy(ein,"menu");
   taste = menu_wahl(ein,
     "[o] the original reference numbers are assigned to all exported records\n"
     "[n] instead of the original reference numbers, new numbers are assigned\n"
     "[q] quit"
   );

   eigene_kennziff = 0;
   if (taste==3)
   {
      return 0;
   }
   if (taste==2)
   {
    schleifeok = 0;
    do
    {
      ein_zeile(zahl,"Please enter nummber for first reference "
                    "[0..100,000,000]",REFZAHL_LEN);
      string_in_long(zahl,&j,&ok);
      if ((ok) && (j >= 0) && (j<=100000000) && (strlen(zahl) > 0)) 
      {
         schleifeok=1; 
      }else
      { 
         schleifeok=0;
      }

     }
     while (!schleifeok);
     eigene_kennziff = 1;
     erste_kennziff = j;
   } /* ... if (taste==2) */

   schleifeok = 0;
   
   if (!read_ix01(journal_pix_name))
   {
      return 0;
   }
   if (!read_ix04(abstr_pix_name))
   {
      return 0;
   }
   sprintf(wrtxtbu,"Export of %li references",anzahl_records+1);
   logdatei_schreiben(wrtxtbu);
   sprintf(wrtxtbu,"\n(Exporting %li references)\n",anzahl_records+1);
   wrtxt(wrtxtbu);
   rewind(fpbbt);

   fprintf(fptxt,"****:BEGIN ARCHIVE\n");
   fprintf(fptxt,"\n****:BEGIN REFERENCES\n");
   for (i=0;i<=anzahl_records;i++)
   {
        /* */
        if ((i % 100)==0)
        {
           if (i==100) wrtxt("\n");
           if (i>0)
           {
             sprintf(wrtxtbu,"[%li] ",i);
             wrtxt(wrtxtbu);
           }
        }
        /* */
        /*  
        if (((i % 100)==0) || (i==anzahl_records))
        {
           if (i==100) wrtxt("\n");
           if (i>0)
           {
             sprintf(wrtxtbu,"%5.1f%%",100.0*i/anzahl_records);
             wrtxt(wrtxtbu);
             wrtxt("\b\b\b\b\b\b");
           }
        }
         */ 
        fread(&one_bbt_rec, sizeof(one_bbt_rec),1,fpbbt);
        strcpy(haupt_schluessel,one_bbt_rec.kennziffer);
        if (locate_ix01(haupt_schluessel,&ix01rec) > -1)
        {
           rec_zeiger = ix01rec.journal_rptr;
           byte_zeiger = rec_zeiger * sizeof(one_journal_rec);
           fseek(fpjournal,byte_zeiger,SEEK_SET);
           fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

           if (taste==1)
           {
              fprintf(fptxt,"\nRECN:%s\n",haupt_schluessel);
           }
           else
           {
              fprintf(fptxt,"\nRECN:%0*li\n",REFZAHL_LEN,j);
           }
           if (!strcmp(one_journal_rec.reftyp,"j1")) compile_j1();
           else if (!strcmp(one_journal_rec.reftyp,"j2")) compile_j2();
           else if (!strcmp(one_journal_rec.reftyp,"b1")) compile_b1();
           else if (!strcmp(one_journal_rec.reftyp,"b2")) compile_b2();
           else if (!strcmp(one_journal_rec.reftyp,"b3")) compile_b3();
           else if (!strcmp(one_journal_rec.reftyp,"m1")) compile_m1();
           else compile_m2();

           add_abstract(haupt_schluessel);
        }
        else
        {
          sprintf(wrtxtbu,"# %s: Reference not found",haupt_schluessel);
          logdatei_schreiben(wrtxtbu);
        }
        j++;
   }
   if (i > 100) wrtxt("\n\n");
   fprintf(fptxt,"\n****:END REFERENCES\n");
   wrtxt("(Writing CURRENT DATABASE completed)\n");

   close_ix01();
   close_ix04();
   if (!read_ix02(quell_pix_name))
   {
     return 0;
   }
   fprintf(fptxt,"\n****:BEGIN JOURNALS\n");

   if (fcode==1) journal_archivieren();

   fprintf(fptxt,"\n****:END JOURNALS\n");

   close_ix02();
   if (!read_ix03(stichw_pix_name))
   {
      return 0;
   }
   fprintf(fptxt,"\n****:BEGIN KEYWORDS THESAURUS\n");
   if (fcode==1) stichw_archivieren();
   fprintf(fptxt,"\n****:END KEYWORDS THESAURUS\n");
   fprintf(fptxt,"\n****:END ARCHIVE\n");
   close_ix03();
   sprintf(wrtxtbu,"Export closed");
   logdatei_schreiben(wrtxtbu);
   return 1;
}
 
static void compile_j1(void)
{
   fprintf(fptxt,"DTYP:%s\n",one_journal_rec.reftyp);
   compile_aued(fpautorjl, au_zeile,ix01rec.autorjl_rptr,";");
   fprintf(fptxt,"AUTH:%s\n",au_zeile);
   fprintf(fptxt,"TITA:%s\n",one_journal_rec.titel);
   fprintf(fptxt,"JRNL:%s\n",one_journal_rec.kuerzel);
   fprintf(fptxt,"IDNR:%s\n",one_journal_rec.idnr);
   fprintf(fptxt,"YEAR:%s\n",one_journal_rec.jahrgang);
   fprintf(fptxt,"MONP:%s\n",one_journal_rec.monat);
   fprintf(fptxt,"DAYP:%s\n",one_journal_rec.tag);
   fprintf(fptxt,"VOLM:%s\n",one_journal_rec.band);
   fprintf(fptxt,"ISNU:%s\n",one_journal_rec.issue_nummer);
   fprintf(fptxt,"PGFR:%s\n",one_journal_rec.seite_von);
   fprintf(fptxt,"PGTO:%s\n",one_journal_rec.seite_bis);
   fprintf(fptxt,"STAT:%s\n",one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,", ");
   fprintf(fptxt,"KEYW:%s\n",desc_zeile);
}
 
static void compile_j2(void)
{
   fprintf(fptxt,"DTYP:%s\n",one_journal_rec.reftyp);
   fprintf(fptxt,"INAU:%s\n",one_journal_rec.instau);
   fprintf(fptxt,"TITA:%s\n",one_journal_rec.titel);
   fprintf(fptxt,"JRNL:%s\n",one_journal_rec.kuerzel);
   fprintf(fptxt,"IDNR:%s\n",one_journal_rec.idnr);
   fprintf(fptxt,"YEAR:%s\n",one_journal_rec.jahrgang);
   fprintf(fptxt,"MONP:%s\n",one_journal_rec.monat);
   fprintf(fptxt,"DAYP:%s\n",one_journal_rec.tag);
   fprintf(fptxt,"VOLM:%s\n",one_journal_rec.band);
   fprintf(fptxt,"ISNU:%s\n",one_journal_rec.issue_nummer);
   fprintf(fptxt,"PGFR:%s\n",one_journal_rec.seite_von);
   fprintf(fptxt,"PGTO:%s\n",one_journal_rec.seite_bis);
   fprintf(fptxt,"STAT:%s\n",one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,", ");
   fprintf(fptxt,"KEYW:%s\n",desc_zeile);
}
 
 
static void compile_b1(void)
{
   long byte_zeiger;

   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

   fprintf(fptxt,"DTYP:%s\n",one_journal_rec.reftyp);
   compile_aued(fpautorbu, ed_zeile,ix01rec.autorbu_rptr,";");
   fprintf(fptxt,"EDIT:%s\n",ed_zeile);
   fprintf(fptxt,"TITB:%s\n",one_buch_rec.titel_bu);
   fprintf(fptxt,"EDTN:%s\n",one_journal_rec.band);
   fprintf(fptxt,"ISBN:%s\n",one_buch_rec.isbn);
   fprintf(fptxt,"PLAC:%s\n",one_buch_rec.publ_ort);
   fprintf(fptxt,"IDNR:%s\n",one_journal_rec.idnr);
   fprintf(fptxt,"YEAR:%s\n",one_journal_rec.jahrgang);
   fprintf(fptxt,"PUBL:%s\n",one_buch_rec.verlag);
   fprintf(fptxt,"PGFR:%s\n",one_journal_rec.seite_von);
   fprintf(fptxt,"PGTO:%s\n",one_journal_rec.seite_bis);
   fprintf(fptxt,"STAT:%s\n",one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,", ");
   fprintf(fptxt,"KEYW:%s\n",desc_zeile);
}
 
 
 
static void compile_b2(void)
{
   long byte_zeiger;

   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

   fprintf(fptxt,"DTYP:%s\n",one_journal_rec.reftyp);
   compile_aued(fpautorjl, au_zeile,ix01rec.autorjl_rptr,";");
   fprintf(fptxt,"AUTH:%s\n",au_zeile);
   fprintf(fptxt,"TITA:%s\n",one_journal_rec.titel);
   compile_aued(fpautorbu, ed_zeile,ix01rec.autorbu_rptr,";");
   fprintf(fptxt,"EDIT:%s\n",ed_zeile);
   fprintf(fptxt,"TITB:%s\n",one_buch_rec.titel_bu);
   fprintf(fptxt,"EDTN:%s\n",one_journal_rec.band);
   fprintf(fptxt,"ISBN:%s\n",one_buch_rec.isbn);
   fprintf(fptxt,"PLAC:%s\n",one_buch_rec.publ_ort);
   fprintf(fptxt,"IDNR:%s\n",one_journal_rec.idnr);
   fprintf(fptxt,"YEAR:%s\n",one_journal_rec.jahrgang);
   fprintf(fptxt,"PUBL:%s\n",one_buch_rec.verlag);
   fprintf(fptxt,"PGFR:%s\n",one_journal_rec.seite_von);
   fprintf(fptxt,"PGTO:%s\n",one_journal_rec.seite_bis);
   fprintf(fptxt,"STAT:%s\n",one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,", ");
   fprintf(fptxt,"KEYW:%s\n",desc_zeile);
}


static void compile_b3(void)
{
   long byte_zeiger;

   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

   fprintf(fptxt,"DTYP:%s\n",one_journal_rec.reftyp);
   fprintf(fptxt,"INED:%s\n",one_buch_rec.insted);
   fprintf(fptxt,"TITB:%s\n",one_buch_rec.titel_bu);
   fprintf(fptxt,"EDTN:%s\n",one_journal_rec.band);
   fprintf(fptxt,"ISBN:%s\n",one_buch_rec.isbn);
   fprintf(fptxt,"PLAC:%s\n",one_buch_rec.publ_ort);
   fprintf(fptxt,"IDNR:%s\n",one_journal_rec.idnr);
   fprintf(fptxt,"YEAR:%s\n",one_journal_rec.jahrgang);
   fprintf(fptxt,"PUBL:%s\n",one_buch_rec.verlag);
   fprintf(fptxt,"PGFR:%s\n",one_journal_rec.seite_von);
   fprintf(fptxt,"PGTO:%s\n",one_journal_rec.seite_bis);
   fprintf(fptxt,"STAT:%s\n",one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,", ");
   fprintf(fptxt,"KEYW:%s\n",desc_zeile);
}
 
static void compile_m1(void)
{
   fprintf(fptxt,"DTYP:%s\n",one_journal_rec.reftyp);
   compile_aued(fpautorjl, au_zeile,ix01rec.autorjl_rptr,";");
   fprintf(fptxt,"AUTH:%s\n",au_zeile);
   fprintf(fptxt,"TITA:%s\n",one_journal_rec.titel);
   fprintf(fptxt,"HOWP:%s\n",one_journal_rec.howpublished);
   fprintf(fptxt,"IDNR:%s\n",one_journal_rec.idnr);
   fprintf(fptxt,"YEAR:%s\n",one_journal_rec.jahrgang);
   fprintf(fptxt,"MONP:%s\n",one_journal_rec.monat);
   fprintf(fptxt,"DAYP:%s\n",one_journal_rec.tag);
   fprintf(fptxt,"PGFR:%s\n",one_journal_rec.seite_von);
   fprintf(fptxt,"PGTO:%s\n",one_journal_rec.seite_bis);
   fprintf(fptxt,"STAT:%s\n",one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,", ");
   fprintf(fptxt,"KEYW:%s\n",desc_zeile);
}


static void compile_m2(void)
{
   fprintf(fptxt,"DTYP:%s\n",one_journal_rec.reftyp);
   fprintf(fptxt,"INAU:%s\n",one_journal_rec.instau);
   fprintf(fptxt,"TITA:%s\n",one_journal_rec.titel);
   fprintf(fptxt,"HOWP:%s\n",one_journal_rec.howpublished);
   fprintf(fptxt,"IDNR:%s\n",one_journal_rec.idnr);
   fprintf(fptxt,"YEAR:%s\n",one_journal_rec.jahrgang);
   fprintf(fptxt,"MONP:%s\n",one_journal_rec.monat);
   fprintf(fptxt,"DAYP:%s\n",one_journal_rec.tag);
   fprintf(fptxt,"PGFR:%s\n",one_journal_rec.seite_von);
   fprintf(fptxt,"PGTO:%s\n",one_journal_rec.seite_bis);
   fprintf(fptxt,"STAT:%s\n",one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,", ");
   fprintf(fptxt,"KEYW:%s\n",desc_zeile);
}
 


static void compile_aued(FILE * fpaued, char * auedstring, long zeiger, char * separator)
{
   int anzahl_n, i;
   long byte_zeiger;
   strcpy(auedstring,"");
   byte_zeiger = zeiger * sizeof(one_aued_rec);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   anzahl_n = one_aued_rec.au_n;
   for (i=1;i<=anzahl_n;i++)
   {
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);
        strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
        strlimcat(auedstring,",",AUTORZEILE_LEN);
        strlimcat(auedstring,one_aued_rec.au_vornamen,AUTORZEILE_LEN);
        if  (i<anzahl_n) strlimcat(auedstring,separator,AUTORZEILE_LEN);
   }
}


static void compile_desc(char * desc_zeile, long zeiger, char * separator)
{
   int n_desc, i;
   long byte_zeiger;
   strcpy(desc_zeile,"");

   byte_zeiger = zeiger * sizeof(one_desc_rec);
   fseek(fpdesc,byte_zeiger,SEEK_SET);
   fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
   fseek(fpdesc,byte_zeiger,SEEK_SET);
   n_desc = one_desc_rec.desc_n;
   for (i=1;i<=n_desc;i++)
   {
        fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
        strlimcat(desc_zeile,one_desc_rec.keywordsfield,DESC_ZEILE_LEN);
        if (i< n_desc)
        {
          strlimcat(desc_zeile,separator,DESC_ZEILE_LEN);
        }
   }
   return;
}
 
static void journal_archivieren(void)
{
  long i, anzahl_records, byte_zeiger;
  wrtxt("(Writing JOURNAL names into archive)\n");
  fseek(ix02file,0L,SEEK_END);
  byte_zeiger = ftell(ix02file);
  anzahl_records = byte_zeiger / sizeof(ix02rec);
  anzahl_records--;
  rewind(ix02file);
  for (i=0;i<=anzahl_records;i++)
  {
      fread(&ix02rec,sizeof(ix02rec),1,ix02file);
      byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
      fseek(fpsource,byte_zeiger,SEEK_SET);
      fread(&one_quell_rec,sizeof(one_quell_rec),1,fpsource);

      fprintf(fptxt,"\nJCOD:%s\n",one_quell_rec.quell_kuerzel);
      fprintf(fptxt,"ISSN:%s\n",one_quell_rec.quell_issn);
      fprintf(fptxt,"JNAM:%s\n",one_quell_rec.quell_zeitschrift);
      fprintf(fptxt,"JS01:%s\n",one_quell_rec.quell_kurzform);

  }
}



static void stichw_archivieren(void)
{
  long i, anzahl_records, byte_zeiger;
  wrtxt("(Writing KEYWORD table into archive)\n");
  fseek(ix03file,0L,SEEK_END);
  byte_zeiger = ftell(ix03file);
  anzahl_records = byte_zeiger / sizeof(ix03rec);
  anzahl_records--;
  rewind(ix03file);
  for (i=0;i<=anzahl_records;i++)
  {
      fread(&ix03rec,sizeof(ix03rec),1,ix03file);
      byte_zeiger = ix03rec.keywords_rptr * sizeof(one_stichw_rec);
      fseek(fpstichw,byte_zeiger,SEEK_SET);
      fread(&one_stichw_rec,sizeof(one_stichw_rec),1,fpstichw);

      fprintf(fptxt,"\nKEYT:%s\n",one_stichw_rec.keywordsfield);
  }
}


static int add_abstract(char * kennziffer)
{
   long rec_zeiger, byte_zeiger, j, anzahl_bloecke;

   fprintf(fptxt,"ABST:");
   strcpy(abs_zeile,"");
   if (locate_ix04(one_bbt_rec.kennziffer,&ix04rec)!=-1)
   {
       rec_zeiger = ix04rec.abstr_rptr;
       byte_zeiger = rec_zeiger * sizeof(one_abstr_rec);
       fseek(fpabs,byte_zeiger,SEEK_SET);
       fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
       fseek(fpabs,byte_zeiger,SEEK_SET);
       anzahl_bloecke = one_abstr_rec.abstr_n;
       for (j=1;j<=anzahl_bloecke;j++)
       {
           fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
           strlimcat(abs_zeile,one_abstr_rec.abs_text,ABS_ZEILE_LEN);
       }
       fprintf(fptxt,"%s",abs_zeile);
   }
   fprintf(fptxt,"\n");
   return 1;
}
 
#undef REFZAHL_LEN


static int expo_fun_speicher_allokieren(void)
{
   if ((au_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      return 0;
   }
   if ((ed_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      return 0;
   }
   if ((ex_au_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      return 0;
   }
   if ((abs_zeile =  (char *) malloc((ABS_ZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      return 0;
   }
   if ((desc_zeile =  (char *) malloc((DESC_ZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      return 0;
   }
   return 1;
}
static int expo_fun_speicher_freigeben(void)
{
   free(au_zeile);
   free(ed_zeile);
   free(ex_au_zeile);
   free(abs_zeile);
   free(desc_zeile);
   return 1;
}

static int machlist_expo_fun_formular(char * kz)
{
   long byte_zeiger, rec_zeiger;
   int ret_wert;

   ret_wert=0;

   if (strlen(kz)==0)
   {
     return ret_wert;
   }
   if (!read_ix01(journal_pix_name))
   {
      return ret_wert;
   }
   if (!read_ix04(abstr_pix_name))
   {
      return ret_wert;
   }
   sprintf(wrtxtbu,"Writing reference no `%s' into form", kz);
   logdatei_schreiben(wrtxtbu);
   
   if (locate_ix01(kz,&ix01rec) > -1)
   {
      rec_zeiger = ix01rec.journal_rptr;
      byte_zeiger = rec_zeiger * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

      if (!strcmp(one_journal_rec.reftyp,"j1")) compile_j1_formular(kz);
      else if (!strcmp(one_journal_rec.reftyp,"j2")) compile_j2_formular(kz);
      else if (!strcmp(one_journal_rec.reftyp,"b1")) compile_b1_formular(kz);
      else if (!strcmp(one_journal_rec.reftyp,"b2")) compile_b2_formular(kz);
      else if (!strcmp(one_journal_rec.reftyp,"b3")) compile_b3_formular(kz);
      else if (!strcmp(one_journal_rec.reftyp,"m1")) compile_m1_formular(kz);
      else compile_m2_formular(kz);

      add_abstract_formular(kz);
      ret_wert=1;
   }
   else
   {
     sprintf(wrtxtbu,"\n(Reference # %s not found)\n",haupt_schluessel);
     wrtxt(wrtxtbu);
     logdatei_schreiben(wrtxtbu);
   }
   
   if (ret_wert==1)
   {
    sprintf(wrtxtbu,"Form `%s' written",kz);
    logdatei_schreiben(wrtxtbu);
   }
   close_ix01();
   close_ix04();

   return ret_wert;
}

static void compile_j1_formular(char * kz)
{
   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","j1");
   fprintf(fptxt,"%sAUTHORS-[width:%i,%i]\n",
     one_config_set.form_label, AUNAME_LEN,AUVORNAMEN_LEN);
   compile_aued(fpautorjl, au_zeile,ix01rec.autorjl_rptr,"\n");
   fprintf(fptxt,"%s\n",au_zeile);
   wwrap(one_journal_rec.titel,EDITING_LINE_LEN);
   fprintf(fptxt,"%sTITLE-ARTICLE-[width:%iw]\n%s\n",
     one_config_set.form_label,TITEL_LEN,one_journal_rec.titel);
   fprintf(fptxt,"%sJOURNAL-[width:%i]\n%s\n",
       one_config_set.form_label,KUERZEL_LEN,one_journal_rec.kuerzel);
   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,one_journal_rec.idnr);
   fprintf(fptxt,"%sDATE-YEAR-[width:%i;num]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,one_journal_rec.jahrgang);
   fprintf(fptxt,"%sDATE-MONTH-[width:%i;num:1..12]\n%s\n",
       one_config_set.form_label,MONAT_LEN,one_journal_rec.monat);
   fprintf(fptxt,"%sDATE-DAY-[width:%i;num:1..31]\n%s\n",
       one_config_set.form_label,TAG_LEN,one_journal_rec.tag);
   fprintf(fptxt,"%sVOLUME-[width:%i]\n%s\n",
       one_config_set.form_label,BAND_LEN,one_journal_rec.band);
   fprintf(fptxt,"%sISSUE-NUMBER-[width:%i]\n%s\n",
       one_config_set.form_label,ISSUE_NUMMER_LEN,one_journal_rec.issue_nummer);
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,one_journal_rec.seite_von);
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,one_journal_rec.seite_bis);
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,"\n");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,desc_zeile);
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
}

static void compile_j2_formular(char * kz)
{
   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","j2");
   wwrap(one_journal_rec.instau,EDITING_LINE_LEN);
   fprintf(fptxt,"%sINSTITUTIONAL-AUTHOR-[width:%iw]\n%s\n",
     one_config_set.form_label,INSTAU_LEN,one_journal_rec.instau);
   wwrap(one_journal_rec.titel,EDITING_LINE_LEN);
   fprintf(fptxt,"%sTITLE-ARTICLE-[width:%iw]\n%s\n",
     one_config_set.form_label,TITEL_LEN,one_journal_rec.titel);
   fprintf(fptxt,"%sJOURNAL-[width:%i]\n%s\n",
       one_config_set.form_label,KUERZEL_LEN,one_journal_rec.kuerzel);
   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,one_journal_rec.idnr);
   fprintf(fptxt,"%sDATE-YEAR-[width:%i;num]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,one_journal_rec.jahrgang);
   fprintf(fptxt,"%sDATE-MONTH-[width:%i;num:1..12]\n%s\n",
       one_config_set.form_label,MONAT_LEN,one_journal_rec.monat);
   fprintf(fptxt,"%sDATE-DAY-[width:%i;num:1..31]\n%s\n",
       one_config_set.form_label,TAG_LEN,one_journal_rec.tag);
   fprintf(fptxt,"%sVOLUME-[width:%i]\n%s\n",
       one_config_set.form_label,BAND_LEN,one_journal_rec.band);
   fprintf(fptxt,"%sISSUE-NUMBER-[width:%i]\n%s\n",
       one_config_set.form_label,ISSUE_NUMMER_LEN,one_journal_rec.issue_nummer);
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,one_journal_rec.seite_von);
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,one_journal_rec.seite_bis);
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,"\n");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,desc_zeile);
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
}


static void compile_b1_formular(char * kz)
{
   long byte_zeiger;

   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
   
   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",
     one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",
     one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","b1");
   compile_aued(fpautorbu, ed_zeile,ix01rec.autorbu_rptr,"\n");
   fprintf(fptxt,"%sEDITORS-[width:%i,%i]\n",
       one_config_set.form_label,AUNAME_LEN,AUVORNAMEN_LEN);
   fprintf(fptxt,"%s\n",ed_zeile);
   wwrap(one_buch_rec.titel_bu,EDITING_LINE_LEN);
   fprintf(fptxt,"%sTITLE-BOOK-[width:%iw]\n%s\n",
       one_config_set.form_label,TITELBUCH_LEN,one_buch_rec.titel_bu);
   fprintf(fptxt,"%sEDITION-NUMBER-[width:%i]\n%s\n",
       one_config_set.form_label,BAND_LEN,one_journal_rec.band);
   fprintf(fptxt,"%sISBN-[width:%i]\n%s\n",
       one_config_set.form_label,ISBN_LEN,one_buch_rec.isbn);
   wwrap(one_buch_rec.publ_ort,EDITING_LINE_LEN);
   fprintf(fptxt,"%sPLACE-OF-PUBLICATION-[width:%iw]\n%s\n",
       one_config_set.form_label,PUBLORT_LEN,one_buch_rec.publ_ort);
   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,one_journal_rec.idnr);
   fprintf(fptxt,"%sDATE-YEAR-[width:%i]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,one_journal_rec.jahrgang);
   wwrap(one_buch_rec.verlag,EDITING_LINE_LEN);
   fprintf(fptxt,"%sPUBLISHER-[width:%iw]\n%s\n",
       one_config_set.form_label,VERLAG_LEN,one_buch_rec.verlag);
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,one_journal_rec.seite_von);
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,one_journal_rec.seite_bis);
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,"\n");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,desc_zeile);
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
}

static void compile_b2_formular(char * kz)
{
   long byte_zeiger;

   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",
     one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",
     one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","b2");
   fprintf(fptxt,"%sAUTHORS-[width:%i,%i]\n",
       one_config_set.form_label,AUNAME_LEN,AUVORNAMEN_LEN);
   compile_aued(fpautorjl, au_zeile,ix01rec.autorjl_rptr,"\n");
   fprintf(fptxt,"%s\n",au_zeile);

   wwrap(one_journal_rec.titel,EDITING_LINE_LEN);
   fprintf(fptxt,"%sTITLE-ARTICLE-[width:%iw]\n%s\n",
     one_config_set.form_label,TITEL_LEN,one_journal_rec.titel);
   compile_aued(fpautorbu, ed_zeile,ix01rec.autorbu_rptr,"\n");
   fprintf(fptxt,"%sEDITORS-[width:%i,%i]\n",
       one_config_set.form_label,AUNAME_LEN,AUVORNAMEN_LEN);
   fprintf(fptxt,"%s\n",ed_zeile);
   wwrap(one_buch_rec.titel_bu,EDITING_LINE_LEN);
   fprintf(fptxt,"%sTITLE-BOOK-[width:%iw]\n%s\n",
       one_config_set.form_label,TITELBUCH_LEN,one_buch_rec.titel_bu);
   fprintf(fptxt,"%sEDITION-NUMBER-[width:%i]\n%s\n",
       one_config_set.form_label,BAND_LEN,one_journal_rec.band);
   fprintf(fptxt,"%sISBN-[width:%i]\n%s\n",
       one_config_set.form_label,ISBN_LEN,one_buch_rec.isbn);
   wwrap(one_buch_rec.publ_ort,EDITING_LINE_LEN);
   fprintf(fptxt,"%sPLACE-OF-PUBLICATION-[width:%iw]\n%s\n",
       one_config_set.form_label,PUBLORT_LEN,one_buch_rec.publ_ort);
   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,one_journal_rec.idnr);
   fprintf(fptxt,"%sDATE-YEAR-[width:%i]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,one_journal_rec.jahrgang);
   wwrap(one_buch_rec.verlag,EDITING_LINE_LEN);
   fprintf(fptxt,"%sPUBLISHER-[width:%iw]\n%s\n",
       one_config_set.form_label,VERLAG_LEN,one_buch_rec.verlag);
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,one_journal_rec.seite_von);
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,one_journal_rec.seite_bis);
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,"\n");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,desc_zeile);
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
}

static void compile_b3_formular(char * kz)
{
   long byte_zeiger;

   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
   
   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",
     one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",
     one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","b3");
   wwrap(one_buch_rec.insted,EDITING_LINE_LEN);
   fprintf(fptxt,"%sINSTITUTIONAL-EDITOR-[width:%iw]\n%s\n",
     one_config_set.form_label,INSTED_LEN,one_buch_rec.insted);
   wwrap(one_buch_rec.titel_bu,EDITING_LINE_LEN);
   fprintf(fptxt,"%sTITLE-BOOK-[width:%iw]\n%s\n",
       one_config_set.form_label,TITELBUCH_LEN,one_buch_rec.titel_bu);
   fprintf(fptxt,"%sEDITION-NUMBER-[width:%i]\n%s\n",
       one_config_set.form_label,BAND_LEN,one_journal_rec.band);
   fprintf(fptxt,"%sISBN-[width:%i]\n%s\n",
       one_config_set.form_label,ISBN_LEN,one_buch_rec.isbn);
   wwrap(one_buch_rec.publ_ort,EDITING_LINE_LEN);
   fprintf(fptxt,"%sPLACE-OF-PUBLICATION-[width:%iw]\n%s\n",
       one_config_set.form_label,PUBLORT_LEN,one_buch_rec.publ_ort);
   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,one_journal_rec.idnr);
   fprintf(fptxt,"%sDATE-YEAR-[width:%i]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,one_journal_rec.jahrgang);
   wwrap(one_buch_rec.verlag,EDITING_LINE_LEN);
   fprintf(fptxt,"%sPUBLISHER-[width:%iw]\n%s\n",
       one_config_set.form_label,VERLAG_LEN,one_buch_rec.verlag);
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,one_journal_rec.seite_von);
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,one_journal_rec.seite_bis);
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,"\n");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,desc_zeile);
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
}



static void compile_m1_formular(char * kz)
{
   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","m1");
   fprintf(fptxt,"%sAUTHORS-[width:%i,%i]\n",
     one_config_set.form_label, AUNAME_LEN,AUVORNAMEN_LEN);
   compile_aued(fpautorjl, au_zeile,ix01rec.autorjl_rptr,"\n");
   fprintf(fptxt,"%s\n",au_zeile);
   wwrap(one_journal_rec.titel,EDITING_LINE_LEN);
   fprintf(fptxt,"%sTITLE-ARTICLE-[width:%iw]\n%s\n",
     one_config_set.form_label,TITEL_LEN,one_journal_rec.titel);

   fprintf(fptxt,"%sHOWPUBLISHED-[width:%i]\n%s\n",
     one_config_set.form_label,HOWPUBLISHED_LEN,one_journal_rec.howpublished);

   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,one_journal_rec.idnr);
   fprintf(fptxt,"%sDATE-YEAR-[width:%i;num]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,one_journal_rec.jahrgang);
   fprintf(fptxt,"%sDATE-MONTH-[width:%i;num:1..12]\n%s\n",
       one_config_set.form_label,MONAT_LEN,one_journal_rec.monat);
   fprintf(fptxt,"%sDATE-DAY-[width:%i;num:1..31]\n%s\n",
       one_config_set.form_label,TAG_LEN,one_journal_rec.tag);
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,one_journal_rec.seite_von);
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,one_journal_rec.seite_bis);
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,"\n");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,desc_zeile);
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
}

static void compile_m2_formular(char * kz)
{
   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","m2");
   wwrap(one_journal_rec.instau,EDITING_LINE_LEN);
   fprintf(fptxt,"%sINSTITUTIONAL-AUTHOR-[width:%iw]\n%s\n",
     one_config_set.form_label,INSTAU_LEN,one_journal_rec.instau);
   wwrap(one_journal_rec.titel,EDITING_LINE_LEN);
   fprintf(fptxt,"%sTITLE-ARTICLE-[width:%iw]\n%s\n",
     one_config_set.form_label,TITEL_LEN,one_journal_rec.titel);
   fprintf(fptxt,"%sHOWPUBLISHED-[width:%i]\n%s\n",
     one_config_set.form_label,HOWPUBLISHED_LEN,one_journal_rec.howpublished);
   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,one_journal_rec.idnr);
   fprintf(fptxt,"%sDATE-YEAR-[width:%i;num]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,one_journal_rec.jahrgang);
   fprintf(fptxt,"%sDATE-MONTH-[width:%i;num:1..12]\n%s\n",
       one_config_set.form_label,MONAT_LEN,one_journal_rec.monat);
   fprintf(fptxt,"%sDATE-DAY-[width:%i;num:1..31]\n%s\n",
       one_config_set.form_label,TAG_LEN,one_journal_rec.tag);
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,one_journal_rec.seite_von);
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,one_journal_rec.seite_bis);
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr,"\n");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,desc_zeile);
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
}


static int add_abstract_formular(char * kennziffer)
{
   long rec_zeiger, byte_zeiger, j, anzahl_bloecke, i, laenge;

   fprintf(fptxt,"%sABSTRACT-[width:%iw]\n",
       one_config_set.form_label,ABSTRACT_ZEILE_LEN);
   strcpy(abs_zeile,"");
   if (locate_ix04(kennziffer,&ix04rec)!=-1)
   {
       rec_zeiger = ix04rec.abstr_rptr;
       byte_zeiger = rec_zeiger * sizeof(one_abstr_rec);
       fseek(fpabs,byte_zeiger,SEEK_SET);
       fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
       fseek(fpabs,byte_zeiger,SEEK_SET);
       anzahl_bloecke = one_abstr_rec.abstr_n;
       for (j=1;j<=anzahl_bloecke;j++)
       {
           fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
           strlimcat(abs_zeile,one_abstr_rec.abs_text,ABS_ZEILE_LEN);
       }

       laenge = strlen(abs_zeile);
       for (i=0;i<laenge;i++)
       {
         if (abs_zeile[i]=='\xfe')
         {
            abs_zeile[i]='\n';
         }
       }
       /* begin new 27. Mai 2002 */
       rtrim(abs_zeile,'\n');
       /* end new 27. Mai 2002 */
       fprintf(fptxt,"%s",abs_zeile);
   }
   fprintf(fptxt,"\n%sEND-OF-RECORD\n",one_config_set.form_label);
   return 1;
}


static void compile_j1_leer_formular(char * kz_proposed)
{
   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz_proposed);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","j1");
   fprintf(fptxt,"%sAUTHORS-[width:%i,%i]\n",
     one_config_set.form_label, AUNAME_LEN,AUVORNAMEN_LEN);
   fprintf(fptxt,"\n");
   fprintf(fptxt,"%sTITLE-ARTICLE-[width:%iw]\n%s\n",
     one_config_set.form_label,TITEL_LEN,"");
   fprintf(fptxt,"%sJOURNAL-[width:%i]\n%s\n",
       one_config_set.form_label,KUERZEL_LEN,"");
   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,"");
   fprintf(fptxt,"%sDATE-YEAR-[width:%i;num]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,"");
   fprintf(fptxt,"%sDATE-MONTH-[width:%i;num:1..12]\n%s\n",
       one_config_set.form_label,MONAT_LEN,"");
   fprintf(fptxt,"%sDATE-DAY-[width:%i;num:1..31]\n%s\n",
       one_config_set.form_label,TAG_LEN,"");
   fprintf(fptxt,"%sVOLUME-[width:%i]\n%s\n",
       one_config_set.form_label,BAND_LEN,"");
   fprintf(fptxt,"%sISSUE-NUMBER-[width:%i]\n%s\n",
       one_config_set.form_label,ISSUE_NUMMER_LEN,"");
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,"");
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,"");
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,"");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,"");
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
   fprintf(fptxt,"%sABSTRACT-[width:%iw]\n",
       one_config_set.form_label,ABSTRACT_ZEILE_LEN);
   fprintf(fptxt,"\n%sEND-OF-RECORD\n",one_config_set.form_label);
   return;
}

static void compile_j2_leer_formular(char * kz_proposed)
{
   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz_proposed);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","j2");
   fprintf(fptxt,"%sINSTITUTIONAL-AUTHOR-[width:%iw]\n",
     one_config_set.form_label,INSTAU_LEN);
   fprintf(fptxt,"\n");
   fprintf(fptxt,"%sTITLE-ARTICLE-[width:%iw]\n%s\n",
     one_config_set.form_label,TITEL_LEN,"");
   fprintf(fptxt,"%sJOURNAL-[width:%i]\n%s\n",
       one_config_set.form_label,KUERZEL_LEN,"");
   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,"");
   fprintf(fptxt,"%sDATE-YEAR-[width:%i;num]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,"");
   fprintf(fptxt,"%sDATE-MONTH-[width:%i;num:1..12]\n%s\n",
       one_config_set.form_label,MONAT_LEN,"");
   fprintf(fptxt,"%sDATE-DAY-[width:%i;num:1..31]\n%s\n",
       one_config_set.form_label,TAG_LEN,"");
   fprintf(fptxt,"%sVOLUME-[width:%i]\n%s\n",
       one_config_set.form_label,BAND_LEN,"");
   fprintf(fptxt,"%sISSUE-NUMBER-[width:%i]\n%s\n",
       one_config_set.form_label,ISSUE_NUMMER_LEN,"");
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,"");
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,"");
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,"");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,"");
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
   fprintf(fptxt,"%sABSTRACT-[width:%iw]\n",
       one_config_set.form_label,ABSTRACT_ZEILE_LEN);
   fprintf(fptxt,"\n%sEND-OF-RECORD\n",one_config_set.form_label);
   return;
}


static void compile_b1_leer_formular(char * kz_proposed)
{
   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",
     one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz_proposed);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",
     one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","b1");
   fprintf(fptxt,"%sEDITORS-[width:%i,%i]\n",
       one_config_set.form_label,AUNAME_LEN,AUVORNAMEN_LEN);
   fprintf(fptxt,"\n");
   fprintf(fptxt,"%sTITLE-BOOK-[width:%iw]\n%s\n",
       one_config_set.form_label,TITELBUCH_LEN,"");
   fprintf(fptxt,"%sEDITION-NUMBER-[width:%i]\n%s\n",
       one_config_set.form_label,BAND_LEN,"");
   fprintf(fptxt,"%sISBN-[width:%i]\n%s\n",
       one_config_set.form_label,ISBN_LEN,"");
   fprintf(fptxt,"%sPLACE-OF-PUBLICATION-[width:%iw]\n%s\n",
       one_config_set.form_label,PUBLORT_LEN,"");
   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,"");
   fprintf(fptxt,"%sDATE-YEAR-[width:%i]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,"");
   fprintf(fptxt,"%sPUBLISHER-[width:%iw]\n%s\n",
       one_config_set.form_label,VERLAG_LEN,"");
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,"");
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,"");
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,"");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,"");
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
   fprintf(fptxt,"%sABSTRACT-[width:%iw]\n",
       one_config_set.form_label,ABSTRACT_ZEILE_LEN);
   fprintf(fptxt,"\n%sEND-OF-RECORD\n",one_config_set.form_label);
   return;
}

static void compile_b2_leer_formular(char * kz_proposed)
{
   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",
     one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz_proposed);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",
     one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","b2");
   fprintf(fptxt,"%sAUTHORS-[width:%i,%i]\n",
       one_config_set.form_label,AUNAME_LEN,AUVORNAMEN_LEN);
   fprintf(fptxt,"\n");
   fprintf(fptxt,"%sTITLE-ARTICLE-[width:%iw]\n%s\n",
     one_config_set.form_label,TITEL_LEN,"");
   fprintf(fptxt,"%sEDITORS-[width:%i,%i]\n",
       one_config_set.form_label,AUNAME_LEN,AUVORNAMEN_LEN);
   fprintf(fptxt,"\n");
   fprintf(fptxt,"%sTITLE-BOOK-[width:%iw]\n%s\n",
       one_config_set.form_label,TITELBUCH_LEN,"");
   fprintf(fptxt,"%sEDITION-NUMBER-[width:%i]\n%s\n",
       one_config_set.form_label,BAND_LEN,"");
   fprintf(fptxt,"%sISBN-[width:%i]\n%s\n",
       one_config_set.form_label,ISBN_LEN,"");
   fprintf(fptxt,"%sPLACE-OF-PUBLICATION-[width:%iw]\n%s\n",
       one_config_set.form_label,PUBLORT_LEN,"");
   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,"");
   fprintf(fptxt,"%sDATE-YEAR-[width:%i]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,"");
   fprintf(fptxt,"%sPUBLISHER-[width:%iw]\n%s\n",
       one_config_set.form_label,VERLAG_LEN,"");
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,"");
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,"");
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,"");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,"");
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
   fprintf(fptxt,"%sABSTRACT-[width:%iw]\n",
       one_config_set.form_label,ABSTRACT_ZEILE_LEN);
   fprintf(fptxt,"\n%sEND-OF-RECORD\n",one_config_set.form_label);
   return;
}


static void compile_b3_leer_formular(char * kz_proposed)
{
   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",
     one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz_proposed);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",
     one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","b3");
   fprintf(fptxt,"%sINSTITUTIONAL-EDITOR-[width:%iw]\n",
       one_config_set.form_label,INSTED_LEN);
   fprintf(fptxt,"\n");
   fprintf(fptxt,"%sTITLE-BOOK-[width:%iw]\n%s\n",
       one_config_set.form_label,TITELBUCH_LEN,"");
   fprintf(fptxt,"%sEDITION-NUMBER-[width:%i]\n%s\n",
       one_config_set.form_label,BAND_LEN,"");
   fprintf(fptxt,"%sISBN-[width:%i]\n%s\n",
       one_config_set.form_label,ISBN_LEN,"");
   fprintf(fptxt,"%sPLACE-OF-PUBLICATION-[width:%iw]\n%s\n",
       one_config_set.form_label,PUBLORT_LEN,"");
   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,"");
   fprintf(fptxt,"%sDATE-YEAR-[width:%i]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,"");
   fprintf(fptxt,"%sPUBLISHER-[width:%iw]\n%s\n",
       one_config_set.form_label,VERLAG_LEN,"");
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,"");
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,"");
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,"");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,"");
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
   fprintf(fptxt,"%sABSTRACT-[width:%iw]\n",
       one_config_set.form_label,ABSTRACT_ZEILE_LEN);
   fprintf(fptxt,"\n%sEND-OF-RECORD\n",one_config_set.form_label);
   return;
}

static void compile_m1_leer_formular(char * kz_proposed)
{
   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz_proposed);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","m1");
   fprintf(fptxt,"%sAUTHORS-[width:%i,%i]\n",
     one_config_set.form_label, AUNAME_LEN,AUVORNAMEN_LEN);
   fprintf(fptxt,"\n");
   fprintf(fptxt,"%sTITLE-ARTICLE-[width:%iw]\n%s\n",
     one_config_set.form_label,TITEL_LEN,"");
   fprintf(fptxt,"%sHOWPUBLISHED-[width:%i]\n%s\n",
     one_config_set.form_label,HOWPUBLISHED_LEN,"");
   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,"");
   fprintf(fptxt,"%sDATE-YEAR-[width:%i;num]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,"");
   fprintf(fptxt,"%sDATE-MONTH-[width:%i;num:1..12]\n%s\n",
       one_config_set.form_label,MONAT_LEN,"");
   fprintf(fptxt,"%sDATE-DAY-[width:%i;num:1..31]\n%s\n",
       one_config_set.form_label,TAG_LEN,"");
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,"");
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,"");
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,"");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,"");
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
   fprintf(fptxt,"%sABSTRACT-[width:%iw]\n",
       one_config_set.form_label,ABSTRACT_ZEILE_LEN);
   fprintf(fptxt,"\n%sEND-OF-RECORD\n",one_config_set.form_label);
   return;
}


static void compile_m2_leer_formular(char * kz_proposed)
{
   fprintf(fptxt,"%sREFERENCE-NUMBER-[width:%i]\n",one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fptxt,"%s\n",kz_proposed);
   fprintf(fptxt,"%sDOCUMENT-TYPE-[width:%i]\n",one_config_set.form_label,REFTYP_LEN);
   fprintf(fptxt,"%s\n","m2");
   fprintf(fptxt,"%sINSTITUTIONAL-AUTHOR-[width:%iw]\n",
     one_config_set.form_label,INSTAU_LEN);
   fprintf(fptxt,"\n");
   fprintf(fptxt,"%sTITLE-ARTICLE-[width:%iw]\n%s\n",
     one_config_set.form_label,TITEL_LEN,"");
   fprintf(fptxt,"%sHOWPUBLISHED-[width:%i]\n%s\n",
     one_config_set.form_label,HOWPUBLISHED_LEN,"");
   fprintf(fptxt,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,"");
   fprintf(fptxt,"%sDATE-YEAR-[width:%i;num]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,"");
   fprintf(fptxt,"%sDATE-MONTH-[width:%i;num:1..12]\n%s\n",
       one_config_set.form_label,MONAT_LEN,"");
   fprintf(fptxt,"%sDATE-DAY-[width:%i;num:1..31]\n%s\n",
       one_config_set.form_label,TAG_LEN,"");
   fprintf(fptxt,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,"");
   fprintf(fptxt,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,"");
   fprintf(fptxt,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,"");
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,"");
   fprintf(fptxt,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
   fprintf(fptxt,"%sABSTRACT-[width:%iw]\n",
       one_config_set.form_label,ABSTRACT_ZEILE_LEN);
   fprintf(fptxt,"\n%sEND-OF-RECORD\n",one_config_set.form_label);
   return;
}



