/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputQueryDialog
extends MessageDialog {
    private String input;
    private Text field;
    private boolean okPressed = false;
    private String initialText;
    private IInputValidator validator;

    public InputQueryDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    public InputQueryDialog(Shell shell, String title, String message, String def, IInputValidator vali) {
        super(shell, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.initialText = def;
        this.input = def;
        this.validator = vali;
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.field = new Text(composite, 2052);
        if (this.initialText != null) {
            this.field.setText(this.initialText);
            this.field.setSelection(0, this.initialText.length());
        }
        this.field.setLayoutData((Object)new GridData(768));
        this.field.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (InputQueryDialog.this.validator != null) {
                    InputQueryDialog.this.input = InputQueryDialog.this.field.getText();
                    if (InputQueryDialog.this.input != null) {
                        InputQueryDialog.this.input = InputQueryDialog.this.input.trim();
                    }
                    String error = InputQueryDialog.this.validator.isValid(InputQueryDialog.this.input);
                    Button ok = InputQueryDialog.this.getButton(0);
                    ok.setEnabled(error == null);
                } else {
                    InputQueryDialog.this.input = InputQueryDialog.this.field.getText();
                }
            }
        });
        return composite;
    }

    public void setValidator(IInputValidator validator) {
        this.validator = validator;
    }

    public String getInput() {
        return this.input;
    }

    public static InputQueryDialog createQuery(String title, String message, String okText, String cancelText) {
        return new InputQueryDialog(new Shell(), title, null, message, 3, new String[]{okText, cancelText}, 0);
    }

    public static InputQueryDialog createQuery(String title, String message) {
        return InputQueryDialog.createQuery(title, message, IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL);
    }
}

