/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.actions.TexSelections;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class TexComment
implements IEditorActionDelegate {
    private IEditorPart targetEditor;
    private static TexSelections selection;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    public void run(IAction action) {
        selection = new TexSelections(this.getTextEditor());
        this.comment();
    }

    private ITextEditor getTextEditor() {
        if (this.targetEditor instanceof ITextEditor) {
            return (ITextEditor)this.targetEditor;
        }
        throw new RuntimeException("Expecting text editor. Found:" + this.targetEditor.getClass().getName());
    }

    private void comment() {
        StringBuffer strbuf = new StringBuffer();
        selection.selectCompleteLines();
        try {
            int i = selection.getStartLineIndex();
            while (i < selection.getEndLineIndex()) {
                strbuf.append("% " + selection.getLine(i) + selection.getEndLineDelim());
                ++i;
            }
            strbuf.append("% " + selection.getLine(selection.getEndLineIndex()));
            selection.getDocument().replace(selection.getStartLine().getOffset(), selection.getSelLength(), strbuf.toString());
        }
        catch (Exception e) {
            TexlipsePlugin.log("TexComment.comment(): ", e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof TextSelection) {
            action.setEnabled(true);
            return;
        }
        action.setEnabled(this.targetEditor instanceof ITextEditor);
    }
}

