---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, 
              polices de caractères, police en mode mathématique, 
              lettres grecques en gras, lettres grecques grasses, 
              caractères grecs gras
---

# Comment utiliser des lettres grecques grasses en mode mathématique ?

La question est rendue non-triviale par le fait que `\mathbf` (la commande
qui met du texte en gras en mode mathématique) affecte différemment 
les lettres grecques minuscules et majuscules : les lettres grecques minuscules
sont dans les polices mathématiques, tandis que les lettres majuscules 
sont dans les polices de texte originales (encodées en OT1).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\Large % Pour de grands caractères
Gras : $\mathbf{\theta\Theta}$

Maigre : $\theta\Theta$
\end{document}
```


## Avec les commandes de base 

Une solution fonctionne mais avec des inconvénients. Il s'agit de passer 
en style mathématique gras, avant de commencer l'équation :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\Large % Pour de grands caractères
Gras : {\boldmath$\theta\Theta$}

Maigre : {$\theta\Theta$}
\end{document}
```

Si cela fonctionne, `\boldmath` ne peut cependant pas être utilisé 
en mode mathématique. Pour s'en servir au sein d'une formule, il faut en fait 
inclure une autre formule à l'intérieur, dans une boîte :

```{noedit}
$... \mbox{\boldmath$\theta$} ...$
```

ce qui cause d'autres problèmes, par exemple avec les indices et les exposants.


## Avec l'extension <ctanpkg:mathtools>

Si vous chargez l'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>), 
vous pouvez écrire :

```{noedit}
$... \text{\boldmath$\theta$} ...$
```

Ceci pose moins de problèmes avec les indices et exposants mais reste 
peu satisfaisant.


## Avec l'extension <ctanpkg:bm>

L'extension <ctanpkg:bm> (*bold math*) définit une commande `\bm` utilisable
partout en mode mathématique (et pas seulement sur les lettres grecques 
d'ailleurs).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{bm}

\begin{document}
\Large % Pour de grands caractères
Gras : $\bm{\theta + \Theta}$

Maigre : $\theta + \Theta$
\end{document}
```


## Avec l'extension <ctanpkg:amsbsy>

L'extension <ctanpkg:amsbsy> (qui fait partie de l'ensemble 
[latex-amsmath)](ctanpkg:latex-amsmath)) définit une commande `\boldsymbol`, 
qui couvre quasiment tous les cas d'usage, même si elle est un peu 
moins complète que `\bm`.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{amsbsy}

\begin{document}
\Large % Pour de grands caractères
Gras : $\boldsymbol{\theta + \Theta}$

Maigre : $\theta + \Theta$
\end{document}
```


:::{sources}
- [Setting bold Greek letters in LaTeX maths](faquk:FAQ-boldgreek)
:::