---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, 
              polices de caractères, police en mode mathématique, 
              formules mathématiques, taille des symboles mathématiques
---

# Comment agrandir les symboles mathématiques ?

Par défaut, les "grands" symboles mathématiques restent à la même taille
quelle que soit la taille de la police du texte environnant. Il y a 
une bonne raison à cela : les fontes *Computer Modern Math Large Symbols*
(`cmex`) ne sont pas vraiment conçues pour être mises à l'échelle. Dès lors,
si les polices étaient mises à l'échelle, les algorithmes de placement 
des symboles mathématiques de TeX conduiraient à un résultat médiocre.

Cependant, ce choix, en plus de dérouter l'utilisateur, peut conduire 
à des documents à l'aspect un peu étrange, comme le montre 
l'exemple suivant. 

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\[ \sum_{i=0}^{\infty} x^i \]
\Huge
\[ \sum_{i=0}^{\infty} x^i \]
\end{document}
```

Si vous voulez que les polices soient mises à l'échelle, il faut utiliser
l'une des extensions suivantes.


## Avec l'extension <ctanpkg:mathtools>

Il suffit de charger l'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) 
pour que l'adaptation de taille se fasse. Cependant, il ne faut pas avoir 
en même temps recours à l'extension <ctanpkg:lmodern> sous peine de retomber
dans la situation vue initialement.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\[ \sum_{i=0}^{\infty} x^i \]
\Huge
\[ \sum_{i=0}^{\infty} x^i \]
\end{document}
```


## Avec l'extension <ctanpkg:exscale>

Même chose avec l'extension <ctanpkg:exscale> : faire appel à l'extension
suffit à obtenir l'adaptation de taille. 

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{exscale}

\begin{document}
\[ \sum_{i=0}^{\infty} x^i \]
\Huge
\[ \sum_{i=0}^{\infty} x^i \]
\end{document}
```


:::{sources}
- [Maths symbols don't scale up](faquk:FAQ-exscale)
- [Should one always use exscale when using lmodern?](https://tex.stackexchange.com/q/198219),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
- [Compatibility between amsmath and exscale](https://tex.stackexchange.com/q/80088), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::