/* This is -*- C -*- */
/* vim: set sw=2: */
/* $Id: poly.h,v 1.2 2001/01/16 23:35:48 trow Exp $ */

/*
 * guppi-curve-poly-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_CURVE_POLY_IMPL_H
#define _INC_GUPPI_CURVE_POLY_IMPL_H

/* #include <gnome.h> */
#include <guppi-defs.h>
#include <guppi-curve-impl.h>
#include <guppi-data.h>

BEGIN_GUPPI_DECLS;

typedef struct _GuppiCurvePolyImpl GuppiCurvePolyImpl;
typedef struct _GuppiCurvePolyImplClass GuppiCurvePolyImplClass;

struct _GuppiCurvePolyImpl {
  GuppiCurveImpl parent;

  double min, max;

  gint degree;
  double *c;  /* coefficients */

  gboolean ext_end_pts_only;
  double *ext_pts;  /* extreme points */
};

struct _GuppiCurvePolyImplClass {
  GuppiCurveImplClass parent_class;
};

#define GUPPI_TYPE_CURVE_POLY_IMPL (guppi_curve_poly_impl_get_type ())
#define GUPPI_CURVE_POLY_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_CURVE_POLY_IMPL,GuppiCurvePolyImpl))
#define GUPPI_CURVE_POLY_IMPL0(obj) ((obj) ? (GUPPI_CURVE_POLY_IMPL(obj)) : NULL)
#define GUPPI_CURVE_POLY_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_CURVE_POLY_IMPL,GuppiCurvePolyImplClass))
#define GUPPI_IS_CURVE_POLY_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_CURVE_POLY_IMPL))
#define GUPPI_IS_CURVE_POLY_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_CURVE_POLY_IMPL(obj)))
#define GUPPI_IS_CURVE_POLY_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_CURVE_POLY_IMPL))

#define g_return_unless_is_guppi_curve_poly_impl(x) (g_return_if_fail((x)&&GUPPI_IS_CURVE_POLY_IMPL((x))))
#define g_return_val_unless_is_guppi_curve_poly_impl(x,y) (g_return_val_if_fail((x)&&GUPPI_IS_CURVE_POLY_IMPL((x)),(y)))

GtkType guppi_curve_poly_impl_get_type (void);

gint guppi_curve_poly_impl_degree (GuppiCurvePolyImpl *);

double guppi_curve_poly_impl_coefficient (GuppiCurvePolyImpl *, gint i);
void guppi_curve_poly_impl_set_coefficient (GuppiCurvePolyImpl *,
					    gint i, double a);


GuppiData *guppi_curve_new_polynomial2 (double c0, double c1, double c2);
GuppiData *guppi_curve_new_polynomial3 (double c0, double c1, double c2,
					double c3);



END_GUPPI_DECLS;

#endif /* _INC_GUPPI_CURVE_POLY_IMPL_H */

/* $Id: poly.h,v 1.2 2001/01/16 23:35:48 trow Exp $ */
