/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-scatter-register.c
 *
 * Copyright (C) 2000 Helix Code, Inc.
 *
 * Developed by Jody Goldberg <jgoldberg@home.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#include <config.h>

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>
#include <libgnome/gnome-i18n.h>

#include <guppi-root-group-state.h>
#include <guppi-root-group-view.h>
#include "guppi-chart-type.h"
#include "guppi-scatter-register.h"
#include "guppi-XLplots-common.h"
#include <guppi-seq-scalar.h>
#include "scatter.xpm"
#include "bubble.xpm"

#include <guppi-seq-data.h>

typedef struct
{
  gboolean bubble;
} ScatterChartDescriptor;

static GuppiRootGroupView *
guppi_scatter_factory (GuppiMinorChartType const *t,
		       GuppiSeqData   *series,
		       GuppiSeqData   *labels,
		       GuppiSeqString *series_names)
{
  ScatterChartDescriptor const *desc = t->user_data;

  GuppiData *x_data;
  GuppiData *y_data;

  /* State Objects */
  GuppiElementState* scatter_state, *legend_state;

  /* View Objects */
  GuppiElementView* scatter_view, *legend_view;

  GuppiElementState* root_state;
  GuppiGroupView* root_view;

  root_state = guppi_root_group_state_new ();
  root_view = GUPPI_GROUP_VIEW (guppi_element_state_make_view (root_state));

  /* FIXME : Only plot the first sequence */
  x_data = guppi_seq_data_get(GUPPI_SEQ_DATA (series), 0);
  y_data = guppi_seq_data_get(GUPPI_SEQ_DATA (series), 1);

  /* Build our state objects */
  scatter_state = guppi_element_state_new("scatter",
					  "x_data",  x_data,
					  "y_data",  y_data,
					  NULL);
  if (desc->bubble && guppi_seq_size (GUPPI_SEQ (series)) > 2) {
    GuppiData *size_data = guppi_seq_data_get(GUPPI_SEQ_DATA (series), 2);
    gtk_object_set (GTK_OBJECT (scatter_state), "size1_data", size_data, NULL);
  }

  legend_state = xlplots_stock_legend ();
  guppi_element_state_changed_delayed(GUPPI_ELEMENT_STATE(scatter_state));

#if 0
  /* This doesn't work with scatter plots */
  guppi_element_state_connect(scatter_state, SHARED_LABEL_DATA,
			      legend_state, SHARED_LABEL_DATA);
  guppi_element_state_connect(scatter_state, SHARED_STYLE_DATA,
			      legend_state, SHARED_STYLE_DATA);
#endif

  /* Build our views */
  scatter_view = guppi_element_state_make_view(scatter_state);
  guppi_element_view_set_preferred_view(scatter_view);
  legend_view = guppi_element_state_make_view(legend_state);

  /* Do our layout */
  guppi_group_view_layout_flush_top(root_view, scatter_view, 7.2);
  guppi_group_view_layout_flush_left(root_view, scatter_view, 7.2);
  guppi_group_view_layout_flush_bottom(root_view, scatter_view, 7.2);

  guppi_group_view_layout_horizontally_adjacent(root_view, scatter_view,
						legend_view, 7.2);
  guppi_group_view_layout_natural_width(root_view, legend_view);
  guppi_group_view_layout_natural_height(root_view, legend_view);
  guppi_group_view_layout_flush_right(root_view, legend_view, 7.2);
  guppi_group_view_layout_same_y_center(root_view, scatter_view, legend_view);

  guppi_group_view_commit_all_changes(root_view);

  guppi_root_group_view_set_size(GUPPI_ROOT_GROUP_VIEW(root_view),
				 6*72, 4.5*72);

  return GUPPI_ROOT_GROUP_VIEW (root_view);
}

void
guppi_scatter_register ()
{
  GuppiMajorChartType *scatter_types =
      guppi_major_chart_type_register ( _("Scatter"), scatter_icon, NULL);
  GuppiMajorChartType *bubble_types =
      guppi_major_chart_type_register ( _("Bubble"), bubble_icon, NULL);

  {
    static ScatterChartDescriptor const desc = { FALSE };
    guppi_minor_chart_type_register (scatter_types,
      _("Points"), "chart_scatter_1_1.png",
      _("Plot one series per axis."),
      1, 1, &guppi_scatter_factory, &desc);
  }

  {
    static ScatterChartDescriptor const desc = { FALSE };
    guppi_minor_chart_type_register (scatter_types,
      _("Marked interpolated points"), "chart_scatter_2_1.png",
      _("Interpolate between multi-dimensionsal points,"
	"with markers at each point."),
      2, 1, &guppi_scatter_factory, &desc);
  }

  {
    static ScatterChartDescriptor const desc = { FALSE };
    guppi_minor_chart_type_register (scatter_types,
      _("Interpolated points"), "chart_scatter_2_2.png",
      _("Interpolate between multi-dimensionsal points,"),
      2, 2, &guppi_scatter_factory, &desc);
  }

  {
    static ScatterChartDescriptor const desc = { FALSE };
    guppi_minor_chart_type_register (scatter_types,
      _("Marked linearly interpolated points"), "chart_scatter_3_1.png",
      _("Linearly interpolate between multi-dimensionsal points,"
	"with markers at each point."),
      3, 1, &guppi_scatter_factory, &desc);
  }

  {
    static ScatterChartDescriptor const desc = { FALSE };
    guppi_minor_chart_type_register (scatter_types,
      _("Linearly interpolated points"), "chart_scatter_3_2.png",
      _("Linearly interpolate between multi-dimensionsal points,"),
      3, 2, &guppi_scatter_factory, &desc);
  }

  {
    static ScatterChartDescriptor const desc = { TRUE };
    guppi_minor_chart_type_register (bubble_types,
      _("Bubble"), "chart_bubble_1_1.png",
      _("Plot X, Y and bubble size."),
      1, 1, &guppi_scatter_factory, &desc);
  }

#if 0
  {
    static ScatterChartDescriptor const desc = { TRUE };
    guppi_minor_chart_type_register (bubble_types,
      _("3D Bubbles"), "chart_bubble_1_1.png",
      _("Plot X, Y and bubble size, with a 3d effect."),
      1, 2, &guppi_scatter_factory, &desc);
  }
#endif
}
