/* This is -*- C -*- */
/* $Id: guppi-barchart-state.h,v 1.14 2001/05/06 07:56:27 trow Exp $ */

/*
 * guppi-barchart-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_BARCHART_STATE_H
#define _INC_GUPPI_BARCHART_STATE_H

/* #include <gnome.h> */
#include <guppi-defs.h>
#include <guppi-data.h>
#include <guppi-seq-string.h>
#include <guppi-seq-style.h>
#include <guppi-useful.h>
#include <guppi-element-state.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiBarchartState GuppiBarchartState;
typedef struct _GuppiBarchartStateClass GuppiBarchartStateClass;

struct _GuppiBarchartState {
  GuppiElementState parent;

  gboolean stacked;
  gboolean normalize_stacks;

  double edge_thickness;
  guint32 edge_color;

  guint32 default_color;
  guint32 use_stock_colors;

  gboolean vertical_bars;
  double bar_base;

  double cluster_margin, bar_margin;

  gboolean enforce_preferred_view;
  double bar_pos_min, bar_pos_max;

};

struct _GuppiBarchartStateClass {
  GuppiElementStateClass parent_class;
};

#define GUPPI_TYPE_BARCHART_STATE (guppi_barchart_state_get_type())
#define GUPPI_BARCHART_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_BARCHART_STATE,GuppiBarchartState))
#define GUPPI_BARCHART_STATE0(obj) ((obj) ? (GUPPI_BARCHART_STATE(obj)) : NULL)
#define GUPPI_BARCHART_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_BARCHART_STATE,GuppiBarchartStateClass))
#define GUPPI_IS_BARCHART_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_BARCHART_STATE))
#define GUPPI_IS_BARCHART_STATE0(obj) (((obj) == NULL) || (GUPPI_IS_BARCHART_STATE(obj)))
#define GUPPI_IS_BARCHART_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_BARCHART_STATE))

GtkType guppi_barchart_state_get_type (void);

GuppiElementState *guppi_barchart_state_new (void);

GuppiData *guppi_barchart_state_data (GuppiBarchartState *);
GuppiSeqString *guppi_barchart_state_row_labels (GuppiBarchartState *);
GuppiSeqString *guppi_barchart_state_column_labels (GuppiBarchartState *);
GuppiSeqStyle *guppi_barchart_state_column_styles (GuppiBarchartState *);

#define guppi_barchart_state_stacked(x) ((x)->stacked)
#define guppi_barchart_state_normalize_stacks(x) ((x)->normalize_stacks)

#define guppi_barchart_state_edge_thickness(x) ((x)->edge_thickness)
#define guppi_barchart_state_edge_color(x) ((x)->edge_color)

#define guppi_barchart_state_default_color(x) ((x)->default_color)
#define guppi_barchart_state_use_stock_colors(x) ((x)->use_stock_colors)

#define guppi_barchart_state_vertical_bars(x) ((x)->vertical_bars)
#define guppi_barchart_state_horizontal_bars(x) (!(x)->vertical_bars)
#define guppi_barchart_state_bar_base(x) ((x)->bar_base)

#define guppi_barchart_state_cluster_margin(x) ((x)->cluster_margin)
#define guppi_barchart_state_bar_margin(x) ((x)->bar_margin)

#define guppi_barchart_state_enforce_preferred_view(x) ((x)->enforce_preferred_view)

#define guppi_barchart_state_bar_pos_min(x) ((x)->bar_pos_min)
#define guppi_barchart_state_bar_pos_max(x) ((x)->bar_pos_max)


void guppi_barchart_state_set_data (GuppiBarchartState *, GuppiData *);
void guppi_barchart_state_set_row_labels (GuppiBarchartState *,
					  GuppiSeqString *);
void guppi_barchart_state_set_column_labels (GuppiBarchartState *,
					     GuppiSeqString *);
void guppi_barchart_state_set_column_styles (GuppiBarchartState *,
					     GuppiSeqStyle *);


void guppi_barchart_state_set_stacked (GuppiBarchartState *, gboolean);
void guppi_barchart_state_set_normalize_stacks (GuppiBarchartState *,
						gboolean);

void guppi_barchart_state_set_edge_thickness (GuppiBarchartState *, double);
void guppi_barchart_state_set_edge_color (GuppiBarchartState *, guint32);

void guppi_barchart_state_set_default_color (GuppiBarchartState *, guint32);
void guppi_barchart_state_set_use_stock_colors (GuppiBarchartState * state,
						guint32 x);

void guppi_barchart_state_set_vertical_bars (GuppiBarchartState *, gboolean);
void guppi_barchart_state_set_horizontal_bars (GuppiBarchartState *,
					       gboolean);
void guppi_barchart_state_set_bar_base (GuppiBarchartState *, double);

void guppi_barchart_state_set_cluster_margin (GuppiBarchartState *, double);
void guppi_barchart_state_set_bar_margin (GuppiBarchartState *, double);

void guppi_barchart_state_set_enforce_preferred_view (GuppiBarchartState *,
						      gboolean);
void guppi_barchart_state_set_bar_pos_min (GuppiBarchartState *, double);
void guppi_barchart_state_set_bar_pos_max (GuppiBarchartState *, double);

/**************************************************************************/

void guppi_barchart_state_col_bounds (GuppiBarchartState *, gint * c0,
				      gint * c1);
void guppi_barchart_state_rows_in_col (GuppiBarchartState *, gint c,
				       gint * r0, gint * r1);

double guppi_barchart_state_data_by_rc (GuppiBarchartState *, gint r, gint c);

void guppi_barchart_state_row_bounds (GuppiBarchartState *, gint * r0,
				      gint * r1);

void guppi_barchart_state_data_range (GuppiBarchartState *,
				      double *min, double *max);
double guppi_barchart_state_row_abs_sum (GuppiBarchartState *, gint r);
double guppi_barchart_state_row_abs_partial_sum (GuppiBarchartState *,
						 gint r, gint c);
double guppi_barchart_state_max_row_abs_sum (GuppiBarchartState * state);

guint32 guppi_barchart_state_col_color (GuppiBarchartState *, gint c);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_BARCHART_STATE_H */

/* $Id: guppi-barchart-state.h,v 1.14 2001/05/06 07:56:27 trow Exp $ */
