/* This is -*- C -*- */
/* $Id: guppi-data-impl-plug-in.c,v 1.4 2001/05/03 23:03:00 trow Exp $ */

/*
 * guppi-data-impl-plug-in.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-memory.h>
#include "guppi-data-impl-plug-in.h"

static GtkObjectClass *parent_class = NULL;

static void
guppi_data_impl_plug_in_finalize (GtkObject * obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

static void
guppi_data_impl_plug_in_class_init (GuppiDataImplPlugInClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;

  parent_class = gtk_type_class (GUPPI_TYPE_PLUG_IN);

  object_class->finalize = guppi_data_impl_plug_in_finalize;
}

static void
guppi_data_impl_plug_in_init (GuppiDataImplPlugIn * obj)
{

}

GtkType guppi_data_impl_plug_in_get_type (void)
{
  static GtkType guppi_data_impl_plug_in_type = 0;
  if (!guppi_data_impl_plug_in_type) {
    static const GtkTypeInfo guppi_data_impl_plug_in_info = {
      "GuppiDataImplPlugIn",
      sizeof (GuppiDataImplPlugIn),
      sizeof (GuppiDataImplPlugInClass),
      (GtkClassInitFunc) guppi_data_impl_plug_in_class_init,
      (GtkObjectInitFunc) guppi_data_impl_plug_in_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_data_impl_plug_in_type =
      gtk_type_unique (GUPPI_TYPE_PLUG_IN, &guppi_data_impl_plug_in_info);
  }
  return guppi_data_impl_plug_in_type;
}

GuppiPlugIn *
guppi_data_impl_plug_in_new (void)
{
  return GUPPI_PLUG_IN (guppi_type_new (guppi_data_impl_plug_in_get_type ()));
}

GuppiDataImpl *
guppi_data_impl_plug_in_construct_impl (GuppiDataImplPlugIn *plugin)
{
  GuppiDataImpl *impl;
  GuppiDataImplClass *klass;

  g_return_val_if_fail (plugin != NULL, NULL);
  g_return_val_if_fail (plugin->impl_constructor, NULL);

  impl = (plugin->impl_constructor) ();

  if (impl) {
    klass = GUPPI_DATA_IMPL_CLASS (GTK_OBJECT (impl)->klass);
    if (klass->plug_in_code == NULL) {
      klass->plug_in_code = guppi_strdup (guppi_plug_in_code (GUPPI_PLUG_IN (plugin)));
      guppi_permanent_alloc (klass->plug_in_code);
    }
  }

  return impl;
}


/* $Id: guppi-data-impl-plug-in.c,v 1.4 2001/05/03 23:03:00 trow Exp $ */
