/* This is -*- C -*- */
/* $Id: guppi-seq.h,v 1.17 2001/05/03 23:03:02 trow Exp $ */

/*
 * guppi-seq.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 * Copyright (C) 2001 The Free Software Foundation
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SEQ_H
#define _INC_GUPPI_SEQ_H

/* #include <gtk/gtk.h> */
#include "guppi-data.h"

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

typedef struct _GuppiSeq GuppiSeq;
typedef struct _GuppiSeqClass GuppiSeqClass;

struct _GuppiSeq {
  GuppiData parent;
};

struct _GuppiSeqClass {
  GuppiDataClass parent_class;

  xmlNodePtr (*export_xml_element) (GuppiSeq *, gint i, GuppiXMLDocument *);
  void (*import_xml_element) (GuppiSeq *, GuppiXMLDocument *, xmlNodePtr);

  void (*changed_shift_indices) (GuppiSeq *, gint);
  void (*changed_set) (GuppiSeq *, gint, gint);
  void (*changed_insert) (GuppiSeq *, gint, gsize);
  void (*changed_delete) (GuppiSeq *, gint, gsize);
};

#define GUPPI_TYPE_SEQ (guppi_seq_get_type())
#define GUPPI_SEQ(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SEQ,GuppiSeq))
#define GUPPI_SEQ0(obj) ((obj) ? (GUPPI_SEQ(obj)) : NULL)
#define GUPPI_SEQ_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SEQ,GuppiSeqClass))
#define GUPPI_IS_SEQ(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SEQ))
#define GUPPI_IS_SEQ0(obj) (((obj) == NULL) || (GUPPI_IS_SEQ(obj)))
#define GUPPI_IS_SEQ_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SEQ))

GtkType guppi_seq_get_type (void);

void guppi_seq_size_hint (GuppiSeq *, gsize expected_size);

void guppi_seq_indices (const GuppiSeq *, gint * min, gint * max);
#define guppi_seq_bounds(seq, a, b) (guppi_seq_indices((seq), (a), (b)))

gint guppi_seq_min_index (const GuppiSeq *);
gint guppi_seq_max_index (const GuppiSeq *);

/* Size = max index - min index + 1 */
gsize guppi_seq_size (const GuppiSeq *);

/* Count = size - # of missing values (so size == count in many cases) */
gsize guppi_seq_count (const GuppiSeq *);

gboolean guppi_seq_empty (const GuppiSeq *);	/* size == 0 */
gboolean guppi_seq_nonempty (const GuppiSeq *);	/* size != 0 */

gboolean guppi_seq_absent (const GuppiSeq *);	/* count == 0 */
gboolean guppi_seq_present (const GuppiSeq *);	/* count != 0 */

gboolean guppi_seq_in_bounds (const GuppiSeq *, gint);
gboolean guppi_seq_contains_bounds (const GuppiSeq *, const GuppiSeq *);
gboolean guppi_seq_equal_bounds (const GuppiSeq *, const GuppiSeq *);
void guppi_seq_common_bounds (const GuppiSeq *, const GuppiSeq *,
			      gint *, gint *);

void guppi_seq_shift_indices (GuppiSeq *, gint);
void guppi_seq_set_min_index (GuppiSeq *, gint);
void guppi_seq_set_max_index (GuppiSeq *, gint);

gboolean guppi_seq_validate (const GuppiSeq *, const gchar * sbuf);
gboolean guppi_seq_validate_with_feedback (const GuppiSeq *,
					   const gchar * sbuf,
					   gchar * ebuf, gsize elen);

gchar *guppi_seq_get_string (const GuppiSeq *, gint i);
void guppi_seq_get_to_string (const GuppiSeq *, gint i,
			      gchar * sbuf, gsize sbuf_len);
void guppi_seq_set_from_string (GuppiSeq *, gint i, const gchar * sbuf);
void guppi_seq_insert_from_string (GuppiSeq *, gint i, const gchar * sbuf);
void guppi_seq_prepend_from_string (GuppiSeq *, const gchar * sbuf);
void guppi_seq_append_from_string (GuppiSeq *, const gchar * sbuf);

void guppi_seq_delete (GuppiSeq *, gint);
void guppi_seq_delete_many (GuppiSeq *, gint, gsize);
void guppi_seq_delete_range (GuppiSeq *, gint, gint);

void guppi_seq_grow_to_include (GuppiSeq *, gint i);
void guppi_seq_grow_to_include_range (GuppiSeq *, gint i0, gint i1);
void guppi_seq_grow_to_overlap (GuppiSeq *, const GuppiSeq *);


/* Missing values */

gboolean guppi_seq_has_missing (GuppiSeq *);
gsize guppi_seq_missing_count (GuppiSeq *);
gboolean guppi_seq_missing (GuppiSeq *, gint);
gboolean guppi_seq_available (GuppiSeq *, gint);	/* !missing */
void guppi_seq_set_missing (GuppiSeq *, gint);
void guppi_seq_insert_missing (GuppiSeq *, gint);
void guppi_seq_prepend_missing (GuppiSeq *);
void guppi_seq_append_missing (GuppiSeq *);


/* Don't call these unless you know what you are doing... */
void guppi_seq_changed_shift_indices (GuppiSeq *, gint, GuppiDataOp *);
void guppi_seq_changed_set (GuppiSeq *, gint, gint, GuppiDataOp *);
void guppi_seq_changed_insert (GuppiSeq *, gint, gsize, GuppiDataOp *);
void guppi_seq_changed_delete (GuppiSeq *, gint, gsize, GuppiDataOp *);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_SEQ_H */

/* $Id: guppi-seq.h,v 1.17 2001/05/03 23:03:02 trow Exp $ */
