/* This is -*- C -*- */
/* $Id: guppi-shared-hash.c,v 1.7 2000/12/17 05:24:57 trow Exp $ */

/*
 * guppi-shared-hash.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-convenient.h>
#include "guppi-shared-hash.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_shared_hash_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_shared_hash_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_shared_hash_destroy (GtkObject * obj)
{
  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
hash_cleanup (gpointer key, gpointer val, gpointer user_data)
{
  guppi_free (key);
  guppi_unref (val);
}

static void
guppi_shared_hash_finalize (GtkObject * obj)
{
  GuppiSharedHash *gsh = GUPPI_SHARED_HASH (obj);

  guppi_finalized (obj);

  g_hash_table_foreach (gsh->hash, hash_cleanup, NULL);
  g_hash_table_destroy (gsh->hash);
  gsh->hash = NULL;

  guppi_unref0 (gsh->chain);
  guppi_unref0 (gsh->shared_viewport);

  if (parent_class->finalize)
    parent_class->finalize (obj);
}

static void
guppi_shared_hash_class_init (GuppiSharedHashClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;

  parent_class = gtk_type_class (GTK_TYPE_OBJECT);

  object_class->get_arg = guppi_shared_hash_get_arg;
  object_class->set_arg = guppi_shared_hash_set_arg;
  object_class->destroy = guppi_shared_hash_destroy;
  object_class->finalize = guppi_shared_hash_finalize;

}

static void
guppi_shared_hash_init (GuppiSharedHash * obj)
{
  obj->hash = g_hash_table_new (g_str_hash, g_str_equal);
}

GtkType guppi_shared_hash_get_type (void)
{
  static GtkType guppi_shared_hash_type = 0;
  if (!guppi_shared_hash_type) {
    static const GtkTypeInfo guppi_shared_hash_info = {
      "GuppiSharedHash",
      sizeof (GuppiSharedHash),
      sizeof (GuppiSharedHashClass),
      (GtkClassInitFunc) guppi_shared_hash_class_init,
      (GtkObjectInitFunc) guppi_shared_hash_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_shared_hash_type =
      gtk_type_unique (GTK_TYPE_OBJECT, &guppi_shared_hash_info);
  }
  return guppi_shared_hash_type;
}

GuppiSharedHash *
guppi_shared_hash_new (void)
{
  return GUPPI_SHARED_HASH (guppi_type_new (guppi_shared_hash_get_type ()));
}

void
guppi_shared_hash_chain (GuppiSharedHash * gsh, GuppiSharedHash * ch)
{
  g_return_if_fail (gsh != NULL);
  guppi_refcounting_assign (gsh->chain, ch);
}

void
guppi_shared_hash_add (GuppiSharedHash * gsh, const gchar * key,
		       GuppiShared * sh)
{
  g_return_if_fail (gsh != NULL);
  g_return_if_fail (key != NULL);
  g_return_if_fail (sh != NULL);

  if (g_hash_table_lookup (gsh->hash, key)) {
    g_warning ("SharedHash collision on key \"%s\"", key);
    return;
  }
  g_hash_table_insert (gsh->hash, guppi_strdup (key), sh);
  guppi_ref (sh);
  guppi_sink (sh);
}

GuppiShared *
guppi_shared_hash_extract (GuppiSharedHash * gsh, const gchar * key)
{
  GuppiShared *sh;

  g_return_val_if_fail (gsh != NULL, NULL);
  g_return_val_if_fail (key != NULL, NULL);


  if ((sh = GUPPI_SHARED0 (g_hash_table_lookup (gsh->hash, key))))
    return sh;

  return gsh->chain ? guppi_shared_hash_extract (gsh->chain, key) : NULL;
}

gboolean guppi_shared_hash_test (GuppiSharedHash * gsh, const gchar * key)
{
  g_return_val_if_fail (gsh != NULL, FALSE);
  g_return_val_if_fail (key != NULL, FALSE);

  return g_hash_table_lookup_extended (gsh->hash, key, NULL, NULL) ||
    (gsh->chain && guppi_shared_hash_test (gsh->chain, key));
}

GtkObject *
guppi_shared_hash_get (GuppiSharedHash * gsh, const gchar * key)
{
  GuppiShared *sh;

  g_return_val_if_fail (gsh != NULL, NULL);
  g_return_val_if_fail (key != NULL, NULL);

  sh = guppi_shared_hash_extract (gsh, key);

  return sh ? guppi_shared_get (sh) : NULL;
}

void
guppi_shared_hash_set (GuppiSharedHash * gsh, const gchar * key,
		       GtkObject * obj)
{
  GuppiShared *sh;

  g_return_if_fail (gsh != NULL);
  g_return_if_fail (key != NULL);

  sh = guppi_shared_hash_extract (gsh, key);
  if (sh)
    guppi_shared_set (sh, obj);
  else
    g_warning ("Unknown shared access on key \"%s\"", key);
}


/* $Id: guppi-shared-hash.c,v 1.7 2000/12/17 05:24:57 trow Exp $ */
