/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-attributes.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 * Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_ATTRIBUTES_H
#define _INC_GUPPI_ATTRIBUTES_H

/* #include <gtk/gtk.h> */
#include <guppi-defs.h>
#include <libgnomeprint/gnome-font.h>
#include "guppi-unique-id.h"
#include "guppi-xml.h"

BEGIN_GUPPI_DECLS

typedef gpointer   (*AttributeStringToPointerFn) (const gchar *);
typedef gchar     *(*AttributePointerToStringFn) (gpointer);
typedef void       (*AttributePointerDestroyFn)  (gpointer);
typedef xmlNodePtr (*AttributeCustomExportFn)    (GuppiXMLDocument *, gpointer);
typedef gpointer   (*AttributeCustomImportFn)    (GuppiXMLDocument *, xmlNodePtr);

typedef struct _GuppiAttributes GuppiAttributes;
typedef struct _GuppiAttributesClass GuppiAttributesClass;

struct _GuppiAttributes {
  GtkObject parent;

  GHashTable *attr_table;
};

struct _GuppiAttributesClass {
  GtkObjectClass parent_class;
};

#define GUPPI_TYPE_ATTRIBUTES (guppi_attributes_get_type ())
#define GUPPI_ATTRIBUTES(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_ATTRIBUTES,GuppiAttributes))
#define GUPPI_ATTRIBUTES0(obj) ((obj) ? (GUPPI_ATTRIBUTES(obj)) : NULL)
#define GUPPI_ATTRIBUTES_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_ATTRIBUTES,GuppiAttributesClass))
#define GUPPI_IS_ATTRIBUTES(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_ATTRIBUTES))
#define GUPPI_IS_ATTRIBUTES0(obj) (((obj) == NULL) || (GUPPI_IS_ATTRIBUTES(obj)))
#define GUPPI_IS_ATTRIBUTES_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_ATTRIBUTES))

GtkType guppi_attributes_get_type (void);

GuppiAttributes *guppi_attributes_new (void);

gboolean guppi_attributes_check_type(GuppiAttributes *, const gchar *name, const gchar *type);

void guppi_attributes_declare_full (GuppiAttributes *,
				    const gchar *name,
				    const gchar *type,
				    AttributeStringToPointerFn s2p,
				    AttributePointerToStringFn p2s,
				    AttributePointerDestroyFn  pdest);

void guppi_attributes_declare_full_custom (GuppiAttributes *,
					   const gchar *name,
					   const gchar *type,
					   AttributeCustomExportFn   c_export,
					   AttributeCustomImportFn   c_import,
					   AttributePointerDestroyFn pdest);

void     guppi_attributes_undeclare (GuppiAttributes *, const gchar *name);
gboolean guppi_attributes_declared  (GuppiAttributes *, const gchar *name);

gpointer guppi_attributes_get_raw  (GuppiAttributes *, const gchar *name);
void     guppi_attributes_set_raw  (GuppiAttributes *, const gchar *name, gpointer);

gboolean guppi_attributes_is_undef   (GuppiAttributes *, const gchar *name);
gboolean guppi_attributes_is_defined (GuppiAttributes *, const gchar *name);
void     guppi_attributes_set_undef  (GuppiAttributes *, const gchar *name);


void         guppi_attributes_declare_string (GuppiAttributes *, const gchar *name);
const gchar *guppi_attributes_get_string     (GuppiAttributes *, const gchar *name);
void         guppi_attributes_set_string     (GuppiAttributes *, const gchar *name, const gchar *str);

void guppi_attributes_declare_int (GuppiAttributes *, const gchar *name);
gint guppi_attributes_get_int     (GuppiAttributes *, const gchar *name);
void guppi_attributes_set_int     (GuppiAttributes *, const gchar *name, gint n);

void    guppi_attributes_declare_uint32 (GuppiAttributes *, const gchar *name);
guint32 guppi_attributes_get_uint32     (GuppiAttributes *, const gchar *name);
void    guppi_attributes_set_uint32     (GuppiAttributes *, const gchar *name, guint32 n);

void   guppi_attributes_declare_double (GuppiAttributes *, const gchar *name);
double guppi_attributes_get_double     (GuppiAttributes *, const gchar *name);
void   guppi_attributes_set_double     (GuppiAttributes *, const gchar *name, double x);

void     guppi_attributes_declare_boolean (GuppiAttributes *, const gchar *name); 
gboolean guppi_attributes_get_boolean     (GuppiAttributes *, const gchar *name);
void     guppi_attributes_set_boolean     (GuppiAttributes *, const gchar *name, gboolean);

void         guppi_attributes_declare_date (GuppiAttributes *, const gchar *name);
const GDate *guppi_attributes_get_date     (GuppiAttributes *, const gchar *name);
void         guppi_attributes_set_date     (GuppiAttributes *, const gchar *name, const GDate *dt);

void    guppi_attributes_declare_rgb (GuppiAttributes *, const gchar *name);
guint32 guppi_attributes_get_rgb     (GuppiAttributes *, const gchar *name);
void    guppi_attributes_set_rgb     (GuppiAttributes *, const gchar *name, guint32);

void    guppi_attributes_declare_rgba (GuppiAttributes *, const gchar *name);
guint32 guppi_attributes_get_rgba     (GuppiAttributes *, const gchar *name);
void    guppi_attributes_set_rgba     (GuppiAttributes *, const gchar *name, guint32);

void       guppi_attributes_declare_font (GuppiAttributes *, const gchar *name);
GnomeFont *guppi_attributes_get_font     (GuppiAttributes *, const gchar *name);
void       guppi_attributes_set_font     (GuppiAttributes *, const gchar *name, GnomeFont *);

void         guppi_attributes_declare_unique_id (GuppiAttributes *, const gchar *name);
guppi_uniq_t guppi_attributes_get_unique_id     (GuppiAttributes *, const gchar *name);
void         guppi_attributes_set_unique_id     (GuppiAttributes *, const gchar *name, guppi_uniq_t);

xmlNodePtr guppi_attributes_export_xml (GuppiAttributes *, GuppiXMLDocument *);
void       guppi_attributes_import_xml  (GuppiAttributes *, GuppiXMLDocument *, xmlNodePtr); 

END_GUPPI_DECLS

#endif /* _INC_GUPPI_ATTRIBUTES_H */

/* $Id: guppi-attributes.h,v 1.1 2001/05/03 23:02:26 trow Exp $ */
