/* website-updates.c generated by valac 0.12.0, the Vala compiler
 * generated from website-updates.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks-tracker.h>
#include <gio/gio.h>


#define TYPE_WEBSITE_UPDATES_TESTS (website_updates_tests_get_type ())
#define WEBSITE_UPDATES_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WEBSITE_UPDATES_TESTS, WebsiteUpdatesTests))
#define WEBSITE_UPDATES_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WEBSITE_UPDATES_TESTS, WebsiteUpdatesTestsClass))
#define IS_WEBSITE_UPDATES_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WEBSITE_UPDATES_TESTS))
#define IS_WEBSITE_UPDATES_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WEBSITE_UPDATES_TESTS))
#define WEBSITE_UPDATES_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WEBSITE_UPDATES_TESTS, WebsiteUpdatesTestsClass))

typedef struct _WebsiteUpdatesTests WebsiteUpdatesTests;
typedef struct _WebsiteUpdatesTestsClass WebsiteUpdatesTestsClass;
typedef struct _WebsiteUpdatesTestsPrivate WebsiteUpdatesTestsPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _WebsiteUpdatesTestsTestWebsiteUpdatesAsyncData WebsiteUpdatesTestsTestWebsiteUpdatesAsyncData;

struct _WebsiteUpdatesTests {
	FolksTestCase parent_instance;
	WebsiteUpdatesTestsPrivate * priv;
};

struct _WebsiteUpdatesTestsClass {
	FolksTestCaseClass parent_class;
};

struct _WebsiteUpdatesTestsPrivate {
	GMainLoop* _main_loop;
	TrackerTestBackend* _tracker_backend;
	FolksIndividualAggregator* _aggregator;
	gboolean _updated_website_found;
	gboolean _deleted_website_found;
	gboolean _initial_website_found;
	gchar* _updated_website;
	gchar* _individual_id;
	gchar* _initial_fullname;
	gchar* _initial_website;
	gchar* _contact_urn;
};

struct _WebsiteUpdatesTestsTestWebsiteUpdatesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	WebsiteUpdatesTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	GError * e;
	GError * _inner_error_;
};


static gpointer website_updates_tests_parent_class = NULL;

GType website_updates_tests_get_type (void) G_GNUC_CONST;
#define WEBSITE_UPDATES_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_WEBSITE_UPDATES_TESTS, WebsiteUpdatesTestsPrivate))
enum  {
	WEBSITE_UPDATES_TESTS_DUMMY_PROPERTY
};
WebsiteUpdatesTests* website_updates_tests_new (void);
WebsiteUpdatesTests* website_updates_tests_construct (GType object_type);
void website_updates_tests_test_website_updates (WebsiteUpdatesTests* self);
static void _website_updates_tests_test_website_updates_folks_test_case_test_method (gpointer self);
static void website_updates_tests_real_set_up (FolksTestCase* base);
static void website_updates_tests_real_tear_down (FolksTestCase* base);
static void _website_updates_tests_test_website_updates_async (WebsiteUpdatesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _website_updates_tests_test_website_updates_finish (WebsiteUpdatesTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (WebsiteUpdatesTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void _website_updates_tests_test_website_updates_async_data_free (gpointer _data);
static gboolean _website_updates_tests_test_website_updates_async_co (WebsiteUpdatesTestsTestWebsiteUpdatesAsyncData* data);
static void _website_updates_tests_test_website_updates_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _website_updates_tests_individuals_changed_cb (WebsiteUpdatesTests* self, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __website_updates_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _website_updates_tests_notify_website_cb (WebsiteUpdatesTests* self, GObject* individual_obj, GParamSpec* ps);
static void __website_updates_tests_notify_website_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void website_updates_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _website_updates_tests_test_website_updates_folks_test_case_test_method (gpointer self) {
	website_updates_tests_test_website_updates (self);
}


WebsiteUpdatesTests* website_updates_tests_construct (GType object_type) {
	WebsiteUpdatesTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (WebsiteUpdatesTests*) folks_test_case_construct (object_type, "WebsiteUpdates");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	tracker_test_backend_set_debug (self->priv->_tracker_backend, FALSE);
	folks_test_case_add_test ((FolksTestCase*) self, "websites updates", _website_updates_tests_test_website_updates_folks_test_case_test_method, self);
	return self;
}


WebsiteUpdatesTests* website_updates_tests_new (void) {
	return website_updates_tests_construct (TYPE_WEBSITE_UPDATES_TESTS);
}


static void website_updates_tests_real_set_up (FolksTestCase* base) {
	WebsiteUpdatesTests * self;
	self = (WebsiteUpdatesTests*) base;
}


static void website_updates_tests_real_tear_down (FolksTestCase* base) {
	WebsiteUpdatesTests * self;
	self = (WebsiteUpdatesTests*) base;
}


static gboolean _lambda0_ (WebsiteUpdatesTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void website_updates_tests_test_website_updates (WebsiteUpdatesTests* self) {
	GMainLoop* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* c1;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	c1 = _tmp1_;
	_tmp2_ = g_strdup ("persona #1");
	_g_free0 (self->priv->_initial_fullname);
	self->priv->_initial_fullname = _tmp2_;
	_tmp3_ = g_strdup ("www.example1.org");
	_g_free0 (self->priv->_initial_website);
	self->priv->_initial_website = _tmp3_;
	_tmp4_ = g_strdup ("www.example2.org");
	_g_free0 (self->priv->_updated_website);
	self->priv->_updated_website = _tmp4_;
	_tmp5_ = g_strdup ("<urn:contact001>");
	_g_free0 (self->priv->_contact_urn);
	self->priv->_contact_urn = _tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRACKER_TEST_BACKEND_URN, self->priv->_contact_urn);
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_FULLNAME, self->priv->_initial_fullname);
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRACKER_TEST_BACKEND_URLS, self->priv->_initial_website);
	tracker_test_backend_add_contact (self->priv->_tracker_backend, c1);
	tracker_test_backend_set_up (self->priv->_tracker_backend);
	self->priv->_initial_website_found = FALSE;
	self->priv->_updated_website_found = FALSE;
	self->priv->_deleted_website_found = FALSE;
	_tmp6_ = g_strdup ("");
	_g_free0 (self->priv->_individual_id);
	self->priv->_individual_id = _tmp6_;
	_website_updates_tests_test_website_updates_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (self->priv->_initial_website_found == TRUE);
	g_assert (self->priv->_updated_website_found == TRUE);
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
	_g_object_unref0 (c1);
}


static void _website_updates_tests_test_website_updates_async_data_free (gpointer _data) {
	WebsiteUpdatesTestsTestWebsiteUpdatesAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (WebsiteUpdatesTestsTestWebsiteUpdatesAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _website_updates_tests_test_website_updates_async (WebsiteUpdatesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	WebsiteUpdatesTestsTestWebsiteUpdatesAsyncData* _data_;
	_data_ = g_slice_new0 (WebsiteUpdatesTestsTestWebsiteUpdatesAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _website_updates_tests_test_website_updates_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _website_updates_tests_test_website_updates_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_website_updates_tests_test_website_updates_async_co (_data_);
}


static void _website_updates_tests_test_website_updates_finish (WebsiteUpdatesTests* self, GAsyncResult* _res_) {
	WebsiteUpdatesTestsTestWebsiteUpdatesAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _website_updates_tests_test_website_updates_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	WebsiteUpdatesTestsTestWebsiteUpdatesAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_website_updates_tests_test_website_updates_async_co (data);
}


static void __website_updates_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_website_updates_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static gboolean _website_updates_tests_test_website_updates_async_co (WebsiteUpdatesTestsTestWebsiteUpdatesAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, _website_updates_tests_test_website_updates_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_aggregator_new ();
	_g_object_unref0 (data->self->priv->_aggregator);
	data->self->priv->_aggregator = data->_tmp1_;
	g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __website_updates_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, _website_updates_tests_test_website_updates_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("website-updates.vala:108: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void __website_updates_tests_notify_website_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_website_updates_tests_notify_website_cb (self, _sender, pspec);
}


static void _website_updates_tests_individuals_changed_cb (WebsiteUpdatesTests* self, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	g_return_if_fail (self != NULL);
	{
		GList* i_collection;
		GList* i_it;
		i_collection = added;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* i;
			i = (FolksIndividual*) i_it->data;
			{
				const gchar* _tmp0_ = NULL;
				_tmp0_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
				if (g_strcmp0 (_tmp0_, self->priv->_initial_fullname) == 0) {
					const gchar* _tmp1_ = NULL;
					gchar* _tmp2_;
					GList* _tmp3_ = NULL;
					g_signal_connect_object ((GObject*) i, "notify::urls", (GCallback) __website_updates_tests_notify_website_cb_g_object_notify, self, 0);
					_tmp1_ = folks_individual_get_id (i);
					_tmp2_ = g_strdup (_tmp1_);
					_g_free0 (self->priv->_individual_id);
					self->priv->_individual_id = _tmp2_;
					_tmp3_ = folks_url_details_get_urls ((FolksUrlDetails*) i);
					{
						GList* fd_collection;
						GList* fd_it;
						fd_collection = _tmp3_;
						for (fd_it = fd_collection; fd_it != NULL; fd_it = fd_it->next) {
							FolksFieldDetails* fd;
							fd = (FolksFieldDetails*) fd_it->data;
							{
								const gchar* _tmp4_ = NULL;
								gchar* _tmp5_;
								gchar* website;
								_tmp4_ = folks_field_details_get_value (fd);
								_tmp5_ = g_strdup (_tmp4_);
								website = _tmp5_;
								if (g_strcmp0 (website, self->priv->_initial_website) == 0) {
									gchar* _tmp6_;
									gchar* affl;
									self->priv->_initial_website_found = TRUE;
									_tmp6_ = g_strdup ("<affl:website>");
									affl = _tmp6_;
									tracker_test_backend_insert_triplet (self->priv->_tracker_backend, affl, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, TRF_ONTOLOGY_DEFS_NCO_WEBSITE, self->priv->_updated_website, NULL, NULL);
									tracker_test_backend_insert_triplet (self->priv->_tracker_backend, self->priv->_contact_urn, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, affl, NULL, NULL, NULL, NULL);
									_g_free0 (affl);
								}
								_g_free0 (website);
							}
						}
					}
				}
			}
		}
	}
	g_assert (removed == NULL);
}


static void _website_updates_tests_notify_website_cb (WebsiteUpdatesTests* self, GObject* individual_obj, GParamSpec* ps) {
	FolksIndividual* _tmp0_;
	FolksIndividual* i;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual_obj != NULL);
	g_return_if_fail (ps != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_INDIVIDUAL (individual_obj));
	i = _tmp0_;
	_tmp1_ = folks_url_details_get_urls ((FolksUrlDetails*) i);
	{
		GList* fd_collection;
		GList* fd_it;
		fd_collection = _tmp1_;
		for (fd_it = fd_collection; fd_it != NULL; fd_it = fd_it->next) {
			FolksFieldDetails* fd;
			fd = (FolksFieldDetails*) fd_it->data;
			{
				const gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				gchar* website;
				_tmp2_ = folks_field_details_get_value (fd);
				_tmp3_ = g_strdup (_tmp2_);
				website = _tmp3_;
				if (g_strcmp0 (website, self->priv->_updated_website) == 0) {
					self->priv->_updated_website_found = TRUE;
					g_main_loop_quit (self->priv->_main_loop);
				}
				_g_free0 (website);
			}
		}
	}
	_g_object_unref0 (i);
}


static void website_updates_tests_class_init (WebsiteUpdatesTestsClass * klass) {
	website_updates_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (WebsiteUpdatesTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = website_updates_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = website_updates_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = website_updates_tests_finalize;
}


static void website_updates_tests_instance_init (WebsiteUpdatesTests * self) {
	self->priv = WEBSITE_UPDATES_TESTS_GET_PRIVATE (self);
}


static void website_updates_tests_finalize (GObject* obj) {
	WebsiteUpdatesTests * self;
	self = WEBSITE_UPDATES_TESTS (obj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_object_unref0 (self->priv->_aggregator);
	_g_free0 (self->priv->_updated_website);
	_g_free0 (self->priv->_individual_id);
	_g_free0 (self->priv->_initial_fullname);
	_g_free0 (self->priv->_initial_website);
	_g_free0 (self->priv->_contact_urn);
	G_OBJECT_CLASS (website_updates_tests_parent_class)->finalize (obj);
}


GType website_updates_tests_get_type (void) {
	static volatile gsize website_updates_tests_type_id__volatile = 0;
	if (g_once_init_enter (&website_updates_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WebsiteUpdatesTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) website_updates_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WebsiteUpdatesTests), 0, (GInstanceInitFunc) website_updates_tests_instance_init, NULL };
		GType website_updates_tests_type_id;
		website_updates_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "WebsiteUpdatesTests", &g_define_type_info, 0);
		g_once_init_leave (&website_updates_tests_type_id__volatile, website_updates_tests_type_id);
	}
	return website_updates_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	WebsiteUpdatesTests* _tmp1_ = NULL;
	WebsiteUpdatesTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = website_updates_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



