// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_PROXYADDRESS_H
#define _GIOMM_PROXYADDRESS_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2009 The glibmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <giomm/inetsocketaddress.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GProxyAddress GProxyAddress;
typedef struct _GProxyAddressClass GProxyAddressClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class ProxyAddress_Class; } // namespace Gio
namespace Gio
{

/** ProxyAddress - An internet address with proxy information.
 * Support for proxied InetSocketAddress.
 *
 * @ingroup NetworkIO
 * @newin{2,28}
 */

class ProxyAddress
: public InetSocketAddress
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ProxyAddress CppObjectType;
  typedef ProxyAddress_Class CppClassType;
  typedef GProxyAddress BaseObjectType;
  typedef GProxyAddressClass BaseClassType;

private:  friend class ProxyAddress_Class;
  static CppClassType proxyaddress_class_;

private:
  // noncopyable
  ProxyAddress(const ProxyAddress&);
  ProxyAddress& operator=(const ProxyAddress&);

protected:
  explicit ProxyAddress(const Glib::ConstructParams& construct_params);
  explicit ProxyAddress(GProxyAddress* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ProxyAddress();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GProxyAddress*       gobj()       { return reinterpret_cast<GProxyAddress*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GProxyAddress* gobj() const { return reinterpret_cast<GProxyAddress*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GProxyAddress* gobj_copy();

private:


protected:
  explicit ProxyAddress(const Glib::RefPtr<InetAddress>& address,
    guint16 port,
    const Glib::ustring& protocol,
    const Glib::ustring& destination_hostname,
    guint16 destination_port,
    const Glib::ustring& username = Glib::ustring(),
    const Glib::ustring& password = Glib::ustring());

public:
  
  static Glib::RefPtr<ProxyAddress> create(const Glib::RefPtr<InetAddress>& address, guint16 port, const Glib::ustring& protocol, const Glib::ustring& destination_hostname, guint16 destination_port, const Glib::ustring& username =  Glib::ustring(), const Glib::ustring& password =  Glib::ustring());


  /** Gets @a proxy's protocol.
   * 
   * @newin{2,26}
   * @return The @a proxy's protocol.
   */
  Glib::ustring get_protocol() const;
  
  /** Gets @a proxy's destination hostname.
   * 
   * @newin{2,26}
   * @return The @a proxy's destination hostname.
   */
  Glib::ustring get_destination_hostname() const;
  
  /** Gets @a proxy's destination port.
   * 
   * @newin{2,26}
   * @return The @a proxy's destination port.
   */
  guint16 get_destination_port() const;

  
  /** Gets @a proxy's username.
   * 
   * @newin{2,26}
   * @return The @a proxy's username.
   */
  Glib::ustring get_username() const;
  
  /** Gets @a proxy's password.
   * 
   * @newin{2,26}
   * @return The @a proxy's password.
   */
  Glib::ustring get_password() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The proxy protocol.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_protocol() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The proxy destination hostname.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_destination_hostname() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


//TODO: This should really be a guint16:
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The proxy destination port.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_destination_port() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The proxy username.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_username() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The proxy password.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_password() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::ProxyAddress
   */
  Glib::RefPtr<Gio::ProxyAddress> wrap(GProxyAddress* object, bool take_copy = false);
}


#endif /* _GIOMM_PROXYADDRESS_H */

