/* vnc-display.c generated by valac 0.39.5, the Vala compiler
 * generated from vnc-display.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libcommon.h>
#include <stdlib.h>
#include <string.h>
#include <gtk-vnc.h>
#include <libxml/uri.h>
#include <glib/gi18n-lib.h>


#define BOXES_TYPE_IPROPERTIES_PROVIDER (boxes_iproperties_provider_get_type ())
#define BOXES_IPROPERTIES_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER, BoxesIPropertiesProvider))
#define BOXES_IS_IPROPERTIES_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER))
#define BOXES_IPROPERTIES_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER, BoxesIPropertiesProviderIface))

typedef struct _BoxesIPropertiesProvider BoxesIPropertiesProvider;
typedef struct _BoxesIPropertiesProviderIface BoxesIPropertiesProviderIface;

#define BOXES_TYPE_PROPERTIES_PAGE (boxes_properties_page_get_type ())

#define BOXES_TYPE_PROPERTY (boxes_property_get_type ())
#define BOXES_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_PROPERTY, BoxesProperty))
#define BOXES_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_PROPERTY, BoxesPropertyClass))
#define BOXES_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_PROPERTY))
#define BOXES_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_PROPERTY))
#define BOXES_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_PROPERTY, BoxesPropertyClass))

typedef struct _BoxesProperty BoxesProperty;
typedef struct _BoxesPropertyClass BoxesPropertyClass;

#define BOXES_TYPE_DISPLAY (boxes_display_get_type ())
#define BOXES_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY, BoxesDisplay))
#define BOXES_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY, BoxesDisplayClass))
#define BOXES_IS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY))
#define BOXES_IS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY))
#define BOXES_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY, BoxesDisplayClass))

typedef struct _BoxesDisplay BoxesDisplay;
typedef struct _BoxesDisplayClass BoxesDisplayClass;
typedef struct _BoxesDisplayPrivate BoxesDisplayPrivate;

#define BOXES_TYPE_VNC_DISPLAY (boxes_vnc_display_get_type ())
#define BOXES_VNC_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplay))
#define BOXES_VNC_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplayClass))
#define BOXES_IS_VNC_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VNC_DISPLAY))
#define BOXES_IS_VNC_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VNC_DISPLAY))
#define BOXES_VNC_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplayClass))

typedef struct _BoxesVncDisplay BoxesVncDisplay;
typedef struct _BoxesVncDisplayClass BoxesVncDisplayClass;
typedef struct _BoxesVncDisplayPrivate BoxesVncDisplayPrivate;
enum  {
	BOXES_VNC_DISPLAY_0_PROPERTY,
	BOXES_VNC_DISPLAY_PROTOCOL_PROPERTY,
	BOXES_VNC_DISPLAY_URI_PROPERTY,
	BOXES_VNC_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* boxes_vnc_display_properties[BOXES_VNC_DISPLAY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmlFreeURI0(var) ((var == NULL) ? NULL : (var = (xmlFreeURI (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

typedef enum  {
	BOXES_PROPERTIES_PAGE_GENERAL,
	BOXES_PROPERTIES_PAGE_SYSTEM,
	BOXES_PROPERTIES_PAGE_DEVICES,
	BOXES_PROPERTIES_PAGE_SNAPSHOTS,
	BOXES_PROPERTIES_PAGE_LAST
} BoxesPropertiesPage;

struct _BoxesIPropertiesProviderIface {
	GTypeInterface parent_iface;
	GList* (*get_properties) (BoxesIPropertiesProvider* self, BoxesPropertiesPage page);
};

typedef gint (*BoxesDisplayOpenFDFunc) (void* user_data);
struct _BoxesDisplay {
	GObject parent_instance;
	BoxesDisplayPrivate * priv;
	gboolean connected;
	GHashTable* displays;
};

struct _BoxesDisplayClass {
	GObjectClass parent_class;
	GtkWidget* (*get_display) (BoxesDisplay* self, gint n);
	GdkPixbuf* (*get_pixbuf) (BoxesDisplay* self, gint n, GError** error);
	void (*set_enable_audio) (BoxesDisplay* self, gboolean enable);
	gboolean (*should_keep_alive) (BoxesDisplay* self);
	void (*connect_it) (BoxesDisplay* self, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify, GError** error);
	void (*disconnect_it) (BoxesDisplay* self);
	void (*collect_logs) (BoxesDisplay* self, GString* builder);
	void (*send_keys) (BoxesDisplay* self, guint* keyvals, int keyvals_length1);
	GList* (*get_properties) (BoxesDisplay* self, BoxesPropertiesPage page);
	const gchar* (*get_protocol) (BoxesDisplay* self);
	gchar* (*get_uri) (BoxesDisplay* self);
};

struct _BoxesVncDisplay {
	BoxesDisplay parent_instance;
	BoxesVncDisplayPrivate * priv;
};

struct _BoxesVncDisplayClass {
	BoxesDisplayClass parent_class;
};

struct _BoxesVncDisplayPrivate {
	VncDisplay* display;
	gchar* host;
	gint port;
	GtkWindow* window;
	BoxesBoxConfigSavedProperty* saved_properties;
	gint saved_properties_length1;
	gint _saved_properties_size_;
};


static gpointer boxes_vnc_display_parent_class = NULL;

GType boxes_properties_page_get_type (void) G_GNUC_CONST;
GType boxes_property_get_type (void) G_GNUC_CONST;
GType boxes_iproperties_provider_get_type (void) G_GNUC_CONST;
GType boxes_display_get_type (void) G_GNUC_CONST;
GType boxes_vnc_display_get_type (void) G_GNUC_CONST;
#define BOXES_VNC_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplayPrivate))
static void _vala_BoxesBoxConfigSavedProperty_array_free (BoxesBoxConfigSavedProperty * array,
                                                   gint array_length);
BoxesVncDisplay* boxes_vnc_display_new (BoxesBoxConfig* config,
                                        const gchar* host,
                                        gint port);
BoxesVncDisplay* boxes_vnc_display_construct (GType object_type,
                                              BoxesBoxConfig* config,
                                              const gchar* host,
                                              gint port);
BoxesDisplay* boxes_display_construct (GType object_type);
void boxes_display_set_config (BoxesDisplay* self,
                               BoxesBoxConfig* value);
BoxesVncDisplay* boxes_vnc_display_new_with_uri (BoxesBoxConfig* config,
                                                 const gchar* _uri,
                                                 GError** error);
BoxesVncDisplay* boxes_vnc_display_construct_with_uri (GType object_type,
                                                       BoxesBoxConfig* config,
                                                       const gchar* _uri,
                                                       GError** error);
static GtkWidget* boxes_vnc_display_real_get_display (BoxesDisplay* base,
                                               gint n);
static void boxes_vnc_display_real_set_enable_audio (BoxesDisplay* base,
                                              gboolean enable);
static GdkPixbuf* boxes_vnc_display_real_get_pixbuf (BoxesDisplay* base,
                                              gint n,
                                              GError** error);
static void boxes_vnc_display_real_connect_it (BoxesDisplay* base,
                                        BoxesDisplayOpenFDFunc open_fd,
                                        void* open_fd_target,
                                        GDestroyNotify open_fd_target_destroy_notify,
                                        GError** error);
const gchar* boxes_display_get_username (BoxesDisplay* self);
const gchar* boxes_display_get_password (BoxesDisplay* self);
static void boxes_vnc_display_real_disconnect_it (BoxesDisplay* base);
static GList* boxes_vnc_display_real_get_properties (BoxesDisplay* base,
                                              BoxesPropertiesPage page);
BoxesProperty* boxes_iproperties_provider_add_property (BoxesIPropertiesProvider* self,
                                                        GList* * list,
                                                        const gchar* name,
                                                        GtkWidget* widget,
                                                        GtkWidget* extra_widget);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void boxes_vnc_display_real_send_keys (BoxesDisplay* base,
                                       guint* keyvals,
                                       int keyvals_length1);
static GObject * boxes_vnc_display_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
void boxes_display_set_need_password (BoxesDisplay* self,
                                      gboolean value);
static void _boxes_vnc_display___lambda81_ (BoxesVncDisplay* self);
void boxes_display_access_start (BoxesDisplay* self);
static void __boxes_vnc_display___lambda81__vnc_display_vnc_initialized (VncDisplay* _sender,
                                                                  gpointer self);
static void _boxes_vnc_display___lambda82_ (BoxesVncDisplay* self);
void boxes_display_access_finish (BoxesDisplay* self);
static void __boxes_vnc_display___lambda82__vnc_display_vnc_disconnected (VncDisplay* _sender,
                                                                   gpointer self);
static void _boxes_vnc_display___lambda83_ (BoxesVncDisplay* self);
static void __boxes_vnc_display___lambda83__vnc_display_vnc_auth_failure (VncDisplay* _sender,
                                                                   const gchar* object,
                                                                   gpointer self);
static void _boxes_vnc_display___lambda84_ (BoxesVncDisplay* self);
static void __boxes_vnc_display___lambda84__vnc_display_vnc_auth_unsupported (VncDisplay* _sender,
                                                                       guint object,
                                                                       gpointer self);
static void _boxes_vnc_display___lambda85_ (BoxesVncDisplay* self,
                                     GValueArray* creds);
void boxes_display_set_need_username (BoxesDisplay* self,
                                      gboolean value);
const gchar* vnc_display_credential_to_string (VncDisplayCredential self);
static void __boxes_vnc_display___lambda85__vnc_display_vnc_auth_credential (VncDisplay* _sender,
                                                                      GValueArray* credList,
                                                                      gpointer self);
static void boxes_vnc_display_finalize (GObject * obj);
const gchar* boxes_display_get_protocol (BoxesDisplay* self);
gchar* boxes_display_get_uri (BoxesDisplay* self);
static void _vala_boxes_vnc_display_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);


static void
_vala_BoxesBoxConfigSavedProperty_array_free (BoxesBoxConfigSavedProperty * array,
                                              gint array_length)
{
#line 12 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (array != NULL) {
#line 226 "vnc-display.c"
		int i;
#line 12 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 12 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			boxes_box_config_saved_property_destroy (&array[i]);
#line 232 "vnc-display.c"
		}
	}
#line 12 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_free (array);
#line 237 "vnc-display.c"
}


BoxesVncDisplay*
boxes_vnc_display_construct (GType object_type,
                             BoxesBoxConfig* config,
                             const gchar* host,
                             gint port)
{
	BoxesVncDisplay * self = NULL;
	gchar* _tmp0_;
	VncDisplay* _tmp1_;
	BoxesBoxConfigSavedProperty* _tmp2_;
	gint _tmp2__length1;
#line 74 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 74 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 74 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) boxes_display_construct (object_type);
#line 75 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, config);
#line 77 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = g_strdup (host);
#line 77 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_free0 (self->priv->host);
#line 77 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->host = _tmp0_;
#line 78 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->port = port;
#line 80 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = self->priv->display;
#line 80 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = self->priv->saved_properties;
#line 80 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2__length1 = self->priv->saved_properties_length1;
#line 80 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_box_config_save_properties (config, (GObject*) _tmp1_, _tmp2_, _tmp2__length1);
#line 74 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return self;
#line 278 "vnc-display.c"
}


BoxesVncDisplay*
boxes_vnc_display_new (BoxesBoxConfig* config,
                       const gchar* host,
                       gint port)
{
#line 74 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return boxes_vnc_display_construct (BOXES_TYPE_VNC_DISPLAY, config, host, port);
#line 289 "vnc-display.c"
}


BoxesVncDisplay*
boxes_vnc_display_construct_with_uri (GType object_type,
                                      BoxesBoxConfig* config,
                                      const gchar* _uri,
                                      GError** error)
{
	BoxesVncDisplay * self = NULL;
	xmlURI* uri = NULL;
	xmlURI* _tmp0_;
	xmlURI* _tmp1_;
	const gchar* _tmp2_;
	xmlURI* _tmp4_;
	const gchar* _tmp5_;
	xmlURI* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_ = 0;
	xmlURI* _tmp11_;
	gint _tmp12_;
	VncDisplay* _tmp15_;
	BoxesBoxConfigSavedProperty* _tmp16_;
	gint _tmp16__length1;
	GError * _inner_error_ = NULL;
#line 83 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 83 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_return_val_if_fail (_uri != NULL, NULL);
#line 83 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) boxes_display_construct (object_type);
#line 84 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, config);
#line 86 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = xmlParseURI (_uri);
#line 86 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	uri = _tmp0_;
#line 88 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = uri;
#line 88 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = _tmp1_->scheme;
#line 88 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (g_strcmp0 (_tmp2_, "vnc") != 0) {
#line 334 "vnc-display.c"
		GError* _tmp3_;
#line 89 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp3_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, "the URL is not vnc://");
#line 89 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_inner_error_ = _tmp3_;
#line 89 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		if (_inner_error_->domain == BOXES_ERROR) {
#line 89 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_propagate_error (error, _inner_error_);
#line 89 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_xmlFreeURI0 (uri);
#line 89 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_g_object_unref0 (self);
#line 89 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			return NULL;
#line 350 "vnc-display.c"
		} else {
#line 89 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_xmlFreeURI0 (uri);
#line 89 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 89 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_clear_error (&_inner_error_);
#line 89 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			return NULL;
#line 360 "vnc-display.c"
		}
	}
#line 91 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp4_ = uri;
#line 91 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp5_ = _tmp4_->server;
#line 91 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (_tmp5_ == NULL) {
#line 369 "vnc-display.c"
		GError* _tmp6_;
#line 92 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp6_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, "the URL is missing a server");
#line 92 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_inner_error_ = _tmp6_;
#line 92 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		if (_inner_error_->domain == BOXES_ERROR) {
#line 92 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_propagate_error (error, _inner_error_);
#line 92 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_xmlFreeURI0 (uri);
#line 92 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_g_object_unref0 (self);
#line 92 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			return NULL;
#line 385 "vnc-display.c"
		} else {
#line 92 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_xmlFreeURI0 (uri);
#line 92 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 92 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_clear_error (&_inner_error_);
#line 92 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			return NULL;
#line 395 "vnc-display.c"
		}
	}
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp7_ = uri;
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp8_ = _tmp7_->server;
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_free0 (self->priv->host);
#line 94 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->host = _tmp9_;
#line 95 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp11_ = uri;
#line 95 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp12_ = _tmp11_->port;
#line 95 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (_tmp12_ <= 0) {
#line 95 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp10_ = 5900;
#line 416 "vnc-display.c"
	} else {
		xmlURI* _tmp13_;
		gint _tmp14_;
#line 95 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp13_ = uri;
#line 95 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp14_ = _tmp13_->port;
#line 95 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp10_ = _tmp14_;
#line 426 "vnc-display.c"
	}
#line 95 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->port = _tmp10_;
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp15_ = self->priv->display;
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp16_ = self->priv->saved_properties;
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp16__length1 = self->priv->saved_properties_length1;
#line 97 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_box_config_save_properties (config, (GObject*) _tmp15_, _tmp16_, _tmp16__length1);
#line 83 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_xmlFreeURI0 (uri);
#line 83 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return self;
#line 442 "vnc-display.c"
}


BoxesVncDisplay*
boxes_vnc_display_new_with_uri (BoxesBoxConfig* config,
                                const gchar* _uri,
                                GError** error)
{
#line 83 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return boxes_vnc_display_construct_with_uri (BOXES_TYPE_VNC_DISPLAY, config, _uri, error);
#line 453 "vnc-display.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 103 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return self ? g_object_ref (self) : NULL;
#line 462 "vnc-display.c"
}


static GtkWidget*
boxes_vnc_display_real_get_display (BoxesDisplay* base,
                                    gint n)
{
	BoxesVncDisplay * self;
	GtkWidget* result = NULL;
	GtkWindow* _tmp0_;
	VncDisplay* _tmp1_;
	VncDisplay* _tmp2_;
	GtkWidget* _tmp3_;
#line 100 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 101 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->window;
#line 101 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = self->priv->display;
#line 101 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp1_);
#line 103 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = self->priv->display;
#line 103 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
#line 103 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	result = _tmp3_;
#line 103 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return result;
#line 492 "vnc-display.c"
}


static void
boxes_vnc_display_real_set_enable_audio (BoxesDisplay* base,
                                         gboolean enable)
{
	BoxesVncDisplay * self;
#line 106 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 503 "vnc-display.c"
}


static GdkPixbuf*
boxes_vnc_display_real_get_pixbuf (BoxesDisplay* base,
                                   gint n,
                                   GError** error)
{
	BoxesVncDisplay * self;
	GdkPixbuf* result = NULL;
	VncDisplay* _tmp0_;
	GdkPixbuf* _tmp1_;
#line 109 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 110 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->display;
#line 110 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = vnc_display_get_pixbuf (_tmp0_);
#line 110 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	result = _tmp1_;
#line 110 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return result;
#line 526 "vnc-display.c"
}


static void
boxes_vnc_display_real_connect_it (BoxesDisplay* base,
                                   BoxesDisplayOpenFDFunc open_fd,
                                   void* open_fd_target,
                                   GDestroyNotify open_fd_target_destroy_notify,
                                   GError** error)
{
	BoxesVncDisplay * self;
	gboolean _tmp0_;
	VncDisplay* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	VncDisplay* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	VncDisplay* _tmp7_;
#line 113 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 115 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = ((BoxesDisplay*) self)->connected;
#line 115 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (_tmp0_) {
#line 116 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
#line 116 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		open_fd = NULL;
#line 116 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		open_fd_target = NULL;
#line 116 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		open_fd_target_destroy_notify = NULL;
#line 116 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		return;
#line 562 "vnc-display.c"
	}
#line 117 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplay*) self)->connected = TRUE;
#line 120 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = self->priv->display;
#line 120 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = boxes_display_get_username ((BoxesDisplay*) self);
#line 120 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = _tmp2_;
#line 120 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_credential (_tmp1_, (gint) VNC_DISPLAY_CREDENTIAL_USERNAME, _tmp3_);
#line 121 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp4_ = self->priv->display;
#line 121 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp5_ = boxes_display_get_password ((BoxesDisplay*) self);
#line 121 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp6_ = _tmp5_;
#line 121 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_credential (_tmp4_, (gint) VNC_DISPLAY_CREDENTIAL_PASSWORD, _tmp6_);
#line 122 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp7_ = self->priv->display;
#line 122 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_credential (_tmp7_, (gint) VNC_DISPLAY_CREDENTIAL_CLIENTNAME, "boxes");
#line 124 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (open_fd != NULL) {
#line 588 "vnc-display.c"
		gint fd = 0;
		VncDisplay* _tmp8_;
		gint _tmp9_;
		const gchar* _tmp10_;
#line 125 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		fd = open_fd (open_fd_target);
#line 126 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp8_ = self->priv->display;
#line 126 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp9_ = fd;
#line 126 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp10_ = self->priv->host;
#line 126 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		vnc_display_open_fd_with_hostname (_tmp8_, _tmp9_, _tmp10_);
#line 603 "vnc-display.c"
	} else {
		VncDisplay* _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 128 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp11_ = self->priv->display;
#line 128 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp12_ = self->priv->host;
#line 128 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp13_ = self->priv->port;
#line 128 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp14_ = g_strdup_printf ("%i", _tmp13_);
#line 128 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp15_ = _tmp14_;
#line 128 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		vnc_display_open_host (_tmp11_, _tmp12_, _tmp15_);
#line 128 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_g_free0 (_tmp15_);
#line 624 "vnc-display.c"
	}
#line 113 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
#line 113 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	open_fd = NULL;
#line 113 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	open_fd_target = NULL;
#line 113 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	open_fd_target_destroy_notify = NULL;
#line 634 "vnc-display.c"
}


static void
boxes_vnc_display_real_disconnect_it (BoxesDisplay* base)
{
	BoxesVncDisplay * self;
	VncDisplay* _tmp0_;
#line 131 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 132 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->display;
#line 132 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	if (vnc_display_is_open (_tmp0_)) {
#line 649 "vnc-display.c"
		VncDisplay* _tmp1_;
#line 133 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		_tmp1_ = self->priv->display;
#line 133 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		vnc_display_close (_tmp1_);
#line 655 "vnc-display.c"
	}
}


static void
_g_object_unref0_ (gpointer var)
{
#line 136 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 665 "vnc-display.c"
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 136 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 674 "vnc-display.c"
}


static GList*
boxes_vnc_display_real_get_properties (BoxesDisplay* base,
                                       BoxesPropertiesPage page)
{
	BoxesVncDisplay * self;
	GList* result = NULL;
	GList* list = NULL;
#line 136 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 137 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	list = NULL;
#line 139 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	switch (page) {
#line 139 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		case BOXES_PROPERTIES_PAGE_GENERAL:
#line 693 "vnc-display.c"
		{
			GtkSwitch* toggle = NULL;
			GtkSwitch* _tmp0_;
			GtkSwitch* _tmp1_;
			VncDisplay* _tmp2_;
			GtkSwitch* _tmp3_;
			GtkSwitch* _tmp4_;
			BoxesProperty* _tmp5_;
			BoxesProperty* _tmp6_;
#line 141 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_tmp0_ = (GtkSwitch*) gtk_switch_new ();
#line 141 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_object_ref_sink (_tmp0_);
#line 141 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			toggle = _tmp0_;
#line 142 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_tmp1_ = toggle;
#line 142 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_START);
#line 143 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_tmp2_ = self->priv->display;
#line 143 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_tmp3_ = toggle;
#line 143 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			g_object_bind_property_with_closures ((GObject*) _tmp2_, "read-only", (GObject*) _tmp3_, "active", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 145 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_tmp4_ = toggle;
#line 145 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_tmp5_ = boxes_iproperties_provider_add_property ((BoxesIPropertiesProvider*) self, &list, _ ("Read-only"), (GtkWidget*) _tmp4_, NULL);
#line 145 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_tmp6_ = _tmp5_;
#line 145 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_g_object_unref0 (_tmp6_);
#line 146 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			_g_object_unref0 (toggle);
#line 146 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			break;
#line 731 "vnc-display.c"
		}
		default:
#line 139 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		break;
#line 736 "vnc-display.c"
	}
#line 149 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	result = list;
#line 149 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return result;
#line 742 "vnc-display.c"
}


static void
boxes_vnc_display_real_send_keys (BoxesDisplay* base,
                                  guint* keyvals,
                                  int keyvals_length1)
{
	BoxesVncDisplay * self;
	VncDisplay* _tmp0_;
#line 152 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 153 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->display;
#line 153 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_send_keys (_tmp0_, keyvals, keyvals_length1);
#line 759 "vnc-display.c"
}


static const gchar*
boxes_vnc_display_real_get_protocol (BoxesDisplay* base)
{
	const gchar* result;
	BoxesVncDisplay* self;
#line 6 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 6 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	result = "VNC";
#line 6 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return result;
#line 774 "vnc-display.c"
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1456 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1457 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	result = self;
#line 1457 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 788 "vnc-display.c"
}


static gchar*
boxes_vnc_display_real_get_uri (BoxesDisplay* base)
{
	gchar* result;
	BoxesVncDisplay* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = (BoxesVncDisplay*) base;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = self->priv->host;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp1_ = string_to_string (_tmp0_);
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_ = self->priv->port;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp4_ = _tmp3_;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp5_ = g_strconcat ("vnc://", _tmp1_, ":", _tmp4_, NULL);
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp6_ = _tmp5_;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_free0 (_tmp4_);
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	result = _tmp6_;
#line 7 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return result;
#line 826 "vnc-display.c"
}


static void
_boxes_vnc_display___lambda81_ (BoxesVncDisplay* self)
{
#line 33 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_emit_by_name ((BoxesDisplay*) self, "show", 0);
#line 34 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_display_access_start ((BoxesDisplay*) self);
#line 837 "vnc-display.c"
}


static void
__boxes_vnc_display___lambda81__vnc_display_vnc_initialized (VncDisplay* _sender,
                                                             gpointer self)
{
#line 32 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda81_ ((BoxesVncDisplay*) self);
#line 847 "vnc-display.c"
}


static void
_boxes_vnc_display___lambda82_ (BoxesVncDisplay* self)
{
#line 37 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_emit_by_name ((BoxesDisplay*) self, "hide", 0);
#line 38 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_display_access_finish ((BoxesDisplay*) self);
#line 858 "vnc-display.c"
}


static void
__boxes_vnc_display___lambda82__vnc_display_vnc_disconnected (VncDisplay* _sender,
                                                              gpointer self)
{
#line 36 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda82_ ((BoxesVncDisplay*) self);
#line 868 "vnc-display.c"
}


static void
_boxes_vnc_display___lambda83_ (BoxesVncDisplay* self)
{
#line 42 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_debug ("vnc-display.vala:42: auth failure");
#line 877 "vnc-display.c"
}


static void
__boxes_vnc_display___lambda83__vnc_display_vnc_auth_failure (VncDisplay* _sender,
                                                              const gchar* object,
                                                              gpointer self)
{
#line 41 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda83_ ((BoxesVncDisplay*) self);
#line 888 "vnc-display.c"
}


static void
_boxes_vnc_display___lambda84_ (BoxesVncDisplay* self)
{
#line 45 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_debug ("vnc-display.vala:45: auth unsupported");
#line 897 "vnc-display.c"
}


static void
__boxes_vnc_display___lambda84__vnc_display_vnc_auth_unsupported (VncDisplay* _sender,
                                                                  guint object,
                                                                  gpointer self)
{
#line 44 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda84_ ((BoxesVncDisplay*) self);
#line 908 "vnc-display.c"
}


static void
_boxes_vnc_display___lambda85_ (BoxesVncDisplay* self,
                                GValueArray* creds)
{
	VncDisplay* _tmp6_;
#line 48 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_return_if_fail (creds != NULL);
#line 919 "vnc-display.c"
	{
		GValueArray* cred_collection = NULL;
		guint cred_index = 0U;
#line 49 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		cred_collection = creds;
#line 49 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		for (cred_index = 0; cred_index < cred_collection->n_values; cred_index = cred_index + 1) {
#line 927 "vnc-display.c"
			GValue cred = {0};
#line 49 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
			cred = *g_value_array_get_nth (cred_collection, cred_index);
#line 931 "vnc-display.c"
			{
				VncDisplayCredential credential = 0;
				GValue _tmp0_;
				VncDisplayCredential _tmp1_;
#line 50 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
				_tmp0_ = cred;
#line 50 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
				credential = g_value_get_enum (&_tmp0_);
#line 52 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
				_tmp1_ = credential;
#line 52 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
				switch (_tmp1_) {
#line 52 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
					case VNC_DISPLAY_CREDENTIAL_USERNAME:
#line 946 "vnc-display.c"
					{
#line 54 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						boxes_display_set_need_username ((BoxesDisplay*) self, TRUE);
#line 55 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						break;
#line 952 "vnc-display.c"
					}
#line 52 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
					case VNC_DISPLAY_CREDENTIAL_PASSWORD:
#line 956 "vnc-display.c"
					{
#line 58 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						boxes_display_set_need_password ((BoxesDisplay*) self, TRUE);
#line 59 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						break;
#line 962 "vnc-display.c"
					}
#line 52 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
					case VNC_DISPLAY_CREDENTIAL_CLIENTNAME:
#line 966 "vnc-display.c"
					{
#line 62 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						break;
#line 970 "vnc-display.c"
					}
					default:
					{
						VncDisplayCredential _tmp2_;
						GEnumValue* _tmp3_;
						gchar* _tmp4_;
						gchar* _tmp5_;
#line 65 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						_tmp2_ = credential;
#line 65 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						_tmp3_ = g_enum_get_value (g_type_class_ref (vnc_display_credential_get_type ()), _tmp2_);
#line 65 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						_tmp4_ = g_strdup_printf ("Unsupported credential: %s", (_tmp3_ != NULL) ? _tmp3_->value_name : NULL);
#line 65 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						_tmp5_ = _tmp4_;
#line 65 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						g_debug ("vnc-display.vala:65: %s", _tmp5_);
#line 65 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						_g_free0 (_tmp5_);
#line 66 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
						break;
#line 992 "vnc-display.c"
					}
				}
			}
		}
	}
#line 70 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp6_ = self->priv->display;
#line 70 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_close (_tmp6_);
#line 1002 "vnc-display.c"
}


static void
__boxes_vnc_display___lambda85__vnc_display_vnc_auth_credential (VncDisplay* _sender,
                                                                 GValueArray* credList,
                                                                 gpointer self)
{
#line 48 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_boxes_vnc_display___lambda85_ ((BoxesVncDisplay*) self, credList);
#line 1013 "vnc-display.c"
}


static GObject *
boxes_vnc_display_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BoxesVncDisplay * self;
	gchar* _tmp0_;
	GValue _tmp1_ = {0};
	BoxesBoxConfigSavedProperty _tmp2_ = {0};
	BoxesBoxConfigSavedProperty* _tmp3_;
	VncDisplay* _tmp4_;
	VncDisplay* _tmp5_;
	VncDisplay* _tmp6_;
	VncDisplay* _tmp7_;
	VncDisplay* _tmp8_;
	GtkWindow* _tmp9_;
	GtkWindow* _tmp10_;
	VncDisplay* _tmp11_;
	VncDisplay* _tmp12_;
	VncDisplay* _tmp13_;
	VncDisplay* _tmp14_;
	VncDisplay* _tmp15_;
	VncDisplay* _tmp16_;
	VncDisplay* _tmp17_;
#line 14 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	parent_class = G_OBJECT_CLASS (boxes_vnc_display_parent_class);
#line 14 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 14 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplay);
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp0_ = g_strdup ("read-only");
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_value_init (&_tmp1_, G_TYPE_BOOLEAN);
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_value_set_boolean (&_tmp1_, FALSE);
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	memset (&_tmp2_, 0, sizeof (BoxesBoxConfigSavedProperty));
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_free0 (_tmp2_.name);
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_.name = _tmp0_;
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	G_IS_VALUE (&_tmp2_.default_value) ? (g_value_unset (&_tmp2_.default_value), NULL) : NULL;
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp2_.default_value = _tmp1_;
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp3_ = g_new0 (BoxesBoxConfigSavedProperty, 1);
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp3_[0] = _tmp2_;
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->saved_properties = (_vala_BoxesBoxConfigSavedProperty_array_free (self->priv->saved_properties, self->priv->saved_properties_length1), NULL);
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->saved_properties = _tmp3_;
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->saved_properties_length1 = 1;
#line 15 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->_saved_properties_size_ = self->priv->saved_properties_length1;
#line 18 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_display_set_need_password ((BoxesDisplay*) self, FALSE);
#line 20 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp4_ = (VncDisplay*) vnc_display_new ();
#line 20 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_object_ref_sink (_tmp4_);
#line 20 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_object_unref0 (self->priv->display);
#line 20 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->display = _tmp4_;
#line 21 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp5_ = self->priv->display;
#line 21 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_keyboard_grab (_tmp5_, TRUE);
#line 22 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp6_ = self->priv->display;
#line 22 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_pointer_grab (_tmp6_, TRUE);
#line 23 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp7_ = self->priv->display;
#line 23 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_force_size (_tmp7_, FALSE);
#line 24 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp8_ = self->priv->display;
#line 24 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	vnc_display_set_scaling (_tmp8_, TRUE);
#line 28 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp9_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
#line 28 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_object_ref_sink (_tmp9_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_object_unref0 (self->priv->window);
#line 28 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->window = _tmp9_;
#line 29 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp10_ = self->priv->window;
#line 29 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp11_ = self->priv->display;
#line 29 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
#line 30 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp12_ = self->priv->display;
#line 30 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	gtk_widget_realize ((GtkWidget*) _tmp12_);
#line 32 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp13_ = self->priv->display;
#line 32 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp13_, "vnc-initialized", (GCallback) __boxes_vnc_display___lambda81__vnc_display_vnc_initialized, self, 0);
#line 36 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp14_ = self->priv->display;
#line 36 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp14_, "vnc-disconnected", (GCallback) __boxes_vnc_display___lambda82__vnc_display_vnc_disconnected, self, 0);
#line 41 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp15_ = self->priv->display;
#line 41 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp15_, "vnc-auth-failure", (GCallback) __boxes_vnc_display___lambda83__vnc_display_vnc_auth_failure, self, 0);
#line 44 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp16_ = self->priv->display;
#line 44 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp16_, "vnc-auth-unsupported", (GCallback) __boxes_vnc_display___lambda84__vnc_display_vnc_auth_unsupported, self, 0);
#line 48 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_tmp17_ = self->priv->display;
#line 48 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_signal_connect_object (_tmp17_, "vnc-auth-credential", (GCallback) __boxes_vnc_display___lambda85__vnc_display_vnc_auth_credential, self, 0);
#line 14 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	return obj;
#line 1143 "vnc-display.c"
}


static void
boxes_vnc_display_class_init (BoxesVncDisplayClass * klass)
{
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	boxes_vnc_display_parent_class = g_type_class_peek_parent (klass);
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_type_class_add_private (klass, sizeof (BoxesVncDisplayPrivate));
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->get_display = (GtkWidget* (*) (BoxesDisplay *, gint)) boxes_vnc_display_real_get_display;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->set_enable_audio = (void (*) (BoxesDisplay *, gboolean)) boxes_vnc_display_real_set_enable_audio;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->get_pixbuf = (GdkPixbuf* (*) (BoxesDisplay *, gint, GError**)) boxes_vnc_display_real_get_pixbuf;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->connect_it = (void (*) (BoxesDisplay *, BoxesDisplayOpenFDFunc, void*, GDestroyNotify, GError**)) boxes_vnc_display_real_connect_it;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->disconnect_it = (void (*) (BoxesDisplay *)) boxes_vnc_display_real_disconnect_it;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->get_properties = (GList* (*) (BoxesDisplay *, BoxesPropertiesPage)) boxes_vnc_display_real_get_properties;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	((BoxesDisplayClass *) klass)->send_keys = (void (*) (BoxesDisplay *, guint*, int)) boxes_vnc_display_real_send_keys;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_protocol = boxes_vnc_display_real_get_protocol;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_uri = boxes_vnc_display_real_get_uri;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_vnc_display_get_property;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	G_OBJECT_CLASS (klass)->constructor = boxes_vnc_display_constructor;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_vnc_display_finalize;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_VNC_DISPLAY_PROTOCOL_PROPERTY, boxes_vnc_display_properties[BOXES_VNC_DISPLAY_PROTOCOL_PROPERTY] = g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_VNC_DISPLAY_URI_PROPERTY, boxes_vnc_display_properties[BOXES_VNC_DISPLAY_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1182 "vnc-display.c"
}


static void
boxes_vnc_display_instance_init (BoxesVncDisplay * self)
{
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv = BOXES_VNC_DISPLAY_GET_PRIVATE (self);
#line 1191 "vnc-display.c"
}


static void
boxes_vnc_display_finalize (GObject * obj)
{
	BoxesVncDisplay * self;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplay);
#line 8 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_object_unref0 (self->priv->display);
#line 9 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_free0 (self->priv->host);
#line 11 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	_g_object_unref0 (self->priv->window);
#line 12 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	self->priv->saved_properties = (_vala_BoxesBoxConfigSavedProperty_array_free (self->priv->saved_properties, self->priv->saved_properties_length1), NULL);
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	G_OBJECT_CLASS (boxes_vnc_display_parent_class)->finalize (obj);
#line 1211 "vnc-display.c"
}


GType
boxes_vnc_display_get_type (void)
{
	static volatile gsize boxes_vnc_display_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_vnc_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesVncDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_vnc_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesVncDisplay), 0, (GInstanceInitFunc) boxes_vnc_display_instance_init, NULL };
		GType boxes_vnc_display_type_id;
		boxes_vnc_display_type_id = g_type_register_static (BOXES_TYPE_DISPLAY, "BoxesVncDisplay", &g_define_type_info, 0);
		g_once_init_leave (&boxes_vnc_display_type_id__volatile, boxes_vnc_display_type_id);
	}
	return boxes_vnc_display_type_id__volatile;
}


static void
_vala_boxes_vnc_display_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	BoxesVncDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplay);
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
	switch (property_id) {
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		case BOXES_VNC_DISPLAY_PROTOCOL_PROPERTY:
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		g_value_set_string (value, boxes_display_get_protocol ((BoxesDisplay*) self));
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		break;
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		case BOXES_VNC_DISPLAY_URI_PROPERTY:
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		g_value_take_string (value, boxes_display_get_uri ((BoxesDisplay*) self));
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		break;
#line 1251 "vnc-display.c"
		default:
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 5 "/home/fborges/checkout/gnome-boxes/src/vnc-display.vala"
		break;
#line 1257 "vnc-display.c"
	}
}



