/* vm-configurator.c generated by valac 0.15.0.11-e8f32, the Vala compiler
 * generated from vm-configurator.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <osinfo/osinfo.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <config.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <unistd.h>
#include <gobject/gvaluecollector.h>


#define BOXES_TYPE_VM_CONFIGURATOR (boxes_vm_configurator_get_type ())
#define BOXES_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator))
#define BOXES_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))
#define BOXES_IS_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_IS_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_VM_CONFIGURATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))

typedef struct _BoxesVMConfigurator BoxesVMConfigurator;
typedef struct _BoxesVMConfiguratorClass BoxesVMConfiguratorClass;
typedef struct _BoxesVMConfiguratorPrivate BoxesVMConfiguratorPrivate;

#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BOXES_TYPE_UNATTENDED_INSTALLER (boxes_unattended_installer_get_type ())
#define BOXES_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstaller))
#define BOXES_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))
#define BOXES_IS_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_IS_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_UNATTENDED_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))

typedef struct _BoxesUnattendedInstaller BoxesUnattendedInstaller;
typedef struct _BoxesUnattendedInstallerClass BoxesUnattendedInstallerClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _BoxesUnattendedInstallerPrivate BoxesUnattendedInstallerPrivate;

#define BOXES_TYPE_WIN7_INSTALLER (boxes_win7_installer_get_type ())
#define BOXES_WIN7_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_WIN7_INSTALLER, BoxesWin7Installer))
#define BOXES_WIN7_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_WIN7_INSTALLER, BoxesWin7InstallerClass))
#define BOXES_IS_WIN7_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_WIN7_INSTALLER))
#define BOXES_IS_WIN7_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_WIN7_INSTALLER))
#define BOXES_WIN7_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_WIN7_INSTALLER, BoxesWin7InstallerClass))

typedef struct _BoxesWin7Installer BoxesWin7Installer;
typedef struct _BoxesWin7InstallerClass BoxesWin7InstallerClass;
typedef struct _BoxesParamSpecVMConfigurator BoxesParamSpecVMConfigurator;

struct _BoxesVMConfigurator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesVMConfiguratorPrivate * priv;
};

struct _BoxesVMConfiguratorClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesVMConfigurator *self);
};

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
};

struct _BoxesUnattendedInstaller {
	BoxesInstallerMedia parent_instance;
	BoxesUnattendedInstallerPrivate * priv;
	gchar* kernel_path;
	gchar* initrd_path;
	gchar* _floppy_path;
	gchar* unattended_src_path;
	gchar* unattended_dest_name;
	GDataStreamNewlineType newline_type;
	GtkTable* setup_table;
	GtkLabel* setup_label;
	GtkHBox* setup_hbox;
	GtkSwitch* express_toggle;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	gchar* timezone;
	gchar* kbd;
	gchar* lang;
};

struct _BoxesUnattendedInstallerClass {
	BoxesInstallerMediaClass parent_class;
	void (*populate_setup_vbox) (BoxesUnattendedInstaller* self, GtkVBox* setup_vbox);
	void (*setup_ui) (BoxesUnattendedInstaller* self);
	void (*clean_up) (BoxesUnattendedInstaller* self, GError** error);
	gchar* (*fill_unattended_data) (BoxesUnattendedInstaller* self, const gchar* data, GError** error);
	void (*prepare_direct_boot) (BoxesUnattendedInstaller* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_direct_boot_finish) (BoxesUnattendedInstaller* self, GAsyncResult* _res_, GError** error);
};

struct _BoxesParamSpecVMConfigurator {
	GParamSpec parent_instance;
};


static gpointer boxes_vm_configurator_parent_class = NULL;

gpointer boxes_vm_configurator_ref (gpointer instance);
void boxes_vm_configurator_unref (gpointer instance);
GParamSpec* boxes_param_spec_vm_configurator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_vm_configurator (GValue* value, gpointer v_object);
void boxes_value_take_vm_configurator (GValue* value, gpointer v_object);
gpointer boxes_value_get_vm_configurator (const GValue* value);
GType boxes_vm_configurator_get_type (void) G_GNUC_CONST;
enum  {
	BOXES_VM_CONFIGURATOR_DUMMY_PROPERTY
};
GType boxes_installer_media_get_type (void) G_GNUC_CONST;
GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesVMConfigurator* self, BoxesInstallerMedia* install_media, const gchar* name, const gchar* target_path, OsinfoResources* resources);
static void boxes_vm_configurator_set_os_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_target_media_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, const gchar* target_path);
static void boxes_vm_configurator_set_unattended_floppy_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_source_media_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_video_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
void boxes_vm_configurator_post_install_setup (BoxesVMConfigurator* self, GVirConfigDomain* domain);
GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (BoxesVMConfigurator* self, const gchar* name, gint64 storage, GError** error);
static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (BoxesVMConfigurator* self);
GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (BoxesVMConfigurator* self, GError** error);
gchar* boxes_get_pkgconfig (const gchar* file_name);
void boxes_ensure_directory (const gchar* dir);
GType boxes_unattended_installer_get_type (void) G_GNUC_CONST;
const gchar* boxes_unattended_installer_get_floppy_path (BoxesUnattendedInstaller* self);
static void boxes_vm_configurator_set_direct_boot_params (BoxesVMConfigurator* self, GVirConfigDomainOs* os, BoxesInstallerMedia* install_media);
GType boxes_win7_installer_get_type (void) G_GNUC_CONST;
BoxesVMConfigurator* boxes_vm_configurator_new (void);
BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type);
static void boxes_vm_configurator_finalize (BoxesVMConfigurator* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesVMConfigurator* self, BoxesInstallerMedia* install_media, const gchar* name, const gchar* target_path, OsinfoResources* resources) {
	GVirConfigDomain* result = NULL;
	GVirConfigDomain* _tmp0_;
	GVirConfigDomain* domain;
	GVirConfigDomain* _tmp1_;
	const gchar* _tmp2_;
	GVirConfigDomain* _tmp3_;
	OsinfoResources* _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	GVirConfigDomain* _tmp7_;
	OsinfoResources* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GVirConfigDomain* _tmp11_;
	GVirConfigDomain* _tmp12_;
	BoxesInstallerMedia* _tmp13_;
	GVirConfigDomain* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_ = NULL;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GVirConfigDomainClock* _tmp20_;
	GVirConfigDomainClock* clock;
	gboolean _tmp21_ = FALSE;
	BoxesInstallerMedia* _tmp22_;
	OsinfoOs* _tmp23_;
	gboolean _tmp29_;
	GVirConfigDomain* _tmp32_;
	GVirConfigDomainClock* _tmp33_;
	GVirConfigDomain* _tmp34_;
	const gchar* _tmp35_;
	GVirConfigDomain* _tmp36_;
	BoxesInstallerMedia* _tmp37_;
	GVirConfigDomain* _tmp38_;
	BoxesInstallerMedia* _tmp39_;
	GVirConfigDomainInput* _tmp40_;
	GVirConfigDomainInput* input;
	GVirConfigDomain* _tmp41_;
	GVirConfigDomainGraphicsSpice* _tmp42_;
	GVirConfigDomainGraphicsSpice* graphics;
	GVirConfigDomain* _tmp43_;
	GVirConfigDomain* _tmp44_;
	BoxesInstallerMedia* _tmp45_;
	GVirConfigDomain* _tmp46_;
	GVirConfigDomain* _tmp47_;
	GVirConfigDomain* _tmp48_;
	GVirConfigDomainConsole* _tmp49_;
	GVirConfigDomainConsole* console;
	GVirConfigDomainChardevSourcePty* _tmp50_;
	GVirConfigDomainChardevSourcePty* _tmp51_;
	GVirConfigDomain* _tmp52_;
	GVirConfigDomainInterfaceUser* _tmp53_;
	GVirConfigDomainInterfaceUser* iface;
	GVirConfigDomain* _tmp54_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (install_media != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (target_path != NULL, NULL);
	g_return_val_if_fail (resources != NULL, NULL);
	_tmp0_ = gvir_config_domain_new ();
	domain = _tmp0_;
	_tmp1_ = domain;
	_tmp2_ = name;
	gvir_config_domain_set_name (_tmp1_, _tmp2_);
	_tmp3_ = domain;
	_tmp4_ = resources;
	_tmp5_ = osinfo_resources_get_ram (_tmp4_);
	_tmp6_ = _tmp5_;
	gvir_config_domain_set_memory (_tmp3_, (guint64) (_tmp6_ / OSINFO_KIBIBYTES));
	_tmp7_ = domain;
	_tmp8_ = resources;
	_tmp9_ = osinfo_resources_get_n_cpus (_tmp8_);
	_tmp10_ = _tmp9_;
	g_object_set (_tmp7_, "vcpu", (guint64) _tmp10_, NULL);
	_tmp11_ = domain;
	gvir_config_domain_set_virt_type (_tmp11_, GVIR_CONFIG_DOMAIN_VIRT_KVM);
	_tmp12_ = domain;
	_tmp13_ = install_media;
	boxes_vm_configurator_set_os_config (self, _tmp12_, _tmp13_);
	_tmp14_ = domain;
	_tmp15_ = g_strdup ("acpi");
	_tmp16_ = g_strdup ("apic");
	_tmp17_ = g_strdup ("pae");
	_tmp18_ = g_new0 (gchar*, 3 + 1);
	_tmp18_[0] = _tmp15_;
	_tmp18_[1] = _tmp16_;
	_tmp18_[2] = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 3;
	gvir_config_domain_set_features (_tmp14_, _tmp19_);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	_tmp20_ = gvir_config_domain_clock_new ();
	clock = _tmp20_;
	_tmp22_ = install_media;
	_tmp23_ = _tmp22_->os;
	if (_tmp23_ != NULL) {
		BoxesInstallerMedia* _tmp24_;
		OsinfoOs* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gboolean _tmp28_ = FALSE;
		_tmp24_ = install_media;
		_tmp25_ = _tmp24_->os;
		_tmp26_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = string_contains (_tmp27_, "win");
		_tmp21_ = _tmp28_;
	} else {
		_tmp21_ = FALSE;
	}
	_tmp29_ = _tmp21_;
	if (_tmp29_) {
		GVirConfigDomainClock* _tmp30_;
		_tmp30_ = clock;
		gvir_config_domain_clock_set_offset (_tmp30_, GVIR_CONFIG_DOMAIN_CLOCK_LOCALTIME);
	} else {
		GVirConfigDomainClock* _tmp31_;
		_tmp31_ = clock;
		gvir_config_domain_clock_set_offset (_tmp31_, GVIR_CONFIG_DOMAIN_CLOCK_UTC);
	}
	_tmp32_ = domain;
	_tmp33_ = clock;
	gvir_config_domain_set_clock (_tmp32_, _tmp33_);
	_tmp34_ = domain;
	_tmp35_ = target_path;
	boxes_vm_configurator_set_target_media_config (self, _tmp34_, _tmp35_);
	_tmp36_ = domain;
	_tmp37_ = install_media;
	boxes_vm_configurator_set_unattended_floppy_config (self, _tmp36_, _tmp37_);
	_tmp38_ = domain;
	_tmp39_ = install_media;
	boxes_vm_configurator_set_source_media_config (self, _tmp38_, _tmp39_);
	_tmp40_ = gvir_config_domain_input_new ();
	input = _tmp40_;
	gvir_config_domain_input_set_bus (input, GVIR_CONFIG_DOMAIN_INPUT_BUS_USB);
	gvir_config_domain_input_set_device_type (input, GVIR_CONFIG_DOMAIN_INPUT_DEVICE_TABLET);
	_tmp41_ = domain;
	gvir_config_domain_add_device (_tmp41_, (GVirConfigDomainDevice*) input);
	_tmp42_ = gvir_config_domain_graphics_spice_new ();
	graphics = _tmp42_;
	gvir_config_domain_graphics_spice_set_autoport (graphics, TRUE);
	_tmp43_ = domain;
	gvir_config_domain_add_device (_tmp43_, (GVirConfigDomainDevice*) graphics);
	_tmp44_ = domain;
	_tmp45_ = install_media;
	boxes_vm_configurator_set_video_config (self, _tmp44_, _tmp45_);
	_tmp46_ = domain;
	gvir_config_domain_set_lifecycle (_tmp46_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_POWEROFF, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
	_tmp47_ = domain;
	gvir_config_domain_set_lifecycle (_tmp47_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
	_tmp48_ = domain;
	gvir_config_domain_set_lifecycle (_tmp48_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_CRASH, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
	_tmp49_ = gvir_config_domain_console_new ();
	console = _tmp49_;
	_tmp50_ = gvir_config_domain_chardev_source_pty_new ();
	_tmp51_ = _tmp50_;
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) console, (GVirConfigDomainChardevSource*) _tmp51_);
	_g_object_unref0 (_tmp51_);
	_tmp52_ = domain;
	gvir_config_domain_add_device (_tmp52_, (GVirConfigDomainDevice*) console);
	_tmp53_ = gvir_config_domain_interface_user_new ();
	iface = _tmp53_;
	_tmp54_ = domain;
	gvir_config_domain_add_device (_tmp54_, (GVirConfigDomainDevice*) iface);
	result = domain;
	_g_object_unref0 (iface);
	_g_object_unref0 (console);
	_g_object_unref0 (graphics);
	_g_object_unref0 (input);
	_g_object_unref0 (clock);
	return result;
}


void boxes_vm_configurator_post_install_setup (BoxesVMConfigurator* self, GVirConfigDomain* domain) {
	GVirConfigDomain* _tmp0_;
	GVirConfigDomain* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	_tmp0_ = domain;
	boxes_vm_configurator_set_os_config (self, _tmp0_, NULL);
	_tmp1_ = domain;
	gvir_config_domain_set_lifecycle (_tmp1_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_RESTART);
}


GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (BoxesVMConfigurator* self, const gchar* name, gint64 storage, GError** error) {
	GVirConfigStorageVol* result = NULL;
	GVirConfigStorageVol* _tmp0_;
	GVirConfigStorageVol* volume;
	const gchar* _tmp1_;
	gint64 _tmp2_;
	GVirConfigStorageVolTarget* _tmp3_;
	GVirConfigStorageVolTarget* target;
	GVirConfigStoragePermissions* _tmp4_ = NULL;
	GVirConfigStoragePermissions* permissions;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gvir_config_storage_vol_new ();
	volume = _tmp0_;
	_tmp1_ = name;
	gvir_config_storage_vol_set_name (volume, _tmp1_);
	_tmp2_ = storage;
	gvir_config_storage_vol_set_capacity (volume, (guint64) _tmp2_);
	_tmp3_ = gvir_config_storage_vol_target_new ();
	target = _tmp3_;
	gvir_config_storage_vol_target_set_format (target, "qcow2");
	_tmp4_ = boxes_vm_configurator_get_default_permissions (self);
	permissions = _tmp4_;
	gvir_config_storage_vol_target_set_permissions (target, permissions);
	gvir_config_storage_vol_set_target (volume, target);
	result = volume;
	_g_object_unref0 (permissions);
	_g_object_unref0 (target);
	return result;
}


GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (BoxesVMConfigurator* self, GError** error) {
	GVirConfigStoragePool* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* pool_path;
	GVirConfigStoragePool* _tmp1_;
	GVirConfigStoragePool* pool;
	GVirConfigStoragePoolSource* _tmp2_;
	GVirConfigStoragePoolSource* source;
	GVirConfigStoragePoolTarget* _tmp3_;
	GVirConfigStoragePoolTarget* target;
	GVirConfigStoragePermissions* _tmp4_ = NULL;
	GVirConfigStoragePermissions* permissions;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = boxes_get_pkgconfig ("images");
	pool_path = _tmp0_;
	boxes_ensure_directory (pool_path);
	_tmp1_ = gvir_config_storage_pool_new ();
	pool = _tmp1_;
	gvir_config_storage_pool_set_pool_type (pool, GVIR_CONFIG_STORAGE_POOL_TYPE_DIR);
	gvir_config_storage_pool_set_name (pool, PACKAGE_TARNAME);
	_tmp2_ = gvir_config_storage_pool_source_new ();
	source = _tmp2_;
	gvir_config_storage_pool_source_set_directory (source, pool_path);
	gvir_config_storage_pool_set_source (pool, source);
	_tmp3_ = gvir_config_storage_pool_target_new ();
	target = _tmp3_;
	gvir_config_storage_pool_target_set_path (target, pool_path);
	_tmp4_ = boxes_vm_configurator_get_default_permissions (self);
	permissions = _tmp4_;
	gvir_config_storage_pool_target_set_permissions (target, permissions);
	gvir_config_storage_pool_set_target (pool, target);
	result = pool;
	_g_object_unref0 (permissions);
	_g_object_unref0 (target);
	_g_object_unref0 (source);
	_g_free0 (pool_path);
	return result;
}


static void boxes_vm_configurator_set_target_media_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, const gchar* target_path) {
	GVirConfigDomainDisk* _tmp0_;
	GVirConfigDomainDisk* disk;
	const gchar* _tmp1_;
	GVirConfigDomain* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (target_path != NULL);
	_tmp0_ = gvir_config_domain_disk_new ();
	disk = _tmp0_;
	gvir_config_domain_disk_set_type (disk, GVIR_CONFIG_DOMAIN_DISK_FILE);
	gvir_config_domain_disk_set_guest_device_type (disk, GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_DISK);
	gvir_config_domain_disk_set_driver_name (disk, "qemu");
	gvir_config_domain_disk_set_driver_type (disk, "qcow2");
	_tmp1_ = target_path;
	gvir_config_domain_disk_set_source (disk, _tmp1_);
	gvir_config_domain_disk_set_target_dev (disk, "hda");
	gvir_config_domain_disk_set_target_bus (disk, GVIR_CONFIG_DOMAIN_DISK_BUS_IDE);
	_tmp2_ = domain;
	gvir_config_domain_add_device (_tmp2_, (GVirConfigDomainDevice*) disk);
	_g_object_unref0 (disk);
}


static void boxes_vm_configurator_set_source_media_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainDisk* _tmp0_;
	GVirConfigDomainDisk* disk;
	GVirConfigDomainDisk* _tmp1_;
	GVirConfigDomainDisk* _tmp2_;
	GVirConfigDomainDisk* _tmp3_;
	GVirConfigDomainDisk* _tmp4_;
	BoxesInstallerMedia* _tmp5_;
	const gchar* _tmp6_;
	GVirConfigDomainDisk* _tmp7_;
	GVirConfigDomainDisk* _tmp8_;
	BoxesInstallerMedia* _tmp9_;
	gboolean _tmp10_;
	GVirConfigDomain* _tmp13_;
	GVirConfigDomainDisk* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = gvir_config_domain_disk_new ();
	disk = _tmp0_;
	_tmp1_ = disk;
	gvir_config_domain_disk_set_guest_device_type (_tmp1_, GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_CDROM);
	_tmp2_ = disk;
	gvir_config_domain_disk_set_driver_name (_tmp2_, "qemu");
	_tmp3_ = disk;
	gvir_config_domain_disk_set_driver_type (_tmp3_, "raw");
	_tmp4_ = disk;
	_tmp5_ = install_media;
	_tmp6_ = _tmp5_->device_file;
	gvir_config_domain_disk_set_source (_tmp4_, _tmp6_);
	_tmp7_ = disk;
	gvir_config_domain_disk_set_target_dev (_tmp7_, "hdc");
	_tmp8_ = disk;
	gvir_config_domain_disk_set_target_bus (_tmp8_, GVIR_CONFIG_DOMAIN_DISK_BUS_IDE);
	_tmp9_ = install_media;
	_tmp10_ = _tmp9_->from_image;
	if (_tmp10_) {
		GVirConfigDomainDisk* _tmp11_;
		_tmp11_ = disk;
		gvir_config_domain_disk_set_type (_tmp11_, GVIR_CONFIG_DOMAIN_DISK_FILE);
	} else {
		GVirConfigDomainDisk* _tmp12_;
		_tmp12_ = disk;
		gvir_config_domain_disk_set_type (_tmp12_, GVIR_CONFIG_DOMAIN_DISK_BLOCK);
	}
	_tmp13_ = domain;
	_tmp14_ = disk;
	gvir_config_domain_add_device (_tmp13_, (GVirConfigDomainDevice*) _tmp14_);
	_g_object_unref0 (disk);
}


static void boxes_vm_configurator_set_unattended_floppy_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	BoxesInstallerMedia* _tmp0_;
	BoxesInstallerMedia* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* floppy_path;
	const gchar* _tmp5_;
	GVirConfigDomainDisk* _tmp6_;
	GVirConfigDomainDisk* disk;
	GVirConfigDomainDisk* _tmp7_;
	GVirConfigDomainDisk* _tmp8_;
	GVirConfigDomainDisk* _tmp9_;
	GVirConfigDomainDisk* _tmp10_;
	GVirConfigDomainDisk* _tmp11_;
	const gchar* _tmp12_;
	GVirConfigDomainDisk* _tmp13_;
	GVirConfigDomain* _tmp14_;
	GVirConfigDomainDisk* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = install_media;
	if (!BOXES_IS_UNATTENDED_INSTALLER (_tmp0_)) {
		return;
	}
	_tmp1_ = install_media;
	_tmp2_ = boxes_unattended_installer_get_floppy_path (BOXES_IS_UNATTENDED_INSTALLER (_tmp1_) ? ((BoxesUnattendedInstaller*) _tmp1_) : NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	floppy_path = _tmp4_;
	_tmp5_ = floppy_path;
	if (_tmp5_ == NULL) {
		_g_free0 (floppy_path);
		return;
	}
	_tmp6_ = gvir_config_domain_disk_new ();
	disk = _tmp6_;
	_tmp7_ = disk;
	gvir_config_domain_disk_set_type (_tmp7_, GVIR_CONFIG_DOMAIN_DISK_FILE);
	_tmp8_ = disk;
	gvir_config_domain_disk_set_guest_device_type (_tmp8_, GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_FLOPPY);
	_tmp9_ = disk;
	gvir_config_domain_disk_set_driver_name (_tmp9_, "qemu");
	_tmp10_ = disk;
	gvir_config_domain_disk_set_driver_type (_tmp10_, "raw");
	_tmp11_ = disk;
	_tmp12_ = floppy_path;
	gvir_config_domain_disk_set_source (_tmp11_, _tmp12_);
	_tmp13_ = disk;
	gvir_config_domain_disk_set_target_dev (_tmp13_, "fd");
	_tmp14_ = domain;
	_tmp15_ = disk;
	gvir_config_domain_add_device (_tmp14_, (GVirConfigDomainDevice*) _tmp15_);
	_g_object_unref0 (disk);
	_g_free0 (floppy_path);
}


static void boxes_vm_configurator_set_os_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainOs* _tmp0_;
	GVirConfigDomainOs* os;
	GVirConfigDomainOs* _tmp1_;
	GVirConfigDomainOs* _tmp2_;
	GList* boot_devices;
	BoxesInstallerMedia* _tmp3_;
	GVirConfigDomainOs* _tmp6_;
	GList* _tmp7_;
	GVirConfigDomain* _tmp8_;
	GVirConfigDomainOs* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	_tmp0_ = gvir_config_domain_os_new ();
	os = _tmp0_;
	_tmp1_ = os;
	gvir_config_domain_os_set_os_type (_tmp1_, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
	_tmp2_ = os;
	gvir_config_domain_os_set_arch (_tmp2_, "x86_64");
	boot_devices = NULL;
	_tmp3_ = install_media;
	if (_tmp3_ != NULL) {
		GVirConfigDomainOs* _tmp4_;
		BoxesInstallerMedia* _tmp5_;
		_tmp4_ = os;
		_tmp5_ = install_media;
		boxes_vm_configurator_set_direct_boot_params (self, _tmp4_, _tmp5_);
		boot_devices = g_list_append (boot_devices, GINT_TO_POINTER (GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
	}
	boot_devices = g_list_append (boot_devices, GINT_TO_POINTER (GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_HD));
	_tmp6_ = os;
	_tmp7_ = boot_devices;
	gvir_config_domain_os_set_boot_devices (_tmp6_, _tmp7_);
	_tmp8_ = domain;
	_tmp9_ = os;
	gvir_config_domain_set_os (_tmp8_, _tmp9_);
	_g_list_free0 (boot_devices);
	_g_object_unref0 (os);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void boxes_vm_configurator_set_direct_boot_params (BoxesVMConfigurator* self, GVirConfigDomainOs* os, BoxesInstallerMedia* install_media) {
	BoxesInstallerMedia* _tmp0_;
	BoxesInstallerMedia* _tmp1_;
	BoxesUnattendedInstaller* _tmp2_;
	BoxesUnattendedInstaller* unattended;
	BoxesUnattendedInstaller* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* kernel_path;
	BoxesUnattendedInstaller* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* initrd_path;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gboolean _tmp12_;
	GVirConfigDomainOs* _tmp13_;
	const gchar* _tmp14_;
	GVirConfigDomainOs* _tmp15_;
	const gchar* _tmp16_;
	GVirConfigDomainOs* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = install_media;
	if (!BOXES_IS_UNATTENDED_INSTALLER (_tmp0_)) {
		return;
	}
	_tmp1_ = install_media;
	_tmp2_ = _g_object_ref0 (BOXES_IS_UNATTENDED_INSTALLER (_tmp1_) ? ((BoxesUnattendedInstaller*) _tmp1_) : NULL);
	unattended = _tmp2_;
	_tmp3_ = unattended;
	_tmp4_ = _tmp3_->kernel_path;
	_tmp5_ = g_strdup (_tmp4_);
	kernel_path = _tmp5_;
	_tmp6_ = unattended;
	_tmp7_ = _tmp6_->initrd_path;
	_tmp8_ = g_strdup (_tmp7_);
	initrd_path = _tmp8_;
	_tmp10_ = kernel_path;
	if (_tmp10_ == NULL) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp11_;
		_tmp11_ = initrd_path;
		_tmp9_ = _tmp11_ == NULL;
	}
	_tmp12_ = _tmp9_;
	if (_tmp12_) {
		_g_free0 (initrd_path);
		_g_free0 (kernel_path);
		_g_object_unref0 (unattended);
		return;
	}
	_tmp13_ = os;
	_tmp14_ = kernel_path;
	gvir_config_domain_os_set_kernel (_tmp13_, _tmp14_);
	_tmp15_ = os;
	_tmp16_ = initrd_path;
	gvir_config_domain_os_set_ramdisk (_tmp15_, _tmp16_);
	_tmp17_ = os;
	gvir_config_domain_os_set_cmdline (_tmp17_, "ks=floppy");
	_g_free0 (initrd_path);
	_g_free0 (kernel_path);
	_g_object_unref0 (unattended);
}


static void boxes_vm_configurator_set_video_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainVideo* _tmp0_;
	GVirConfigDomainVideo* video;
	BoxesInstallerMedia* _tmp1_;
	GVirConfigDomain* _tmp4_;
	GVirConfigDomainVideo* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = gvir_config_domain_video_new ();
	video = _tmp0_;
	_tmp1_ = install_media;
	if (BOXES_IS_WIN7_INSTALLER (_tmp1_)) {
		GVirConfigDomainVideo* _tmp2_;
		_tmp2_ = video;
		gvir_config_domain_video_set_model (_tmp2_, GVIR_CONFIG_DOMAIN_VIDEO_MODEL_VGA);
	} else {
		GVirConfigDomainVideo* _tmp3_;
		_tmp3_ = video;
		gvir_config_domain_video_set_model (_tmp3_, GVIR_CONFIG_DOMAIN_VIDEO_MODEL_QXL);
	}
	_tmp4_ = domain;
	_tmp5_ = video;
	gvir_config_domain_add_device (_tmp4_, (GVirConfigDomainDevice*) _tmp5_);
	_g_object_unref0 (video);
}


static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (BoxesVMConfigurator* self) {
	GVirConfigStoragePermissions* result = NULL;
	GVirConfigStoragePermissions* _tmp0_;
	GVirConfigStoragePermissions* permissions;
	uid_t _tmp1_ = {0};
	gid_t _tmp2_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gvir_config_storage_permissions_new ();
	permissions = _tmp0_;
	_tmp1_ = getuid ();
	gvir_config_storage_permissions_set_owner (permissions, (guint) _tmp1_);
	_tmp2_ = getgid ();
	gvir_config_storage_permissions_set_group (permissions, (guint) _tmp2_);
	gvir_config_storage_permissions_set_mode (permissions, (guint) 744);
	result = permissions;
	return result;
}


BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type) {
	BoxesVMConfigurator* self = NULL;
	self = (BoxesVMConfigurator*) g_type_create_instance (object_type);
	return self;
}


BoxesVMConfigurator* boxes_vm_configurator_new (void) {
	return boxes_vm_configurator_construct (BOXES_TYPE_VM_CONFIGURATOR);
}


static void boxes_value_vm_configurator_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void boxes_value_vm_configurator_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		boxes_vm_configurator_unref (value->data[0].v_pointer);
	}
}


static void boxes_value_vm_configurator_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = boxes_vm_configurator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer boxes_value_vm_configurator_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* boxes_value_vm_configurator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BoxesVMConfigurator* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = boxes_vm_configurator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* boxes_value_vm_configurator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BoxesVMConfigurator** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = boxes_vm_configurator_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* boxes_param_spec_vm_configurator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BoxesParamSpecVMConfigurator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_VM_CONFIGURATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer boxes_value_get_vm_configurator (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR), NULL);
	return value->data[0].v_pointer;
}


void boxes_value_set_vm_configurator (GValue* value, gpointer v_object) {
	BoxesVMConfigurator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		boxes_vm_configurator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_vm_configurator_unref (old);
	}
}


void boxes_value_take_vm_configurator (GValue* value, gpointer v_object) {
	BoxesVMConfigurator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_vm_configurator_unref (old);
	}
}


static void boxes_vm_configurator_class_init (BoxesVMConfiguratorClass * klass) {
	boxes_vm_configurator_parent_class = g_type_class_peek_parent (klass);
	BOXES_VM_CONFIGURATOR_CLASS (klass)->finalize = boxes_vm_configurator_finalize;
}


static void boxes_vm_configurator_instance_init (BoxesVMConfigurator * self) {
	self->ref_count = 1;
}


static void boxes_vm_configurator_finalize (BoxesVMConfigurator* obj) {
	BoxesVMConfigurator * self;
	self = BOXES_VM_CONFIGURATOR (obj);
}


GType boxes_vm_configurator_get_type (void) {
	static volatile gsize boxes_vm_configurator_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_vm_configurator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { boxes_value_vm_configurator_init, boxes_value_vm_configurator_free_value, boxes_value_vm_configurator_copy_value, boxes_value_vm_configurator_peek_pointer, "p", boxes_value_vm_configurator_collect_value, "p", boxes_value_vm_configurator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BoxesVMConfiguratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_vm_configurator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesVMConfigurator), 0, (GInstanceInitFunc) boxes_vm_configurator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType boxes_vm_configurator_type_id;
		boxes_vm_configurator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesVMConfigurator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&boxes_vm_configurator_type_id__volatile, boxes_vm_configurator_type_id);
	}
	return boxes_vm_configurator_type_id__volatile;
}


gpointer boxes_vm_configurator_ref (gpointer instance) {
	BoxesVMConfigurator* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void boxes_vm_configurator_unref (gpointer instance) {
	BoxesVMConfigurator* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BOXES_VM_CONFIGURATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



