/* vm-configurator.c generated by valac 0.20.1.16-ff48-dirty, the Vala compiler
 * generated from vm-configurator.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <gio/gio.h>
#include <libcommon.h>
#include <gtk/gtk.h>
#include <osinfo/osinfo.h>
#include <config.h>
#include <unistd.h>
#include <libxml/xmlreader.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define BOXES_TYPE_VM_CONFIGURATOR (boxes_vm_configurator_get_type ())
#define BOXES_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator))
#define BOXES_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))
#define BOXES_IS_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_IS_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_VM_CONFIGURATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))

typedef struct _BoxesVMConfigurator BoxesVMConfigurator;
typedef struct _BoxesVMConfiguratorClass BoxesVMConfiguratorClass;
typedef struct _BoxesVMConfiguratorPrivate BoxesVMConfiguratorPrivate;

#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _xmlFreeTextReader0(var) ((var == NULL) ? NULL : (var = (xmlFreeTextReader (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoxesParamSpecVMConfigurator BoxesParamSpecVMConfigurator;

typedef enum  {
	BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS
} BoxesVMConfiguratorError;
#define BOXES_VM_CONFIGURATOR_ERROR boxes_vm_configurator_error_quark ()
struct _BoxesVMConfigurator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesVMConfiguratorPrivate * priv;
};

struct _BoxesVMConfiguratorClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesVMConfigurator *self);
};

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
	void (*set_direct_boot_params) (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
	void (*prepare) (BoxesInstallerMedia* self, BoxesActivityProgress* progress, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_);
	void (*prepare_for_installation) (BoxesInstallerMedia* self, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_for_installation_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_, GError** error);
	void (*prepare_to_continue_installation) (BoxesInstallerMedia* self, const gchar* vm_name);
	void (*clean_up) (BoxesInstallerMedia* self);
	void (*clean_up_preparation_cache) (BoxesInstallerMedia* self);
	void (*setup_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*setup_post_install_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*populate_setup_vbox) (BoxesInstallerMedia* self, GtkBox* setup_vbox);
	GList* (*get_vm_properties) (BoxesInstallerMedia* self);
	OsinfoDeviceList* (*get_supported_devices) (BoxesInstallerMedia* self);
	guint64 (*get_installed_size) (BoxesInstallerMedia* self);
	gboolean (*get_need_user_input_for_vm_creation) (BoxesInstallerMedia* self);
	gboolean (*get_ready_to_create) (BoxesInstallerMedia* self);
};

struct _BoxesParamSpecVMConfigurator {
	GParamSpec parent_instance;
};


static gpointer boxes_vm_configurator_parent_class = NULL;

GQuark boxes_vm_configurator_error_quark (void);
gpointer boxes_vm_configurator_ref (gpointer instance);
void boxes_vm_configurator_unref (gpointer instance);
GParamSpec* boxes_param_spec_vm_configurator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_vm_configurator (GValue* value, gpointer v_object);
void boxes_value_take_vm_configurator (GValue* value, gpointer v_object);
gpointer boxes_value_get_vm_configurator (const GValue* value);
GType boxes_vm_configurator_get_type (void) G_GNUC_CONST;
enum  {
	BOXES_VM_CONFIGURATOR_DUMMY_PROPERTY
};
#define BOXES_VM_CONFIGURATOR_BOXES_NS "boxes"
#define BOXES_VM_CONFIGURATOR_BOXES_NS_URI "http://live.gnome.org/Boxes/"
#define BOXES_VM_CONFIGURATOR_BOXES_XML "<gnome-boxes>%s</gnome-boxes>"
#define BOXES_VM_CONFIGURATOR_LIVE_STATE "live"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "installation"
#define BOXES_VM_CONFIGURATOR_INSTALLED_STATE "installed"
#define BOXES_VM_CONFIGURATOR_LIVE_XML "<os-state>" BOXES_VM_CONFIGURATOR_LIVE_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLED_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLED_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_OS_ID_XML "<os-id>%s</os-id>"
#define BOXES_VM_CONFIGURATOR_MEDIA_ID_XML "<media-id>%s</media-id>"
#define BOXES_VM_CONFIGURATOR_NUM_REBOOTS_XML "<num-reboots>%u</num-reboots>"
GType boxes_installer_media_get_type (void) G_GNUC_CONST;
GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesInstallerMedia* install_media, const gchar* target_path, GVirConfigCapabilities* caps, GError** error);
static void boxes_vm_configurator_update_custom_xml (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, guint num_reboots, gboolean installed);
static GVirConfigCapabilitiesGuest* boxes_vm_configurator_get_best_guest_caps (GVirConfigCapabilities* caps, BoxesInstallerMedia* install_media, GError** error);
static void boxes_vm_configurator_set_cpu_config (GVirConfigDomain* domain, GVirConfigCapabilities* caps);
static gboolean boxes_vm_configurator_guest_kvm_enabled (GVirConfigCapabilitiesGuest* guest_caps);
static void boxes_vm_configurator_set_os_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, GVirConfigCapabilitiesGuest* guest_caps);
static gboolean boxes_vm_configurator_guest_supports_feature (GVirConfigCapabilitiesGuest* guest_caps, const gchar* feature_name);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value);
static void boxes_vm_configurator_set_target_media_config (GVirConfigDomain* domain, const gchar* target_path, BoxesInstallerMedia* install_media);
void boxes_installer_media_setup_domain_config (BoxesInstallerMedia* self, GVirConfigDomain* domain);
void boxes_vm_configurator_add_usb_support (GVirConfigDomain* domain);
void boxes_vm_configurator_add_smartcard_support (GVirConfigDomain* domain);
static void boxes_vm_configurator_set_video_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_sound_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_tablet_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
void boxes_vm_configurator_post_install_setup (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_post_install_os_config (GVirConfigDomain* domain);
void boxes_installer_media_setup_post_install_domain_config (BoxesInstallerMedia* self, GVirConfigDomain* domain);
static void boxes_vm_configurator_mark_as_installed (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
gboolean boxes_vm_configurator_is_install_config (GVirConfigDomain* domain);
static gchar* boxes_vm_configurator_get_os_state (GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_live_config (GVirConfigDomain* domain);
GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (const gchar* name, gint64 storage, GError** error);
static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (void);
GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (GError** error);
gchar* boxes_vm_configurator_get_os_id (GVirConfigDomain* domain);
static gchar* boxes_vm_configurator_get_custom_xml_node (GVirConfigDomain* domain, const gchar* node_name);
gchar* boxes_vm_configurator_get_os_media_id (GVirConfigDomain* domain);
guint boxes_vm_configurator_get_num_reboots (GVirConfigDomain* domain);
void boxes_vm_configurator_set_num_reboots (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, guint num_reboots);
gboolean boxes_installer_media_get_supports_virtio_disk (BoxesInstallerMedia* self);
void boxes_installer_media_set_direct_boot_params (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
OsinfoDevice* boxes_find_device_by_prop (OsinfoDeviceList* devices, const gchar* prop_name, const gchar* prop_value);
OsinfoDeviceList* boxes_installer_media_get_supported_devices (BoxesInstallerMedia* self);
gchar* boxes_vm_configurator_get_source_media_path (GVirConfigDomain* domain);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gboolean boxes_installer_media_get_live (BoxesInstallerMedia* self);
static GVirConfigDomainControllerUsb* boxes_vm_configurator_create_usb_controller (GVirConfigDomainControllerUsbModel model, GVirConfigDomainControllerUsb* master, guint index, guint start_port);
void boxes_vm_configurator_remove_usb_controllers (GVirConfigDomain* domain, GError** error);
gboolean boxes_installer_media_is_architecture_compatible (BoxesInstallerMedia* self, const gchar* architecture);
static gboolean boxes_vm_configurator_guest_is_qemu (GVirConfigCapabilitiesGuest* guest_caps);
BoxesVMConfigurator* boxes_vm_configurator_new (void);
BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type);
static void boxes_vm_configurator_finalize (BoxesVMConfigurator* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark boxes_vm_configurator_error_quark (void) {
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	return g_quark_from_static_string ("boxes_vm_configurator_error-quark");
#line 186 "vm-configurator.c"
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if ((*length) == (*size)) {
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 197 "vm-configurator.c"
	}
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[(*length)++] = value;
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[*length] = NULL;
#line 203 "vm-configurator.c"
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
#line 44 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if ((*length) == (*size)) {
#line 44 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 44 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 214 "vm-configurator.c"
	}
#line 44 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[(*length)++] = value;
#line 44 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[*length] = NULL;
#line 220 "vm-configurator.c"
}


static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value) {
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if ((*length) == (*size)) {
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 231 "vm-configurator.c"
	}
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[(*length)++] = value;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[*length] = NULL;
#line 237 "vm-configurator.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 1238 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1238 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1239 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1239 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1239 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1239 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 257 "vm-configurator.c"
}


GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesInstallerMedia* install_media, const gchar* target_path, GVirConfigCapabilities* caps, GError** error) {
	GVirConfigDomain* result = NULL;
	GVirConfigDomain* domain = NULL;
	GVirConfigDomain* _tmp0_;
	BoxesInstallerMedia* _tmp1_;
	GVirConfigCapabilitiesGuest* best_caps = NULL;
	GVirConfigCapabilities* _tmp2_;
	BoxesInstallerMedia* _tmp3_;
	GVirConfigCapabilitiesGuest* _tmp4_ = NULL;
	BoxesInstallerMedia* _tmp5_;
	OsinfoResources* _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	GVirConfigCapabilities* _tmp9_;
	GVirConfigDomainVirtType _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	GVirConfigDomainVirtType virt_type = 0;
	GVirConfigDomainVirtType _tmp12_;
	GVirConfigDomainVirtType _tmp13_;
	BoxesInstallerMedia* _tmp14_;
	gchar** features = NULL;
	gchar** _tmp15_ = NULL;
	gint features_length1;
	gint _features_size_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gchar** _tmp25_;
	gint _tmp25__length1;
	GVirConfigDomainClock* clock = NULL;
	GVirConfigDomainClock* _tmp26_;
	gboolean _tmp27_ = FALSE;
	BoxesInstallerMedia* _tmp28_;
	OsinfoOs* _tmp29_;
	gboolean _tmp35_;
	GVirConfigDomainTimer* timer = NULL;
	GVirConfigDomainTimerRtc* _tmp38_;
	GVirConfigDomainTimer* _tmp39_;
	GVirConfigDomainClock* _tmp40_;
	GVirConfigDomainTimer* _tmp41_;
	GVirConfigDomainTimerPit* _tmp42_;
	GVirConfigDomainTimer* _tmp43_;
	GVirConfigDomainClock* _tmp44_;
	GVirConfigDomainTimer* _tmp45_;
	GVirConfigDomainClock* _tmp46_;
	const gchar* _tmp47_;
	BoxesInstallerMedia* _tmp48_;
	BoxesInstallerMedia* _tmp49_;
	GVirConfigDomainGraphicsSpice* graphics = NULL;
	GVirConfigDomainGraphicsSpice* _tmp50_;
	GVirConfigDomainGraphicsSpice* _tmp51_;
	GVirConfigDomainGraphicsSpice* _tmp52_;
	GVirConfigDomainGraphicsSpice* _tmp53_;
	GVirConfigDomainChannel* channel = NULL;
	GVirConfigDomainChannel* _tmp54_;
	GVirConfigDomainChannel* _tmp55_;
	GVirConfigDomainChannel* _tmp56_;
	GVirConfigDomainChardevSourceSpiceVmc* vmc = NULL;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp57_;
	GVirConfigDomainChannel* _tmp58_;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp59_;
	GVirConfigDomainChannel* _tmp60_;
	BoxesInstallerMedia* _tmp61_;
	BoxesInstallerMedia* _tmp62_;
	BoxesInstallerMedia* _tmp63_;
	GVirConfigDomainPowerManagement* pm = NULL;
	GVirConfigDomainPowerManagement* _tmp64_;
	GVirConfigDomainPowerManagement* _tmp65_;
	GVirConfigDomainPowerManagement* _tmp66_;
	GVirConfigDomainPowerManagement* _tmp67_;
	GVirConfigDomainConsole* console = NULL;
	GVirConfigDomainConsole* _tmp68_;
	GVirConfigDomainConsole* _tmp69_;
	GVirConfigDomainChardevSourcePty* _tmp70_;
	GVirConfigDomainChardevSourcePty* _tmp71_;
	GVirConfigDomainConsole* _tmp72_;
	GVirConfigDomainInterfaceUser* iface = NULL;
	GVirConfigDomainInterfaceUser* _tmp73_;
	GVirConfigDomainInterfaceUser* _tmp74_;
	GError * _inner_error_ = NULL;
#line 25 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (install_media != NULL, NULL);
#line 25 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (target_path != NULL, NULL);
#line 25 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (caps != NULL, NULL);
#line 27 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_new ();
#line 27 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	domain = _tmp0_;
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 29 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_update_custom_xml (domain, _tmp1_, (guint) 0, FALSE);
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = caps;
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = install_media;
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = boxes_vm_configurator_get_best_guest_caps (_tmp2_, _tmp3_, &_inner_error_);
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	best_caps = _tmp4_;
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_inner_error_ != NULL) {
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_inner_error_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_propagate_error (error, _inner_error_);
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_object_unref0 (domain);
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return NULL;
#line 373 "vm-configurator.c"
		} else {
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_object_unref0 (domain);
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_clear_error (&_inner_error_);
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return NULL;
#line 383 "vm-configurator.c"
		}
	}
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = install_media;
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = _tmp5_->resources;
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = osinfo_resources_get_ram (_tmp6_);
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = _tmp7_;
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_memory (domain, (guint64) (_tmp8_ / OSINFO_KIBIBYTES));
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = caps;
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_cpu_config (domain, _tmp9_);
#line 35 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp11_ = boxes_vm_configurator_guest_kvm_enabled (best_caps);
#line 35 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp11_) {
#line 35 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = GVIR_CONFIG_DOMAIN_VIRT_KVM;
#line 406 "vm-configurator.c"
	} else {
#line 35 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = GVIR_CONFIG_DOMAIN_VIRT_QEMU;
#line 410 "vm-configurator.c"
	}
#line 35 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = _tmp10_;
#line 35 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	virt_type = _tmp12_;
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = virt_type;
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_virt_type (domain, _tmp13_);
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = install_media;
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_os_config (domain, _tmp14_, best_caps);
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = g_new0 (gchar*, 0 + 1);
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	features = _tmp15_;
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	features_length1 = 0;
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_features_size_ = features_length1;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = boxes_vm_configurator_guest_supports_feature (best_caps, "acpi");
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp16_) {
#line 436 "vm-configurator.c"
		gchar** _tmp17_;
		gint _tmp17__length1;
		gchar* _tmp18_;
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp17_ = features;
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp17__length1 = features_length1;
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp18_ = g_strdup ("acpi");
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_vala_array_add9 (&features, &features_length1, &_features_size_, _tmp18_);
#line 448 "vm-configurator.c"
	}
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp19_ = boxes_vm_configurator_guest_supports_feature (best_caps, "apic");
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp19_) {
#line 454 "vm-configurator.c"
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_;
#line 44 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp20_ = features;
#line 44 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp20__length1 = features_length1;
#line 44 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp21_ = g_strdup ("apic");
#line 44 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_vala_array_add10 (&features, &features_length1, &_features_size_, _tmp21_);
#line 466 "vm-configurator.c"
	}
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp22_ = boxes_vm_configurator_guest_supports_feature (best_caps, "pae");
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp22_) {
#line 472 "vm-configurator.c"
		gchar** _tmp23_;
		gint _tmp23__length1;
		gchar* _tmp24_;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp23_ = features;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp23__length1 = features_length1;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp24_ = g_strdup ("pae");
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_vala_array_add11 (&features, &features_length1, &_features_size_, _tmp24_);
#line 484 "vm-configurator.c"
	}
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp25_ = features;
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp25__length1 = features_length1;
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_features (domain, _tmp25_);
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp26_ = gvir_config_domain_clock_new ();
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	clock = _tmp26_;
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp28_ = install_media;
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp29_ = _tmp28_->os;
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp29_ != NULL) {
#line 502 "vm-configurator.c"
		BoxesInstallerMedia* _tmp30_;
		OsinfoOs* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gboolean _tmp34_ = FALSE;
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp30_ = install_media;
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp31_ = _tmp30_->os;
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp32_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp31_);
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp33_ = _tmp32_;
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp34_ = string_contains (_tmp33_, "win");
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp27_ = _tmp34_;
#line 520 "vm-configurator.c"
	} else {
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp27_ = FALSE;
#line 524 "vm-configurator.c"
	}
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp35_ = _tmp27_;
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp35_) {
#line 530 "vm-configurator.c"
		GVirConfigDomainClock* _tmp36_;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp36_ = clock;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_clock_set_offset (_tmp36_, GVIR_CONFIG_DOMAIN_CLOCK_LOCALTIME);
#line 536 "vm-configurator.c"
	} else {
		GVirConfigDomainClock* _tmp37_;
#line 53 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp37_ = clock;
#line 53 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_clock_set_offset (_tmp37_, GVIR_CONFIG_DOMAIN_CLOCK_UTC);
#line 543 "vm-configurator.c"
	}
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp38_ = gvir_config_domain_timer_rtc_new ();
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	timer = (GVirConfigDomainTimer*) _tmp38_;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp39_ = timer;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_timer_set_tick_policy (_tmp39_, GVIR_CONFIG_DOMAIN_TIMER_TICK_POLICY_CATCHUP);
#line 57 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp40_ = clock;
#line 57 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp41_ = timer;
#line 57 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_clock_add_timer (_tmp40_, _tmp41_);
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp42_ = gvir_config_domain_timer_pit_new ();
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (timer);
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	timer = (GVirConfigDomainTimer*) _tmp42_;
#line 59 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp43_ = timer;
#line 59 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_timer_set_tick_policy (_tmp43_, GVIR_CONFIG_DOMAIN_TIMER_TICK_POLICY_DELAY);
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp44_ = clock;
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp45_ = timer;
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_clock_add_timer (_tmp44_, _tmp45_);
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp46_ = clock;
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_clock (domain, _tmp46_);
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp47_ = target_path;
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp48_ = install_media;
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_target_media_config (domain, _tmp47_, _tmp48_);
#line 64 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp49_ = install_media;
#line 64 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_installer_media_setup_domain_config (_tmp49_, domain);
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp50_ = gvir_config_domain_graphics_spice_new ();
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	graphics = _tmp50_;
#line 67 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp51_ = graphics;
#line 67 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_graphics_spice_set_autoport (_tmp51_, TRUE);
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp52_ = graphics;
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_graphics_spice_set_image_compression (_tmp52_, GVIR_CONFIG_DOMAIN_GRAPHICS_SPICE_IMAGE_COMPRESSION_OFF);
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp53_ = graphics;
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp53_);
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp54_ = gvir_config_domain_channel_new ();
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	channel = _tmp54_;
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp55_ = channel;
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_channel_set_target_type (_tmp55_, GVIR_CONFIG_DOMAIN_CHANNEL_TARGET_VIRTIO);
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp56_ = channel;
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_channel_set_target_name (_tmp56_, "com.redhat.spice.0");
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp57_ = gvir_config_domain_chardev_source_spicevmc_new ();
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	vmc = _tmp57_;
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp58_ = channel;
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp59_ = vmc;
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp58_, (GVirConfigDomainChardevSource*) _tmp59_);
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp60_ = channel;
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp60_);
#line 80 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (HAVE_USBREDIR) {
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_add_usb_support (domain);
#line 635 "vm-configurator.c"
	}
#line 83 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (HAVE_SMARTCARD) {
#line 84 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_add_smartcard_support (domain);
#line 641 "vm-configurator.c"
	}
#line 86 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp61_ = install_media;
#line 86 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_video_config (domain, _tmp61_);
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp62_ = install_media;
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_sound_config (domain, _tmp62_);
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp63_ = install_media;
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_tablet_config (domain, _tmp63_);
#line 90 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_POWEROFF, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_CRASH, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp64_ = gvir_config_domain_power_management_new ();
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	pm = _tmp64_;
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp65_ = pm;
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_power_management_set_mem_suspend_enabled (_tmp65_, FALSE);
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp66_ = pm;
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_power_management_set_disk_suspend_enabled (_tmp66_, FALSE);
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp67_ = pm;
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_power_management (domain, _tmp67_);
#line 99 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp68_ = gvir_config_domain_console_new ();
#line 99 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	console = _tmp68_;
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp69_ = console;
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp70_ = gvir_config_domain_chardev_source_pty_new ();
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp71_ = _tmp70_;
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp69_, (GVirConfigDomainChardevSource*) _tmp71_);
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp71_);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp72_ = console;
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp72_);
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp73_ = gvir_config_domain_interface_user_new ();
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	iface = _tmp73_;
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp74_ = iface;
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp74_);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = domain;
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (iface);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (console);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (pm);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (vmc);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (channel);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (graphics);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (timer);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (clock);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	features = (_vala_array_free (features, features_length1, (GDestroyNotify) g_free), NULL);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (best_caps);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 727 "vm-configurator.c"
}


void boxes_vm_configurator_post_install_setup (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomain* _tmp0_;
	GVirConfigDomain* _tmp1_;
	BoxesInstallerMedia* _tmp2_;
	GVirConfigDomain* _tmp5_;
	BoxesInstallerMedia* _tmp6_;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_post_install_os_config (_tmp0_);
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = domain;
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (_tmp1_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_RESTART);
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = install_media;
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp2_ != NULL) {
#line 751 "vm-configurator.c"
		BoxesInstallerMedia* _tmp3_;
		GVirConfigDomain* _tmp4_;
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp3_ = install_media;
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = domain;
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_installer_media_setup_post_install_domain_config (_tmp3_, _tmp4_);
#line 760 "vm-configurator.c"
	}
#line 116 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = domain;
#line 116 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = install_media;
#line 116 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_mark_as_installed (_tmp5_, _tmp6_);
#line 768 "vm-configurator.c"
}


gboolean boxes_vm_configurator_is_install_config (GVirConfigDomain* domain) {
	gboolean result = FALSE;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_os_state (_tmp0_);
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = g_strcmp0 (_tmp2_, BOXES_VM_CONFIGURATOR_INSTALLATION_STATE) == 0;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp2_);
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp3_;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 794 "vm-configurator.c"
}


gboolean boxes_vm_configurator_is_live_config (GVirConfigDomain* domain) {
	gboolean result = FALSE;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
#line 123 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_os_state (_tmp0_);
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_;
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = g_strcmp0 (_tmp2_, BOXES_VM_CONFIGURATOR_LIVE_STATE) == 0;
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp2_);
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp3_;
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 820 "vm-configurator.c"
}


GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (const gchar* name, gint64 storage, GError** error) {
	GVirConfigStorageVol* result = NULL;
	GVirConfigStorageVol* volume = NULL;
	GVirConfigStorageVol* _tmp0_;
	const gchar* _tmp1_;
	gint64 _tmp2_;
	GVirConfigStorageVolTarget* target = NULL;
	GVirConfigStorageVolTarget* _tmp3_;
	GVirConfigStoragePermissions* permissions = NULL;
	GVirConfigStoragePermissions* _tmp4_ = NULL;
#line 127 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 128 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_storage_vol_new ();
#line 128 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	volume = _tmp0_;
#line 129 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = name;
#line 129 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_set_name (volume, _tmp1_);
#line 130 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = storage;
#line 130 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_set_capacity (volume, (guint64) _tmp2_);
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_storage_vol_target_new ();
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	target = _tmp3_;
#line 132 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_target_set_format (target, "qcow2");
#line 133 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = boxes_vm_configurator_get_default_permissions ();
#line 133 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	permissions = _tmp4_;
#line 134 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_target_set_permissions (target, permissions);
#line 135 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_set_target (volume, target);
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = volume;
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (permissions);
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (target);
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 870 "vm-configurator.c"
}


GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (GError** error) {
	GVirConfigStoragePool* result = NULL;
	gchar* pool_path = NULL;
	gchar* _tmp0_ = NULL;
	GVirConfigStoragePool* pool = NULL;
	GVirConfigStoragePool* _tmp1_;
	GVirConfigStoragePoolSource* source = NULL;
	GVirConfigStoragePoolSource* _tmp2_;
	GVirConfigStoragePoolTarget* target = NULL;
	GVirConfigStoragePoolTarget* _tmp3_;
	GVirConfigStoragePermissions* permissions = NULL;
	GVirConfigStoragePermissions* _tmp4_ = NULL;
#line 141 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_get_user_pkgdata ("images");
#line 141 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	pool_path = _tmp0_;
#line 142 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_ensure_directory (pool_path);
#line 144 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_storage_pool_new ();
#line 144 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	pool = _tmp1_;
#line 145 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_pool_type (pool, GVIR_CONFIG_STORAGE_POOL_TYPE_DIR);
#line 146 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_name (pool, PACKAGE_TARNAME);
#line 148 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_storage_pool_source_new ();
#line 148 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	source = _tmp2_;
#line 149 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_source_set_directory (source, pool_path);
#line 150 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_source (pool, source);
#line 152 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_storage_pool_target_new ();
#line 152 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	target = _tmp3_;
#line 153 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_target_set_path (target, pool_path);
#line 154 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = boxes_vm_configurator_get_default_permissions ();
#line 154 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	permissions = _tmp4_;
#line 155 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_target_set_permissions (target, permissions);
#line 156 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_target (pool, target);
#line 158 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = pool;
#line 158 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (permissions);
#line 158 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (target);
#line 158 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (source);
#line 158 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (pool_path);
#line 158 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 934 "vm-configurator.c"
}


gchar* boxes_vm_configurator_get_os_id (GVirConfigDomain* domain) {
	gchar* result = NULL;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 161 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 162 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 162 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_custom_xml_node (_tmp0_, "os-id");
#line 162 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp1_;
#line 162 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 952 "vm-configurator.c"
}


gchar* boxes_vm_configurator_get_os_media_id (GVirConfigDomain* domain) {
	gchar* result = NULL;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 165 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 166 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 166 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_custom_xml_node (_tmp0_, "media-id");
#line 166 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp1_;
#line 166 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 970 "vm-configurator.c"
}


guint boxes_vm_configurator_get_num_reboots (GVirConfigDomain* domain) {
	guint result = 0U;
	gchar* str = NULL;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	const gchar* _tmp3_;
#line 169 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, 0U);
#line 170 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 170 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_custom_xml_node (_tmp0_, "num-reboots");
#line 170 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	str = _tmp1_;
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = str;
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp3_ != NULL) {
#line 993 "vm-configurator.c"
		const gchar* _tmp4_;
		gint _tmp5_ = 0;
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = str;
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp5_ = atoi (_tmp4_);
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp2_ = _tmp5_;
#line 1002 "vm-configurator.c"
	} else {
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp2_ = 0;
#line 1006 "vm-configurator.c"
	}
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = (guint) _tmp2_;
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (str);
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1014 "vm-configurator.c"
}


void boxes_vm_configurator_set_num_reboots (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, guint num_reboots) {
	GVirConfigDomain* _tmp0_;
	BoxesInstallerMedia* _tmp1_;
	guint _tmp2_;
#line 174 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 174 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 175 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 175 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 175 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = num_reboots;
#line 175 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_update_custom_xml (_tmp0_, _tmp1_, _tmp2_, FALSE);
#line 1034 "vm-configurator.c"
}


static void boxes_vm_configurator_mark_as_installed (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomain* _tmp0_;
	BoxesInstallerMedia* _tmp1_;
#line 178 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 179 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 179 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 179 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_update_custom_xml (_tmp0_, _tmp1_, (guint) 0, TRUE);
#line 1049 "vm-configurator.c"
}


static void boxes_vm_configurator_set_cpu_config (GVirConfigDomain* domain, GVirConfigCapabilities* caps) {
	GVirConfigCapabilitiesCpuTopology* topology = NULL;
	GVirConfigCapabilities* _tmp0_;
	GVirConfigCapabilitiesHost* _tmp1_ = NULL;
	GVirConfigCapabilitiesHost* _tmp2_;
	GVirConfigCapabilitiesCpu* _tmp3_ = NULL;
	GVirConfigCapabilitiesCpu* _tmp4_;
	GVirConfigCapabilitiesCpuTopology* _tmp5_ = NULL;
	GVirConfigCapabilitiesCpuTopology* _tmp6_;
	GVirConfigCapabilitiesCpuTopology* _tmp7_;
	GVirConfigDomain* _tmp8_;
	GVirConfigCapabilitiesCpuTopology* _tmp9_;
	guint64 _tmp10_ = 0ULL;
	GVirConfigCapabilitiesCpuTopology* _tmp11_;
	guint64 _tmp12_ = 0ULL;
	GVirConfigCapabilitiesCpuTopology* _tmp13_;
	guint64 _tmp14_ = 0ULL;
	GVirConfigDomainCpu* cpu = NULL;
	GVirConfigDomainCpu* _tmp15_;
	GVirConfigDomainCpu* _tmp16_;
	GVirConfigDomainCpu* _tmp17_;
	GVirConfigCapabilitiesCpuTopology* _tmp18_;
	GVirConfigDomain* _tmp19_;
	GVirConfigDomainCpu* _tmp20_;
#line 182 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 182 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (caps != NULL);
#line 183 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = caps;
#line 183 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_get_host (_tmp0_);
#line 183 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_;
#line 183 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_capabilities_host_get_cpu (_tmp2_);
#line 183 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = _tmp3_;
#line 183 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = gvir_config_capabilities_cpu_get_topology (_tmp4_);
#line 183 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = _tmp5_;
#line 183 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp4_);
#line 183 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp2_);
#line 183 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	topology = _tmp6_;
#line 185 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = topology;
#line 185 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp7_ == NULL) {
#line 186 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_object_unref0 (topology);
#line 186 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return;
#line 1109 "vm-configurator.c"
	}
#line 188 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = domain;
#line 188 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = topology;
#line 188 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp10_ = gvir_config_capabilities_cpu_topology_get_sockets (_tmp9_);
#line 188 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp11_ = topology;
#line 188 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = gvir_config_capabilities_cpu_topology_get_cores (_tmp11_);
#line 188 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = topology;
#line 188 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = gvir_config_capabilities_cpu_topology_get_threads (_tmp13_);
#line 188 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_object_set (_tmp8_, "vcpu", (_tmp10_ * _tmp12_) * _tmp14_, NULL);
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = gvir_config_domain_cpu_new ();
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	cpu = _tmp15_;
#line 191 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = cpu;
#line 191 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_cpu_set_mode (_tmp16_, GVIR_CONFIG_DOMAIN_CPU_MODE_HOST_MODEL);
#line 192 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp17_ = cpu;
#line 192 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp18_ = topology;
#line 192 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_capabilities_cpu_set_topology ((GVirConfigCapabilitiesCpu*) _tmp17_, _tmp18_);
#line 193 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp19_ = domain;
#line 193 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp20_ = cpu;
#line 193 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_cpu (_tmp19_, _tmp20_);
#line 182 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (cpu);
#line 182 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (topology);
#line 1151 "vm-configurator.c"
}


static void boxes_vm_configurator_set_target_media_config (GVirConfigDomain* domain, const gchar* target_path, BoxesInstallerMedia* install_media) {
	GVirConfigDomainDisk* disk = NULL;
	GVirConfigDomainDisk* _tmp0_;
	GVirConfigDomainDisk* _tmp1_;
	GVirConfigDomainDisk* _tmp2_;
	GVirConfigDomainDisk* _tmp3_;
	GVirConfigDomainDisk* _tmp4_;
	GVirConfigDomainDisk* _tmp5_;
	const gchar* _tmp6_;
	GVirConfigDomainDisk* _tmp7_;
	BoxesInstallerMedia* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GVirConfigDomain* _tmp15_;
	GVirConfigDomainDisk* _tmp16_;
#line 196 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 196 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (target_path != NULL);
#line 196 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 197 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_disk_new ();
#line 197 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	disk = _tmp0_;
#line 198 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = disk;
#line 198 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_type (_tmp1_, GVIR_CONFIG_DOMAIN_DISK_FILE);
#line 199 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = disk;
#line 199 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_guest_device_type (_tmp2_, GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_DISK);
#line 200 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = disk;
#line 200 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_driver_name (_tmp3_, "qemu");
#line 201 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = disk;
#line 201 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_driver_type (_tmp4_, "qcow2");
#line 202 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = disk;
#line 202 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = target_path;
#line 202 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_source (_tmp5_, _tmp6_);
#line 203 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = disk;
#line 203 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_driver_cache (_tmp7_, GVIR_CONFIG_DOMAIN_DISK_CACHE_NONE);
#line 205 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = install_media;
#line 205 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = boxes_installer_media_get_supports_virtio_disk (_tmp8_);
#line 205 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp10_ = _tmp9_;
#line 205 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp10_) {
#line 1214 "vm-configurator.c"
		GVirConfigDomainDisk* _tmp11_;
		GVirConfigDomainDisk* _tmp12_;
#line 206 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_debug ("vm-configurator.vala:206: Using virtio controller for the main disk");
#line 207 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp11_ = disk;
#line 207 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_bus (_tmp11_, GVIR_CONFIG_DOMAIN_DISK_BUS_VIRTIO);
#line 208 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp12_ = disk;
#line 208 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_dev (_tmp12_, "vda");
#line 1227 "vm-configurator.c"
	} else {
		GVirConfigDomainDisk* _tmp13_;
		GVirConfigDomainDisk* _tmp14_;
#line 210 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_debug ("vm-configurator.vala:210: Using IDE controller for the main disk");
#line 211 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp13_ = disk;
#line 211 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_bus (_tmp13_, GVIR_CONFIG_DOMAIN_DISK_BUS_IDE);
#line 212 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp14_ = disk;
#line 212 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_dev (_tmp14_, "hda");
#line 1241 "vm-configurator.c"
	}
#line 215 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = domain;
#line 215 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = disk;
#line 215 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp15_, (GVirConfigDomainDevice*) _tmp16_);
#line 196 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (disk);
#line 1251 "vm-configurator.c"
}


static void boxes_vm_configurator_set_post_install_os_config (GVirConfigDomain* domain) {
	GVirConfigDomainOs* os = NULL;
	GVirConfigDomainOs* _tmp0_;
	GVirConfigDomainOs* old_os = NULL;
	GVirConfigDomain* _tmp1_;
	GVirConfigDomainOs* _tmp2_ = NULL;
	GList* boot_devices = NULL;
	GList* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GVirConfigDomain* _tmp5_;
#line 218 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 219 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_os_new ();
#line 219 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	os = _tmp0_;
#line 220 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_os_type (os, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
#line 222 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = domain;
#line 222 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_domain_get_os (_tmp1_);
#line 222 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	old_os = _tmp2_;
#line 223 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_domain_os_get_boot_devices (old_os);
#line 223 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = _tmp3_;
#line 224 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = g_list_remove (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
#line 225 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_boot_devices (os, boot_devices);
#line 227 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = gvir_config_domain_os_get_arch (old_os);
#line 227 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_arch (os, _tmp4_);
#line 229 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = domain;
#line 229 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_os (_tmp5_, os);
#line 218 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_list_free0 (boot_devices);
#line 218 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (old_os);
#line 218 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (os);
#line 1301 "vm-configurator.c"
}


static void boxes_vm_configurator_set_os_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, GVirConfigCapabilitiesGuest* guest_caps) {
	GVirConfigDomainOs* os = NULL;
	GVirConfigDomainOs* _tmp0_;
	GVirConfigCapabilitiesGuest* _tmp1_;
	GVirConfigCapabilitiesGuestArch* _tmp2_ = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GList* boot_devices = NULL;
	BoxesInstallerMedia* _tmp5_;
	GVirConfigDomain* _tmp6_;
#line 232 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 232 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 232 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (guest_caps != NULL);
#line 233 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_os_new ();
#line 233 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	os = _tmp0_;
#line 234 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_os_type (os, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
#line 235 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = guest_caps;
#line 235 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_capabilities_guest_get_arch (_tmp1_);
#line 235 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = _tmp2_;
#line 235 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = gvir_config_capabilities_guest_arch_get_name (_tmp3_);
#line 235 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_arch (os, _tmp4_);
#line 235 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp3_);
#line 237 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = NULL;
#line 238 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = install_media;
#line 238 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_installer_media_set_direct_boot_params (_tmp5_, os);
#line 239 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = g_list_append (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
#line 240 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = g_list_append (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_HD));
#line 241 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_boot_devices (os, boot_devices);
#line 243 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = domain;
#line 243 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_os (_tmp6_, os);
#line 232 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_list_free0 (boot_devices);
#line 232 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (os);
#line 1359 "vm-configurator.c"
}


static void boxes_vm_configurator_set_video_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainVideo* video = NULL;
	GVirConfigDomainVideo* _tmp0_;
	OsinfoDevice* device = NULL;
	BoxesInstallerMedia* _tmp1_;
	OsinfoDeviceList* _tmp2_;
	OsinfoDeviceList* _tmp3_;
	OsinfoDeviceList* _tmp4_;
	OsinfoDevice* _tmp5_ = NULL;
	OsinfoDevice* _tmp6_;
	gint _tmp7_ = 0;
	OsinfoDevice* _tmp8_;
	gint model = 0;
	gint _tmp12_;
	GVirConfigDomainVideo* _tmp13_;
	GVirConfigDomain* _tmp14_;
	GVirConfigDomainVideo* _tmp15_;
#line 246 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 246 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 247 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_video_new ();
#line 247 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	video = _tmp0_;
#line 248 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 248 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = boxes_installer_media_get_supported_devices (_tmp1_);
#line 248 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = _tmp2_;
#line 248 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = _tmp3_;
#line 248 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = boxes_find_device_by_prop (_tmp4_, OSINFO_DEVICE_PROP_CLASS, "video");
#line 248 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = _tmp5_;
#line 248 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp4_);
#line 248 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	device = _tmp6_;
#line 249 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = device;
#line 249 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp8_ != NULL) {
#line 1408 "vm-configurator.c"
		OsinfoDevice* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
#line 249 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp9_ = device;
#line 249 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = osinfo_device_get_name (_tmp9_);
#line 249 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp11_ = boxes_get_enum_value (_tmp10_, gvir_config_domain_video_model_get_type ());
#line 249 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = _tmp11_;
#line 1420 "vm-configurator.c"
	} else {
#line 250 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = (gint) GVIR_CONFIG_DOMAIN_VIDEO_MODEL_QXL;
#line 1424 "vm-configurator.c"
	}
#line 249 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = _tmp7_;
#line 249 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	model = _tmp12_;
#line 251 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (model != (-1));
#line 252 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = video;
#line 252 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_video_set_model (_tmp13_, (GVirConfigDomainVideoModel) model);
#line 254 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = domain;
#line 254 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = video;
#line 254 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp14_, (GVirConfigDomainDevice*) _tmp15_);
#line 246 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (device);
#line 246 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (video);
#line 1446 "vm-configurator.c"
}


static void boxes_vm_configurator_set_sound_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainSound* sound = NULL;
	GVirConfigDomainSound* _tmp0_;
	OsinfoDevice* device = NULL;
	BoxesInstallerMedia* _tmp1_;
	OsinfoDeviceList* _tmp2_;
	OsinfoDeviceList* _tmp3_;
	OsinfoDeviceList* _tmp4_;
	OsinfoDevice* _tmp5_ = NULL;
	OsinfoDevice* _tmp6_;
	gint _tmp7_ = 0;
	OsinfoDevice* _tmp8_;
	gint model = 0;
	gint _tmp12_;
	GVirConfigDomainSound* _tmp13_;
	GVirConfigDomain* _tmp14_;
	GVirConfigDomainSound* _tmp15_;
#line 257 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 257 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 258 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_sound_new ();
#line 258 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	sound = _tmp0_;
#line 259 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 259 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = boxes_installer_media_get_supported_devices (_tmp1_);
#line 259 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = _tmp2_;
#line 259 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = _tmp3_;
#line 259 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = boxes_find_device_by_prop (_tmp4_, OSINFO_DEVICE_PROP_CLASS, "audio");
#line 259 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = _tmp5_;
#line 259 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp4_);
#line 259 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	device = _tmp6_;
#line 260 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = device;
#line 260 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp8_ != NULL) {
#line 1495 "vm-configurator.c"
		OsinfoDevice* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
#line 260 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp9_ = device;
#line 260 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = osinfo_device_get_name (_tmp9_);
#line 260 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp11_ = boxes_get_enum_value (_tmp10_, gvir_config_domain_sound_model_get_type ());
#line 260 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = _tmp11_;
#line 1507 "vm-configurator.c"
	} else {
#line 261 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = (gint) GVIR_CONFIG_DOMAIN_SOUND_MODEL_AC97;
#line 1511 "vm-configurator.c"
	}
#line 260 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = _tmp7_;
#line 260 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	model = _tmp12_;
#line 262 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (model != (-1));
#line 263 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = sound;
#line 263 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_sound_set_model (_tmp13_, (GVirConfigDomainSoundModel) model);
#line 265 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = domain;
#line 265 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = sound;
#line 265 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp14_, (GVirConfigDomainDevice*) _tmp15_);
#line 257 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (device);
#line 257 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (sound);
#line 1533 "vm-configurator.c"
}


static void boxes_vm_configurator_set_tablet_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainInput* input = NULL;
	GVirConfigDomainInput* _tmp0_;
	GVirConfigDomain* _tmp1_;
#line 268 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 268 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 269 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_input_new ();
#line 269 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	input = _tmp0_;
#line 270 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_input_set_device_type (input, GVIR_CONFIG_DOMAIN_INPUT_DEVICE_TABLET);
#line 272 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = domain;
#line 272 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp1_, (GVirConfigDomainDevice*) input);
#line 268 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (input);
#line 1557 "vm-configurator.c"
}


static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (void) {
	GVirConfigStoragePermissions* result = NULL;
	GVirConfigStoragePermissions* permissions = NULL;
	GVirConfigStoragePermissions* _tmp0_;
	uid_t _tmp1_ = {0};
	gid_t _tmp2_ = {0};
#line 276 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_storage_permissions_new ();
#line 276 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	permissions = _tmp0_;
#line 278 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = getuid ();
#line 278 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_permissions_set_owner (permissions, (guint) _tmp1_);
#line 279 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = getgid ();
#line 279 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_permissions_set_group (permissions, (guint) _tmp2_);
#line 280 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_permissions_set_mode (permissions, (guint) 744);
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = permissions;
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1585 "vm-configurator.c"
}


static gchar* boxes_vm_configurator_get_os_state (GVirConfigDomain* domain) {
	gchar* result = NULL;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 285 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 286 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 286 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_custom_xml_node (_tmp0_, "os-state");
#line 286 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp1_;
#line 286 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1603 "vm-configurator.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 293 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return self ? g_object_ref (self) : NULL;
#line 1610 "vm-configurator.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 306 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1617 "vm-configurator.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 306 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 306 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_list_free (self);
#line 1626 "vm-configurator.c"
}


gchar* boxes_vm_configurator_get_source_media_path (GVirConfigDomain* domain) {
	gchar* result = NULL;
	gchar* path = NULL;
	GList* devices = NULL;
	GVirConfigDomain* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* _tmp2_;
#line 289 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 290 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	path = NULL;
#line 292 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 292 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_domain_get_devices (_tmp0_);
#line 292 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	devices = _tmp1_;
#line 293 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = devices;
#line 1649 "vm-configurator.c"
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
#line 293 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		device_collection = _tmp2_;
#line 293 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 1657 "vm-configurator.c"
			GVirConfigDomainDevice* _tmp3_;
			GVirConfigDomainDevice* device = NULL;
#line 293 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp3_ = _g_object_ref0 ((GVirConfigDomainDevice*) device_it->data);
#line 293 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			device = _tmp3_;
#line 1664 "vm-configurator.c"
			{
				GVirConfigDomainDevice* _tmp4_;
				GVirConfigDomainDisk* disk = NULL;
				GVirConfigDomainDevice* _tmp5_;
				GVirConfigDomainDisk* _tmp6_;
				GVirConfigDomainDiskGuestDeviceType disk_type = 0;
				GVirConfigDomainDisk* _tmp7_;
				GVirConfigDomainDiskGuestDeviceType _tmp8_ = 0;
				GVirConfigDomainDiskGuestDeviceType _tmp9_;
#line 294 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp4_ = device;
#line 294 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gvir_config_domain_disk_get_type ())) {
#line 295 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (device);
#line 295 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					continue;
#line 1682 "vm-configurator.c"
				}
#line 297 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = device;
#line 297 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gvir_config_domain_disk_get_type ()) ? ((GVirConfigDomainDisk*) _tmp5_) : NULL);
#line 297 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				disk = _tmp6_;
#line 298 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp7_ = disk;
#line 298 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp8_ = gvir_config_domain_disk_get_guest_device_type (_tmp7_);
#line 298 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				disk_type = _tmp8_;
#line 299 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp9_ = disk_type;
#line 299 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp9_ == GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_CDROM) {
#line 1700 "vm-configurator.c"
					GVirConfigDomainDisk* _tmp10_;
					const gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
#line 300 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp10_ = disk;
#line 300 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp11_ = gvir_config_domain_disk_get_source (_tmp10_);
#line 300 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp12_ = g_strdup (_tmp11_);
#line 300 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_free0 (path);
#line 300 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					path = _tmp12_;
#line 302 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (disk);
#line 302 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (device);
#line 302 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					break;
#line 1720 "vm-configurator.c"
				}
#line 293 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (disk);
#line 293 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (device);
#line 1726 "vm-configurator.c"
			}
		}
	}
#line 306 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = path;
#line 306 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	__g_list_free__g_object_unref0_0 (devices);
#line 306 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1736 "vm-configurator.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1260 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1261 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1261 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1261 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1262 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1262 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1262 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1262 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1263 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1263 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1263 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1263 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1263 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1263 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 1780 "vm-configurator.c"
	}
#line 1263 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1263 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 1786 "vm-configurator.c"
}


static gchar* boxes_vm_configurator_get_custom_xml_node (GVirConfigDomain* domain, const gchar* node_name) {
	gchar* result = NULL;
	gchar* xml = NULL;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp28_;
	GVirConfigDomain* _tmp29_;
	const gchar* _tmp30_ = NULL;
#line 309 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 309 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (node_name != NULL, NULL);
#line 310 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 310 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_domain_get_custom_xml (_tmp0_, BOXES_VM_CONFIGURATOR_BOXES_NS_URI);
#line 310 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	xml = _tmp1_;
#line 311 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = xml;
#line 311 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp2_ != NULL) {
#line 1813 "vm-configurator.c"
		xmlTextReader* reader = NULL;
		const gchar* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		guint8* _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		xmlTextReader* _tmp9_;
		xmlTextReader* _tmp10_;
		xmlNode* node = NULL;
		xmlTextReader* _tmp11_;
		xmlNode* _tmp12_ = NULL;
		xmlNode* _tmp13_;
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp3_ = xml;
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = string_get_data (_tmp3_, &_tmp4__length1);
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp5_ = _tmp4_;
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp5__length1 = _tmp4__length1;
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp6_ = xml;
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = strlen (_tmp6_);
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp8_ = _tmp7_;
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp9_ = xmlReaderForMemory ((gchar*) _tmp5_, _tmp8_, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, NULL, (gint) XML_PARSE_COMPACT);
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		reader = _tmp9_;
#line 317 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = reader;
#line 317 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		xmlTextReaderNext (_tmp10_);
#line 319 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp11_ = reader;
#line 319 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp12_ = xmlTextReaderExpand (_tmp11_);
#line 319 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		node = _tmp12_;
#line 320 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp13_ = node;
#line 320 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_tmp13_ != NULL) {
#line 1861 "vm-configurator.c"
			xmlNode* _tmp14_;
			const gchar* _tmp15_;
#line 322 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp14_ = node;
#line 322 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp15_ = _tmp14_->name;
#line 322 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			if (g_strcmp0 (_tmp15_, "gnome-boxes") == 0) {
#line 1870 "vm-configurator.c"
				xmlNode* _tmp16_;
				xmlNode* _tmp17_;
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp16_ = node;
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp17_ = _tmp16_->children;
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				node = _tmp17_;
#line 1879 "vm-configurator.c"
			}
#line 325 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			while (TRUE) {
#line 1883 "vm-configurator.c"
				xmlNode* _tmp18_;
				xmlNode* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				xmlNode* _tmp26_;
				xmlNode* _tmp27_;
#line 325 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp18_ = node;
#line 325 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (!(_tmp18_ != NULL)) {
#line 325 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					break;
#line 1896 "vm-configurator.c"
				}
#line 326 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp19_ = node;
#line 326 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp20_ = _tmp19_->name;
#line 326 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp21_ = node_name;
#line 326 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (g_strcmp0 (_tmp20_, _tmp21_) == 0) {
#line 1906 "vm-configurator.c"
					xmlNode* _tmp22_;
					xmlNode* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
#line 327 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp22_ = node;
#line 327 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp23_ = _tmp22_->children;
#line 327 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp24_ = _tmp23_->content;
#line 327 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp25_ = g_strdup (_tmp24_);
#line 327 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = _tmp25_;
#line 327 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_xmlFreeTextReader0 (reader);
#line 327 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_free0 (xml);
#line 327 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 1927 "vm-configurator.c"
				}
#line 329 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp26_ = node;
#line 329 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp27_ = _tmp26_->next;
#line 329 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				node = _tmp27_;
#line 1935 "vm-configurator.c"
			}
		}
#line 311 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_xmlFreeTextReader0 (reader);
#line 1940 "vm-configurator.c"
	}
#line 334 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp28_ = node_name;
#line 334 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp29_ = domain;
#line 334 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp30_ = gvir_config_domain_get_name (_tmp29_);
#line 334 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_debug ("vm-configurator.vala:334: No XML node %s' for domain '%s'.", _tmp28_, _tmp30_);
#line 336 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = NULL;
#line 336 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (xml);
#line 336 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1956 "vm-configurator.c"
}


static void boxes_vm_configurator_update_custom_xml (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, guint num_reboots, gboolean installed) {
	gchar* custom_xml = NULL;
	gboolean _tmp0_;
	BoxesInstallerMedia* _tmp8_;
	guint _tmp31_;
	const gchar* _tmp37_;
	gchar* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
#line 339 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 345 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = installed;
#line 345 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp0_) {
#line 1974 "vm-configurator.c"
		gchar* _tmp1_;
#line 346 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp1_ = g_strdup (BOXES_VM_CONFIGURATOR_INSTALLED_XML);
#line 346 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (custom_xml);
#line 346 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		custom_xml = _tmp1_;
#line 1982 "vm-configurator.c"
	} else {
		const gchar* _tmp2_ = NULL;
		BoxesInstallerMedia* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp3_ = install_media;
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = boxes_installer_media_get_live (_tmp3_);
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp5_ = _tmp4_;
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_tmp5_) {
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp2_ = BOXES_VM_CONFIGURATOR_LIVE_XML;
#line 2000 "vm-configurator.c"
		} else {
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp2_ = BOXES_VM_CONFIGURATOR_INSTALLATION_XML;
#line 2004 "vm-configurator.c"
		}
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp6_ = _tmp2_;
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (custom_xml);
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		custom_xml = _tmp7_;
#line 2014 "vm-configurator.c"
	}
#line 350 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = install_media;
#line 350 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp8_ != NULL) {
#line 2020 "vm-configurator.c"
		BoxesInstallerMedia* _tmp9_;
		OsinfoOs* _tmp10_;
		BoxesInstallerMedia* _tmp20_;
		OsinfoMedia* _tmp21_;
#line 351 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp9_ = install_media;
#line 351 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = _tmp9_->os;
#line 351 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_tmp10_ != NULL) {
#line 2031 "vm-configurator.c"
			const gchar* _tmp11_;
			BoxesInstallerMedia* _tmp12_;
			OsinfoOs* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			gchar* _tmp19_;
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp11_ = custom_xml;
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp12_ = install_media;
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp13_ = _tmp12_->os;
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_object_get ((OsinfoEntity*) _tmp13_, "id", &_tmp14_, NULL);
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp15_ = _tmp14_;
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp16_ = _tmp15_;
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp17_ = g_markup_printf_escaped (BOXES_VM_CONFIGURATOR_OS_ID_XML, _tmp16_);
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp18_ = _tmp17_;
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp19_ = g_strconcat (_tmp11_, _tmp18_, NULL);
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (custom_xml);
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			custom_xml = _tmp19_;
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (_tmp18_);
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (_tmp16_);
#line 2067 "vm-configurator.c"
		}
#line 353 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp20_ = install_media;
#line 353 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp21_ = _tmp20_->os_media;
#line 353 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_tmp21_ != NULL) {
#line 2075 "vm-configurator.c"
			const gchar* _tmp22_;
			BoxesInstallerMedia* _tmp23_;
			OsinfoMedia* _tmp24_;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			gchar* _tmp30_;
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp22_ = custom_xml;
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp23_ = install_media;
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp24_ = _tmp23_->os_media;
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_object_get ((OsinfoEntity*) _tmp24_, "id", &_tmp25_, NULL);
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp26_ = _tmp25_;
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp27_ = _tmp26_;
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp28_ = g_markup_printf_escaped (BOXES_VM_CONFIGURATOR_MEDIA_ID_XML, _tmp27_);
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp29_ = _tmp28_;
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp30_ = g_strconcat (_tmp22_, _tmp29_, NULL);
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (custom_xml);
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			custom_xml = _tmp30_;
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (_tmp29_);
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (_tmp27_);
#line 2111 "vm-configurator.c"
		}
	}
#line 357 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp31_ = num_reboots;
#line 357 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp31_ != ((guint) 0)) {
#line 2118 "vm-configurator.c"
		const gchar* _tmp32_;
		guint _tmp33_;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		gchar* _tmp36_;
#line 358 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp32_ = custom_xml;
#line 358 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp33_ = num_reboots;
#line 358 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp34_ = g_strdup_printf (BOXES_VM_CONFIGURATOR_NUM_REBOOTS_XML, _tmp33_);
#line 358 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp35_ = _tmp34_;
#line 358 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp36_ = g_strconcat (_tmp32_, _tmp35_, NULL);
#line 358 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (custom_xml);
#line 358 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		custom_xml = _tmp36_;
#line 358 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (_tmp35_);
#line 2140 "vm-configurator.c"
	}
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp37_ = custom_xml;
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp38_ = g_strdup_printf (BOXES_VM_CONFIGURATOR_BOXES_XML, _tmp37_);
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (custom_xml);
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	custom_xml = _tmp38_;
#line 2150 "vm-configurator.c"
	{
		GVirConfigDomain* _tmp39_;
		const gchar* _tmp40_;
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp39_ = domain;
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp40_ = custom_xml;
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_set_custom_xml (_tmp39_, _tmp40_, BOXES_VM_CONFIGURATOR_BOXES_NS, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, &_inner_error_);
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_inner_error_ != NULL) {
#line 2162 "vm-configurator.c"
			goto __catch89_g_error;
		}
	}
	goto __finally89;
	__catch89_g_error:
	{
		GError* _error_ = NULL;
#line 361 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_error_ = _inner_error_;
#line 361 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_inner_error_ = NULL;
#line 363 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_assert_not_reached ();
#line 361 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_error_free0 (_error_);
#line 2178 "vm-configurator.c"
	}
	__finally89:
#line 361 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_inner_error_ != NULL) {
#line 361 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (custom_xml);
#line 361 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 361 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_clear_error (&_inner_error_);
#line 361 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return;
#line 2191 "vm-configurator.c"
	}
#line 339 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (custom_xml);
#line 2195 "vm-configurator.c"
}


void boxes_vm_configurator_add_smartcard_support (GVirConfigDomain* domain) {
	GVirConfigDomainSmartcardPassthrough* smartcard = NULL;
	GVirConfigDomainSmartcardPassthrough* _tmp0_;
	GVirConfigDomainChardevSourceSpiceVmc* vmc = NULL;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp1_;
	GVirConfigDomain* _tmp2_;
#line 366 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 367 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_smartcard_passthrough_new ();
#line 367 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	smartcard = _tmp0_;
#line 368 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_domain_chardev_source_spicevmc_new ();
#line 368 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	vmc = _tmp1_;
#line 369 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_smartcard_passthrough_set_source (smartcard, (GVirConfigDomainChardevSource*) vmc);
#line 370 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = domain;
#line 370 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp2_, (GVirConfigDomainDevice*) smartcard);
#line 366 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (vmc);
#line 366 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (smartcard);
#line 2225 "vm-configurator.c"
}


void boxes_vm_configurator_add_usb_support (GVirConfigDomain* domain) {
	GVirConfigDomainControllerUsb* master_controller = NULL;
	GVirConfigDomainControllerUsb* _tmp11_ = NULL;
	GVirConfigDomain* _tmp12_;
	GVirConfigDomainControllerUsb* controller = NULL;
	GVirConfigDomainControllerUsb* _tmp13_ = NULL;
	GVirConfigDomain* _tmp14_;
	GVirConfigDomainControllerUsb* _tmp15_;
	GVirConfigDomainControllerUsb* _tmp16_ = NULL;
	GVirConfigDomain* _tmp17_;
	GVirConfigDomainControllerUsb* _tmp18_;
	GVirConfigDomainControllerUsb* _tmp19_ = NULL;
	GVirConfigDomain* _tmp20_;
	GVirConfigDomainControllerUsb* _tmp21_;
#line 373 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 2245 "vm-configurator.c"
	{
		gint i = 0;
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		i = 0;
#line 2250 "vm-configurator.c"
		{
			gboolean _tmp0_ = FALSE;
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp0_ = TRUE;
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			while (TRUE) {
#line 2257 "vm-configurator.c"
				gboolean _tmp1_;
				gint _tmp3_;
				GVirConfigDomainRedirdev* usb_redir = NULL;
				GVirConfigDomainRedirdev* _tmp4_;
				GVirConfigDomainRedirdev* _tmp5_;
				GVirConfigDomainChardevSourceSpiceVmc* vmc = NULL;
				GVirConfigDomainChardevSourceSpiceVmc* _tmp6_;
				GVirConfigDomainRedirdev* _tmp7_;
				GVirConfigDomainChardevSourceSpiceVmc* _tmp8_;
				GVirConfigDomain* _tmp9_;
				GVirConfigDomainRedirdev* _tmp10_;
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp1_ = _tmp0_;
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (!_tmp1_) {
#line 2273 "vm-configurator.c"
					gint _tmp2_;
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp2_ = i;
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					i = _tmp2_ + 1;
#line 2279 "vm-configurator.c"
				}
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp0_ = FALSE;
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp3_ = i;
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (!(_tmp3_ < 4)) {
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					break;
#line 2289 "vm-configurator.c"
				}
#line 376 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp4_ = gvir_config_domain_redirdev_new ();
#line 376 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				usb_redir = _tmp4_;
#line 377 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = usb_redir;
#line 377 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				gvir_config_domain_redirdev_set_bus (_tmp5_, GVIR_CONFIG_DOMAIN_REDIRDEV_BUS_USB);
#line 378 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = gvir_config_domain_chardev_source_spicevmc_new ();
#line 378 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				vmc = _tmp6_;
#line 379 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp7_ = usb_redir;
#line 379 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp8_ = vmc;
#line 379 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp7_, (GVirConfigDomainChardevSource*) _tmp8_);
#line 380 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp9_ = domain;
#line 380 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp10_ = usb_redir;
#line 380 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				gvir_config_domain_add_device (_tmp9_, (GVirConfigDomainDevice*) _tmp10_);
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (vmc);
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (usb_redir);
#line 2319 "vm-configurator.c"
			}
		}
	}
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp11_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_EHCI1, NULL, (guint) 0, (guint) 0);
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	master_controller = _tmp11_;
#line 385 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = domain;
#line 385 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp12_, (GVirConfigDomainDevice*) master_controller);
#line 386 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_UHCI1, master_controller, (guint) 0, (guint) 0);
#line 386 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	controller = _tmp13_;
#line 387 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = domain;
#line 387 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = controller;
#line 387 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp14_, (GVirConfigDomainDevice*) _tmp15_);
#line 388 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_UHCI2, master_controller, (guint) 0, (guint) 2);
#line 388 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (controller);
#line 388 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	controller = _tmp16_;
#line 389 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp17_ = domain;
#line 389 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp18_ = controller;
#line 389 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp17_, (GVirConfigDomainDevice*) _tmp18_);
#line 390 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp19_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_UHCI3, master_controller, (guint) 0, (guint) 4);
#line 390 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (controller);
#line 390 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	controller = _tmp19_;
#line 391 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp20_ = domain;
#line 391 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp21_ = controller;
#line 391 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp20_, (GVirConfigDomainDevice*) _tmp21_);
#line 373 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (controller);
#line 373 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (master_controller);
#line 2369 "vm-configurator.c"
}


static GVirConfigDomainControllerUsb* boxes_vm_configurator_create_usb_controller (GVirConfigDomainControllerUsbModel model, GVirConfigDomainControllerUsb* master, guint index, guint start_port) {
	GVirConfigDomainControllerUsb* result = NULL;
	GVirConfigDomainControllerUsb* controller = NULL;
	GVirConfigDomainControllerUsb* _tmp0_;
	GVirConfigDomainControllerUsb* _tmp1_;
	GVirConfigDomainControllerUsbModel _tmp2_;
	GVirConfigDomainControllerUsb* _tmp3_;
	guint _tmp4_;
	GVirConfigDomainControllerUsb* _tmp5_;
#line 398 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_controller_usb_new ();
#line 398 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	controller = _tmp0_;
#line 399 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = controller;
#line 399 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = model;
#line 399 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_controller_usb_set_model (_tmp1_, _tmp2_);
#line 400 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = controller;
#line 400 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = index;
#line 400 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_controller_set_index ((GVirConfigDomainController*) _tmp3_, _tmp4_);
#line 401 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = master;
#line 401 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp5_ != NULL) {
#line 2402 "vm-configurator.c"
		GVirConfigDomainControllerUsb* _tmp6_;
		GVirConfigDomainControllerUsb* _tmp7_;
		guint _tmp8_;
#line 402 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp6_ = controller;
#line 402 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = master;
#line 402 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp8_ = start_port;
#line 402 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_controller_usb_set_master (_tmp6_, _tmp7_, _tmp8_);
#line 2414 "vm-configurator.c"
	}
#line 404 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = controller;
#line 404 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2420 "vm-configurator.c"
}


void boxes_vm_configurator_remove_usb_controllers (GVirConfigDomain* domain, GError** error) {
	GList* devices = NULL;
	GVirConfigDomain* _tmp0_;
	GList* _tmp1_ = NULL;
	GVirConfigDomain* _tmp6_;
	GList* _tmp7_;
#line 408 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 409 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	devices = NULL;
#line 410 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 410 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_domain_get_devices (_tmp0_);
#line 2438 "vm-configurator.c"
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
#line 410 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		device_collection = _tmp1_;
#line 410 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 2446 "vm-configurator.c"
			GVirConfigDomainDevice* _tmp2_;
			GVirConfigDomainDevice* device = NULL;
#line 410 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp2_ = _g_object_ref0 ((GVirConfigDomainDevice*) device_it->data);
#line 410 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			device = _tmp2_;
#line 2453 "vm-configurator.c"
			{
				GVirConfigDomainDevice* _tmp3_;
#line 411 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp3_ = device;
#line 411 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gvir_config_domain_controller_usb_get_type ())) {
#line 2460 "vm-configurator.c"
					GVirConfigDomainDevice* _tmp4_;
					GVirConfigDomainDevice* _tmp5_;
#line 412 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp4_ = device;
#line 412 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp5_ = _g_object_ref0 (_tmp4_);
#line 412 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					devices = g_list_prepend (devices, _tmp5_);
#line 2469 "vm-configurator.c"
				}
#line 410 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (device);
#line 2473 "vm-configurator.c"
			}
		}
#line 410 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (device_collection);
#line 2478 "vm-configurator.c"
	}
#line 415 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	devices = g_list_reverse (devices);
#line 416 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = domain;
#line 416 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = devices;
#line 416 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_devices (_tmp6_, _tmp7_);
#line 408 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	__g_list_free__g_object_unref0_0 (devices);
#line 2490 "vm-configurator.c"
}


static GVirConfigCapabilitiesGuest* boxes_vm_configurator_get_best_guest_caps (GVirConfigCapabilities* caps, BoxesInstallerMedia* install_media, GError** error) {
	GVirConfigCapabilitiesGuest* result = NULL;
	GList* guests_caps = NULL;
	GVirConfigCapabilities* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* compat_guests_caps = NULL;
	GList* _tmp2_;
	GList* _tmp15_;
	GList* _tmp19_;
	const gchar* _tmp23_ = NULL;
	GError* _tmp24_;
	GError * _inner_error_ = NULL;
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (caps != NULL, NULL);
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (install_media != NULL, NULL);
#line 421 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = caps;
#line 421 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_get_guests (_tmp0_);
#line 421 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	guests_caps = _tmp1_;
#line 424 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	compat_guests_caps = NULL;
#line 425 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = guests_caps;
#line 2520 "vm-configurator.c"
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
#line 425 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		guest_caps_collection = _tmp2_;
#line 425 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
#line 2528 "vm-configurator.c"
			GVirConfigCapabilitiesGuest* _tmp3_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
#line 425 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp3_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
#line 425 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			guest_caps = _tmp3_;
#line 2535 "vm-configurator.c"
			{
				gchar* guest_arch = NULL;
				GVirConfigCapabilitiesGuest* _tmp4_;
				GVirConfigCapabilitiesGuestArch* _tmp5_ = NULL;
				GVirConfigCapabilitiesGuestArch* _tmp6_;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_;
				BoxesInstallerMedia* _tmp10_;
				const gchar* _tmp11_;
				gboolean _tmp12_ = FALSE;
#line 426 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp4_ = guest_caps;
#line 426 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = gvir_config_capabilities_guest_get_arch (_tmp4_);
#line 426 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = _tmp5_;
#line 426 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp7_ = gvir_config_capabilities_guest_arch_get_name (_tmp6_);
#line 426 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp8_ = g_strdup (_tmp7_);
#line 426 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp9_ = _tmp8_;
#line 426 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (_tmp6_);
#line 426 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				guest_arch = _tmp9_;
#line 428 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp10_ = install_media;
#line 428 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp11_ = guest_arch;
#line 428 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp12_ = boxes_installer_media_is_architecture_compatible (_tmp10_, _tmp11_);
#line 428 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp12_) {
#line 2571 "vm-configurator.c"
					GVirConfigCapabilitiesGuest* _tmp13_;
					GVirConfigCapabilitiesGuest* _tmp14_;
#line 429 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp13_ = guest_caps;
#line 429 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp14_ = _g_object_ref0 (_tmp13_);
#line 429 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					compat_guests_caps = g_list_append (compat_guests_caps, _tmp14_);
#line 2580 "vm-configurator.c"
				}
#line 425 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_free0 (guest_arch);
#line 425 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (guest_caps);
#line 2586 "vm-configurator.c"
			}
		}
	}
#line 433 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = compat_guests_caps;
#line 2592 "vm-configurator.c"
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
#line 433 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		guest_caps_collection = _tmp15_;
#line 433 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
#line 2600 "vm-configurator.c"
			GVirConfigCapabilitiesGuest* _tmp16_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
#line 433 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp16_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
#line 433 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			guest_caps = _tmp16_;
#line 2607 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuest* _tmp17_;
				gboolean _tmp18_ = FALSE;
#line 434 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp17_ = guest_caps;
#line 434 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp18_ = boxes_vm_configurator_guest_kvm_enabled (_tmp17_);
#line 434 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp18_) {
#line 435 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = guest_caps;
#line 435 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 435 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (guests_caps);
#line 435 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 2625 "vm-configurator.c"
				}
#line 433 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (guest_caps);
#line 2629 "vm-configurator.c"
			}
		}
	}
#line 438 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp19_ = compat_guests_caps;
#line 2635 "vm-configurator.c"
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
#line 438 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		guest_caps_collection = _tmp19_;
#line 438 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
#line 2643 "vm-configurator.c"
			GVirConfigCapabilitiesGuest* _tmp20_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
#line 438 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp20_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
#line 438 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			guest_caps = _tmp20_;
#line 2650 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuest* _tmp21_;
				gboolean _tmp22_ = FALSE;
#line 439 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp21_ = guest_caps;
#line 439 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp22_ = boxes_vm_configurator_guest_is_qemu (_tmp21_);
#line 439 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp22_) {
#line 440 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = guest_caps;
#line 440 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 440 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (guests_caps);
#line 440 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 2668 "vm-configurator.c"
				}
#line 438 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (guest_caps);
#line 2672 "vm-configurator.c"
			}
		}
	}
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp23_ = _ ("Incapable host system");
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp24_ = g_error_new_literal (BOXES_VM_CONFIGURATOR_ERROR, BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS, _tmp23_);
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_inner_error_ = _tmp24_;
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_inner_error_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_propagate_error (error, _inner_error_);
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (guests_caps);
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return NULL;
#line 2692 "vm-configurator.c"
	} else {
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (guests_caps);
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_clear_error (&_inner_error_);
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return NULL;
#line 2704 "vm-configurator.c"
	}
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	__g_list_free__g_object_unref0_0 (guests_caps);
#line 2710 "vm-configurator.c"
}


static gboolean boxes_vm_configurator_guest_kvm_enabled (GVirConfigCapabilitiesGuest* guest_caps) {
	gboolean result = FALSE;
	GVirConfigCapabilitiesGuestArch* arch = NULL;
	GVirConfigCapabilitiesGuest* _tmp0_;
	GVirConfigCapabilitiesGuestArch* _tmp1_ = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp2_;
	GList* _tmp3_ = NULL;
#line 447 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (guest_caps != NULL, FALSE);
#line 448 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = guest_caps;
#line 448 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_guest_get_arch (_tmp0_);
#line 448 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	arch = _tmp1_;
#line 449 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = arch;
#line 449 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_capabilities_guest_arch_get_domains (_tmp2_);
#line 2733 "vm-configurator.c"
	{
		GList* domain_collection = NULL;
		GList* domain_it = NULL;
#line 449 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		domain_collection = _tmp3_;
#line 449 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (domain_it = domain_collection; domain_it != NULL; domain_it = domain_it->next) {
#line 2741 "vm-configurator.c"
			GVirConfigCapabilitiesGuestDomain* _tmp4_;
			GVirConfigCapabilitiesGuestDomain* domain = NULL;
#line 449 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp4_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestDomain*) domain_it->data);
#line 449 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			domain = _tmp4_;
#line 2748 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuestDomain* _tmp5_;
				GVirConfigDomainVirtType _tmp6_ = 0;
#line 450 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = domain;
#line 450 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = gvir_config_capabilities_guest_domain_get_virt_type (_tmp5_);
#line 450 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp6_ == GVIR_CONFIG_DOMAIN_VIRT_KVM) {
#line 451 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = TRUE;
#line 451 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (domain);
#line 451 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (domain_collection);
#line 451 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (arch);
#line 451 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 2768 "vm-configurator.c"
				}
#line 449 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (domain);
#line 2772 "vm-configurator.c"
			}
		}
#line 449 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (domain_collection);
#line 2777 "vm-configurator.c"
	}
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = FALSE;
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (arch);
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2785 "vm-configurator.c"
}


static gboolean boxes_vm_configurator_guest_is_qemu (GVirConfigCapabilitiesGuest* guest_caps) {
	gboolean result = FALSE;
	GVirConfigCapabilitiesGuestArch* arch = NULL;
	GVirConfigCapabilitiesGuest* _tmp0_;
	GVirConfigCapabilitiesGuestArch* _tmp1_ = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp2_;
	GList* _tmp3_ = NULL;
#line 456 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (guest_caps != NULL, FALSE);
#line 457 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = guest_caps;
#line 457 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_guest_get_arch (_tmp0_);
#line 457 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	arch = _tmp1_;
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = arch;
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_capabilities_guest_arch_get_domains (_tmp2_);
#line 2808 "vm-configurator.c"
	{
		GList* domain_collection = NULL;
		GList* domain_it = NULL;
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		domain_collection = _tmp3_;
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (domain_it = domain_collection; domain_it != NULL; domain_it = domain_it->next) {
#line 2816 "vm-configurator.c"
			GVirConfigCapabilitiesGuestDomain* _tmp4_;
			GVirConfigCapabilitiesGuestDomain* domain = NULL;
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp4_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestDomain*) domain_it->data);
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			domain = _tmp4_;
#line 2823 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuestDomain* _tmp5_;
				GVirConfigDomainVirtType _tmp6_ = 0;
#line 459 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = domain;
#line 459 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = gvir_config_capabilities_guest_domain_get_virt_type (_tmp5_);
#line 459 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp6_ == GVIR_CONFIG_DOMAIN_VIRT_QEMU) {
#line 460 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = TRUE;
#line 460 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (domain);
#line 460 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (domain_collection);
#line 460 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (arch);
#line 460 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 2843 "vm-configurator.c"
				}
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (domain);
#line 2847 "vm-configurator.c"
			}
		}
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (domain_collection);
#line 2852 "vm-configurator.c"
	}
#line 462 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = FALSE;
#line 462 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (arch);
#line 462 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2860 "vm-configurator.c"
}


static gboolean boxes_vm_configurator_guest_supports_feature (GVirConfigCapabilitiesGuest* guest_caps, const gchar* feature_name) {
	gboolean result = FALSE;
	gboolean supports = FALSE;
	GVirConfigCapabilitiesGuest* _tmp0_;
	GList* _tmp1_ = NULL;
#line 465 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (guest_caps != NULL, FALSE);
#line 465 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (feature_name != NULL, FALSE);
#line 466 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	supports = FALSE;
#line 468 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = guest_caps;
#line 468 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_guest_get_features (_tmp0_);
#line 2879 "vm-configurator.c"
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
#line 468 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		feature_collection = _tmp1_;
#line 468 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
#line 2887 "vm-configurator.c"
			GVirConfigCapabilitiesGuestFeature* _tmp2_;
			GVirConfigCapabilitiesGuestFeature* feature = NULL;
#line 468 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp2_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestFeature*) feature_it->data);
#line 468 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			feature = _tmp2_;
#line 2894 "vm-configurator.c"
			{
				const gchar* _tmp3_;
				GVirConfigCapabilitiesGuestFeature* _tmp4_;
				const gchar* _tmp5_ = NULL;
#line 469 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp3_ = feature_name;
#line 469 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp4_ = feature;
#line 469 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = gvir_config_capabilities_guest_feature_get_name (_tmp4_);
#line 469 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (g_strcmp0 (_tmp3_, _tmp5_) == 0) {
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					supports = TRUE;
#line 472 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (feature);
#line 472 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					break;
#line 2913 "vm-configurator.c"
				}
#line 468 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (feature);
#line 2917 "vm-configurator.c"
			}
		}
#line 468 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (feature_collection);
#line 2922 "vm-configurator.c"
	}
#line 475 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = supports;
#line 475 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2928 "vm-configurator.c"
}


BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type) {
	BoxesVMConfigurator* self = NULL;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	self = (BoxesVMConfigurator*) g_type_create_instance (object_type);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return self;
#line 2938 "vm-configurator.c"
}


BoxesVMConfigurator* boxes_vm_configurator_new (void) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return boxes_vm_configurator_construct (BOXES_TYPE_VM_CONFIGURATOR);
#line 2945 "vm-configurator.c"
}


static void boxes_value_vm_configurator_init (GValue* value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	value->data[0].v_pointer = NULL;
#line 2952 "vm-configurator.c"
}


static void boxes_value_vm_configurator_free_value (GValue* value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (value->data[0].v_pointer) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_unref (value->data[0].v_pointer);
#line 2961 "vm-configurator.c"
	}
}


static void boxes_value_vm_configurator_copy_value (const GValue* src_value, GValue* dest_value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (src_value->data[0].v_pointer) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		dest_value->data[0].v_pointer = boxes_vm_configurator_ref (src_value->data[0].v_pointer);
#line 2971 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2975 "vm-configurator.c"
	}
}


static gpointer boxes_value_vm_configurator_peek_pointer (const GValue* value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return value->data[0].v_pointer;
#line 2983 "vm-configurator.c"
}


static gchar* boxes_value_vm_configurator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (collect_values[0].v_pointer) {
#line 2990 "vm-configurator.c"
		BoxesVMConfigurator* object;
		object = collect_values[0].v_pointer;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (object->parent_instance.g_class == NULL) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2997 "vm-configurator.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3001 "vm-configurator.c"
		}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = boxes_vm_configurator_ref (object);
#line 3005 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = NULL;
#line 3009 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return NULL;
#line 3013 "vm-configurator.c"
}


static gchar* boxes_value_vm_configurator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BoxesVMConfigurator** object_p;
	object_p = collect_values[0].v_pointer;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (!object_p) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3024 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (!value->data[0].v_pointer) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*object_p = NULL;
#line 3030 "vm-configurator.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*object_p = value->data[0].v_pointer;
#line 3034 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*object_p = boxes_vm_configurator_ref (value->data[0].v_pointer);
#line 3038 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return NULL;
#line 3042 "vm-configurator.c"
}


GParamSpec* boxes_param_spec_vm_configurator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BoxesParamSpecVMConfigurator* spec;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_VM_CONFIGURATOR), NULL);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return G_PARAM_SPEC (spec);
#line 3056 "vm-configurator.c"
}


gpointer boxes_value_get_vm_configurator (const GValue* value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR), NULL);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return value->data[0].v_pointer;
#line 3065 "vm-configurator.c"
}


void boxes_value_set_vm_configurator (GValue* value, gpointer v_object) {
	BoxesVMConfigurator* old;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	old = value->data[0].v_pointer;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (v_object) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = v_object;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_ref (value->data[0].v_pointer);
#line 3085 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = NULL;
#line 3089 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (old) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_unref (old);
#line 3095 "vm-configurator.c"
	}
}


void boxes_value_take_vm_configurator (GValue* value, gpointer v_object) {
	BoxesVMConfigurator* old;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	old = value->data[0].v_pointer;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (v_object) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = v_object;
#line 3114 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = NULL;
#line 3118 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (old) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_unref (old);
#line 3124 "vm-configurator.c"
	}
}


static void boxes_vm_configurator_class_init (BoxesVMConfiguratorClass * klass) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_parent_class = g_type_class_peek_parent (klass);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	BOXES_VM_CONFIGURATOR_CLASS (klass)->finalize = boxes_vm_configurator_finalize;
#line 3134 "vm-configurator.c"
}


static void boxes_vm_configurator_instance_init (BoxesVMConfigurator * self) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	self->ref_count = 1;
#line 3141 "vm-configurator.c"
}


static void boxes_vm_configurator_finalize (BoxesVMConfigurator* obj) {
	BoxesVMConfigurator * self;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator);
#line 3149 "vm-configurator.c"
}


GType boxes_vm_configurator_get_type (void) {
	static volatile gsize boxes_vm_configurator_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_vm_configurator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { boxes_value_vm_configurator_init, boxes_value_vm_configurator_free_value, boxes_value_vm_configurator_copy_value, boxes_value_vm_configurator_peek_pointer, "p", boxes_value_vm_configurator_collect_value, "p", boxes_value_vm_configurator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BoxesVMConfiguratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_vm_configurator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesVMConfigurator), 0, (GInstanceInitFunc) boxes_vm_configurator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType boxes_vm_configurator_type_id;
		boxes_vm_configurator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesVMConfigurator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&boxes_vm_configurator_type_id__volatile, boxes_vm_configurator_type_id);
	}
	return boxes_vm_configurator_type_id__volatile;
}


gpointer boxes_vm_configurator_ref (gpointer instance) {
	BoxesVMConfigurator* self;
	self = instance;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_atomic_int_inc (&self->ref_count);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return instance;
#line 3174 "vm-configurator.c"
}


void boxes_vm_configurator_unref (gpointer instance) {
	BoxesVMConfigurator* self;
	self = instance;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		BOXES_VM_CONFIGURATOR_GET_CLASS (self)->finalize (self);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3187 "vm-configurator.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 3195 "vm-configurator.c"
		int i;
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
				destroy_func (((gpointer*) array)[i]);
#line 3203 "vm-configurator.c"
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	g_free (array);
#line 3215 "vm-configurator.c"
}



