/* child.c */
#include <gnome.h>
#include <glib.h>

#include <ctype.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <stdarg.h>
#include <signal.h>

#include "portab.h"
#include "child.h"
#include "board.h"
#include "cho1.h"
#include "pro.h"
#include "var.h"

/*#define DEBUG*/

struct engine { 
  FILE *read_from;
  FILE *write_to;
  pid_t childpid;
};

static GSList *engines=NULL;


static int start_child(char *cmd, char *arg, FILE **readpipe, FILE **writepipe,pid_t *childpid)
{
int pipe1[2],pipe2[2];

if((pipe(pipe1) <0) || (pipe(pipe2) < 0))
  {
    perror("pipe");
    exit(-1);
  }

if((*childpid = fork())<0)
  {
    perror("fork");
    exit(-1);
  }
else if (*childpid > 0) /* Parent */
  {
    close(pipe1[0]);
    close(pipe2[1]);

    *readpipe  = fdopen(pipe2[0],"r");
    *writepipe = fdopen(pipe1[1],"w");
    setlinebuf(*writepipe);

    return *childpid;
  }
else   /* Child */
  {
    close(pipe1[1]);
    close(pipe2[0]);

    dup2(pipe1[0],0);
    dup2(pipe2[1],1);

    close(pipe1[0]);
    close(pipe2[1]);

#ifdef DEBUG
    fprintf (stderr,"cmd: %s %s\n",cmd,arg);
#endif
    if (execlp(cmd,cmd,arg,NULL) <0)
      perror("execlp");
    return 0;
  }

// NOT REACHED
  abort(); 
  return 0;
}

// Kill Child
static int stop_child(pid_t childpid)
{

 if ( kill(childpid,SIGTERM) )
   { 
#ifdef DEBUG 
     fprintf(stderr,"kill failed\n");
#endif
     return 1;
   }
 return 0;
}

void engine_write(struct engine *e, char *format,...)
{
  FILE *file= e->write_to;

  va_list ap;
  va_start(ap,format);
  vfprintf(file,format,ap);
#ifdef DEBUG
  vfprintf(stderr,format,ap);  
#endif
  va_end(ap);
}

static void engine_move(char *p)
{
	    int from,to,piece;

	    ascii_to_move(p,&from,&to);
#ifdef DEBUG
	    printf("move detected: %s %d %d\n",p+4,from,to);
#endif
	    piece= feld[from];
	    make_move(from,to);
	    notation_update(piece,from,to);
	    update_board();
}

static void engine_cb( gpointer data,
		gint     source,
		GdkInputCondition condition)
{
  static char buf[1024];
  static char *b=buf;

  char *p,*q;
  ssize_t len;

  len = read(source, b, sizeof buf - 1 - (b-buf));
  if (len > 0) 
    {
      b[len] = 0;
      b += len;
    }

  while(1)
    {
      char tmp;

      q = strchr(buf,'\n');
      if ( q == NULL) break;
      tmp = *(q+1);
      *(q+1) = 0;

      // fputs(buf,stderr);
      gtk_text_insert (GTK_TEXT(board.messages), NULL,
                    0,
		    NULL,
                    buf, -1);
      *q=0;
      *(q+1) = tmp;

      // parse for  NUMBER ... MOVE  
  
      if (isdigit(*buf))
	if ((p = strstr(buf,"...")))
	    engine_move(p+4);

      // parse for move MOVE
      if (!strncmp("move",buf,4))
	    engine_move(buf+5);

      memmove( buf, q+1, sizeof(buf) - ( q + 1 - buf));
      b -= (q + 1 - buf );
    }
}

struct engine * new_engine(char *cmd, char *arg)
{
  struct engine *e;

  e = malloc( sizeof(struct engine));
  start_child(cmd, arg, &e->read_from, &e->write_to, &e->childpid);

  engines = g_slist_append(engines,e);
  gdk_input_add( fileno(e->read_from), GDK_INPUT_READ, engine_cb, e);

  return e;
}

static int destroy_engine( struct engine *e)
{
  return stop_child(e->childpid);
}

void destroy_all_engines()
{
  int i;
  int n = g_slist_length(engines);

  for (i=0;i<n;i++)
    {
      void *e = g_slist_nth_data (engines,i);
      destroy_engine(e); 
    }
}

  
