#include <glib.h>

#include "portab.h"
#include "typedef.h"
#include "makros.h"
#include "var.h"
#include "pro.h"



static const int jump[]={ 8, 12,19, 21,-8,-12,-19,-21,     
                   9, 11,-9,-11, 1, 10,-10, -1,     
                   9, 11, 1, 10,-1,  1, 10, -1,
                  -9,-11, 1,-10,-1     };


static BYTE *index,*sindex;

static void sdouble(WORD af,WORD a,WORD b);
static void wdouble(WORD af,WORD a,WORD b);
static void neuer_zug(WORD von,WORD nach);
static void neuer_szug(WORD von,WORD nach);
static void s_ro_l(void);
static void s_ro_k(void);
static void w_ro_k(void);
static void w_ro_l(void);

static void wbauer2(REG WORD af);
static void wbauer3(REG WORD af);
static void wbauer5(REG WORD af);
static void wbauer7(WORD af);
static void wb_um2(WORD af,WORD ef);
static void wstpringer(WORD af);
static void wlaeufer(WORD af);
static void wturm(WORD af);
static void wdame(WORD af);
static void wkoenig(WORD af);
static void wkoenigro(WORD af);

static void sbauer7(REG WORD af);
static void sbauer6(REG WORD af);
static void sbauer4(REG WORD af);
static void sbauer2(REG WORD af);
static void sb_um2(WORD af,WORD ef);
static void sspringer(WORD af);
static void slaeufer(WORD af);
static void sturm(WORD af);
static void sdame(WORD af);
static void skoenigro(WORD af);
static void skoenig(WORD af);



static void inline neuer_zug(WORD von,WORD nach)
{

   *   index          = (BYTE) von;
   * ( index + 1 )    = (BYTE) nach;
       index         += 2;
}

static void wbauer2(REG WORD af)      
{
   register WORD ef;

    ef = af + 10;    
    if (feld[ef] == LEER ) {
        neuer_zug(af,ef);
        ef = af + 20;
        if (feld[ef] == LEER ) {
            neuer_zug(af,ef);
        }
    }
    if (SFIGUR(feld[af + 9 ])) neuer_szug(af,af+9);
    if (SFIGUR(feld[af +11 ])) neuer_szug(af,af+11);
}

static void wbauer3(REG WORD af)  
{
   register WORD ef;

     ef = af + 10;
     if ( feld[ef] == LEER ) neuer_zug(af,ef);

     if ( SFIGUR( feld[af + 9 ] ) ) neuer_szug(af, af + 9 );
     if ( SFIGUR( feld[af +11 ] ) ) neuer_szug(af, af + 11 );
}

static void wbauer5(REG WORD af)   
{

   wbauer3(af);

   if ( ( af - 1 ) == stp->ep )  
       neuer_szug(af,af+9);
   else
   if ( ( af + 1 ) == stp->ep )  
     neuer_szug(af,af+11);
}

static void  wbauer7(WORD af)
{
register WORD ef;

   ef = af + 10;
   if (feld[ef] == LEER ) wb_um2(af,ef);

   if (SFIGUR( feld[af + 9] )) wb_um2( af , af + 9);
   if (SFIGUR( feld[af +11] )) wb_um2 (af , af +11);

}
static void wb_um2(WORD af,WORD ef)
{
register WORD b,i;

        for (i=2;i<6;i++) {
                b = 128 + 8 * i + ef - A8;
                neuer_szug(af,b);
        }
}
static void wstpringer(WORD af)
{
   register WORD a,fi,bb;

   for (a = 0 ; a < 8;a++) {
      bb=af+jump[a];
      fi=feld[bb];

      switch (fi) {
         case LEER:  neuer_zug(af,bb);break;
         case RAND:  break;

         default  :  if (SFIGUR(fi)) neuer_szug(af,bb);
      }
   }
}

static void wlaeufer(WORD af)
{
   WORD a = 8,
        b = 12;

   wdouble(af,a,b);
}

static void wturm(WORD af)
{
   WORD a = 12,
        b = 16;

   wdouble(af,a,b);
}

static void wdame(WORD af)
{
   WORD a = 8,
        b = 16;

   wdouble(af,a,b);
}

static void wkoenig(WORD af)
{
register WORD a;
register WORD fi,bb;

   for (a = 8; a < 16 ; a++) {
      bb=af+jump[a];
      fi=feld[bb];

      switch (fi) {
         case LEER:  neuer_zug(af,bb);break;
         case RAND:  break;

         default  :  if (SFIGUR(fi)) neuer_szug(af,bb);
      }
   }
}

static void wkoenigro(WORD af)  
{
register WORD a;
register WORD fi,bb;

   for (a = 8; a < 16 ; a++) {
      bb=af+jump[a];
      fi=feld[bb];

      switch (fi) {
         case LEER:  neuer_zug(af,bb);break;
         case RAND:  break;

         default  :  if (SFIGUR(fi)) neuer_szug(af,bb);
      }
   }

   if ( stp->wki != E1) return;
   if ( ! stp->wth ) w_ro_k();  
   if ( ! stp->wta ) w_ro_l();  
}
static void w_ro_k(void)
{
  if ( feld[F1] == LEER &&
       feld[G1] == LEER &&
       feld[H1] == WT)
    neuer_zug(E1,G1);

}
static void w_ro_l(void)
{
  if (feld[D1] == LEER &&
      feld[C1] == LEER &&
      feld[B1] == LEER &&
      feld[A1] == WT) 
    neuer_zug(E1,C1);
}
static void wdouble(WORD af,WORD a,WORD b)   
{
        WORD jp,
             ef = af,
             fi;

        for ( ; a < b ; a ++ )
        {
                ef = af;
                jp = jump[a];

                do {
                        ef += jp;
                        fi  = feld[ef];

                        if ( fi == LEER )   neuer_zug(af,ef);
                else    if ( fi == RAND )   break;
                else    if ( SFIGUR(fi) ) { neuer_szug(af,ef);break; }
                else    break;
                }       while ( TRUE );
        }
}

static void sbauer7(REG WORD af)      
{
   register WORD ef;

    ef = af - 10;                
    if (feld[ef] == LEER ) {
        neuer_zug(af,ef);
        ef = af - 20;            
        if (feld[ef] == LEER ) {
            neuer_zug(af,ef);
        }
    }


    if (WFIGUR(feld[af - 9 ])) neuer_szug(af,af-9);
    if (WFIGUR(feld[af -11 ])) neuer_szug(af,af-11);
}

static void sbauer6(REG WORD af)                
{
   register WORD ef;

     ef = af - 10;
     if ( feld[ef] == LEER ) neuer_zug(af,ef);

     if ( WFIGUR( feld[af - 9 ] ) ) neuer_szug(af, af - 9 );
     if ( WFIGUR( feld[af -11 ] ) ) neuer_szug(af, af - 11 );
}

static void sbauer4(REG WORD af)         
{
   sbauer6(af);

   if (( af - 1) == stp->ep )   
     neuer_szug( af, af-11);
   if (( af + 1) == stp->ep ) 
     neuer_szug( af, af-9);
}

static void  sbauer2(REG WORD af)  
{
register WORD ef;

   ef = af - 10;
   if (feld[ef] == LEER ) sb_um2(af,ef);


   if (WFIGUR( feld[af - 9] )) sb_um2( af , af - 9);
   if (WFIGUR( feld[af -11] )) sb_um2 (af , af -11);

}
static void sb_um2(WORD af,WORD ef)    
{
register WORD b,i;
 for (i=2;i<6;i++)
   {
     b = 128 + 8 * i + ef - A1;
     neuer_szug(af,b);
   }
}
static void sspringer(WORD af)
{
   register WORD a,fi,bb;

   for (a = 0 ; a < 8;a++) {
      bb=af+jump[a];
      fi=feld[bb];

      switch (fi) {
         case LEER:  neuer_zug(af,bb);break;
         case RAND:  break;

         default  :  if (WFIGUR(fi)) neuer_szug(af,bb);
      }
   }
}

static void slaeufer(WORD af)
{
   WORD a=8,
        b=12;

   sdouble(af,a,b);
}

static void sturm(WORD af)
{
   WORD a = 12,
        b = 16;

   sdouble(af,a,b);
}

static void sdame(WORD af)
{
   WORD a=8,
        b=16;

   sdouble(af,a,b);
}

static void skoenig(WORD af)
{
register WORD a;
register WORD fi,bb;

   for (a = 8; a < 16 ; a++) {
      bb=af+jump[a];
      fi=feld[bb];

      switch (fi) {
         case LEER:  neuer_zug(af,bb);break;
         case RAND:  break;

         default  :  if (WFIGUR(fi)) neuer_szug(af,bb);
      }
   }
}

static void skoenigro(WORD af)     
{
register WORD a;
register WORD fi,bb;

   for (a = 8; a < 16 ; a++) {
      bb=af+jump[a];
      fi=feld[bb];

      switch (fi) {
         case LEER:  neuer_zug(af,bb);break;
         case RAND:  break;

         default  :  if (WFIGUR(fi)) neuer_szug(af,bb);
      }
   }

   if ( stp->ski != E8) return;
   if ( ! stp->sth ) s_ro_k();  
   if ( ! stp->sta ) s_ro_l();  
}
static void s_ro_k(void)
{

  if ( feld[F8] == LEER &&
       feld[G8] == LEER && 
       feld[H8] == ST)
    neuer_zug(E8,G8);

}
static void s_ro_l(void)
{
  if (feld[D8] == LEER &&
      feld[C8] == LEER &&
      feld[B8] == LEER &&
      feld[A8] == ST) 
    neuer_zug(E8,C8);
}
static void sdouble(WORD af,WORD a,WORD b)  
{
        WORD jp,
             ef = af,
             fi;

        for ( ; a < b ; a ++ )
        {
                ef = af;
                jp = jump[a];

                do
                {
                        ef += jp;
                        fi  = feld[ef];

                        if ( fi == LEER )   neuer_zug(af,ef);
                else    if ( fi == RAND )   break;
                else    if ( WFIGUR(fi) ) { neuer_szug(af,ef);break; }
                else    break;
                }       while ( TRUE );
        }
}

static void neuer_szug(WORD von,WORD nach)  
{
               sindex       -= 2;
            *  sindex        = (BYTE) von;
            * (sindex + 1 )  = (BYTE) nach;
}

static int movgen_white(BYTE **index0,WORD *anz_s,WORD *anz_n)
{
   register WORD af,figur;

   index = sindex = *index0;

      for( af = A1 ; af <= H1 ; af++ ) {
         figur = feld[af];
            if ( WFIGUR(figur)) { 
               switch (figur)   {
                  case    WB: abort();          break;
                  case    WS: wstpringer(af);       break;
                  case    WL: wlaeufer(af);         break;
                  case    WT: wturm(af);            break;
                  case    WD: wdame(af);            break;
                  case    WK: wkoenigro(af);        break;
               }
            }
      }
      for( af = A2 ; af <= H2 ; af++ ) {
         figur = feld[af];
            if ( WFIGUR(figur)) { 
               switch (figur)   {
                  case    WB: wbauer2(af);          break;
                  case    WS: wstpringer(af);        break;
                  case    WL: wlaeufer(af);         break;
                  case    WT: wturm(af);            break;
                  case    WD: wdame(af);            break;
                  case    WK: wkoenig(af);          break;
               }
            }
      }
      for( af = A3 ; af <= H3 ; af++ ) {
         figur = feld[af];
            if ( WFIGUR(figur)) { 
               switch (figur)   {
                  case    WB: wbauer3(af);          break;
                  case    WS: wstpringer(af);        break;
                  case    WL: wlaeufer(af);         break;
                  case    WT: wturm(af);            break;
                  case    WD: wdame(af);            break;
                  case    WK: wkoenig(af);          break;
               }
            }
      }
      for( af = A4 ; af <= H4 ; af++ ) {
         figur = feld[af];
            if ( WFIGUR(figur)) {
               switch (figur)   {
                  case    WB: wbauer3(af);          break;
                  case    WS: wstpringer(af);        break;
                  case    WL: wlaeufer(af);         break;
                  case    WT: wturm(af);            break;
                  case    WD: wdame(af);            break;
                  case    WK: wkoenig(af);          break;
               }
            }
      }
      for( af = A5 ; af <= H5 ; af++ ) {
         figur = feld[af];
            if ( WFIGUR(figur)) {
               switch (figur)   {
                  case    WB: wbauer5(af);          break;
                  case    WS: wstpringer(af);        break;
                  case    WL: wlaeufer(af);         break;
                  case    WT: wturm(af);            break;
                  case    WD: wdame(af);            break;
                  case    WK: wkoenig(af);          break;
               }
            }
      }
      for( af = A6 ; af <= H6 ; af++ ) {
         figur = feld[af];
            if ( WFIGUR(figur)) {
               switch (figur)   {
                  case    WB: wbauer3(af);          break;
                  case    WS: wstpringer(af);        break;
                  case    WL: wlaeufer(af);         break;
                  case    WT: wturm(af);            break;
                  case    WD: wdame(af);            break;
                  case    WK: wkoenig(af);          break;
               }
            }
      }
      for( af = A7 ; af <= H7 ; af++ ) {
         figur = feld[af];
            if ( WFIGUR(figur)) {
               switch (figur)   {
                  case    WB: wbauer7(af);          break;
                  case    WS: wstpringer(af);        break;
                  case    WL: wlaeufer(af);         break;
                  case    WT: wturm(af);            break;
                  case    WD: wdame(af);            break;
                  case    WK: wkoenig(af);          break;
               }
            }
      }
      for( af = A8 ; af <= H8 ; af++ ) {
         figur = feld[af];
            if ( WFIGUR(figur)) {
               switch (figur)   {
                  case    WB: abort();          break;
                  case    WS: wstpringer(af);        break;
                  case    WL: wlaeufer(af);         break;
                  case    WT: wturm(af);            break;
                  case    WD: wdame(af);            break;
                  case    WK: wkoenig(af);          break;
               }
            }
         }

      *anz_n = (WORD) (( index  - *index0) / 2) ;
      *anz_s = (WORD) (( *index0 - sindex) / 2 );

      af = *anz_n + *anz_s ;
      *index0 = sindex;

      return af;
}

static int movgen_black(BYTE **index0,WORD *anz_s,WORD *anz_n)
{
   register WORD af,figur;

   index = sindex = *index0;

      for( af = A1 ; af <= H1 ; af++ ) {
         figur = feld[af];
            if (SFIGUR(figur)) {
               switch (figur) {
                  case   SB: abort();          break;
                  case   SS: sspringer(af);        break;
                  case   SL: slaeufer(af);         break;
                  case   ST: sturm(af);            break;
                  case   SD: sdame(af);            break;
                  case   SK: skoenig(af);        break;
               }
            }
      }
      for( af = A2 ; af <= H2 ; af++ ) {
         figur = feld[af];
            if (SFIGUR(figur)) {
               switch (figur) {
                  case   SB: sbauer2(af);          break;
                  case   SS: sspringer(af);        break;
                  case   SL: slaeufer(af);         break;
                  case   ST: sturm(af);            break;
                  case   SD: sdame(af);            break;
                  case   SK: skoenig(af);          break;
               }
            }
      }
      for( af = A3 ; af <= H3 ; af++ ) {
         figur = feld[af];
            if (SFIGUR(figur)) {
               switch (figur) {
                  case   SB: sbauer6(af);          break;
                  case   SS: sspringer(af);        break;
                  case   SL: slaeufer(af);         break;
                  case   ST: sturm(af);            break;
                  case   SD: sdame(af);            break;
                  case   SK: skoenig(af);          break;
               }
            }
      }
      for( af = A4 ; af <= H4 ; af++ ) {
         figur = feld[af];
            if (SFIGUR(figur)) {
               switch (figur) {
                  case   SB: sbauer4(af);          break;
                  case   SS: sspringer(af);        break;
                  case   SL: slaeufer(af);         break;
                  case   ST: sturm(af);            break;
                  case   SD: sdame(af);            break;
                  case   SK: skoenig(af);          break;
               }
            }
      }
      for( af = A5 ; af <= H5 ; af++ ) {
         figur = feld[af];
            if (SFIGUR(figur)) {
               switch (figur) {
                  case   SB: sbauer6(af);          break;
                  case   SS: sspringer(af);        break;
                  case   SL: slaeufer(af);         break;
                  case   ST: sturm(af);            break;
                  case   SD: sdame(af);            break;
                  case   SK: skoenig(af);          break;
               }
            }
      }
      for( af = A6 ; af <= H6 ; af++ ) {
         figur = feld[af];
            if (SFIGUR(figur)) {
               switch (figur) {
                  case   SB: sbauer6(af);          break;
                  case   SS: sspringer(af);        break;
                  case   SL: slaeufer(af);         break;
                  case   ST: sturm(af);            break;
                  case   SD: sdame(af);            break;
                  case   SK: skoenig(af);          break;
               }
            }
      }
      for( af = A7 ; af <= H7 ; af++ ) {
         figur = feld[af];
            if (SFIGUR(figur)) {
               switch (figur) {
                  case   SB: sbauer7(af);          break;
                  case   SS: sspringer(af);        break;
                  case   SL: slaeufer(af);         break;
                  case   ST: sturm(af);            break;
                  case   SD: sdame(af);            break;
                  case   SK: skoenig(af);          break;
               }
            }
      }
      for( af = A8 ; af <= H8 ; af++ ) {
         figur = feld[af];
            if (SFIGUR(figur)) {
               switch (figur) {
                  case   SB: abort();          break;
                  case   SS: sspringer(af);        break;
                  case   SL: slaeufer(af);         break;
                  case   ST: sturm(af);            break;
                  case   SD: sdame(af);            break;
                  case   SK: skoenigro(af);          break;
               }
            }
      }

      *anz_n = (WORD) (( index  - *index0) / 2) ;
      *anz_s = (WORD) (( *index0 - sindex) / 2 );
     
      af = *anz_n + *anz_s ;
      *index0 = sindex;

      return af;
}


int  move_generator(BYTE **index0,WORD *anz_s,WORD *anz_n)
{
        if (stp->amzug == WAZ ) return movgen_white(index0,anz_s,anz_n);
        else
        if (stp->amzug == SAZ ) return  movgen_black(index0,anz_s,anz_n);
        else
        abort();
}
