/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "makros.h"
#include "timer.h"
#include "board_info.h"

/* Prototypes */
static void class_init (BoardInfoClass *class);
static void init (BoardInfo *info);

guint
board_info_get_type (void)
{
	static guint board_info_type = 0;

         if (!board_info_type) {
           GtkTypeInfo board_info_info = {
               "BoardInfo",
               sizeof (BoardInfo),
               sizeof (BoardInfoClass),
               (GtkClassInitFunc) class_init,
               (GtkObjectInitFunc) init,
               (GtkArgSetFunc) NULL,
               (GtkArgGetFunc) NULL
             };
             board_info_type = gtk_type_unique (gtk_vbox_get_type (), &board_info_info);
           }

         return board_info_type;
}

static void
class_init (BoardInfoClass *class)
{
}

static void
init (BoardInfo *info)
{
	GtkStyle *style;
	GtkWidget *wcont, *bcont;

	/* Set defaults */
	gtk_box_set_homogeneous (GTK_BOX (info), FALSE);
	gtk_box_set_spacing (GTK_BOX (info), 2);

	/* Players */
	info->white_name = gtk_label_new (_("White"));
	gtk_label_set_justify (GTK_LABEL (info->white_name), GTK_JUSTIFY_LEFT);
	info->black_name = gtk_label_new (_("Black"));
	gtk_label_set_justify (GTK_LABEL (info->black_name), GTK_JUSTIFY_LEFT);
	gtk_widget_show (info->white_name);
	gtk_widget_show (info->black_name);

	/* The Timers */
	info->white_time = timer_new (300);
	info->black_time = timer_new (300);
	gtk_widget_show (info->white_time);
	gtk_widget_show (info->black_time);

	/* The Result */
	info->result = gtk_label_new ("");
	info->resultval = NONE;
	gtk_widget_show (info->result);

	/* Style */
	style = gtk_style_new ();
	style->font = gdk_font_load ("-adobe-courier-medium-r-normal-*-*-180-*-*-m-*-iso8859-1");
	gtk_widget_set_style (info->white_name, style);	
	gtk_widget_set_style (info->black_name, style);
	style->font = gdk_font_load ("-adobe-courier-medium-r-normal-*-*-240-*-*-m-*-iso8859-1");
	gtk_widget_set_style (info->white_time, style);	
	gtk_widget_set_style (info->black_time, style);
	gtk_style_unref (style);
	
	wcont = gtk_vbox_new (TRUE,  2);
	gtk_box_pack_start (GTK_BOX (wcont), info->white_name, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (wcont), info->white_time, TRUE, TRUE, 0);
	gtk_widget_show (wcont);
	
	bcont = gtk_vbox_new (TRUE, 2);
	gtk_box_pack_start (GTK_BOX (wcont), info->black_name, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (wcont), info->black_time, TRUE, TRUE, 0);
	gtk_widget_show (bcont);
	
	gtk_container_add (GTK_CONTAINER (info), wcont);
	gtk_container_add (GTK_CONTAINER (info), bcont);
	gtk_container_add (GTK_CONTAINER (info), info->result);

}

GtkWidget *
board_info_new (void)
{
	return GTK_WIDGET(gtk_type_new(board_info_get_type()));
}

void
board_info_set_game_info (BoardInfo *info, GameInfo *gameinfo)
{
	board_info_set_white_name(info, gameinfo->white);
	board_info_set_black_name(info, gameinfo->black);
	board_info_set_white_time(info, gameinfo->white_time);
	board_info_set_black_time(info, gameinfo->black_time);
	board_info_set_result(info, gameinfo->result);
	if (gameinfo->result == GAME_PROGRESS &&
	    gameinfo->tomove == WHITE) {
		timer_start(TIMER(info->white_time));
		timer_stop(TIMER(info->black_time));
	} else if (gameinfo->result == GAME_PROGRESS &&
		   gameinfo->tomove == BLACK) {
		timer_start(TIMER(info->black_time));
		timer_stop(TIMER(info->white_time));
	} else {
		timer_stop(TIMER(info->white_time));
		timer_stop(TIMER(info->black_time));
	}
}

gchar *board_info_get_white_name(BoardInfo *info) {
	gchar *str;

	gtk_label_get(GTK_LABEL(info->white_name), &str);

	return str;
}

void board_info_set_white_name(BoardInfo *info, const gchar *name) {

	gtk_label_set_text(GTK_LABEL(info->white_name), name);
}

gchar *board_info_get_black_name(BoardInfo *info) {
	gchar *str;

	gtk_label_get(GTK_LABEL(info->black_name), &str);

	return str;
}

void board_info_set_black_name(BoardInfo *info, const gchar *name) {

	gtk_label_set_text(GTK_LABEL(info->black_name), name);
}

gint
board_info_get_white_time(BoardInfo *info)
{
	return timer_get(TIMER(info->white_time));
}

void
board_info_set_white_time(BoardInfo *info, gint secs)
{
	timer_set(TIMER(info->white_time), secs);
}

gint
board_info_get_black_time(BoardInfo *info)
{
	return timer_get(TIMER(info->black_time));
}

void
board_info_set_black_time(BoardInfo *info, gint secs)
{
	timer_set(TIMER(info->black_time), secs);
}

gint
board_info_get_result(BoardInfo *info)
{
	return info->resultval;
}

void
board_info_set_result(BoardInfo *info, gint result)
{
	switch (result) {
	case GAME_PROGRESS:
		gtk_label_set_text(GTK_LABEL(info->result),
				   _("In progress..."));
		break;
	case GAME_WHITE:
		gtk_label_set_text(GTK_LABEL(info->result),
				   _("1-0"));
		break;
	case GAME_BLACK:
		gtk_label_set_text(GTK_LABEL(info->result),
				   _("0-1"));
		break;
	case GAME_DRAW:
		gtk_label_set_text(GTK_LABEL(info->result),
				   _("1/2-1/2"));
		break;
	default:
		gtk_label_set_text(GTK_LABEL(info->result), "");
	}
		
	info->resultval=result;
	
}

