/*  -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * 
 * This file is part of the GNOME Debugging Framework.
 * 
 * Copyright (C) 1999-2000 Dave Camp <campd@oit.edu>
 *                         Martin Baulig <martin@home-of-linux.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#include <config.h>
#include <gnome.h>
#include <bonobo.h>
#include <liboaf/liboaf.h>

#include "control-factories.h"

void
control_server_quit ()
{
	gtk_main_quit ();
}

int
main (int argc, char *argv[])
{
	CORBA_Environment ev;

	CORBA_exception_init (&ev);
#if 0 /* goad stuff */
	orb = gnome_CORBA_init ("gdf-server", VERSION, &argc, argv,
							GNORBA_INIT_SERVER_FUNC, &ev);
#endif
    gnome_init_with_popt_table ("gdf-server", VERSION, argc, argv, 
                                oaf_popt_options, 0, NULL);
    oaf_init (argc, argv);

	if (!bonobo_init (oaf_orb_get(), NULL, NULL)) 
		g_error (_("Can't initialize bonobo!"));
	
	init_control_factories ();

	bonobo_main ();

	return 0;
}

