/*  -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * 
 * This file is part of the GNOME Debugging Framework.
 * 
 * Copyright (C) 1999-2000 Dave Camp <campd@oit.edu>
 *                         Martin Baulig <martin@home-of-linux.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#ifndef __GDF_DEBUGGER_CLIENT_H__
#define __GDF_DEBUGGER_CLIENT_H__

#include <bonobo.h>
#include "gnome-debug.h"

BEGIN_GNOME_DECLS

#include "gdf-event-channel-client.h"

#define GDF_DEBUGGER_CLIENT_TYPE		(gdf_debugger_client_get_type ())
#define GDF_DEBUGGER_CLIENT(o)		(GTK_CHECK_CAST ((o), GDF_DEBUGGER_CLIENT_TYPE, GdfDebuggerClient))
#define GDF_DEBUGGER_CLIENT_CLASS(k)	(GTK_CHECK_CLASS_CAST((k), GDF_DEBUGGER_CLIENT_TYPE, GdfDebuggerClientClass))
#define GDF_IS_DEBUGGER_CLIENT(o)		(GTK_CHECK_TYPE ((o), GDF_DEBUGGER_CLIENT_TYPE))
#define GDF_IS_DEBUGGER_CLIENT_CLASS(k)	(GTK_CHECK_CLASS_TYPE ((k), GDF_DEBUGGER_CLIENT_TYPE))

typedef struct _GdfDebuggerClient        GdfDebuggerClient;
typedef struct _GdfDebuggerClientPrivate GdfDebuggerClientPrivate;
typedef struct _GdfDebuggerClientClass   GdfDebuggerClientClass;


struct _GdfDebuggerClient {
    GtkObject parent;
    
    CORBA_Object objref;
    gboolean program_loaded;
    GdfDebuggerClientPrivate *priv;
};

struct _GdfDebuggerClientClass {
    GtkObjectClass parent_class;
    
    void (*unknown_event_pushed) (GdfEventChannelClient *,
                                  const char *, 
                                  CORBA_any *);
    void (*program_loaded) (GdfDebuggerClient *);
    void (*program_unloaded) (GdfDebuggerClient *);
    void (*breakpoint_set) (GdfDebuggerClient *, gint bp_num);
    void (*breakpoint_enabled) (GdfDebuggerClient *, gint bp_num);
    void (*breakpoint_disabled) (GdfDebuggerClient *, gint bp_num);
    void (*breakpoint_deleted) (GdfDebuggerClient *, gint bp_num);
    void (*execution_started) (GdfDebuggerClient *);
    void (*execution_running) (GdfDebuggerClient *);
    void (*execution_stopped) (GdfDebuggerClient *);
    void (*execution_killed) (GdfDebuggerClient *, gint signal);
    void (*execution_exited) (GdfDebuggerClient *, gint exit_code);
    void (*execution_source_line) (GdfDebuggerClient *, 
                                   const gchar *filename,
                                   gint source_line);
    void (*symbol_set_changed) (GdfDebuggerClient *, gint set_id);
    void (*symbol_changed) (GdfDebuggerClient *, gint set_id, gint handle);
    void (*symbol_expanded) (GdfDebuggerClient *, gint set_id, gint handle);
    void (*stack_frame_changed) (GdfDebuggerClient *, gint new_id);
    void (*signal_received) (GdfDebuggerClient *, char *sig_id);
    void (*signal_termination) (GdfDebuggerClient *, char *sig_id);
};

GdfDebuggerClient *gdf_debugger_client_new (const char *iid);
GdfDebuggerClient *gdf_debugger_client_new_from_corba (GDF_Debugger debugger);
GtkType gdf_debugger_client_get_type (void);

GDF_Debugger_State gdf_debugger_client_get_state (GdfDebuggerClient *dbg);
gboolean gdf_debugger_client_load_binary (GdfDebuggerClient *dbg, 
                                          gchar *file_name);
void gdf_debugger_client_unload_binary (GdfDebuggerClient *dbg);

void gdf_debugger_client_execute (GdfDebuggerClient *dbg, 
                                  int argc,
                                  char *argv[]);
void gdf_debugger_client_attach (GdfDebuggerClient *dbg, 
                                 int pid);
void gdf_debugger_client_load_corefile (GdfDebuggerClient *dbg,
                                        const char*corefile_name);

GDF_source_file_list *
gdf_debugger_client_get_sources (GdfDebuggerClient *dbg);
gchar *gdf_debugger_client_get_absolute_source_path (GdfDebuggerClient *dbg,
                                                     const gchar *file_name);
long gdf_debugger_client_set_breakpoint (GdfDebuggerClient *dbg,
                                         const char *file_name,
                                         long line_num,
                                         const char *condition);
long gdf_debugger_client_set_breakpoint_function (GdfDebuggerClient *dbg,
                                                  const char *file_name,
                                                  const char *function_name,
                                                  const char *condition);
void gdf_debugger_client_enable_breakpoint (GdfDebuggerClient *dbg,
                                            long bp_num);
void gdf_debugger_client_disable_breakpoint (GdfDebuggerClient *dbg,
                                             long bp_num);
void gdf_debugger_client_delete_breakpoint (GdfDebuggerClient *dbg,
                                            long bp_num);
GDF_Breakpoint *
gdf_debugger_client_get_breakpoint_info (GdfDebuggerClient *dbg,
                                         long bp_num);
GDF_RegisterList *gdf_debugger_client_get_registers (GdfDebuggerClient *dbg);

long gdf_debugger_client_current_frame (GdfDebuggerClient *dbg);
void gdf_debugger_client_up_frame (GdfDebuggerClient *dbg);

void gdf_debugger_client_down_frame (GdfDebuggerClient *dbg);
void gdf_debugger_client_change_frame (GdfDebuggerClient *dbg, 
                                        long new_id);
GDF_StackFrame *gdf_debugger_client_get_frame (GdfDebuggerClient *dbg,
                                                long id);
GDF_Stack *gdf_debugger_client_get_backtrace (GdfDebuggerClient *dbg);

void gdf_debugger_client_cont (GdfDebuggerClient *dbg);
void gdf_debugger_client_stop (GdfDebuggerClient *dbg);
void gdf_debugger_client_restart (GdfDebuggerClient *dbg);
void gdf_debugger_client_step_over (GdfDebuggerClient *dbg);
void gdf_debugger_client_step_into (GdfDebuggerClient *dbg);
void gdf_debugger_client_step_out (GdfDebuggerClient *dbg);

GDF_SymbolSetId gdf_debugger_client_allocate_symbol_set (GdfDebuggerClient *dbg);
void gdf_debugger_client_destroy_symbol_set (GdfDebuggerClient *dbg,
                                             GDF_SymbolSetId id);
void gdf_debugger_client_add_to_symbol_set (GdfDebuggerClient *dbg,
                                            GDF_SymbolSetId id,
                                            const char *expr);
GDF_SymbolSet *gdf_debugger_client_get_symbol_set (GdfDebuggerClient *dbg,
                                                   GDF_SymbolSetId id);
GDF_Symbol *gdf_debugger_client_get_symbol (GdfDebuggerClient *dbg,
                                            GDF_SymbolSetId id,
                                            int handle);
void gdf_debugger_client_expand_symbol (GdfDebuggerClient *dbg, 
                                        GDF_SymbolSetId id,
                                        int handle,
                                        gboolean expand);
void gdf_debugger_client_set_output_tty (GdfDebuggerClient *dbg,
                                         const char *tty_name);

END_GNOME_DECLS

#endif
