#include <config.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgnome/libgnome.h>
#include <libgnomeui/libgnomeui.h>
#include <gconf/gconf-client.h>

#include <libgnomeui/gnome-hint.h>

int main (int argc, char **argv) {
  GtkWidget *gnome_hint;

  gchar *hintfile, *backimg, *logoimg;

  gnome_program_init("gnome-hint","0.1",LIBGNOMEUI_MODULE,
                                   argc, argv, NULL);

  if (argc !=4){
 	printf("You must specify the location of a hintfile\na background image and a logo image\n\n");
	return (1);
  }

  hintfile = g_strdup(argv[1]);
  backimg = g_strdup(argv[2]);
  logoimg = g_strdup(argv[3]);

  gnome_hint = gnome_hint_new (hintfile, "GNOME Test Hints",
				backimg, logoimg, "/apps/test-hint/startup");

  if (!gnome_hint){
	printf("Bad hintfile\n\n");
	return (2);
  }
 


  g_signal_connect_swapped(GTK_OBJECT(gnome_hint), "destroy",
                           G_CALLBACK (gtk_main_quit), NULL);
  gtk_widget_show_all (GTK_WIDGET(gnome_hint));
  gtk_main ();
  return 0;
}

