/* document_view.c generated by valac 0.56.7, the Vala compiler
 * generated from document_view.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tepl/tepl.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <latexila.h>
#include <gtksourceview/gtksource.h>
#include <gdk/gdk.h>
#include <gspell/gspell.h>
#include <glib/gi18n-lib.h>

#define DOCUMENT_VIEW_METADATA_KEY_SPELL_LANGUAGE "gnome-latex-spell-language"
#define DOCUMENT_VIEW_METADATA_KEY_INLINE_SPELL "gnome-latex-inline-spell"
#define DOCUMENT_VIEW_INLINE_SPELL_ENABLED_STR "1"
#define DOCUMENT_VIEW_INLINE_SPELL_DISABLED_STR "0"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _DocumentViewPrivate DocumentViewPrivate;
enum  {
	DOCUMENT_VIEW_0_PROPERTY,
	DOCUMENT_VIEW_NUM_PROPERTIES
};
static GParamSpec* document_view_properties[DOCUMENT_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block18Data Block18Data;

struct _DocumentView {
	TeplView parent_instance;
	DocumentViewPrivate * priv;
};

struct _DocumentViewClass {
	TeplViewClass parent_class;
};

struct _DocumentViewPrivate {
	GSettings* _editor_settings;
	PangoFontDescription* _font_desc;
};

struct _Block18Data {
	int _ref_count_;
	DocumentView* self;
	GspellChecker* spell_checker;
};

static gint DocumentView_private_offset;
static gpointer document_view_parent_class = NULL;
static gboolean document_view__no_spell_language_dialog_shown;
static gboolean document_view__no_spell_language_dialog_shown = FALSE;

VALA_EXTERN GType document_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN DocumentView* document_view_new (Document* doc);
VALA_EXTERN DocumentView* document_view_construct (GType object_type,
                                       Document* doc);
static void __lambda68_ (DocumentView* self,
                  GObject* d,
                  GParamSpec* p);
VALA_EXTERN gboolean document_get_readonly (Document* self);
static void ___lambda68__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void document_view_setup_font (DocumentView* self);
VALA_EXTERN GType completion_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CompletionProvider, g_object_unref)
VALA_EXTERN CompletionProvider* completion_provider_get_default (void);
VALA_EXTERN GtkSourceCompletion* gtk_source_view_get_completion (GtkSourceView* self);
static void document_view_hide_completion_calltip_when_needed (DocumentView* self);
static void document_view_init_spell_checking (DocumentView* self);
static gboolean document_view_on_button_release_event (DocumentView* self,
                                                GdkEventButton* event);
static gboolean _document_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                 GdkEventButton* event,
                                                                                 gpointer self);
VALA_EXTERN void document_view_set_font_from_settings (DocumentView* self);
static void _document_view_set_font_from_settings_tepl_settings_font_changed (TeplSettings* _sender,
                                                                       gpointer self);
VALA_EXTERN void document_view_enlarge_font (DocumentView* self);
VALA_EXTERN void document_view_shrink_font (DocumentView* self);
VALA_EXTERN GFile* document_get_location (Document* self);
VALA_EXTERN GFile* document_get_main_file (Document* self);
static void __lambda69_ (DocumentView* self);
VALA_EXTERN void completion_provider_hide_calltip_window (CompletionProvider* self);
static void ___lambda69__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static GspellLanguage* document_view_get_spell_language (DocumentView* self);
VALA_EXTERN void document_view_setup_inline_spell_checker (DocumentView* self);
static void document_view_inline_checker_enabled_notify_cb (DocumentView* self);
static void _document_view_inline_checker_enabled_notify_cb_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void __lambda70_ (Block18Data* _data18_);
static void ___lambda70__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda71_ (Block18Data* _data18_);
static void ___lambda71__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda72_ (DocumentView* self);
static void ___lambda72__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static GspellChecker* document_view_get_spell_checker (DocumentView* self);
VALA_EXTERN void document_view_launch_spell_checker_dialog (DocumentView* self);
VALA_EXTERN void document_view_launch_spell_language_chooser_dialog (DocumentView* self);
VALA_EXTERN void document_view_save_spell_language_metadata (DocumentView* self);
VALA_EXTERN void document_set_metadata (Document* self,
                            const gchar* key,
                            const gchar* val);
VALA_EXTERN void document_view_save_inline_spell_metadata (DocumentView* self);
static void document_view_finalize (GObject * obj);
static GType document_view_get_type_once (void);

static inline gpointer
document_view_get_instance_private (DocumentView* self)
{
	return G_STRUCT_MEMBER_P (self, DocumentView_private_offset);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
__lambda68_ (DocumentView* self,
             GObject* d,
             GParamSpec* p)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (d != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = document_get_readonly (G_TYPE_CHECK_INSTANCE_CAST (d, TYPE_DOCUMENT, Document));
	_tmp1_ = _tmp0_;
	gtk_text_view_set_editable ((GtkTextView*) self, !_tmp1_);
}

static void
___lambda68__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda68_ ((DocumentView*) self, _sender, pspec);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_document_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                        GdkEventButton* event,
                                                                        gpointer self)
{
	gboolean result;
	result = document_view_on_button_release_event ((DocumentView*) self, event);
	return result;
}

DocumentView*
document_view_construct (GType object_type,
                         Document* doc)
{
	DocumentView * self = NULL;
	LatexilaSettings* latexila_settings = NULL;
	LatexilaSettings* _tmp0_;
	LatexilaSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (DocumentView*) g_object_new (object_type, NULL);
	gtk_text_view_set_buffer ((GtkTextView*) self, (GtkTextBuffer*) doc);
	g_signal_connect_object ((GObject*) doc, "notify::readonly", (GCallback) ___lambda68__g_object_notify, self, 0);
	latexila_view_setup ((GtkSourceView*) self);
	_tmp0_ = latexila_settings_get_singleton ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	latexila_settings = _tmp1_;
	_tmp2_ = latexila_settings_peek_editor_settings (latexila_settings);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_editor_settings);
	self->priv->_editor_settings = _tmp3_;
	document_view_setup_font (self);
	{
		CompletionProvider* provider = NULL;
		CompletionProvider* _tmp4_;
		GtkSourceCompletion* _tmp5_;
		GtkSourceCompletion* _tmp6_;
		GtkSourceCompletion* _tmp7_;
		GtkSourceCompletion* _tmp8_;
		GtkSourceCompletion* _tmp9_;
		GtkSourceCompletion* _tmp10_;
		GtkSourceCompletion* _tmp11_;
		GtkSourceCompletion* _tmp12_;
		GtkSourceCompletion* _tmp13_;
		GtkSourceCompletion* _tmp14_;
		_tmp4_ = completion_provider_get_default ();
		provider = _tmp4_;
		_tmp5_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp6_ = _tmp5_;
		gtk_source_completion_add_provider (_tmp6_, (GtkSourceCompletionProvider*) provider, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (provider);
			goto __catch0_g_error;
		}
		_tmp7_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp8_ = _tmp7_;
		g_object_set (_tmp8_, "remember-info-visibility", TRUE, NULL);
		_tmp9_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp10_ = _tmp9_;
		g_object_set (_tmp10_, "show-headers", FALSE, NULL);
		_tmp11_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp12_ = _tmp11_;
		g_object_set (_tmp12_, "auto-complete-delay", (guint) 0, NULL);
		_tmp13_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp14_ = _tmp13_;
		g_object_set (_tmp14_, "accelerators", (guint) 0, NULL);
		document_view_hide_completion_calltip_when_needed (self);
		_g_object_unref0 (provider);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("document_view.vala:64: Completion: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (latexila_settings);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	document_view_init_spell_checking (self);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _document_view_on_button_release_event_gtk_widget_button_release_event, self, 0);
	_g_object_unref0 (latexila_settings);
	return self;
}

DocumentView*
document_view_new (Document* doc)
{
	return document_view_construct (TYPE_DOCUMENT_VIEW, doc);
}

static void
_document_view_set_font_from_settings_tepl_settings_font_changed (TeplSettings* _sender,
                                                                  gpointer self)
{
	document_view_set_font_from_settings ((DocumentView*) self);
}

static void
document_view_setup_font (DocumentView* self)
{
	TeplSettings* tepl_settings = NULL;
	TeplSettings* _tmp0_;
	TeplSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	document_view_set_font_from_settings (self);
	_tmp0_ = tepl_settings_get_singleton ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tepl_settings = _tmp1_;
	g_signal_connect_object (tepl_settings, "font-changed", (GCallback) _document_view_set_font_from_settings_tepl_settings_font_changed, self, 0);
	_g_object_unref0 (tepl_settings);
}

void
document_view_set_font_from_settings (DocumentView* self)
{
	gchar* font = NULL;
	TeplSettings* _tmp0_;
	gchar* _tmp1_;
	PangoFontDescription* _tmp2_;
	PangoFontDescription* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tepl_settings_get_singleton ();
	_tmp1_ = tepl_settings_get_selected_font (_tmp0_);
	font = _tmp1_;
	_tmp2_ = pango_font_description_from_string (font);
	__vala_PangoFontDescription_free0 (self->priv->_font_desc);
	self->priv->_font_desc = _tmp2_;
	_tmp3_ = self->priv->_font_desc;
	tepl_utils_override_font_description ((GtkWidget*) self, _tmp3_);
	_g_free0 (font);
}

void
document_view_enlarge_font (DocumentView* self)
{
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
	PangoFontDescription* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_font_desc;
	_tmp1_ = self->priv->_font_desc;
	pango_font_description_set_size (_tmp0_, pango_font_description_get_size (_tmp1_) + PANGO_SCALE);
	_tmp2_ = self->priv->_font_desc;
	tepl_utils_override_font_description ((GtkWidget*) self, _tmp2_);
}

void
document_view_shrink_font (DocumentView* self)
{
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
	PangoFontDescription* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_font_desc;
	_tmp1_ = self->priv->_font_desc;
	pango_font_description_set_size (_tmp0_, pango_font_description_get_size (_tmp1_) - PANGO_SCALE);
	_tmp2_ = self->priv->_font_desc;
	tepl_utils_override_font_description ((GtkWidget*) self, _tmp2_);
}

static gboolean
document_view_on_button_release_event (DocumentView* self,
                                       GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 1)) {
		_tmp0_ = (event->state & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		LatexilaSynctex* synctex = NULL;
		LatexilaSynctex* _tmp1_;
		LatexilaSynctex* _tmp2_;
		Document* doc = NULL;
		GtkTextBuffer* _tmp3_;
		GtkTextBuffer* _tmp4_;
		Document* _tmp5_;
		LatexilaSynctex* _tmp6_;
		GtkTextBuffer* _tmp7_;
		GtkTextBuffer* _tmp8_;
		Document* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		Document* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		_tmp1_ = latexila_synctex_get_instance ();
		_tmp2_ = _g_object_ref0 (_tmp1_);
		synctex = _tmp2_;
		_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _g_object_ref0 (IS_DOCUMENT (_tmp4_) ? ((Document*) _tmp4_) : NULL);
		doc = _tmp5_;
		_tmp6_ = synctex;
		_tmp7_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = doc;
		_tmp10_ = document_get_location (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = doc;
		_tmp13_ = document_get_main_file (_tmp12_);
		_tmp14_ = _tmp13_;
		latexila_synctex_forward_search (_tmp6_, _tmp8_, _tmp11_, _tmp14_, (guint) event->time);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (doc);
		_g_object_unref0 (synctex);
	}
	result = FALSE;
	return result;
}

static void
__lambda69_ (DocumentView* self)
{
	CompletionProvider* provider = NULL;
	CompletionProvider* _tmp0_;
	_tmp0_ = completion_provider_get_default ();
	provider = _tmp0_;
	completion_provider_hide_calltip_window (provider);
	_g_object_unref0 (provider);
}

static void
___lambda69__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda69_ ((DocumentView*) self);
}

static void
document_view_hide_completion_calltip_when_needed (DocumentView* self)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::cursor-position", (GCallback) ___lambda69__g_object_notify, self, 0);
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		DocumentView* self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->spell_checker);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
_document_view_inline_checker_enabled_notify_cb_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
	document_view_inline_checker_enabled_notify_cb ((DocumentView*) self);
}

static void
__lambda70_ (Block18Data* _data18_)
{
	DocumentView* self;
	GspellLanguage* _tmp0_;
	self = _data18_->self;
	_tmp0_ = document_view_get_spell_language (self);
	gspell_checker_set_language (_data18_->spell_checker, _tmp0_);
	document_view_setup_inline_spell_checker (self);
}

static void
___lambda70__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda70_ (self);
}

static void
__lambda71_ (Block18Data* _data18_)
{
	DocumentView* self;
	GspellLanguage* _tmp0_;
	self = _data18_->self;
	_tmp0_ = document_view_get_spell_language (self);
	gspell_checker_set_language (_data18_->spell_checker, _tmp0_);
}

static void
___lambda71__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda71_ (self);
}

static void
__lambda72_ (DocumentView* self)
{
	document_view_setup_inline_spell_checker (self);
}

static void
___lambda72__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda72_ ((DocumentView*) self);
}

static void
document_view_init_spell_checking (DocumentView* self)
{
	Block18Data* _data18_;
	GspellLanguage* _tmp0_;
	GspellChecker* _tmp1_;
	GspellTextBuffer* gspell_buffer = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GspellTextBuffer* _tmp4_;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp5_;
	GspellTextView* _tmp6_;
	Document* doc = NULL;
	GtkTextBuffer* _tmp7_;
	Document* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	g_return_if_fail (self != NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_tmp0_ = document_view_get_spell_language (self);
	_tmp1_ = gspell_checker_new (_tmp0_);
	_data18_->spell_checker = _tmp1_;
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gspell_text_buffer_get_from_gtk_text_buffer (_tmp3_);
	gspell_buffer = _tmp4_;
	gspell_text_buffer_set_spell_checker (gspell_buffer, _data18_->spell_checker);
	document_view_setup_inline_spell_checker (self);
	_tmp5_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	gspell_view = _tmp6_;
	g_signal_connect_object ((GObject*) gspell_view, "notify::inline-spell-checking", (GCallback) _document_view_inline_checker_enabled_notify_cb_g_object_notify, self, 0);
	_tmp7_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp8_ = _g_object_ref0 (IS_DOCUMENT (_tmp7_) ? ((Document*) _tmp7_) : NULL);
	doc = _tmp8_;
	g_signal_connect_data ((GObject*) doc, "notify::location", (GCallback) ___lambda70__g_object_notify, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	_tmp9_ = self->priv->_editor_settings;
	g_signal_connect_data (_tmp9_, "changed::spell-checking-language", (GCallback) ___lambda71__g_settings_changed, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	_tmp10_ = self->priv->_editor_settings;
	g_signal_connect_object (_tmp10_, "changed::highlight-misspelled-words", (GCallback) ___lambda72__g_settings_changed, self, 0);
	_g_object_unref0 (doc);
	_g_object_unref0 (gspell_view);
	block18_data_unref (_data18_);
	_data18_ = NULL;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static GspellLanguage*
document_view_get_spell_language (DocumentView* self)
{
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_;
	Document* _tmp1_;
	gchar* lang_code = NULL;
	Document* _tmp2_;
	TeplMetadata* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GspellLanguage* _tmp10_;
	GspellLanguage* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _g_object_ref0 (IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL);
	doc = _tmp1_;
	_tmp2_ = doc;
	_tmp3_ = tepl_buffer_get_metadata ((TeplBuffer*) _tmp2_);
	_tmp4_ = tepl_metadata_get (_tmp3_, DOCUMENT_VIEW_METADATA_KEY_SPELL_LANGUAGE);
	lang_code = _tmp4_;
	_tmp5_ = lang_code;
	if (_tmp5_ == NULL) {
		GSettings* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = self->priv->_editor_settings;
		_tmp7_ = g_settings_get_string (_tmp6_, "spell-checking-language");
		_g_free0 (lang_code);
		lang_code = _tmp7_;
	}
	_tmp8_ = lang_code;
	if (string_get (_tmp8_, (glong) 0) == '\0') {
		result = NULL;
		_g_free0 (lang_code);
		_g_object_unref0 (doc);
		return result;
	}
	_tmp9_ = lang_code;
	_tmp10_ = gspell_language_lookup (_tmp9_);
	result = _tmp10_;
	_g_free0 (lang_code);
	_g_object_unref0 (doc);
	return result;
}

static GspellChecker*
document_view_get_spell_checker (DocumentView* self)
{
	GspellTextBuffer* gspell_buffer = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GspellTextBuffer* _tmp2_;
	GspellChecker* _tmp3_;
	GspellChecker* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gspell_text_buffer_get_from_gtk_text_buffer (_tmp1_);
	gspell_buffer = _tmp2_;
	_tmp3_ = gspell_text_buffer_get_spell_checker (gspell_buffer);
	result = _tmp3_;
	return result;
}

void
document_view_setup_inline_spell_checker (DocumentView* self)
{
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_;
	Document* _tmp1_;
	gboolean enabled = FALSE;
	gchar* metadata = NULL;
	Document* _tmp2_;
	TeplMetadata* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp8_;
	GspellTextView* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _g_object_ref0 (IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL);
	doc = _tmp1_;
	_tmp2_ = doc;
	_tmp3_ = tepl_buffer_get_metadata ((TeplBuffer*) _tmp2_);
	_tmp4_ = tepl_metadata_get (_tmp3_, DOCUMENT_VIEW_METADATA_KEY_INLINE_SPELL);
	metadata = _tmp4_;
	_tmp5_ = metadata;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = metadata;
		enabled = g_strcmp0 (_tmp6_, DOCUMENT_VIEW_INLINE_SPELL_ENABLED_STR) == 0;
	} else {
		GSettings* _tmp7_;
		_tmp7_ = self->priv->_editor_settings;
		enabled = g_settings_get_boolean (_tmp7_, "highlight-misspelled-words");
	}
	_tmp8_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	gspell_view = _tmp9_;
	gspell_text_view_set_inline_spell_checking (gspell_view, enabled);
	_g_object_unref0 (gspell_view);
	_g_free0 (metadata);
	_g_object_unref0 (doc);
}

void
document_view_launch_spell_checker_dialog (DocumentView* self)
{
	GspellNavigator* navigator = NULL;
	GspellNavigator* _tmp0_;
	GspellNavigator* _tmp1_;
	GspellCheckerDialog* dialog = NULL;
	GtkWidget* _tmp2_;
	GspellCheckerDialog* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gspell_navigator_text_view_new (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	navigator = _tmp1_;
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp3_ = (GspellCheckerDialog*) gspell_checker_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL, navigator);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	gtk_widget_show ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (navigator);
}

void
document_view_launch_spell_language_chooser_dialog (DocumentView* self)
{
	GspellChecker* spell_checker = NULL;
	GspellChecker* _tmp0_;
	GspellChecker* _tmp1_;
	GspellLanguageChooserDialog* dialog = NULL;
	GtkWidget* _tmp2_;
	GspellLanguage* _tmp3_;
	GspellLanguageChooserDialog* _tmp4_;
	GspellLanguage* lang = NULL;
	GspellLanguage* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = document_view_get_spell_checker (self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	spell_checker = _tmp1_;
	g_return_if_fail (spell_checker != NULL);
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp3_ = gspell_checker_get_language (spell_checker);
	_tmp4_ = (GspellLanguageChooserDialog*) gspell_language_chooser_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL, _tmp3_, (GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL) | GTK_DIALOG_USE_HEADER_BAR);
	g_object_ref_sink (_tmp4_);
	dialog = _tmp4_;
	gtk_dialog_run ((GtkDialog*) dialog);
	_tmp5_ = gspell_language_chooser_get_language ((GspellLanguageChooser*) dialog);
	lang = _tmp5_;
	gspell_checker_set_language (spell_checker, lang);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (spell_checker);
}

void
document_view_save_spell_language_metadata (DocumentView* self)
{
	GspellChecker* spell_checker = NULL;
	GspellChecker* _tmp0_;
	GspellChecker* _tmp1_;
	GspellChecker* _tmp2_;
	Document* doc = NULL;
	GtkTextBuffer* _tmp3_;
	Document* _tmp4_;
	GspellLanguage* lang = NULL;
	GspellChecker* _tmp5_;
	GspellLanguage* _tmp6_;
	GspellLanguage* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = document_view_get_spell_checker (self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	spell_checker = _tmp1_;
	_tmp2_ = spell_checker;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp4_ = _g_object_ref0 (IS_DOCUMENT (_tmp3_) ? ((Document*) _tmp3_) : NULL);
	doc = _tmp4_;
	_tmp5_ = spell_checker;
	_tmp6_ = gspell_checker_get_language (_tmp5_);
	lang = _tmp6_;
	_tmp7_ = lang;
	if (_tmp7_ != NULL) {
		Document* _tmp8_;
		GspellLanguage* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = doc;
		_tmp9_ = lang;
		_tmp10_ = gspell_language_get_code (_tmp9_);
		document_set_metadata (_tmp8_, DOCUMENT_VIEW_METADATA_KEY_SPELL_LANGUAGE, _tmp10_);
	} else {
		Document* _tmp11_;
		_tmp11_ = doc;
		document_set_metadata (_tmp11_, DOCUMENT_VIEW_METADATA_KEY_SPELL_LANGUAGE, NULL);
	}
	_g_object_unref0 (doc);
	_g_object_unref0 (spell_checker);
}

void
document_view_save_inline_spell_metadata (DocumentView* self)
{
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_;
	Document* _tmp1_;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp2_;
	GspellTextView* _tmp3_;
	GspellTextView* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _g_object_ref0 (IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL);
	doc = _tmp1_;
	_tmp2_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	gspell_view = _tmp3_;
	_tmp4_ = gspell_view;
	_tmp5_ = gspell_text_view_get_inline_spell_checking (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		Document* _tmp7_;
		_tmp7_ = doc;
		document_set_metadata (_tmp7_, DOCUMENT_VIEW_METADATA_KEY_INLINE_SPELL, DOCUMENT_VIEW_INLINE_SPELL_ENABLED_STR);
	} else {
		Document* _tmp8_;
		_tmp8_ = doc;
		document_set_metadata (_tmp8_, DOCUMENT_VIEW_METADATA_KEY_INLINE_SPELL, DOCUMENT_VIEW_INLINE_SPELL_DISABLED_STR);
	}
	_g_object_unref0 (gspell_view);
	_g_object_unref0 (doc);
}

static void
document_view_inline_checker_enabled_notify_cb (DocumentView* self)
{
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp0_;
	GspellTextView* _tmp1_;
	GspellTextView* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GspellChecker* spell_checker = NULL;
	GspellChecker* _tmp5_;
	GspellChecker* _tmp6_;
	GspellChecker* _tmp7_;
	GspellChecker* _tmp8_;
	GspellLanguage* _tmp9_;
	GspellTextView* _tmp10_;
	GtkMessageDialog* dialog = NULL;
	GtkWidget* _tmp11_;
	GtkMessageDialog* _tmp12_;
	GtkMessageDialog* _tmp13_;
	gint response = 0;
	GtkMessageDialog* _tmp14_;
	GtkMessageDialog* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	gspell_view = _tmp1_;
	_tmp2_ = gspell_view;
	_tmp3_ = gspell_text_view_get_inline_spell_checking (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		_g_object_unref0 (gspell_view);
		return;
	}
	_tmp5_ = document_view_get_spell_checker (self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	spell_checker = _tmp6_;
	_tmp7_ = spell_checker;
	g_return_if_fail (_tmp7_ != NULL);
	_tmp8_ = spell_checker;
	_tmp9_ = gspell_checker_get_language (_tmp8_);
	if (_tmp9_ != NULL) {
		_g_object_unref0 (spell_checker);
		_g_object_unref0 (gspell_view);
		return;
	}
	_tmp10_ = gspell_view;
	gspell_text_view_set_inline_spell_checking (_tmp10_, FALSE);
	if (document_view__no_spell_language_dialog_shown) {
		_g_object_unref0 (spell_checker);
		_g_object_unref0 (gspell_view);
		return;
	}
	document_view__no_spell_language_dialog_shown = TRUE;
	_tmp11_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp11_) : NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _ ("No dictionaries available for the spell-checking."));
	g_object_ref_sink (_tmp12_);
	dialog = _tmp12_;
	_tmp13_ = dialog;
	gtk_dialog_add_buttons ((GtkDialog*) _tmp13_, _ ("_Help"), GTK_RESPONSE_HELP, _ ("_OK"), GTK_RESPONSE_OK, NULL, NULL);
	_tmp14_ = dialog;
	response = gtk_dialog_run ((GtkDialog*) _tmp14_);
	if (response == ((gint) GTK_RESPONSE_HELP)) {
		{
			latexila_utils_show_uri ((GtkWidget*) self, "help:latexila/spell_checking", (guint32) GDK_CURRENT_TIME, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp15_;
			const gchar* _tmp16_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			g_warning ("document_view.vala:304: Impossible to open the documentation: %s", _tmp16_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dialog);
			_g_object_unref0 (spell_checker);
			_g_object_unref0 (gspell_view);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp17_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp17_);
	_g_object_unref0 (dialog);
	_g_object_unref0 (spell_checker);
	_g_object_unref0 (gspell_view);
}

static void
document_view_class_init (DocumentViewClass * klass,
                          gpointer klass_data)
{
	document_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DocumentView_private_offset);
	G_OBJECT_CLASS (klass)->finalize = document_view_finalize;
}

static void
document_view_instance_init (DocumentView * self,
                             gpointer klass)
{
	self->priv = document_view_get_instance_private (self);
}

static void
document_view_finalize (GObject * obj)
{
	DocumentView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT_VIEW, DocumentView);
	_g_object_unref0 (self->priv->_editor_settings);
	__vala_PangoFontDescription_free0 (self->priv->_font_desc);
	G_OBJECT_CLASS (document_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
document_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DocumentViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentView), 0, (GInstanceInitFunc) document_view_instance_init, NULL };
	GType document_view_type_id;
	document_view_type_id = g_type_register_static (tepl_view_get_type (), "DocumentView", &g_define_type_info, 0);
	DocumentView_private_offset = g_type_add_instance_private (document_view_type_id, sizeof (DocumentViewPrivate));
	return document_view_type_id;
}

GType
document_view_get_type (void)
{
	static gsize document_view_type_id__once = 0;
	if (g_once_init_enter (&document_view_type_id__once)) {
		GType document_view_type_id;
		document_view_type_id = document_view_get_type_once ();
		g_once_init_leave (&document_view_type_id__once, document_view_type_id);
	}
	return document_view_type_id__once;
}

