/* glatex_app.c generated by valac 0.56.7, the Vala compiler
 * generated from glatex_app.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <latexila.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <tepl/tepl.h>
#include <gee.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;
typedef struct _GlatexAppPrivate GlatexAppPrivate;
enum  {
	GLATEX_APP_0_PROPERTY,
	GLATEX_APP_NUM_PROPERTIES
};
static GParamSpec* glatex_app_properties[GLATEX_APP_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_BUILD_TOOLS_PREFERENCES (build_tools_preferences_get_type ())
#define BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences))
#define BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))
#define IS_BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS_PREFERENCES))
#define IS_BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS_PREFERENCES))
#define BUILD_TOOLS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))

typedef struct _BuildToolsPreferences BuildToolsPreferences;
typedef struct _BuildToolsPreferencesClass BuildToolsPreferencesClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GlatexApp {
	LatexilaApp parent_instance;
	GlatexAppPrivate * priv;
};

struct _GlatexAppClass {
	LatexilaAppClass parent_class;
};

static gpointer glatex_app_parent_class = NULL;

VALA_EXTERN GType glatex_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
static void glatex_app_new_document_cb (GlatexApp* self);
static void _glatex_app_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void glatex_app_manage_build_tools_cb (GlatexApp* self);
static void _glatex_app_manage_build_tools_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void glatex_app_quit_cb (GlatexApp* self);
static void _glatex_app_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
VALA_EXTERN GlatexApp* glatex_app_new (void);
VALA_EXTERN GlatexApp* glatex_app_construct (GType object_type);
static void glatex_app_startup_cb (GlatexApp* self);
static void _glatex_app_startup_cb_g_application_startup (GApplication* _sender,
                                                   gpointer self);
VALA_EXTERN void glatex_app_open_documents (GlatexApp* self,
                                GFile** files,
                                gint files_length1);
static void _glatex_app_open_documents_g_application_open (GApplication* _sender,
                                                    GFile** files,
                                                    gint n_files,
                                                    const gchar* hint,
                                                    gpointer self);
static void glatex_app_shutdown_cb (GlatexApp* self);
static void _glatex_app_shutdown_cb_g_application_shutdown (GApplication* _sender,
                                                     gpointer self);
VALA_EXTERN GlatexApp* glatex_app_get_instance (void);
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN MainWindow* glatex_app_get_active_main_window (GlatexApp* self);
static void glatex_app_support_backward_search (GlatexApp* self);
VALA_EXTERN gpointer projects_ref (gpointer instance);
VALA_EXTERN void projects_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_projects (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_projects (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_projects (const GValue* value);
VALA_EXTERN GType projects_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Projects, projects_unref)
VALA_EXTERN Projects* projects_get_default (void);
VALA_EXTERN void projects_save (Projects* self);
VALA_EXTERN GType most_used_symbols_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MostUsedSymbols, g_object_unref)
VALA_EXTERN MostUsedSymbols* most_used_symbols_get_default (void);
VALA_EXTERN void most_used_symbols_save (MostUsedSymbols* self);
VALA_EXTERN MainWindow* glatex_app_create_window (GlatexApp* self);
VALA_EXTERN GType document_tab_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
VALA_EXTERN DocumentTab* main_window_create_tab (MainWindow* self,
                                     gboolean jump_to);
VALA_EXTERN BuildToolsPreferences* build_tools_preferences_new (GtkWindow* parent_window);
VALA_EXTERN BuildToolsPreferences* build_tools_preferences_construct (GType object_type,
                                                          GtkWindow* parent_window);
VALA_EXTERN GType build_tools_preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BuildToolsPreferences, g_object_unref)
VALA_EXTERN gboolean main_window_quit (MainWindow* self);
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN GeeList* glatex_app_get_documents (GlatexApp* self);
VALA_EXTERN GeeList* main_window_get_documents (MainWindow* self);
VALA_EXTERN DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
static void __lambda62_ (GlatexApp* self,
                  const gchar* tex_uri,
                  gint line,
                  guint timestamp);
VALA_EXTERN void main_window_jump_to_file_position (MainWindow* self,
                                        GFile* file,
                                        gint start_line,
                                        gint end_line);
static void ___lambda62__latexila_synctex_backward_search (LatexilaSynctex* _sender,
                                                    const gchar* tex_uri,
                                                    gint line,
                                                    guint timestamp,
                                                    gpointer self);
static GType glatex_app_get_type_once (void);

static const GActionEntry GLATEX_APP__app_actions[3] = {{"new-document", _glatex_app_new_document_cb_gsimple_action_activate_callback}, {"manage-build-tools", _glatex_app_manage_build_tools_cb_gsimple_action_activate_callback}, {"quit", _glatex_app_quit_cb_gsimple_action_activate_callback}};

static void
_glatex_app_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	glatex_app_new_document_cb ((GlatexApp*) self);
}

static void
_glatex_app_manage_build_tools_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	glatex_app_manage_build_tools_cb ((GlatexApp*) self);
}

static void
_glatex_app_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	glatex_app_quit_cb ((GlatexApp*) self);
}

static void
_glatex_app_startup_cb_g_application_startup (GApplication* _sender,
                                              gpointer self)
{
	glatex_app_startup_cb ((GlatexApp*) self);
}

static void
_glatex_app_open_documents_g_application_open (GApplication* _sender,
                                               GFile** files,
                                               gint n_files,
                                               const gchar* hint,
                                               gpointer self)
{
	glatex_app_open_documents ((GlatexApp*) self, files, n_files);
}

static void
_glatex_app_shutdown_cb_g_application_shutdown (GApplication* _sender,
                                                gpointer self)
{
	glatex_app_shutdown_cb ((GlatexApp*) self);
}

GlatexApp*
glatex_app_construct (GType object_type)
{
	GlatexApp * self = NULL;
	self = (GlatexApp*) g_object_new (object_type, NULL);
	g_signal_connect_object ((GApplication*) self, "startup", (GCallback) _glatex_app_startup_cb_g_application_startup, self, 0);
	g_signal_connect_object ((GApplication*) self, "open", (GCallback) _glatex_app_open_documents_g_application_open, self, 0);
	g_signal_connect_object ((GApplication*) self, "shutdown", (GCallback) _glatex_app_shutdown_cb_g_application_shutdown, self, 0);
	return self;
}

GlatexApp*
glatex_app_new (void)
{
	return glatex_app_construct (TYPE_GLATEX_APP);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GlatexApp*
glatex_app_get_instance (void)
{
	GApplication* _tmp0_;
	GlatexApp* _tmp1_;
	GlatexApp* result;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (IS_GLATEX_APP (_tmp0_) ? ((GlatexApp*) _tmp0_) : NULL);
	result = _tmp1_;
	return result;
}

MainWindow*
glatex_app_get_active_main_window (GlatexApp* self)
{
	TeplApplication* tepl_app = NULL;
	TeplApplication* _tmp0_;
	TeplApplication* _tmp1_;
	GtkApplicationWindow* main_window = NULL;
	TeplApplication* _tmp2_;
	GtkApplicationWindow* _tmp3_;
	GtkApplicationWindow* _tmp4_;
	GtkApplicationWindow* _tmp5_;
	GtkApplicationWindow* _tmp6_;
	MainWindow* _tmp7_;
	MainWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tepl_application_get_from_gtk_application ((GtkApplication*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tepl_app = _tmp1_;
	_tmp2_ = tepl_app;
	_tmp3_ = tepl_application_get_active_main_window (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	main_window = _tmp4_;
	_tmp5_ = main_window;
	if (_tmp5_ == NULL) {
		result = NULL;
		_g_object_unref0 (main_window);
		_g_object_unref0 (tepl_app);
		return result;
	}
	_tmp6_ = main_window;
	_tmp7_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp6_) ? ((MainWindow*) _tmp6_) : NULL);
	result = _tmp7_;
	_g_object_unref0 (main_window);
	_g_object_unref0 (tepl_app);
	return result;
}

static void
glatex_app_startup_cb (GlatexApp* self)
{
	g_return_if_fail (self != NULL);
	g_application_hold ((GApplication*) self);
	g_action_map_add_action_entries ((GActionMap*) self, GLATEX_APP__app_actions, (gint) G_N_ELEMENTS (GLATEX_APP__app_actions), self);
	glatex_app_support_backward_search (self);
	g_application_release ((GApplication*) self);
}

static void
glatex_app_shutdown_cb (GlatexApp* self)
{
	Projects* _tmp0_;
	Projects* _tmp1_;
	MostUsedSymbols* _tmp2_;
	MostUsedSymbols* _tmp3_;
	g_return_if_fail (self != NULL);
	g_application_hold ((GApplication*) self);
	_tmp0_ = projects_get_default ();
	_tmp1_ = _tmp0_;
	projects_save (_tmp1_);
	_projects_unref0 (_tmp1_);
	_tmp2_ = most_used_symbols_get_default ();
	_tmp3_ = _tmp2_;
	most_used_symbols_save (_tmp3_);
	_g_object_unref0 (_tmp3_);
	g_application_release ((GApplication*) self);
}

static void
glatex_app_new_document_cb (GlatexApp* self)
{
	MainWindow* window = NULL;
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	MainWindow* _tmp3_;
	DocumentTab* _tmp4_;
	DocumentTab* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = glatex_app_get_active_main_window (self);
	window = _tmp0_;
	_tmp1_ = window;
	if (_tmp1_ == NULL) {
		MainWindow* _tmp2_;
		_tmp2_ = glatex_app_create_window (self);
		_g_object_unref0 (window);
		window = _tmp2_;
	}
	_tmp3_ = window;
	_tmp4_ = main_window_create_tab (_tmp3_, TRUE);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (window);
}

static void
glatex_app_manage_build_tools_cb (GlatexApp* self)
{
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	BuildToolsPreferences* _tmp2_;
	BuildToolsPreferences* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = glatex_app_get_active_main_window (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = build_tools_preferences_new ((GtkWindow*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
}

static void
glatex_app_quit_cb (GlatexApp* self)
{
	gboolean cont = FALSE;
	g_return_if_fail (self != NULL);
	g_application_hold ((GApplication*) self);
	cont = TRUE;
	while (TRUE) {
		MainWindow* main_window = NULL;
		MainWindow* _tmp0_;
		MainWindow* _tmp1_;
		MainWindow* _tmp2_;
		MainWindow* _tmp3_;
		if (!cont) {
			break;
		}
		_tmp0_ = glatex_app_get_active_main_window (self);
		main_window = _tmp0_;
		_tmp1_ = main_window;
		if (_tmp1_ == NULL) {
			_g_object_unref0 (main_window);
			break;
		}
		_tmp2_ = main_window;
		gtk_window_present ((GtkWindow*) _tmp2_);
		_tmp3_ = main_window;
		cont = main_window_quit (_tmp3_);
		_g_object_unref0 (main_window);
	}
	if (cont) {
		while (TRUE) {
			GtkWindow* _tmp4_;
			GtkWindow* _tmp5_;
			GtkWindow* _tmp6_;
			GtkWindow* _tmp7_;
			_tmp4_ = gtk_application_get_active_window ((GtkApplication*) self);
			_tmp5_ = _tmp4_;
			if (!(_tmp5_ != NULL)) {
				break;
			}
			_tmp6_ = gtk_application_get_active_window ((GtkApplication*) self);
			_tmp7_ = _tmp6_;
			gtk_widget_destroy ((GtkWidget*) _tmp7_);
		}
	}
	g_application_release ((GApplication*) self);
}

GeeList*
glatex_app_get_documents (GlatexApp* self)
{
	GeeList* all_documents = NULL;
	GeeLinkedList* _tmp0_;
	GList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	all_documents = (GeeList*) _tmp0_;
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp2_;
			GtkWindow* window = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp2_;
			{
				GtkWindow* _tmp3_;
				_tmp3_ = window;
				if (IS_MAIN_WINDOW (_tmp3_)) {
					MainWindow* main_window = NULL;
					GtkWindow* _tmp4_;
					MainWindow* _tmp5_;
					GeeList* _tmp6_;
					MainWindow* _tmp7_;
					GeeList* _tmp8_;
					GeeList* _tmp9_;
					_tmp4_ = window;
					_tmp5_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp4_) ? ((MainWindow*) _tmp4_) : NULL);
					main_window = _tmp5_;
					_tmp6_ = all_documents;
					_tmp7_ = main_window;
					_tmp8_ = main_window_get_documents (_tmp7_);
					_tmp9_ = _tmp8_;
					gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp9_);
					_g_object_unref0 (_tmp9_);
					_g_object_unref0 (main_window);
				}
				_g_object_unref0 (window);
			}
		}
	}
	result = all_documents;
	return result;
}

MainWindow*
glatex_app_create_window (GlatexApp* self)
{
	TeplAbstractFactory* factory = NULL;
	TeplAbstractFactory* _tmp0_;
	TeplAbstractFactory* _tmp1_;
	GtkApplicationWindow* _tmp2_;
	MainWindow* _tmp3_;
	MainWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tepl_abstract_factory_get_singleton ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	factory = _tmp1_;
	_tmp2_ = tepl_abstract_factory_create_main_window (factory, (GtkApplication*) self);
	_tmp3_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp2_) ? ((MainWindow*) _tmp2_) : NULL);
	result = _tmp3_;
	_g_object_unref0 (factory);
	return result;
}

void
glatex_app_open_documents (GlatexApp* self,
                           GFile** files,
                           gint files_length1)
{
	MainWindow* main_window = NULL;
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	gboolean jump_to = FALSE;
	MainWindow* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = glatex_app_get_active_main_window (self);
	main_window = _tmp0_;
	_tmp1_ = main_window;
	if (_tmp1_ == NULL) {
		MainWindow* _tmp2_;
		_tmp2_ = glatex_app_create_window (self);
		_g_object_unref0 (main_window);
		main_window = _tmp2_;
	}
	jump_to = TRUE;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* _tmp3_;
			GFile* file = NULL;
			_tmp3_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp3_;
			{
				MainWindow* _tmp4_;
				GFile* _tmp5_;
				DocumentTab* _tmp6_;
				DocumentTab* _tmp7_;
				_tmp4_ = main_window;
				_tmp5_ = file;
				_tmp6_ = main_window_open_document (_tmp4_, _tmp5_, jump_to);
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp7_);
				jump_to = FALSE;
				_g_object_unref0 (file);
			}
		}
	}
	_tmp8_ = main_window;
	gtk_window_present ((GtkWindow*) _tmp8_);
	_g_object_unref0 (main_window);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
__lambda62_ (GlatexApp* self,
             const gchar* tex_uri,
             gint line,
             guint timestamp)
{
	GFile* tex_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	MainWindow* main_window = NULL;
	MainWindow* _tmp5_;
	MainWindow* _tmp6_;
	g_return_if_fail (tex_uri != NULL);
	_tmp0_ = g_file_new_for_uri (tex_uri);
	tex_file = _tmp0_;
	_tmp1_ = tex_file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = string_to_string (tex_uri);
		_tmp3_ = g_strconcat ("Backward search: the file \"", _tmp2_, "\" doesn't exist.", NULL);
		_tmp4_ = _tmp3_;
		g_warning ("glatex_app.vala:156: %s", _tmp4_);
		_g_free0 (_tmp4_);
		_g_object_unref0 (tex_file);
		return;
	}
	_tmp5_ = glatex_app_get_active_main_window (self);
	main_window = _tmp5_;
	_tmp6_ = main_window;
	if (_tmp6_ != NULL) {
		MainWindow* _tmp7_;
		GFile* _tmp8_;
		MainWindow* _tmp9_;
		_tmp7_ = main_window;
		_tmp8_ = tex_file;
		main_window_jump_to_file_position (_tmp7_, _tmp8_, line, line);
		_tmp9_ = main_window;
		gtk_window_present_with_time ((GtkWindow*) _tmp9_, (guint32) timestamp);
	}
	_g_object_unref0 (main_window);
	_g_object_unref0 (tex_file);
}

static void
___lambda62__latexila_synctex_backward_search (LatexilaSynctex* _sender,
                                               const gchar* tex_uri,
                                               gint line,
                                               guint timestamp,
                                               gpointer self)
{
	__lambda62_ ((GlatexApp*) self, tex_uri, line, timestamp);
}

static void
glatex_app_support_backward_search (GlatexApp* self)
{
	LatexilaSynctex* synctex = NULL;
	LatexilaSynctex* _tmp0_;
	LatexilaSynctex* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_synctex_get_instance ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	synctex = _tmp1_;
	g_signal_connect_object (synctex, "backward-search", (GCallback) ___lambda62__latexila_synctex_backward_search, self, 0);
	_g_object_unref0 (synctex);
}

static void
glatex_app_class_init (GlatexAppClass * klass,
                       gpointer klass_data)
{
	glatex_app_parent_class = g_type_class_peek_parent (klass);
}

static void
glatex_app_instance_init (GlatexApp * self,
                          gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
glatex_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GlatexAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) glatex_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GlatexApp), 0, (GInstanceInitFunc) glatex_app_instance_init, NULL };
	GType glatex_app_type_id;
	glatex_app_type_id = g_type_register_static (latexila_app_get_type (), "GlatexApp", &g_define_type_info, 0);
	return glatex_app_type_id;
}

GType
glatex_app_get_type (void)
{
	static gsize glatex_app_type_id__once = 0;
	if (g_once_init_enter (&glatex_app_type_id__once)) {
		GType glatex_app_type_id;
		glatex_app_type_id = glatex_app_get_type_once ();
		g_once_init_leave (&glatex_app_type_id__once, glatex_app_type_id);
	}
	return glatex_app_type_id__once;
}

