/* boni.c generated by valac 0.44.6, the Vala compiler
 * generated from boni.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This is a fairly literal translation of the GPLv2+ original by*/
/* Sean MacIsaac, Ian Peters, Guillaume Béland.*/

#include <glib-object.h>
#include <glib.h>
#include <gee.h>

typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;

#define TYPE_BONUS_TYPE (bonus_type_get_type ())

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;
typedef struct _BonusPrivate BonusPrivate;
enum  {
	BONUS_0_PROPERTY,
	BONUS_NUM_PROPERTIES
};
static GParamSpec* bonus_properties[BONUS_NUM_PROPERTIES];

#define TYPE_BONI (boni_get_type ())
#define BONI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONI, Boni))
#define BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONI, BoniClass))
#define IS_BONI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONI))
#define IS_BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONI))
#define BONI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONI, BoniClass))

typedef struct _Boni Boni;
typedef struct _BoniClass BoniClass;
typedef struct _BoniPrivate BoniPrivate;
enum  {
	BONI_0_PROPERTY,
	BONI_NUM_PROPERTIES
};
static GParamSpec* boni_properties[BONI_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	BONI_BONUS_ADDED_SIGNAL,
	BONI_BONUS_REMOVED_SIGNAL,
	BONI_NUM_SIGNALS
};
static guint boni_signals[BONI_NUM_SIGNALS] = {0};

struct _Bonus {
	GObject parent_instance;
	BonusPrivate * priv;
	gint x;
	gint y;
	BonusType type;
	gboolean fake;
	gint countdown;
};

struct _BonusClass {
	GObjectClass parent_class;
};

struct _Boni {
	GObject parent_instance;
	BoniPrivate * priv;
	GeeLinkedList* bonuses;
	gint missed;
	gint numleft;
	gint numboni;
	gint numbonuses;
};

struct _BoniClass {
	GObjectClass parent_class;
};

static gpointer bonus_parent_class = NULL;
static gpointer boni_parent_class = NULL;

GType bonus_type_get_type (void) G_GNUC_CONST;
GType bonus_get_type (void) G_GNUC_CONST;
Bonus* bonus_new (gint x,
                  gint y,
                  BonusType type,
                  gboolean fake,
                  gint countdown);
Bonus* bonus_construct (GType object_type,
                        gint x,
                        gint y,
                        BonusType type,
                        gboolean fake,
                        gint countdown);
static void bonus_finalize (GObject * obj);
GType boni_get_type (void) G_GNUC_CONST;
#define BONI_MAX_BONUSES 100
#define BONI_MAX_MISSED 2
Boni* boni_new (gint numworms);
Boni* boni_construct (GType object_type,
                      gint numworms);
void boni_add_bonus (Boni* self,
                     gint* board,
                     gint board_length1,
                     gint board_length2,
                     gint x,
                     gint y,
                     BonusType type,
                     gboolean fake,
                     gint countdown);
void boni_remove_bonus (Boni* self,
                        gint* board,
                        gint board_length1,
                        gint board_length2,
                        Bonus* bonus);
#define NIBBLES_GAME_EMPTYCHAR 'a'
void boni_reset (Boni* self,
                 gint numworms);
Bonus* boni_get_bonus (Boni* self,
                       gint* board,
                       gint board_length1,
                       gint board_length2,
                       gint x,
                       gint y);
static void boni_finalize (GObject * obj);

GType
bonus_type_get_type (void)
{
	static volatile gsize bonus_type_type_id__volatile = 0;
	if (g_once_init_enter (&bonus_type_type_id__volatile)) {
		static const GEnumValue values[] = {{BONUS_TYPE_REGULAR, "BONUS_TYPE_REGULAR", "regular"}, {BONUS_TYPE_HALF, "BONUS_TYPE_HALF", "half"}, {BONUS_TYPE_DOUBLE, "BONUS_TYPE_DOUBLE", "double"}, {BONUS_TYPE_LIFE, "BONUS_TYPE_LIFE", "life"}, {BONUS_TYPE_REVERSE, "BONUS_TYPE_REVERSE", "reverse"}, {BONUS_TYPE_WARP, "BONUS_TYPE_WARP", "warp"}, {0, NULL, NULL}};
		GType bonus_type_type_id;
		bonus_type_type_id = g_enum_register_static ("BonusType", values);
		g_once_init_leave (&bonus_type_type_id__volatile, bonus_type_type_id);
	}
	return bonus_type_type_id__volatile;
}

Bonus*
bonus_construct (GType object_type,
                 gint x,
                 gint y,
                 BonusType type,
                 gboolean fake,
                 gint countdown)
{
	Bonus * self = NULL;
#line 40 "boni.vala"
	self = (Bonus*) g_object_new (object_type, NULL);
#line 42 "boni.vala"
	self->x = x;
#line 43 "boni.vala"
	self->y = y;
#line 44 "boni.vala"
	self->type = type;
#line 45 "boni.vala"
	self->fake = fake;
#line 46 "boni.vala"
	self->countdown = countdown;
#line 40 "boni.vala"
	return self;
#line 191 "boni.c"
}

Bonus*
bonus_new (gint x,
           gint y,
           BonusType type,
           gboolean fake,
           gint countdown)
{
#line 40 "boni.vala"
	return bonus_construct (TYPE_BONUS, x, y, type, fake, countdown);
#line 203 "boni.c"
}

static void
bonus_class_init (BonusClass * klass,
                  gpointer klass_data)
{
#line 32 "boni.vala"
	bonus_parent_class = g_type_class_peek_parent (klass);
#line 32 "boni.vala"
	G_OBJECT_CLASS (klass)->finalize = bonus_finalize;
#line 214 "boni.c"
}

static void
bonus_instance_init (Bonus * self,
                     gpointer klass)
{
}

static void
bonus_finalize (GObject * obj)
{
	Bonus * self;
#line 32 "boni.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BONUS, Bonus);
#line 32 "boni.vala"
	G_OBJECT_CLASS (bonus_parent_class)->finalize (obj);
#line 231 "boni.c"
}

GType
bonus_get_type (void)
{
	static volatile gsize bonus_type_id__volatile = 0;
	if (g_once_init_enter (&bonus_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BonusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bonus_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Bonus), 0, (GInstanceInitFunc) bonus_instance_init, NULL };
		GType bonus_type_id;
		bonus_type_id = g_type_register_static (G_TYPE_OBJECT, "Bonus", &g_define_type_info, 0);
		g_once_init_leave (&bonus_type_id__volatile, bonus_type_id);
	}
	return bonus_type_id__volatile;
}

Boni*
boni_construct (GType object_type,
                gint numworms)
{
	Boni * self = NULL;
	GeeLinkedList* _tmp0_;
#line 65 "boni.vala"
	self = (Boni*) g_object_new (object_type, NULL);
#line 67 "boni.vala"
	_tmp0_ = gee_linked_list_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 67 "boni.vala"
	_g_object_unref0 (self->bonuses);
#line 67 "boni.vala"
	self->bonuses = _tmp0_;
#line 68 "boni.vala"
	self->missed = 0;
#line 69 "boni.vala"
	self->numboni = 8 + numworms;
#line 70 "boni.vala"
	self->numbonuses = 0;
#line 71 "boni.vala"
	self->numleft = self->numboni;
#line 65 "boni.vala"
	return self;
#line 271 "boni.c"
}

Boni*
boni_new (gint numworms)
{
#line 65 "boni.vala"
	return boni_construct (TYPE_BONI, numworms);
#line 279 "boni.c"
}

void
boni_add_bonus (Boni* self,
                gint* board,
                gint board_length1,
                gint board_length2,
                gint x,
                gint y,
                BonusType type,
                gboolean fake,
                gint countdown)
{
	Bonus* bonus = NULL;
	Bonus* _tmp0_;
	GeeLinkedList* _tmp1_;
	Bonus* _tmp2_;
	gint _tmp3_;
#line 74 "boni.vala"
	g_return_if_fail (self != NULL);
#line 76 "boni.vala"
	if (self->numbonuses == BONI_MAX_BONUSES) {
#line 77 "boni.vala"
		return;
#line 304 "boni.c"
	}
#line 79 "boni.vala"
	_tmp0_ = bonus_new (x, y, type, fake, countdown);
#line 79 "boni.vala"
	bonus = _tmp0_;
#line 80 "boni.vala"
	_tmp1_ = self->bonuses;
#line 80 "boni.vala"
	_tmp2_ = bonus;
#line 80 "boni.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp2_);
#line 81 "boni.vala"
	board[(x * board_length2) + y] = (gint) (type + 'A');
#line 82 "boni.vala"
	board[((x + 1) * board_length2) + y] = (gint) (type + 'A');
#line 83 "boni.vala"
	board[(x * board_length2) + (y + 1)] = (gint) (type + 'A');
#line 84 "boni.vala"
	board[((x + 1) * board_length2) + (y + 1)] = (gint) (type + 'A');
#line 85 "boni.vala"
	g_signal_emit (self, boni_signals[BONI_BONUS_ADDED_SIGNAL], 0);
#line 86 "boni.vala"
	_tmp3_ = self->numbonuses;
#line 86 "boni.vala"
	self->numbonuses = _tmp3_ + 1;
#line 74 "boni.vala"
	_g_object_unref0 (bonus);
#line 332 "boni.c"
}

void
boni_remove_bonus (Boni* self,
                   gint* board,
                   gint board_length1,
                   gint board_length2,
                   Bonus* bonus)
{
#line 89 "boni.vala"
	g_return_if_fail (self != NULL);
#line 89 "boni.vala"
	g_return_if_fail (bonus != NULL);
#line 91 "boni.vala"
	board[(bonus->x * board_length2) + bonus->y] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 92 "boni.vala"
	board[((bonus->x + 1) * board_length2) + bonus->y] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 93 "boni.vala"
	board[(bonus->x * board_length2) + (bonus->y + 1)] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 94 "boni.vala"
	board[((bonus->x + 1) * board_length2) + (bonus->y + 1)] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 96 "boni.vala"
	g_signal_emit (self, boni_signals[BONI_BONUS_REMOVED_SIGNAL], 0, bonus);
#line 356 "boni.c"
}

void
boni_reset (Boni* self,
            gint numworms)
{
	GeeLinkedList* _tmp0_;
#line 99 "boni.vala"
	g_return_if_fail (self != NULL);
#line 101 "boni.vala"
	_tmp0_ = self->bonuses;
#line 101 "boni.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 102 "boni.vala"
	self->missed = 0;
#line 103 "boni.vala"
	self->numboni = 8 + numworms;
#line 104 "boni.vala"
	self->numbonuses = 0;
#line 105 "boni.vala"
	self->numleft = self->numboni;
#line 378 "boni.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 110 "boni.vala"
	return self ? g_object_ref (self) : NULL;
#line 386 "boni.c"
}

Bonus*
boni_get_bonus (Boni* self,
                gint* board,
                gint board_length1,
                gint board_length2,
                gint x,
                gint y)
{
	Bonus* result = NULL;
#line 108 "boni.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 400 "boni.c"
	{
		GeeLinkedList* _bonus_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _bonus_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _bonus_index = 0;
#line 110 "boni.vala"
		_tmp0_ = self->bonuses;
#line 110 "boni.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 110 "boni.vala"
		_bonus_list = _tmp1_;
#line 110 "boni.vala"
		_tmp2_ = _bonus_list;
#line 110 "boni.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 110 "boni.vala"
		_tmp4_ = _tmp3_;
#line 110 "boni.vala"
		_bonus_size = _tmp4_;
#line 110 "boni.vala"
		_bonus_index = -1;
#line 110 "boni.vala"
		while (TRUE) {
#line 428 "boni.c"
			Bonus* bonus = NULL;
			GeeLinkedList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			Bonus* _tmp11_;
#line 110 "boni.vala"
			_bonus_index = _bonus_index + 1;
#line 110 "boni.vala"
			if (!(_bonus_index < _bonus_size)) {
#line 110 "boni.vala"
				break;
#line 443 "boni.c"
			}
#line 110 "boni.vala"
			_tmp5_ = _bonus_list;
#line 110 "boni.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _bonus_index);
#line 110 "boni.vala"
			bonus = (Bonus*) _tmp6_;
#line 112 "boni.vala"
			_tmp11_ = bonus;
#line 112 "boni.vala"
			if (x == _tmp11_->x) {
#line 455 "boni.c"
				Bonus* _tmp12_;
#line 112 "boni.vala"
				_tmp12_ = bonus;
#line 112 "boni.vala"
				_tmp10_ = y == _tmp12_->y;
#line 461 "boni.c"
			} else {
#line 112 "boni.vala"
				_tmp10_ = FALSE;
#line 465 "boni.c"
			}
#line 112 "boni.vala"
			if (_tmp10_) {
#line 112 "boni.vala"
				_tmp9_ = TRUE;
#line 471 "boni.c"
			} else {
				gboolean _tmp13_ = FALSE;
				Bonus* _tmp14_;
#line 113 "boni.vala"
				_tmp14_ = bonus;
#line 113 "boni.vala"
				if (x == (_tmp14_->x + 1)) {
#line 479 "boni.c"
					Bonus* _tmp15_;
#line 113 "boni.vala"
					_tmp15_ = bonus;
#line 113 "boni.vala"
					_tmp13_ = y == _tmp15_->y;
#line 485 "boni.c"
				} else {
#line 113 "boni.vala"
					_tmp13_ = FALSE;
#line 489 "boni.c"
				}
#line 113 "boni.vala"
				_tmp9_ = _tmp13_;
#line 493 "boni.c"
			}
#line 112 "boni.vala"
			if (_tmp9_) {
#line 112 "boni.vala"
				_tmp8_ = TRUE;
#line 499 "boni.c"
			} else {
				gboolean _tmp16_ = FALSE;
				Bonus* _tmp17_;
#line 114 "boni.vala"
				_tmp17_ = bonus;
#line 114 "boni.vala"
				if (x == _tmp17_->x) {
#line 507 "boni.c"
					Bonus* _tmp18_;
#line 114 "boni.vala"
					_tmp18_ = bonus;
#line 114 "boni.vala"
					_tmp16_ = y == (_tmp18_->y + 1);
#line 513 "boni.c"
				} else {
#line 114 "boni.vala"
					_tmp16_ = FALSE;
#line 517 "boni.c"
				}
#line 114 "boni.vala"
				_tmp8_ = _tmp16_;
#line 521 "boni.c"
			}
#line 112 "boni.vala"
			if (_tmp8_) {
#line 112 "boni.vala"
				_tmp7_ = TRUE;
#line 527 "boni.c"
			} else {
				gboolean _tmp19_ = FALSE;
				Bonus* _tmp20_;
#line 115 "boni.vala"
				_tmp20_ = bonus;
#line 115 "boni.vala"
				if (x == (_tmp20_->x + 1)) {
#line 535 "boni.c"
					Bonus* _tmp21_;
#line 115 "boni.vala"
					_tmp21_ = bonus;
#line 115 "boni.vala"
					_tmp19_ = y == (_tmp21_->y + 1);
#line 541 "boni.c"
				} else {
#line 115 "boni.vala"
					_tmp19_ = FALSE;
#line 545 "boni.c"
				}
#line 115 "boni.vala"
				_tmp7_ = _tmp19_;
#line 549 "boni.c"
			}
#line 112 "boni.vala"
			if (_tmp7_) {
#line 117 "boni.vala"
				result = bonus;
#line 117 "boni.vala"
				_g_object_unref0 (_bonus_list);
#line 117 "boni.vala"
				return result;
#line 559 "boni.c"
			}
#line 110 "boni.vala"
			_g_object_unref0 (bonus);
#line 563 "boni.c"
		}
#line 110 "boni.vala"
		_g_object_unref0 (_bonus_list);
#line 567 "boni.c"
	}
#line 121 "boni.vala"
	result = NULL;
#line 121 "boni.vala"
	return result;
#line 573 "boni.c"
}

static void
boni_class_init (BoniClass * klass,
                 gpointer klass_data)
{
#line 50 "boni.vala"
	boni_parent_class = g_type_class_peek_parent (klass);
#line 50 "boni.vala"
	G_OBJECT_CLASS (klass)->finalize = boni_finalize;
#line 50 "boni.vala"
	boni_signals[BONI_BONUS_ADDED_SIGNAL] = g_signal_new ("bonus-added", TYPE_BONI, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 50 "boni.vala"
	boni_signals[BONI_BONUS_REMOVED_SIGNAL] = g_signal_new ("bonus-removed", TYPE_BONI, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_BONUS);
#line 588 "boni.c"
}

static void
boni_instance_init (Boni * self,
                    gpointer klass)
{
}

static void
boni_finalize (GObject * obj)
{
	Boni * self;
#line 50 "boni.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BONI, Boni);
#line 52 "boni.vala"
	_g_object_unref0 (self->bonuses);
#line 50 "boni.vala"
	G_OBJECT_CLASS (boni_parent_class)->finalize (obj);
#line 607 "boni.c"
}

GType
boni_get_type (void)
{
	static volatile gsize boni_type_id__volatile = 0;
	if (g_once_init_enter (&boni_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoniClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boni_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Boni), 0, (GInstanceInitFunc) boni_instance_init, NULL };
		GType boni_type_id;
		boni_type_id = g_type_register_static (G_TYPE_OBJECT, "Boni", &g_define_type_info, 0);
		g_once_init_leave (&boni_type_id__volatile, boni_type_id);
	}
	return boni_type_id__volatile;
}

