/* gnome-pilot-conduit-file.c
 * Copyright (C) 1999  J. Arthur Random
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include "gnome-pilot-conduit-file.h"

enum {
	INSTALL_DB,
	RESTORE_DIRECTORY,
	LAST_SIGNAL
};

static void gnome_pilot_conduit_file_init		(GnomePilotConduitFile		 *pilot_conduit_file);
static void gnome_pilot_conduit_file_class_init	(GnomePilotConduitFileClass	 *klass);
static void gnome_real_pilot_conduit_file_install_db	(GnomePilotConduitFile		 *pilot_conduit_file);
static void gnome_real_pilot_conduit_file_restore_directory	(GnomePilotConduitFile		 *pilot_conduit_file);


static GnomePilotConduitClass *parent_class = NULL;
static guint pilot_conduit_file_signals[LAST_SIGNAL] = { 0 };


GtkType
gnome_pilot_conduit_file_get_type (void)
{
	static GtkType pilot_conduit_file_type = 0;

	if (!pilot_conduit_file_type)
	{
		static const GtkTypeInfo pilot_conduit_file_info =
		{
			"GnomePilotConduitFile",
			sizeof (GnomePilotConduitFile),
			sizeof (GnomePilotConduitFileClass),
			(GtkClassInitFunc) gnome_pilot_conduit_file_class_init,
			(GtkObjectInitFunc) gnome_pilot_conduit_file_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		pilot_conduit_file_type = gtk_type_unique (gnome_pilot_conduit_get_type (), &pilot_conduit_file_info);
	}

	return pilot_conduit_file_type;
}

/* Stolen from GNOME_ICON_LIST... (-: */
typedef gint (*xGtkSignal_GINT__INT_POINTER) (GtkObject * object,
					      gint     arg1,
					      gpointer arg2,
					      gpointer user_data);
static void
xgtk_marshal_INT__INT_POINTER (GtkObject *object, GtkSignalFunc func, gpointer func_data,
				GtkArg *args)
{
	xGtkSignal_GINT__INT_POINTER rfunc;
	gboolean *return_val;

	return_val = GTK_RETLOC_INT (args[2]);
	rfunc = (xGtkSignal_GINT__INT_POINTER) func;
	*return_val = (*rfunc) (object,
				GTK_VALUE_INT (args[0]),
				GTK_VALUE_POINTER (args[1]),
				func_data);
}

static void
gnome_pilot_conduit_file_class_init (GnomePilotConduitFileClass *klass)
{
	GtkObjectClass *object_class;

	object_class = (GtkObjectClass*) klass;

	parent_class = gtk_type_class (gnome_pilot_conduit_get_type ());

	pilot_conduit_file_signals[INSTALL_DB] =
		gtk_signal_new ("install_db",
				GTK_RUN_LAST,
				object_class->type,
				GTK_SIGNAL_OFFSET (GnomePilotConduitFileClass, install_db),
				xgtk_marshal_INT__INT_POINTER,
				GTK_TYPE_INT, 2,
				GTK_TYPE_INT,
				GTK_TYPE_POINTER);
	pilot_conduit_file_signals[RESTORE_DIRECTORY] =
		gtk_signal_new ("restore_directory",
				GTK_RUN_LAST,
				object_class->type,
				GTK_SIGNAL_OFFSET (GnomePilotConduitFileClass, restore_directory),
				xgtk_marshal_INT__INT_POINTER,
				GTK_TYPE_INT, 2,
				GTK_TYPE_INT,
				GTK_TYPE_POINTER);


	gtk_object_class_add_signals (object_class, pilot_conduit_file_signals, LAST_SIGNAL);


	klass->install_db = gnome_real_pilot_conduit_file_install_db;
	klass->restore_directory = gnome_real_pilot_conduit_file_restore_directory;
}


static void
gnome_pilot_conduit_file_init (GnomePilotConduitFile *pilot_conduit_file)
{

}

static void
gnome_real_pilot_conduit_file_install_db (GnomePilotConduitFile *pilot_conduit_file)
{
	g_return_if_fail (pilot_conduit_file != NULL);
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_FILE (pilot_conduit_file));

}

static void
gnome_real_pilot_conduit_file_restore_directory (GnomePilotConduitFile *pilot_conduit_file)
{
	g_return_if_fail (pilot_conduit_file != NULL);
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_FILE (pilot_conduit_file));

}
GtkObject *
gnome_pilot_conduit_file_new (void)
{
	return GTK_OBJECT (gtk_type_new (gnome_pilot_conduit_file_get_type ()));
}
void
gnome_pilot_conduit_file_construct (GnomePilotConduitFile *pilot_conduit_file,
				    guint32 pilotId)
{
	g_return_if_fail (pilot_conduit_file != NULL);
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_FILE (pilot_conduit_file));

	gnome_pilot_conduit_construct (GNOME_PILOT_CONDUIT (pilot_conduit_file),
				       "file");
	pilot_conduit_file->pilotId = pilotId;
}

gint
gnome_pilot_conduit_file_install_db (GnomePilotConduitFile *pilot_conduit_file,
				     int pisock,
				     gchar *src_file)
{
	gint retval = 0;
	g_return_val_if_fail (pilot_conduit_file != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_FILE (pilot_conduit_file), -1);

	gtk_signal_emit (GTK_OBJECT (pilot_conduit_file), pilot_conduit_file_signals[INSTALL_DB], pisock, src_file, &retval);
	return retval;
}
gint
gnome_pilot_conduit_file_restore_directory (GnomePilotConduitFile *pilot_conduit_file,
					    int pisock,
					    gchar *src_file)
{
	gint retval = 0;
	g_return_val_if_fail (pilot_conduit_file != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_FILE (pilot_conduit_file), -1);

	gtk_signal_emit (GTK_OBJECT (pilot_conduit_file), pilot_conduit_file_signals[RESTORE_DIRECTORY], pisock, src_file, &retval);
	return retval;
}
