#
# Note that this is NOT a relocatable package
# $Id: gnome-pilot.spec.in,v 1.13 2001/08/02 08:47:20 eskil Exp $
#
%define ver      0.1.61
%define rel      1
%define prefix   /usr
%define name	 gnome-pilot
%define epoch	 2147483647

Summary: GNOME pilot programs
Summary(da): GNOME pilot programmer
Name: %name
Version: %ver
Release: %rel
Copyright: LGPL
Epoch: %epoch
Group: Applications/Communications
Source: http://eskil.org/gnome-pilot/download/%name-%ver.tar.gz
BuildRoot: /var/tmp/gnome-pilot
Packager: Eskil Heyn Olsen <eskil@eskil.dk>
URL: http://eskil.org/gnome-pilot
Prereq: /sbin/install-info
Prefix: %{prefix}
Docdir: %{prefix}/doc
Requires: pilot-link >= 0.9.5
Requires: gnome-core >= 1.2.12
Requires: ORBit >= 0.5.7
Requires: libglade >= 0.16
Requires: libxml >= 1.8.12
Requires: gnome-vfs >= 1.0

%description
GNOME pilot is a collection of programs and daemon for integrating
GNOME and the PalmPilot<tm>.

GNOME is the GNU Network Object Model Environment.  That's a fancy
name but really GNOME is a nice GUI desktop environment.  It makes
using your computer easy, powerful, and easy to configure.

%description -l da

GNOME str for GNU Network Object Model Environment, GNU Netvrk Objekt
Model Milj. Et smart navn, men GNOME er i virkeligheden en pnt GUI
desktop milj. Det gr brugen af din computer nemmere, kraftiger og nemmere
at stte op.

%package devel
Summary: GNOME pilot libraries, includes, etc
Summary(da): GNOME pilot biblioteker, include filer etc.
Group: Development/Libraries
Requires: gnome-core-devel
Requires: ORBit-devel
Requires: pilot-link-devel
Requires: %name = %{epoch}:%{ver}
PreReq: /sbin/install-info

%description devel
gpilotd libraries and includes.

%description devel -l da
gpilotd include filer og biblioteker.

%changelog

* Wed Feb 17 1999 Eskil Heyn Olsen <deity@eskil.dk>

- Created the .spec file

%prep
%setup

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix --sysconfdir=$RPM_BUILD_ROOT/etc
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix --sysconfdir=$RPM_BUILD_ROOT/etc
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean


%post
if ! grep %{prefix}/lib /etc/ld.so.conf > /dev/null ; then
  echo "%{prefix}/lib" >> /etc/ld.so.conf
fi

/sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog NEWS README
%{prefix}/bin/gnome-pilot-make-password
%{prefix}/bin/gpilotd
%{prefix}/bin/gpilotd-client
%{prefix}/bin/gpilot-applet
%{prefix}/bin/gpilot-install-file
%{prefix}/bin/gpilotd-control-applet
%{prefix}/bin/gpilotd-session-wrapper
%{prefix}/lib/*.so
%{prefix}/lib/*.so.*
%{prefix}/lib/gnome-pilot/conduits/*.so
%{prefix}/lib/gnome-pilot/conduits/*.so.*
%{prefix}/man/
%{prefix}/share/applets
%{prefix}/share/control-center
%{prefix}/share/gnome
%{prefix}/share/gnome-pilot
%{prefix}/share/idl/gnome-pilot.idl
%{prefix}/share/locale
%{prefix}/share/mime-info/palm.*
%{prefix}/share/oaf/*.oafinfo
%{prefix}/share/pixmaps/*.png
%config /etc/CORBA/servers/gpilotd.gnorba
%config /etc/CORBA/servers/gpilot-applet.gnorba

%files devel
%defattr(-, root, root)
%{prefix}/include/
%{prefix}/lib/*.a
%{prefix}/lib/*.la
%{prefix}/lib/gpilotConf.sh

