/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescanadvancedpreview.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescanadvancedpreview
 * @short_description: A Widget that allow fine area selection
 *
 * #GnomeScanAdvancedPreview differ from #GnomeScanPreview by its
 * goal. It intend to allow fine area selection and features that
 * would bloat the #GnomeScanPreview widget. #GnomeScanAdvancedPreview
 * extends #GnomeScanPreview.
 */

#ifndef GNOME_SCAN_ADVANCED_PREVIEW_H
#define GNOME_SCAN_ADVANCED_PREVIEW_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gnomescan.h>

G_BEGIN_DECLS;

#define	GNOME_TYPE_SCAN_ADVANCED_PREVIEW		(gnome_scan_advanced_preview_get_type ())
#define GNOME_SCAN_ADVANCED_PREVIEW(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_ADVANCED_PREVIEW, GnomeScanAdvancedPreview))
#define GNOME_SCAN_ADVANCED_PREVIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_ADVANCED_PREVIEW, GnomeScanAdvancedPreviewClass))
#define GNOME_IS_SCAN_ADVANCED_PREVIEW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_ADVANCED_PREVIEW))
#define GNOME_IS_SCAN_ADVANCED_PREVIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_ADVANCED_PREVIEW))
#define GNOME_SCAN_ADVANCED_PREVIEW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_ADVANCED_PREVIEW, GnomeScanAdvancedPreviewClass))

typedef struct _GnomeScanAdvancedPreview		GnomeScanAdvancedPreview;
typedef struct _GnomeScanAdvancedPreviewClass		GnomeScanAdvancedPreviewClass;

struct _GnomeScanAdvancedPreview {
  GtkVBox		parent;

  /*< public >*/
  GnomeScanContext	*context;
};

struct _GnomeScanAdvancedPreviewClass {
  GtkVBoxClass		parent;

  /* SIGNALS */
};

enum {
  GNOME_SCAN_ADVANCED_PREVIEW_ERROR_FAILED
};

/* GObject functions */
GType			gnome_scan_advanced_preview_get_type		(void)	G_GNUC_CONST;

/* Methods */

GtkWidget*		gnome_scan_advanced_preview_new			(GnomeScanContext *context);

G_END_DECLS

#endif
