/* Flegita - Scanner Utility
 *
 * flegitaactionwidget.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:flegitaactionwidget:
 * @short_description: A Widget that do something
 *
 * #FlegitaActionWidget do blah.
 */

#ifndef FLEGITA_ACTION_WIDGET_H
#define FLEGITA_ACTION_WIDGET_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gnomescan.h>

G_BEGIN_DECLS

#define	FLEGITA_TYPE_ACTION_WIDGET			(flegita_action_widget_get_type ())
#define FLEGITA_ACTION_WIDGET(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), FLEGITA_TYPE_ACTION_WIDGET, FlegitaActionWidget))
#define FLEGITA_ACTION_WIDGET_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), FLEGITA_TYPE_ACTION_WIDGET, FlegitaActionWidgetClass))
#define FLEGITA_IS_ACTION_WIDGET(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), FLEGITA_TYPE_ACTION_WIDGET))
#define FLEGITA_IS_ACTION_WIDGET_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), FLEGITA_TYPE_ACTION_WIDGET))
#define FLEGITA_ACTION_WIDGET_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), FLEGITA_TYPE_ACTION_WIDGET, FlegitaActionWidgetClass))

typedef struct _FlegitaActionWidget			FlegitaActionWidget;
typedef struct _FlegitaActionWidgetClass		FlegitaActionWidgetClass;

struct _FlegitaActionWidget {
  GtkHBox			parent;

  /*< public >*/
  GnomeScanContext	*context;
};

struct _FlegitaActionWidgetClass {
  GtkHBoxClass		parent;

  /* SIGNALS */
};

typedef enum {
  ACTION_SAVE,
  ACTION_MAIL,			/*< skip >*/
  ACTION_PRINT,			/*< skip >*/
  ACTION_FAX			/*< skip >*/
} FlegitaAction;

typedef enum {
  FORMAT_PNG,
  FORMAT_JPEG,
  FORMAT_TIFF,
  FORMAT_PDF
} FlegitaFormat;

enum {
  FLEGITA_ACTION_WIDGET_ERROR_FAILED
};

/* GObject functions */
GType			flegita_action_widget_get_type		(void)	G_GNUC_CONST;

/* Methods */

GtkWidget*		flegita_action_widget_new		(GnomeScanContext *context);

G_END_DECLS

#endif
