/* Flegita - Gnome Sane Frontend
 *
 * main.c
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gnome-helper.h"
#include <gnomescanui.h>
#include "flegitaactionwidget.h"


void
flegita_about (GtkWidget *button,
	       GnomeScanDialog *dialog)
{
  /* TODO: do not hardcode author and copyright */
  const gchar *authors[] = {
    "Étienne Bersac <bersace03@laposte.net>",
    "Philipp Sadleder <philipp@sadleder.de>",
    "Olaf Leidinger <leidola@newcon.de>",
    NULL
  };

  const gchar *artists[] = {
    "Étienne Bersac <bersace03@laposte.net>",
    "Tango project http://tango.freedesktop.org/",
    NULL
  };

  gtk_show_about_dialog (GTK_WINDOW (dialog),
			 "name", "flegita",
			 "version", VERSION,
			 "logo-icon-name", "flegita",
			 "website", "http://home.gna.org/gnomescan/index",
			 "website-label", "Gnome scan website",
			 "comments", g_strconcat (_("A Gnome scan utility"), "\n",
						  _("In Memoriam Mark Finlay aka sisob"), "\n", NULL),
			 "license",  g_strjoin ("\n\n",
						"This program is free software; you can redistribute it and/or"
						"modify it under the terms of the GNU Lesser General Public License"
						"as published by the Free Software Foundation; either version 2 of"
						"the License, or (at your option) any later version.",
						"This program is distributed in the hope that it will be useful, but"
						"WITHOUT ANY WARRANTY; without even the implied warranty of"
						"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU"
						"General Public License for more details.",
						"You should have received a copy of the GNU General Public License"
						"along with this program; if not, write to the Free Software"
						"Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307"
						"USA",
						NULL),
			 "wrap-license", TRUE,
			 "authors", authors,
			 "artists", artists,
			 "copyright", "Copyright © 2006 Étienne Bersac",
			 /* translators : please put your name here ! */
			 "translator-credits", _("Many thanks to <translators> ! ;)"),
			 NULL);
}

gint
main (int argc, gchar **argv)
{
  GnomeScanContext *context;
  GtkWidget *dialog, *widget, *vbox, *hbox;
  GtkListStore *store;
  GtkCellRenderer *renderer;
  GtkTreeIter iter;
  gint res;
  GdkScreen *screen;
  GnomeProgram *program;

  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);  
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  /* INIT */
  program = gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE, argc, argv, NULL);
  gnome_scan_ui_init ();

  context = gnome_scan_context_new ();
  gnome_scan_context_set_colorspace (context, GNOME_SCAN_COLORSPACE_RGB);
  gnome_scan_context_set_depth (context, 8);

  dialog = gnome_scan_dialog_new (context, NULL);
  gnome_scan_dialog_add_front_widget (GNOME_SCAN_DIALOG (dialog),
				      _("Action"),
				      flegita_action_widget_new (context));

  widget = gtk_button_new_from_stock (GTK_STOCK_ABOUT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      widget,
		      FALSE,
		      FALSE,
		      0);
  gtk_button_box_set_child_secondary (GTK_BUTTON_BOX (GTK_DIALOG (dialog)->action_area),
				      widget,
				      TRUE);
  g_signal_connect (GTK_BUTTON (widget), "clicked", (GCallback) flegita_about, dialog);

  /* run */
  gnome_scan_dialog_run (GNOME_SCAN_DIALOG (dialog));

  gtk_widget_destroy (dialog);

  return (0);
}
