/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define GNOME_SCAN_TYPE_OPTION_WIDGET (gnome_scan_option_widget_get_type ())
#define GNOME_SCAN_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidget))
#define GNOME_SCAN_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))
#define GNOME_SCAN_IS_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_IS_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_OPTION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))

typedef struct _GnomeScanOptionWidget GnomeScanOptionWidget;
typedef struct _GnomeScanOptionWidgetClass GnomeScanOptionWidgetClass;
typedef struct _GnomeScanOptionWidgetPrivate GnomeScanOptionWidgetPrivate;

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GNOME_SCAN_TYPE_UNIT (gnome_scan_unit_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GnomeScanOptionWidget {
	GtkHBox parent_instance;
	GnomeScanOptionWidgetPrivate * priv;
};

struct _GnomeScanOptionWidgetClass {
	GtkHBoxClass parent_class;
};

struct _GnomeScanOptionWidgetPrivate {
	GnomeScanOption* _option;
	gboolean _no_label;
	gboolean _expand;
};

typedef enum  {
	GNOME_SCAN_UNIT_NONE = -1,
	GNOME_SCAN_UNIT_PIXEL,
	GNOME_SCAN_UNIT_POINTS,
	GNOME_SCAN_UNIT_INCH,
	GNOME_SCAN_UNIT_MM,
	GNOME_SCAN_UNIT_BIT,
	GNOME_SCAN_UNIT_DPI,
	GNOME_SCAN_UNIT_PERCENT,
	GNOME_SCAN_UNIT_MICROSECOND
} GnomeScanUnit;


static gpointer gnome_scan_option_widget_parent_class = NULL;

GType gnome_scan_option_widget_get_type (void);
GType gnome_scan_option_get_type (void);
#define GNOME_SCAN_OPTION_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetPrivate))
enum  {
	GNOME_SCAN_OPTION_WIDGET_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_WIDGET_OPTION,
	GNOME_SCAN_OPTION_WIDGET_NO_LABEL,
	GNOME_SCAN_OPTION_WIDGET_EXPAND
};
void gnome_scan_option_widget_set_option (GnomeScanOptionWidget* self, GnomeScanOption* value);
GnomeScanOptionWidget* gnome_scan_option_widget_construct (GType object_type, GnomeScanOption* option);
static void gnome_scan_option_widget_auto_hide (GnomeScanOptionWidget* self, GnomeScanOption* option);
static void gnome_scan_option_widget_on_option_active_changed (GnomeScanOptionWidget* self, GnomeScanOption* option, GParamSpec* pspec);
gboolean gnome_scan_option_get_active (GnomeScanOption* self);
GnomeScanOption* gnome_scan_option_widget_get_option (GnomeScanOptionWidget* self);
gboolean gnome_scan_option_widget_get_no_label (GnomeScanOptionWidget* self);
void gnome_scan_option_widget_set_no_label (GnomeScanOptionWidget* self, gboolean value);
gboolean gnome_scan_option_widget_get_expand (GnomeScanOptionWidget* self);
void gnome_scan_option_widget_set_expand (GnomeScanOptionWidget* self, gboolean value);
const char* gnome_scan_option_get_desc (GnomeScanOption* self);
static void _gnome_scan_option_widget_on_option_active_changed_g_object_notify (GnomeScanOption* _sender, GParamSpec* pspec, gpointer self);
GType gnome_scan_unit_get_type (void);
GnomeScanUnit gnome_scan_option_get_unit (GnomeScanOption* self);
char* gnome_scan_unit_to_string (GnomeScanUnit unit);
static GObject * gnome_scan_option_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gnome_scan_option_widget_finalize (GObject* obj);
static void gnome_scan_option_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_option_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GnomeScanOptionWidget* gnome_scan_option_widget_construct (GType object_type, GnomeScanOption* option) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionWidget * self;
	g_return_val_if_fail (option != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "option";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION);
	g_value_set_object (&__params_it->value, option);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void gnome_scan_option_widget_on_option_active_changed (GnomeScanOptionWidget* self, GnomeScanOption* option, GParamSpec* pspec) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	g_return_if_fail (pspec != NULL);
	gnome_scan_option_widget_auto_hide (self, option);
}


static void gnome_scan_option_widget_auto_hide (GnomeScanOptionWidget* self, GnomeScanOption* option) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	gtk_widget_set_no_show_all ((GtkWidget*) self, !gnome_scan_option_get_active (option));
	if (gnome_scan_option_get_active (option)) {
		gtk_widget_show_all ((GtkWidget*) self);
	} else {
		gtk_widget_hide ((GtkWidget*) self);
	}
}


GnomeScanOption* gnome_scan_option_widget_get_option (GnomeScanOptionWidget* self) {
	GnomeScanOption* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_option;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gnome_scan_option_widget_set_option (GnomeScanOptionWidget* self, GnomeScanOption* value) {
	GnomeScanOption* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_option = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_option), _tmp0_);
	g_object_notify ((GObject *) self, "option");
}


gboolean gnome_scan_option_widget_get_no_label (GnomeScanOptionWidget* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_label;
	return result;
}


void gnome_scan_option_widget_set_no_label (GnomeScanOptionWidget* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_label = value;
	g_object_notify ((GObject *) self, "no-label");
}


gboolean gnome_scan_option_widget_get_expand (GnomeScanOptionWidget* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_expand;
	return result;
}


void gnome_scan_option_widget_set_expand (GnomeScanOptionWidget* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_expand = value;
	g_object_notify ((GObject *) self, "expand");
}


static void _gnome_scan_option_widget_on_option_active_changed_g_object_notify (GnomeScanOption* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_option_widget_on_option_active_changed (self, _sender, pspec);
}


static GObject * gnome_scan_option_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanOptionWidgetClass * klass;
	GObjectClass * parent_class;
	GnomeScanOptionWidget * self;
	klass = GNOME_SCAN_OPTION_WIDGET_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_OPTION_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_OPTION_WIDGET (obj);
	{
		gtk_box_set_spacing ((GtkBox*) self, 4);
		gtk_container_set_border_width ((GtkContainer*) self, (guint) 2);
		gtk_widget_set_tooltip_text ((GtkWidget*) self, gnome_scan_option_get_desc (self->priv->_option));
		g_signal_connect_object ((GObject*) self->priv->_option, "notify::active", (GCallback) _gnome_scan_option_widget_on_option_active_changed_g_object_notify, self, 0);
		gnome_scan_option_widget_auto_hide (self, self->priv->_option);
		if (gnome_scan_option_get_unit (self->priv->_option) != GNOME_SCAN_UNIT_NONE) {
			char* _tmp0_;
			GtkLabel* _tmp1_;
			GtkLabel* unit;
			unit = (_tmp1_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp0_ = gnome_scan_unit_to_string (gnome_scan_option_get_unit (self->priv->_option)))), _g_free0 (_tmp0_), _tmp1_);
			gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) unit, FALSE, FALSE, (guint) 0);
			_g_object_unref0 (unit);
		}
	}
	return obj;
}


static void gnome_scan_option_widget_class_init (GnomeScanOptionWidgetClass * klass) {
	gnome_scan_option_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionWidgetPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_option_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_WIDGET_OPTION, g_param_spec_object ("option", "option", "option", GNOME_SCAN_TYPE_OPTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_WIDGET_NO_LABEL, g_param_spec_boolean ("no-label", "no-label", "no-label", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_WIDGET_EXPAND, g_param_spec_boolean ("expand", "expand", "expand", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_widget_instance_init (GnomeScanOptionWidget * self) {
	self->priv = GNOME_SCAN_OPTION_WIDGET_GET_PRIVATE (self);
	self->priv->_no_label = FALSE;
}


static void gnome_scan_option_widget_finalize (GObject* obj) {
	GnomeScanOptionWidget * self;
	self = GNOME_SCAN_OPTION_WIDGET (obj);
	_g_object_unref0 (self->priv->_option);
	G_OBJECT_CLASS (gnome_scan_option_widget_parent_class)->finalize (obj);
}


GType gnome_scan_option_widget_get_type (void) {
	static GType gnome_scan_option_widget_type_id = 0;
	if (gnome_scan_option_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionWidget), 0, (GInstanceInitFunc) gnome_scan_option_widget_instance_init, NULL };
		gnome_scan_option_widget_type_id = g_type_register_static (GTK_TYPE_HBOX, "GnomeScanOptionWidget", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gnome_scan_option_widget_type_id;
}


static void gnome_scan_option_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionWidget * self;
	self = GNOME_SCAN_OPTION_WIDGET (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_WIDGET_OPTION:
		g_value_set_object (value, gnome_scan_option_widget_get_option (self));
		break;
		case GNOME_SCAN_OPTION_WIDGET_NO_LABEL:
		g_value_set_boolean (value, gnome_scan_option_widget_get_no_label (self));
		break;
		case GNOME_SCAN_OPTION_WIDGET_EXPAND:
		g_value_set_boolean (value, gnome_scan_option_widget_get_expand (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionWidget * self;
	self = GNOME_SCAN_OPTION_WIDGET (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_WIDGET_OPTION:
		gnome_scan_option_widget_set_option (self, g_value_get_object (value));
		break;
		case GNOME_SCAN_OPTION_WIDGET_NO_LABEL:
		gnome_scan_option_widget_set_no_label (self, g_value_get_boolean (value));
		break;
		case GNOME_SCAN_OPTION_WIDGET_EXPAND:
		gnome_scan_option_widget_set_expand (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




