// -*- C++ -*-

/* 
 * state-print.cc
 *
 * Copyright (C) 1998 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@emccta.com>.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "state-print.h"

#include "xyplotstate.h"
#include "barplotstate.h"
#include "printer.h"

// Remember throughout: PostScript coordinate system starts in lower left,
// plot state transforms and item coordinates are for X/GnomeCanvas, so they
// start in top left.

// These functions mostly just draw junk right now.
// Feel free to make them draw something remotely related to 
//  the plot...

// FIXME this prints things vertically flipped, need to account for
// PostScript coordinate system...

static void
print_axis(Printer* p, 
           const Axis* axis, 
           const Rectangle* rect, 
           const Transform* trans)
{
  double x0, y0, x1, y1;

  p->gsave();
  
  p->setcolor(Color(0,0,0,255));

  switch (axis->pos())
    {
    case PlotUtil::NORTH:
    case PlotUtil::SOUTH:
      x0 = trans->transform(axis->start());
      x1 = trans->transform(axis->stop());
      y0 = rect->y();
      y1 = rect->y();
      if (axis->pos() == PlotUtil::NORTH)
        {
          y0 += rect->height();
          y1 += rect->height();
        }
      break;
    case PlotUtil::WEST:
    case PlotUtil::EAST:
      y0 = trans->transform(axis->start());
      y1 = trans->transform(axis->stop());
      x0 = rect->x();
      x1 = rect->x();
      if (axis->pos() == PlotUtil::WEST)
        {
          x0 += rect->width();
          x1 += rect->width();
        }
      break;
    default:
      g_warning("Unplanned switch default");
      x0 = x1 = y0 = y1 = 0.0;
      break;
    }

  if ((fabs(x1 - x0) < PlotUtil::EPSILON) &&
      (fabs(y1 - y0) < PlotUtil::EPSILON)) 
    {
      // too small
      p->grestore();
      return;
    }

  // FIXME clip to the rectangle

  p->moveto(x0, y0);
  p->lineto(x1, y1);

  p->stroke();

  p->grestore();

  ///  Do the tick marks

  p->gsave();

  // FIXME (see canvas-xy.cc for code to copy)

  p->grestore();
}

////////// FIXME none of these functions do anything useful; please
////////// write them!

void 
guppi_print_xy(Printer* p, XyPlotState* state)
{
  p->gsave();

  // obsolete, no longer reflects XyPlotState's contents
#if 0
  print_axis(p, &state->x_axis(), &state->x_axis_rect(), &state->x_trans());
  print_axis(p, &state->y_axis(), &state->y_axis_rect(), &state->y_trans());
#endif

  p->grestore();
}

void 
guppi_print_bar    (Printer* p, BarPlotState* state)
{  
  p->gsave();
  
  p->setcolor(Color(255,0,0,255));

  p->moveto(145,590);
  p->lineto(155 + 300, 590);
  p->lineto(155 + 300, 590);
  p->lineto(145,630);

  p->fill();

  p->grestore();
}
 
void 
guppi_print_pie    (Printer* p, PiePlotState* state)
{  
  p->gsave();
  
  p->setcolor(Color(255,0,0,255));

  p->moveto(145,590);
  p->lineto(155 + 300, 590);
  p->lineto(155 + 300, 590);
  p->lineto(145,630);

  p->fill();

  p->grestore();
}

