/* Serialization.c generated by valac 0.22.1, the Vala compiler
 * generated from Serialization.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 2 -*- */
/* Serialization.vala
 *
 * Copyright (C) 2012-2013  Richard Schwarting <aquarichy@gmail.com>
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Richard Schwarting <aquarichy@gmail.com>
 */
/* TODO: so it seems we can get property information from GObjectClass
   but that's about it.  Need to definitely use introspection for anything
   tastier */
/* TODO: document memory management for the C side */

#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))

#define GXML_TYPE_SERIALIZATION (gxml_serialization_get_type ())
#define GXML_SERIALIZATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZATION, GXmlSerialization))
#define GXML_SERIALIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZATION, GXmlSerializationClass))
#define GXML_IS_SERIALIZATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZATION))
#define GXML_IS_SERIALIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZATION))
#define GXML_SERIALIZATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZATION, GXmlSerializationClass))

typedef struct _GXmlSerialization GXmlSerialization;
typedef struct _GXmlSerializationClass GXmlSerializationClass;
typedef struct _GXmlSerializationPrivate GXmlSerializationPrivate;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_NODE, GXmlNodeClass))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_NODE))
#define GXML_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_NODE, GXmlNodeClass))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeClass GXmlNodeClass;

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOCUMENT, GXmlDocumentClass))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentClass))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentClass GXmlDocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GXML_TYPE_SERIALIZABLE (gxml_serializable_get_type ())
#define GXML_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializable))
#define GXML_IS_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE))
#define GXML_SERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializableIface))

typedef struct _GXmlSerializable GXmlSerializable;
typedef struct _GXmlSerializableIface GXmlSerializableIface;

#define GXML_TYPE_BACKED_NODE (gxml_backed_node_get_type ())
#define GXML_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNode))
#define GXML_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))
#define GXML_IS_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_BACKED_NODE))
#define GXML_IS_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_BACKED_NODE))
#define GXML_BACKED_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))

typedef struct _GXmlBackedNode GXmlBackedNode;
typedef struct _GXmlBackedNodeClass GXmlBackedNodeClass;

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT, GXmlElementClass))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT, GXmlElementClass))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementClass GXmlElementClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GXML_TYPE_CHARACTER_DATA (gxml_character_data_get_type ())
#define GXML_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_CHARACTER_DATA, GXmlCharacterData))
#define GXML_CHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_CHARACTER_DATA, GXmlCharacterDataClass))
#define GXML_IS_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_CHARACTER_DATA))
#define GXML_IS_CHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_CHARACTER_DATA))
#define GXML_CHARACTER_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_CHARACTER_DATA, GXmlCharacterDataClass))

typedef struct _GXmlCharacterData GXmlCharacterData;
typedef struct _GXmlCharacterDataClass GXmlCharacterDataClass;

#define GXML_TYPE_TEXT (gxml_text_get_type ())
#define GXML_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_TEXT, GXmlText))
#define GXML_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_TEXT, GXmlTextClass))
#define GXML_IS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_TEXT))
#define GXML_IS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_TEXT))
#define GXML_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_TEXT, GXmlTextClass))

typedef struct _GXmlText GXmlText;
typedef struct _GXmlTextClass GXmlTextClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GXML_TYPE_NODE_LIST (gxml_node_list_get_type ())
#define GXML_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE_LIST, GXmlNodeList))
#define GXML_IS_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE_LIST))
#define GXML_NODE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE_LIST, GXmlNodeListIface))

typedef struct _GXmlNodeList GXmlNodeList;
typedef struct _GXmlNodeListIface GXmlNodeListIface;

/**
 * Errors from {@link Serialization}.
 */
typedef enum  {
	GXML_SERIALIZATION_ERROR_UNKNOWN_TYPE,
	GXML_SERIALIZATION_ERROR_UNKNOWN_PROPERTY,
	GXML_SERIALIZATION_ERROR_UNSUPPORTED_OBJECT_TYPE,
	GXML_SERIALIZATION_ERROR_UNSUPPORTED_PROPERTY_TYPE,
	GXML_SERIALIZATION_ERROR_UNSUPPORTED_TYPE,
	GXML_SERIALIZATION_ERROR_UNSUPPORTED_FILE_FORMAT
} GXmlSerializationError;
#define GXML_SERIALIZATION_ERROR gxml_serialization_error_quark ()
struct _GXmlSerialization {
	GObject parent_instance;
	GXmlSerializationPrivate * priv;
};

struct _GXmlSerializationClass {
	GObjectClass parent_class;
};

struct _GXmlSerializableIface {
	GTypeInterface parent_iface;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializable* self);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializable* self);
	gchar* (*node_name) (GXmlSerializable* self);
	gboolean (*property_use_nick) (GXmlSerializable* self);
	GXmlNode* (*serialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializable* self, GXmlElement* element, GParamSpec* prop, GError** error);
	GXmlNode* (*deserialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_property) (GXmlSerializable* self, GXmlNode* property_node, GError** error);
	GParamSpec* (*find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec* (*default_find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	void (*init_properties) (GXmlSerializable* self);
	void (*default_init_properties) (GXmlSerializable* self);
	GParamSpec** (*list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	GParamSpec** (*default_list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	void (*get_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*default_get_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*set_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*default_set_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	gboolean (*transform_from_string) (GXmlSerializable* self, const gchar* str, GValue* dest, GError** error);
	gboolean (*transform_to_string) (GXmlSerializable* self, GValue* val, gchar** str, GError** error);
	GParamSpec** (*get_properties) (GXmlSerializable* self, int* result_length1);
	void (*set_properties) (GXmlSerializable* self, GParamSpec** value, int value_length1);
	GHashTable* (*get_ignored_serializable_properties) (GXmlSerializable* self);
	void (*set_ignored_serializable_properties) (GXmlSerializable* self, GHashTable* value);
	GHashTable* (*get_unknown_serializable_property) (GXmlSerializable* self);
	void (*set_unknown_serializable_property) (GXmlSerializable* self, GHashTable* value);
	const gchar* (*get_serialized_xml_node_value) (GXmlSerializable* self);
	void (*set_serialized_xml_node_value) (GXmlSerializable* self, const gchar* value);
};

typedef enum  {
	GXML_SERIALIZABLE_ERROR_UNSUPPORTED_TYPE_ERROR,
	GXML_SERIALIZABLE_ERROR_STR_TO_VALUE_ERROR
} GXmlSerializableError;
#define GXML_SERIALIZABLE_ERROR gxml_serializable_error_quark ()
struct _GXmlNodeListIface {
	GTypeInterface parent_iface;
	GXmlNode* (*item) (GXmlNodeList* self, gulong idx);
	GXmlNode* (*insert_before) (GXmlNodeList* self, GXmlNode* new_child, GXmlNode* ref_child);
	GXmlNode* (*replace_child) (GXmlNodeList* self, GXmlNode* new_child, GXmlNode* old_child);
	GXmlNode* (*remove_child) (GXmlNodeList* self, GXmlNode* old_child);
	GXmlNode* (*append_child) (GXmlNodeList* self, GXmlNode* new_child);
	gchar* (*to_string) (GXmlNodeList* self, gboolean in_line);
	GXmlNode* (*first) (GXmlNodeList* self);
	GXmlNode* (*last) (GXmlNodeList* self);
	GXmlNode* (*get) (GXmlNodeList* self, gint n);
	gulong (*get_length) (GXmlNodeList* self);
	void (*set_length) (GXmlNodeList* self, gulong value);
};


static gpointer gxml_serialization_parent_class = NULL;
static GHashTable* gxml_serialization_deserialize_cache;
static GHashTable* gxml_serialization_deserialize_cache = NULL;
static GHashTable* gxml_serialization_serialize_cache;
static GHashTable* gxml_serialization_serialize_cache = NULL;

void gxml_print_object_properties (GObject* obj);
static GParamSpec** _vala_array_dup4 (GParamSpec** self, int length);
GQuark gxml_serialization_error_quark (void);
GType gxml_serialization_get_type (void) G_GNUC_CONST;
enum  {
	GXML_SERIALIZATION_DUMMY_PROPERTY
};
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
static void gxml_serialization_print_debug (GXmlDocument* doc, GObject* object);
gchar* gxml_node_to_string (GXmlNode* self, gboolean format, gint level);
static GXmlNode* gxml_serialization_serialize_property (GObject* object, GParamSpec* prop_spec, GXmlDocument* doc, GError** error);
GType gxml_backed_node_get_type (void) G_GNUC_CONST;
GType gxml_element_get_type (void) G_GNUC_CONST;
GType gxml_serializable_get_type (void) G_GNUC_CONST;
GType gxml_character_data_get_type (void) G_GNUC_CONST;
GType gxml_text_get_type (void) G_GNUC_CONST;
GXmlText* gxml_document_create_text_node (GXmlDocument* self, const gchar* text_data);
GXmlDocument* gxml_serialization_serialize_object (GObject* object, GError** error);
GXmlNode* gxml_document_copy_node (GXmlDocument* self, GXmlNode* foreign_node, gboolean deep);
GXmlElement* gxml_document_get_document_element (GXmlDocument* self);
static void gxml_serialization_init_caches (void);
GXmlDocument* gxml_document_new (void);
GXmlDocument* gxml_document_construct (GType object_type);
GXmlNode* gxml_serializable_serialize (GXmlSerializable* self, GXmlNode* node, GError** error);
GXmlElement* gxml_document_create_element (GXmlDocument* self, const gchar* tag_name);
GXmlNode* gxml_node_append_child (GXmlNode* self, GXmlNode* new_child);
void gxml_element_set_attribute (GXmlElement* self, const gchar* name, const gchar* value);
static GParamSpec** _vala_array_dup5 (GParamSpec** self, int length);
static void gxml_serialization_deserialize_property (GParamSpec* spec, GXmlElement* prop_elem, GValue* val, GError** error);
GQuark gxml_serializable_error_quark (void);
gboolean gxml_serializable_string_to_gvalue (const gchar* str, GValue* dest, GError** error);
gchar* gxml_element_get_content (GXmlElement* self);
GXmlNode* gxml_node_get_first_child (GXmlNode* self);
GObject* gxml_serialization_deserialize_object_from_node (GXmlNode* obj_node, GError** error);
void gxml_serialization_clear_cache (void);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
GObject* gxml_serialization_deserialize_object (GType type, GXmlDocument* doc, GError** error);
GXmlNode* gxml_serializable_deserialize (GXmlSerializable* self, GXmlNode* node, GError** error);
gchar* gxml_element_get_attribute (GXmlElement* self, const gchar* name);
static void g_parameter_destroy (GParameter* self);
static void _vala_GParameter_array_free (GParameter* array, gint array_length);
static GParamSpec** _vala_array_dup6 (GParamSpec** self, int length);
GType gxml_node_list_get_type (void) G_GNUC_CONST;
GXmlNodeList* gxml_node_get_child_nodes (GXmlNode* self);
GXmlNode* gxml_node_list_get (GXmlNodeList* self, gint n);
const gchar* gxml_node_get_node_name (GXmlNode* self);
GXmlSerialization* gxml_serialization_new (void);
GXmlSerialization* gxml_serialization_construct (GType object_type);
static void gxml_serialization_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_param_spec_ref0 (gpointer self) {
	return self ? g_param_spec_ref (self) : NULL;
}


static GParamSpec** _vala_array_dup4 (GParamSpec** self, int length) {
	GParamSpec** result;
	int i;
	result = g_new0 (GParamSpec*, length + 1);
	for (i = 0; i < length; i++) {
		GParamSpec* _tmp0_ = NULL;
		_tmp0_ = _g_param_spec_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void gxml_print_object_properties (GObject* obj) {
	GParamSpec** properties = NULL;
	gint properties_length1 = 0;
	gint _properties_size_ = 0;
	GObject* _tmp0_ = NULL;
	GObjectClass* _tmp1_ = NULL;
	guint _tmp2_;
	GParamSpec** _tmp3_ = NULL;
	GParamSpec** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	FILE* _tmp5_ = NULL;
	GParamSpec** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GParamSpec** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_if_fail (obj != NULL);
	_tmp0_ = obj;
	_tmp1_ = G_OBJECT_GET_CLASS (_tmp0_);
	_tmp3_ = g_object_class_list_properties (_tmp1_, &_tmp2_);
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup4 (_tmp3_, _tmp2_) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp2_;
	properties = (_vala_array_free (properties, properties_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	properties = _tmp4_;
	properties_length1 = _tmp4__length1;
	_properties_size_ = properties_length1;
	_tmp5_ = stdout;
	_tmp6_ = properties;
	_tmp6__length1 = properties_length1;
	fprintf (_tmp5_, "object has %d properties\n", _tmp6__length1);
	_tmp7_ = properties;
	_tmp7__length1 = properties_length1;
	{
		GParamSpec** prop_spec_collection = NULL;
		gint prop_spec_collection_length1 = 0;
		gint _prop_spec_collection_size_ = 0;
		gint prop_spec_it = 0;
		prop_spec_collection = _tmp7_;
		prop_spec_collection_length1 = _tmp7__length1;
		for (prop_spec_it = 0; prop_spec_it < _tmp7__length1; prop_spec_it = prop_spec_it + 1) {
			GParamSpec* _tmp8_ = NULL;
			GParamSpec* prop_spec = NULL;
			_tmp8_ = _g_param_spec_ref0 (prop_spec_collection[prop_spec_it]);
			prop_spec = _tmp8_;
			{
				FILE* _tmp9_ = NULL;
				FILE* _tmp10_ = NULL;
				GParamSpec* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				FILE* _tmp13_ = NULL;
				GParamSpec* _tmp14_ = NULL;
				GType _tmp15_ = 0UL;
				const gchar* _tmp16_ = NULL;
				FILE* _tmp17_ = NULL;
				GParamSpec* _tmp18_ = NULL;
				GType _tmp19_ = 0UL;
				const gchar* _tmp20_ = NULL;
				FILE* _tmp21_ = NULL;
				GParamSpec* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				FILE* _tmp24_ = NULL;
				GParamSpec* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				FILE* _tmp27_ = NULL;
				GParamSpec* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				_tmp9_ = stdout;
				fprintf (_tmp9_, "---\n");
				_tmp10_ = stdout;
				_tmp11_ = prop_spec;
				_tmp12_ = _tmp11_->name;
				fprintf (_tmp10_, "name            %s\n", _tmp12_);
				_tmp13_ = stdout;
				_tmp14_ = prop_spec;
				_tmp15_ = _tmp14_->value_type;
				_tmp16_ = g_type_name (_tmp15_);
				fprintf (_tmp13_, "  value_type    %s\n", _tmp16_);
				_tmp17_ = stdout;
				_tmp18_ = prop_spec;
				_tmp19_ = _tmp18_->owner_type;
				_tmp20_ = g_type_name (_tmp19_);
				fprintf (_tmp17_, "  owner_type    %s\n", _tmp20_);
				_tmp21_ = stdout;
				_tmp22_ = prop_spec;
				_tmp23_ = g_param_spec_get_name (_tmp22_);
				fprintf (_tmp21_, "  get_name ()   %s\n", _tmp23_);
				_tmp24_ = stdout;
				_tmp25_ = prop_spec;
				_tmp26_ = g_param_spec_get_blurb (_tmp25_);
				fprintf (_tmp24_, "  get_blurb ()  %s\n", _tmp26_);
				_tmp27_ = stdout;
				_tmp28_ = prop_spec;
				_tmp29_ = g_param_spec_get_nick (_tmp28_);
				fprintf (_tmp27_, "  get_nick ()   %s\n", _tmp29_);
				_g_param_spec_unref0 (prop_spec);
			}
		}
	}
	properties = (_vala_array_free (properties, properties_length1, (GDestroyNotify) g_param_spec_unref), NULL);
}


GQuark gxml_serialization_error_quark (void) {
	return g_quark_from_static_string ("gxml_serialization_error-quark");
}


static void gxml_serialization_print_debug (GXmlDocument* doc, GObject* object) {
	FILE* _tmp0_ = NULL;
	GXmlDocument* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	FILE* _tmp4_ = NULL;
	FILE* _tmp5_ = NULL;
	GObject* _tmp6_ = NULL;
	GType _tmp7_ = 0UL;
	const gchar* _tmp8_ = NULL;
	FILE* _tmp9_ = NULL;
	GObject* _tmp10_ = NULL;
	GObjectClass* _tmp11_ = NULL;
	GType _tmp12_ = 0UL;
	const gchar* _tmp13_ = NULL;
	GObject* _tmp14_ = NULL;
	g_return_if_fail (doc != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = stdout;
	_tmp1_ = doc;
	_tmp2_ = gxml_node_to_string ((GXmlNode*) _tmp1_, FALSE, 0);
	_tmp3_ = _tmp2_;
	fprintf (_tmp0_, "Object XML\n---\n%s\n", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = stdout;
	fprintf (_tmp4_, "object\n---\n");
	_tmp5_ = stdout;
	_tmp6_ = object;
	_tmp7_ = G_TYPE_FROM_INSTANCE (_tmp6_);
	_tmp8_ = g_type_name (_tmp7_);
	fprintf (_tmp5_, "get_type (): %s\n", _tmp8_);
	_tmp9_ = stdout;
	_tmp10_ = object;
	_tmp11_ = G_OBJECT_GET_CLASS (_tmp10_);
	_tmp12_ = G_TYPE_FROM_CLASS ((GTypeClass*) _tmp11_);
	_tmp13_ = g_type_name (_tmp12_);
	fprintf (_tmp9_, "get_class ().get_type (): %s\n", _tmp13_);
	_tmp14_ = object;
	gxml_print_object_properties (_tmp14_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GXmlNode* gxml_serialization_serialize_property (GObject* object, GParamSpec* prop_spec, GXmlDocument* doc, GError** error) {
	GXmlNode* result = NULL;
	GType type = 0UL;
	GValue value = {0};
	GXmlNode* value_node = NULL;
	GXmlSerializable* serializable = NULL;
	GObject* _tmp0_ = NULL;
	GType _tmp1_ = 0UL;
	gboolean _tmp2_ = FALSE;
	GParamSpec* _tmp5_ = NULL;
	GType _tmp6_ = 0UL;
	GParamSpec* _tmp7_ = NULL;
	GType _tmp8_ = 0UL;
	gboolean _tmp9_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (prop_spec != NULL, NULL);
	g_return_val_if_fail (doc != NULL, NULL);
	serializable = NULL;
	_tmp0_ = object;
	_tmp1_ = G_TYPE_FROM_INSTANCE (_tmp0_);
	_tmp2_ = g_type_is_a (_tmp1_, GXML_TYPE_SERIALIZABLE);
	if (_tmp2_) {
		GObject* _tmp3_ = NULL;
		GXmlSerializable* _tmp4_ = NULL;
		_tmp3_ = object;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GXML_TYPE_SERIALIZABLE, GXmlSerializable));
		_g_object_unref0 (serializable);
		serializable = _tmp4_;
	}
	_tmp5_ = prop_spec;
	_tmp6_ = _tmp5_->value_type;
	type = _tmp6_;
	_tmp7_ = prop_spec;
	_tmp8_ = _tmp7_->value_type;
	_tmp9_ = G_TYPE_IS_ENUM (_tmp8_);
	if (_tmp9_) {
		GValue _tmp10_ = {0};
		GValue _tmp11_ = {0};
		GObject* _tmp12_ = NULL;
		GParamSpec* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GXmlDocument* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		GXmlText* _tmp19_ = NULL;
		GXmlNode* _tmp20_ = NULL;
		g_value_init (&_tmp10_, G_TYPE_INT);
		G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
		value = _tmp10_;
		_tmp11_ = value;
		_tmp12_ = object;
		_tmp13_ = prop_spec;
		_tmp14_ = _tmp13_->name;
		g_object_get_property (_tmp12_, _tmp14_, &value);
		_tmp15_ = doc;
		_tmp16_ = g_value_get_int (&value);
		_tmp17_ = g_strdup_printf ("%d", _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gxml_document_create_text_node (_tmp15_, _tmp18_);
		_tmp20_ = _g_object_ref0 ((GXmlNode*) _tmp19_);
		_g_object_unref0 (value_node);
		value_node = _tmp20_;
		_g_free0 (_tmp18_);
	} else {
		GParamSpec* _tmp21_ = NULL;
		GType _tmp22_ = 0UL;
		gboolean _tmp23_ = FALSE;
		_tmp21_ = prop_spec;
		_tmp22_ = _tmp21_->value_type;
		_tmp23_ = g_value_type_transformable (_tmp22_, G_TYPE_STRING);
		if (_tmp23_) {
			GValue _tmp24_ = {0};
			GValue _tmp25_ = {0};
			GObject* _tmp26_ = NULL;
			GParamSpec* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			GXmlDocument* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			GXmlText* _tmp31_ = NULL;
			GXmlNode* _tmp32_ = NULL;
			g_value_init (&_tmp24_, G_TYPE_STRING);
			G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
			value = _tmp24_;
			_tmp25_ = value;
			_tmp26_ = object;
			_tmp27_ = prop_spec;
			_tmp28_ = _tmp27_->name;
			g_object_get_property (_tmp26_, _tmp28_, &value);
			_tmp29_ = doc;
			_tmp30_ = g_value_get_string (&value);
			_tmp31_ = gxml_document_create_text_node (_tmp29_, _tmp30_);
			_tmp32_ = _g_object_ref0 ((GXmlNode*) _tmp31_);
			_g_object_unref0 (value_node);
			value_node = _tmp32_;
		} else {
			GType _tmp33_ = 0UL;
			_tmp33_ = type;
			if (_tmp33_ == G_TYPE_GTYPE) {
				GXmlDocument* _tmp34_ = NULL;
				GType _tmp35_ = 0UL;
				const gchar* _tmp36_ = NULL;
				GXmlText* _tmp37_ = NULL;
				GXmlNode* _tmp38_ = NULL;
				_tmp34_ = doc;
				_tmp35_ = type;
				_tmp36_ = g_type_name (_tmp35_);
				_tmp37_ = gxml_document_create_text_node (_tmp34_, _tmp36_);
				_tmp38_ = _g_object_ref0 ((GXmlNode*) _tmp37_);
				_g_object_unref0 (value_node);
				value_node = _tmp38_;
			} else {
				gboolean _tmp39_ = FALSE;
				GType _tmp40_ = 0UL;
				gboolean _tmp41_ = FALSE;
				gboolean _tmp44_ = FALSE;
				_tmp40_ = type;
				_tmp41_ = g_type_is_a (_tmp40_, G_TYPE_OBJECT);
				if (_tmp41_) {
					GType _tmp42_ = 0UL;
					gboolean _tmp43_ = FALSE;
					_tmp42_ = type;
					_tmp43_ = g_type_is_a (_tmp42_, GEE_TYPE_COLLECTION);
					_tmp39_ = !_tmp43_;
				} else {
					_tmp39_ = FALSE;
				}
				_tmp44_ = _tmp39_;
				if (_tmp44_) {
					GObject* child_object = NULL;
					GValue _tmp45_ = {0};
					GValue _tmp46_ = {0};
					GObject* _tmp47_ = NULL;
					GParamSpec* _tmp48_ = NULL;
					const gchar* _tmp49_ = NULL;
					GObject* _tmp50_ = NULL;
					GObject* _tmp51_ = NULL;
					GXmlDocument* value_doc = NULL;
					GObject* _tmp52_ = NULL;
					GXmlDocument* _tmp53_ = NULL;
					GXmlDocument* _tmp54_ = NULL;
					GXmlDocument* _tmp55_ = NULL;
					GXmlElement* _tmp56_ = NULL;
					GXmlElement* _tmp57_ = NULL;
					GXmlNode* _tmp58_ = NULL;
					GXmlNode* _tmp59_ = NULL;
					g_value_init (&_tmp45_, G_TYPE_OBJECT);
					G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
					value = _tmp45_;
					_tmp46_ = value;
					_tmp47_ = object;
					_tmp48_ = prop_spec;
					_tmp49_ = _tmp48_->name;
					g_object_get_property (_tmp47_, _tmp49_, &value);
					_tmp50_ = g_value_get_object (&value);
					_tmp51_ = _g_object_ref0 (_tmp50_);
					_g_object_unref0 (child_object);
					child_object = _tmp51_;
					_tmp52_ = child_object;
					_tmp53_ = gxml_serialization_serialize_object (_tmp52_, &_inner_error_);
					value_doc = _tmp53_;
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (child_object);
						_g_object_unref0 (serializable);
						_g_object_unref0 (value_node);
						G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
						return NULL;
					}
					_tmp54_ = doc;
					_tmp55_ = value_doc;
					_tmp56_ = gxml_document_get_document_element (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = gxml_document_copy_node (_tmp54_, (GXmlNode*) _tmp57_, TRUE);
					_tmp59_ = _g_object_ref0 (_tmp58_);
					_g_object_unref0 (value_node);
					value_node = _tmp59_;
					_g_object_unref0 (value_doc);
					_g_object_unref0 (child_object);
				} else {
					GType _tmp60_ = 0UL;
					const gchar* _tmp61_ = NULL;
					_tmp60_ = type;
					_tmp61_ = g_type_name (_tmp60_);
					if (g_strcmp0 (_tmp61_, "gpointer") == 0) {
						GParamSpec* _tmp62_ = NULL;
						const gchar* _tmp63_ = NULL;
						GObject* _tmp64_ = NULL;
						GType _tmp65_ = 0UL;
						const gchar* _tmp66_ = NULL;
						GXmlDocument* _tmp67_ = NULL;
						GParamSpec* _tmp68_ = NULL;
						const gchar* _tmp69_ = NULL;
						GXmlText* _tmp70_ = NULL;
						GXmlNode* _tmp71_ = NULL;
						_tmp62_ = prop_spec;
						_tmp63_ = _tmp62_->name;
						_tmp64_ = object;
						_tmp65_ = G_TYPE_FROM_INSTANCE (_tmp64_);
						_tmp66_ = g_type_name (_tmp65_);
						g_warning ("Serialization.vala:179: DEBUG: skipping gpointer with name '%s' of obj" \
"ect '%s'", _tmp63_, _tmp66_);
						_tmp67_ = doc;
						_tmp68_ = prop_spec;
						_tmp69_ = _tmp68_->name;
						_tmp70_ = gxml_document_create_text_node (_tmp67_, _tmp69_);
						_tmp71_ = _g_object_ref0 ((GXmlNode*) _tmp70_);
						_g_object_unref0 (value_node);
						value_node = _tmp71_;
					} else {
						GType _tmp72_ = 0UL;
						const gchar* _tmp73_ = NULL;
						GParamSpec* _tmp74_ = NULL;
						const gchar* _tmp75_ = NULL;
						GObject* _tmp76_ = NULL;
						GType _tmp77_ = 0UL;
						const gchar* _tmp78_ = NULL;
						GError* _tmp79_ = NULL;
						_tmp72_ = type;
						_tmp73_ = g_type_name (_tmp72_);
						_tmp74_ = prop_spec;
						_tmp75_ = _tmp74_->name;
						_tmp76_ = object;
						_tmp77_ = G_TYPE_FROM_INSTANCE (_tmp76_);
						_tmp78_ = g_type_name (_tmp77_);
						_tmp79_ = g_error_new (GXML_SERIALIZATION_ERROR, GXML_SERIALIZATION_ERROR_UNSUPPORTED_PROPERTY_TYPE, "Can't currently serialize type '%s' for property '%s' of object '%s'", _tmp73_, _tmp75_, _tmp78_);
						_inner_error_ = _tmp79_;
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (serializable);
						_g_object_unref0 (value_node);
						G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
						return NULL;
					}
				}
			}
		}
	}
	result = value_node;
	_g_object_unref0 (serializable);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	return result;
}


/**
 * Serializes a {@link GLib.Object} into a {@link GXml.Document}.
 *
 * This takes a {@link GLib.Object} and serializes it
 * into a {@link GXml.Document} which can be saved to
 * disk or transferred over a network.  It handles
 * serialization of primitive properties and some more
 * complex ones like enums, other {@link GLib.Object}s
 * recursively, and some collections.
 *
 * The serialization process can be customised for an object
 * by having the object implement the {@link GXml.Serializable}
 * interface, which allows direct control over the
 * conversation of individual properties into {@link GXml.Node}s
 * and the object's list of properties as used by
 * {@link GXml.Serialization}.
 *
 * A {@link GXml.SerializationError} may be thrown if there is
 * a problem serializing a property (e.g. the type is unknown,
 * unsupported, or the property isn't known to the object).
 *
 * @param object A {@link GLib.Object} to serialize
 * @return a {@link GXml.Document} representing the serialized `object`
 */
static GParamSpec** _vala_array_dup5 (GParamSpec** self, int length) {
	GParamSpec** result;
	int i;
	result = g_new0 (GParamSpec*, length + 1);
	for (i = 0; i < length; i++) {
		GParamSpec* _tmp0_ = NULL;
		_tmp0_ = _g_param_spec_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


GXmlDocument* gxml_serialization_serialize_object (GObject* object, GError** error) {
	GXmlDocument* result = NULL;
	GXmlDocument* doc = NULL;
	GXmlElement* root = NULL;
	GParamSpec** prop_specs = NULL;
	gint prop_specs_length1 = 0;
	gint _prop_specs_size_ = 0;
	GXmlElement* prop = NULL;
	GXmlNode* value_prop = NULL;
	gchar* oid = NULL;
	GXmlDocument* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GObject* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp13_ = FALSE;
	GObject* _tmp25_ = NULL;
	GXmlDocument* _tmp37_ = NULL;
	GXmlElement* _tmp38_ = NULL;
	GXmlElement* _tmp39_ = NULL;
	GXmlDocument* _tmp40_ = NULL;
	GXmlElement* _tmp41_ = NULL;
	GXmlElement* _tmp42_ = NULL;
	GObject* _tmp43_ = NULL;
	GType _tmp44_ = 0UL;
	const gchar* _tmp45_ = NULL;
	GXmlElement* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	GHashTable* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	GXmlElement* _tmp51_ = NULL;
	GXmlNode* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GObjectClass* _tmp54_ = NULL;
	guint _tmp55_;
	GParamSpec** _tmp56_ = NULL;
	GParamSpec** _tmp57_ = NULL;
	gint _tmp57__length1 = 0;
	GParamSpec** _tmp58_ = NULL;
	gint _tmp58__length1 = 0;
	gboolean debug = FALSE;
	gboolean _tmp79_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (object != NULL, NULL);
	value_prop = NULL;
	gxml_serialization_init_caches ();
	_tmp0_ = gxml_document_new ();
	_g_object_unref0 (doc);
	doc = _tmp0_;
	_tmp1_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GXML_TYPE_SERIALIZABLE)) {
		GObject* _tmp2_ = NULL;
		GXmlDocument* _tmp3_ = NULL;
		GXmlNode* _tmp4_ = NULL;
		GXmlNode* _tmp5_ = NULL;
		_tmp2_ = object;
		_tmp3_ = doc;
		_tmp4_ = gxml_serializable_serialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), (GXmlNode*) _tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp5_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (oid);
			_g_object_unref0 (value_prop);
			_g_object_unref0 (prop);
			prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (root);
			_g_object_unref0 (doc);
			return NULL;
		}
		result = doc;
		_g_free0 (oid);
		_g_object_unref0 (value_prop);
		_g_object_unref0 (prop);
		prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
		_g_object_unref0 (root);
		return result;
	}
	_tmp6_ = object;
	_tmp7_ = g_strdup_printf ("%p", _tmp6_);
	_g_free0 (oid);
	oid = _tmp7_;
	_tmp9_ = oid;
	if (g_strcmp0 (_tmp9_, "") != 0) {
		GHashTable* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp10_ = gxml_serialization_serialize_cache;
		_tmp11_ = oid;
		_tmp12_ = g_hash_table_contains (_tmp10_, _tmp11_);
		_tmp8_ = _tmp12_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp13_ = _tmp8_;
	if (_tmp13_) {
		GXmlDocument* _tmp14_ = NULL;
		GXmlElement* _tmp15_ = NULL;
		GXmlElement* _tmp16_ = NULL;
		GXmlDocument* _tmp17_ = NULL;
		GXmlElement* _tmp18_ = NULL;
		GXmlElement* _tmp19_ = NULL;
		GObject* _tmp20_ = NULL;
		GType _tmp21_ = 0UL;
		const gchar* _tmp22_ = NULL;
		GXmlElement* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp14_ = doc;
		_tmp15_ = gxml_document_create_element (_tmp14_, "ObjectRef");
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_g_object_unref0 (root);
		root = _tmp16_;
		_tmp17_ = doc;
		_tmp18_ = root;
		gxml_node_append_child ((GXmlNode*) _tmp17_, (GXmlNode*) _tmp18_);
		_tmp19_ = root;
		_tmp20_ = object;
		_tmp21_ = G_TYPE_FROM_INSTANCE (_tmp20_);
		_tmp22_ = g_type_name (_tmp21_);
		gxml_element_set_attribute (_tmp19_, "otype", _tmp22_);
		_tmp23_ = root;
		_tmp24_ = oid;
		gxml_element_set_attribute (_tmp23_, "oid", _tmp24_);
		result = doc;
		_g_free0 (oid);
		_g_object_unref0 (value_prop);
		_g_object_unref0 (prop);
		prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
		_g_object_unref0 (root);
		return result;
	}
	_tmp25_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, GXML_TYPE_SERIALIZABLE)) {
		GObject* _tmp26_ = NULL;
		GXmlDocument* _tmp27_ = NULL;
		GXmlNode* _tmp28_ = NULL;
		GXmlNode* _tmp29_ = NULL;
		GHashTable* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		GXmlDocument* _tmp33_ = NULL;
		GXmlElement* _tmp34_ = NULL;
		GXmlElement* _tmp35_ = NULL;
		GXmlNode* _tmp36_ = NULL;
		_tmp26_ = object;
		_tmp27_ = doc;
		_tmp28_ = gxml_serializable_serialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), (GXmlNode*) _tmp27_, &_inner_error_);
		_tmp29_ = _tmp28_;
		_g_object_unref0 (_tmp29_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (oid);
			_g_object_unref0 (value_prop);
			_g_object_unref0 (prop);
			prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (root);
			_g_object_unref0 (doc);
			return NULL;
		}
		_tmp30_ = gxml_serialization_serialize_cache;
		_tmp31_ = oid;
		_tmp32_ = g_strdup (_tmp31_);
		_tmp33_ = doc;
		_tmp34_ = gxml_document_get_document_element (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = _g_object_ref0 ((GXmlNode*) _tmp35_);
		g_hash_table_insert (_tmp30_, _tmp32_, _tmp36_);
		result = doc;
		_g_free0 (oid);
		_g_object_unref0 (value_prop);
		_g_object_unref0 (prop);
		prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
		_g_object_unref0 (root);
		return result;
	}
	_tmp37_ = doc;
	_tmp38_ = gxml_document_create_element (_tmp37_, "Object");
	_tmp39_ = _g_object_ref0 (_tmp38_);
	_g_object_unref0 (root);
	root = _tmp39_;
	_tmp40_ = doc;
	_tmp41_ = root;
	gxml_node_append_child ((GXmlNode*) _tmp40_, (GXmlNode*) _tmp41_);
	_tmp42_ = root;
	_tmp43_ = object;
	_tmp44_ = G_TYPE_FROM_INSTANCE (_tmp43_);
	_tmp45_ = g_type_name (_tmp44_);
	gxml_element_set_attribute (_tmp42_, "otype", _tmp45_);
	_tmp46_ = root;
	_tmp47_ = oid;
	gxml_element_set_attribute (_tmp46_, "oid", _tmp47_);
	_tmp48_ = gxml_serialization_serialize_cache;
	_tmp49_ = oid;
	_tmp50_ = g_strdup (_tmp49_);
	_tmp51_ = root;
	_tmp52_ = _g_object_ref0 ((GXmlNode*) _tmp51_);
	g_hash_table_insert (_tmp48_, _tmp50_, _tmp52_);
	_tmp53_ = object;
	_tmp54_ = G_OBJECT_GET_CLASS (_tmp53_);
	_tmp56_ = g_object_class_list_properties (_tmp54_, &_tmp55_);
	_tmp57_ = (_tmp56_ != NULL) ? _vala_array_dup5 (_tmp56_, _tmp55_) : ((gpointer) _tmp56_);
	_tmp57__length1 = _tmp55_;
	prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	prop_specs = _tmp57_;
	prop_specs_length1 = _tmp57__length1;
	_prop_specs_size_ = prop_specs_length1;
	_tmp58_ = prop_specs;
	_tmp58__length1 = prop_specs_length1;
	{
		GParamSpec** prop_spec_collection = NULL;
		gint prop_spec_collection_length1 = 0;
		gint _prop_spec_collection_size_ = 0;
		gint prop_spec_it = 0;
		prop_spec_collection = _tmp58_;
		prop_spec_collection_length1 = _tmp58__length1;
		for (prop_spec_it = 0; prop_spec_it < _tmp58__length1; prop_spec_it = prop_spec_it + 1) {
			GParamSpec* _tmp59_ = NULL;
			GParamSpec* prop_spec = NULL;
			_tmp59_ = _g_param_spec_ref0 (prop_spec_collection[prop_spec_it]);
			prop_spec = _tmp59_;
			{
				GXmlDocument* _tmp60_ = NULL;
				GXmlElement* _tmp61_ = NULL;
				GXmlElement* _tmp62_ = NULL;
				GXmlElement* _tmp63_ = NULL;
				GParamSpec* _tmp64_ = NULL;
				GType _tmp65_ = 0UL;
				const gchar* _tmp66_ = NULL;
				GXmlElement* _tmp67_ = NULL;
				GParamSpec* _tmp68_ = NULL;
				const gchar* _tmp69_ = NULL;
				GXmlNode* _tmp70_ = NULL;
				GObject* _tmp71_ = NULL;
				GParamSpec* _tmp72_ = NULL;
				GXmlDocument* _tmp73_ = NULL;
				GXmlNode* _tmp74_ = NULL;
				GXmlElement* _tmp75_ = NULL;
				GXmlNode* _tmp76_ = NULL;
				GXmlElement* _tmp77_ = NULL;
				GXmlElement* _tmp78_ = NULL;
				_tmp60_ = doc;
				_tmp61_ = gxml_document_create_element (_tmp60_, "Property");
				_tmp62_ = _g_object_ref0 (_tmp61_);
				_g_object_unref0 (prop);
				prop = _tmp62_;
				_tmp63_ = prop;
				_tmp64_ = prop_spec;
				_tmp65_ = _tmp64_->value_type;
				_tmp66_ = g_type_name (_tmp65_);
				gxml_element_set_attribute (_tmp63_, "ptype", _tmp66_);
				_tmp67_ = prop;
				_tmp68_ = prop_spec;
				_tmp69_ = _tmp68_->name;
				gxml_element_set_attribute (_tmp67_, "pname", _tmp69_);
				_tmp71_ = object;
				_tmp72_ = prop_spec;
				_tmp73_ = doc;
				_tmp74_ = gxml_serialization_serialize_property (_tmp71_, _tmp72_, _tmp73_, &_inner_error_);
				_tmp70_ = _tmp74_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_param_spec_unref0 (prop_spec);
					_g_free0 (oid);
					_g_object_unref0 (value_prop);
					_g_object_unref0 (prop);
					prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
					_g_object_unref0 (root);
					_g_object_unref0 (doc);
					return NULL;
				}
				_g_object_unref0 (value_prop);
				value_prop = _tmp70_;
				_tmp75_ = prop;
				_tmp76_ = value_prop;
				gxml_node_append_child ((GXmlNode*) _tmp75_, _tmp76_);
				_tmp77_ = root;
				_tmp78_ = prop;
				gxml_node_append_child ((GXmlNode*) _tmp77_, (GXmlNode*) _tmp78_);
				_g_param_spec_unref0 (prop_spec);
			}
		}
	}
	debug = FALSE;
	_tmp79_ = debug;
	if (_tmp79_) {
		GXmlDocument* _tmp80_ = NULL;
		GObject* _tmp81_ = NULL;
		_tmp80_ = doc;
		_tmp81_ = object;
		gxml_serialization_print_debug (_tmp80_, _tmp81_);
	}
	result = doc;
	_g_free0 (oid);
	_g_object_unref0 (value_prop);
	_g_object_unref0 (prop);
	prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	_g_object_unref0 (root);
	return result;
}


static void gxml_serialization_deserialize_property (GParamSpec* spec, GXmlElement* prop_elem, GValue* val, GError** error) {
	GValue _vala_val = {0};
	GType type = 0UL;
	GParamSpec* _tmp0_ = NULL;
	GType _tmp1_ = 0UL;
	GType _tmp2_ = 0UL;
	GValue _tmp3_ = {0};
	GValue _tmp4_ = {0};
	GType _tmp5_ = 0UL;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (spec != NULL);
	g_return_if_fail (prop_elem != NULL);
	_tmp0_ = spec;
	_tmp1_ = _tmp0_->value_type;
	type = _tmp1_;
	_tmp2_ = type;
	g_value_init (&_tmp3_, _tmp2_);
	G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
	_vala_val = _tmp3_;
	_tmp4_ = _vala_val;
	_tmp5_ = type;
	_tmp6_ = g_value_type_transformable (_tmp5_, G_TYPE_STRING);
	if (_tmp6_) {
		GXmlElement* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp7_ = prop_elem;
		_tmp8_ = gxml_element_get_content (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		gxml_serializable_string_to_gvalue (_tmp10_, &_vala_val, &_inner_error_);
		_g_free0 (_tmp10_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	} else {
		GType _tmp11_ = 0UL;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = type;
		_tmp12_ = g_type_is_a (_tmp11_, G_TYPE_OBJECT);
		if (_tmp12_) {
			GXmlNode* prop_elem_child = NULL;
			GObject* property_object = NULL;
			GXmlElement* _tmp13_ = NULL;
			GXmlNode* _tmp14_ = NULL;
			GXmlNode* _tmp15_ = NULL;
			GXmlNode* _tmp16_ = NULL;
			GObject* _tmp17_ = NULL;
			GXmlNode* _tmp18_ = NULL;
			GObject* _tmp19_ = NULL;
			GObject* _tmp20_ = NULL;
			_tmp13_ = prop_elem;
			_tmp14_ = gxml_node_get_first_child ((GXmlNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = _g_object_ref0 (_tmp15_);
			_g_object_unref0 (prop_elem_child);
			prop_elem_child = _tmp16_;
			_tmp18_ = prop_elem_child;
			_tmp19_ = gxml_serialization_deserialize_object_from_node (_tmp18_, &_inner_error_);
			_tmp17_ = _tmp19_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (property_object);
				_g_object_unref0 (prop_elem_child);
				return;
			}
			_g_object_unref0 (property_object);
			property_object = _tmp17_;
			_tmp20_ = property_object;
			g_value_set_object (&_vala_val, _tmp20_);
			_g_object_unref0 (property_object);
			_g_object_unref0 (prop_elem_child);
		}
	}
	if (val) {
		*val = _vala_val;
	} else {
		G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
	}
}


void gxml_serialization_clear_cache (void) {
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp2_ = NULL;
	_tmp0_ = gxml_serialization_deserialize_cache;
	if (_tmp0_ != NULL) {
		GHashTable* _tmp1_ = NULL;
		_tmp1_ = gxml_serialization_deserialize_cache;
		g_hash_table_remove_all (_tmp1_);
	}
	_tmp2_ = gxml_serialization_serialize_cache;
	if (_tmp2_ != NULL) {
		GHashTable* _tmp3_ = NULL;
		_tmp3_ = gxml_serialization_serialize_cache;
		g_hash_table_remove_all (_tmp3_);
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void gxml_serialization_init_caches (void) {
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp4_ = NULL;
	_tmp0_ = gxml_serialization_deserialize_cache;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_ = NULL;
		GEqualFunc _tmp2_ = NULL;
		GHashTable* _tmp3_ = NULL;
		_tmp1_ = g_str_hash;
		_tmp2_ = g_str_equal;
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (gxml_serialization_deserialize_cache);
		gxml_serialization_deserialize_cache = _tmp3_;
	}
	_tmp4_ = gxml_serialization_serialize_cache;
	if (_tmp4_ == NULL) {
		GHashFunc _tmp5_ = NULL;
		GEqualFunc _tmp6_ = NULL;
		GHashTable* _tmp7_ = NULL;
		_tmp5_ = g_str_hash;
		_tmp6_ = g_str_equal;
		_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (gxml_serialization_serialize_cache);
		gxml_serialization_serialize_cache = _tmp7_;
	}
}


/**
 * Deserialize a {@link GXml.Document} back into a {@link GLib.Object}.
 *
 * This deserializes a {@link GXml.Document} back into a
 * {@link GLib.Object}.  The {@link GXml.Document}
 * must represent a {@link GLib.Object} as serialized
 * by {@link GXml.Serialization}.  The types of the
 * objects that are being deserialized must be known
 * to the system deserializing them or a
 * {@link GXml.SerializationError} will result.
 *
 * @type object type to deserialize
 * @doc a {@link GXml.Document} to deseralize from
 * @return the deserialized {@link GLib.Object}
 */
GObject* gxml_serialization_deserialize_object (GType type, GXmlDocument* doc, GError** error) {
	GObject* result = NULL;
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	GObject* _tmp9_ = NULL;
	GXmlDocument* _tmp10_ = NULL;
	GXmlElement* _tmp11_ = NULL;
	GXmlElement* _tmp12_ = NULL;
	GObject* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	_tmp0_ = type;
	_tmp1_ = g_type_is_a (_tmp0_, GXML_TYPE_SERIALIZABLE);
	if (_tmp1_) {
		GObject* object = NULL;
		GType _tmp2_ = 0UL;
		GObject* _tmp3_ = NULL;
		GObject* _tmp4_ = NULL;
		GObject* _tmp5_ = NULL;
		GXmlDocument* _tmp6_ = NULL;
		GXmlNode* _tmp7_ = NULL;
		GXmlNode* _tmp8_ = NULL;
		_tmp2_ = type;
		_tmp3_ = g_object_new (_tmp2_, NULL);
		_tmp4_ = G_IS_INITIALLY_UNOWNED (_tmp3_) ? g_object_ref_sink (_tmp3_) : _tmp3_;
		object = _tmp4_;
		_tmp5_ = object;
		_tmp6_ = doc;
		_tmp7_ = gxml_serializable_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), (GXmlNode*) _tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp8_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			return NULL;
		}
		result = object;
		return result;
	}
	_tmp10_ = doc;
	_tmp11_ = gxml_document_get_document_element (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = gxml_serialization_deserialize_object_from_node ((GXmlNode*) _tmp12_, &_inner_error_);
	_tmp9_ = _tmp13_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp9_;
	return result;
}


/**
 * This function must assume deserialize over non-Serializable objects
 * because Serializable have its own method serialize/deserialize
 */
static void g_parameter_destroy (GParameter* self) {
	G_IS_VALUE (&(*self).value) ? (g_value_unset (&(*self).value), NULL) : NULL;
}


static void _vala_GParameter_array_free (GParameter* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_parameter_destroy (&array[i]);
		}
	}
	g_free (array);
}


static GParamSpec** _vala_array_dup6 (GParamSpec** self, int length) {
	GParamSpec** result;
	int i;
	result = g_new0 (GParamSpec*, length + 1);
	for (i = 0; i < length; i++) {
		GParamSpec* _tmp0_ = NULL;
		_tmp0_ = _g_param_spec_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


GObject* gxml_serialization_deserialize_object_from_node (GXmlNode* obj_node, GError** error) {
	GObject* result = NULL;
	GXmlElement* obj_elem = NULL;
	gchar* otype = NULL;
	gchar* oid = NULL;
	GType type = 0UL;
	GObject* obj = NULL;
	GObjectClass* obj_class = NULL;
	GParamSpec** specs = NULL;
	gint specs_length1 = 0;
	gint _specs_size_ = 0;
	GXmlNode* _tmp0_ = NULL;
	GXmlElement* _tmp1_ = NULL;
	GXmlElement* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp9_ = FALSE;
	GXmlElement* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GType _tmp17_ = 0UL;
	GType _tmp18_ = 0UL;
	GType _tmp21_ = 0UL;
	gboolean _tmp22_ = FALSE;
	GType _tmp30_ = 0UL;
	GParameter* _tmp31_ = NULL;
	GParameter* _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	GObject* _tmp33_ = NULL;
	GObject* _tmp34_ = NULL;
	GObject* _tmp35_ = NULL;
	GObjectClass* _tmp36_ = NULL;
	GHashTable* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	GObject* _tmp40_ = NULL;
	GObject* _tmp41_ = NULL;
	GObjectClass* _tmp42_ = NULL;
	guint _tmp43_;
	GParamSpec** _tmp44_ = NULL;
	GParamSpec** _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (obj_node != NULL, NULL);
	_tmp0_ = obj_node;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GXML_TYPE_ELEMENT, GXmlElement));
	_g_object_unref0 (obj_elem);
	obj_elem = _tmp1_;
	_tmp2_ = obj_elem;
	_tmp3_ = gxml_element_get_attribute (_tmp2_, "oid");
	_g_free0 (oid);
	oid = _tmp3_;
	gxml_serialization_init_caches ();
	_tmp5_ = oid;
	if (g_strcmp0 (_tmp5_, "") != 0) {
		GHashTable* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = gxml_serialization_deserialize_cache;
		_tmp7_ = oid;
		_tmp8_ = g_hash_table_contains (_tmp6_, _tmp7_);
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		GHashTable* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gconstpointer _tmp12_ = NULL;
		GObject* _tmp13_ = NULL;
		_tmp10_ = gxml_serialization_deserialize_cache;
		_tmp11_ = oid;
		_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
		_tmp13_ = _g_object_ref0 ((GObject*) _tmp12_);
		result = _tmp13_;
		specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
		_g_object_unref0 (obj);
		_g_free0 (oid);
		_g_free0 (otype);
		_g_object_unref0 (obj_elem);
		return result;
	}
	_tmp14_ = obj_elem;
	_tmp15_ = gxml_element_get_attribute (_tmp14_, "otype");
	_g_free0 (otype);
	otype = _tmp15_;
	_tmp16_ = otype;
	_tmp17_ = g_type_from_name (_tmp16_);
	type = _tmp17_;
	_tmp18_ = type;
	if (_tmp18_ == ((GType) 0)) {
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_ = NULL;
		_tmp19_ = otype;
		_tmp20_ = g_error_new (GXML_SERIALIZATION_ERROR, GXML_SERIALIZATION_ERROR_UNKNOWN_TYPE, "Deserializing unknown GType '%s' objects is unsupported", _tmp19_);
		_inner_error_ = _tmp20_;
		g_propagate_error (error, _inner_error_);
		specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
		_g_object_unref0 (obj);
		_g_free0 (oid);
		_g_free0 (otype);
		_g_object_unref0 (obj_elem);
		return NULL;
	}
	_tmp21_ = type;
	_tmp22_ = g_type_is_a (_tmp21_, GXML_TYPE_SERIALIZABLE);
	if (_tmp22_) {
		GType _tmp23_ = 0UL;
		GObject* _tmp24_ = NULL;
		GObject* _tmp25_ = NULL;
		GObject* _tmp26_ = NULL;
		GXmlNode* _tmp27_ = NULL;
		GXmlNode* _tmp28_ = NULL;
		GXmlNode* _tmp29_ = NULL;
		_tmp23_ = type;
		_tmp24_ = g_object_new (_tmp23_, NULL);
		_tmp25_ = G_IS_INITIALLY_UNOWNED (_tmp24_) ? g_object_ref_sink (_tmp24_) : _tmp24_;
		_g_object_unref0 (obj);
		obj = _tmp25_;
		_tmp26_ = obj;
		_tmp27_ = obj_node;
		_tmp28_ = gxml_serializable_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), _tmp27_, &_inner_error_);
		_tmp29_ = _tmp28_;
		_g_object_unref0 (_tmp29_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (obj);
			_g_free0 (oid);
			_g_free0 (otype);
			_g_object_unref0 (obj_elem);
			return NULL;
		}
		result = obj;
		specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
		_g_free0 (oid);
		_g_free0 (otype);
		_g_object_unref0 (obj_elem);
		return result;
	}
	_tmp30_ = type;
	_tmp31_ = g_new0 (GParameter, 0);
	_tmp32_ = _tmp31_;
	_tmp32__length1 = 0;
	_tmp33_ = g_object_newv (_tmp30_, 0, _tmp32_);
	_tmp34_ = G_IS_INITIALLY_UNOWNED (_tmp33_) ? g_object_ref_sink (_tmp33_) : _tmp33_;
	_g_object_unref0 (obj);
	obj = _tmp34_;
	_tmp32_ = (_vala_GParameter_array_free (_tmp32_, _tmp32__length1), NULL);
	_tmp35_ = obj;
	_tmp36_ = G_OBJECT_GET_CLASS (_tmp35_);
	obj_class = _tmp36_;
	_tmp37_ = gxml_serialization_deserialize_cache;
	_tmp38_ = oid;
	_tmp39_ = g_strdup (_tmp38_);
	_tmp40_ = obj;
	_tmp41_ = _g_object_ref0 (_tmp40_);
	g_hash_table_insert (_tmp37_, _tmp39_, _tmp41_);
	_tmp42_ = obj_class;
	_tmp44_ = g_object_class_list_properties (_tmp42_, &_tmp43_);
	_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup6 (_tmp44_, _tmp43_) : ((gpointer) _tmp44_);
	_tmp45__length1 = _tmp43_;
	specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	specs = _tmp45_;
	specs_length1 = _tmp45__length1;
	_specs_size_ = specs_length1;
	{
		GXmlNodeList* _child_node_list = NULL;
		GXmlElement* _tmp46_ = NULL;
		GXmlNodeList* _tmp47_ = NULL;
		GXmlNodeList* _tmp48_ = NULL;
		gint _child_node_size = 0;
		GXmlNodeList* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		gint _child_node_index = 0;
		_tmp46_ = obj_elem;
		_tmp47_ = gxml_node_get_child_nodes ((GXmlNode*) _tmp46_);
		_tmp48_ = _tmp47_;
		_child_node_list = _tmp48_;
		_tmp49_ = _child_node_list;
		_tmp50_ = gee_collection_get_size ((GeeCollection*) _tmp49_);
		_tmp51_ = _tmp50_;
		_child_node_size = _tmp51_;
		_child_node_index = -1;
		while (TRUE) {
			gint _tmp52_ = 0;
			gint _tmp53_ = 0;
			gint _tmp54_ = 0;
			GXmlNode* child_node = NULL;
			GXmlNodeList* _tmp55_ = NULL;
			gint _tmp56_ = 0;
			GXmlNode* _tmp57_ = NULL;
			GXmlNode* _tmp58_ = NULL;
			const gchar* _tmp59_ = NULL;
			const gchar* _tmp60_ = NULL;
			_tmp52_ = _child_node_index;
			_child_node_index = _tmp52_ + 1;
			_tmp53_ = _child_node_index;
			_tmp54_ = _child_node_size;
			if (!(_tmp53_ < _tmp54_)) {
				break;
			}
			_tmp55_ = _child_node_list;
			_tmp56_ = _child_node_index;
			_tmp57_ = gxml_node_list_get (_tmp55_, _tmp56_);
			child_node = _tmp57_;
			_tmp58_ = child_node;
			_tmp59_ = gxml_node_get_node_name (_tmp58_);
			_tmp60_ = _tmp59_;
			if (g_strcmp0 (_tmp60_, "Property") == 0) {
				GXmlElement* prop_elem = NULL;
				gchar* pname = NULL;
				GValue val = {0};
				GXmlNode* _tmp61_ = NULL;
				GXmlElement* _tmp62_ = NULL;
				GXmlElement* _tmp63_ = NULL;
				gchar* _tmp64_ = NULL;
				GParamSpec* spec = NULL;
				GObjectClass* _tmp65_ = NULL;
				const gchar* _tmp66_ = NULL;
				GParamSpec* _tmp67_ = NULL;
				GParamSpec* _tmp68_ = NULL;
				GParamSpec* _tmp69_ = NULL;
				GParamSpec* _tmp77_ = NULL;
				GXmlElement* _tmp78_ = NULL;
				GValue _tmp79_ = {0};
				GObject* _tmp80_ = NULL;
				const gchar* _tmp81_ = NULL;
				GValue _tmp82_ = {0};
				_tmp61_ = child_node;
				_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GXML_TYPE_ELEMENT, GXmlElement));
				_g_object_unref0 (prop_elem);
				prop_elem = _tmp62_;
				_tmp63_ = prop_elem;
				_tmp64_ = gxml_element_get_attribute (_tmp63_, "pname");
				_g_free0 (pname);
				pname = _tmp64_;
				spec = NULL;
				_tmp65_ = obj_class;
				_tmp66_ = pname;
				_tmp67_ = g_object_class_find_property (_tmp65_, _tmp66_);
				_tmp68_ = _g_param_spec_ref0 (_tmp67_);
				_g_param_spec_unref0 (spec);
				spec = _tmp68_;
				_tmp69_ = spec;
				if (_tmp69_ == NULL) {
					const gchar* _tmp70_ = NULL;
					const gchar* _tmp71_ = NULL;
					GXmlElement* _tmp72_ = NULL;
					gchar* _tmp73_ = NULL;
					gchar* _tmp74_ = NULL;
					GError* _tmp75_ = NULL;
					GError* _tmp76_ = NULL;
					_tmp70_ = pname;
					_tmp71_ = otype;
					_tmp72_ = obj_elem;
					_tmp73_ = gxml_node_to_string ((GXmlNode*) _tmp72_, FALSE, 0);
					_tmp74_ = _tmp73_;
					_tmp75_ = g_error_new (GXML_SERIALIZATION_ERROR, GXML_SERIALIZATION_ERROR_UNKNOWN_PROPERTY, "Unknown property '%s' found, for object type '%s'-->XML: [%s]", _tmp70_, _tmp71_, _tmp74_);
					_tmp76_ = _tmp75_;
					_g_free0 (_tmp74_);
					_inner_error_ = _tmp76_;
					g_propagate_error (error, _inner_error_);
					_g_param_spec_unref0 (spec);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_free0 (pname);
					_g_object_unref0 (prop_elem);
					_g_object_unref0 (child_node);
					_g_object_unref0 (_child_node_list);
					specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
					_g_object_unref0 (obj);
					_g_free0 (oid);
					_g_free0 (otype);
					_g_object_unref0 (obj_elem);
					return NULL;
					result = NULL;
					_g_param_spec_unref0 (spec);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_free0 (pname);
					_g_object_unref0 (prop_elem);
					_g_object_unref0 (child_node);
					_g_object_unref0 (_child_node_list);
					specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
					_g_object_unref0 (obj);
					_g_free0 (oid);
					_g_free0 (otype);
					_g_object_unref0 (obj_elem);
					return result;
				}
				_tmp77_ = spec;
				_tmp78_ = prop_elem;
				gxml_serialization_deserialize_property (_tmp77_, _tmp78_, &_tmp79_, &_inner_error_);
				G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
				val = _tmp79_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_param_spec_unref0 (spec);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_free0 (pname);
					_g_object_unref0 (prop_elem);
					_g_object_unref0 (child_node);
					_g_object_unref0 (_child_node_list);
					specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
					_g_object_unref0 (obj);
					_g_free0 (oid);
					_g_free0 (otype);
					_g_object_unref0 (obj_elem);
					return NULL;
				}
				_tmp80_ = obj;
				_tmp81_ = pname;
				_tmp82_ = val;
				g_object_set_property (_tmp80_, _tmp81_, &_tmp82_);
				_g_param_spec_unref0 (spec);
				G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
				_g_free0 (pname);
				_g_object_unref0 (prop_elem);
			}
			_g_object_unref0 (child_node);
		}
		_g_object_unref0 (_child_node_list);
	}
	result = obj;
	specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	_g_free0 (oid);
	_g_free0 (otype);
	_g_object_unref0 (obj_elem);
	return result;
}


GXmlSerialization* gxml_serialization_construct (GType object_type) {
	GXmlSerialization * self = NULL;
	self = (GXmlSerialization*) g_object_new (object_type, NULL);
	return self;
}


GXmlSerialization* gxml_serialization_new (void) {
	return gxml_serialization_construct (GXML_TYPE_SERIALIZATION);
}


static void gxml_serialization_class_init (GXmlSerializationClass * klass) {
	gxml_serialization_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = gxml_serialization_finalize;
}


static void gxml_serialization_instance_init (GXmlSerialization * self) {
}


static void gxml_serialization_finalize (GObject* obj) {
	GXmlSerialization * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZATION, GXmlSerialization);
	G_OBJECT_CLASS (gxml_serialization_parent_class)->finalize (obj);
}


/**
 * Serializes and deserializes {@link GLib.Object}s to and from
 * {@link GXml.Node}.
 *
 * Serialization can automatically serialize a variety of public
 * properties.  {@link GLib.Object}s can also implement the
 * {@link GXml.Serializable} to partially or completely manage
 * serialization themselves, including non-public properties or
 * data types not automatically supported by {@link GXml.Serialization}.
 */
GType gxml_serialization_get_type (void) {
	static volatile gsize gxml_serialization_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serialization_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_serialization_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlSerialization), 0, (GInstanceInitFunc) gxml_serialization_instance_init, NULL };
		GType gxml_serialization_type_id;
		gxml_serialization_type_id = g_type_register_static (G_TYPE_OBJECT, "GXmlSerialization", &g_define_type_info, 0);
		g_once_init_leave (&gxml_serialization_type_id__volatile, gxml_serialization_type_id);
	}
	return gxml_serialization_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



