typedef	GtkWidget *(*GDoDemoFunc) (GtkWidget *do_widget);

typedef struct _Demo Demo;

struct _Demo 
{
  gchar *title;
  gchar *filename;
  GDoDemoFunc func;
  Demo *children;
};

GtkWidget *do_data_model_dir (GtkWidget *do_widget);
GtkWidget *do_form (GtkWidget *do_widget);
GtkWidget *do_form_rw (GtkWidget *do_widget);
GtkWidget *do_form_pict (GtkWidget *do_widget);
GtkWidget *do_form_data_layout (GtkWidget *do_widget);
GtkWidget *do_grid (GtkWidget *do_widget);
GtkWidget *do_grid_rw (GtkWidget *do_widget);
GtkWidget *do_grid_pict (GtkWidget *do_widget);
GtkWidget *do_grid_data_layout (GtkWidget *do_widget);
GtkWidget *do_linked_grid_form (GtkWidget *do_widget);
GtkWidget *do_linked_model_param (GtkWidget *do_widget);
GtkWidget *do_ddl_queries (GtkWidget *do_widget);
GtkWidget *do_login (GtkWidget *do_widget);
GtkWidget *do_tree (GtkWidget *do_widget);

Demo child0[] = {
  { "Directory data model", "data_model_dir.c", do_data_model_dir, NULL },
  { NULL } 
};

Demo child1[] = {
  { "Read-only form", "form.c", do_form, NULL },
  { "Read-write form", "form_rw.c", do_form_rw, NULL },
  { "Using the picture plugin", "form_pict.c", do_form_pict, NULL },
  { "Automatic data_layout", "form_data_layout.c", do_form_data_layout, NULL },
  { NULL } 
};

Demo child2[] = {
  { "Read-only grid", "grid.c", do_grid, NULL },
  { "Read-write grid", "grid_rw.c", do_grid_rw, NULL },
  { "Using the picture plugin", "grid_pict.c", do_grid_pict, NULL },
  { "Automatic data_layout", "grid_data_layout.c", do_grid_data_layout, NULL },
  { NULL } 
};

Demo child3[] = {
  { "Same data", "linked_grid_form.c", do_linked_grid_form, NULL },
  { "Data model with parameters", "linked_model_param.c", do_linked_model_param, NULL },
  { NULL } 
};

Demo child4[] = {
  { "Login widget", "login.c", do_login, NULL },
  { "GdaTree display", "tree.c", do_tree, NULL },
  { NULL } 
};

Demo gdaui_demos[] = {
  { "DDL queries", "ddl_queries.c", do_ddl_queries, NULL }, 
  { "Data models", NULL, NULL, child0 }, 
  { "Data widgets linking", NULL, NULL, child3 }, 
  { "Forms", NULL, NULL, child1 }, 
  { "Grids", NULL, NULL, child2 }, 
  { "Widgets", NULL, NULL, child4 },
  { NULL } 
};
