/* CheckDataModelIterator.c generated by valac 0.18.0, the Vala compiler
 * generated from CheckDataModelIterator.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata Unit Tests
 * Copyright (C) Daniel Espinosa Ortiz 2011 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgda/libgda.h>
#include <libgda/data/libgdadata.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define CHECK_TYPE_TESTS (check_tests_get_type ())
#define CHECK_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECK_TYPE_TESTS, CheckTests))
#define CHECK_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECK_TYPE_TESTS, CheckTestsClass))
#define CHECK_IS_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECK_TYPE_TESTS))
#define CHECK_IS_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECK_TYPE_TESTS))
#define CHECK_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECK_TYPE_TESTS, CheckTestsClass))

typedef struct _CheckTests CheckTests;
typedef struct _CheckTestsClass CheckTestsClass;
typedef struct _CheckTestsPrivate CheckTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gee_lazy_unref0(var) ((var == NULL) ? NULL : (var = (gee_lazy_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _CheckTests {
	GObject parent_instance;
	CheckTestsPrivate * priv;
};

struct _CheckTestsClass {
	GObjectClass parent_class;
};

struct _CheckTestsPrivate {
	GdaConnection* connection;
	GdaDataDbRecordCollection* itermodel;
};

struct _Block1Data {
	int _ref_count_;
	CheckTests * self;
	gchar* ts;
};


static gpointer check_tests_parent_class = NULL;

GType check_tests_get_type (void) G_GNUC_CONST;
#define CHECK_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHECK_TYPE_TESTS, CheckTestsPrivate))
enum  {
	CHECK_TESTS_DUMMY_PROPERTY
};
static CheckTests* check_tests_new (void);
static CheckTests* check_tests_construct (GType object_type);
gint check_tests_iterating (CheckTests* self, GError** error);
gint check_tests_choping (CheckTests* self);
gint check_tests_filtering (CheckTests* self);
static gboolean __lambda2_ (CheckTests* self, GdaDataDbRecord* g);
static gboolean ___lambda2__gee_predicate (gconstpointer g, gpointer self);
gint check_tests_streaming (CheckTests* self);
static GeeTraversableStream __lambda3_ (CheckTests* self, GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gchar* ______lambda4_ (Block1Data* _data1_);
static gpointer _______lambda4__gee_lazy_func (gpointer self);
static GeeTraversableStream ___lambda3__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
gint check_tests_InitIter (CheckTests* self, GError** error);
gint check_tests_main (gchar** args, int args_length1);
static void check_tests_finalize (GObject* obj);


static CheckTests* check_tests_construct (GType object_type) {
	CheckTests * self = NULL;
	GError * _inner_error_ = NULL;
	self = (CheckTests*) g_object_new (object_type, NULL);
	{
		FILE* _tmp0_;
		GdaConnection* _tmp1_ = NULL;
		GdaConnection* _tmp2_;
		FILE* _tmp3_;
		GdaConnection* _tmp4_;
		GdaConnection* _tmp5_;
		GdaConnection* _tmp6_;
		GdaConnection* _tmp7_;
		GdaConnection* _tmp8_;
		GdaConnection* _tmp9_;
		GdaConnection* _tmp10_;
		GdaConnection* _tmp11_;
		g_unlink ("datamodeliterator.db");
		_tmp0_ = stdout;
		fprintf (_tmp0_, "Creating Database...\n");
		_tmp1_ = gda_connection_open_from_string ("SQLite", "DB_DIR=.;DB_NAME=datamodeliterator", NULL, GDA_CONNECTION_OPTIONS_NONE, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_g_object_unref0 (self->priv->connection);
		self->priv->connection = _tmp2_;
		_tmp3_ = stdout;
		fprintf (_tmp3_, "Creating table 'user'...\n");
		_tmp4_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp4_, "CREATE TABLE user (id int PRIMARY KEY, name string, city string)", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp5_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp5_, "INSERT INTO user (id, name, city) VALUES (1, \"Daniel\", \"Mexico\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp6_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp6_, "INSERT INTO user (id, name, city) VALUES (2, \"Jhon\", \"USA\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp7_, "INSERT INTO user (id, name, city) VALUES (3, \"James\", \"Germany\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp8_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp8_, "INSERT INTO user (id, name, city) VALUES (4, \"Jack\", \"United Kindom" \
"\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp9_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp9_, "INSERT INTO user (id, name, city) VALUES (5, \"Elsy\", \"España\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp10_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp10_, "INSERT INTO user (id, name, city) VALUES (6, \"Mayo\", \"Mexico\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp11_ = self->priv->connection;
		gda_connection_update_meta_store (_tmp11_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stdout;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "Couln't create temporary database...\nERROR: %s\n", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static CheckTests* check_tests_new (void) {
	return check_tests_construct (CHECK_TYPE_TESTS);
}


gint check_tests_iterating (CheckTests* self, GError** error) {
	gint result = 0;
	gint fails;
	FILE* _tmp0_;
	gint i;
	FILE* _tmp1_;
	GdaDataDbRecordCollection* _tmp2_;
	GeeIterator* _tmp3_ = NULL;
	GeeIterator* iter;
	GeeIterator* _tmp4_;
	gboolean _tmp28_ = FALSE;
	gint _tmp29_;
	gboolean _tmp31_;
	FILE* _tmp41_;
	gboolean _tmp57_ = FALSE;
	gint _tmp58_;
	gboolean _tmp60_;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Iterating over all Records in DataModel using foreach...\n");
	i = 0;
	_tmp1_ = stdout;
	fprintf (_tmp1_, "Iterating using a Gee.Iterator...\n");
	i = 0;
	_tmp2_ = self->priv->itermodel;
	_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
	iter = _tmp3_;
	_tmp4_ = iter;
	if (_tmp4_ == NULL) {
		FILE* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp5_ = stdout;
		_tmp6_ = fails;
		fails = _tmp6_ + 1;
		_tmp7_ = fails;
		_tmp8_ = g_strdup_printf ("%i", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("----- FAIL ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
		_tmp13_ = _tmp12_;
		fprintf (_tmp5_, "%s", _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
	while (TRUE) {
		GeeIterator* _tmp14_;
		gboolean _tmp15_ = FALSE;
		GeeIterator* _tmp16_;
		gpointer _tmp17_ = NULL;
		GdaDataDbRecord* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		gchar* t2;
		const gchar* _tmp21_;
		_tmp14_ = iter;
		_tmp15_ = gee_iterator_next (_tmp14_);
		if (!_tmp15_) {
			break;
		}
		_tmp16_ = iter;
		_tmp17_ = gee_iterator_get (_tmp16_);
		_tmp18_ = (GdaDataDbRecord*) _tmp17_;
		_tmp19_ = gda_data_db_record_to_string (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		t2 = _tmp20_;
		_tmp21_ = t2;
		if (_tmp21_ == NULL) {
			gint _tmp22_;
			_tmp22_ = fails;
			fails = _tmp22_ + 1;
			_g_free0 (t2);
			break;
		} else {
			FILE* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gint _tmp27_;
			_tmp23_ = stdout;
			_tmp24_ = t2;
			_tmp25_ = g_strconcat (_tmp24_, "\n", NULL);
			_tmp26_ = _tmp25_;
			fprintf (_tmp23_, "%s", _tmp26_);
			_g_free0 (_tmp26_);
			_tmp27_ = i;
			i = _tmp27_ + 1;
		}
		_g_free0 (t2);
	}
	_tmp29_ = fails;
	if (_tmp29_ > 0) {
		_tmp28_ = TRUE;
	} else {
		gint _tmp30_;
		_tmp30_ = i;
		_tmp28_ = _tmp30_ != 6;
	}
	_tmp31_ = _tmp28_;
	if (_tmp31_) {
		FILE* _tmp32_;
		gint _tmp33_;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp32_ = stdout;
		_tmp33_ = fails;
		_tmp34_ = g_strdup_printf ("%i", _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat ("----- FAIL ", _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat (_tmp37_, "\n", NULL);
		_tmp39_ = _tmp38_;
		fprintf (_tmp32_, "%s", _tmp39_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
	} else {
		FILE* _tmp40_;
		_tmp40_ = stdout;
		fprintf (_tmp40_, "+++++ PASS\n");
	}
	_tmp41_ = stdout;
	fprintf (_tmp41_, "Iterating using foreach instruction...\n");
	i = 0;
	{
		GdaDataDbRecordCollection* _tmp42_;
		GeeIterator* _tmp43_ = NULL;
		GeeIterator* _r_it;
		_tmp42_ = self->priv->itermodel;
		_tmp43_ = gee_iterable_iterator ((GeeIterable*) _tmp42_);
		_r_it = _tmp43_;
		while (TRUE) {
			GeeIterator* _tmp44_;
			gboolean _tmp45_ = FALSE;
			GeeIterator* _tmp46_;
			gpointer _tmp47_ = NULL;
			GdaDataDbRecord* r;
			GdaDataDbRecord* _tmp48_;
			gchar* _tmp49_ = NULL;
			gchar* t;
			const gchar* _tmp50_;
			gint _tmp52_;
			FILE* _tmp53_;
			const gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			_tmp44_ = _r_it;
			_tmp45_ = gee_iterator_next (_tmp44_);
			if (!_tmp45_) {
				break;
			}
			_tmp46_ = _r_it;
			_tmp47_ = gee_iterator_get (_tmp46_);
			r = (GdaDataDbRecord*) _tmp47_;
			_tmp48_ = r;
			_tmp49_ = gda_data_db_record_to_string (_tmp48_);
			t = _tmp49_;
			_tmp50_ = t;
			if (_tmp50_ == NULL) {
				gint _tmp51_;
				_tmp51_ = fails;
				fails = _tmp51_ + 1;
				_g_free0 (t);
				_g_object_unref0 (r);
				break;
			}
			_tmp52_ = i;
			i = _tmp52_ + 1;
			_tmp53_ = stdout;
			_tmp54_ = t;
			_tmp55_ = g_strconcat (_tmp54_, "\n", NULL);
			_tmp56_ = _tmp55_;
			fprintf (_tmp53_, "%s", _tmp56_);
			_g_free0 (_tmp56_);
			_g_free0 (t);
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_it);
	}
	_tmp58_ = fails;
	if (_tmp58_ > 0) {
		_tmp57_ = TRUE;
	} else {
		gint _tmp59_;
		_tmp59_ = i;
		_tmp57_ = _tmp59_ != 6;
	}
	_tmp60_ = _tmp57_;
	if (_tmp60_) {
		FILE* _tmp61_;
		gint _tmp62_;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		_tmp61_ = stdout;
		_tmp62_ = fails;
		_tmp63_ = g_strdup_printf ("%i", _tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = g_strconcat ("----- FAIL ", _tmp64_, NULL);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strconcat (_tmp66_, "\n", NULL);
		_tmp68_ = _tmp67_;
		fprintf (_tmp61_, "%s", _tmp68_);
		_g_free0 (_tmp68_);
		_g_free0 (_tmp66_);
		_g_free0 (_tmp64_);
	} else {
		FILE* _tmp69_;
		_tmp69_ = stdout;
		fprintf (_tmp69_, "+++++ PASS\n");
	}
	result = fails;
	_g_object_unref0 (iter);
	return result;
}


gint check_tests_choping (CheckTests* self) {
	gint result = 0;
	gint fails;
	FILE* _tmp0_;
	FILE* _tmp1_;
	GdaDataDbRecordCollection* _tmp2_;
	GeeIterator* _tmp3_ = NULL;
	GeeIterator* iter;
	gint i;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_;
	gboolean _tmp35_;
	FILE* _tmp46_;
	GdaDataDbRecordCollection* _tmp47_;
	GeeIterator* _tmp48_ = NULL;
	GeeIterator* iter2;
	gint _tmp90_;
	FILE* _tmp102_;
	GdaDataDbRecordCollection* _tmp103_;
	GeeIterator* _tmp104_ = NULL;
	GeeIterator* iter3;
	GeeIterator* _tmp105_;
	gboolean _tmp106_ = FALSE;
	FILE* _tmp129_;
	GdaDataDbRecordCollection* _tmp130_;
	GeeIterator* _tmp131_ = NULL;
	GeeIterator* iter4;
	GeeIterator* _tmp132_;
	gboolean _tmp133_ = FALSE;
	FILE* _tmp156_;
	GdaDataDbRecordCollection* _tmp157_;
	GeeIterator* _tmp158_ = NULL;
	GeeIterator* iter5;
	GeeIterator* _tmp159_;
	gboolean _tmp160_ = FALSE;
	gint _tmp183_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Chopping...\n");
	_tmp1_ = stdout;
	fprintf (_tmp1_, " to get from the 2nd DbRecord to the 6th...\n");
	_tmp2_ = self->priv->itermodel;
	_tmp3_ = gee_traversable_chop ((GeeTraversable*) _tmp2_, 1, -1);
	iter = _tmp3_;
	i = 0;
	while (TRUE) {
		GeeIterator* _tmp4_;
		gboolean _tmp5_ = FALSE;
		FILE* _tmp6_;
		GeeIterator* _tmp7_;
		gpointer _tmp8_ = NULL;
		GdaDataDbRecord* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gint _tmp14_;
		GeeIterator* _tmp15_;
		gpointer _tmp16_ = NULL;
		GdaDataDbRecord* _tmp17_;
		GValue* _tmp18_ = NULL;
		GValue* _tmp19_;
		GValue* _tmp20_;
		gchar* name;
		gint _tmp21_;
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_next (_tmp4_);
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = stdout;
		_tmp7_ = iter;
		_tmp8_ = gee_iterator_get (_tmp7_);
		_tmp9_ = (GdaDataDbRecord*) _tmp8_;
		_tmp10_ = gda_data_db_record_to_string (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
		_tmp13_ = _tmp12_;
		fprintf (_tmp6_, "%s", _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_object_unref0 (_tmp9_);
		_tmp14_ = i;
		i = _tmp14_ + 1;
		_tmp15_ = iter;
		_tmp16_ = gee_iterator_get (_tmp15_);
		_tmp17_ = (GdaDataDbRecord*) _tmp16_;
		_tmp18_ = gda_data_db_record_get_value (_tmp17_, "name", &_inner_error_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_tmp20_ = _tmp19_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		name = g_value_get_string (_tmp20_);
		_tmp21_ = i;
		switch (_tmp21_) {
			case 1:
			{
				const gchar* _tmp22_;
				_tmp22_ = name;
				if (g_strcmp0 (_tmp22_, "Jhon") != 0) {
					gint _tmp23_;
					_tmp23_ = fails;
					fails = _tmp23_ + 1;
				}
				break;
			}
			case 2:
			{
				const gchar* _tmp24_;
				_tmp24_ = name;
				if (g_strcmp0 (_tmp24_, "James") != 0) {
					gint _tmp25_;
					_tmp25_ = fails;
					fails = _tmp25_ + 1;
				}
				break;
			}
			case 3:
			{
				const gchar* _tmp26_;
				_tmp26_ = name;
				if (g_strcmp0 (_tmp26_, "Jack") != 0) {
					gint _tmp27_;
					_tmp27_ = fails;
					fails = _tmp27_ + 1;
				}
				break;
			}
			case 4:
			{
				const gchar* _tmp28_;
				_tmp28_ = name;
				if (g_strcmp0 (_tmp28_, "Elsy") != 0) {
					gint _tmp29_;
					_tmp29_ = fails;
					fails = _tmp29_ + 1;
				}
				break;
			}
			case 5:
			{
				const gchar* _tmp30_;
				_tmp30_ = name;
				if (g_strcmp0 (_tmp30_, "Mayo") != 0) {
					gint _tmp31_;
					_tmp31_ = fails;
					fails = _tmp31_ + 1;
				}
				break;
			}
			default:
			break;
		}
		_g_free0 (name);
	}
	_tmp33_ = fails;
	if (_tmp33_ != 0) {
		_tmp32_ = TRUE;
	} else {
		gint _tmp34_;
		_tmp34_ = i;
		_tmp32_ = _tmp34_ != 5;
	}
	_tmp35_ = _tmp32_;
	if (_tmp35_) {
		FILE* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		_tmp36_ = stdout;
		_tmp37_ = fails;
		fails = _tmp37_ + 1;
		_tmp38_ = fails;
		_tmp39_ = g_strdup_printf ("%i", _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strconcat ("----- FAIL: ", _tmp40_, NULL);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strconcat (_tmp42_, "\n", NULL);
		_tmp44_ = _tmp43_;
		fprintf (_tmp36_, "%s", _tmp44_);
		_g_free0 (_tmp44_);
		_g_free0 (_tmp42_);
		_g_free0 (_tmp40_);
	} else {
		FILE* _tmp45_;
		_tmp45_ = stdout;
		fprintf (_tmp45_, "+++++ PASS\n");
	}
	_tmp46_ = stdout;
	fprintf (_tmp46_, "Choping to get the 4th to 5th DbRecords...\n");
	_tmp47_ = self->priv->itermodel;
	_tmp48_ = gee_traversable_chop ((GeeTraversable*) _tmp47_, 3, 2);
	iter2 = _tmp48_;
	i = 0;
	while (TRUE) {
		GeeIterator* _tmp49_;
		gboolean _tmp50_ = FALSE;
		gint _tmp51_;
		FILE* _tmp52_;
		GeeIterator* _tmp53_;
		gpointer _tmp54_ = NULL;
		GdaDataDbRecord* _tmp55_;
		gchar* _tmp56_ = NULL;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		GeeIterator* _tmp60_;
		gpointer _tmp61_ = NULL;
		GdaDataDbRecord* _tmp62_;
		GValue* _tmp63_ = NULL;
		GValue* _tmp64_;
		GValue* _tmp65_;
		gchar* name2;
		gint _tmp66_;
		gint _tmp78_;
		_tmp49_ = iter2;
		_tmp50_ = gee_iterator_next (_tmp49_);
		if (!_tmp50_) {
			break;
		}
		_tmp51_ = i;
		i = _tmp51_ + 1;
		_tmp52_ = stdout;
		_tmp53_ = iter2;
		_tmp54_ = gee_iterator_get (_tmp53_);
		_tmp55_ = (GdaDataDbRecord*) _tmp54_;
		_tmp56_ = gda_data_db_record_to_string (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_strconcat (_tmp57_, "\n", NULL);
		_tmp59_ = _tmp58_;
		fprintf (_tmp52_, "%s", _tmp59_);
		_g_free0 (_tmp59_);
		_g_free0 (_tmp57_);
		_g_object_unref0 (_tmp55_);
		_tmp60_ = iter2;
		_tmp61_ = gee_iterator_get (_tmp60_);
		_tmp62_ = (GdaDataDbRecord*) _tmp61_;
		_tmp63_ = gda_data_db_record_get_value (_tmp62_, "name", &_inner_error_);
		_tmp64_ = _tmp63_;
		_g_object_unref0 (_tmp62_);
		_tmp65_ = _tmp64_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (iter2);
			_g_object_unref0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		name2 = g_value_get_string (_tmp65_);
		_tmp66_ = i;
		if (_tmp66_ == 1) {
			const gchar* _tmp67_;
			_tmp67_ = name2;
			if (g_strcmp0 (_tmp67_, "Jack") != 0) {
				gint _tmp68_;
				FILE* _tmp69_;
				gint _tmp70_;
				gint _tmp71_;
				gchar* _tmp72_ = NULL;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				_tmp68_ = fails;
				fails = _tmp68_ + 1;
				_tmp69_ = stdout;
				_tmp70_ = fails;
				fails = _tmp70_ + 1;
				_tmp71_ = fails;
				_tmp72_ = g_strdup_printf ("%i", _tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = g_strconcat ("----- FAIL: ", _tmp73_, NULL);
				_tmp75_ = _tmp74_;
				_tmp76_ = g_strconcat (_tmp75_, "\n", NULL);
				_tmp77_ = _tmp76_;
				fprintf (_tmp69_, "%s", _tmp77_);
				_g_free0 (_tmp77_);
				_g_free0 (_tmp75_);
				_g_free0 (_tmp73_);
				_g_free0 (name2);
				break;
			}
		}
		_tmp78_ = i;
		if (_tmp78_ == 2) {
			const gchar* _tmp79_;
			_tmp79_ = name2;
			if (g_strcmp0 (_tmp79_, "Elsy") != 0) {
				gint _tmp80_;
				FILE* _tmp81_;
				gint _tmp82_;
				gint _tmp83_;
				gchar* _tmp84_ = NULL;
				gchar* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
				_tmp80_ = fails;
				fails = _tmp80_ + 1;
				_tmp81_ = stdout;
				_tmp82_ = fails;
				fails = _tmp82_ + 1;
				_tmp83_ = fails;
				_tmp84_ = g_strdup_printf ("%i", _tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = g_strconcat ("----- FAIL: ", _tmp85_, NULL);
				_tmp87_ = _tmp86_;
				_tmp88_ = g_strconcat (_tmp87_, "\n", NULL);
				_tmp89_ = _tmp88_;
				fprintf (_tmp81_, "%s", _tmp89_);
				_g_free0 (_tmp89_);
				_g_free0 (_tmp87_);
				_g_free0 (_tmp85_);
				_g_free0 (name2);
				break;
			}
		}
		_g_free0 (name2);
	}
	_tmp90_ = i;
	if (_tmp90_ != 2) {
		gint _tmp91_;
		FILE* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		gchar* _tmp95_ = NULL;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		gchar* _tmp100_;
		_tmp91_ = fails;
		fails = _tmp91_ + 1;
		_tmp92_ = stdout;
		_tmp93_ = fails;
		fails = _tmp93_ + 1;
		_tmp94_ = fails;
		_tmp95_ = g_strdup_printf ("%i", _tmp94_);
		_tmp96_ = _tmp95_;
		_tmp97_ = g_strconcat ("----- FAIL: ", _tmp96_, NULL);
		_tmp98_ = _tmp97_;
		_tmp99_ = g_strconcat (_tmp98_, "\n", NULL);
		_tmp100_ = _tmp99_;
		fprintf (_tmp92_, "%s", _tmp100_);
		_g_free0 (_tmp100_);
		_g_free0 (_tmp98_);
		_g_free0 (_tmp96_);
	} else {
		FILE* _tmp101_;
		_tmp101_ = stdout;
		fprintf (_tmp101_, "+++++ PASS\n");
	}
	_tmp102_ = stdout;
	fprintf (_tmp102_, "Choping offset = 7 must fail...\n");
	_tmp103_ = self->priv->itermodel;
	_tmp104_ = gee_traversable_chop ((GeeTraversable*) _tmp103_, 7, -1);
	iter3 = _tmp104_;
	_tmp105_ = iter3;
	_tmp106_ = gee_iterator_has_next (_tmp105_);
	if (_tmp106_) {
		FILE* _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		gchar* _tmp110_ = NULL;
		gchar* _tmp111_;
		gchar* _tmp112_;
		gchar* _tmp113_;
		gchar* _tmp114_;
		gchar* _tmp115_;
		_tmp107_ = stdout;
		_tmp108_ = fails;
		fails = _tmp108_ + 1;
		_tmp109_ = fails;
		_tmp110_ = g_strdup_printf ("%i", _tmp109_);
		_tmp111_ = _tmp110_;
		_tmp112_ = g_strconcat ("----- FAIL: ", _tmp111_, NULL);
		_tmp113_ = _tmp112_;
		_tmp114_ = g_strconcat (_tmp113_, "\n", NULL);
		_tmp115_ = _tmp114_;
		fprintf (_tmp107_, "%s", _tmp115_);
		_g_free0 (_tmp115_);
		_g_free0 (_tmp113_);
		_g_free0 (_tmp111_);
	} else {
		GeeIterator* _tmp116_;
		gboolean _tmp117_ = FALSE;
		gint _tmp127_;
		_tmp116_ = iter3;
		_tmp117_ = gee_iterator_next (_tmp116_);
		if (_tmp117_) {
			FILE* _tmp118_;
			gint _tmp119_;
			gint _tmp120_;
			gchar* _tmp121_ = NULL;
			gchar* _tmp122_;
			gchar* _tmp123_;
			gchar* _tmp124_;
			gchar* _tmp125_;
			gchar* _tmp126_;
			_tmp118_ = stdout;
			_tmp119_ = fails;
			fails = _tmp119_ + 1;
			_tmp120_ = fails;
			_tmp121_ = g_strdup_printf ("%i", _tmp120_);
			_tmp122_ = _tmp121_;
			_tmp123_ = g_strconcat ("----- FAIL: ", _tmp122_, NULL);
			_tmp124_ = _tmp123_;
			_tmp125_ = g_strconcat (_tmp124_, "\n", NULL);
			_tmp126_ = _tmp125_;
			fprintf (_tmp118_, "%s", _tmp126_);
			_g_free0 (_tmp126_);
			_g_free0 (_tmp124_);
			_g_free0 (_tmp122_);
		}
		_tmp127_ = fails;
		if (_tmp127_ == 0) {
			FILE* _tmp128_;
			_tmp128_ = stdout;
			fprintf (_tmp128_, "+++++ PASS\n");
		}
	}
	_tmp129_ = stdout;
	fprintf (_tmp129_, "Choping offset = 6 length = 0 must fail...\n");
	_tmp130_ = self->priv->itermodel;
	_tmp131_ = gee_traversable_chop ((GeeTraversable*) _tmp130_, 6, 0);
	iter4 = _tmp131_;
	_tmp132_ = iter4;
	_tmp133_ = gee_iterator_has_next (_tmp132_);
	if (_tmp133_) {
		FILE* _tmp134_;
		gint _tmp135_;
		gint _tmp136_;
		gchar* _tmp137_ = NULL;
		gchar* _tmp138_;
		gchar* _tmp139_;
		gchar* _tmp140_;
		gchar* _tmp141_;
		gchar* _tmp142_;
		_tmp134_ = stdout;
		_tmp135_ = fails;
		fails = _tmp135_ + 1;
		_tmp136_ = fails;
		_tmp137_ = g_strdup_printf ("%i", _tmp136_);
		_tmp138_ = _tmp137_;
		_tmp139_ = g_strconcat ("----- FAIL: ", _tmp138_, NULL);
		_tmp140_ = _tmp139_;
		_tmp141_ = g_strconcat (_tmp140_, "\n", NULL);
		_tmp142_ = _tmp141_;
		fprintf (_tmp134_, "%s", _tmp142_);
		_g_free0 (_tmp142_);
		_g_free0 (_tmp140_);
		_g_free0 (_tmp138_);
	} else {
		GeeIterator* _tmp143_;
		gboolean _tmp144_ = FALSE;
		gint _tmp154_;
		_tmp143_ = iter4;
		_tmp144_ = gee_iterator_next (_tmp143_);
		if (_tmp144_) {
			FILE* _tmp145_;
			gint _tmp146_;
			gint _tmp147_;
			gchar* _tmp148_ = NULL;
			gchar* _tmp149_;
			gchar* _tmp150_;
			gchar* _tmp151_;
			gchar* _tmp152_;
			gchar* _tmp153_;
			_tmp145_ = stdout;
			_tmp146_ = fails;
			fails = _tmp146_ + 1;
			_tmp147_ = fails;
			_tmp148_ = g_strdup_printf ("%i", _tmp147_);
			_tmp149_ = _tmp148_;
			_tmp150_ = g_strconcat ("----- FAIL: ", _tmp149_, NULL);
			_tmp151_ = _tmp150_;
			_tmp152_ = g_strconcat (_tmp151_, "\n", NULL);
			_tmp153_ = _tmp152_;
			fprintf (_tmp145_, "%s", _tmp153_);
			_g_free0 (_tmp153_);
			_g_free0 (_tmp151_);
			_g_free0 (_tmp149_);
		}
		_tmp154_ = fails;
		if (_tmp154_ == 0) {
			FILE* _tmp155_;
			_tmp155_ = stdout;
			fprintf (_tmp155_, "+++++ PASS\n");
		}
	}
	_tmp156_ = stdout;
	fprintf (_tmp156_, "Choping offset = 5 length = 1...\n");
	_tmp157_ = self->priv->itermodel;
	_tmp158_ = gee_traversable_chop ((GeeTraversable*) _tmp157_, 5, 1);
	iter5 = _tmp158_;
	_tmp159_ = iter5;
	_tmp160_ = gee_iterator_next (_tmp159_);
	if (!_tmp160_) {
		FILE* _tmp161_;
		gint _tmp162_;
		gint _tmp163_;
		gchar* _tmp164_ = NULL;
		gchar* _tmp165_;
		gchar* _tmp166_;
		gchar* _tmp167_;
		gchar* _tmp168_;
		gchar* _tmp169_;
		_tmp161_ = stdout;
		_tmp162_ = fails;
		fails = _tmp162_ + 1;
		_tmp163_ = fails;
		_tmp164_ = g_strdup_printf ("%i", _tmp163_);
		_tmp165_ = _tmp164_;
		_tmp166_ = g_strconcat ("----- FAIL: ", _tmp165_, NULL);
		_tmp167_ = _tmp166_;
		_tmp168_ = g_strconcat (_tmp167_, "\n", NULL);
		_tmp169_ = _tmp168_;
		fprintf (_tmp161_, "%s", _tmp169_);
		_g_free0 (_tmp169_);
		_g_free0 (_tmp167_);
		_g_free0 (_tmp165_);
	} else {
		GeeIterator* _tmp170_;
		gboolean _tmp171_ = FALSE;
		gint _tmp181_;
		_tmp170_ = iter5;
		_tmp171_ = gee_iterator_next (_tmp170_);
		if (_tmp171_) {
			FILE* _tmp172_;
			gint _tmp173_;
			gint _tmp174_;
			gchar* _tmp175_ = NULL;
			gchar* _tmp176_;
			gchar* _tmp177_;
			gchar* _tmp178_;
			gchar* _tmp179_;
			gchar* _tmp180_;
			_tmp172_ = stdout;
			_tmp173_ = fails;
			fails = _tmp173_ + 1;
			_tmp174_ = fails;
			_tmp175_ = g_strdup_printf ("%i", _tmp174_);
			_tmp176_ = _tmp175_;
			_tmp177_ = g_strconcat ("----- FAIL: ", _tmp176_, NULL);
			_tmp178_ = _tmp177_;
			_tmp179_ = g_strconcat (_tmp178_, "\n", NULL);
			_tmp180_ = _tmp179_;
			fprintf (_tmp172_, "%s", _tmp180_);
			_g_free0 (_tmp180_);
			_g_free0 (_tmp178_);
			_g_free0 (_tmp176_);
		}
		_tmp181_ = fails;
		if (_tmp181_ == 0) {
			FILE* _tmp182_;
			_tmp182_ = stdout;
			fprintf (_tmp182_, "+++++ PASS\n");
		}
	}
	_tmp183_ = fails;
	if (_tmp183_ == 0) {
		FILE* _tmp184_;
		_tmp184_ = stdout;
		fprintf (_tmp184_, "%s", "+++++ PASS: " "\n");
	}
	result = fails;
	_g_object_unref0 (iter5);
	_g_object_unref0 (iter4);
	_g_object_unref0 (iter3);
	_g_object_unref0 (iter2);
	_g_object_unref0 (iter);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean __lambda2_ (CheckTests* self, GdaDataDbRecord* g) {
	gboolean result = FALSE;
	gboolean ret;
	gboolean _tmp23_;
	g_return_val_if_fail (g != NULL, FALSE);
	ret = FALSE;
	{
		GdaDataDbRecord* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _fl_it;
		_tmp0_ = g;
		_tmp1_ = gda_data_db_record_get_fields (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_fl_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			GdaDataDbField* fl;
			GdaDataDbField* _tmp10_;
			GValue* _tmp11_;
			GValue* _tmp12_;
			GValue _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* t;
			FILE* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			gboolean _tmp20_ = FALSE;
			_tmp6_ = _fl_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _fl_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			fl = (GdaDataDbField*) _tmp9_;
			_tmp10_ = fl;
			_tmp11_ = gda_data_db_field_get_value (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = *_tmp12_;
			_tmp14_ = gda_value_stringify (&_tmp13_);
			t = _tmp14_;
			_tmp15_ = stdout;
			_tmp16_ = t;
			_tmp17_ = g_strconcat ("Value to check: ", _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			fprintf (_tmp15_, "%s", _tmp18_);
			_g_free0 (_tmp18_);
			_tmp19_ = t;
			_tmp20_ = string_contains (_tmp19_, "J");
			if (_tmp20_) {
				FILE* _tmp21_;
				ret = TRUE;
				_tmp21_ = stdout;
				fprintf (_tmp21_, "...SELECTED\n");
				_g_free0 (t);
				_g_object_unref0 (fl);
				break;
			} else {
				FILE* _tmp22_;
				ret = FALSE;
				_tmp22_ = stdout;
				fprintf (_tmp22_, "...REJECTED\n");
			}
			_g_free0 (t);
			_g_object_unref0 (fl);
		}
		_g_object_unref0 (_fl_it);
	}
	_tmp23_ = ret;
	if (_tmp23_) {
		FILE* _tmp24_;
		GdaDataDbRecord* _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp24_ = stdout;
		_tmp25_ = g;
		_tmp26_ = gda_data_db_record_to_string (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat ("SELECTED ROW: \n", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp29_, "\n", NULL);
		_tmp31_ = _tmp30_;
		fprintf (_tmp24_, "%s", _tmp31_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
	}
	result = ret;
	return result;
}


static gboolean ___lambda2__gee_predicate (gconstpointer g, gpointer self) {
	gboolean result;
	result = __lambda2_ (self, g);
	return result;
}


gint check_tests_filtering (CheckTests* self) {
	gint result = 0;
	gint fails;
	FILE* _tmp0_;
	GdaDataDbRecordCollection* _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* iter;
	FILE* _tmp3_;
	gint i;
	gint _tmp24_;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Filtering Records: Any field type STRING with a letter 'J" \
"'...\n");
	_tmp1_ = self->priv->itermodel;
	_tmp2_ = gee_traversable_filter ((GeeTraversable*) _tmp1_, ___lambda2__gee_predicate, g_object_ref (self), g_object_unref);
	iter = _tmp2_;
	_tmp3_ = stdout;
	fprintf (_tmp3_, "\nPrinting Filtered Values...\n");
	i = 0;
	while (TRUE) {
		GeeIterator* _tmp4_;
		gboolean _tmp5_ = FALSE;
		FILE* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GeeIterator* _tmp15_;
		gpointer _tmp16_ = NULL;
		GdaDataDbRecord* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_next (_tmp4_);
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = stdout;
		_tmp7_ = i;
		i = _tmp7_ + 1;
		_tmp8_ = i;
		_tmp9_ = g_strdup_printf ("%i", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat ("Row", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp12_, ":\n", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = iter;
		_tmp16_ = gee_iterator_get (_tmp15_);
		_tmp17_ = (GdaDataDbRecord*) _tmp16_;
		_tmp18_ = gda_data_db_record_to_string (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp14_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, "\n", NULL);
		_tmp23_ = _tmp22_;
		fprintf (_tmp6_, "%s", _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_object_unref0 (_tmp17_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
	}
	_tmp24_ = i;
	if (_tmp24_ != 3) {
		FILE* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp25_ = stdout;
		_tmp26_ = fails;
		fails = _tmp26_ + 1;
		_tmp27_ = fails;
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat ("----- FAIL", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp31_, "\n", NULL);
		_tmp33_ = _tmp32_;
		fprintf (_tmp25_, "%s", _tmp33_);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
	} else {
		FILE* _tmp34_;
		_tmp34_ = stdout;
		fprintf (_tmp34_, "+++++ PASS\n");
	}
	result = fails;
	_g_object_unref0 (iter);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CheckTests * self;
		self = _data1_->self;
		_g_free0 (_data1_->ts);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gchar* ______lambda4_ (Block1Data* _data1_) {
	CheckTests * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	self = _data1_->self;
	_tmp0_ = _data1_->ts;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gpointer _______lambda4__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ______lambda4_ (self);
	return result;
}


static GeeTraversableStream __lambda3_ (CheckTests* self, GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy) {
	GeeLazy* _vala_lazy = NULL;
	GeeTraversableStream result = 0;
	GeeTraversableStream _tmp0_;
	_tmp0_ = state;
	switch (_tmp0_) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			_gee_lazy_unref0 (_vala_lazy);
			_vala_lazy = NULL;
			result = GEE_TRAVERSABLE_STREAM_CONTINUE;
			_gee_lazy_unref0 (g);
			if (lazy) {
				*lazy = _vala_lazy;
			} else {
				_gee_lazy_unref0 (_vala_lazy);
			}
			return result;
			break;
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			GeeLazy* _tmp1_;
			gconstpointer _tmp2_;
			GdaDataDbRecord* _tmp3_;
			GdaDataDbRecord* _tmp4_;
			GdaDataDbRecord* r;
			_tmp1_ = g;
			_tmp2_ = gee_lazy_get_value (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = _g_object_ref0 ((GdaDataDbRecord*) _tmp3_);
			r = _tmp4_;
			{
				GdaDataDbRecord* _tmp5_;
				GeeCollection* _tmp6_;
				GeeCollection* _tmp7_;
				GeeCollection* _tmp8_;
				GeeIterator* _tmp9_ = NULL;
				GeeIterator* _tmp10_;
				GeeIterator* _f_it;
				_tmp5_ = r;
				_tmp6_ = gda_data_db_record_get_fields (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_;
				_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp8_);
				_f_it = _tmp10_;
				while (TRUE) {
					GeeIterator* _tmp11_;
					gboolean _tmp12_ = FALSE;
					GeeIterator* _tmp13_;
					gpointer _tmp14_ = NULL;
					GdaDataDbField* f;
					GdaDataDbField* _tmp15_;
					GValue* _tmp16_;
					GValue* _tmp17_;
					GType _tmp18_ = 0UL;
					_tmp11_ = _f_it;
					_tmp12_ = gee_iterator_next (_tmp11_);
					if (!_tmp12_) {
						break;
					}
					_tmp13_ = _f_it;
					_tmp14_ = gee_iterator_get (_tmp13_);
					f = (GdaDataDbField*) _tmp14_;
					_tmp15_ = f;
					_tmp16_ = gda_data_db_field_get_value (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = G_VALUE_TYPE (_tmp17_);
					if (_tmp18_ == G_TYPE_STRING) {
						Block1Data* _data1_;
						FILE* _tmp19_;
						GdaDataDbField* _tmp20_;
						const gchar* _tmp21_;
						const gchar* _tmp22_;
						GdaDataDbField* _tmp23_;
						GValue* _tmp24_;
						GValue* _tmp25_;
						GValue _tmp26_;
						gchar* _tmp27_ = NULL;
						gchar* _tmp28_;
						GdaDataDbField* _tmp29_;
						GValue* _tmp30_;
						GValue* _tmp31_;
						GValue _tmp32_;
						gchar* _tmp33_ = NULL;
						GeeLazy* _tmp34_;
						_data1_ = g_slice_new0 (Block1Data);
						_data1_->_ref_count_ = 1;
						_data1_->self = g_object_ref (self);
						_tmp19_ = stdout;
						_tmp20_ = f;
						_tmp21_ = gda_data_db_field_get_name (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = f;
						_tmp24_ = gda_data_db_field_get_value (_tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = *_tmp25_;
						_tmp27_ = gda_value_stringify (&_tmp26_);
						_tmp28_ = _tmp27_;
						fprintf (_tmp19_, "Field (%s) =  %s\n", _tmp22_, _tmp28_);
						_g_free0 (_tmp28_);
						_tmp29_ = f;
						_tmp30_ = gda_data_db_field_get_value (_tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = *_tmp31_;
						_tmp33_ = gda_value_stringify (&_tmp32_);
						_data1_->ts = _tmp33_;
						_tmp34_ = gee_lazy_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _______lambda4__gee_lazy_func, block1_data_ref (_data1_), block1_data_unref);
						_gee_lazy_unref0 (_vala_lazy);
						_vala_lazy = _tmp34_;
						block1_data_unref (_data1_);
						_data1_ = NULL;
					}
					_g_object_unref0 (f);
				}
				_g_object_unref0 (_f_it);
			}
			result = GEE_TRAVERSABLE_STREAM_YIELD;
			_g_object_unref0 (r);
			_gee_lazy_unref0 (g);
			if (lazy) {
				*lazy = _vala_lazy;
			} else {
				_gee_lazy_unref0 (_vala_lazy);
			}
			return result;
			_g_object_unref0 (r);
			break;
		}
		default:
		break;
	}
	result = GEE_TRAVERSABLE_STREAM_END;
	_gee_lazy_unref0 (g);
	if (lazy) {
		*lazy = _vala_lazy;
	} else {
		_gee_lazy_unref0 (_vala_lazy);
	}
	return result;
}


static GeeTraversableStream ___lambda3__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda3_ (self, state, g, lazy);
	return result;
}


gint check_tests_streaming (CheckTests* self) {
	gint result = 0;
	gint fails;
	FILE* _tmp0_;
	GdaDataDbRecordCollection* _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* iter;
	FILE* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* l;
	GeeArrayList* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GeeArrayList* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GeeArrayList* _tmp21_;
	gboolean _tmp22_ = FALSE;
	GeeArrayList* _tmp24_;
	gboolean _tmp25_ = FALSE;
	GeeArrayList* _tmp27_;
	gboolean _tmp28_ = FALSE;
	gint _tmp30_;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Streaming Values: First DbRecord's field type STRING will" \
" be YIELDED...\n");
	_tmp1_ = self->priv->itermodel;
	_tmp2_ = gee_traversable_stream ((GeeTraversable*) _tmp1_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, ___lambda3__gee_stream_func, g_object_ref (self), g_object_unref);
	iter = _tmp2_;
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Printing Streamed Values...\n");
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	l = _tmp4_;
	while (TRUE) {
		GeeIterator* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GeeIterator* _tmp7_;
		gpointer _tmp8_ = NULL;
		gchar* v;
		GeeArrayList* _tmp9_;
		const gchar* _tmp10_;
		FILE* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp5_ = iter;
		_tmp6_ = gee_iterator_next (_tmp5_);
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = iter;
		_tmp8_ = gee_iterator_get (_tmp7_);
		v = (gchar*) _tmp8_;
		_tmp9_ = l;
		_tmp10_ = v;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
		_tmp11_ = stdout;
		_tmp12_ = v;
		_tmp13_ = g_strconcat (_tmp12_, "\n", NULL);
		_tmp14_ = _tmp13_;
		fprintf (_tmp11_, "%s", _tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (v);
	}
	_tmp15_ = l;
	_tmp16_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp15_, "Daniel");
	if (!_tmp16_) {
		gint _tmp17_;
		_tmp17_ = fails;
		fails = _tmp17_ + 1;
	}
	_tmp18_ = l;
	_tmp19_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp18_, "Jhon");
	if (!_tmp19_) {
		gint _tmp20_;
		_tmp20_ = fails;
		fails = _tmp20_ + 1;
	}
	_tmp21_ = l;
	_tmp22_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp21_, "Jack");
	if (!_tmp22_) {
		gint _tmp23_;
		_tmp23_ = fails;
		fails = _tmp23_ + 1;
	}
	_tmp24_ = l;
	_tmp25_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp24_, "Elsy");
	if (!_tmp25_) {
		gint _tmp26_;
		_tmp26_ = fails;
		fails = _tmp26_ + 1;
	}
	_tmp27_ = l;
	_tmp28_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp27_, "Mayo");
	if (!_tmp28_) {
		gint _tmp29_;
		_tmp29_ = fails;
		fails = _tmp29_ + 1;
	}
	_tmp30_ = fails;
	if (_tmp30_ > 0) {
		FILE* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp31_ = stdout;
		_tmp32_ = fails;
		fails = _tmp32_ + 1;
		_tmp33_ = fails;
		_tmp34_ = g_strdup_printf ("%i", _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat ("----- FAIL", _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat (_tmp37_, "\n", NULL);
		_tmp39_ = _tmp38_;
		fprintf (_tmp31_, "%s", _tmp39_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
	} else {
		FILE* _tmp40_;
		_tmp40_ = stdout;
		fprintf (_tmp40_, "+++++ PASS\n");
	}
	result = fails;
	_g_object_unref0 (l);
	_g_object_unref0 (iter);
	return result;
}


gint check_tests_InitIter (CheckTests* self, GError** error) {
	gint result = 0;
	FILE* _tmp0_;
	gint fails;
	GdaConnection* _tmp1_;
	GdaDataModel* _tmp2_ = NULL;
	GdaDataModel* model;
	FILE* _tmp3_;
	GdaDataTable* _tmp4_;
	GdaDataTable* t;
	GdaDataTable* _tmp5_;
	GdaConnection* _tmp6_;
	GdaDataTable* _tmp7_;
	FILE* _tmp8_;
	FILE* _tmp9_;
	GdaDataTable* _tmp10_;
	GdaDataRecordCollection* _tmp11_;
	FILE* _tmp12_;
	FILE* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> INITIALIZING: DbRecordCollection/RecordCollection\n");
	fails = 0;
	_tmp1_ = self->priv->connection;
	_tmp2_ = gda_connection_execute_select_command (_tmp1_, "SELECT * FROM user ORDER BY id", &_inner_error_);
	model = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Setting up Table...");
	_tmp4_ = gda_data_table_new ();
	t = _tmp4_;
	_tmp5_ = t;
	_tmp6_ = self->priv->connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp5_, _tmp6_);
	_tmp7_ = t;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp7_, "user");
	_tmp8_ = stdout;
	fprintf (_tmp8_, "+++++ PASS\n");
	_tmp9_ = stdout;
	fprintf (_tmp9_, "Setting up DbRecordCollection...");
	_tmp10_ = t;
	_tmp11_ = gda_data_record_collection_new (model, (GdaDataDbTable*) _tmp10_);
	_g_object_unref0 (self->priv->itermodel);
	self->priv->itermodel = (GdaDataDbRecordCollection*) _tmp11_;
	_tmp12_ = stdout;
	fprintf (_tmp12_, "+++++ PASS\n");
	_tmp13_ = stdout;
	_tmp14_ = gda_data_model_dump_as_string (model);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat ("DataModel rows:\n", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	fprintf (_tmp13_, "%s", _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	result = fails;
	_g_object_unref0 (t);
	_g_object_unref0 (model);
	return result;
}


gint check_tests_main (gchar** args, int args_length1) {
	gint result = 0;
	FILE* _tmp0_;
	gint failures;
	CheckTests* _tmp1_;
	CheckTests* app;
	CheckTests* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_;
	CheckTests* _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	CheckTests* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_;
	CheckTests* _tmp14_;
	gint _tmp15_ = 0;
	gint _tmp16_;
	CheckTests* _tmp17_;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_;
	gint _tmp21_;
	GError * _inner_error_ = NULL;
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Checking Gda.DataModelIterator implementation...\n");
	failures = 0;
	_tmp1_ = check_tests_new ();
	app = _tmp1_;
	_tmp2_ = app;
	_tmp3_ = check_tests_InitIter (_tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp5_ = failures;
	failures = _tmp5_ + _tmp4_;
	_tmp6_ = app;
	_tmp7_ = check_tests_iterating (_tmp6_, &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = failures;
	failures = _tmp9_ + _tmp8_;
	_tmp10_ = failures;
	_tmp11_ = app;
	_tmp12_ = check_tests_streaming (_tmp11_);
	failures = _tmp10_ + _tmp12_;
	_tmp13_ = failures;
	_tmp14_ = app;
	_tmp15_ = check_tests_filtering (_tmp14_);
	failures = _tmp13_ + _tmp15_;
	_tmp16_ = failures;
	_tmp17_ = app;
	_tmp18_ = check_tests_choping (_tmp17_);
	failures = _tmp16_ + _tmp18_;
	_tmp20_ = failures;
	if (_tmp20_ != 0) {
		_tmp19_ = 1;
	} else {
		_tmp19_ = 0;
	}
	_tmp21_ = _tmp19_;
	result = _tmp21_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return check_tests_main (argv, argc);
}


static void check_tests_class_init (CheckTestsClass * klass) {
	check_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheckTestsPrivate));
	G_OBJECT_CLASS (klass)->finalize = check_tests_finalize;
}


static void check_tests_instance_init (CheckTests * self) {
	self->priv = CHECK_TESTS_GET_PRIVATE (self);
}


static void check_tests_finalize (GObject* obj) {
	CheckTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHECK_TYPE_TESTS, CheckTests);
	_g_object_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->itermodel);
	G_OBJECT_CLASS (check_tests_parent_class)->finalize (obj);
}


GType check_tests_get_type (void) {
	static volatile gsize check_tests_type_id__volatile = 0;
	if (g_once_init_enter (&check_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) check_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckTests), 0, (GInstanceInitFunc) check_tests_instance_init, NULL };
		GType check_tests_type_id;
		check_tests_type_id = g_type_register_static (G_TYPE_OBJECT, "CheckTests", &g_define_type_info, 0);
		g_once_init_leave (&check_tests_type_id__volatile, check_tests_type_id);
	}
	return check_tests_type_id__volatile;
}



