// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_HOLDER_H
#define _LIBGDAMM_HOLDER_H


#include <glibmm.h>

// -*- C++ -*- //

/* set.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/datahandler.h>
#include <libgdamm/value.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaHolder GdaHolder;
typedef struct _GdaHolderClass GdaHolderClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Holder_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class DataModel;

class HolderError : public Glib::Error
{
public:
  enum Code
  {
    HOLDER_STRING_CONVERSION_ERROR,
    HOLDER_VALUE_TYPE_ERROR,
    HOLDER_VALUE_NULL_ERROR
  };

  HolderError(Code error_code, const Glib::ustring& error_message);
  explicit HolderError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::HolderError::Code> : public Glib::Value_Enum<Gnome::Gda::HolderError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{
 

/** Container for a single Gda::Value.
 *
 * The GdaHolder is a container for a single Gda::Value value. It also specifies 
 * various attributes of the contained value (default value, ...)
 *
 * @ingroup DataHandlers
 */

class Holder : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Holder CppObjectType;
  typedef Holder_Class CppClassType;
  typedef GdaHolder BaseObjectType;
  typedef GdaHolderClass BaseClassType;

private:  friend class Holder_Class;
  static CppClassType holder_class_;

private:
  // noncopyable
  Holder(const Holder&);
  Holder& operator=(const Holder&);

protected:
  explicit Holder(const Glib::ConstructParams& construct_params);
  explicit Holder(GdaHolder* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Holder();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaHolder*       gobj()       { return reinterpret_cast<GdaHolder*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaHolder* gobj() const { return reinterpret_cast<GdaHolder*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaHolder* gobj_copy();

private:

protected:
  Holder(GType g_type, const Glib::ustring& id);    
public:
  
  static Glib::RefPtr<Holder> create(GType g_type, const Glib::ustring& id);

  
  /** Copy constructor.
   * 
   * @note if @a orig is set with a static value (see take_static_value()) 
   * its copy will have a fresh new allocated GValue, so that user should free it when done.
   * @return A new Gda::Holder object.
   */
  Glib::RefPtr<Holder> copy() const;
  
  
  /** Get @a holder's type
   * @return The data type.
   */
  GType get_g_type() const;
  
  /** Get the ID of @a holder. The ID can be set using @a holder's "id" property
   * @return The ID (don't modify the string).
   */
  Glib::ustring get_id() const;

  
  /** Get the value held into the holder. If @a holder is set to use its default value
   * and that default value is not of the same type as @a holder, then <tt>0</tt> is returned.
   * 
   * If @a holder is set to <tt>0</tt>, then the returned value is a Gda::TYPE_<tt>0</tt> GValue.
   * @return The value, or <tt>0</tt>.
   */
  Value get_value() const;


  /** Same functionality as get_value() except that it returns the value as a string
   * (the conversion is done using @a dh if not <tt>0</tt>, or the default data handler otherwise).
   * @param dh A Gda::DataHandler to use, or <tt>0</tt>.
   * @return The value, or <tt>0</tt>.
   */
  Glib::ustring get_value_str(const Glib::RefPtr<DataHandler>& dh) const;

  
  /** Sets the value within the holder. If @a holder is an alias for another
   * holder, then the value is also set for that other holder.
   * 
   * On success, the action of any call to force_invalid() is cancelled
   * as soon as this method is called (even if @a holder's value does not actually change)
   * 
   * If the value is not different from the one already contained within @a holder,
   * then @a holder is not changed and no signal is emitted.
   * 
   * @note the @a value argument is treated the same way if it is <tt>0</tt> or if it is a Gda::TYPE_<tt>0</tt> value
   * 
   * @note if @a holder can't accept the @a value value, then this method returns <tt>false</tt>, and @a holder will be left
   * in an invalid state.
   * 
   * @note before the change is accepted by @a holder, the "validate-change" signal will be emitted (the value
   * of which can prevent the change from happening) which can be connected to to have a greater control
   * of which values @a holder can have, or implement some business rules.
   * @param value A value to set the holder to, or <tt>0</tt>.
   * @return <tt>true</tt> if value has been set.
   */
  bool set_value_as_value(const Value& value);

  //TODO: Documentation:
  template <class ValueType>
  bool set_value(const ValueType& value);

  
  /** Same functionality as set_value() except that it uses a string representation
   * of the value to set, which will be converted into a GValue first (using default data handler if
   *  @a dh is <tt>0</tt>).
   * 
   * @note if @a value is <tt>0</tt> or is the "<tt>0</tt>" string, then @a holder's value is set to <tt>0</tt>.
   * @note if @a holder can't accept the @a value value, then this method returns <tt>false</tt>, and @a holder will be left
   * in an invalid state.
   * @param dh A Gda::DataHandler to use, or <tt>0</tt>.
   * @param value A value to set the holder to, as a string.
   * @return <tt>true</tt> if value has been set.
   */
  bool set_value_str(const Glib::RefPtr<DataHandler>& dh, const Glib::ustring& value);
  
  /** Sets the value within the holder. If @a holder is an alias for another
   * holder, then the value is also set for that other holder.
   * 
   * On success, the action of any call to force_invalid() is cancelled
   * as soon as this method is called (even if @a holder's value does not actually change).
   * 
   * If the value is not different from the one already contained within @a holder,
   * then @a holder is not changed and no signal is emitted.
   * 
   * @note if @a holder can't accept the @a value value, then this method returns <tt>false</tt>, and @a holder will be left
   * in an invalid state.
   * 
   * @note before the change is accepted by @a holder, the "validate-change" signal will be emitted (the value
   * of which can prevent the change from happening) which can be connected to to have a greater control
   * of which values @a holder can have, or implement some business rules.
   * 
   * @note if user previously set this holder with take_static_value() the GValue
   * stored internally will be forgiven and replaced by the @a value. User should then
   * take care of the 'old' static GValue.
   * @param value A value to set the holder to.
   * @return <tt>true</tt> if value has been set.
   */
  bool take_value(const Value& value);
  
  /** Sets the const value within the holder. If @a holder is an alias for another
   * holder, then the value is also set for that other holder.
   * 
   * The value will not be freed, and user should take care of it, either for its
   * freeing or for its correct value at the moment of query.
   * 
   * If the value is not different from the one already contained within @a holder,
   * then @a holder is not changed and no signal is emitted.
   * 
   * @note if @a holder can't accept the @a value value, then this method returns <tt>0</tt>, and @a holder will be left
   * in an invalid state.
   * 
   * @note before the change is accepted by @a holder, the "validate-change" signal will be emitted (the value
   * of which can prevent the change from happening) which can be connected to to have a greater control
   * of which values @a holder can have, or implement some business rules.
   * @param value A const value to set the holder to.
   * @param value_changed A boolean set with <tt>true</tt> if the value changes, <tt>false</tt> elsewhere.
   * @return <tt>0</tt> if an error occurred or if the previous GValue was <tt>0</tt> itself. It returns
   * the static GValue user set previously, so that he can free it.
   */
  Value take_static_value(const Value& value, bool& value_changed);

  void set_attribute(const Glib::ustring& attribute, const Value& value);
  
  //TODO: gda_holder_set_attribute() has stupid memory management: _WRAP_METHOD(void set_attribute(const Glib::ustring& attribute, const Value& value), gda_holder_set_attribute)

  
  /** Get the value associated to a named attribute.
   * 
   * Attributes can have any name, but Libgda proposes some default names, see this section.
   * @param attribute Attribute name as a string.
   * @return A read-only Value, or <tt>0</tt> if not attribute named @a attribute has been set for @a holder.
   */
  Value get_attribute(const Glib::ustring& attribute) const; 
  
  
  /** Get the default value held into the holder. WARNING: the default value does not need to be of 
   * the same type as the one required by @a holder.
   * @return The default value.
   */
  Value get_default_value() const;
  
  /** Sets the default value within the holder. If @a value is <tt>0</tt> then @a holder won't have a
   * default value anymore. To set a default value to <tt>0</tt>, then pass a Value created using
   * gda_value_new_null().
   * 
   * NOTE: the default value does not need to be of the same type as the one required by @a holder.
   * @param value A value to set the holder's default value, or <tt>0</tt>.
   */
  void set_default_value(const Value& value);
  
  /** Set @a holder's value to its default value.
   * @return <tt>true</tt> if @a holder has got a default value.
   */
  bool set_value_to_default();
  
  /** Tells if @a holder's current value is the default one.
   * @return <tt>true</tt> if @a holder @a holder's current value is the default one.
   */
  bool value_is_default() const;

  
  /** Forces a holder to be invalid; to set it valid again, a new value must be assigned
   * to it using set_value() or take_value().
   * 
   *  @a holder's value is set to <tt>0</tt>.
   */
  void force_invalid();
  
  /** Get the validity of @a holder (that is, of the value held by @a holder)
   * @return <tt>true</tt> if @a holder's value can safely be used.
   */
  bool is_valid() const;
  
  /** Sets if the holder can have a <tt>0</tt> value. If @a not_null is <tt>true</tt>, then that won't be allowed
   * @param not_null <tt>true</tt> if @a holder should not accept <tt>0</tt> values.
   */
  void set_not_null(bool not_null =  true);
  
  /** Get wether the holder can be <tt>0</tt> or not
   * @return <tt>true</tt> if the holder cannot be <tt>0</tt>.
   */
  bool get_not_null() const;

  
  /** If set_source_model() has been used to provide a hint that @a holder's value
   * should be among the values contained in a column of a data model, then this method
   * returns which data model, and if @a col is not <tt>0</tt>, then it is set to the restricting column
   * as well.
   * 
   * Otherwise, this method returns <tt>0</tt>, and if @a col is not <tt>0</tt>, then it is set to 0.
   * @param col A place to store the column in the model sourcing the holder, or <tt>0</tt>.
   * @return A pointer to a Gda::DataModel, or <tt>0</tt>.
   */
  Glib::RefPtr<DataModel> get_source_model(int& col);
  
  /** If set_source_model() has been used to provide a hint that @a holder's value
   * should be among the values contained in a column of a data model, then this method
   * returns which data model, and if @a col is not <tt>0</tt>, then it is set to the restricting column
   * as well.
   * 
   * Otherwise, this method returns <tt>0</tt>, and if @a col is not <tt>0</tt>, then it is set to 0.
   * @param col A place to store the column in the model sourcing the holder, or <tt>0</tt>.
   * @return A pointer to a Gda::DataModel, or <tt>0</tt>.
   */
  Glib::RefPtr<const DataModel> get_source_model(int& col) const;

  
  /** Sets an hint that @a holder's values should be restricted among the values
   * contained in the @a col column of the @a model data model. Note that this is just a hint,
   * meaning this policy is not enforced by @a holder's implementation.
   * @param model A Gda::DataModel object or <tt>0</tt>.
   * @param col The reference column in @a model.
   * @return <tt>true</tt> if no error occurred.
   */
  bool set_source_model(const Glib::RefPtr<DataModel>& model, int col);

  
  /** Sets @a holder to change when @a bind_to changes (and does not make @a bind_to change when @a holder changes).
   * For the operation to succeed, the GType of @a holder and @a bind_to must be the same, with the exception that
   * any of them can have a Gda::TYPE_<tt>0</tt> type (in this situation, the GType of the two Gda::Holder objects
   * involved is set to match the other when any of them sets its type to something different than GDA_TYPE_<tt>0</tt>).
   * 
   * If @a bind_to is <tt>0</tt>, then @a holder will not be bound anymore.
   * @param bind_to A Gda::Holder or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
  void set_bind(const Glib::RefPtr<Holder>& bind_to);
  
  /** Get the holder which makes @a holder change its value when the holder's value is changed.
   * @return The Gda::Holder or <tt>0</tt>.
   */
  Glib::RefPtr<Holder> get_bind();
  
  /** Get the holder which makes @a holder change its value when the holder's value is changed.
   * @return The Gda::Holder or <tt>0</tt>.
   */
  Glib::RefPtr<const Holder> get_bind() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Holder's description.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_description() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Holder's description.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_description() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Make value holder follow other GdaHolder's changes and the other way around.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Holder> > property_full_bind() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Make value holder follow other GdaHolder's changes and the other way around.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Holder> > property_full_bind() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Holder's GType.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<gulong> property_g_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Holder's GType.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<gulong> property_g_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Holder's ID.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Holder's ID.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Holder's name.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Holder's name.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Can the value holder be NULL?.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_not_null() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Can the value holder be NULL?.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_not_null() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Make value holder follow other GdaHolder's changes.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Holder> > property_simple_bind() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Make value holder follow other GdaHolder's changes.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Holder> > property_simple_bind() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Column number to use in coordination with the source-model property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_source_column() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Column number to use in coordination with the source-model property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_source_column() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Data model among which the holder's value should be.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<DataModel> > property_source_model() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Data model among which the holder's value should be.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DataModel> > property_source_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Prototype:
   * <tt>void on_my_%changed()</tt>
   */

  Glib::SignalProxy0< void > signal_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%source_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_source_changed();

  
  /**
   * @par Prototype:
   * <tt>Glib::Error on_my_%validate_change(const Value& value)</tt>
   */

  Glib::SignalProxy1< Glib::Error,const Value& > signal_validate_change();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%attribute_changed(const Glib::ustring& attr_name, const Value& value)</tt>
   */

  Glib::SignalProxy2< void,const Glib::ustring&,const Value& > signal_attribute_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_changed();
  virtual void on_source_changed();


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <class ValueType> inline
bool Holder::set_value(const ValueType& value)
{
  Gnome::Gda::Value gdavalue(value);
  return this->set_value_as_value(gdavalue);
}
#endif //DOXYGEN_SHOULD_SKIP_THIS

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::Holder
   */
  Glib::RefPtr<Gnome::Gda::Holder> wrap(GdaHolder* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_HOLDER_H */

