/* linkedlist.c generated by valac, the Vala compiler
 * generated from linkedlist.vala, do not modify */

/* linkedlist.vala
 *
 * Copyright (C) 2004-2005  Novell, Inc
 * Copyright (C) 2005  David Waite
 * Copyright (C) 2007-2008  Jürg Billeter
 * Copyright (C) 2009  Mark Lee
 * Copyright (C) 2009  Julien Fontanet
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Mark Lee <marklee@src.gnome.org>
 */

#include <glib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;

#define GEE_TYPE_LINKED_LIST (gee_linked_list_get_type ())
#define GEE_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedList))
#define GEE_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))
#define GEE_IS_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LINKED_LIST))
#define GEE_IS_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LINKED_LIST))
#define GEE_LINKED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))

typedef struct _GeeLinkedList GeeLinkedList;
typedef struct _GeeLinkedListClass GeeLinkedListClass;
typedef struct _GeeLinkedListPrivate GeeLinkedListPrivate;

#define GEE_LINKED_LIST_TYPE_NODE (gee_linked_list_node_get_type ())
#define GEE_LINKED_LIST_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_LINKED_LIST_TYPE_NODE, GeeLinkedListNode))
#define GEE_LINKED_LIST_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_LINKED_LIST_TYPE_NODE, GeeLinkedListNodeClass))
#define GEE_LINKED_LIST_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_LINKED_LIST_TYPE_NODE))
#define GEE_LINKED_LIST_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_LINKED_LIST_TYPE_NODE))
#define GEE_LINKED_LIST_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_LINKED_LIST_TYPE_NODE, GeeLinkedListNodeClass))

typedef struct _GeeLinkedListNode GeeLinkedListNode;
typedef struct _GeeLinkedListNodeClass GeeLinkedListNodeClass;
#define _gee_linked_list_node_unref0(var) ((var == NULL) ? NULL : (var = (gee_linked_list_node_unref (var), NULL)))

#define GEE_LINKED_LIST_TYPE_ITERATOR (gee_linked_list_iterator_get_type ())
#define GEE_LINKED_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator))
#define GEE_LINKED_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorClass))
#define GEE_LINKED_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_LINKED_LIST_TYPE_ITERATOR))
#define GEE_LINKED_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_LINKED_LIST_TYPE_ITERATOR))
#define GEE_LINKED_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorClass))

typedef struct _GeeLinkedListIterator GeeLinkedListIterator;
typedef struct _GeeLinkedListIteratorClass GeeLinkedListIteratorClass;
typedef struct _GeeLinkedListNodePrivate GeeLinkedListNodePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
typedef struct _GeeLinkedListParamSpecNode GeeLinkedListParamSpecNode;
typedef struct _GeeLinkedListIteratorPrivate GeeLinkedListIteratorPrivate;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	void (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	void (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	gpointer (*first) (GeeAbstractList* self);
	gpointer (*last) (GeeAbstractList* self);
	void (*insert_all) (GeeAbstractList* self, gint index, GeeCollection* collection);
};

struct _GeeLinkedList {
	GeeAbstractList parent_instance;
	GeeLinkedListPrivate * priv;
};

struct _GeeLinkedListClass {
	GeeAbstractListClass parent_class;
};

struct _GeeLinkedListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint _size;
	gint _stamp;
	GeeLinkedListNode* _head;
	GeeLinkedListNode* _tail;
	GEqualFunc _equal_func;
};

struct _GeeLinkedListNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeLinkedListNodePrivate * priv;
	gpointer data;
	GeeLinkedListNode* prev;
	GeeLinkedListNode* next;
};

struct _GeeLinkedListNodeClass {
	GTypeClass parent_class;
	void (*finalize) (GeeLinkedListNode *self);
};

struct _GeeLinkedListNodePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeeLinkedListParamSpecNode {
	GParamSpec parent_instance;
};

struct _GeeLinkedListIterator {
	GObject parent_instance;
	GeeLinkedListIteratorPrivate * priv;
};

struct _GeeLinkedListIteratorClass {
	GObjectClass parent_class;
};

struct _GeeLinkedListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gboolean started;
	GeeLinkedListNode* position;
	gint _stamp;
	GeeLinkedList* _list;
};


static gpointer gee_linked_list_node_parent_class = NULL;
static gpointer gee_linked_list_iterator_parent_class = NULL;
static GeeIteratorIface* gee_linked_list_iterator_gee_iterator_parent_iface = NULL;
static gpointer gee_linked_list_parent_class = NULL;

GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_collection_get_type (void);
GType gee_abstract_collection_get_type (void);
GType gee_list_get_type (void);
GType gee_abstract_list_get_type (void);
GType gee_linked_list_get_type (void);
static gpointer gee_linked_list_node_ref (gpointer instance);
static void gee_linked_list_node_unref (gpointer instance);
static GParamSpec* gee_linked_list_param_spec_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
static void gee_linked_list_value_set_node (GValue* value, gpointer v_object);
static gpointer gee_linked_list_value_get_node (const GValue* value);
static GType gee_linked_list_node_get_type (void);
#define GEE_LINKED_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_LINKED_LIST, GeeLinkedListPrivate))
enum  {
	GEE_LINKED_LIST_DUMMY_PROPERTY,
	GEE_LINKED_LIST_EQUAL_FUNC,
	GEE_LINKED_LIST_SIZE,
	GEE_LINKED_LIST_G_TYPE,
	GEE_LINKED_LIST_G_DUP_FUNC,
	GEE_LINKED_LIST_G_DESTROY_FUNC
};
GeeAbstractList* gee_abstract_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GEqualFunc gee_functions_get_equal_func_for (GType t);
static void gee_linked_list_set_equal_func (GeeLinkedList* self, GEqualFunc value);
GeeLinkedList* gee_linked_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GeeLinkedList* gee_linked_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
static GeeLinkedListIterator* gee_linked_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list);
static GeeLinkedListIterator* gee_linked_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list);
static GType gee_linked_list_iterator_get_type (void);
static GeeIterator* gee_linked_list_real_iterator (GeeAbstractCollection* base);
gint gee_abstract_list_index_of (GeeAbstractList* self, gconstpointer item);
static gboolean gee_linked_list_real_contains (GeeAbstractCollection* base, gconstpointer item);
static GeeLinkedListNode* gee_linked_list_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static GeeLinkedListNode* gee_linked_list_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static gboolean gee_linked_list_real_add (GeeAbstractCollection* base, gconstpointer item);
GEqualFunc gee_linked_list_get_equal_func (GeeLinkedList* self);
static void _gee_linked_list_remove_node (GeeLinkedList* self, GeeLinkedListNode* n);
static gboolean gee_linked_list_real_remove (GeeAbstractCollection* base, gconstpointer item);
static void gee_linked_list_real_clear (GeeAbstractCollection* base);
static GeeLinkedListNode* _gee_linked_list_get_node_at (GeeLinkedList* self, gint index);
static gpointer gee_linked_list_real_get (GeeAbstractList* base, gint index);
static void gee_linked_list_real_set (GeeAbstractList* base, gint index, gconstpointer item);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
static gint gee_linked_list_real_index_of (GeeAbstractList* base, gconstpointer item);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static void gee_linked_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item);
static void gee_linked_list_real_remove_at (GeeAbstractList* base, gint index);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
static GeeList* gee_linked_list_real_slice (GeeAbstractList* base, gint start, gint stop);
#define GEE_LINKED_LIST_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_LINKED_LIST_TYPE_NODE, GeeLinkedListNodePrivate))
enum  {
	GEE_LINKED_LIST_NODE_DUMMY_PROPERTY
};
static void gee_linked_list_node_finalize (GeeLinkedListNode* obj);
#define GEE_LINKED_LIST_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorPrivate))
enum  {
	GEE_LINKED_LIST_ITERATOR_DUMMY_PROPERTY,
	GEE_LINKED_LIST_ITERATOR_G_TYPE,
	GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC,
	GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_linked_list_iterator_real_next (GeeIterator* base);
static gpointer gee_linked_list_iterator_real_get (GeeIterator* base);
static void gee_linked_list_iterator_finalize (GObject* obj);
static void gee_linked_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_linked_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_linked_list_finalize (GObject* obj);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
static void gee_linked_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_linked_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GeeLinkedList* gee_linked_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
	GeeLinkedList * self;
	self = (GeeLinkedList*) gee_abstract_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (equal_func == NULL) {
		equal_func = gee_functions_get_equal_func_for (g_type);
	}
	gee_linked_list_set_equal_func (self, equal_func);
	return self;
}


GeeLinkedList* gee_linked_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
	return gee_linked_list_construct (GEE_TYPE_LINKED_LIST, g_type, g_dup_func, g_destroy_func, equal_func);
}


static GeeIterator* gee_linked_list_real_iterator (GeeAbstractCollection* base) {
	GeeLinkedList * self;
	GeeIterator* result;
	self = (GeeLinkedList*) base;
	result = (GeeIterator*) gee_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	return result;
}


static gboolean gee_linked_list_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeLinkedList * self;
	gboolean result;
	self = (GeeLinkedList*) base;
	result = gee_abstract_list_index_of ((GeeAbstractList*) self, item) != (-1);
	return result;
}


static gpointer _gee_linked_list_node_ref0 (gpointer self) {
	return self ? gee_linked_list_node_ref (self) : NULL;
}


static gboolean gee_linked_list_real_add (GeeAbstractCollection* base, gconstpointer item) {
	GeeLinkedList * self;
	gboolean result;
	GeeLinkedListNode* n;
	gboolean _tmp0_ = FALSE;
	self = (GeeLinkedList*) base;
	n = gee_linked_list_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, item);
	if (self->priv->_head == NULL) {
		_tmp0_ = self->priv->_tail == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeLinkedListNode* _tmp2_;
		GeeLinkedListNode* _tmp1_;
		self->priv->_head = (_tmp2_ = _gee_linked_list_node_ref0 (self->priv->_tail = (_tmp1_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->_tail), _tmp1_)), _gee_linked_list_node_unref0 (self->priv->_head), _tmp2_);
	} else {
		GeeLinkedListNode* _tmp3_;
		GeeLinkedListNode* _tmp4_;
		GeeLinkedListNode* _tmp5_;
		self->priv->_tail->next = (_tmp3_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->_tail->next), _tmp3_);
		n->prev = (_tmp4_ = _gee_linked_list_node_ref0 (self->priv->_tail), _gee_linked_list_node_unref0 (n->prev), _tmp4_);
		self->priv->_tail = (_tmp5_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->_tail), _tmp5_);
	}
	self->priv->_size++;
	result = TRUE;
	_gee_linked_list_node_unref0 (n);
	return result;
}


static gboolean gee_linked_list_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeLinkedList * self;
	gboolean result;
	self = (GeeLinkedList*) base;
	{
		GeeLinkedListNode* n;
		n = _gee_linked_list_node_ref0 (self->priv->_head);
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					GeeLinkedListNode* _tmp1_;
					n = (_tmp1_ = _gee_linked_list_node_ref0 (n->next), _gee_linked_list_node_unref0 (n), _tmp1_);
				}
				_tmp0_ = FALSE;
				if (!(n != NULL)) {
					break;
				}
				if (gee_linked_list_get_equal_func (self) (item, n->data)) {
					_gee_linked_list_remove_node (self, _gee_linked_list_node_ref0 (n));
					result = TRUE;
					_gee_linked_list_node_unref0 (n);
					return result;
				}
			}
		}
		_gee_linked_list_node_unref0 (n);
	}
	result = FALSE;
	return result;
}


static void gee_linked_list_real_clear (GeeAbstractCollection* base) {
	GeeLinkedList * self;
	GeeLinkedListNode* _tmp1_;
	GeeLinkedListNode* _tmp0_;
	self = (GeeLinkedList*) base;
	self->priv->_stamp = self->priv->_stamp + 1;
	self->priv->_head = (_tmp1_ = _gee_linked_list_node_ref0 (self->priv->_tail = (_tmp0_ = NULL, _gee_linked_list_node_unref0 (self->priv->_tail), _tmp0_)), _gee_linked_list_node_unref0 (self->priv->_head), _tmp1_);
	self->priv->_size = 0;
}


static gpointer gee_linked_list_real_get (GeeAbstractList* base, gint index) {
	GeeLinkedList * self;
	gpointer result;
	GeeLinkedListNode* n;
	self = (GeeLinkedList*) base;
	g_assert (index >= 0);
	g_assert (index < self->priv->_size);
	n = _gee_linked_list_get_node_at (self, index);
	if (n == NULL) {
		result = NULL;
		return result;
	} else {
		gconstpointer _tmp0_;
		result = (_tmp0_ = n->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
		return result;
	}
}


static void gee_linked_list_real_set (GeeAbstractList* base, gint index, gconstpointer item) {
	GeeLinkedList * self;
	GeeLinkedListNode* n;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (GeeLinkedList*) base;
	g_assert (index >= 0);
	g_assert (index < self->priv->_size);
	n = _gee_linked_list_get_node_at (self, index);
	g_return_if_fail (n != NULL);
	n->data = (_tmp1_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), ((n->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (n->data = (self->priv->g_destroy_func (n->data), NULL)), _tmp1_);
}


static gint gee_linked_list_real_index_of (GeeAbstractList* base, gconstpointer item) {
	GeeLinkedList * self;
	gint result;
	gint _result_;
	gint idx;
	self = (GeeLinkedList*) base;
	_result_ = -1;
	idx = 0;
	{
		GeeIterator* _node_item_it;
		_node_item_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
		while (TRUE) {
			gpointer node_item;
			if (!gee_iterator_next (_node_item_it)) {
				break;
			}
			node_item = gee_iterator_get (_node_item_it);
			if (gee_linked_list_get_equal_func (self) (item, node_item)) {
				_result_ = idx;
				((node_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node_item = (self->priv->g_destroy_func (node_item), NULL));
				break;
			} else {
				idx++;
			}
			((node_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node_item = (self->priv->g_destroy_func (node_item), NULL));
		}
		_g_object_unref0 (_node_item_it);
	}
	result = _result_;
	return result;
}


static void gee_linked_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item) {
	GeeLinkedList * self;
	self = (GeeLinkedList*) base;
	g_assert (index >= 0);
	g_assert (index <= self->priv->_size);
	if (index == self->priv->_size) {
		gee_abstract_collection_add ((GeeAbstractCollection*) self, item);
	} else {
		GeeLinkedListNode* n;
		n = gee_linked_list_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, item);
		if (index == 0) {
			GeeLinkedListNode* _tmp0_;
			GeeLinkedListNode* _tmp1_;
			GeeLinkedListNode* _tmp3_;
			GeeLinkedListNode* _tmp2_;
			n->next = (_tmp0_ = _gee_linked_list_node_ref0 (self->priv->_head), _gee_linked_list_node_unref0 (n->next), _tmp0_);
			self->priv->_head->prev = (_tmp1_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->_head->prev), _tmp1_);
			self->priv->_head = (_tmp3_ = (_tmp2_ = n, n = NULL, _tmp2_), _gee_linked_list_node_unref0 (self->priv->_head), _tmp3_);
		} else {
			GeeLinkedListNode* prev;
			GeeLinkedListNode* _tmp6_;
			GeeLinkedListNode* _tmp7_;
			GeeLinkedListNode* _tmp8_;
			GeeLinkedListNode* _tmp9_;
			prev = _gee_linked_list_node_ref0 (self->priv->_head);
			{
				gint i;
				i = 0;
				{
					gboolean _tmp4_;
					_tmp4_ = TRUE;
					while (TRUE) {
						GeeLinkedListNode* _tmp5_;
						if (!_tmp4_) {
							i++;
						}
						_tmp4_ = FALSE;
						if (!(i < (index - 1))) {
							break;
						}
						prev = (_tmp5_ = _gee_linked_list_node_ref0 (prev->next), _gee_linked_list_node_unref0 (prev), _tmp5_);
					}
				}
			}
			n->prev = (_tmp6_ = _gee_linked_list_node_ref0 (prev), _gee_linked_list_node_unref0 (n->prev), _tmp6_);
			n->next = (_tmp7_ = _gee_linked_list_node_ref0 (prev->next), _gee_linked_list_node_unref0 (n->next), _tmp7_);
			n->next->prev = (_tmp8_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (n->next->prev), _tmp8_);
			prev->next = (_tmp9_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (prev->next), _tmp9_);
			_gee_linked_list_node_unref0 (prev);
		}
		self->priv->_size++;
		_gee_linked_list_node_unref0 (n);
	}
}


static void gee_linked_list_real_remove_at (GeeAbstractList* base, gint index) {
	GeeLinkedList * self;
	GeeLinkedListNode* n;
	self = (GeeLinkedList*) base;
	g_assert (index >= 0);
	g_assert (index < self->priv->_size);
	n = _gee_linked_list_get_node_at (self, index);
	g_return_if_fail (n != NULL);
	_gee_linked_list_remove_node (self, _gee_linked_list_node_ref0 (n));
}


static GeeList* gee_linked_list_real_slice (GeeAbstractList* base, gint start, gint stop) {
	GeeLinkedList * self;
	GeeList* result;
	GeeList* slice;
	GeeLinkedListNode* n;
	self = (GeeLinkedList*) base;
	g_return_val_if_fail (start <= stop, NULL);
	g_return_val_if_fail (start >= 0, NULL);
	g_return_val_if_fail (stop <= self->priv->_size, NULL);
	slice = (GeeList*) gee_linked_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, gee_linked_list_get_equal_func (self));
	n = _gee_linked_list_node_ref0 (_gee_linked_list_get_node_at (self, start));
	{
		gint i;
		i = start;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeLinkedListNode* _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < stop)) {
					break;
				}
				gee_collection_add ((GeeCollection*) slice, n->data);
				n = (_tmp1_ = _gee_linked_list_node_ref0 (n->next), _gee_linked_list_node_unref0 (n), _tmp1_);
			}
		}
	}
	result = slice;
	_gee_linked_list_node_unref0 (n);
	return result;
}


static GeeLinkedListNode* _gee_linked_list_get_node_at (GeeLinkedList* self, gint index) {
	GeeLinkedListNode* result;
	GeeLinkedListNode* n;
	g_return_val_if_fail (self != NULL, NULL);
	n = NULL;
	;
	if (index == 0) {
		n = self->priv->_head;
	} else {
		if (index == (self->priv->_size - 1)) {
			n = self->priv->_tail;
		} else {
			if (index <= (self->priv->_size / 2)) {
				n = self->priv->_head;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp0_;
						_tmp0_ = TRUE;
						while (TRUE) {
							if (!_tmp0_) {
								i++;
							}
							_tmp0_ = FALSE;
							if (!(index != i)) {
								break;
							}
							n = n->next;
						}
					}
				}
			} else {
				n = self->priv->_tail;
				{
					gint i;
					i = self->priv->_size - 1;
					{
						gboolean _tmp1_;
						_tmp1_ = TRUE;
						while (TRUE) {
							if (!_tmp1_) {
								i--;
							}
							_tmp1_ = FALSE;
							if (!(index != i)) {
								break;
							}
							n = n->prev;
						}
					}
				}
			}
		}
	}
	result = n;
	return result;
}


static void _gee_linked_list_remove_node (GeeLinkedList* self, GeeLinkedListNode* n) {
	GeeLinkedListNode* _tmp4_;
	GeeLinkedListNode* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	if (n == self->priv->_head) {
		GeeLinkedListNode* _tmp0_;
		self->priv->_head = (_tmp0_ = _gee_linked_list_node_ref0 (n->next), _gee_linked_list_node_unref0 (self->priv->_head), _tmp0_);
	}
	if (n == self->priv->_tail) {
		GeeLinkedListNode* _tmp1_;
		self->priv->_tail = (_tmp1_ = _gee_linked_list_node_ref0 (n->prev), _gee_linked_list_node_unref0 (self->priv->_tail), _tmp1_);
	}
	if (n->prev != NULL) {
		GeeLinkedListNode* _tmp2_;
		n->prev->next = (_tmp2_ = _gee_linked_list_node_ref0 (n->next), _gee_linked_list_node_unref0 (n->prev->next), _tmp2_);
	}
	if (n->next != NULL) {
		GeeLinkedListNode* _tmp3_;
		n->next->prev = (_tmp3_ = _gee_linked_list_node_ref0 (n->prev), _gee_linked_list_node_unref0 (n->next->prev), _tmp3_);
	}
	n->prev = (_tmp4_ = NULL, _gee_linked_list_node_unref0 (n->prev), _tmp4_);
	n->next = (_tmp5_ = NULL, _gee_linked_list_node_unref0 (n->next), _tmp5_);
	self->priv->_stamp = self->priv->_stamp + 1;
	self->priv->_size--;
	_gee_linked_list_node_unref0 (n);
}


GEqualFunc gee_linked_list_get_equal_func (GeeLinkedList* self) {
	GEqualFunc result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_equal_func;
	return result;
}


static void gee_linked_list_set_equal_func (GeeLinkedList* self, GEqualFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_equal_func = value;
	g_object_notify ((GObject *) self, "equal-func");
}


static gint gee_linked_list_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = self->priv->_size;
	return result;
}


static GeeLinkedListNode* gee_linked_list_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
	GeeLinkedListNode* self;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (GeeLinkedListNode*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->data = (_tmp1_ = (_tmp0_ = data, ((_tmp0_ == NULL) || (g_dup_func == NULL)) ? ((gpointer) _tmp0_) : g_dup_func ((gpointer) _tmp0_)), _g_destroy_func0 (self->data), _tmp1_);
	return self;
}


static GeeLinkedListNode* gee_linked_list_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
	return gee_linked_list_node_construct (GEE_LINKED_LIST_TYPE_NODE, g_type, g_dup_func, g_destroy_func, data);
}


static void gee_linked_list_value_node_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gee_linked_list_value_node_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gee_linked_list_node_unref (value->data[0].v_pointer);
	}
}


static void gee_linked_list_value_node_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_linked_list_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gee_linked_list_value_node_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gee_linked_list_value_node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GeeLinkedListNode* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_linked_list_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gee_linked_list_value_node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GeeLinkedListNode** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_linked_list_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* gee_linked_list_param_spec_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GeeLinkedListParamSpecNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_LINKED_LIST_TYPE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer gee_linked_list_value_get_node (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_LINKED_LIST_TYPE_NODE), NULL);
	return value->data[0].v_pointer;
}


static void gee_linked_list_value_set_node (GValue* value, gpointer v_object) {
	GeeLinkedListNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_LINKED_LIST_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_LINKED_LIST_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_linked_list_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_linked_list_node_unref (old);
	}
}


static void gee_linked_list_node_class_init (GeeLinkedListNodeClass * klass) {
	gee_linked_list_node_parent_class = g_type_class_peek_parent (klass);
	GEE_LINKED_LIST_NODE_CLASS (klass)->finalize = gee_linked_list_node_finalize;
	g_type_class_add_private (klass, sizeof (GeeLinkedListNodePrivate));
}


static void gee_linked_list_node_instance_init (GeeLinkedListNode * self) {
	self->priv = GEE_LINKED_LIST_NODE_GET_PRIVATE (self);
	self->prev = NULL;
	self->next = NULL;
	self->ref_count = 1;
}


static void gee_linked_list_node_finalize (GeeLinkedListNode* obj) {
	GeeLinkedListNode * self;
	self = GEE_LINKED_LIST_NODE (obj);
	((self->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->data = (self->priv->g_destroy_func (self->data), NULL));
	_gee_linked_list_node_unref0 (self->prev);
	_gee_linked_list_node_unref0 (self->next);
}


static GType gee_linked_list_node_get_type (void) {
	static GType gee_linked_list_node_type_id = 0;
	if (gee_linked_list_node_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { gee_linked_list_value_node_init, gee_linked_list_value_node_free_value, gee_linked_list_value_node_copy_value, gee_linked_list_value_node_peek_pointer, "p", gee_linked_list_value_node_collect_value, "p", gee_linked_list_value_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedListNode), 0, (GInstanceInitFunc) gee_linked_list_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		gee_linked_list_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeeLinkedListNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return gee_linked_list_node_type_id;
}


static gpointer gee_linked_list_node_ref (gpointer instance) {
	GeeLinkedListNode* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void gee_linked_list_node_unref (gpointer instance) {
	GeeLinkedListNode* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_LINKED_LIST_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeLinkedListIterator* gee_linked_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list) {
	GeeLinkedListIterator * self;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (list != NULL, NULL);
	self = (GeeLinkedListIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->_list = (_tmp0_ = _g_object_ref0 (list), _g_object_unref0 (self->priv->_list), _tmp0_);
	self->priv->position = list->priv->_head;
	self->priv->_stamp = list->priv->_stamp;
	return self;
}


static GeeLinkedListIterator* gee_linked_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list) {
	return gee_linked_list_iterator_construct (GEE_LINKED_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, list);
}


static gboolean gee_linked_list_iterator_real_next (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	if (!self->priv->started) {
		self->priv->started = TRUE;
		result = self->priv->position != NULL;
		return result;
	} else {
		if (self->priv->position->next == NULL) {
			result = FALSE;
			return result;
		} else {
			self->priv->position = self->priv->position->next;
			result = TRUE;
			return result;
		}
	}
}


static gpointer gee_linked_list_iterator_real_get (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gpointer result;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	if (self->priv->position == NULL) {
		result = NULL;
		return result;
	} else {
		gconstpointer _tmp0_;
		result = (_tmp0_ = self->priv->position->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
		return result;
	}
}


static void gee_linked_list_iterator_class_init (GeeLinkedListIteratorClass * klass) {
	gee_linked_list_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeLinkedListIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_linked_list_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_linked_list_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_linked_list_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_linked_list_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_linked_list_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_linked_list_iterator_real_next;
	iface->get = gee_linked_list_iterator_real_get;
}


static void gee_linked_list_iterator_instance_init (GeeLinkedListIterator * self) {
	self->priv = GEE_LINKED_LIST_ITERATOR_GET_PRIVATE (self);
	self->priv->started = FALSE;
}


static void gee_linked_list_iterator_finalize (GObject* obj) {
	GeeLinkedListIterator * self;
	self = GEE_LINKED_LIST_ITERATOR (obj);
	_g_object_unref0 (self->priv->_list);
	G_OBJECT_CLASS (gee_linked_list_iterator_parent_class)->finalize (obj);
}


static GType gee_linked_list_iterator_get_type (void) {
	static GType gee_linked_list_iterator_type_id = 0;
	if (gee_linked_list_iterator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedListIterator), 0, (GInstanceInitFunc) gee_linked_list_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_linked_list_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeLinkedListIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	}
	return gee_linked_list_iterator_type_id;
}


static void gee_linked_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeLinkedListIterator * self;
	self = GEE_LINKED_LIST_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_linked_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeLinkedListIterator * self;
	self = GEE_LINKED_LIST_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_LINKED_LIST_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_linked_list_class_init (GeeLinkedListClass * klass) {
	gee_linked_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeLinkedListPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_linked_list_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_linked_list_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_linked_list_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_linked_list_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_linked_list_real_clear;
	GEE_ABSTRACT_LIST_CLASS (klass)->get = gee_linked_list_real_get;
	GEE_ABSTRACT_LIST_CLASS (klass)->set = gee_linked_list_real_set;
	GEE_ABSTRACT_LIST_CLASS (klass)->index_of = gee_linked_list_real_index_of;
	GEE_ABSTRACT_LIST_CLASS (klass)->insert = gee_linked_list_real_insert;
	GEE_ABSTRACT_LIST_CLASS (klass)->remove_at = gee_linked_list_real_remove_at;
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = gee_linked_list_real_slice;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_linked_list_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = gee_linked_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_linked_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_linked_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_EQUAL_FUNC, g_param_spec_pointer ("equal-func", "equal-func", "equal-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_SIZE, "size");
}


static void gee_linked_list_instance_init (GeeLinkedList * self) {
	self->priv = GEE_LINKED_LIST_GET_PRIVATE (self);
	self->priv->_size = 0;
	self->priv->_stamp = 0;
	self->priv->_head = NULL;
	self->priv->_tail = NULL;
}


static void gee_linked_list_finalize (GObject* obj) {
	GeeLinkedList * self;
	self = GEE_LINKED_LIST (obj);
	_gee_linked_list_node_unref0 (self->priv->_head);
	_gee_linked_list_node_unref0 (self->priv->_tail);
	G_OBJECT_CLASS (gee_linked_list_parent_class)->finalize (obj);
}


GType gee_linked_list_get_type (void) {
	static GType gee_linked_list_type_id = 0;
	if (gee_linked_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedList), 0, (GInstanceInitFunc) gee_linked_list_instance_init, NULL };
		gee_linked_list_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_LIST, "GeeLinkedList", &g_define_type_info, 0);
	}
	return gee_linked_list_type_id;
}


static void gee_linked_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeLinkedList * self;
	self = GEE_LINKED_LIST (object);
	switch (property_id) {
		case GEE_LINKED_LIST_EQUAL_FUNC:
		g_value_set_pointer (value, gee_linked_list_get_equal_func (self));
		break;
		case GEE_LINKED_LIST_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_linked_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeLinkedList * self;
	self = GEE_LINKED_LIST (object);
	switch (property_id) {
		case GEE_LINKED_LIST_EQUAL_FUNC:
		gee_linked_list_set_equal_func (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_LINKED_LIST_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_LINKED_LIST_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_LINKED_LIST_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}




