/* treeset.c generated by valac 0.12.0, the Vala compiler
 * generated from treeset.vala, do not modify */

/* treeset.vala
 *
 * Copyright (C) 2009  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_TYPE_ABSTRACT_SET (gee_abstract_set_get_type ())
#define GEE_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSet))
#define GEE_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))
#define GEE_IS_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_SET))
#define GEE_IS_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_SET))
#define GEE_ABSTRACT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))

typedef struct _GeeAbstractSet GeeAbstractSet;
typedef struct _GeeAbstractSetClass GeeAbstractSetClass;
typedef struct _GeeAbstractSetPrivate GeeAbstractSetPrivate;

#define GEE_TYPE_SORTED_SET (gee_sorted_set_get_type ())
#define GEE_SORTED_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SORTED_SET, GeeSortedSet))
#define GEE_IS_SORTED_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SORTED_SET))
#define GEE_SORTED_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SORTED_SET, GeeSortedSetIface))

typedef struct _GeeSortedSet GeeSortedSet;
typedef struct _GeeSortedSetIface GeeSortedSetIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_TREE_SET (gee_tree_set_get_type ())
#define GEE_TREE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TREE_SET, GeeTreeSet))
#define GEE_TREE_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TREE_SET, GeeTreeSetClass))
#define GEE_IS_TREE_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TREE_SET))
#define GEE_IS_TREE_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TREE_SET))
#define GEE_TREE_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TREE_SET, GeeTreeSetClass))

typedef struct _GeeTreeSet GeeTreeSet;
typedef struct _GeeTreeSetClass GeeTreeSetClass;
typedef struct _GeeTreeSetPrivate GeeTreeSetPrivate;
typedef struct _GeeTreeSetNode GeeTreeSetNode;

#define GEE_TREE_SET_TYPE_RANGE_TYPE (gee_tree_set_range_type_get_type ())
#define _gee_tree_set_node_free0(var) ((var == NULL) ? NULL : (var = (gee_tree_set_node_free (var), NULL)))

#define GEE_TREE_SET_NODE_TYPE_COLOR (gee_tree_set_node_color_get_type ())

#define GEE_TREE_SET_TYPE_ITERATOR (gee_tree_set_iterator_get_type ())
#define GEE_TREE_SET_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIterator))
#define GEE_TREE_SET_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIteratorClass))
#define GEE_TREE_SET_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TREE_SET_TYPE_ITERATOR))
#define GEE_TREE_SET_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TREE_SET_TYPE_ITERATOR))
#define GEE_TREE_SET_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIteratorClass))

typedef struct _GeeTreeSetIterator GeeTreeSetIterator;
typedef struct _GeeTreeSetIteratorClass GeeTreeSetIteratorClass;

#define GEE_TREE_SET_TYPE_SUB_SET (gee_tree_set_sub_set_get_type ())
#define GEE_TREE_SET_SUB_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TREE_SET_TYPE_SUB_SET, GeeTreeSetSubSet))
#define GEE_TREE_SET_SUB_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TREE_SET_TYPE_SUB_SET, GeeTreeSetSubSetClass))
#define GEE_TREE_SET_IS_SUB_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TREE_SET_TYPE_SUB_SET))
#define GEE_TREE_SET_IS_SUB_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TREE_SET_TYPE_SUB_SET))
#define GEE_TREE_SET_SUB_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TREE_SET_TYPE_SUB_SET, GeeTreeSetSubSetClass))

typedef struct _GeeTreeSetSubSet GeeTreeSetSubSet;
typedef struct _GeeTreeSetSubSetClass GeeTreeSetSubSetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GeeTreeSetIteratorPrivate GeeTreeSetIteratorPrivate;

#define GEE_TREE_SET_TYPE_RANGE (gee_tree_set_range_get_type ())
#define GEE_TREE_SET_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TREE_SET_TYPE_RANGE, GeeTreeSetRange))
#define GEE_TREE_SET_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TREE_SET_TYPE_RANGE, GeeTreeSetRangeClass))
#define GEE_TREE_SET_IS_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TREE_SET_TYPE_RANGE))
#define GEE_TREE_SET_IS_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TREE_SET_TYPE_RANGE))
#define GEE_TREE_SET_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TREE_SET_TYPE_RANGE, GeeTreeSetRangeClass))

typedef struct _GeeTreeSetRange GeeTreeSetRange;
typedef struct _GeeTreeSetRangeClass GeeTreeSetRangeClass;
typedef struct _GeeTreeSetRangePrivate GeeTreeSetRangePrivate;
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
typedef struct _GeeTreeSetParamSpecRange GeeTreeSetParamSpecRange;
typedef struct _GeeTreeSetSubSetPrivate GeeTreeSetSubSetPrivate;
#define _gee_tree_set_range_unref0(var) ((var == NULL) ? NULL : (var = (gee_tree_set_range_unref (var), NULL)))

#define GEE_TREE_SET_TYPE_SUB_ITERATOR (gee_tree_set_sub_iterator_get_type ())
#define GEE_TREE_SET_SUB_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TREE_SET_TYPE_SUB_ITERATOR, GeeTreeSetSubIterator))
#define GEE_TREE_SET_SUB_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TREE_SET_TYPE_SUB_ITERATOR, GeeTreeSetSubIteratorClass))
#define GEE_TREE_SET_IS_SUB_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TREE_SET_TYPE_SUB_ITERATOR))
#define GEE_TREE_SET_IS_SUB_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TREE_SET_TYPE_SUB_ITERATOR))
#define GEE_TREE_SET_SUB_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TREE_SET_TYPE_SUB_ITERATOR, GeeTreeSetSubIteratorClass))

typedef struct _GeeTreeSetSubIterator GeeTreeSetSubIterator;
typedef struct _GeeTreeSetSubIteratorClass GeeTreeSetSubIteratorClass;
typedef struct _GeeTreeSetSubIteratorPrivate GeeTreeSetSubIteratorPrivate;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_read_only_view) (GeeSet* self);
};

struct _GeeAbstractSet {
	GeeAbstractCollection parent_instance;
	GeeAbstractSetPrivate * priv;
};

struct _GeeAbstractSetClass {
	GeeAbstractCollectionClass parent_class;
	GeeSet* (*get_read_only_view) (GeeAbstractSet* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeSortedSetIface {
	GTypeInterface parent_iface;
	gpointer (*first) (GeeSortedSet* self);
	gpointer (*last) (GeeSortedSet* self);
	GeeBidirIterator* (*bidir_iterator) (GeeSortedSet* self);
	GeeBidirIterator* (*iterator_at) (GeeSortedSet* self, gconstpointer element);
	gpointer (*lower) (GeeSortedSet* self, gconstpointer element);
	gpointer (*higher) (GeeSortedSet* self, gconstpointer element);
	gpointer (*floor) (GeeSortedSet* self, gconstpointer element);
	gpointer (*ceil) (GeeSortedSet* self, gconstpointer element);
	GeeSortedSet* (*head_set) (GeeSortedSet* self, gconstpointer before);
	GeeSortedSet* (*tail_set) (GeeSortedSet* self, gconstpointer after);
	GeeSortedSet* (*sub_set) (GeeSortedSet* self, gconstpointer from, gconstpointer to);
};

struct _GeeTreeSet {
	GeeAbstractSet parent_instance;
	GeeTreeSetPrivate * priv;
};

struct _GeeTreeSetClass {
	GeeAbstractSetClass parent_class;
};

struct _GeeTreeSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GCompareFunc _compare_func;
	gint _size;
	GeeTreeSetNode* root;
	GeeTreeSetNode* _first;
	GeeTreeSetNode* _last;
	gint stamp;
};

typedef enum  {
	GEE_TREE_SET_RANGE_TYPE_HEAD,
	GEE_TREE_SET_RANGE_TYPE_TAIL,
	GEE_TREE_SET_RANGE_TYPE_EMPTY,
	GEE_TREE_SET_RANGE_TYPE_BOUNDED
} GeeTreeSetRangeType;

typedef enum  {
	GEE_TREE_SET_NODE_COLOR_RED,
	GEE_TREE_SET_NODE_COLOR_BLACK
} GeeTreeSetNodeColor;

struct _GeeTreeSetNode {
	gpointer key;
	GeeTreeSetNodeColor color;
	GeeTreeSetNode* left;
	GeeTreeSetNode* right;
	GeeTreeSetNode* prev;
	GeeTreeSetNode* next;
};

struct _GeeTreeSetIterator {
	GObject parent_instance;
	GeeTreeSetIteratorPrivate * priv;
};

struct _GeeTreeSetIteratorClass {
	GObjectClass parent_class;
};

struct _GeeTreeSetIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeTreeSet* _set;
	gint stamp;
	GeeTreeSetNode* current;
	GeeTreeSetNode* _next;
	GeeTreeSetNode* _prev;
	gboolean started;
};

struct _GeeTreeSetRange {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeTreeSetRangePrivate * priv;
};

struct _GeeTreeSetRangeClass {
	GTypeClass parent_class;
	void (*finalize) (GeeTreeSetRange *self);
};

struct _GeeTreeSetRangePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeTreeSet* set;
	gpointer after;
	gpointer before;
	GeeTreeSetRangeType type;
};

struct _GeeTreeSetParamSpecRange {
	GParamSpec parent_instance;
};

struct _GeeTreeSetSubSet {
	GeeAbstractSet parent_instance;
	GeeTreeSetSubSetPrivate * priv;
};

struct _GeeTreeSetSubSetClass {
	GeeAbstractSetClass parent_class;
};

struct _GeeTreeSetSubSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeTreeSet* set;
	GeeTreeSetRange* range;
};

struct _GeeTreeSetSubIterator {
	GObject parent_instance;
	GeeTreeSetSubIteratorPrivate * priv;
};

struct _GeeTreeSetSubIteratorClass {
	GObjectClass parent_class;
};

struct _GeeTreeSetSubIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeTreeSet* set;
	GeeTreeSetRange* range;
	GeeTreeSetIterator* iterator;
};


static gpointer gee_tree_set_parent_class = NULL;
static gpointer gee_tree_set_iterator_parent_class = NULL;
static GeeIteratorIface* gee_tree_set_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* gee_tree_set_iterator_gee_bidir_iterator_parent_iface = NULL;
static gpointer gee_tree_set_range_parent_class = NULL;
static gpointer gee_tree_set_sub_set_parent_class = NULL;
static GeeSortedSetIface* gee_tree_set_sub_set_gee_sorted_set_parent_iface = NULL;
static gpointer gee_tree_set_sub_iterator_parent_class = NULL;
static GeeIteratorIface* gee_tree_set_sub_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* gee_tree_set_sub_iterator_gee_bidir_iterator_parent_iface = NULL;
static GeeSortedSetIface* gee_tree_set_gee_sorted_set_parent_iface = NULL;

GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_set_get_type (void) G_GNUC_CONST;
GType gee_abstract_set_get_type (void) G_GNUC_CONST;
GType gee_bidir_iterator_get_type (void) G_GNUC_CONST;
GType gee_sorted_set_get_type (void) G_GNUC_CONST;
GType gee_tree_set_get_type (void) G_GNUC_CONST;
static void gee_tree_set_node_free (GeeTreeSetNode* self);
#define GEE_TREE_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_TREE_SET, GeeTreeSetPrivate))
enum  {
	GEE_TREE_SET_DUMMY_PROPERTY,
	GEE_TREE_SET_G_TYPE,
	GEE_TREE_SET_G_DUP_FUNC,
	GEE_TREE_SET_G_DESTROY_FUNC,
	GEE_TREE_SET_SIZE,
	GEE_TREE_SET_COMPARE_FUNC
};
static GType gee_tree_set_range_type_get_type (void) G_GNUC_UNUSED;
GeeTreeSet* gee_tree_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func);
GeeTreeSet* gee_tree_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func);
GeeAbstractSet* gee_abstract_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GCompareFunc gee_functions_get_compare_func_for (GType t);
static void gee_tree_set_set_compare_func (GeeTreeSet* self, GCompareFunc value);
static gboolean gee_tree_set_real_contains (GeeAbstractCollection* base, gconstpointer item);
GCompareFunc gee_tree_set_get_compare_func (GeeTreeSet* self);
GType gee_tree_set_node_color_get_type (void) G_GNUC_CONST;
static inline void gee_tree_set_rotate_right (GeeTreeSet* self, GeeTreeSetNode** root);
static inline void gee_tree_set_rotate_left (GeeTreeSet* self, GeeTreeSetNode** root);
static inline gboolean gee_tree_set_is_red (GeeTreeSet* self, GeeTreeSetNode* n);
static inline gboolean gee_tree_set_is_black (GeeTreeSet* self, GeeTreeSetNode* n);
static inline void gee_tree_set_fix_up (GeeTreeSet* self, GeeTreeSetNode** node);
static void gee_tree_set_node_flip (GeeTreeSetNode* self);
static gboolean gee_tree_set_add_to_node (GeeTreeSet* self, GeeTreeSetNode** node, gpointer item, GeeTreeSetNode* prev, GeeTreeSetNode* next);
static GeeTreeSetNode* gee_tree_set_node_new (gpointer node, GeeTreeSetNode* prev, GeeTreeSetNode* next);
static GeeTreeSetNode* gee_tree_set_node_new (gpointer node, GeeTreeSetNode* prev, GeeTreeSetNode* next);
static gboolean gee_tree_set_real_add (GeeAbstractCollection* base, gconstpointer item);
static inline void gee_tree_set_move_red_left (GeeTreeSet* self, GeeTreeSetNode** root);
static inline void gee_tree_set_move_red_right (GeeTreeSet* self, GeeTreeSetNode** root);
static inline void gee_tree_set_fix_removal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key);
static void gee_tree_set_remove_minimal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key);
static gboolean gee_tree_set_remove_from_node (GeeTreeSet* self, GeeTreeSetNode** node, gconstpointer item, GeeTreeSetNode** prev, GeeTreeSetNode** next);
static gboolean gee_tree_set_real_remove (GeeAbstractCollection* base, gconstpointer item);
static inline void gee_tree_set_clear_subtree (GeeTreeSet* self, GeeTreeSetNode* node);
static void gee_tree_set_real_clear (GeeAbstractCollection* base);
static GeeIterator* gee_tree_set_real_iterator (GeeAbstractCollection* base);
static GeeTreeSetIterator* gee_tree_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set);
static GeeTreeSetIterator* gee_tree_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set);
static GType gee_tree_set_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeBidirIterator* gee_tree_set_real_bidir_iterator (GeeSortedSet* base);
static inline gpointer gee_tree_set_lift_null_get (GeeTreeSet* self, GeeTreeSetNode* node);
static gpointer gee_tree_set_real_first (GeeSortedSet* base);
static gpointer gee_tree_set_real_last (GeeSortedSet* base);
static GeeSortedSet* gee_tree_set_real_head_set (GeeSortedSet* base, gconstpointer before);
static GeeTreeSetSubSet* gee_tree_set_sub_set_new_head (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before);
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_head (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before);
static GType gee_tree_set_sub_set_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeSortedSet* gee_tree_set_real_tail_set (GeeSortedSet* base, gconstpointer after);
static GeeTreeSetSubSet* gee_tree_set_sub_set_new_tail (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after);
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_tail (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after);
static GeeSortedSet* gee_tree_set_real_sub_set (GeeSortedSet* base, gconstpointer after, gconstpointer before);
static GeeTreeSetSubSet* gee_tree_set_sub_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before);
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before);
static inline GeeTreeSetNode* gee_tree_set_find_node (GeeTreeSet* self, gconstpointer item);
static GeeBidirIterator* gee_tree_set_real_iterator_at (GeeSortedSet* base, gconstpointer item);
static GeeTreeSetIterator* gee_tree_set_iterator_new_pointing (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetNode* current);
static GeeTreeSetIterator* gee_tree_set_iterator_construct_pointing (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetNode* current);
static inline GeeTreeSetNode* gee_tree_set_find_nearest (GeeTreeSet* self, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_lower (GeeTreeSet* self, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_higher (GeeTreeSet* self, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_floor (GeeTreeSet* self, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_ceil (GeeTreeSet* self, gconstpointer item);
static gpointer gee_tree_set_real_lower (GeeSortedSet* base, gconstpointer item);
static gpointer gee_tree_set_real_higher (GeeSortedSet* base, gconstpointer item);
static gpointer gee_tree_set_real_floor (GeeSortedSet* base, gconstpointer item);
static gpointer gee_tree_set_real_ceil (GeeSortedSet* base, gconstpointer item);
static inline gpointer gee_tree_set_min (GeeTreeSet* self, gconstpointer a, gconstpointer b);
static inline gpointer gee_tree_set_max (GeeTreeSet* self, gconstpointer a, gconstpointer b);
static void gee_tree_set_node_instance_init (GeeTreeSetNode * self);
static GeeTreeSetNodeColor gee_tree_set_node_color_flip (GeeTreeSetNodeColor self);
#define GEE_TREE_SET_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIteratorPrivate))
enum  {
	GEE_TREE_SET_ITERATOR_DUMMY_PROPERTY,
	GEE_TREE_SET_ITERATOR_G_TYPE,
	GEE_TREE_SET_ITERATOR_G_DUP_FUNC,
	GEE_TREE_SET_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_tree_set_iterator_real_next (GeeIterator* base);
static gboolean gee_tree_set_iterator_real_has_next (GeeIterator* base);
static gboolean gee_tree_set_iterator_real_first (GeeIterator* base);
static gboolean gee_tree_set_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_tree_set_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_tree_set_iterator_real_last (GeeBidirIterator* base);
static gpointer gee_tree_set_iterator_real_get (GeeIterator* base);
static void gee_tree_set_iterator_real_remove (GeeIterator* base);
static gboolean gee_tree_set_iterator_safe_next_get (GeeTreeSetIterator* self, gpointer* val);
static gboolean gee_tree_set_iterator_safe_previous_get (GeeTreeSetIterator* self, gpointer* val);
static void gee_tree_set_iterator_finalize (GObject* obj);
static void _vala_gee_tree_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_tree_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static gpointer gee_tree_set_range_ref (gpointer instance);
static void gee_tree_set_range_unref (gpointer instance);
static GParamSpec* gee_tree_set_param_spec_range (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void gee_tree_set_value_set_range (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void gee_tree_set_value_take_range (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer gee_tree_set_value_get_range (const GValue* value) G_GNUC_UNUSED;
static GType gee_tree_set_range_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define GEE_TREE_SET_RANGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TREE_SET_TYPE_RANGE, GeeTreeSetRangePrivate))
enum  {
	GEE_TREE_SET_RANGE_DUMMY_PROPERTY
};
static GeeTreeSetRange* gee_tree_set_range_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before);
static GeeTreeSetRange* gee_tree_set_range_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before);
static GeeTreeSetRange* gee_tree_set_range_new_head (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before);
static GeeTreeSetRange* gee_tree_set_range_construct_head (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before);
static GeeTreeSetRange* gee_tree_set_range_new_tail (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after);
static GeeTreeSetRange* gee_tree_set_range_construct_tail (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after);
static GeeTreeSetRange* gee_tree_set_range_cut_head (GeeTreeSetRange* self, gconstpointer after);
static GeeTreeSetRange* gee_tree_set_range_cut_tail (GeeTreeSetRange* self, gconstpointer before);
static GeeTreeSetRange* gee_tree_set_range_cut (GeeTreeSetRange* self, gconstpointer after, gconstpointer before);
static gboolean gee_tree_set_range_in_range (GeeTreeSetRange* self, gconstpointer item);
static gint gee_tree_set_range_compare_range (GeeTreeSetRange* self, gconstpointer item);
static gboolean gee_tree_set_range_empty_subset (GeeTreeSetRange* self);
static GeeTreeSetNode* gee_tree_set_range_first (GeeTreeSetRange* self);
static GeeTreeSetNode* gee_tree_set_range_last (GeeTreeSetRange* self);
static void gee_tree_set_range_finalize (GeeTreeSetRange* obj);
#define GEE_TREE_SET_SUB_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TREE_SET_TYPE_SUB_SET, GeeTreeSetSubSetPrivate))
enum  {
	GEE_TREE_SET_SUB_SET_DUMMY_PROPERTY,
	GEE_TREE_SET_SUB_SET_G_TYPE,
	GEE_TREE_SET_SUB_SET_G_DUP_FUNC,
	GEE_TREE_SET_SUB_SET_G_DESTROY_FUNC,
	GEE_TREE_SET_SUB_SET_SIZE,
	GEE_TREE_SET_SUB_SET_IS_EMPTY
};
static GeeTreeSetSubSet* gee_tree_set_sub_set_new_from_range (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range);
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_from_range (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range);
static gboolean gee_tree_set_sub_set_real_contains (GeeAbstractCollection* base, gconstpointer item);
gboolean gee_abstract_collection_contains (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_tree_set_sub_set_real_add (GeeAbstractCollection* base, gconstpointer item);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_tree_set_sub_set_real_remove (GeeAbstractCollection* base, gconstpointer item);
gboolean gee_abstract_collection_remove (GeeAbstractCollection* self, gconstpointer item);
static void gee_tree_set_sub_set_real_clear (GeeAbstractCollection* base);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
void gee_iterator_remove (GeeIterator* self);
static GeeIterator* gee_tree_set_sub_set_real_iterator (GeeAbstractCollection* base);
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range);
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range);
static GType gee_tree_set_sub_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeBidirIterator* gee_tree_set_sub_set_real_bidir_iterator (GeeSortedSet* base);
static gpointer gee_tree_set_sub_set_real_first (GeeSortedSet* base);
static gpointer gee_tree_set_sub_set_real_last (GeeSortedSet* base);
static GeeSortedSet* gee_tree_set_sub_set_real_head_set (GeeSortedSet* base, gconstpointer before);
static GeeSortedSet* gee_tree_set_sub_set_real_tail_set (GeeSortedSet* base, gconstpointer after);
static GeeSortedSet* gee_tree_set_sub_set_real_sub_set (GeeSortedSet* base, gconstpointer after, gconstpointer before);
static GeeBidirIterator* gee_tree_set_sub_set_real_iterator_at (GeeSortedSet* base, gconstpointer item);
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_new_pointing (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range, GeeTreeSetNode* node);
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_construct_pointing (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range, GeeTreeSetNode* node);
static gpointer gee_tree_set_sub_set_real_lower (GeeSortedSet* base, gconstpointer item);
gpointer gee_sorted_set_last (GeeSortedSet* self);
gpointer gee_sorted_set_lower (GeeSortedSet* self, gconstpointer element);
static gpointer gee_tree_set_sub_set_real_higher (GeeSortedSet* base, gconstpointer item);
gpointer gee_sorted_set_first (GeeSortedSet* self);
gpointer gee_sorted_set_higher (GeeSortedSet* self, gconstpointer element);
static gpointer gee_tree_set_sub_set_real_floor (GeeSortedSet* base, gconstpointer item);
gpointer gee_sorted_set_floor (GeeSortedSet* self, gconstpointer element);
static gpointer gee_tree_set_sub_set_real_ceil (GeeSortedSet* base, gconstpointer item);
gpointer gee_sorted_set_ceil (GeeSortedSet* self, gconstpointer element);
static void gee_tree_set_sub_set_finalize (GObject* obj);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_is_empty (GeeAbstractCollection* self);
static void _vala_gee_tree_set_sub_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_tree_set_sub_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GEE_TREE_SET_SUB_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TREE_SET_TYPE_SUB_ITERATOR, GeeTreeSetSubIteratorPrivate))
enum  {
	GEE_TREE_SET_SUB_ITERATOR_DUMMY_PROPERTY,
	GEE_TREE_SET_SUB_ITERATOR_G_TYPE,
	GEE_TREE_SET_SUB_ITERATOR_G_DUP_FUNC,
	GEE_TREE_SET_SUB_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_tree_set_sub_iterator_real_next (GeeIterator* base);
gboolean gee_iterator_first (GeeIterator* self);
static gboolean gee_tree_set_sub_iterator_real_has_next (GeeIterator* base);
static gboolean gee_tree_set_sub_iterator_real_first (GeeIterator* base);
static gboolean gee_tree_set_sub_iterator_real_previous (GeeBidirIterator* base);
gboolean gee_bidir_iterator_previous (GeeBidirIterator* self);
static gboolean gee_tree_set_sub_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_tree_set_sub_iterator_real_last (GeeBidirIterator* base);
static gpointer gee_tree_set_sub_iterator_real_get (GeeIterator* base);
gpointer gee_iterator_get (GeeIterator* self);
static void gee_tree_set_sub_iterator_real_remove (GeeIterator* base);
static void gee_tree_set_sub_iterator_finalize (GObject* obj);
static void _vala_gee_tree_set_sub_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_tree_set_sub_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_tree_set_finalize (GObject* obj);
static void _vala_gee_tree_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_tree_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static GType gee_tree_set_range_type_get_type (void) {
	static volatile gsize gee_tree_set_range_type_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_range_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_TREE_SET_RANGE_TYPE_HEAD, "GEE_TREE_SET_RANGE_TYPE_HEAD", "head"}, {GEE_TREE_SET_RANGE_TYPE_TAIL, "GEE_TREE_SET_RANGE_TYPE_TAIL", "tail"}, {GEE_TREE_SET_RANGE_TYPE_EMPTY, "GEE_TREE_SET_RANGE_TYPE_EMPTY", "empty"}, {GEE_TREE_SET_RANGE_TYPE_BOUNDED, "GEE_TREE_SET_RANGE_TYPE_BOUNDED", "bounded"}, {0, NULL, NULL}};
		GType gee_tree_set_range_type_type_id;
		gee_tree_set_range_type_type_id = g_enum_register_static ("GeeTreeSetRangeType", values);
		g_once_init_leave (&gee_tree_set_range_type_type_id__volatile, gee_tree_set_range_type_type_id);
	}
	return gee_tree_set_range_type_type_id__volatile;
}


/**
 * Constructs a new, empty tree set sorted according to the specified
 * comparator function.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param compare_func an optional element comparator function
 */
GeeTreeSet* gee_tree_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func) {
	GeeTreeSet * self = NULL;
	self = (GeeTreeSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (compare_func == NULL) {
		GCompareFunc _tmp0_ = NULL;
		_tmp0_ = gee_functions_get_compare_func_for (g_type);
		compare_func = _tmp0_;
	}
	gee_tree_set_set_compare_func (self, compare_func);
	return self;
}


GeeTreeSet* gee_tree_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func) {
	return gee_tree_set_construct (GEE_TYPE_TREE_SET, g_type, g_dup_func, g_destroy_func, compare_func);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_tree_set_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSet * self;
	gboolean result = FALSE;
	GeeTreeSetNode* cur;
	self = (GeeTreeSet*) base;
	cur = self->priv->root;
	while (TRUE) {
		GCompareFunc _tmp0_ = NULL;
		gint _tmp1_;
		gint res;
		if (!(cur != NULL)) {
			break;
		}
		_tmp0_ = gee_tree_set_get_compare_func (self);
		_tmp1_ = _tmp0_ (item, cur->key);
		res = _tmp1_;
		if (res == 0) {
			result = TRUE;
			return result;
		} else {
			if (res < 0) {
				cur = cur->left;
			} else {
				cur = cur->right;
			}
		}
	}
	result = FALSE;
	return result;
}


static inline void gee_tree_set_rotate_right (GeeTreeSet* self, GeeTreeSetNode** root) {
	GeeTreeSetNode* _tmp0_;
	GeeTreeSetNode* pivot;
	GeeTreeSetNode* _tmp1_;
	GeeTreeSetNode* _tmp2_;
	GeeTreeSetNode* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	_tmp0_ = (*root)->left;
	(*root)->left = NULL;
	pivot = _tmp0_;
	pivot->color = (*root)->color;
	(*root)->color = GEE_TREE_SET_NODE_COLOR_RED;
	_tmp1_ = pivot->right;
	pivot->right = NULL;
	_gee_tree_set_node_free0 ((*root)->left);
	(*root)->left = _tmp1_;
	_tmp2_ = *root;
	*root = NULL;
	_gee_tree_set_node_free0 (pivot->right);
	pivot->right = _tmp2_;
	_tmp3_ = pivot;
	pivot = NULL;
	_gee_tree_set_node_free0 (*root);
	*root = _tmp3_;
	_gee_tree_set_node_free0 (pivot);
}


static inline void gee_tree_set_rotate_left (GeeTreeSet* self, GeeTreeSetNode** root) {
	GeeTreeSetNode* _tmp0_;
	GeeTreeSetNode* pivot;
	GeeTreeSetNode* _tmp1_;
	GeeTreeSetNode* _tmp2_;
	GeeTreeSetNode* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	_tmp0_ = (*root)->right;
	(*root)->right = NULL;
	pivot = _tmp0_;
	pivot->color = (*root)->color;
	(*root)->color = GEE_TREE_SET_NODE_COLOR_RED;
	_tmp1_ = pivot->left;
	pivot->left = NULL;
	_gee_tree_set_node_free0 ((*root)->right);
	(*root)->right = _tmp1_;
	_tmp2_ = *root;
	*root = NULL;
	_gee_tree_set_node_free0 (pivot->left);
	pivot->left = _tmp2_;
	_tmp3_ = pivot;
	pivot = NULL;
	_gee_tree_set_node_free0 (*root);
	*root = _tmp3_;
	_gee_tree_set_node_free0 (pivot);
}


static inline gboolean gee_tree_set_is_red (GeeTreeSet* self, GeeTreeSetNode* n) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (n != NULL) {
		_tmp0_ = n->color == GEE_TREE_SET_NODE_COLOR_RED;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static inline gboolean gee_tree_set_is_black (GeeTreeSet* self, GeeTreeSetNode* n) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (n == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = n->color == GEE_TREE_SET_NODE_COLOR_BLACK;
	}
	result = _tmp0_;
	return result;
}


static inline void gee_tree_set_fix_up (GeeTreeSet* self, GeeTreeSetNode** node) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp1_ = gee_tree_set_is_black (self, (*node)->left);
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = gee_tree_set_is_red (self, (*node)->right);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gee_tree_set_rotate_left (self, node);
	}
	_tmp4_ = gee_tree_set_is_red (self, (*node)->left);
	if (_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = gee_tree_set_is_red (self, (*node)->left->left);
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gee_tree_set_rotate_right (self, node);
	}
	_tmp7_ = gee_tree_set_is_red (self, (*node)->left);
	if (_tmp7_) {
		gboolean _tmp8_;
		_tmp8_ = gee_tree_set_is_red (self, (*node)->right);
		_tmp6_ = _tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gee_tree_set_node_flip (*node);
	}
}


static gboolean gee_tree_set_add_to_node (GeeTreeSet* self, GeeTreeSetNode** node, gpointer item, GeeTreeSetNode* prev, GeeTreeSetNode* next) {
	gboolean result = FALSE;
	GCompareFunc _tmp2_ = NULL;
	gint _tmp3_;
	gint cmp;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*node) == NULL) {
		gpointer _tmp0_;
		GeeTreeSetNode* _tmp1_ = NULL;
		_tmp0_ = item;
		item = NULL;
		_tmp1_ = gee_tree_set_node_new (_tmp0_, prev, next);
		_gee_tree_set_node_free0 (*node);
		*node = _tmp1_;
		if (prev == NULL) {
			self->priv->_first = *node;
		}
		if (next == NULL) {
			self->priv->_last = *node;
		}
		self->priv->_size++;
		result = TRUE;
		((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		return result;
	}
	_tmp2_ = gee_tree_set_get_compare_func (self);
	_tmp3_ = _tmp2_ (item, (*node)->key);
	cmp = _tmp3_;
	if (cmp == 0) {
		gee_tree_set_fix_up (self, node);
		result = FALSE;
		((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		return result;
	} else {
		if (cmp < 0) {
			gpointer _tmp4_;
			gconstpointer _tmp5_;
			gboolean _tmp6_;
			gboolean r;
			_tmp4_ = (_tmp5_ = item, ((_tmp5_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp5_) : self->priv->g_dup_func ((gpointer) _tmp5_));
			_tmp6_ = gee_tree_set_add_to_node (self, &(*node)->left, _tmp4_, (*node)->prev, *node);
			r = _tmp6_;
			gee_tree_set_fix_up (self, node);
			result = r;
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
			return result;
		} else {
			gpointer _tmp7_;
			gconstpointer _tmp8_;
			gboolean _tmp9_;
			gboolean r;
			_tmp7_ = (_tmp8_ = item, ((_tmp8_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp8_) : self->priv->g_dup_func ((gpointer) _tmp8_));
			_tmp9_ = gee_tree_set_add_to_node (self, &(*node)->right, _tmp7_, *node, (*node)->next);
			r = _tmp9_;
			gee_tree_set_fix_up (self, node);
			result = r;
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
			return result;
		}
	}
	((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
}


/**
 * {@inheritDoc}
 *
 * If the element already exists in the set it will not be added twice.
 */
static gboolean gee_tree_set_real_add (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSet * self;
	gboolean result = FALSE;
	gpointer _tmp0_;
	gconstpointer _tmp1_;
	gboolean _tmp2_;
	gboolean r;
	self = (GeeTreeSet*) base;
	_tmp0_ = (_tmp1_ = item, ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_));
	_tmp2_ = gee_tree_set_add_to_node (self, &self->priv->root, _tmp0_, NULL, NULL);
	r = _tmp2_;
	self->priv->root->color = GEE_TREE_SET_NODE_COLOR_BLACK;
	self->priv->stamp++;
	result = r;
	return result;
}


static inline void gee_tree_set_move_red_left (GeeTreeSet* self, GeeTreeSetNode** root) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	gee_tree_set_node_flip (*root);
	_tmp0_ = gee_tree_set_is_red (self, (*root)->right->left);
	if (_tmp0_) {
		gee_tree_set_rotate_right (self, &(*root)->right);
		gee_tree_set_rotate_left (self, root);
		gee_tree_set_node_flip (*root);
	}
}


static inline void gee_tree_set_move_red_right (GeeTreeSet* self, GeeTreeSetNode** root) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	gee_tree_set_node_flip (*root);
	_tmp0_ = gee_tree_set_is_red (self, (*root)->left->left);
	if (_tmp0_) {
		gee_tree_set_rotate_right (self, root);
		gee_tree_set_node_flip (*root);
	}
}


static inline void gee_tree_set_fix_removal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key) {
	gpointer _key = NULL;
	GeeTreeSetNode* _tmp0_;
	GeeTreeSetNode* n;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = *node;
	*node = NULL;
	n = _tmp0_;
	if ((&_key) != NULL) {
		gpointer _tmp1_;
		_tmp1_ = n->key;
		n->key = NULL;
		((_key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_key = (self->priv->g_destroy_func (_key), NULL));
		_key = _tmp1_;
	} else {
		((n->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (n->key = (self->priv->g_destroy_func (n->key), NULL));
		n->key = NULL;
	}
	if (n->prev != NULL) {
		n->prev->next = n->next;
	} else {
		self->priv->_first = n->next;
	}
	if (n->next != NULL) {
		n->next->prev = n->prev;
	} else {
		self->priv->_last = n->prev;
	}
	_gee_tree_set_node_free0 (*node);
	*node = NULL;
	self->priv->_size--;
	_gee_tree_set_node_free0 (n);
	if (key) {
		*key = _key;
	} else {
		((_key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_key = (self->priv->g_destroy_func (_key), NULL));
	}
}


static void gee_tree_set_remove_minimal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key) {
	gpointer _key = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gpointer _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if ((*node)->left == NULL) {
		gpointer _tmp0_ = NULL;
		gee_tree_set_fix_removal (self, node, &_tmp0_);
		((_key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_key = (self->priv->g_destroy_func (_key), NULL));
		_key = _tmp0_;
		if (key) {
			*key = _key;
		} else {
			((_key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_key = (self->priv->g_destroy_func (_key), NULL));
		}
		return;
	}
	_tmp2_ = gee_tree_set_is_black (self, (*node)->left);
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = gee_tree_set_is_black (self, (*node)->left->left);
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gee_tree_set_move_red_left (self, node);
	}
	gee_tree_set_remove_minimal (self, &(*node)->left, &_tmp4_);
	((_key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_key = (self->priv->g_destroy_func (_key), NULL));
	_key = _tmp4_;
	gee_tree_set_fix_up (self, node);
	if (key) {
		*key = _key;
	} else {
		((_key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_key = (self->priv->g_destroy_func (_key), NULL));
	}
}


static gboolean gee_tree_set_remove_from_node (GeeTreeSet* self, GeeTreeSetNode** node, gconstpointer item, GeeTreeSetNode** prev, GeeTreeSetNode** next) {
	GeeTreeSetNode* _prev = NULL;
	GeeTreeSetNode* _next = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*node) == NULL) {
		result = FALSE;
		if (prev) {
			*prev = _prev;
		}
		if (next) {
			*next = _next;
		}
		return result;
	} else {
		GCompareFunc _tmp0_ = NULL;
		gint _tmp1_;
		_tmp0_ = gee_tree_set_get_compare_func (self);
		_tmp1_ = _tmp0_ (item, (*node)->key);
		if (_tmp1_ < 0) {
			GeeTreeSetNode* left;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_;
			GeeTreeSetNode* _tmp5_ = NULL;
			GeeTreeSetNode* _tmp6_ = NULL;
			gboolean _tmp7_;
			gboolean r;
			left = (*node)->left;
			if (left == NULL) {
				result = FALSE;
				if (prev) {
					*prev = _prev;
				}
				if (next) {
					*next = _next;
				}
				return result;
			}
			_tmp3_ = gee_tree_set_is_black (self, left);
			if (_tmp3_) {
				gboolean _tmp4_;
				_tmp4_ = gee_tree_set_is_black (self, left->left);
				_tmp2_ = _tmp4_;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				gee_tree_set_move_red_left (self, node);
			}
			_tmp7_ = gee_tree_set_remove_from_node (self, &(*node)->left, item, &_tmp5_, &_tmp6_);
			_prev = _tmp5_;
			_next = _tmp6_;
			r = _tmp7_;
			gee_tree_set_fix_up (self, node);
			result = r;
			if (prev) {
				*prev = _prev;
			}
			if (next) {
				*next = _next;
			}
			return result;
		} else {
			gboolean _tmp8_;
			GeeTreeSetNode* r;
			gboolean _tmp9_ = FALSE;
			GCompareFunc _tmp10_ = NULL;
			gint _tmp11_;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			GCompareFunc _tmp16_ = NULL;
			gint _tmp17_;
			_tmp8_ = gee_tree_set_is_red (self, (*node)->left);
			if (_tmp8_) {
				gee_tree_set_rotate_right (self, node);
			}
			r = (*node)->right;
			_tmp10_ = gee_tree_set_get_compare_func (self);
			_tmp11_ = _tmp10_ (item, (*node)->key);
			if (_tmp11_ == 0) {
				_tmp9_ = r == NULL;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				if ((&_prev) != NULL) {
					_prev = (*node)->prev;
				}
				if ((&_next) != NULL) {
					_next = (*node)->next;
				}
				gee_tree_set_fix_removal (self, node, NULL);
				result = TRUE;
				if (prev) {
					*prev = _prev;
				}
				if (next) {
					*next = _next;
				}
				return result;
			}
			_tmp14_ = gee_tree_set_is_black (self, r);
			if (_tmp14_) {
				_tmp13_ = r != NULL;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				gboolean _tmp15_;
				_tmp15_ = gee_tree_set_is_black (self, r->left);
				_tmp12_ = _tmp15_;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				gee_tree_set_move_red_right (self, node);
			}
			_tmp16_ = gee_tree_set_get_compare_func (self);
			_tmp17_ = _tmp16_ (item, (*node)->key);
			if (_tmp17_ == 0) {
				gpointer _tmp18_ = NULL;
				if ((&_prev) != NULL) {
					_prev = (*node)->prev;
				}
				if ((&_next) != NULL) {
					_next = *node;
				}
				gee_tree_set_remove_minimal (self, &(*node)->right, &_tmp18_);
				(((*node)->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*node)->key = (self->priv->g_destroy_func ((*node)->key), NULL));
				(*node)->key = _tmp18_;
				gee_tree_set_fix_up (self, node);
				result = TRUE;
				if (prev) {
					*prev = _prev;
				}
				if (next) {
					*next = _next;
				}
				return result;
			} else {
				GeeTreeSetNode* _tmp19_ = NULL;
				GeeTreeSetNode* _tmp20_ = NULL;
				gboolean _tmp21_;
				gboolean re;
				_tmp21_ = gee_tree_set_remove_from_node (self, &(*node)->right, item, &_tmp19_, &_tmp20_);
				_prev = _tmp19_;
				_next = _tmp20_;
				re = _tmp21_;
				gee_tree_set_fix_up (self, node);
				result = re;
				if (prev) {
					*prev = _prev;
				}
				if (next) {
					*next = _next;
				}
				return result;
			}
		}
	}
	if (prev) {
		*prev = _prev;
	}
	if (next) {
		*next = _next;
	}
}


/**
 * {@inheritDoc}
 */
static gboolean gee_tree_set_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSet * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean b;
	self = (GeeTreeSet*) base;
	_tmp0_ = gee_tree_set_remove_from_node (self, &self->priv->root, item, NULL, NULL);
	b = _tmp0_;
	if (self->priv->root != NULL) {
		self->priv->root->color = GEE_TREE_SET_NODE_COLOR_BLACK;
	}
	self->priv->stamp++;
	result = b;
	return result;
}


static inline void gee_tree_set_clear_subtree (GeeTreeSet* self, GeeTreeSetNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	((node->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node->key = (self->priv->g_destroy_func (node->key), NULL));
	node->key = NULL;
	if (node->left != NULL) {
		GeeTreeSetNode* _tmp0_;
		_tmp0_ = node->left;
		node->left = NULL;
		gee_tree_set_clear_subtree (self, _tmp0_);
	}
	if (node->right != NULL) {
		GeeTreeSetNode* _tmp1_;
		_tmp1_ = node->right;
		node->right = NULL;
		gee_tree_set_clear_subtree (self, _tmp1_);
	}
	_gee_tree_set_node_free0 (node);
}


/**
 * {@inheritDoc}
 */
static void gee_tree_set_real_clear (GeeAbstractCollection* base) {
	GeeTreeSet * self;
	self = (GeeTreeSet*) base;
	if (self->priv->root != NULL) {
		GeeTreeSetNode* _tmp0_;
		_tmp0_ = self->priv->root;
		self->priv->root = NULL;
		gee_tree_set_clear_subtree (self, _tmp0_);
		self->priv->_last = NULL;
		self->priv->_first = self->priv->_last;
	}
	self->priv->_size = 0;
	self->priv->stamp++;
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_tree_set_real_iterator (GeeAbstractCollection* base) {
	GeeTreeSet * self;
	GeeIterator* result = NULL;
	GeeTreeSetIterator* _tmp0_ = NULL;
	self = (GeeTreeSet*) base;
	_tmp0_ = gee_tree_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	result = (GeeIterator*) _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeBidirIterator* gee_tree_set_real_bidir_iterator (GeeSortedSet* base) {
	GeeTreeSet * self;
	GeeBidirIterator* result = NULL;
	GeeTreeSetIterator* _tmp0_ = NULL;
	self = (GeeTreeSet*) base;
	_tmp0_ = gee_tree_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	result = (GeeBidirIterator*) _tmp0_;
	return result;
}


static inline gpointer gee_tree_set_lift_null_get (GeeTreeSet* self, GeeTreeSetNode* node) {
	gpointer result = NULL;
	gconstpointer _tmp0_ = NULL;
	gpointer _tmp1_;
	gconstpointer _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	if (node != NULL) {
		_tmp0_ = node->key;
	} else {
		_tmp0_ = NULL;
	}
	_tmp1_ = (_tmp2_ = _tmp0_, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_));
	result = _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_tree_set_real_first (GeeSortedSet* base) {
	GeeTreeSet * self;
	gpointer result = NULL;
	gpointer _tmp0_;
	gconstpointer _tmp1_;
	self = (GeeTreeSet*) base;
	g_assert (self->priv->_first != NULL);
	_tmp0_ = (_tmp1_ = self->priv->_first->key, ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_));
	result = _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_tree_set_real_last (GeeSortedSet* base) {
	GeeTreeSet * self;
	gpointer result = NULL;
	gpointer _tmp0_;
	gconstpointer _tmp1_;
	self = (GeeTreeSet*) base;
	g_assert (self->priv->_last != NULL);
	_tmp0_ = (_tmp1_ = self->priv->_last->key, ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_));
	result = _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeSortedSet* gee_tree_set_real_head_set (GeeSortedSet* base, gconstpointer before) {
	GeeTreeSet * self;
	GeeSortedSet* result = NULL;
	GeeTreeSetSubSet* _tmp0_ = NULL;
	self = (GeeTreeSet*) base;
	_tmp0_ = gee_tree_set_sub_set_new_head (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self, before);
	result = (GeeSortedSet*) _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeSortedSet* gee_tree_set_real_tail_set (GeeSortedSet* base, gconstpointer after) {
	GeeTreeSet * self;
	GeeSortedSet* result = NULL;
	GeeTreeSetSubSet* _tmp0_ = NULL;
	self = (GeeTreeSet*) base;
	_tmp0_ = gee_tree_set_sub_set_new_tail (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self, after);
	result = (GeeSortedSet*) _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeSortedSet* gee_tree_set_real_sub_set (GeeSortedSet* base, gconstpointer after, gconstpointer before) {
	GeeTreeSet * self;
	GeeSortedSet* result = NULL;
	GeeTreeSetSubSet* _tmp0_ = NULL;
	self = (GeeTreeSet*) base;
	_tmp0_ = gee_tree_set_sub_set_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self, after, before);
	result = (GeeSortedSet*) _tmp0_;
	return result;
}


static inline GeeTreeSetNode* gee_tree_set_find_node (GeeTreeSet* self, gconstpointer item) {
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* cur;
	g_return_val_if_fail (self != NULL, NULL);
	cur = self->priv->root;
	while (TRUE) {
		GCompareFunc _tmp0_ = NULL;
		gint _tmp1_;
		gint res;
		if (!(cur != NULL)) {
			break;
		}
		_tmp0_ = gee_tree_set_get_compare_func (self);
		_tmp1_ = _tmp0_ (item, cur->key);
		res = _tmp1_;
		if (res == 0) {
			result = cur;
			return result;
		} else {
			if (res < 0) {
				cur = cur->left;
			} else {
				cur = cur->right;
			}
		}
	}
	result = NULL;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeBidirIterator* gee_tree_set_real_iterator_at (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSet * self;
	GeeBidirIterator* result = NULL;
	GeeTreeSetNode* _tmp0_ = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetIterator* _tmp1_ = NULL;
	self = (GeeTreeSet*) base;
	_tmp0_ = gee_tree_set_find_node (self, item);
	node = _tmp0_;
	if (node != NULL) {
		GeeTreeSetIterator* _tmp2_ = NULL;
		_tmp2_ = gee_tree_set_iterator_new_pointing (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self, node);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp2_;
	} else {
		_g_object_unref0 (_tmp1_);
		_tmp1_ = NULL;
	}
	result = (GeeBidirIterator*) _tmp1_;
	return result;
}


static inline GeeTreeSetNode* gee_tree_set_find_nearest (GeeTreeSet* self, gconstpointer item) {
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* cur;
	g_return_val_if_fail (self != NULL, NULL);
	cur = self->priv->root;
	while (TRUE) {
		GCompareFunc _tmp0_ = NULL;
		gint _tmp1_;
		gint res;
		if (!(cur != NULL)) {
			break;
		}
		_tmp0_ = gee_tree_set_get_compare_func (self);
		_tmp1_ = _tmp0_ (item, cur->key);
		res = _tmp1_;
		if (res == 0) {
			result = cur;
			return result;
		} else {
			if (res < 0) {
				if (cur->left == NULL) {
					result = cur;
					return result;
				}
				cur = cur->left;
			} else {
				if (cur->right == NULL) {
					result = cur;
					return result;
				}
				cur = cur->right;
			}
		}
	}
	result = NULL;
	return result;
}


static inline GeeTreeSetNode* gee_tree_set_find_lower (GeeTreeSet* self, gconstpointer item) {
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* _tmp0_ = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetNode* _tmp1_ = NULL;
	GCompareFunc _tmp2_ = NULL;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_tree_set_find_nearest (self, item);
	node = _tmp0_;
	if (node == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = gee_tree_set_get_compare_func (self);
	_tmp3_ = _tmp2_ (item, node->key);
	if (_tmp3_ <= 0) {
		_tmp1_ = node->prev;
	} else {
		_tmp1_ = node;
	}
	result = _tmp1_;
	return result;
}


static inline GeeTreeSetNode* gee_tree_set_find_higher (GeeTreeSet* self, gconstpointer item) {
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* _tmp0_ = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetNode* _tmp1_ = NULL;
	GCompareFunc _tmp2_ = NULL;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_tree_set_find_nearest (self, item);
	node = _tmp0_;
	if (node == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = gee_tree_set_get_compare_func (self);
	_tmp3_ = _tmp2_ (item, node->key);
	if (_tmp3_ >= 0) {
		_tmp1_ = node->next;
	} else {
		_tmp1_ = node;
	}
	result = _tmp1_;
	return result;
}


static inline GeeTreeSetNode* gee_tree_set_find_floor (GeeTreeSet* self, gconstpointer item) {
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* _tmp0_ = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetNode* _tmp1_ = NULL;
	GCompareFunc _tmp2_ = NULL;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_tree_set_find_nearest (self, item);
	node = _tmp0_;
	if (node == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = gee_tree_set_get_compare_func (self);
	_tmp3_ = _tmp2_ (item, node->key);
	if (_tmp3_ < 0) {
		_tmp1_ = node->prev;
	} else {
		_tmp1_ = node;
	}
	result = _tmp1_;
	return result;
}


static inline GeeTreeSetNode* gee_tree_set_find_ceil (GeeTreeSet* self, gconstpointer item) {
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* _tmp0_ = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetNode* _tmp1_ = NULL;
	GCompareFunc _tmp2_ = NULL;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_tree_set_find_nearest (self, item);
	node = _tmp0_;
	if (node == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = gee_tree_set_get_compare_func (self);
	_tmp3_ = _tmp2_ (item, node->key);
	if (_tmp3_ > 0) {
		_tmp1_ = node->next;
	} else {
		_tmp1_ = node;
	}
	result = _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_tree_set_real_lower (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSet * self;
	gpointer result = NULL;
	GeeTreeSetNode* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	self = (GeeTreeSet*) base;
	_tmp0_ = gee_tree_set_find_lower (self, item);
	_tmp1_ = gee_tree_set_lift_null_get (self, _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_tree_set_real_higher (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSet * self;
	gpointer result = NULL;
	GeeTreeSetNode* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	self = (GeeTreeSet*) base;
	_tmp0_ = gee_tree_set_find_higher (self, item);
	_tmp1_ = gee_tree_set_lift_null_get (self, _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_tree_set_real_floor (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSet * self;
	gpointer result = NULL;
	GeeTreeSetNode* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	self = (GeeTreeSet*) base;
	_tmp0_ = gee_tree_set_find_floor (self, item);
	_tmp1_ = gee_tree_set_lift_null_get (self, _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_tree_set_real_ceil (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSet * self;
	gpointer result = NULL;
	GeeTreeSetNode* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	self = (GeeTreeSet*) base;
	_tmp0_ = gee_tree_set_find_ceil (self, item);
	_tmp1_ = gee_tree_set_lift_null_get (self, _tmp0_);
	result = _tmp1_;
	return result;
}


static inline gpointer gee_tree_set_min (GeeTreeSet* self, gconstpointer a, gconstpointer b) {
	gpointer result = NULL;
	gconstpointer _tmp0_ = NULL;
	GCompareFunc _tmp1_ = NULL;
	gint _tmp2_;
	gpointer _tmp3_;
	gconstpointer _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = gee_tree_set_get_compare_func (self);
	_tmp2_ = _tmp1_ (a, b);
	if (_tmp2_ <= 0) {
		_tmp0_ = a;
	} else {
		_tmp0_ = b;
	}
	_tmp3_ = (_tmp4_ = _tmp0_, ((_tmp4_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp4_) : self->priv->g_dup_func ((gpointer) _tmp4_));
	result = _tmp3_;
	return result;
}


static inline gpointer gee_tree_set_max (GeeTreeSet* self, gconstpointer a, gconstpointer b) {
	gpointer result = NULL;
	gconstpointer _tmp0_ = NULL;
	GCompareFunc _tmp1_ = NULL;
	gint _tmp2_;
	gpointer _tmp3_;
	gconstpointer _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = gee_tree_set_get_compare_func (self);
	_tmp2_ = _tmp1_ (a, b);
	if (_tmp2_ > 0) {
		_tmp0_ = a;
	} else {
		_tmp0_ = b;
	}
	_tmp3_ = (_tmp4_ = _tmp0_, ((_tmp4_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp4_) : self->priv->g_dup_func ((gpointer) _tmp4_));
	result = _tmp3_;
	return result;
}


static gint gee_tree_set_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeTreeSet* self;
	self = (GeeTreeSet*) base;
	result = self->priv->_size;
	return result;
}


GCompareFunc gee_tree_set_get_compare_func (GeeTreeSet* self) {
	GCompareFunc result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_compare_func;
	return result;
}


static void gee_tree_set_set_compare_func (GeeTreeSet* self, GCompareFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_compare_func = value;
	g_object_notify ((GObject *) self, "compare-func");
}


static GeeTreeSetNodeColor gee_tree_set_node_color_flip (GeeTreeSetNodeColor self) {
	GeeTreeSetNodeColor result = 0;
	if (self == GEE_TREE_SET_NODE_COLOR_RED) {
		result = GEE_TREE_SET_NODE_COLOR_BLACK;
		return result;
	} else {
		result = GEE_TREE_SET_NODE_COLOR_RED;
		return result;
	}
}


GType gee_tree_set_node_color_get_type (void) {
	static volatile gsize gee_tree_set_node_color_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_node_color_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_TREE_SET_NODE_COLOR_RED, "GEE_TREE_SET_NODE_COLOR_RED", "red"}, {GEE_TREE_SET_NODE_COLOR_BLACK, "GEE_TREE_SET_NODE_COLOR_BLACK", "black"}, {0, NULL, NULL}};
		GType gee_tree_set_node_color_type_id;
		gee_tree_set_node_color_type_id = g_enum_register_static ("GeeTreeSetNodeColor", values);
		g_once_init_leave (&gee_tree_set_node_color_type_id__volatile, gee_tree_set_node_color_type_id);
	}
	return gee_tree_set_node_color_type_id__volatile;
}


static GeeTreeSetNode* gee_tree_set_node_new (gpointer node, GeeTreeSetNode* prev, GeeTreeSetNode* next) {
	GeeTreeSetNode* self;
	gpointer _tmp0_;
	self = g_slice_new0 (GeeTreeSetNode);
	gee_tree_set_node_instance_init (self);
	_tmp0_ = node;
	node = NULL;
	self->key = _tmp0_;
	self->color = GEE_TREE_SET_NODE_COLOR_RED;
	self->prev = prev;
	self->next = next;
	if (prev != NULL) {
		prev->next = self;
	}
	if (next != NULL) {
		next->prev = self;
	}
	return self;
}


static void gee_tree_set_node_flip (GeeTreeSetNode* self) {
	GeeTreeSetNodeColor _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_tree_set_node_color_flip (self->color);
	self->color = _tmp0_;
	if (self->left != NULL) {
		GeeTreeSetNodeColor _tmp1_;
		_tmp1_ = gee_tree_set_node_color_flip (self->left->color);
		self->left->color = _tmp1_;
	}
	if (self->right != NULL) {
		GeeTreeSetNodeColor _tmp2_;
		_tmp2_ = gee_tree_set_node_color_flip (self->right->color);
		self->right->color = _tmp2_;
	}
}


static void gee_tree_set_node_instance_init (GeeTreeSetNode * self) {
}


static void gee_tree_set_node_free (GeeTreeSetNode* self) {
	_gee_tree_set_node_free0 (self->left);
	_gee_tree_set_node_free0 (self->right);
	g_slice_free (GeeTreeSetNode, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeTreeSetIterator* gee_tree_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set) {
	GeeTreeSetIterator * self = NULL;
	GeeTreeSet* _tmp0_;
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeTreeSetIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (set);
	_g_object_unref0 (self->priv->_set);
	self->priv->_set = _tmp0_;
	self->priv->stamp = self->priv->_set->priv->stamp;
	return self;
}


static GeeTreeSetIterator* gee_tree_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set) {
	return gee_tree_set_iterator_construct (GEE_TREE_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set);
}


static GeeTreeSetIterator* gee_tree_set_iterator_construct_pointing (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetNode* current) {
	GeeTreeSetIterator * self = NULL;
	GeeTreeSet* _tmp0_;
	g_return_val_if_fail (set != NULL, NULL);
	g_return_val_if_fail (current != NULL, NULL);
	self = (GeeTreeSetIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (set);
	_g_object_unref0 (self->priv->_set);
	self->priv->_set = _tmp0_;
	self->priv->current = current;
	self->priv->stamp = set->priv->stamp;
	self->priv->started = TRUE;
	return self;
}


static GeeTreeSetIterator* gee_tree_set_iterator_new_pointing (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetNode* current) {
	return gee_tree_set_iterator_construct_pointing (GEE_TREE_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set, current);
}


static gboolean gee_tree_set_iterator_real_next (GeeIterator* base) {
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	if (self->priv->current != NULL) {
		if (self->priv->current->next != NULL) {
			self->priv->current = self->priv->current->next;
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	} else {
		if (!self->priv->started) {
			self->priv->current = self->priv->_set->priv->_first;
			self->priv->started = TRUE;
			result = self->priv->current != NULL;
			return result;
		} else {
			self->priv->current = self->priv->_next;
			if (self->priv->current != NULL) {
				self->priv->_next = NULL;
				self->priv->_prev = NULL;
			}
			result = self->priv->current != NULL;
			return result;
		}
	}
}


static gboolean gee_tree_set_iterator_real_has_next (GeeIterator* base) {
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	if (!self->priv->started) {
		_tmp2_ = self->priv->_set->priv->_first != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (self->priv->current == NULL) {
			_tmp3_ = self->priv->_next != NULL;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if (self->priv->current != NULL) {
			_tmp4_ = self->priv->current->next != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


static gboolean gee_tree_set_iterator_real_first (GeeIterator* base) {
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	self->priv->current = self->priv->_set->priv->_first;
	self->priv->_next = NULL;
	self->priv->_prev = NULL;
	self->priv->started = TRUE;
	result = self->priv->current != NULL;
	return result;
}


static gboolean gee_tree_set_iterator_real_previous (GeeBidirIterator* base) {
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	if (self->priv->current != NULL) {
		if (self->priv->current->prev != NULL) {
			self->priv->current = self->priv->current->prev;
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	} else {
		if (self->priv->_prev != NULL) {
			self->priv->current = self->priv->_prev;
			self->priv->_next = NULL;
			self->priv->_prev = NULL;
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	}
}


static gboolean gee_tree_set_iterator_real_has_previous (GeeBidirIterator* base) {
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	if (self->priv->current == NULL) {
		_tmp1_ = self->priv->_prev != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->priv->current != NULL) {
			_tmp2_ = self->priv->current->prev != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}


static gboolean gee_tree_set_iterator_real_last (GeeBidirIterator* base) {
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	self->priv->current = self->priv->_set->priv->_last;
	self->priv->_next = NULL;
	self->priv->_prev = NULL;
	self->priv->started = TRUE;
	result = self->priv->current != NULL;
	return result;
}


static gpointer gee_tree_set_iterator_real_get (GeeIterator* base) {
	GeeTreeSetIterator * self;
	gpointer result = NULL;
	gpointer _tmp0_;
	gconstpointer _tmp1_;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	g_assert (self->priv->current != NULL);
	_tmp0_ = (_tmp1_ = self->priv->current->key, ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_));
	result = _tmp0_;
	return result;
}


static void gee_tree_set_iterator_real_remove (GeeIterator* base) {
	GeeTreeSetIterator * self;
	GeeTreeSetNode* _tmp0_ = NULL;
	GeeTreeSetNode* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean success;
	gint _tmp3_;
	gint _tmp4_;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	g_assert (self->priv->current != NULL);
	_tmp2_ = gee_tree_set_remove_from_node (self->priv->_set, &self->priv->_set->priv->root, self->priv->current->key, &_tmp0_, &_tmp1_);
	self->priv->_prev = _tmp0_;
	self->priv->_next = _tmp1_;
	success = _tmp2_;
	g_assert (success);
	if (self->priv->_set->priv->root != NULL) {
		self->priv->_set->priv->root->color = GEE_TREE_SET_NODE_COLOR_BLACK;
	}
	self->priv->current = NULL;
	_tmp3_ = self->priv->stamp;
	self->priv->stamp = _tmp3_ + 1;
	_tmp4_ = self->priv->_set->priv->stamp;
	self->priv->_set->priv->stamp = _tmp4_ + 1;
	g_assert (_tmp3_ == _tmp4_);
}


static gboolean gee_tree_set_iterator_safe_next_get (GeeTreeSetIterator* self, gpointer* val) {
	gpointer _val = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current != NULL) {
		gpointer _tmp0_ = NULL;
		_tmp0_ = gee_tree_set_lift_null_get (self->priv->_set, self->priv->current->next);
		((_val == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_val = (self->priv->g_destroy_func (_val), NULL));
		_val = _tmp0_;
		result = self->priv->current->next != NULL;
		if (val) {
			*val = _val;
		} else {
			((_val == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_val = (self->priv->g_destroy_func (_val), NULL));
		}
		return result;
	} else {
		gpointer _tmp1_ = NULL;
		_tmp1_ = gee_tree_set_lift_null_get (self->priv->_set, self->priv->_next);
		((_val == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_val = (self->priv->g_destroy_func (_val), NULL));
		_val = _tmp1_;
		result = self->priv->_next != NULL;
		if (val) {
			*val = _val;
		} else {
			((_val == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_val = (self->priv->g_destroy_func (_val), NULL));
		}
		return result;
	}
	if (val) {
		*val = _val;
	} else {
		((_val == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_val = (self->priv->g_destroy_func (_val), NULL));
	}
}


static gboolean gee_tree_set_iterator_safe_previous_get (GeeTreeSetIterator* self, gpointer* val) {
	gpointer _val = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current != NULL) {
		gpointer _tmp0_ = NULL;
		_tmp0_ = gee_tree_set_lift_null_get (self->priv->_set, self->priv->current->prev);
		((_val == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_val = (self->priv->g_destroy_func (_val), NULL));
		_val = _tmp0_;
		result = self->priv->current->prev != NULL;
		if (val) {
			*val = _val;
		} else {
			((_val == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_val = (self->priv->g_destroy_func (_val), NULL));
		}
		return result;
	} else {
		gpointer _tmp1_ = NULL;
		_tmp1_ = gee_tree_set_lift_null_get (self->priv->_set, self->priv->_prev);
		((_val == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_val = (self->priv->g_destroy_func (_val), NULL));
		_val = _tmp1_;
		result = self->priv->_next != NULL;
		if (val) {
			*val = _val;
		} else {
			((_val == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_val = (self->priv->g_destroy_func (_val), NULL));
		}
		return result;
	}
	if (val) {
		*val = _val;
	} else {
		((_val == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_val = (self->priv->g_destroy_func (_val), NULL));
	}
}


static void gee_tree_set_iterator_class_init (GeeTreeSetIteratorClass * klass) {
	gee_tree_set_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_tree_set_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_tree_set_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_tree_set_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_tree_set_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(GeeIterator*)) gee_tree_set_iterator_real_next;
	iface->has_next = (gboolean (*)(GeeIterator*)) gee_tree_set_iterator_real_has_next;
	iface->first = (gboolean (*)(GeeIterator*)) gee_tree_set_iterator_real_first;
	iface->get = (gpointer (*)(GeeIterator*)) gee_tree_set_iterator_real_get;
	iface->remove = (void (*)(GeeIterator*)) gee_tree_set_iterator_real_remove;
}


static void gee_tree_set_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
	gee_tree_set_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->previous = (gboolean (*)(GeeBidirIterator*)) gee_tree_set_iterator_real_previous;
	iface->has_previous = (gboolean (*)(GeeBidirIterator*)) gee_tree_set_iterator_real_has_previous;
	iface->last = (gboolean (*)(GeeBidirIterator*)) gee_tree_set_iterator_real_last;
}


static void gee_tree_set_iterator_instance_init (GeeTreeSetIterator * self) {
	self->priv = GEE_TREE_SET_ITERATOR_GET_PRIVATE (self);
	self->priv->current = NULL;
	self->priv->_next = NULL;
	self->priv->_prev = NULL;
	self->priv->started = FALSE;
}


static void gee_tree_set_iterator_finalize (GObject* obj) {
	GeeTreeSetIterator * self;
	self = GEE_TREE_SET_ITERATOR (obj);
	_g_object_unref0 (self->priv->_set);
	G_OBJECT_CLASS (gee_tree_set_iterator_parent_class)->finalize (obj);
}


static GType gee_tree_set_iterator_get_type (void) {
	static volatile gsize gee_tree_set_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSetIterator), 0, (GInstanceInitFunc) gee_tree_set_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_tree_set_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_tree_set_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_tree_set_iterator_type_id;
		gee_tree_set_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeTreeSetIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_tree_set_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_once_init_leave (&gee_tree_set_iterator_type_id__volatile, gee_tree_set_iterator_type_id);
	}
	return gee_tree_set_iterator_type_id__volatile;
}


static void _vala_gee_tree_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSetIterator * self;
	self = GEE_TREE_SET_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_tree_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSetIterator * self;
	self = GEE_TREE_SET_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static GeeTreeSetRange* gee_tree_set_range_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before) {
	GeeTreeSetRange* self = NULL;
	GeeTreeSet* _tmp0_;
	GCompareFunc _tmp1_ = NULL;
	gint _tmp2_;
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeTreeSetRange*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (set);
	_g_object_unref0 (self->priv->set);
	self->priv->set = _tmp0_;
	_tmp1_ = gee_tree_set_get_compare_func (set);
	_tmp2_ = _tmp1_ (after, before);
	if (_tmp2_ < 0) {
		gpointer _tmp3_;
		gconstpointer _tmp4_;
		gpointer _tmp5_;
		gconstpointer _tmp6_;
		_tmp3_ = (_tmp4_ = after, ((_tmp4_ == NULL) || (g_dup_func == NULL)) ? ((gpointer) _tmp4_) : g_dup_func ((gpointer) _tmp4_));
		_g_destroy_func0 (self->priv->after);
		self->priv->after = _tmp3_;
		_tmp5_ = (_tmp6_ = before, ((_tmp6_ == NULL) || (g_dup_func == NULL)) ? ((gpointer) _tmp6_) : g_dup_func ((gpointer) _tmp6_));
		_g_destroy_func0 (self->priv->before);
		self->priv->before = _tmp5_;
		self->priv->type = GEE_TREE_SET_RANGE_TYPE_BOUNDED;
	} else {
		self->priv->type = GEE_TREE_SET_RANGE_TYPE_EMPTY;
	}
	return self;
}


static GeeTreeSetRange* gee_tree_set_range_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before) {
	return gee_tree_set_range_construct (GEE_TREE_SET_TYPE_RANGE, g_type, g_dup_func, g_destroy_func, set, after, before);
}


static GeeTreeSetRange* gee_tree_set_range_construct_head (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before) {
	GeeTreeSetRange* self = NULL;
	GeeTreeSet* _tmp0_;
	gpointer _tmp1_;
	gconstpointer _tmp2_;
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeTreeSetRange*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (set);
	_g_object_unref0 (self->priv->set);
	self->priv->set = _tmp0_;
	_tmp1_ = (_tmp2_ = before, ((_tmp2_ == NULL) || (g_dup_func == NULL)) ? ((gpointer) _tmp2_) : g_dup_func ((gpointer) _tmp2_));
	_g_destroy_func0 (self->priv->before);
	self->priv->before = _tmp1_;
	self->priv->type = GEE_TREE_SET_RANGE_TYPE_HEAD;
	return self;
}


static GeeTreeSetRange* gee_tree_set_range_new_head (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before) {
	return gee_tree_set_range_construct_head (GEE_TREE_SET_TYPE_RANGE, g_type, g_dup_func, g_destroy_func, set, before);
}


static GeeTreeSetRange* gee_tree_set_range_construct_tail (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after) {
	GeeTreeSetRange* self = NULL;
	GeeTreeSet* _tmp0_;
	gpointer _tmp1_;
	gconstpointer _tmp2_;
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeTreeSetRange*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (set);
	_g_object_unref0 (self->priv->set);
	self->priv->set = _tmp0_;
	_tmp1_ = (_tmp2_ = after, ((_tmp2_ == NULL) || (g_dup_func == NULL)) ? ((gpointer) _tmp2_) : g_dup_func ((gpointer) _tmp2_));
	_g_destroy_func0 (self->priv->after);
	self->priv->after = _tmp1_;
	self->priv->type = GEE_TREE_SET_RANGE_TYPE_TAIL;
	return self;
}


static GeeTreeSetRange* gee_tree_set_range_new_tail (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after) {
	return gee_tree_set_range_construct_tail (GEE_TREE_SET_TYPE_RANGE, g_type, g_dup_func, g_destroy_func, set, after);
}


static gpointer _gee_tree_set_range_ref0 (gpointer self) {
	return self ? gee_tree_set_range_ref (self) : NULL;
}


static GeeTreeSetRange* gee_tree_set_range_cut_head (GeeTreeSetRange* self, gconstpointer after) {
	GeeTreeSetRange* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (self->priv->type) {
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			GeeTreeSetRange* _tmp0_ = NULL;
			_tmp0_ = gee_tree_set_range_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, after, self->priv->before);
			result = _tmp0_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			gpointer _tmp1_ = NULL;
			gpointer _tmp2_;
			GeeTreeSetRange* _tmp3_ = NULL;
			GeeTreeSetRange* _tmp4_;
			_tmp1_ = gee_tree_set_max (self->priv->set, after, self->priv->after);
			_tmp2_ = _tmp1_;
			_tmp3_ = gee_tree_set_range_new_tail (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, _tmp2_);
			_tmp4_ = _tmp3_;
			((_tmp2_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp2_ = (self->priv->g_destroy_func (_tmp2_), NULL));
			result = _tmp4_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			GeeTreeSetRange* _tmp5_;
			_tmp5_ = _gee_tree_set_range_ref0 (self);
			result = _tmp5_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_BOUNDED:
		{
			gpointer _tmp6_ = NULL;
			gpointer _after;
			GeeTreeSetRange* _tmp7_ = NULL;
			_tmp6_ = gee_tree_set_max (self->priv->set, after, self->priv->after);
			_after = _tmp6_;
			_tmp7_ = gee_tree_set_range_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, _after, self->priv->before);
			result = _tmp7_;
			((_after == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_after = (self->priv->g_destroy_func (_after), NULL));
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static GeeTreeSetRange* gee_tree_set_range_cut_tail (GeeTreeSetRange* self, gconstpointer before) {
	GeeTreeSetRange* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (self->priv->type) {
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			gpointer _tmp0_ = NULL;
			gpointer _tmp1_;
			GeeTreeSetRange* _tmp2_ = NULL;
			GeeTreeSetRange* _tmp3_;
			_tmp0_ = gee_tree_set_min (self->priv->set, before, self->priv->before);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_tree_set_range_new_head (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, _tmp1_);
			_tmp3_ = _tmp2_;
			((_tmp1_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_ = (self->priv->g_destroy_func (_tmp1_), NULL));
			result = _tmp3_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			GeeTreeSetRange* _tmp4_ = NULL;
			_tmp4_ = gee_tree_set_range_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, self->priv->after, before);
			result = _tmp4_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			GeeTreeSetRange* _tmp5_;
			_tmp5_ = _gee_tree_set_range_ref0 (self);
			result = _tmp5_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_BOUNDED:
		{
			gpointer _tmp6_ = NULL;
			gpointer _before;
			GeeTreeSetRange* _tmp7_ = NULL;
			_tmp6_ = gee_tree_set_min (self->priv->set, before, self->priv->before);
			_before = _tmp6_;
			_tmp7_ = gee_tree_set_range_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, self->priv->after, _before);
			result = _tmp7_;
			((_before == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_before = (self->priv->g_destroy_func (_before), NULL));
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static GeeTreeSetRange* gee_tree_set_range_cut (GeeTreeSetRange* self, gconstpointer after, gconstpointer before) {
	GeeTreeSetRange* result = NULL;
	gpointer _tmp1_ = NULL;
	gpointer _tmp5_;
	gconstpointer _tmp6_;
	gpointer _before;
	gpointer _tmp7_ = NULL;
	gpointer _tmp11_;
	gconstpointer _tmp12_;
	gpointer _after;
	GeeTreeSetRange* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->type == GEE_TREE_SET_RANGE_TYPE_EMPTY) {
		GeeTreeSetRange* _tmp0_;
		_tmp0_ = _gee_tree_set_range_ref0 (self);
		result = _tmp0_;
		return result;
	}
	if (self->priv->type != GEE_TREE_SET_RANGE_TYPE_TAIL) {
		gpointer _tmp2_ = NULL;
		_tmp2_ = gee_tree_set_min (self->priv->set, before, self->priv->before);
		((_tmp1_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_ = (self->priv->g_destroy_func (_tmp1_), NULL));
		_tmp1_ = _tmp2_;
	} else {
		gpointer _tmp3_;
		gconstpointer _tmp4_;
		_tmp3_ = (_tmp4_ = before, ((_tmp4_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp4_) : self->priv->g_dup_func ((gpointer) _tmp4_));
		((_tmp1_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_ = (self->priv->g_destroy_func (_tmp1_), NULL));
		_tmp1_ = _tmp3_;
	}
	_tmp5_ = (_tmp6_ = _tmp1_, ((_tmp6_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp6_) : self->priv->g_dup_func ((gpointer) _tmp6_));
	_before = _tmp5_;
	if (self->priv->type != GEE_TREE_SET_RANGE_TYPE_HEAD) {
		gpointer _tmp8_ = NULL;
		_tmp8_ = gee_tree_set_max (self->priv->set, after, self->priv->after);
		((_tmp7_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp7_ = (self->priv->g_destroy_func (_tmp7_), NULL));
		_tmp7_ = _tmp8_;
	} else {
		gpointer _tmp9_;
		gconstpointer _tmp10_;
		_tmp9_ = (_tmp10_ = after, ((_tmp10_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp10_) : self->priv->g_dup_func ((gpointer) _tmp10_));
		((_tmp7_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp7_ = (self->priv->g_destroy_func (_tmp7_), NULL));
		_tmp7_ = _tmp9_;
	}
	_tmp11_ = (_tmp12_ = _tmp7_, ((_tmp12_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp12_) : self->priv->g_dup_func ((gpointer) _tmp12_));
	_after = _tmp11_;
	_tmp13_ = gee_tree_set_range_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, _after, _before);
	result = _tmp13_;
	((_after == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_after = (self->priv->g_destroy_func (_after), NULL));
	((_tmp7_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp7_ = (self->priv->g_destroy_func (_tmp7_), NULL));
	((_before == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_before = (self->priv->g_destroy_func (_before), NULL));
	((_tmp1_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_ = (self->priv->g_destroy_func (_tmp1_), NULL));
	return result;
}


static gboolean gee_tree_set_range_in_range (GeeTreeSetRange* self, gconstpointer item) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->type == GEE_TREE_SET_RANGE_TYPE_EMPTY) {
		_tmp0_ = FALSE;
	} else {
		gint _tmp1_;
		_tmp1_ = gee_tree_set_range_compare_range (self, item);
		_tmp0_ = _tmp1_ == 0;
	}
	result = _tmp0_;
	return result;
}


static gint gee_tree_set_range_compare_range (GeeTreeSetRange* self, gconstpointer item) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (self->priv->type) {
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			gint _tmp0_ = 0;
			GCompareFunc _tmp1_ = NULL;
			gint _tmp2_;
			_tmp1_ = gee_tree_set_get_compare_func (self->priv->set);
			_tmp2_ = _tmp1_ (item, self->priv->before);
			if (_tmp2_ < 0) {
				_tmp0_ = 0;
			} else {
				_tmp0_ = 1;
			}
			result = _tmp0_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			gint _tmp3_ = 0;
			GCompareFunc _tmp4_ = NULL;
			gint _tmp5_;
			_tmp4_ = gee_tree_set_get_compare_func (self->priv->set);
			_tmp5_ = _tmp4_ (item, self->priv->after);
			if (_tmp5_ >= 0) {
				_tmp3_ = 0;
			} else {
				_tmp3_ = -1;
			}
			result = _tmp3_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			result = 0;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_BOUNDED:
		{
			gint _tmp6_ = 0;
			GCompareFunc _tmp7_ = NULL;
			gint _tmp8_;
			_tmp7_ = gee_tree_set_get_compare_func (self->priv->set);
			_tmp8_ = _tmp7_ (item, self->priv->after);
			if (_tmp8_ >= 0) {
				gint _tmp9_ = 0;
				GCompareFunc _tmp10_ = NULL;
				gint _tmp11_;
				_tmp10_ = gee_tree_set_get_compare_func (self->priv->set);
				_tmp11_ = _tmp10_ (item, self->priv->before);
				if (_tmp11_ < 0) {
					_tmp9_ = 0;
				} else {
					_tmp9_ = 1;
				}
				_tmp6_ = _tmp9_;
			} else {
				_tmp6_ = -1;
			}
			result = _tmp6_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static gboolean gee_tree_set_range_empty_subset (GeeTreeSetRange* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	switch (self->priv->type) {
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			gboolean _tmp0_ = FALSE;
			if (self->priv->set->priv->_first == NULL) {
				_tmp0_ = TRUE;
			} else {
				gboolean _tmp1_;
				_tmp1_ = gee_tree_set_range_in_range (self, self->priv->set->priv->_first->key);
				_tmp0_ = !_tmp1_;
			}
			result = _tmp0_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			gboolean _tmp2_ = FALSE;
			if (self->priv->set->priv->_last == NULL) {
				_tmp2_ = TRUE;
			} else {
				gboolean _tmp3_;
				_tmp3_ = gee_tree_set_range_in_range (self, self->priv->set->priv->_last->key);
				_tmp2_ = !_tmp3_;
			}
			result = _tmp2_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			result = TRUE;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_BOUNDED:
		{
			GeeTreeSetNode* _tmp4_ = NULL;
			_tmp4_ = gee_tree_set_range_first (self);
			result = _tmp4_ == NULL;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static GeeTreeSetNode* gee_tree_set_range_first (GeeTreeSetRange* self) {
	GeeTreeSetNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (self->priv->type) {
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			result = NULL;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			result = self->priv->set->priv->_first;
			return result;
		}
		default:
		{
			GeeTreeSetNode* _tmp0_ = NULL;
			_tmp0_ = gee_tree_set_find_floor (self->priv->set, self->priv->after);
			result = _tmp0_;
			return result;
		}
	}
}


static GeeTreeSetNode* gee_tree_set_range_last (GeeTreeSetRange* self) {
	GeeTreeSetNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (self->priv->type) {
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			result = NULL;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			result = self->priv->set->priv->_last;
			return result;
		}
		default:
		{
			GeeTreeSetNode* _tmp0_ = NULL;
			_tmp0_ = gee_tree_set_find_lower (self->priv->set, self->priv->before);
			result = _tmp0_;
			return result;
		}
	}
}


static void gee_tree_set_value_range_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gee_tree_set_value_range_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gee_tree_set_range_unref (value->data[0].v_pointer);
	}
}


static void gee_tree_set_value_range_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_tree_set_range_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gee_tree_set_value_range_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gee_tree_set_value_range_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GeeTreeSetRange* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_tree_set_range_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gee_tree_set_value_range_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GeeTreeSetRange** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_tree_set_range_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* gee_tree_set_param_spec_range (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GeeTreeSetParamSpecRange* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_TREE_SET_TYPE_RANGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer gee_tree_set_value_get_range (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_TREE_SET_TYPE_RANGE), NULL);
	return value->data[0].v_pointer;
}


static void gee_tree_set_value_set_range (GValue* value, gpointer v_object) {
	GeeTreeSetRange* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_TREE_SET_TYPE_RANGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_TREE_SET_TYPE_RANGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_tree_set_range_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_tree_set_range_unref (old);
	}
}


static void gee_tree_set_value_take_range (GValue* value, gpointer v_object) {
	GeeTreeSetRange* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_TREE_SET_TYPE_RANGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_TREE_SET_TYPE_RANGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_tree_set_range_unref (old);
	}
}


static void gee_tree_set_range_class_init (GeeTreeSetRangeClass * klass) {
	gee_tree_set_range_parent_class = g_type_class_peek_parent (klass);
	GEE_TREE_SET_RANGE_CLASS (klass)->finalize = gee_tree_set_range_finalize;
	g_type_class_add_private (klass, sizeof (GeeTreeSetRangePrivate));
}


static void gee_tree_set_range_instance_init (GeeTreeSetRange * self) {
	self->priv = GEE_TREE_SET_RANGE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gee_tree_set_range_finalize (GeeTreeSetRange* obj) {
	GeeTreeSetRange * self;
	self = GEE_TREE_SET_RANGE (obj);
	_g_object_unref0 (self->priv->set);
	((self->priv->after == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->after = (self->priv->g_destroy_func (self->priv->after), NULL));
	((self->priv->before == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->before = (self->priv->g_destroy_func (self->priv->before), NULL));
}


static GType gee_tree_set_range_get_type (void) {
	static volatile gsize gee_tree_set_range_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_range_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gee_tree_set_value_range_init, gee_tree_set_value_range_free_value, gee_tree_set_value_range_copy_value, gee_tree_set_value_range_peek_pointer, "p", gee_tree_set_value_range_collect_value, "p", gee_tree_set_value_range_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetRangeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_range_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSetRange), 0, (GInstanceInitFunc) gee_tree_set_range_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gee_tree_set_range_type_id;
		gee_tree_set_range_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeeTreeSetRange", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gee_tree_set_range_type_id__volatile, gee_tree_set_range_type_id);
	}
	return gee_tree_set_range_type_id__volatile;
}


static gpointer gee_tree_set_range_ref (gpointer instance) {
	GeeTreeSetRange* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void gee_tree_set_range_unref (gpointer instance) {
	GeeTreeSetRange* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_TREE_SET_RANGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before) {
	GeeTreeSetSubSet * self = NULL;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange* _tmp1_ = NULL;
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeTreeSetSubSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (set);
	_g_object_unref0 (self->priv->set);
	self->priv->set = _tmp0_;
	_tmp1_ = gee_tree_set_range_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, set, after, before);
	_gee_tree_set_range_unref0 (self->priv->range);
	self->priv->range = _tmp1_;
	return self;
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before) {
	return gee_tree_set_sub_set_construct (GEE_TREE_SET_TYPE_SUB_SET, g_type, g_dup_func, g_destroy_func, set, after, before);
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_head (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before) {
	GeeTreeSetSubSet * self = NULL;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange* _tmp1_ = NULL;
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeTreeSetSubSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (set);
	_g_object_unref0 (self->priv->set);
	self->priv->set = _tmp0_;
	_tmp1_ = gee_tree_set_range_new_head (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, set, before);
	_gee_tree_set_range_unref0 (self->priv->range);
	self->priv->range = _tmp1_;
	return self;
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_new_head (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before) {
	return gee_tree_set_sub_set_construct_head (GEE_TREE_SET_TYPE_SUB_SET, g_type, g_dup_func, g_destroy_func, set, before);
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_tail (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after) {
	GeeTreeSetSubSet * self = NULL;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange* _tmp1_ = NULL;
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeTreeSetSubSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (set);
	_g_object_unref0 (self->priv->set);
	self->priv->set = _tmp0_;
	_tmp1_ = gee_tree_set_range_new_tail (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, set, after);
	_gee_tree_set_range_unref0 (self->priv->range);
	self->priv->range = _tmp1_;
	return self;
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_new_tail (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after) {
	return gee_tree_set_sub_set_construct_tail (GEE_TREE_SET_TYPE_SUB_SET, g_type, g_dup_func, g_destroy_func, set, after);
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_from_range (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range) {
	GeeTreeSetSubSet * self = NULL;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange* _tmp1_;
	g_return_val_if_fail (set != NULL, NULL);
	g_return_val_if_fail (range != NULL, NULL);
	self = (GeeTreeSetSubSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (set);
	_g_object_unref0 (self->priv->set);
	self->priv->set = _tmp0_;
	_tmp1_ = _gee_tree_set_range_ref0 (range);
	_gee_tree_set_range_unref0 (self->priv->range);
	self->priv->range = _tmp1_;
	return self;
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_new_from_range (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range) {
	return gee_tree_set_sub_set_construct_from_range (GEE_TREE_SET_TYPE_SUB_SET, g_type, g_dup_func, g_destroy_func, set, range);
}


static gboolean gee_tree_set_sub_set_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	self = (GeeTreeSetSubSet*) base;
	_tmp1_ = gee_tree_set_range_in_range (self->priv->range, item);
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->set, item);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean gee_tree_set_sub_set_real_add (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	self = (GeeTreeSetSubSet*) base;
	_tmp1_ = gee_tree_set_range_in_range (self->priv->range, item);
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->set, item);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean gee_tree_set_sub_set_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	self = (GeeTreeSetSubSet*) base;
	_tmp1_ = gee_tree_set_range_in_range (self->priv->range, item);
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->set, item);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void gee_tree_set_sub_set_real_clear (GeeAbstractCollection* base) {
	GeeTreeSetSubSet * self;
	GeeIterator* _tmp0_ = NULL;
	GeeIterator* iter;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
	iter = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_;
		_tmp1_ = gee_iterator_next (iter);
		if (!_tmp1_) {
			break;
		}
		gee_iterator_remove (iter);
	}
	_g_object_unref0 (iter);
}


static GeeIterator* gee_tree_set_sub_set_real_iterator (GeeAbstractCollection* base) {
	GeeTreeSetSubSet * self;
	GeeIterator* result = NULL;
	GeeTreeSetSubIterator* _tmp0_ = NULL;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_tree_set_sub_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, self->priv->range);
	result = (GeeIterator*) _tmp0_;
	return result;
}


static GeeBidirIterator* gee_tree_set_sub_set_real_bidir_iterator (GeeSortedSet* base) {
	GeeTreeSetSubSet * self;
	GeeBidirIterator* result = NULL;
	GeeTreeSetSubIterator* _tmp0_ = NULL;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_tree_set_sub_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, self->priv->range);
	result = (GeeBidirIterator*) _tmp0_;
	return result;
}


static gpointer gee_tree_set_sub_set_real_first (GeeSortedSet* base) {
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	GeeTreeSetNode* _tmp0_ = NULL;
	GeeTreeSetNode* _first;
	gpointer _tmp1_;
	gconstpointer _tmp2_;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_tree_set_range_first (self->priv->range);
	_first = _tmp0_;
	g_assert (_first != NULL);
	_tmp1_ = (_tmp2_ = _first->key, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_));
	result = _tmp1_;
	return result;
}


static gpointer gee_tree_set_sub_set_real_last (GeeSortedSet* base) {
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	GeeTreeSetNode* _tmp0_ = NULL;
	GeeTreeSetNode* _last;
	gpointer _tmp1_;
	gconstpointer _tmp2_;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_tree_set_range_last (self->priv->range);
	_last = _tmp0_;
	g_assert (_last != NULL);
	_tmp1_ = (_tmp2_ = _last->key, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_));
	result = _tmp1_;
	return result;
}


static GeeSortedSet* gee_tree_set_sub_set_real_head_set (GeeSortedSet* base, gconstpointer before) {
	GeeTreeSetSubSet * self;
	GeeSortedSet* result = NULL;
	GeeTreeSetRange* _tmp0_ = NULL;
	GeeTreeSetRange* _tmp1_;
	GeeTreeSetSubSet* _tmp2_ = NULL;
	GeeSortedSet* _tmp3_;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_tree_set_range_cut_tail (self->priv->range, before);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_tree_set_sub_set_new_from_range (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, _tmp1_);
	_tmp3_ = (GeeSortedSet*) _tmp2_;
	_gee_tree_set_range_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static GeeSortedSet* gee_tree_set_sub_set_real_tail_set (GeeSortedSet* base, gconstpointer after) {
	GeeTreeSetSubSet * self;
	GeeSortedSet* result = NULL;
	GeeTreeSetRange* _tmp0_ = NULL;
	GeeTreeSetRange* _tmp1_;
	GeeTreeSetSubSet* _tmp2_ = NULL;
	GeeSortedSet* _tmp3_;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_tree_set_range_cut_head (self->priv->range, after);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_tree_set_sub_set_new_from_range (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, _tmp1_);
	_tmp3_ = (GeeSortedSet*) _tmp2_;
	_gee_tree_set_range_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static GeeSortedSet* gee_tree_set_sub_set_real_sub_set (GeeSortedSet* base, gconstpointer after, gconstpointer before) {
	GeeTreeSetSubSet * self;
	GeeSortedSet* result = NULL;
	GeeTreeSetRange* _tmp0_ = NULL;
	GeeTreeSetRange* _tmp1_;
	GeeTreeSetSubSet* _tmp2_ = NULL;
	GeeSortedSet* _tmp3_;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_tree_set_range_cut (self->priv->range, after, before);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_tree_set_sub_set_new_from_range (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, _tmp1_);
	_tmp3_ = (GeeSortedSet*) _tmp2_;
	_gee_tree_set_range_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static GeeBidirIterator* gee_tree_set_sub_set_real_iterator_at (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	GeeBidirIterator* result = NULL;
	gboolean _tmp0_;
	GeeTreeSetNode* _tmp1_ = NULL;
	GeeTreeSetNode* n;
	GeeTreeSetSubIterator* _tmp2_ = NULL;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_tree_set_range_in_range (self->priv->range, item);
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = gee_tree_set_find_node (self->priv->set, item);
	n = _tmp1_;
	if (n == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = gee_tree_set_sub_iterator_new_pointing (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, self->priv->range, n);
	result = (GeeBidirIterator*) _tmp2_;
	return result;
}


static gpointer gee_tree_set_sub_set_real_lower (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint res;
	gpointer _tmp2_ = NULL;
	gpointer l;
	gconstpointer _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gpointer _tmp6_;
	gconstpointer _tmp7_;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_tree_set_range_compare_range (self->priv->range, item);
	res = _tmp0_;
	if (res > 0) {
		gpointer _tmp1_ = NULL;
		_tmp1_ = gee_sorted_set_last ((GeeSortedSet*) self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = gee_sorted_set_lower ((GeeSortedSet*) self->priv->set, item);
	l = _tmp2_;
	if (l != NULL) {
		gboolean _tmp5_;
		_tmp5_ = gee_tree_set_range_in_range (self->priv->range, l);
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = l;
	} else {
		_tmp3_ = NULL;
	}
	_tmp6_ = (_tmp7_ = _tmp3_, ((_tmp7_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp7_) : self->priv->g_dup_func ((gpointer) _tmp7_));
	result = _tmp6_;
	((l == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (l = (self->priv->g_destroy_func (l), NULL));
	return result;
}


static gpointer gee_tree_set_sub_set_real_higher (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint res;
	gpointer _tmp2_ = NULL;
	gpointer h;
	gconstpointer _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gpointer _tmp6_;
	gconstpointer _tmp7_;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_tree_set_range_compare_range (self->priv->range, item);
	res = _tmp0_;
	if (res < 0) {
		gpointer _tmp1_ = NULL;
		_tmp1_ = gee_sorted_set_first ((GeeSortedSet*) self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = gee_sorted_set_higher ((GeeSortedSet*) self->priv->set, item);
	h = _tmp2_;
	if (h != NULL) {
		gboolean _tmp5_;
		_tmp5_ = gee_tree_set_range_in_range (self->priv->range, h);
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = h;
	} else {
		_tmp3_ = NULL;
	}
	_tmp6_ = (_tmp7_ = _tmp3_, ((_tmp7_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp7_) : self->priv->g_dup_func ((gpointer) _tmp7_));
	result = _tmp6_;
	((h == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (h = (self->priv->g_destroy_func (h), NULL));
	return result;
}


static gpointer gee_tree_set_sub_set_real_floor (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint res;
	gpointer _tmp2_ = NULL;
	gpointer l;
	gconstpointer _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gpointer _tmp6_;
	gconstpointer _tmp7_;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_tree_set_range_compare_range (self->priv->range, item);
	res = _tmp0_;
	if (res > 0) {
		gpointer _tmp1_ = NULL;
		_tmp1_ = gee_sorted_set_last ((GeeSortedSet*) self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = gee_sorted_set_floor ((GeeSortedSet*) self->priv->set, item);
	l = _tmp2_;
	if (l != NULL) {
		gboolean _tmp5_;
		_tmp5_ = gee_tree_set_range_in_range (self->priv->range, l);
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = l;
	} else {
		_tmp3_ = NULL;
	}
	_tmp6_ = (_tmp7_ = _tmp3_, ((_tmp7_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp7_) : self->priv->g_dup_func ((gpointer) _tmp7_));
	result = _tmp6_;
	((l == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (l = (self->priv->g_destroy_func (l), NULL));
	return result;
}


static gpointer gee_tree_set_sub_set_real_ceil (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint res;
	gpointer _tmp2_ = NULL;
	gpointer h;
	gconstpointer _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gpointer _tmp6_;
	gconstpointer _tmp7_;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_tree_set_range_compare_range (self->priv->range, item);
	res = _tmp0_;
	if (res < 0) {
		gpointer _tmp1_ = NULL;
		_tmp1_ = gee_sorted_set_first ((GeeSortedSet*) self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = gee_sorted_set_ceil ((GeeSortedSet*) self->priv->set, item);
	h = _tmp2_;
	if (h != NULL) {
		gboolean _tmp5_;
		_tmp5_ = gee_tree_set_range_in_range (self->priv->range, h);
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = h;
	} else {
		_tmp3_ = NULL;
	}
	_tmp6_ = (_tmp7_ = _tmp3_, ((_tmp7_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp7_) : self->priv->g_dup_func ((gpointer) _tmp7_));
	result = _tmp6_;
	((h == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (h = (self->priv->g_destroy_func (h), NULL));
	return result;
}


static gint gee_tree_set_sub_set_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeTreeSetSubSet* self;
	gint i;
	GeeIterator* _tmp0_ = NULL;
	GeeIterator* iterator;
	self = (GeeTreeSetSubSet*) base;
	i = 0;
	_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
	iterator = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_;
		_tmp1_ = gee_iterator_next (iterator);
		if (!_tmp1_) {
			break;
		}
		i++;
	}
	result = i;
	_g_object_unref0 (iterator);
	return result;
}


static gboolean gee_tree_set_sub_set_real_get_is_empty (GeeAbstractCollection* base) {
	gboolean result;
	GeeTreeSetSubSet* self;
	gboolean _tmp0_;
	self = (GeeTreeSetSubSet*) base;
	_tmp0_ = gee_tree_set_range_empty_subset (self->priv->range);
	result = _tmp0_;
	return result;
}


static void gee_tree_set_sub_set_class_init (GeeTreeSetSubSetClass * klass) {
	gee_tree_set_sub_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetSubSetPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_tree_set_sub_set_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_tree_set_sub_set_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_tree_set_sub_set_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_tree_set_sub_set_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_tree_set_sub_set_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_tree_set_sub_set_real_get_size;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_is_empty = gee_tree_set_sub_set_real_get_is_empty;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_tree_set_sub_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_tree_set_sub_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_sub_set_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_SIZE, "size");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_IS_EMPTY, "is-empty");
}


static void gee_tree_set_sub_set_gee_sorted_set_interface_init (GeeSortedSetIface * iface) {
	gee_tree_set_sub_set_gee_sorted_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->bidir_iterator = (GeeBidirIterator* (*)(GeeSortedSet*)) gee_tree_set_sub_set_real_bidir_iterator;
	iface->first = (gpointer (*)(GeeSortedSet*)) gee_tree_set_sub_set_real_first;
	iface->last = (gpointer (*)(GeeSortedSet*)) gee_tree_set_sub_set_real_last;
	iface->head_set = (GeeSortedSet* (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_sub_set_real_head_set;
	iface->tail_set = (GeeSortedSet* (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_sub_set_real_tail_set;
	iface->sub_set = (GeeSortedSet* (*)(GeeSortedSet* ,gconstpointer ,gconstpointer)) gee_tree_set_sub_set_real_sub_set;
	iface->iterator_at = (GeeBidirIterator* (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_sub_set_real_iterator_at;
	iface->lower = (gpointer (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_sub_set_real_lower;
	iface->higher = (gpointer (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_sub_set_real_higher;
	iface->floor = (gpointer (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_sub_set_real_floor;
	iface->ceil = (gpointer (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_sub_set_real_ceil;
}


static void gee_tree_set_sub_set_instance_init (GeeTreeSetSubSet * self) {
	self->priv = GEE_TREE_SET_SUB_SET_GET_PRIVATE (self);
}


static void gee_tree_set_sub_set_finalize (GObject* obj) {
	GeeTreeSetSubSet * self;
	self = GEE_TREE_SET_SUB_SET (obj);
	_g_object_unref0 (self->priv->set);
	_gee_tree_set_range_unref0 (self->priv->range);
	G_OBJECT_CLASS (gee_tree_set_sub_set_parent_class)->finalize (obj);
}


static GType gee_tree_set_sub_set_get_type (void) {
	static volatile gsize gee_tree_set_sub_set_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_sub_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetSubSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_sub_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSetSubSet), 0, (GInstanceInitFunc) gee_tree_set_sub_set_instance_init, NULL };
		static const GInterfaceInfo gee_sorted_set_info = { (GInterfaceInitFunc) gee_tree_set_sub_set_gee_sorted_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_tree_set_sub_set_type_id;
		gee_tree_set_sub_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_SET, "GeeTreeSetSubSet", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_sub_set_type_id, GEE_TYPE_SORTED_SET, &gee_sorted_set_info);
		g_once_init_leave (&gee_tree_set_sub_set_type_id__volatile, gee_tree_set_sub_set_type_id);
	}
	return gee_tree_set_sub_set_type_id__volatile;
}


static void _vala_gee_tree_set_sub_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSetSubSet * self;
	self = GEE_TREE_SET_SUB_SET (object);
	switch (property_id) {
		case GEE_TREE_SET_SUB_SET_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_TREE_SET_SUB_SET_IS_EMPTY:
		g_value_set_boolean (value, gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_tree_set_sub_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSetSubSet * self;
	self = GEE_TREE_SET_SUB_SET (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_SUB_SET_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_SUB_SET_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_SUB_SET_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range) {
	GeeTreeSetSubIterator * self = NULL;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange* _tmp1_;
	g_return_val_if_fail (set != NULL, NULL);
	g_return_val_if_fail (range != NULL, NULL);
	self = (GeeTreeSetSubIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (set);
	_g_object_unref0 (self->priv->set);
	self->priv->set = _tmp0_;
	_tmp1_ = _gee_tree_set_range_ref0 (range);
	_gee_tree_set_range_unref0 (self->priv->range);
	self->priv->range = _tmp1_;
	return self;
}


static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range) {
	return gee_tree_set_sub_iterator_construct (GEE_TREE_SET_TYPE_SUB_ITERATOR, g_type, g_dup_func, g_destroy_func, set, range);
}


static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_construct_pointing (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range, GeeTreeSetNode* node) {
	GeeTreeSetSubIterator * self = NULL;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange* _tmp1_;
	GeeTreeSetIterator* _tmp2_ = NULL;
	g_return_val_if_fail (set != NULL, NULL);
	g_return_val_if_fail (range != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	self = (GeeTreeSetSubIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (set);
	_g_object_unref0 (self->priv->set);
	self->priv->set = _tmp0_;
	_tmp1_ = _gee_tree_set_range_ref0 (range);
	_gee_tree_set_range_unref0 (self->priv->range);
	self->priv->range = _tmp1_;
	_tmp2_ = gee_tree_set_iterator_new_pointing (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, set, node);
	_g_object_unref0 (self->priv->iterator);
	self->priv->iterator = _tmp2_;
	return self;
}


static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_new_pointing (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range, GeeTreeSetNode* node) {
	return gee_tree_set_sub_iterator_construct_pointing (GEE_TREE_SET_TYPE_SUB_ITERATOR, g_type, g_dup_func, g_destroy_func, set, range, node);
}


static gboolean gee_tree_set_sub_iterator_real_next (GeeIterator* base) {
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetSubIterator*) base;
	if (self->priv->iterator != NULL) {
		gpointer next = NULL;
		gboolean _tmp0_ = FALSE;
		gpointer _tmp1_ = NULL;
		gboolean _tmp2_;
		_tmp2_ = gee_tree_set_iterator_safe_next_get (self->priv->iterator, &_tmp1_);
		((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
		next = _tmp1_;
		if (_tmp2_) {
			gboolean _tmp3_;
			_tmp3_ = gee_tree_set_range_in_range (self->priv->range, next);
			_tmp0_ = _tmp3_;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gboolean _tmp4_;
			_tmp4_ = gee_iterator_next ((GeeIterator*) self->priv->iterator);
			g_assert (_tmp4_);
			result = TRUE;
			((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
			return result;
		} else {
			result = FALSE;
			((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
			return result;
		}
		((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
	} else {
		gboolean _tmp5_;
		_tmp5_ = gee_iterator_first ((GeeIterator*) self);
		result = _tmp5_;
		return result;
	}
}


static gboolean gee_tree_set_sub_iterator_real_has_next (GeeIterator* base) {
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetSubIterator*) base;
	if (self->priv->iterator != NULL) {
		gpointer next = NULL;
		gboolean _tmp0_ = FALSE;
		gpointer _tmp1_ = NULL;
		gboolean _tmp2_;
		_tmp2_ = gee_tree_set_iterator_safe_next_get (self->priv->iterator, &_tmp1_);
		((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
		next = _tmp1_;
		if (_tmp2_) {
			gboolean _tmp3_;
			_tmp3_ = gee_tree_set_range_in_range (self->priv->range, next);
			_tmp0_ = _tmp3_;
		} else {
			_tmp0_ = FALSE;
		}
		result = _tmp0_;
		((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
		return result;
	} else {
		GeeTreeSetNode* _tmp4_ = NULL;
		_tmp4_ = gee_tree_set_range_first (self->priv->range);
		result = _tmp4_ != NULL;
		return result;
	}
}


static gboolean gee_tree_set_sub_iterator_real_first (GeeIterator* base) {
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	GeeTreeSetNode* _tmp0_ = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetIterator* _tmp1_ = NULL;
	self = (GeeTreeSetSubIterator*) base;
	_tmp0_ = gee_tree_set_range_first (self->priv->range);
	node = _tmp0_;
	if (node == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = gee_tree_set_iterator_new_pointing (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, node);
	_g_object_unref0 (self->priv->iterator);
	self->priv->iterator = _tmp1_;
	result = TRUE;
	return result;
}


static gboolean gee_tree_set_sub_iterator_real_previous (GeeBidirIterator* base) {
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	gpointer prev = NULL;
	gboolean _tmp0_ = FALSE;
	gpointer _tmp1_ = NULL;
	gboolean _tmp2_;
	self = (GeeTreeSetSubIterator*) base;
	if (self->priv->iterator == NULL) {
		result = FALSE;
		return result;
	}
	_tmp2_ = gee_tree_set_iterator_safe_previous_get (self->priv->iterator, &_tmp1_);
	((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
	prev = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = gee_tree_set_range_in_range (self->priv->range, prev);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp4_;
		_tmp4_ = gee_bidir_iterator_previous ((GeeBidirIterator*) self->priv->iterator);
		g_assert (_tmp4_);
		result = TRUE;
		((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
		return result;
	} else {
		result = FALSE;
		((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
		return result;
	}
	((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
}


static gboolean gee_tree_set_sub_iterator_real_has_previous (GeeBidirIterator* base) {
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	gpointer prev = NULL;
	gboolean _tmp0_ = FALSE;
	gpointer _tmp1_ = NULL;
	gboolean _tmp2_;
	self = (GeeTreeSetSubIterator*) base;
	if (self->priv->iterator == NULL) {
		result = FALSE;
		return result;
	}
	_tmp2_ = gee_tree_set_iterator_safe_previous_get (self->priv->iterator, &_tmp1_);
	((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
	prev = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = gee_tree_set_range_in_range (self->priv->range, prev);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
	return result;
}


static gboolean gee_tree_set_sub_iterator_real_last (GeeBidirIterator* base) {
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	GeeTreeSetNode* _tmp0_ = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetIterator* _tmp1_ = NULL;
	self = (GeeTreeSetSubIterator*) base;
	_tmp0_ = gee_tree_set_range_last (self->priv->range);
	node = _tmp0_;
	if (node == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = gee_tree_set_iterator_new_pointing (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, node);
	_g_object_unref0 (self->priv->iterator);
	self->priv->iterator = _tmp1_;
	result = TRUE;
	return result;
}


static gpointer gee_tree_set_sub_iterator_real_get (GeeIterator* base) {
	GeeTreeSetSubIterator * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	self = (GeeTreeSetSubIterator*) base;
	g_assert (self->priv->iterator != NULL);
	_tmp0_ = gee_iterator_get ((GeeIterator*) self->priv->iterator);
	result = _tmp0_;
	return result;
}


static void gee_tree_set_sub_iterator_real_remove (GeeIterator* base) {
	GeeTreeSetSubIterator * self;
	self = (GeeTreeSetSubIterator*) base;
	g_assert (self->priv->iterator != NULL);
	gee_iterator_remove ((GeeIterator*) self->priv->iterator);
}


static void gee_tree_set_sub_iterator_class_init (GeeTreeSetSubIteratorClass * klass) {
	gee_tree_set_sub_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetSubIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_tree_set_sub_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_tree_set_sub_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_sub_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_tree_set_sub_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_tree_set_sub_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(GeeIterator*)) gee_tree_set_sub_iterator_real_next;
	iface->has_next = (gboolean (*)(GeeIterator*)) gee_tree_set_sub_iterator_real_has_next;
	iface->first = (gboolean (*)(GeeIterator*)) gee_tree_set_sub_iterator_real_first;
	iface->get = (gpointer (*)(GeeIterator*)) gee_tree_set_sub_iterator_real_get;
	iface->remove = (void (*)(GeeIterator*)) gee_tree_set_sub_iterator_real_remove;
}


static void gee_tree_set_sub_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
	gee_tree_set_sub_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->previous = (gboolean (*)(GeeBidirIterator*)) gee_tree_set_sub_iterator_real_previous;
	iface->has_previous = (gboolean (*)(GeeBidirIterator*)) gee_tree_set_sub_iterator_real_has_previous;
	iface->last = (gboolean (*)(GeeBidirIterator*)) gee_tree_set_sub_iterator_real_last;
}


static void gee_tree_set_sub_iterator_instance_init (GeeTreeSetSubIterator * self) {
	self->priv = GEE_TREE_SET_SUB_ITERATOR_GET_PRIVATE (self);
	self->priv->iterator = NULL;
}


static void gee_tree_set_sub_iterator_finalize (GObject* obj) {
	GeeTreeSetSubIterator * self;
	self = GEE_TREE_SET_SUB_ITERATOR (obj);
	_g_object_unref0 (self->priv->set);
	_gee_tree_set_range_unref0 (self->priv->range);
	_g_object_unref0 (self->priv->iterator);
	G_OBJECT_CLASS (gee_tree_set_sub_iterator_parent_class)->finalize (obj);
}


static GType gee_tree_set_sub_iterator_get_type (void) {
	static volatile gsize gee_tree_set_sub_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_sub_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetSubIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_sub_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSetSubIterator), 0, (GInstanceInitFunc) gee_tree_set_sub_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_tree_set_sub_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_tree_set_sub_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_tree_set_sub_iterator_type_id;
		gee_tree_set_sub_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeTreeSetSubIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_sub_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_tree_set_sub_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_once_init_leave (&gee_tree_set_sub_iterator_type_id__volatile, gee_tree_set_sub_iterator_type_id);
	}
	return gee_tree_set_sub_iterator_type_id__volatile;
}


static void _vala_gee_tree_set_sub_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSetSubIterator * self;
	self = GEE_TREE_SET_SUB_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_tree_set_sub_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSetSubIterator * self;
	self = GEE_TREE_SET_SUB_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_SUB_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_SUB_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_SUB_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_tree_set_class_init (GeeTreeSetClass * klass) {
	gee_tree_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_tree_set_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_tree_set_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_tree_set_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_tree_set_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_tree_set_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_tree_set_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_tree_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_tree_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SIZE, "size");
	/**
	 * The elements' comparator function.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_COMPARE_FUNC, g_param_spec_pointer ("compare-func", "compare-func", "compare-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_tree_set_gee_sorted_set_interface_init (GeeSortedSetIface * iface) {
	gee_tree_set_gee_sorted_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->bidir_iterator = (GeeBidirIterator* (*)(GeeSortedSet*)) gee_tree_set_real_bidir_iterator;
	iface->first = (gpointer (*)(GeeSortedSet*)) gee_tree_set_real_first;
	iface->last = (gpointer (*)(GeeSortedSet*)) gee_tree_set_real_last;
	iface->head_set = (GeeSortedSet* (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_real_head_set;
	iface->tail_set = (GeeSortedSet* (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_real_tail_set;
	iface->sub_set = (GeeSortedSet* (*)(GeeSortedSet* ,gconstpointer ,gconstpointer)) gee_tree_set_real_sub_set;
	iface->iterator_at = (GeeBidirIterator* (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_real_iterator_at;
	iface->lower = (gpointer (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_real_lower;
	iface->higher = (gpointer (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_real_higher;
	iface->floor = (gpointer (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_real_floor;
	iface->ceil = (gpointer (*)(GeeSortedSet* ,gconstpointer)) gee_tree_set_real_ceil;
}


static void gee_tree_set_instance_init (GeeTreeSet * self) {
	self->priv = GEE_TREE_SET_GET_PRIVATE (self);
	self->priv->_size = 0;
	self->priv->root = NULL;
	self->priv->_first = NULL;
	self->priv->_last = NULL;
	self->priv->stamp = 0;
}


static void gee_tree_set_finalize (GObject* obj) {
	GeeTreeSet * self;
	self = GEE_TREE_SET (obj);
	_gee_tree_set_node_free0 (self->priv->root);
	G_OBJECT_CLASS (gee_tree_set_parent_class)->finalize (obj);
}


/**
 * Left-leaning red-black tree implementation of the {@link Set} interface.
 *
 * This implementation is especially well designed for large quantity of
 * data. The (balanced) tree implementation insure that the set and get
 * methods are in logarithmic complexity. For a linear implementation see
 * {@link HashSet}.
 *
 * @see HashSet
 */
GType gee_tree_set_get_type (void) {
	static volatile gsize gee_tree_set_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSet), 0, (GInstanceInitFunc) gee_tree_set_instance_init, NULL };
		static const GInterfaceInfo gee_sorted_set_info = { (GInterfaceInitFunc) gee_tree_set_gee_sorted_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_tree_set_type_id;
		gee_tree_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_SET, "GeeTreeSet", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_type_id, GEE_TYPE_SORTED_SET, &gee_sorted_set_info);
		g_once_init_leave (&gee_tree_set_type_id__volatile, gee_tree_set_type_id);
	}
	return gee_tree_set_type_id__volatile;
}


static void _vala_gee_tree_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSet * self;
	self = GEE_TREE_SET (object);
	switch (property_id) {
		case GEE_TREE_SET_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_TREE_SET_COMPARE_FUNC:
		g_value_set_pointer (value, gee_tree_set_get_compare_func (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_tree_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSet * self;
	self = GEE_TREE_SET (object);
	switch (property_id) {
		case GEE_TREE_SET_COMPARE_FUNC:
		gee_tree_set_set_compare_func (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}



