/* set.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

/**
 * A collection without duplicate elements.
 */
public interface Gee.Set<G> : Collection<G> {

	/**
	 * The read-only view of this set.
	 */
	public abstract new Set<G> read_only_view { owned get; }

	/**
	 * Returns an immutable empty set.
	 *
	 * @return an immutable empty set
	 */
	public static Set<G> empty<G> () {
		return new HashSet<G> ().read_only_view;
	}
}

