// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Cancellable;
use Error;
#[cfg(any(feature = "v2_44", feature = "dox"))]
use NetworkConnectivity;
use SocketConnectable;
use ffi;
#[cfg(feature = "futures")]
use futures_core;
use glib;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct NetworkMonitor(Object<ffi::GNetworkMonitor, ffi::GNetworkMonitorInterface>);

    match fn {
        get_type => || ffi::g_network_monitor_get_type(),
    }
}

impl NetworkMonitor {
    pub fn get_default() -> Option<NetworkMonitor> {
        unsafe {
            from_glib_none(ffi::g_network_monitor_get_default())
        }
    }
}

pub trait NetworkMonitorExt: Sized {
    fn can_reach<'a, P: IsA<SocketConnectable>, Q: Into<Option<&'a Cancellable>>>(&self, connectable: &P, cancellable: Q) -> Result<(), Error>;

    fn can_reach_async<'a, P: IsA<SocketConnectable>, Q: Into<Option<&'a Cancellable>>, R: FnOnce(Result<(), Error>) + Send + 'static>(&self, connectable: &P, cancellable: Q, callback: R);

    #[cfg(feature = "futures")]
    fn can_reach_async_future<P: IsA<SocketConnectable> + Clone + 'static>(&self, connectable: &P) -> Box_<futures_core::Future<Item = (Self, ()), Error = (Self, Error)>>;

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn get_connectivity(&self) -> NetworkConnectivity;

    fn get_network_available(&self) -> bool;

    #[cfg(any(feature = "v2_46", feature = "dox"))]
    fn get_network_metered(&self) -> bool;

    fn connect_network_changed<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn connect_property_connectivity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_network_available_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_46", feature = "dox"))]
    fn connect_property_network_metered_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<NetworkMonitor> + IsA<glib::object::Object> + Clone + 'static> NetworkMonitorExt for O {
    fn can_reach<'a, P: IsA<SocketConnectable>, Q: Into<Option<&'a Cancellable>>>(&self, connectable: &P, cancellable: Q) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_network_monitor_can_reach(self.to_glib_none().0, connectable.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn can_reach_async<'a, P: IsA<SocketConnectable>, Q: Into<Option<&'a Cancellable>>, R: FnOnce(Result<(), Error>) + Send + 'static>(&self, connectable: &P, cancellable: Q, callback: R) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<R>> = Box::new(Box::new(callback));
        unsafe extern "C" fn can_reach_async_trampoline<R: FnOnce(Result<(), Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            let mut error = ptr::null_mut();
            let _ = ffi::g_network_monitor_can_reach_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<R>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = can_reach_async_trampoline::<R>;
        unsafe {
            ffi::g_network_monitor_can_reach_async(self.to_glib_none().0, connectable.to_glib_none().0, cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    #[cfg(feature = "futures")]
    fn can_reach_async_future<P: IsA<SocketConnectable> + Clone + 'static>(&self, connectable: &P) -> Box_<futures_core::Future<Item = (Self, ()), Error = (Self, Error)>> {
        use GioFuture;
        use fragile::Fragile;

        let connectable = connectable.clone();
        GioFuture::new(self, move |obj, send| {
            let cancellable = Cancellable::new();
            let send = Fragile::new(send);
            let obj_clone = Fragile::new(obj.clone());
            obj.can_reach_async(
                 &connectable,
                 Some(&cancellable),
                 move |res| {
                     let obj = obj_clone.into_inner();
                     let res = res.map(|v| (obj.clone(), v)).map_err(|v| (obj.clone(), v));
                     let _ = send.into_inner().send(res);
                 },
            );

            cancellable
        })
    }

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn get_connectivity(&self) -> NetworkConnectivity {
        unsafe {
            from_glib(ffi::g_network_monitor_get_connectivity(self.to_glib_none().0))
        }
    }

    fn get_network_available(&self) -> bool {
        unsafe {
            from_glib(ffi::g_network_monitor_get_network_available(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_46", feature = "dox"))]
    fn get_network_metered(&self) -> bool {
        unsafe {
            from_glib(ffi::g_network_monitor_get_network_metered(self.to_glib_none().0))
        }
    }

    fn connect_network_changed<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, bool) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "network-changed",
                transmute(network_changed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn connect_property_connectivity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::connectivity",
                transmute(notify_connectivity_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_network_available_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::network-available",
                transmute(notify_network_available_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v2_46", feature = "dox"))]
    fn connect_property_network_metered_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::network-metered",
                transmute(notify_network_metered_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn network_changed_trampoline<P>(this: *mut ffi::GNetworkMonitor, network_available: glib_ffi::gboolean, f: glib_ffi::gpointer)
where P: IsA<NetworkMonitor> {
    let f: &&(Fn(&P, bool) + 'static) = transmute(f);
    f(&NetworkMonitor::from_glib_borrow(this).downcast_unchecked(), from_glib(network_available))
}

#[cfg(any(feature = "v2_44", feature = "dox"))]
unsafe extern "C" fn notify_connectivity_trampoline<P>(this: *mut ffi::GNetworkMonitor, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<NetworkMonitor> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&NetworkMonitor::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_network_available_trampoline<P>(this: *mut ffi::GNetworkMonitor, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<NetworkMonitor> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&NetworkMonitor::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v2_46", feature = "dox"))]
unsafe extern "C" fn notify_network_metered_trampoline<P>(this: *mut ffi::GNetworkMonitor, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<NetworkMonitor> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&NetworkMonitor::from_glib_borrow(this).downcast_unchecked())
}
