/*
 * xmlunicode.c: this module implements the Unicode character APIs
 *
 * This file is automatically generated from the
 * UCS description files of the Unicode Character Database
 * http://www.unicode.org/Public/3.1-Update/UnicodeCharacterDatabase-3.1.0.html
 * using the genUnicode.py Python script.
 *
 * Generation date: Mon Aug 25 10:45:50 2003
 * Sources: Blocks-4.txt UnicodeData-3.1.0.txt
 * Daniel Veillard <veillard@redhat.com>
 */

#define IN_LIBXML
#include "libxml.h"

#ifdef LIBXML_UNICODE_ENABLED

#include <string.h>
#include <libxml/xmlversion.h>
#include <libxml/xmlunicode.h>

/**
 * xmlUCSIsAlphabeticPresentationForms:
 * @code: UCS code point
 *
 * Check whether the character is part of AlphabeticPresentationForms UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsAlphabeticPresentationForms(int code) {
    return((code >= 0xFB00) && (code <= 0xFB4F));
}

/**
 * xmlUCSIsArabic:
 * @code: UCS code point
 *
 * Check whether the character is part of Arabic UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsArabic(int code) {
    return((code >= 0x0600) && (code <= 0x06FF));
}

/**
 * xmlUCSIsArabicPresentationFormsA:
 * @code: UCS code point
 *
 * Check whether the character is part of ArabicPresentationForms-A UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsArabicPresentationFormsA(int code) {
    return((code >= 0xFB50) && (code <= 0xFDFF));
}

/**
 * xmlUCSIsArabicPresentationFormsB:
 * @code: UCS code point
 *
 * Check whether the character is part of ArabicPresentationForms-B UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsArabicPresentationFormsB(int code) {
    return((code >= 0xFE70) && (code <= 0xFEFE));
}

/**
 * xmlUCSIsArmenian:
 * @code: UCS code point
 *
 * Check whether the character is part of Armenian UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsArmenian(int code) {
    return((code >= 0x0530) && (code <= 0x058F));
}

/**
 * xmlUCSIsArrows:
 * @code: UCS code point
 *
 * Check whether the character is part of Arrows UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsArrows(int code) {
    return((code >= 0x2190) && (code <= 0x21FF));
}

/**
 * xmlUCSIsBasicLatin:
 * @code: UCS code point
 *
 * Check whether the character is part of BasicLatin UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsBasicLatin(int code) {
    return((code >= 0x0000) && (code <= 0x007F));
}

/**
 * xmlUCSIsBengali:
 * @code: UCS code point
 *
 * Check whether the character is part of Bengali UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsBengali(int code) {
    return((code >= 0x0980) && (code <= 0x09FF));
}

/**
 * xmlUCSIsBlockElements:
 * @code: UCS code point
 *
 * Check whether the character is part of BlockElements UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsBlockElements(int code) {
    return((code >= 0x2580) && (code <= 0x259F));
}

/**
 * xmlUCSIsBopomofo:
 * @code: UCS code point
 *
 * Check whether the character is part of Bopomofo UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsBopomofo(int code) {
    return((code >= 0x3100) && (code <= 0x312F));
}

/**
 * xmlUCSIsBopomofoExtended:
 * @code: UCS code point
 *
 * Check whether the character is part of BopomofoExtended UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsBopomofoExtended(int code) {
    return((code >= 0x31A0) && (code <= 0x31BF));
}

/**
 * xmlUCSIsBoxDrawing:
 * @code: UCS code point
 *
 * Check whether the character is part of BoxDrawing UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsBoxDrawing(int code) {
    return((code >= 0x2500) && (code <= 0x257F));
}

/**
 * xmlUCSIsBraillePatterns:
 * @code: UCS code point
 *
 * Check whether the character is part of BraillePatterns UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsBraillePatterns(int code) {
    return((code >= 0x2800) && (code <= 0x28FF));
}

/**
 * xmlUCSIsByzantineMusicalSymbols:
 * @code: UCS code point
 *
 * Check whether the character is part of ByzantineMusicalSymbols UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsByzantineMusicalSymbols(int code) {
    return((code >= 0x1D000) && (code <= 0x1D0FF));
}

/**
 * xmlUCSIsCJKCompatibility:
 * @code: UCS code point
 *
 * Check whether the character is part of CJKCompatibility UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCJKCompatibility(int code) {
    return((code >= 0x3300) && (code <= 0x33FF));
}

/**
 * xmlUCSIsCJKCompatibilityForms:
 * @code: UCS code point
 *
 * Check whether the character is part of CJKCompatibilityForms UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCJKCompatibilityForms(int code) {
    return((code >= 0xFE30) && (code <= 0xFE4F));
}

/**
 * xmlUCSIsCJKCompatibilityIdeographs:
 * @code: UCS code point
 *
 * Check whether the character is part of CJKCompatibilityIdeographs UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCJKCompatibilityIdeographs(int code) {
    return((code >= 0xF900) && (code <= 0xFAFF));
}

/**
 * xmlUCSIsCJKCompatibilityIdeographsSupplement:
 * @code: UCS code point
 *
 * Check whether the character is part of CJKCompatibilityIdeographsSupplement UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCJKCompatibilityIdeographsSupplement(int code) {
    return((code >= 0x2F800) && (code <= 0x2FA1F));
}

/**
 * xmlUCSIsCJKRadicalsSupplement:
 * @code: UCS code point
 *
 * Check whether the character is part of CJKRadicalsSupplement UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCJKRadicalsSupplement(int code) {
    return((code >= 0x2E80) && (code <= 0x2EFF));
}

/**
 * xmlUCSIsCJKSymbolsandPunctuation:
 * @code: UCS code point
 *
 * Check whether the character is part of CJKSymbolsandPunctuation UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCJKSymbolsandPunctuation(int code) {
    return((code >= 0x3000) && (code <= 0x303F));
}

/**
 * xmlUCSIsCJKUnifiedIdeographs:
 * @code: UCS code point
 *
 * Check whether the character is part of CJKUnifiedIdeographs UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCJKUnifiedIdeographs(int code) {
    return((code >= 0x4E00) && (code <= 0x9FFF));
}

/**
 * xmlUCSIsCJKUnifiedIdeographsExtensionA:
 * @code: UCS code point
 *
 * Check whether the character is part of CJKUnifiedIdeographsExtensionA UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCJKUnifiedIdeographsExtensionA(int code) {
    return((code >= 0x3400) && (code <= 0x4DB5));
}

/**
 * xmlUCSIsCJKUnifiedIdeographsExtensionB:
 * @code: UCS code point
 *
 * Check whether the character is part of CJKUnifiedIdeographsExtensionB UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCJKUnifiedIdeographsExtensionB(int code) {
    return((code >= 0x20000) && (code <= 0x2A6D6));
}

/**
 * xmlUCSIsCherokee:
 * @code: UCS code point
 *
 * Check whether the character is part of Cherokee UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCherokee(int code) {
    return((code >= 0x13A0) && (code <= 0x13FF));
}

/**
 * xmlUCSIsCombiningDiacriticalMarks:
 * @code: UCS code point
 *
 * Check whether the character is part of CombiningDiacriticalMarks UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCombiningDiacriticalMarks(int code) {
    return((code >= 0x0300) && (code <= 0x036F));
}

/**
 * xmlUCSIsCombiningHalfMarks:
 * @code: UCS code point
 *
 * Check whether the character is part of CombiningHalfMarks UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCombiningHalfMarks(int code) {
    return((code >= 0xFE20) && (code <= 0xFE2F));
}

/**
 * xmlUCSIsCombiningMarksforSymbols:
 * @code: UCS code point
 *
 * Check whether the character is part of CombiningMarksforSymbols UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCombiningMarksforSymbols(int code) {
    return((code >= 0x20D0) && (code <= 0x20FF));
}

/**
 * xmlUCSIsControlPictures:
 * @code: UCS code point
 *
 * Check whether the character is part of ControlPictures UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsControlPictures(int code) {
    return((code >= 0x2400) && (code <= 0x243F));
}

/**
 * xmlUCSIsCurrencySymbols:
 * @code: UCS code point
 *
 * Check whether the character is part of CurrencySymbols UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCurrencySymbols(int code) {
    return((code >= 0x20A0) && (code <= 0x20CF));
}

/**
 * xmlUCSIsCyrillic:
 * @code: UCS code point
 *
 * Check whether the character is part of Cyrillic UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCyrillic(int code) {
    return((code >= 0x0400) && (code <= 0x04FF));
}

/**
 * xmlUCSIsDeseret:
 * @code: UCS code point
 *
 * Check whether the character is part of Deseret UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsDeseret(int code) {
    return((code >= 0x10400) && (code <= 0x1044F));
}

/**
 * xmlUCSIsDevanagari:
 * @code: UCS code point
 *
 * Check whether the character is part of Devanagari UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsDevanagari(int code) {
    return((code >= 0x0900) && (code <= 0x097F));
}

/**
 * xmlUCSIsDingbats:
 * @code: UCS code point
 *
 * Check whether the character is part of Dingbats UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsDingbats(int code) {
    return((code >= 0x2700) && (code <= 0x27BF));
}

/**
 * xmlUCSIsEnclosedAlphanumerics:
 * @code: UCS code point
 *
 * Check whether the character is part of EnclosedAlphanumerics UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsEnclosedAlphanumerics(int code) {
    return((code >= 0x2460) && (code <= 0x24FF));
}

/**
 * xmlUCSIsEnclosedCJKLettersandMonths:
 * @code: UCS code point
 *
 * Check whether the character is part of EnclosedCJKLettersandMonths UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsEnclosedCJKLettersandMonths(int code) {
    return((code >= 0x3200) && (code <= 0x32FF));
}

/**
 * xmlUCSIsEthiopic:
 * @code: UCS code point
 *
 * Check whether the character is part of Ethiopic UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsEthiopic(int code) {
    return((code >= 0x1200) && (code <= 0x137F));
}

/**
 * xmlUCSIsGeneralPunctuation:
 * @code: UCS code point
 *
 * Check whether the character is part of GeneralPunctuation UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsGeneralPunctuation(int code) {
    return((code >= 0x2000) && (code <= 0x206F));
}

/**
 * xmlUCSIsGeometricShapes:
 * @code: UCS code point
 *
 * Check whether the character is part of GeometricShapes UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsGeometricShapes(int code) {
    return((code >= 0x25A0) && (code <= 0x25FF));
}

/**
 * xmlUCSIsGeorgian:
 * @code: UCS code point
 *
 * Check whether the character is part of Georgian UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsGeorgian(int code) {
    return((code >= 0x10A0) && (code <= 0x10FF));
}

/**
 * xmlUCSIsGothic:
 * @code: UCS code point
 *
 * Check whether the character is part of Gothic UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsGothic(int code) {
    return((code >= 0x10330) && (code <= 0x1034F));
}

/**
 * xmlUCSIsGreek:
 * @code: UCS code point
 *
 * Check whether the character is part of Greek UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsGreek(int code) {
    return((code >= 0x0370) && (code <= 0x03FF));
}

/**
 * xmlUCSIsGreekExtended:
 * @code: UCS code point
 *
 * Check whether the character is part of GreekExtended UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsGreekExtended(int code) {
    return((code >= 0x1F00) && (code <= 0x1FFF));
}

/**
 * xmlUCSIsGujarati:
 * @code: UCS code point
 *
 * Check whether the character is part of Gujarati UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsGujarati(int code) {
    return((code >= 0x0A80) && (code <= 0x0AFF));
}

/**
 * xmlUCSIsGurmukhi:
 * @code: UCS code point
 *
 * Check whether the character is part of Gurmukhi UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsGurmukhi(int code) {
    return((code >= 0x0A00) && (code <= 0x0A7F));
}

/**
 * xmlUCSIsHalfwidthandFullwidthForms:
 * @code: UCS code point
 *
 * Check whether the character is part of HalfwidthandFullwidthForms UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsHalfwidthandFullwidthForms(int code) {
    return((code >= 0xFF00) && (code <= 0xFFEF));
}

/**
 * xmlUCSIsHangulCompatibilityJamo:
 * @code: UCS code point
 *
 * Check whether the character is part of HangulCompatibilityJamo UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsHangulCompatibilityJamo(int code) {
    return((code >= 0x3130) && (code <= 0x318F));
}

/**
 * xmlUCSIsHangulJamo:
 * @code: UCS code point
 *
 * Check whether the character is part of HangulJamo UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsHangulJamo(int code) {
    return((code >= 0x1100) && (code <= 0x11FF));
}

/**
 * xmlUCSIsHangulSyllables:
 * @code: UCS code point
 *
 * Check whether the character is part of HangulSyllables UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsHangulSyllables(int code) {
    return((code >= 0xAC00) && (code <= 0xD7A3));
}

/**
 * xmlUCSIsHebrew:
 * @code: UCS code point
 *
 * Check whether the character is part of Hebrew UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsHebrew(int code) {
    return((code >= 0x0590) && (code <= 0x05FF));
}

/**
 * xmlUCSIsHighPrivateUseSurrogates:
 * @code: UCS code point
 *
 * Check whether the character is part of HighPrivateUseSurrogates UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsHighPrivateUseSurrogates(int code) {
    return((code >= 0xDB80) && (code <= 0xDBFF));
}

/**
 * xmlUCSIsHighSurrogates:
 * @code: UCS code point
 *
 * Check whether the character is part of HighSurrogates UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsHighSurrogates(int code) {
    return((code >= 0xD800) && (code <= 0xDB7F));
}

/**
 * xmlUCSIsHiragana:
 * @code: UCS code point
 *
 * Check whether the character is part of Hiragana UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsHiragana(int code) {
    return((code >= 0x3040) && (code <= 0x309F));
}

/**
 * xmlUCSIsIPAExtensions:
 * @code: UCS code point
 *
 * Check whether the character is part of IPAExtensions UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsIPAExtensions(int code) {
    return((code >= 0x0250) && (code <= 0x02AF));
}

/**
 * xmlUCSIsIdeographicDescriptionCharacters:
 * @code: UCS code point
 *
 * Check whether the character is part of IdeographicDescriptionCharacters UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsIdeographicDescriptionCharacters(int code) {
    return((code >= 0x2FF0) && (code <= 0x2FFF));
}

/**
 * xmlUCSIsKanbun:
 * @code: UCS code point
 *
 * Check whether the character is part of Kanbun UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsKanbun(int code) {
    return((code >= 0x3190) && (code <= 0x319F));
}

/**
 * xmlUCSIsKangxiRadicals:
 * @code: UCS code point
 *
 * Check whether the character is part of KangxiRadicals UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsKangxiRadicals(int code) {
    return((code >= 0x2F00) && (code <= 0x2FDF));
}

/**
 * xmlUCSIsKannada:
 * @code: UCS code point
 *
 * Check whether the character is part of Kannada UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsKannada(int code) {
    return((code >= 0x0C80) && (code <= 0x0CFF));
}

/**
 * xmlUCSIsKatakana:
 * @code: UCS code point
 *
 * Check whether the character is part of Katakana UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsKatakana(int code) {
    return((code >= 0x30A0) && (code <= 0x30FF));
}

/**
 * xmlUCSIsKhmer:
 * @code: UCS code point
 *
 * Check whether the character is part of Khmer UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsKhmer(int code) {
    return((code >= 0x1780) && (code <= 0x17FF));
}

/**
 * xmlUCSIsLao:
 * @code: UCS code point
 *
 * Check whether the character is part of Lao UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsLao(int code) {
    return((code >= 0x0E80) && (code <= 0x0EFF));
}

/**
 * xmlUCSIsLatin1Supplement:
 * @code: UCS code point
 *
 * Check whether the character is part of Latin-1Supplement UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsLatin1Supplement(int code) {
    return((code >= 0x0080) && (code <= 0x00FF));
}

/**
 * xmlUCSIsLatinExtendedA:
 * @code: UCS code point
 *
 * Check whether the character is part of LatinExtended-A UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsLatinExtendedA(int code) {
    return((code >= 0x0100) && (code <= 0x017F));
}

/**
 * xmlUCSIsLatinExtendedB:
 * @code: UCS code point
 *
 * Check whether the character is part of LatinExtended-B UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsLatinExtendedB(int code) {
    return((code >= 0x0180) && (code <= 0x024F));
}

/**
 * xmlUCSIsLatinExtendedAdditional:
 * @code: UCS code point
 *
 * Check whether the character is part of LatinExtendedAdditional UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsLatinExtendedAdditional(int code) {
    return((code >= 0x1E00) && (code <= 0x1EFF));
}

/**
 * xmlUCSIsLetterlikeSymbols:
 * @code: UCS code point
 *
 * Check whether the character is part of LetterlikeSymbols UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsLetterlikeSymbols(int code) {
    return((code >= 0x2100) && (code <= 0x214F));
}

/**
 * xmlUCSIsLowSurrogates:
 * @code: UCS code point
 *
 * Check whether the character is part of LowSurrogates UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsLowSurrogates(int code) {
    return((code >= 0xDC00) && (code <= 0xDFFF));
}

/**
 * xmlUCSIsMalayalam:
 * @code: UCS code point
 *
 * Check whether the character is part of Malayalam UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsMalayalam(int code) {
    return((code >= 0x0D00) && (code <= 0x0D7F));
}

/**
 * xmlUCSIsMathematicalAlphanumericSymbols:
 * @code: UCS code point
 *
 * Check whether the character is part of MathematicalAlphanumericSymbols UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsMathematicalAlphanumericSymbols(int code) {
    return((code >= 0x1D400) && (code <= 0x1D7FF));
}

/**
 * xmlUCSIsMathematicalOperators:
 * @code: UCS code point
 *
 * Check whether the character is part of MathematicalOperators UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsMathematicalOperators(int code) {
    return((code >= 0x2200) && (code <= 0x22FF));
}

/**
 * xmlUCSIsMiscellaneousSymbols:
 * @code: UCS code point
 *
 * Check whether the character is part of MiscellaneousSymbols UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsMiscellaneousSymbols(int code) {
    return((code >= 0x2600) && (code <= 0x26FF));
}

/**
 * xmlUCSIsMiscellaneousTechnical:
 * @code: UCS code point
 *
 * Check whether the character is part of MiscellaneousTechnical UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsMiscellaneousTechnical(int code) {
    return((code >= 0x2300) && (code <= 0x23FF));
}

/**
 * xmlUCSIsMongolian:
 * @code: UCS code point
 *
 * Check whether the character is part of Mongolian UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsMongolian(int code) {
    return((code >= 0x1800) && (code <= 0x18AF));
}

/**
 * xmlUCSIsMusicalSymbols:
 * @code: UCS code point
 *
 * Check whether the character is part of MusicalSymbols UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsMusicalSymbols(int code) {
    return((code >= 0x1D100) && (code <= 0x1D1FF));
}

/**
 * xmlUCSIsMyanmar:
 * @code: UCS code point
 *
 * Check whether the character is part of Myanmar UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsMyanmar(int code) {
    return((code >= 0x1000) && (code <= 0x109F));
}

/**
 * xmlUCSIsNumberForms:
 * @code: UCS code point
 *
 * Check whether the character is part of NumberForms UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsNumberForms(int code) {
    return((code >= 0x2150) && (code <= 0x218F));
}

/**
 * xmlUCSIsOgham:
 * @code: UCS code point
 *
 * Check whether the character is part of Ogham UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsOgham(int code) {
    return((code >= 0x1680) && (code <= 0x169F));
}

/**
 * xmlUCSIsOldItalic:
 * @code: UCS code point
 *
 * Check whether the character is part of OldItalic UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsOldItalic(int code) {
    return((code >= 0x10300) && (code <= 0x1032F));
}

/**
 * xmlUCSIsOpticalCharacterRecognition:
 * @code: UCS code point
 *
 * Check whether the character is part of OpticalCharacterRecognition UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsOpticalCharacterRecognition(int code) {
    return((code >= 0x2440) && (code <= 0x245F));
}

/**
 * xmlUCSIsOriya:
 * @code: UCS code point
 *
 * Check whether the character is part of Oriya UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsOriya(int code) {
    return((code >= 0x0B00) && (code <= 0x0B7F));
}

/**
 * xmlUCSIsPrivateUse:
 * @code: UCS code point
 *
 * Check whether the character is part of PrivateUse UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsPrivateUse(int code) {
    return((code >= 0x100000) && (code <= 0x10FFFD));
}

/**
 * xmlUCSIsRunic:
 * @code: UCS code point
 *
 * Check whether the character is part of Runic UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsRunic(int code) {
    return((code >= 0x16A0) && (code <= 0x16FF));
}

/**
 * xmlUCSIsSinhala:
 * @code: UCS code point
 *
 * Check whether the character is part of Sinhala UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsSinhala(int code) {
    return((code >= 0x0D80) && (code <= 0x0DFF));
}

/**
 * xmlUCSIsSmallFormVariants:
 * @code: UCS code point
 *
 * Check whether the character is part of SmallFormVariants UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsSmallFormVariants(int code) {
    return((code >= 0xFE50) && (code <= 0xFE6F));
}

/**
 * xmlUCSIsSpacingModifierLetters:
 * @code: UCS code point
 *
 * Check whether the character is part of SpacingModifierLetters UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsSpacingModifierLetters(int code) {
    return((code >= 0x02B0) && (code <= 0x02FF));
}

/**
 * xmlUCSIsSpecials:
 * @code: UCS code point
 *
 * Check whether the character is part of Specials UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsSpecials(int code) {
    return((code >= 0xFFF0) && (code <= 0xFFFD));
}

/**
 * xmlUCSIsSuperscriptsandSubscripts:
 * @code: UCS code point
 *
 * Check whether the character is part of SuperscriptsandSubscripts UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsSuperscriptsandSubscripts(int code) {
    return((code >= 0x2070) && (code <= 0x209F));
}

/**
 * xmlUCSIsSyriac:
 * @code: UCS code point
 *
 * Check whether the character is part of Syriac UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsSyriac(int code) {
    return((code >= 0x0700) && (code <= 0x074F));
}

/**
 * xmlUCSIsTags:
 * @code: UCS code point
 *
 * Check whether the character is part of Tags UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsTags(int code) {
    return((code >= 0xE0000) && (code <= 0xE007F));
}

/**
 * xmlUCSIsTamil:
 * @code: UCS code point
 *
 * Check whether the character is part of Tamil UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsTamil(int code) {
    return((code >= 0x0B80) && (code <= 0x0BFF));
}

/**
 * xmlUCSIsTelugu:
 * @code: UCS code point
 *
 * Check whether the character is part of Telugu UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsTelugu(int code) {
    return((code >= 0x0C00) && (code <= 0x0C7F));
}

/**
 * xmlUCSIsThaana:
 * @code: UCS code point
 *
 * Check whether the character is part of Thaana UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsThaana(int code) {
    return((code >= 0x0780) && (code <= 0x07BF));
}

/**
 * xmlUCSIsThai:
 * @code: UCS code point
 *
 * Check whether the character is part of Thai UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsThai(int code) {
    return((code >= 0x0E00) && (code <= 0x0E7F));
}

/**
 * xmlUCSIsTibetan:
 * @code: UCS code point
 *
 * Check whether the character is part of Tibetan UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsTibetan(int code) {
    return((code >= 0x0F00) && (code <= 0x0FFF));
}

/**
 * xmlUCSIsUnifiedCanadianAboriginalSyllabics:
 * @code: UCS code point
 *
 * Check whether the character is part of UnifiedCanadianAboriginalSyllabics UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsUnifiedCanadianAboriginalSyllabics(int code) {
    return((code >= 0x1400) && (code <= 0x167F));
}

/**
 * xmlUCSIsYiRadicals:
 * @code: UCS code point
 *
 * Check whether the character is part of YiRadicals UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsYiRadicals(int code) {
    return((code >= 0xA490) && (code <= 0xA4CF));
}

/**
 * xmlUCSIsYiSyllables:
 * @code: UCS code point
 *
 * Check whether the character is part of YiSyllables UCS Block
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsYiSyllables(int code) {
    return((code >= 0xA000) && (code <= 0xA48F));
}

/**
 * xmlUCSIsBlock:
 * @code: UCS code point
 * @block: UCS block name
 *
 * Check whether the caracter is part of the UCS Block
 *
 * Returns 1 if true, 0 if false and -1 on unknown block
 */
int
xmlUCSIsBlock(int code, const char *block) {
    if (!strcmp(block, "AlphabeticPresentationForms"))
        return(xmlUCSIsAlphabeticPresentationForms(code));
    if (!strcmp(block, "Arabic"))
        return(xmlUCSIsArabic(code));
    if (!strcmp(block, "ArabicPresentationForms-A"))
        return(xmlUCSIsArabicPresentationFormsA(code));
    if (!strcmp(block, "ArabicPresentationForms-B"))
        return(xmlUCSIsArabicPresentationFormsB(code));
    if (!strcmp(block, "Armenian"))
        return(xmlUCSIsArmenian(code));
    if (!strcmp(block, "Arrows"))
        return(xmlUCSIsArrows(code));
    if (!strcmp(block, "BasicLatin"))
        return(xmlUCSIsBasicLatin(code));
    if (!strcmp(block, "Bengali"))
        return(xmlUCSIsBengali(code));
    if (!strcmp(block, "BlockElements"))
        return(xmlUCSIsBlockElements(code));
    if (!strcmp(block, "Bopomofo"))
        return(xmlUCSIsBopomofo(code));
    if (!strcmp(block, "BopomofoExtended"))
        return(xmlUCSIsBopomofoExtended(code));
    if (!strcmp(block, "BoxDrawing"))
        return(xmlUCSIsBoxDrawing(code));
    if (!strcmp(block, "BraillePatterns"))
        return(xmlUCSIsBraillePatterns(code));
    if (!strcmp(block, "ByzantineMusicalSymbols"))
        return(xmlUCSIsByzantineMusicalSymbols(code));
    if (!strcmp(block, "CJKCompatibility"))
        return(xmlUCSIsCJKCompatibility(code));
    if (!strcmp(block, "CJKCompatibilityForms"))
        return(xmlUCSIsCJKCompatibilityForms(code));
    if (!strcmp(block, "CJKCompatibilityIdeographs"))
        return(xmlUCSIsCJKCompatibilityIdeographs(code));
    if (!strcmp(block, "CJKCompatibilityIdeographsSupplement"))
        return(xmlUCSIsCJKCompatibilityIdeographsSupplement(code));
    if (!strcmp(block, "CJKRadicalsSupplement"))
        return(xmlUCSIsCJKRadicalsSupplement(code));
    if (!strcmp(block, "CJKSymbolsandPunctuation"))
        return(xmlUCSIsCJKSymbolsandPunctuation(code));
    if (!strcmp(block, "CJKUnifiedIdeographs"))
        return(xmlUCSIsCJKUnifiedIdeographs(code));
    if (!strcmp(block, "CJKUnifiedIdeographsExtensionA"))
        return(xmlUCSIsCJKUnifiedIdeographsExtensionA(code));
    if (!strcmp(block, "CJKUnifiedIdeographsExtensionB"))
        return(xmlUCSIsCJKUnifiedIdeographsExtensionB(code));
    if (!strcmp(block, "Cherokee"))
        return(xmlUCSIsCherokee(code));
    if (!strcmp(block, "CombiningDiacriticalMarks"))
        return(xmlUCSIsCombiningDiacriticalMarks(code));
    if (!strcmp(block, "CombiningHalfMarks"))
        return(xmlUCSIsCombiningHalfMarks(code));
    if (!strcmp(block, "CombiningMarksforSymbols"))
        return(xmlUCSIsCombiningMarksforSymbols(code));
    if (!strcmp(block, "ControlPictures"))
        return(xmlUCSIsControlPictures(code));
    if (!strcmp(block, "CurrencySymbols"))
        return(xmlUCSIsCurrencySymbols(code));
    if (!strcmp(block, "Cyrillic"))
        return(xmlUCSIsCyrillic(code));
    if (!strcmp(block, "Deseret"))
        return(xmlUCSIsDeseret(code));
    if (!strcmp(block, "Devanagari"))
        return(xmlUCSIsDevanagari(code));
    if (!strcmp(block, "Dingbats"))
        return(xmlUCSIsDingbats(code));
    if (!strcmp(block, "EnclosedAlphanumerics"))
        return(xmlUCSIsEnclosedAlphanumerics(code));
    if (!strcmp(block, "EnclosedCJKLettersandMonths"))
        return(xmlUCSIsEnclosedCJKLettersandMonths(code));
    if (!strcmp(block, "Ethiopic"))
        return(xmlUCSIsEthiopic(code));
    if (!strcmp(block, "GeneralPunctuation"))
        return(xmlUCSIsGeneralPunctuation(code));
    if (!strcmp(block, "GeometricShapes"))
        return(xmlUCSIsGeometricShapes(code));
    if (!strcmp(block, "Georgian"))
        return(xmlUCSIsGeorgian(code));
    if (!strcmp(block, "Gothic"))
        return(xmlUCSIsGothic(code));
    if (!strcmp(block, "Greek"))
        return(xmlUCSIsGreek(code));
    if (!strcmp(block, "GreekExtended"))
        return(xmlUCSIsGreekExtended(code));
    if (!strcmp(block, "Gujarati"))
        return(xmlUCSIsGujarati(code));
    if (!strcmp(block, "Gurmukhi"))
        return(xmlUCSIsGurmukhi(code));
    if (!strcmp(block, "HalfwidthandFullwidthForms"))
        return(xmlUCSIsHalfwidthandFullwidthForms(code));
    if (!strcmp(block, "HangulCompatibilityJamo"))
        return(xmlUCSIsHangulCompatibilityJamo(code));
    if (!strcmp(block, "HangulJamo"))
        return(xmlUCSIsHangulJamo(code));
    if (!strcmp(block, "HangulSyllables"))
        return(xmlUCSIsHangulSyllables(code));
    if (!strcmp(block, "Hebrew"))
        return(xmlUCSIsHebrew(code));
    if (!strcmp(block, "HighPrivateUseSurrogates"))
        return(xmlUCSIsHighPrivateUseSurrogates(code));
    if (!strcmp(block, "HighSurrogates"))
        return(xmlUCSIsHighSurrogates(code));
    if (!strcmp(block, "Hiragana"))
        return(xmlUCSIsHiragana(code));
    if (!strcmp(block, "IPAExtensions"))
        return(xmlUCSIsIPAExtensions(code));
    if (!strcmp(block, "IdeographicDescriptionCharacters"))
        return(xmlUCSIsIdeographicDescriptionCharacters(code));
    if (!strcmp(block, "Kanbun"))
        return(xmlUCSIsKanbun(code));
    if (!strcmp(block, "KangxiRadicals"))
        return(xmlUCSIsKangxiRadicals(code));
    if (!strcmp(block, "Kannada"))
        return(xmlUCSIsKannada(code));
    if (!strcmp(block, "Katakana"))
        return(xmlUCSIsKatakana(code));
    if (!strcmp(block, "Khmer"))
        return(xmlUCSIsKhmer(code));
    if (!strcmp(block, "Lao"))
        return(xmlUCSIsLao(code));
    if (!strcmp(block, "Latin-1Supplement"))
        return(xmlUCSIsLatin1Supplement(code));
    if (!strcmp(block, "LatinExtended-A"))
        return(xmlUCSIsLatinExtendedA(code));
    if (!strcmp(block, "LatinExtended-B"))
        return(xmlUCSIsLatinExtendedB(code));
    if (!strcmp(block, "LatinExtendedAdditional"))
        return(xmlUCSIsLatinExtendedAdditional(code));
    if (!strcmp(block, "LetterlikeSymbols"))
        return(xmlUCSIsLetterlikeSymbols(code));
    if (!strcmp(block, "LowSurrogates"))
        return(xmlUCSIsLowSurrogates(code));
    if (!strcmp(block, "Malayalam"))
        return(xmlUCSIsMalayalam(code));
    if (!strcmp(block, "MathematicalAlphanumericSymbols"))
        return(xmlUCSIsMathematicalAlphanumericSymbols(code));
    if (!strcmp(block, "MathematicalOperators"))
        return(xmlUCSIsMathematicalOperators(code));
    if (!strcmp(block, "MiscellaneousSymbols"))
        return(xmlUCSIsMiscellaneousSymbols(code));
    if (!strcmp(block, "MiscellaneousTechnical"))
        return(xmlUCSIsMiscellaneousTechnical(code));
    if (!strcmp(block, "Mongolian"))
        return(xmlUCSIsMongolian(code));
    if (!strcmp(block, "MusicalSymbols"))
        return(xmlUCSIsMusicalSymbols(code));
    if (!strcmp(block, "Myanmar"))
        return(xmlUCSIsMyanmar(code));
    if (!strcmp(block, "NumberForms"))
        return(xmlUCSIsNumberForms(code));
    if (!strcmp(block, "Ogham"))
        return(xmlUCSIsOgham(code));
    if (!strcmp(block, "OldItalic"))
        return(xmlUCSIsOldItalic(code));
    if (!strcmp(block, "OpticalCharacterRecognition"))
        return(xmlUCSIsOpticalCharacterRecognition(code));
    if (!strcmp(block, "Oriya"))
        return(xmlUCSIsOriya(code));
    if (!strcmp(block, "PrivateUse"))
        return(xmlUCSIsPrivateUse(code));
    if (!strcmp(block, "Runic"))
        return(xmlUCSIsRunic(code));
    if (!strcmp(block, "Sinhala"))
        return(xmlUCSIsSinhala(code));
    if (!strcmp(block, "SmallFormVariants"))
        return(xmlUCSIsSmallFormVariants(code));
    if (!strcmp(block, "SpacingModifierLetters"))
        return(xmlUCSIsSpacingModifierLetters(code));
    if (!strcmp(block, "Specials"))
        return(xmlUCSIsSpecials(code));
    if (!strcmp(block, "SuperscriptsandSubscripts"))
        return(xmlUCSIsSuperscriptsandSubscripts(code));
    if (!strcmp(block, "Syriac"))
        return(xmlUCSIsSyriac(code));
    if (!strcmp(block, "Tags"))
        return(xmlUCSIsTags(code));
    if (!strcmp(block, "Tamil"))
        return(xmlUCSIsTamil(code));
    if (!strcmp(block, "Telugu"))
        return(xmlUCSIsTelugu(code));
    if (!strcmp(block, "Thaana"))
        return(xmlUCSIsThaana(code));
    if (!strcmp(block, "Thai"))
        return(xmlUCSIsThai(code));
    if (!strcmp(block, "Tibetan"))
        return(xmlUCSIsTibetan(code));
    if (!strcmp(block, "UnifiedCanadianAboriginalSyllabics"))
        return(xmlUCSIsUnifiedCanadianAboriginalSyllabics(code));
    if (!strcmp(block, "YiRadicals"))
        return(xmlUCSIsYiRadicals(code));
    if (!strcmp(block, "YiSyllables"))
        return(xmlUCSIsYiSyllables(code));
    return(-1);
}

/**
 * xmlUCSIsCatC:
 * @code: UCS code point
 *
 * Check whether the character is part of C UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatC(int code) {
    return(((code >= 0x0) && (code <= 0x1f)) ||
           ((code >= 0x7f) && (code <= 0x9f)) ||
           (code == 0x70f) ||
           ((code >= 0x180b) && (code <= 0x180e)) ||
           ((code >= 0x200c) && (code <= 0x200f)) ||
           ((code >= 0x202a) && (code <= 0x202e)) ||
           ((code >= 0x206a) && (code <= 0x206f)) ||
           (code == 0xd800) ||
           ((code >= 0xdb7f) && (code <= 0xdb80)) ||
           ((code >= 0xdbff) && (code <= 0xdc00)) ||
           ((code >= 0xdfff) && (code <= 0xe000)) ||
           (code == 0xf8ff) ||
           (code == 0xfeff) ||
           ((code >= 0xfff9) && (code <= 0xfffb)) ||
           ((code >= 0x1d173) && (code <= 0x1d17a)) ||
           (code == 0xe0001) ||
           ((code >= 0xe0020) && (code <= 0xe007f)) ||
           (code == 0xf0000) ||
           (code == 0xffffd) ||
           (code == 0x100000) ||
           (code == 0x10fffd));
}

/**
 * xmlUCSIsCatCc:
 * @code: UCS code point
 *
 * Check whether the character is part of Cc UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatCc(int code) {
    return(((code >= 0x0) && (code <= 0x1f)) ||
           ((code >= 0x7f) && (code <= 0x9f)));
}

/**
 * xmlUCSIsCatCf:
 * @code: UCS code point
 *
 * Check whether the character is part of Cf UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatCf(int code) {
    return((code == 0x70f) ||
           ((code >= 0x180b) && (code <= 0x180e)) ||
           ((code >= 0x200c) && (code <= 0x200f)) ||
           ((code >= 0x202a) && (code <= 0x202e)) ||
           ((code >= 0x206a) && (code <= 0x206f)) ||
           (code == 0xfeff) ||
           ((code >= 0xfff9) && (code <= 0xfffb)) ||
           ((code >= 0x1d173) && (code <= 0x1d17a)) ||
           (code == 0xe0001) ||
           ((code >= 0xe0020) && (code <= 0xe007f)));
}

/**
 * xmlUCSIsCatCo:
 * @code: UCS code point
 *
 * Check whether the character is part of Co UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatCo(int code) {
    return((code == 0xe000) ||
           (code == 0xf8ff) ||
           (code == 0xf0000) ||
           (code == 0xffffd) ||
           (code == 0x100000) ||
           (code == 0x10fffd));
}

/**
 * xmlUCSIsCatCs:
 * @code: UCS code point
 *
 * Check whether the character is part of Cs UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatCs(int code) {
    return((code == 0xd800) ||
           ((code >= 0xdb7f) && (code <= 0xdb80)) ||
           ((code >= 0xdbff) && (code <= 0xdc00)) ||
           (code == 0xdfff));
}

/**
 * xmlUCSIsCatL:
 * @code: UCS code point
 *
 * Check whether the character is part of L UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatL(int code) {
    return(((code >= 0x41) && (code <= 0x5a)) ||
           ((code >= 0x61) && (code <= 0x7a)) ||
           (code == 0xaa) ||
           (code == 0xb5) ||
           (code == 0xba) ||
           ((code >= 0xc0) && (code <= 0xd6)) ||
           ((code >= 0xd8) && (code <= 0xf6)) ||
           ((code >= 0xf8) && (code <= 0x21f)) ||
           ((code >= 0x222) && (code <= 0x233)) ||
           ((code >= 0x250) && (code <= 0x2ad)) ||
           ((code >= 0x2b0) && (code <= 0x2b8)) ||
           ((code >= 0x2bb) && (code <= 0x2c1)) ||
           ((code >= 0x2d0) && (code <= 0x2d1)) ||
           ((code >= 0x2e0) && (code <= 0x2e4)) ||
           (code == 0x2ee) ||
           (code == 0x37a) ||
           (code == 0x386) ||
           ((code >= 0x388) && (code <= 0x38a)) ||
           (code == 0x38c) ||
           ((code >= 0x38e) && (code <= 0x3a1)) ||
           ((code >= 0x3a3) && (code <= 0x3ce)) ||
           ((code >= 0x3d0) && (code <= 0x3d7)) ||
           ((code >= 0x3da) && (code <= 0x3f5)) ||
           ((code >= 0x400) && (code <= 0x481)) ||
           ((code >= 0x48c) && (code <= 0x4c4)) ||
           ((code >= 0x4c7) && (code <= 0x4c8)) ||
           ((code >= 0x4cb) && (code <= 0x4cc)) ||
           ((code >= 0x4d0) && (code <= 0x4f5)) ||
           ((code >= 0x4f8) && (code <= 0x4f9)) ||
           ((code >= 0x531) && (code <= 0x556)) ||
           (code == 0x559) ||
           ((code >= 0x561) && (code <= 0x587)) ||
           ((code >= 0x5d0) && (code <= 0x5ea)) ||
           ((code >= 0x5f0) && (code <= 0x5f2)) ||
           ((code >= 0x621) && (code <= 0x63a)) ||
           ((code >= 0x640) && (code <= 0x64a)) ||
           ((code >= 0x671) && (code <= 0x6d3)) ||
           (code == 0x6d5) ||
           ((code >= 0x6e5) && (code <= 0x6e6)) ||
           ((code >= 0x6fa) && (code <= 0x6fc)) ||
           (code == 0x710) ||
           ((code >= 0x712) && (code <= 0x72c)) ||
           ((code >= 0x780) && (code <= 0x7a5)) ||
           ((code >= 0x905) && (code <= 0x939)) ||
           (code == 0x93d) ||
           (code == 0x950) ||
           ((code >= 0x958) && (code <= 0x961)) ||
           ((code >= 0x985) && (code <= 0x98c)) ||
           ((code >= 0x98f) && (code <= 0x990)) ||
           ((code >= 0x993) && (code <= 0x9a8)) ||
           ((code >= 0x9aa) && (code <= 0x9b0)) ||
           (code == 0x9b2) ||
           ((code >= 0x9b6) && (code <= 0x9b9)) ||
           ((code >= 0x9dc) && (code <= 0x9dd)) ||
           ((code >= 0x9df) && (code <= 0x9e1)) ||
           ((code >= 0x9f0) && (code <= 0x9f1)) ||
           ((code >= 0xa05) && (code <= 0xa0a)) ||
           ((code >= 0xa0f) && (code <= 0xa10)) ||
           ((code >= 0xa13) && (code <= 0xa28)) ||
           ((code >= 0xa2a) && (code <= 0xa30)) ||
           ((code >= 0xa32) && (code <= 0xa33)) ||
           ((code >= 0xa35) && (code <= 0xa36)) ||
           ((code >= 0xa38) && (code <= 0xa39)) ||
           ((code >= 0xa59) && (code <= 0xa5c)) ||
           (code == 0xa5e) ||
           ((code >= 0xa72) && (code <= 0xa74)) ||
           ((code >= 0xa85) && (code <= 0xa8b)) ||
           (code == 0xa8d) ||
           ((code >= 0xa8f) && (code <= 0xa91)) ||
           ((code >= 0xa93) && (code <= 0xaa8)) ||
           ((code >= 0xaaa) && (code <= 0xab0)) ||
           ((code >= 0xab2) && (code <= 0xab3)) ||
           ((code >= 0xab5) && (code <= 0xab9)) ||
           (code == 0xabd) ||
           (code == 0xad0) ||
           (code == 0xae0) ||
           ((code >= 0xb05) && (code <= 0xb0c)) ||
           ((code >= 0xb0f) && (code <= 0xb10)) ||
           ((code >= 0xb13) && (code <= 0xb28)) ||
           ((code >= 0xb2a) && (code <= 0xb30)) ||
           ((code >= 0xb32) && (code <= 0xb33)) ||
           ((code >= 0xb36) && (code <= 0xb39)) ||
           (code == 0xb3d) ||
           ((code >= 0xb5c) && (code <= 0xb5d)) ||
           ((code >= 0xb5f) && (code <= 0xb61)) ||
           ((code >= 0xb85) && (code <= 0xb8a)) ||
           ((code >= 0xb8e) && (code <= 0xb90)) ||
           ((code >= 0xb92) && (code <= 0xb95)) ||
           ((code >= 0xb99) && (code <= 0xb9a)) ||
           (code == 0xb9c) ||
           ((code >= 0xb9e) && (code <= 0xb9f)) ||
           ((code >= 0xba3) && (code <= 0xba4)) ||
           ((code >= 0xba8) && (code <= 0xbaa)) ||
           ((code >= 0xbae) && (code <= 0xbb5)) ||
           ((code >= 0xbb7) && (code <= 0xbb9)) ||
           ((code >= 0xc05) && (code <= 0xc0c)) ||
           ((code >= 0xc0e) && (code <= 0xc10)) ||
           ((code >= 0xc12) && (code <= 0xc28)) ||
           ((code >= 0xc2a) && (code <= 0xc33)) ||
           ((code >= 0xc35) && (code <= 0xc39)) ||
           ((code >= 0xc60) && (code <= 0xc61)) ||
           ((code >= 0xc85) && (code <= 0xc8c)) ||
           ((code >= 0xc8e) && (code <= 0xc90)) ||
           ((code >= 0xc92) && (code <= 0xca8)) ||
           ((code >= 0xcaa) && (code <= 0xcb3)) ||
           ((code >= 0xcb5) && (code <= 0xcb9)) ||
           (code == 0xcde) ||
           ((code >= 0xce0) && (code <= 0xce1)) ||
           ((code >= 0xd05) && (code <= 0xd0c)) ||
           ((code >= 0xd0e) && (code <= 0xd10)) ||
           ((code >= 0xd12) && (code <= 0xd28)) ||
           ((code >= 0xd2a) && (code <= 0xd39)) ||
           ((code >= 0xd60) && (code <= 0xd61)) ||
           ((code >= 0xd85) && (code <= 0xd96)) ||
           ((code >= 0xd9a) && (code <= 0xdb1)) ||
           ((code >= 0xdb3) && (code <= 0xdbb)) ||
           (code == 0xdbd) ||
           ((code >= 0xdc0) && (code <= 0xdc6)) ||
           ((code >= 0xe01) && (code <= 0xe30)) ||
           ((code >= 0xe32) && (code <= 0xe33)) ||
           ((code >= 0xe40) && (code <= 0xe46)) ||
           ((code >= 0xe81) && (code <= 0xe82)) ||
           (code == 0xe84) ||
           ((code >= 0xe87) && (code <= 0xe88)) ||
           (code == 0xe8a) ||
           (code == 0xe8d) ||
           ((code >= 0xe94) && (code <= 0xe97)) ||
           ((code >= 0xe99) && (code <= 0xe9f)) ||
           ((code >= 0xea1) && (code <= 0xea3)) ||
           (code == 0xea5) ||
           (code == 0xea7) ||
           ((code >= 0xeaa) && (code <= 0xeab)) ||
           ((code >= 0xead) && (code <= 0xeb0)) ||
           ((code >= 0xeb2) && (code <= 0xeb3)) ||
           (code == 0xebd) ||
           ((code >= 0xec0) && (code <= 0xec4)) ||
           (code == 0xec6) ||
           ((code >= 0xedc) && (code <= 0xedd)) ||
           (code == 0xf00) ||
           ((code >= 0xf40) && (code <= 0xf47)) ||
           ((code >= 0xf49) && (code <= 0xf6a)) ||
           ((code >= 0xf88) && (code <= 0xf8b)) ||
           ((code >= 0x1000) && (code <= 0x1021)) ||
           ((code >= 0x1023) && (code <= 0x1027)) ||
           ((code >= 0x1029) && (code <= 0x102a)) ||
           ((code >= 0x1050) && (code <= 0x1055)) ||
           ((code >= 0x10a0) && (code <= 0x10c5)) ||
           ((code >= 0x10d0) && (code <= 0x10f6)) ||
           ((code >= 0x1100) && (code <= 0x1159)) ||
           ((code >= 0x115f) && (code <= 0x11a2)) ||
           ((code >= 0x11a8) && (code <= 0x11f9)) ||
           ((code >= 0x1200) && (code <= 0x1206)) ||
           ((code >= 0x1208) && (code <= 0x1246)) ||
           (code == 0x1248) ||
           ((code >= 0x124a) && (code <= 0x124d)) ||
           ((code >= 0x1250) && (code <= 0x1256)) ||
           (code == 0x1258) ||
           ((code >= 0x125a) && (code <= 0x125d)) ||
           ((code >= 0x1260) && (code <= 0x1286)) ||
           (code == 0x1288) ||
           ((code >= 0x128a) && (code <= 0x128d)) ||
           ((code >= 0x1290) && (code <= 0x12ae)) ||
           (code == 0x12b0) ||
           ((code >= 0x12b2) && (code <= 0x12b5)) ||
           ((code >= 0x12b8) && (code <= 0x12be)) ||
           (code == 0x12c0) ||
           ((code >= 0x12c2) && (code <= 0x12c5)) ||
           ((code >= 0x12c8) && (code <= 0x12ce)) ||
           ((code >= 0x12d0) && (code <= 0x12d6)) ||
           ((code >= 0x12d8) && (code <= 0x12ee)) ||
           ((code >= 0x12f0) && (code <= 0x130e)) ||
           (code == 0x1310) ||
           ((code >= 0x1312) && (code <= 0x1315)) ||
           ((code >= 0x1318) && (code <= 0x131e)) ||
           ((code >= 0x1320) && (code <= 0x1346)) ||
           ((code >= 0x1348) && (code <= 0x135a)) ||
           ((code >= 0x13a0) && (code <= 0x13f4)) ||
           ((code >= 0x1401) && (code <= 0x166c)) ||
           ((code >= 0x166f) && (code <= 0x1676)) ||
           ((code >= 0x1681) && (code <= 0x169a)) ||
           ((code >= 0x16a0) && (code <= 0x16ea)) ||
           ((code >= 0x1780) && (code <= 0x17b3)) ||
           ((code >= 0x1820) && (code <= 0x1877)) ||
           ((code >= 0x1880) && (code <= 0x18a8)) ||
           ((code >= 0x1e00) && (code <= 0x1e9b)) ||
           ((code >= 0x1ea0) && (code <= 0x1ef9)) ||
           ((code >= 0x1f00) && (code <= 0x1f15)) ||
           ((code >= 0x1f18) && (code <= 0x1f1d)) ||
           ((code >= 0x1f20) && (code <= 0x1f45)) ||
           ((code >= 0x1f48) && (code <= 0x1f4d)) ||
           ((code >= 0x1f50) && (code <= 0x1f57)) ||
           (code == 0x1f59) ||
           (code == 0x1f5b) ||
           (code == 0x1f5d) ||
           ((code >= 0x1f5f) && (code <= 0x1f7d)) ||
           ((code >= 0x1f80) && (code <= 0x1fb4)) ||
           ((code >= 0x1fb6) && (code <= 0x1fbc)) ||
           (code == 0x1fbe) ||
           ((code >= 0x1fc2) && (code <= 0x1fc4)) ||
           ((code >= 0x1fc6) && (code <= 0x1fcc)) ||
           ((code >= 0x1fd0) && (code <= 0x1fd3)) ||
           ((code >= 0x1fd6) && (code <= 0x1fdb)) ||
           ((code >= 0x1fe0) && (code <= 0x1fec)) ||
           ((code >= 0x1ff2) && (code <= 0x1ff4)) ||
           ((code >= 0x1ff6) && (code <= 0x1ffc)) ||
           (code == 0x207f) ||
           (code == 0x2102) ||
           (code == 0x2107) ||
           ((code >= 0x210a) && (code <= 0x2113)) ||
           (code == 0x2115) ||
           ((code >= 0x2119) && (code <= 0x211d)) ||
           (code == 0x2124) ||
           (code == 0x2126) ||
           (code == 0x2128) ||
           ((code >= 0x212a) && (code <= 0x212d)) ||
           ((code >= 0x212f) && (code <= 0x2131)) ||
           ((code >= 0x2133) && (code <= 0x2139)) ||
           ((code >= 0x3005) && (code <= 0x3006)) ||
           ((code >= 0x3031) && (code <= 0x3035)) ||
           ((code >= 0x3041) && (code <= 0x3094)) ||
           ((code >= 0x309d) && (code <= 0x309e)) ||
           ((code >= 0x30a1) && (code <= 0x30fa)) ||
           ((code >= 0x30fc) && (code <= 0x30fe)) ||
           ((code >= 0x3105) && (code <= 0x312c)) ||
           ((code >= 0x3131) && (code <= 0x318e)) ||
           ((code >= 0x31a0) && (code <= 0x31b7)) ||
           (code == 0x3400) ||
           (code == 0x4db5) ||
           (code == 0x4e00) ||
           (code == 0x9fa5) ||
           ((code >= 0xa000) && (code <= 0xa48c)) ||
           (code == 0xac00) ||
           (code == 0xd7a3) ||
           ((code >= 0xf900) && (code <= 0xfa2d)) ||
           ((code >= 0xfb00) && (code <= 0xfb06)) ||
           ((code >= 0xfb13) && (code <= 0xfb17)) ||
           (code == 0xfb1d) ||
           ((code >= 0xfb1f) && (code <= 0xfb28)) ||
           ((code >= 0xfb2a) && (code <= 0xfb36)) ||
           ((code >= 0xfb38) && (code <= 0xfb3c)) ||
           (code == 0xfb3e) ||
           ((code >= 0xfb40) && (code <= 0xfb41)) ||
           ((code >= 0xfb43) && (code <= 0xfb44)) ||
           ((code >= 0xfb46) && (code <= 0xfbb1)) ||
           ((code >= 0xfbd3) && (code <= 0xfd3d)) ||
           ((code >= 0xfd50) && (code <= 0xfd8f)) ||
           ((code >= 0xfd92) && (code <= 0xfdc7)) ||
           ((code >= 0xfdf0) && (code <= 0xfdfb)) ||
           ((code >= 0xfe70) && (code <= 0xfe72)) ||
           (code == 0xfe74) ||
           ((code >= 0xfe76) && (code <= 0xfefc)) ||
           ((code >= 0xff21) && (code <= 0xff3a)) ||
           ((code >= 0xff41) && (code <= 0xff5a)) ||
           ((code >= 0xff66) && (code <= 0xffbe)) ||
           ((code >= 0xffc2) && (code <= 0xffc7)) ||
           ((code >= 0xffca) && (code <= 0xffcf)) ||
           ((code >= 0xffd2) && (code <= 0xffd7)) ||
           ((code >= 0xffda) && (code <= 0xffdc)) ||
           ((code >= 0x10300) && (code <= 0x1031e)) ||
           ((code >= 0x10330) && (code <= 0x10349)) ||
           ((code >= 0x10400) && (code <= 0x10425)) ||
           ((code >= 0x10428) && (code <= 0x1044d)) ||
           ((code >= 0x1d400) && (code <= 0x1d454)) ||
           ((code >= 0x1d456) && (code <= 0x1d49c)) ||
           ((code >= 0x1d49e) && (code <= 0x1d49f)) ||
           (code == 0x1d4a2) ||
           ((code >= 0x1d4a5) && (code <= 0x1d4a6)) ||
           ((code >= 0x1d4a9) && (code <= 0x1d4ac)) ||
           ((code >= 0x1d4ae) && (code <= 0x1d4b9)) ||
           (code == 0x1d4bb) ||
           ((code >= 0x1d4bd) && (code <= 0x1d4c0)) ||
           ((code >= 0x1d4c2) && (code <= 0x1d4c3)) ||
           ((code >= 0x1d4c5) && (code <= 0x1d505)) ||
           ((code >= 0x1d507) && (code <= 0x1d50a)) ||
           ((code >= 0x1d50d) && (code <= 0x1d514)) ||
           ((code >= 0x1d516) && (code <= 0x1d51c)) ||
           ((code >= 0x1d51e) && (code <= 0x1d539)) ||
           ((code >= 0x1d53b) && (code <= 0x1d53e)) ||
           ((code >= 0x1d540) && (code <= 0x1d544)) ||
           (code == 0x1d546) ||
           ((code >= 0x1d54a) && (code <= 0x1d550)) ||
           ((code >= 0x1d552) && (code <= 0x1d6a3)) ||
           ((code >= 0x1d6a8) && (code <= 0x1d6c0)) ||
           ((code >= 0x1d6c2) && (code <= 0x1d6da)) ||
           ((code >= 0x1d6dc) && (code <= 0x1d6fa)) ||
           ((code >= 0x1d6fc) && (code <= 0x1d714)) ||
           ((code >= 0x1d716) && (code <= 0x1d734)) ||
           ((code >= 0x1d736) && (code <= 0x1d74e)) ||
           ((code >= 0x1d750) && (code <= 0x1d76e)) ||
           ((code >= 0x1d770) && (code <= 0x1d788)) ||
           ((code >= 0x1d78a) && (code <= 0x1d7a8)) ||
           ((code >= 0x1d7aa) && (code <= 0x1d7c2)) ||
           ((code >= 0x1d7c4) && (code <= 0x1d7c9)) ||
           (code == 0x20000) ||
           (code == 0x2a6d6) ||
           ((code >= 0x2f800) && (code <= 0x2fa1d)));
}

/**
 * xmlUCSIsCatLl:
 * @code: UCS code point
 *
 * Check whether the character is part of Ll UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatLl(int code) {
    return(((code >= 0x61) && (code <= 0x7a)) ||
           (code == 0xaa) ||
           (code == 0xb5) ||
           (code == 0xba) ||
           ((code >= 0xdf) && (code <= 0xf6)) ||
           ((code >= 0xf8) && (code <= 0xff)) ||
           (code == 0x101) ||
           (code == 0x103) ||
           (code == 0x105) ||
           (code == 0x107) ||
           (code == 0x109) ||
           (code == 0x10b) ||
           (code == 0x10d) ||
           (code == 0x10f) ||
           (code == 0x111) ||
           (code == 0x113) ||
           (code == 0x115) ||
           (code == 0x117) ||
           (code == 0x119) ||
           (code == 0x11b) ||
           (code == 0x11d) ||
           (code == 0x11f) ||
           (code == 0x121) ||
           (code == 0x123) ||
           (code == 0x125) ||
           (code == 0x127) ||
           (code == 0x129) ||
           (code == 0x12b) ||
           (code == 0x12d) ||
           (code == 0x12f) ||
           (code == 0x131) ||
           (code == 0x133) ||
           (code == 0x135) ||
           ((code >= 0x137) && (code <= 0x138)) ||
           (code == 0x13a) ||
           (code == 0x13c) ||
           (code == 0x13e) ||
           (code == 0x140) ||
           (code == 0x142) ||
           (code == 0x144) ||
           (code == 0x146) ||
           ((code >= 0x148) && (code <= 0x149)) ||
           (code == 0x14b) ||
           (code == 0x14d) ||
           (code == 0x14f) ||
           (code == 0x151) ||
           (code == 0x153) ||
           (code == 0x155) ||
           (code == 0x157) ||
           (code == 0x159) ||
           (code == 0x15b) ||
           (code == 0x15d) ||
           (code == 0x15f) ||
           (code == 0x161) ||
           (code == 0x163) ||
           (code == 0x165) ||
           (code == 0x167) ||
           (code == 0x169) ||
           (code == 0x16b) ||
           (code == 0x16d) ||
           (code == 0x16f) ||
           (code == 0x171) ||
           (code == 0x173) ||
           (code == 0x175) ||
           (code == 0x177) ||
           (code == 0x17a) ||
           (code == 0x17c) ||
           ((code >= 0x17e) && (code <= 0x180)) ||
           (code == 0x183) ||
           (code == 0x185) ||
           (code == 0x188) ||
           ((code >= 0x18c) && (code <= 0x18d)) ||
           (code == 0x192) ||
           (code == 0x195) ||
           ((code >= 0x199) && (code <= 0x19b)) ||
           (code == 0x19e) ||
           (code == 0x1a1) ||
           (code == 0x1a3) ||
           (code == 0x1a5) ||
           (code == 0x1a8) ||
           ((code >= 0x1aa) && (code <= 0x1ab)) ||
           (code == 0x1ad) ||
           (code == 0x1b0) ||
           (code == 0x1b4) ||
           (code == 0x1b6) ||
           ((code >= 0x1b9) && (code <= 0x1ba)) ||
           ((code >= 0x1bd) && (code <= 0x1bf)) ||
           (code == 0x1c6) ||
           (code == 0x1c9) ||
           (code == 0x1cc) ||
           (code == 0x1ce) ||
           (code == 0x1d0) ||
           (code == 0x1d2) ||
           (code == 0x1d4) ||
           (code == 0x1d6) ||
           (code == 0x1d8) ||
           (code == 0x1da) ||
           ((code >= 0x1dc) && (code <= 0x1dd)) ||
           (code == 0x1df) ||
           (code == 0x1e1) ||
           (code == 0x1e3) ||
           (code == 0x1e5) ||
           (code == 0x1e7) ||
           (code == 0x1e9) ||
           (code == 0x1eb) ||
           (code == 0x1ed) ||
           ((code >= 0x1ef) && (code <= 0x1f0)) ||
           (code == 0x1f3) ||
           (code == 0x1f5) ||
           (code == 0x1f9) ||
           (code == 0x1fb) ||
           (code == 0x1fd) ||
           (code == 0x1ff) ||
           (code == 0x201) ||
           (code == 0x203) ||
           (code == 0x205) ||
           (code == 0x207) ||
           (code == 0x209) ||
           (code == 0x20b) ||
           (code == 0x20d) ||
           (code == 0x20f) ||
           (code == 0x211) ||
           (code == 0x213) ||
           (code == 0x215) ||
           (code == 0x217) ||
           (code == 0x219) ||
           (code == 0x21b) ||
           (code == 0x21d) ||
           (code == 0x21f) ||
           (code == 0x223) ||
           (code == 0x225) ||
           (code == 0x227) ||
           (code == 0x229) ||
           (code == 0x22b) ||
           (code == 0x22d) ||
           (code == 0x22f) ||
           (code == 0x231) ||
           (code == 0x233) ||
           ((code >= 0x250) && (code <= 0x2ad)) ||
           (code == 0x390) ||
           ((code >= 0x3ac) && (code <= 0x3ce)) ||
           ((code >= 0x3d0) && (code <= 0x3d1)) ||
           ((code >= 0x3d5) && (code <= 0x3d7)) ||
           (code == 0x3db) ||
           (code == 0x3dd) ||
           (code == 0x3df) ||
           (code == 0x3e1) ||
           (code == 0x3e3) ||
           (code == 0x3e5) ||
           (code == 0x3e7) ||
           (code == 0x3e9) ||
           (code == 0x3eb) ||
           (code == 0x3ed) ||
           ((code >= 0x3ef) && (code <= 0x3f3)) ||
           (code == 0x3f5) ||
           ((code >= 0x430) && (code <= 0x45f)) ||
           (code == 0x461) ||
           (code == 0x463) ||
           (code == 0x465) ||
           (code == 0x467) ||
           (code == 0x469) ||
           (code == 0x46b) ||
           (code == 0x46d) ||
           (code == 0x46f) ||
           (code == 0x471) ||
           (code == 0x473) ||
           (code == 0x475) ||
           (code == 0x477) ||
           (code == 0x479) ||
           (code == 0x47b) ||
           (code == 0x47d) ||
           (code == 0x47f) ||
           (code == 0x481) ||
           (code == 0x48d) ||
           (code == 0x48f) ||
           (code == 0x491) ||
           (code == 0x493) ||
           (code == 0x495) ||
           (code == 0x497) ||
           (code == 0x499) ||
           (code == 0x49b) ||
           (code == 0x49d) ||
           (code == 0x49f) ||
           (code == 0x4a1) ||
           (code == 0x4a3) ||
           (code == 0x4a5) ||
           (code == 0x4a7) ||
           (code == 0x4a9) ||
           (code == 0x4ab) ||
           (code == 0x4ad) ||
           (code == 0x4af) ||
           (code == 0x4b1) ||
           (code == 0x4b3) ||
           (code == 0x4b5) ||
           (code == 0x4b7) ||
           (code == 0x4b9) ||
           (code == 0x4bb) ||
           (code == 0x4bd) ||
           (code == 0x4bf) ||
           (code == 0x4c2) ||
           (code == 0x4c4) ||
           (code == 0x4c8) ||
           (code == 0x4cc) ||
           (code == 0x4d1) ||
           (code == 0x4d3) ||
           (code == 0x4d5) ||
           (code == 0x4d7) ||
           (code == 0x4d9) ||
           (code == 0x4db) ||
           (code == 0x4dd) ||
           (code == 0x4df) ||
           (code == 0x4e1) ||
           (code == 0x4e3) ||
           (code == 0x4e5) ||
           (code == 0x4e7) ||
           (code == 0x4e9) ||
           (code == 0x4eb) ||
           (code == 0x4ed) ||
           (code == 0x4ef) ||
           (code == 0x4f1) ||
           (code == 0x4f3) ||
           (code == 0x4f5) ||
           (code == 0x4f9) ||
           ((code >= 0x561) && (code <= 0x587)) ||
           (code == 0x1e01) ||
           (code == 0x1e03) ||
           (code == 0x1e05) ||
           (code == 0x1e07) ||
           (code == 0x1e09) ||
           (code == 0x1e0b) ||
           (code == 0x1e0d) ||
           (code == 0x1e0f) ||
           (code == 0x1e11) ||
           (code == 0x1e13) ||
           (code == 0x1e15) ||
           (code == 0x1e17) ||
           (code == 0x1e19) ||
           (code == 0x1e1b) ||
           (code == 0x1e1d) ||
           (code == 0x1e1f) ||
           (code == 0x1e21) ||
           (code == 0x1e23) ||
           (code == 0x1e25) ||
           (code == 0x1e27) ||
           (code == 0x1e29) ||
           (code == 0x1e2b) ||
           (code == 0x1e2d) ||
           (code == 0x1e2f) ||
           (code == 0x1e31) ||
           (code == 0x1e33) ||
           (code == 0x1e35) ||
           (code == 0x1e37) ||
           (code == 0x1e39) ||
           (code == 0x1e3b) ||
           (code == 0x1e3d) ||
           (code == 0x1e3f) ||
           (code == 0x1e41) ||
           (code == 0x1e43) ||
           (code == 0x1e45) ||
           (code == 0x1e47) ||
           (code == 0x1e49) ||
           (code == 0x1e4b) ||
           (code == 0x1e4d) ||
           (code == 0x1e4f) ||
           (code == 0x1e51) ||
           (code == 0x1e53) ||
           (code == 0x1e55) ||
           (code == 0x1e57) ||
           (code == 0x1e59) ||
           (code == 0x1e5b) ||
           (code == 0x1e5d) ||
           (code == 0x1e5f) ||
           (code == 0x1e61) ||
           (code == 0x1e63) ||
           (code == 0x1e65) ||
           (code == 0x1e67) ||
           (code == 0x1e69) ||
           (code == 0x1e6b) ||
           (code == 0x1e6d) ||
           (code == 0x1e6f) ||
           (code == 0x1e71) ||
           (code == 0x1e73) ||
           (code == 0x1e75) ||
           (code == 0x1e77) ||
           (code == 0x1e79) ||
           (code == 0x1e7b) ||
           (code == 0x1e7d) ||
           (code == 0x1e7f) ||
           (code == 0x1e81) ||
           (code == 0x1e83) ||
           (code == 0x1e85) ||
           (code == 0x1e87) ||
           (code == 0x1e89) ||
           (code == 0x1e8b) ||
           (code == 0x1e8d) ||
           (code == 0x1e8f) ||
           (code == 0x1e91) ||
           (code == 0x1e93) ||
           ((code >= 0x1e95) && (code <= 0x1e9b)) ||
           (code == 0x1ea1) ||
           (code == 0x1ea3) ||
           (code == 0x1ea5) ||
           (code == 0x1ea7) ||
           (code == 0x1ea9) ||
           (code == 0x1eab) ||
           (code == 0x1ead) ||
           (code == 0x1eaf) ||
           (code == 0x1eb1) ||
           (code == 0x1eb3) ||
           (code == 0x1eb5) ||
           (code == 0x1eb7) ||
           (code == 0x1eb9) ||
           (code == 0x1ebb) ||
           (code == 0x1ebd) ||
           (code == 0x1ebf) ||
           (code == 0x1ec1) ||
           (code == 0x1ec3) ||
           (code == 0x1ec5) ||
           (code == 0x1ec7) ||
           (code == 0x1ec9) ||
           (code == 0x1ecb) ||
           (code == 0x1ecd) ||
           (code == 0x1ecf) ||
           (code == 0x1ed1) ||
           (code == 0x1ed3) ||
           (code == 0x1ed5) ||
           (code == 0x1ed7) ||
           (code == 0x1ed9) ||
           (code == 0x1edb) ||
           (code == 0x1edd) ||
           (code == 0x1edf) ||
           (code == 0x1ee1) ||
           (code == 0x1ee3) ||
           (code == 0x1ee5) ||
           (code == 0x1ee7) ||
           (code == 0x1ee9) ||
           (code == 0x1eeb) ||
           (code == 0x1eed) ||
           (code == 0x1eef) ||
           (code == 0x1ef1) ||
           (code == 0x1ef3) ||
           (code == 0x1ef5) ||
           (code == 0x1ef7) ||
           (code == 0x1ef9) ||
           ((code >= 0x1f00) && (code <= 0x1f07)) ||
           ((code >= 0x1f10) && (code <= 0x1f15)) ||
           ((code >= 0x1f20) && (code <= 0x1f27)) ||
           ((code >= 0x1f30) && (code <= 0x1f37)) ||
           ((code >= 0x1f40) && (code <= 0x1f45)) ||
           ((code >= 0x1f50) && (code <= 0x1f57)) ||
           ((code >= 0x1f60) && (code <= 0x1f67)) ||
           ((code >= 0x1f70) && (code <= 0x1f7d)) ||
           ((code >= 0x1f80) && (code <= 0x1f87)) ||
           ((code >= 0x1f90) && (code <= 0x1f97)) ||
           ((code >= 0x1fa0) && (code <= 0x1fa7)) ||
           ((code >= 0x1fb0) && (code <= 0x1fb4)) ||
           ((code >= 0x1fb6) && (code <= 0x1fb7)) ||
           (code == 0x1fbe) ||
           ((code >= 0x1fc2) && (code <= 0x1fc4)) ||
           ((code >= 0x1fc6) && (code <= 0x1fc7)) ||
           ((code >= 0x1fd0) && (code <= 0x1fd3)) ||
           ((code >= 0x1fd6) && (code <= 0x1fd7)) ||
           ((code >= 0x1fe0) && (code <= 0x1fe7)) ||
           ((code >= 0x1ff2) && (code <= 0x1ff4)) ||
           ((code >= 0x1ff6) && (code <= 0x1ff7)) ||
           (code == 0x207f) ||
           (code == 0x210a) ||
           ((code >= 0x210e) && (code <= 0x210f)) ||
           (code == 0x2113) ||
           (code == 0x212f) ||
           (code == 0x2134) ||
           (code == 0x2139) ||
           ((code >= 0xfb00) && (code <= 0xfb06)) ||
           ((code >= 0xfb13) && (code <= 0xfb17)) ||
           ((code >= 0xff41) && (code <= 0xff5a)) ||
           ((code >= 0x10428) && (code <= 0x1044d)) ||
           ((code >= 0x1d41a) && (code <= 0x1d433)) ||
           ((code >= 0x1d44e) && (code <= 0x1d454)) ||
           ((code >= 0x1d456) && (code <= 0x1d467)) ||
           ((code >= 0x1d482) && (code <= 0x1d49b)) ||
           ((code >= 0x1d4b6) && (code <= 0x1d4b9)) ||
           (code == 0x1d4bb) ||
           ((code >= 0x1d4bd) && (code <= 0x1d4c0)) ||
           ((code >= 0x1d4c2) && (code <= 0x1d4c3)) ||
           ((code >= 0x1d4c5) && (code <= 0x1d4cf)) ||
           ((code >= 0x1d4ea) && (code <= 0x1d503)) ||
           ((code >= 0x1d51e) && (code <= 0x1d537)) ||
           ((code >= 0x1d552) && (code <= 0x1d56b)) ||
           ((code >= 0x1d586) && (code <= 0x1d59f)) ||
           ((code >= 0x1d5ba) && (code <= 0x1d5d3)) ||
           ((code >= 0x1d5ee) && (code <= 0x1d607)) ||
           ((code >= 0x1d622) && (code <= 0x1d63b)) ||
           ((code >= 0x1d656) && (code <= 0x1d66f)) ||
           ((code >= 0x1d68a) && (code <= 0x1d6a3)) ||
           ((code >= 0x1d6c2) && (code <= 0x1d6da)) ||
           ((code >= 0x1d6dc) && (code <= 0x1d6e1)) ||
           ((code >= 0x1d6fc) && (code <= 0x1d714)) ||
           ((code >= 0x1d716) && (code <= 0x1d71b)) ||
           ((code >= 0x1d736) && (code <= 0x1d74e)) ||
           ((code >= 0x1d750) && (code <= 0x1d755)) ||
           ((code >= 0x1d770) && (code <= 0x1d788)) ||
           ((code >= 0x1d78a) && (code <= 0x1d78f)) ||
           ((code >= 0x1d7aa) && (code <= 0x1d7c2)) ||
           ((code >= 0x1d7c4) && (code <= 0x1d7c9)));
}

/**
 * xmlUCSIsCatLm:
 * @code: UCS code point
 *
 * Check whether the character is part of Lm UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatLm(int code) {
    return(((code >= 0x2b0) && (code <= 0x2b8)) ||
           ((code >= 0x2bb) && (code <= 0x2c1)) ||
           ((code >= 0x2d0) && (code <= 0x2d1)) ||
           ((code >= 0x2e0) && (code <= 0x2e4)) ||
           (code == 0x2ee) ||
           (code == 0x37a) ||
           (code == 0x559) ||
           (code == 0x640) ||
           ((code >= 0x6e5) && (code <= 0x6e6)) ||
           (code == 0xe46) ||
           (code == 0xec6) ||
           (code == 0x1843) ||
           (code == 0x3005) ||
           ((code >= 0x3031) && (code <= 0x3035)) ||
           ((code >= 0x309d) && (code <= 0x309e)) ||
           ((code >= 0x30fc) && (code <= 0x30fe)) ||
           (code == 0xff70) ||
           ((code >= 0xff9e) && (code <= 0xff9f)));
}

/**
 * xmlUCSIsCatLo:
 * @code: UCS code point
 *
 * Check whether the character is part of Lo UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatLo(int code) {
    return((code == 0x1bb) ||
           ((code >= 0x1c0) && (code <= 0x1c3)) ||
           ((code >= 0x5d0) && (code <= 0x5ea)) ||
           ((code >= 0x5f0) && (code <= 0x5f2)) ||
           ((code >= 0x621) && (code <= 0x63a)) ||
           ((code >= 0x641) && (code <= 0x64a)) ||
           ((code >= 0x671) && (code <= 0x6d3)) ||
           (code == 0x6d5) ||
           ((code >= 0x6fa) && (code <= 0x6fc)) ||
           (code == 0x710) ||
           ((code >= 0x712) && (code <= 0x72c)) ||
           ((code >= 0x780) && (code <= 0x7a5)) ||
           ((code >= 0x905) && (code <= 0x939)) ||
           (code == 0x93d) ||
           (code == 0x950) ||
           ((code >= 0x958) && (code <= 0x961)) ||
           ((code >= 0x985) && (code <= 0x98c)) ||
           ((code >= 0x98f) && (code <= 0x990)) ||
           ((code >= 0x993) && (code <= 0x9a8)) ||
           ((code >= 0x9aa) && (code <= 0x9b0)) ||
           (code == 0x9b2) ||
           ((code >= 0x9b6) && (code <= 0x9b9)) ||
           ((code >= 0x9dc) && (code <= 0x9dd)) ||
           ((code >= 0x9df) && (code <= 0x9e1)) ||
           ((code >= 0x9f0) && (code <= 0x9f1)) ||
           ((code >= 0xa05) && (code <= 0xa0a)) ||
           ((code >= 0xa0f) && (code <= 0xa10)) ||
           ((code >= 0xa13) && (code <= 0xa28)) ||
           ((code >= 0xa2a) && (code <= 0xa30)) ||
           ((code >= 0xa32) && (code <= 0xa33)) ||
           ((code >= 0xa35) && (code <= 0xa36)) ||
           ((code >= 0xa38) && (code <= 0xa39)) ||
           ((code >= 0xa59) && (code <= 0xa5c)) ||
           (code == 0xa5e) ||
           ((code >= 0xa72) && (code <= 0xa74)) ||
           ((code >= 0xa85) && (code <= 0xa8b)) ||
           (code == 0xa8d) ||
           ((code >= 0xa8f) && (code <= 0xa91)) ||
           ((code >= 0xa93) && (code <= 0xaa8)) ||
           ((code >= 0xaaa) && (code <= 0xab0)) ||
           ((code >= 0xab2) && (code <= 0xab3)) ||
           ((code >= 0xab5) && (code <= 0xab9)) ||
           (code == 0xabd) ||
           (code == 0xad0) ||
           (code == 0xae0) ||
           ((code >= 0xb05) && (code <= 0xb0c)) ||
           ((code >= 0xb0f) && (code <= 0xb10)) ||
           ((code >= 0xb13) && (code <= 0xb28)) ||
           ((code >= 0xb2a) && (code <= 0xb30)) ||
           ((code >= 0xb32) && (code <= 0xb33)) ||
           ((code >= 0xb36) && (code <= 0xb39)) ||
           (code == 0xb3d) ||
           ((code >= 0xb5c) && (code <= 0xb5d)) ||
           ((code >= 0xb5f) && (code <= 0xb61)) ||
           ((code >= 0xb85) && (code <= 0xb8a)) ||
           ((code >= 0xb8e) && (code <= 0xb90)) ||
           ((code >= 0xb92) && (code <= 0xb95)) ||
           ((code >= 0xb99) && (code <= 0xb9a)) ||
           (code == 0xb9c) ||
           ((code >= 0xb9e) && (code <= 0xb9f)) ||
           ((code >= 0xba3) && (code <= 0xba4)) ||
           ((code >= 0xba8) && (code <= 0xbaa)) ||
           ((code >= 0xbae) && (code <= 0xbb5)) ||
           ((code >= 0xbb7) && (code <= 0xbb9)) ||
           ((code >= 0xc05) && (code <= 0xc0c)) ||
           ((code >= 0xc0e) && (code <= 0xc10)) ||
           ((code >= 0xc12) && (code <= 0xc28)) ||
           ((code >= 0xc2a) && (code <= 0xc33)) ||
           ((code >= 0xc35) && (code <= 0xc39)) ||
           ((code >= 0xc60) && (code <= 0xc61)) ||
           ((code >= 0xc85) && (code <= 0xc8c)) ||
           ((code >= 0xc8e) && (code <= 0xc90)) ||
           ((code >= 0xc92) && (code <= 0xca8)) ||
           ((code >= 0xcaa) && (code <= 0xcb3)) ||
           ((code >= 0xcb5) && (code <= 0xcb9)) ||
           (code == 0xcde) ||
           ((code >= 0xce0) && (code <= 0xce1)) ||
           ((code >= 0xd05) && (code <= 0xd0c)) ||
           ((code >= 0xd0e) && (code <= 0xd10)) ||
           ((code >= 0xd12) && (code <= 0xd28)) ||
           ((code >= 0xd2a) && (code <= 0xd39)) ||
           ((code >= 0xd60) && (code <= 0xd61)) ||
           ((code >= 0xd85) && (code <= 0xd96)) ||
           ((code >= 0xd9a) && (code <= 0xdb1)) ||
           ((code >= 0xdb3) && (code <= 0xdbb)) ||
           (code == 0xdbd) ||
           ((code >= 0xdc0) && (code <= 0xdc6)) ||
           ((code >= 0xe01) && (code <= 0xe30)) ||
           ((code >= 0xe32) && (code <= 0xe33)) ||
           ((code >= 0xe40) && (code <= 0xe45)) ||
           ((code >= 0xe81) && (code <= 0xe82)) ||
           (code == 0xe84) ||
           ((code >= 0xe87) && (code <= 0xe88)) ||
           (code == 0xe8a) ||
           (code == 0xe8d) ||
           ((code >= 0xe94) && (code <= 0xe97)) ||
           ((code >= 0xe99) && (code <= 0xe9f)) ||
           ((code >= 0xea1) && (code <= 0xea3)) ||
           (code == 0xea5) ||
           (code == 0xea7) ||
           ((code >= 0xeaa) && (code <= 0xeab)) ||
           ((code >= 0xead) && (code <= 0xeb0)) ||
           ((code >= 0xeb2) && (code <= 0xeb3)) ||
           (code == 0xebd) ||
           ((code >= 0xec0) && (code <= 0xec4)) ||
           ((code >= 0xedc) && (code <= 0xedd)) ||
           (code == 0xf00) ||
           ((code >= 0xf40) && (code <= 0xf47)) ||
           ((code >= 0xf49) && (code <= 0xf6a)) ||
           ((code >= 0xf88) && (code <= 0xf8b)) ||
           ((code >= 0x1000) && (code <= 0x1021)) ||
           ((code >= 0x1023) && (code <= 0x1027)) ||
           ((code >= 0x1029) && (code <= 0x102a)) ||
           ((code >= 0x1050) && (code <= 0x1055)) ||
           ((code >= 0x10d0) && (code <= 0x10f6)) ||
           ((code >= 0x1100) && (code <= 0x1159)) ||
           ((code >= 0x115f) && (code <= 0x11a2)) ||
           ((code >= 0x11a8) && (code <= 0x11f9)) ||
           ((code >= 0x1200) && (code <= 0x1206)) ||
           ((code >= 0x1208) && (code <= 0x1246)) ||
           (code == 0x1248) ||
           ((code >= 0x124a) && (code <= 0x124d)) ||
           ((code >= 0x1250) && (code <= 0x1256)) ||
           (code == 0x1258) ||
           ((code >= 0x125a) && (code <= 0x125d)) ||
           ((code >= 0x1260) && (code <= 0x1286)) ||
           (code == 0x1288) ||
           ((code >= 0x128a) && (code <= 0x128d)) ||
           ((code >= 0x1290) && (code <= 0x12ae)) ||
           (code == 0x12b0) ||
           ((code >= 0x12b2) && (code <= 0x12b5)) ||
           ((code >= 0x12b8) && (code <= 0x12be)) ||
           (code == 0x12c0) ||
           ((code >= 0x12c2) && (code <= 0x12c5)) ||
           ((code >= 0x12c8) && (code <= 0x12ce)) ||
           ((code >= 0x12d0) && (code <= 0x12d6)) ||
           ((code >= 0x12d8) && (code <= 0x12ee)) ||
           ((code >= 0x12f0) && (code <= 0x130e)) ||
           (code == 0x1310) ||
           ((code >= 0x1312) && (code <= 0x1315)) ||
           ((code >= 0x1318) && (code <= 0x131e)) ||
           ((code >= 0x1320) && (code <= 0x1346)) ||
           ((code >= 0x1348) && (code <= 0x135a)) ||
           ((code >= 0x13a0) && (code <= 0x13f4)) ||
           ((code >= 0x1401) && (code <= 0x166c)) ||
           ((code >= 0x166f) && (code <= 0x1676)) ||
           ((code >= 0x1681) && (code <= 0x169a)) ||
           ((code >= 0x16a0) && (code <= 0x16ea)) ||
           ((code >= 0x1780) && (code <= 0x17b3)) ||
           ((code >= 0x1820) && (code <= 0x1842)) ||
           ((code >= 0x1844) && (code <= 0x1877)) ||
           ((code >= 0x1880) && (code <= 0x18a8)) ||
           ((code >= 0x2135) && (code <= 0x2138)) ||
           (code == 0x3006) ||
           ((code >= 0x3041) && (code <= 0x3094)) ||
           ((code >= 0x30a1) && (code <= 0x30fa)) ||
           ((code >= 0x3105) && (code <= 0x312c)) ||
           ((code >= 0x3131) && (code <= 0x318e)) ||
           ((code >= 0x31a0) && (code <= 0x31b7)) ||
           (code == 0x3400) ||
           (code == 0x4db5) ||
           (code == 0x4e00) ||
           (code == 0x9fa5) ||
           ((code >= 0xa000) && (code <= 0xa48c)) ||
           (code == 0xac00) ||
           (code == 0xd7a3) ||
           ((code >= 0xf900) && (code <= 0xfa2d)) ||
           (code == 0xfb1d) ||
           ((code >= 0xfb1f) && (code <= 0xfb28)) ||
           ((code >= 0xfb2a) && (code <= 0xfb36)) ||
           ((code >= 0xfb38) && (code <= 0xfb3c)) ||
           (code == 0xfb3e) ||
           ((code >= 0xfb40) && (code <= 0xfb41)) ||
           ((code >= 0xfb43) && (code <= 0xfb44)) ||
           ((code >= 0xfb46) && (code <= 0xfbb1)) ||
           ((code >= 0xfbd3) && (code <= 0xfd3d)) ||
           ((code >= 0xfd50) && (code <= 0xfd8f)) ||
           ((code >= 0xfd92) && (code <= 0xfdc7)) ||
           ((code >= 0xfdf0) && (code <= 0xfdfb)) ||
           ((code >= 0xfe70) && (code <= 0xfe72)) ||
           (code == 0xfe74) ||
           ((code >= 0xfe76) && (code <= 0xfefc)) ||
           ((code >= 0xff66) && (code <= 0xff6f)) ||
           ((code >= 0xff71) && (code <= 0xff9d)) ||
           ((code >= 0xffa0) && (code <= 0xffbe)) ||
           ((code >= 0xffc2) && (code <= 0xffc7)) ||
           ((code >= 0xffca) && (code <= 0xffcf)) ||
           ((code >= 0xffd2) && (code <= 0xffd7)) ||
           ((code >= 0xffda) && (code <= 0xffdc)) ||
           ((code >= 0x10300) && (code <= 0x1031e)) ||
           ((code >= 0x10330) && (code <= 0x10349)) ||
           (code == 0x20000) ||
           (code == 0x2a6d6) ||
           ((code >= 0x2f800) && (code <= 0x2fa1d)));
}

/**
 * xmlUCSIsCatLt:
 * @code: UCS code point
 *
 * Check whether the character is part of Lt UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatLt(int code) {
    return((code == 0x1c5) ||
           (code == 0x1c8) ||
           (code == 0x1cb) ||
           (code == 0x1f2) ||
           ((code >= 0x1f88) && (code <= 0x1f8f)) ||
           ((code >= 0x1f98) && (code <= 0x1f9f)) ||
           ((code >= 0x1fa8) && (code <= 0x1faf)) ||
           (code == 0x1fbc) ||
           (code == 0x1fcc) ||
           (code == 0x1ffc));
}

/**
 * xmlUCSIsCatLu:
 * @code: UCS code point
 *
 * Check whether the character is part of Lu UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatLu(int code) {
    return(((code >= 0x41) && (code <= 0x5a)) ||
           ((code >= 0xc0) && (code <= 0xd6)) ||
           ((code >= 0xd8) && (code <= 0xde)) ||
           (code == 0x100) ||
           (code == 0x102) ||
           (code == 0x104) ||
           (code == 0x106) ||
           (code == 0x108) ||
           (code == 0x10a) ||
           (code == 0x10c) ||
           (code == 0x10e) ||
           (code == 0x110) ||
           (code == 0x112) ||
           (code == 0x114) ||
           (code == 0x116) ||
           (code == 0x118) ||
           (code == 0x11a) ||
           (code == 0x11c) ||
           (code == 0x11e) ||
           (code == 0x120) ||
           (code == 0x122) ||
           (code == 0x124) ||
           (code == 0x126) ||
           (code == 0x128) ||
           (code == 0x12a) ||
           (code == 0x12c) ||
           (code == 0x12e) ||
           (code == 0x130) ||
           (code == 0x132) ||
           (code == 0x134) ||
           (code == 0x136) ||
           (code == 0x139) ||
           (code == 0x13b) ||
           (code == 0x13d) ||
           (code == 0x13f) ||
           (code == 0x141) ||
           (code == 0x143) ||
           (code == 0x145) ||
           (code == 0x147) ||
           (code == 0x14a) ||
           (code == 0x14c) ||
           (code == 0x14e) ||
           (code == 0x150) ||
           (code == 0x152) ||
           (code == 0x154) ||
           (code == 0x156) ||
           (code == 0x158) ||
           (code == 0x15a) ||
           (code == 0x15c) ||
           (code == 0x15e) ||
           (code == 0x160) ||
           (code == 0x162) ||
           (code == 0x164) ||
           (code == 0x166) ||
           (code == 0x168) ||
           (code == 0x16a) ||
           (code == 0x16c) ||
           (code == 0x16e) ||
           (code == 0x170) ||
           (code == 0x172) ||
           (code == 0x174) ||
           (code == 0x176) ||
           ((code >= 0x178) && (code <= 0x179)) ||
           (code == 0x17b) ||
           (code == 0x17d) ||
           ((code >= 0x181) && (code <= 0x182)) ||
           (code == 0x184) ||
           ((code >= 0x186) && (code <= 0x187)) ||
           ((code >= 0x189) && (code <= 0x18b)) ||
           ((code >= 0x18e) && (code <= 0x191)) ||
           ((code >= 0x193) && (code <= 0x194)) ||
           ((code >= 0x196) && (code <= 0x198)) ||
           ((code >= 0x19c) && (code <= 0x19d)) ||
           ((code >= 0x19f) && (code <= 0x1a0)) ||
           (code == 0x1a2) ||
           (code == 0x1a4) ||
           ((code >= 0x1a6) && (code <= 0x1a7)) ||
           (code == 0x1a9) ||
           (code == 0x1ac) ||
           ((code >= 0x1ae) && (code <= 0x1af)) ||
           ((code >= 0x1b1) && (code <= 0x1b3)) ||
           (code == 0x1b5) ||
           ((code >= 0x1b7) && (code <= 0x1b8)) ||
           (code == 0x1bc) ||
           (code == 0x1c4) ||
           (code == 0x1c7) ||
           (code == 0x1ca) ||
           (code == 0x1cd) ||
           (code == 0x1cf) ||
           (code == 0x1d1) ||
           (code == 0x1d3) ||
           (code == 0x1d5) ||
           (code == 0x1d7) ||
           (code == 0x1d9) ||
           (code == 0x1db) ||
           (code == 0x1de) ||
           (code == 0x1e0) ||
           (code == 0x1e2) ||
           (code == 0x1e4) ||
           (code == 0x1e6) ||
           (code == 0x1e8) ||
           (code == 0x1ea) ||
           (code == 0x1ec) ||
           (code == 0x1ee) ||
           (code == 0x1f1) ||
           (code == 0x1f4) ||
           ((code >= 0x1f6) && (code <= 0x1f8)) ||
           (code == 0x1fa) ||
           (code == 0x1fc) ||
           (code == 0x1fe) ||
           (code == 0x200) ||
           (code == 0x202) ||
           (code == 0x204) ||
           (code == 0x206) ||
           (code == 0x208) ||
           (code == 0x20a) ||
           (code == 0x20c) ||
           (code == 0x20e) ||
           (code == 0x210) ||
           (code == 0x212) ||
           (code == 0x214) ||
           (code == 0x216) ||
           (code == 0x218) ||
           (code == 0x21a) ||
           (code == 0x21c) ||
           (code == 0x21e) ||
           (code == 0x222) ||
           (code == 0x224) ||
           (code == 0x226) ||
           (code == 0x228) ||
           (code == 0x22a) ||
           (code == 0x22c) ||
           (code == 0x22e) ||
           (code == 0x230) ||
           (code == 0x232) ||
           (code == 0x386) ||
           ((code >= 0x388) && (code <= 0x38a)) ||
           (code == 0x38c) ||
           ((code >= 0x38e) && (code <= 0x38f)) ||
           ((code >= 0x391) && (code <= 0x3a1)) ||
           ((code >= 0x3a3) && (code <= 0x3ab)) ||
           ((code >= 0x3d2) && (code <= 0x3d4)) ||
           (code == 0x3da) ||
           (code == 0x3dc) ||
           (code == 0x3de) ||
           (code == 0x3e0) ||
           (code == 0x3e2) ||
           (code == 0x3e4) ||
           (code == 0x3e6) ||
           (code == 0x3e8) ||
           (code == 0x3ea) ||
           (code == 0x3ec) ||
           (code == 0x3ee) ||
           (code == 0x3f4) ||
           ((code >= 0x400) && (code <= 0x42f)) ||
           (code == 0x460) ||
           (code == 0x462) ||
           (code == 0x464) ||
           (code == 0x466) ||
           (code == 0x468) ||
           (code == 0x46a) ||
           (code == 0x46c) ||
           (code == 0x46e) ||
           (code == 0x470) ||
           (code == 0x472) ||
           (code == 0x474) ||
           (code == 0x476) ||
           (code == 0x478) ||
           (code == 0x47a) ||
           (code == 0x47c) ||
           (code == 0x47e) ||
           (code == 0x480) ||
           (code == 0x48c) ||
           (code == 0x48e) ||
           (code == 0x490) ||
           (code == 0x492) ||
           (code == 0x494) ||
           (code == 0x496) ||
           (code == 0x498) ||
           (code == 0x49a) ||
           (code == 0x49c) ||
           (code == 0x49e) ||
           (code == 0x4a0) ||
           (code == 0x4a2) ||
           (code == 0x4a4) ||
           (code == 0x4a6) ||
           (code == 0x4a8) ||
           (code == 0x4aa) ||
           (code == 0x4ac) ||
           (code == 0x4ae) ||
           (code == 0x4b0) ||
           (code == 0x4b2) ||
           (code == 0x4b4) ||
           (code == 0x4b6) ||
           (code == 0x4b8) ||
           (code == 0x4ba) ||
           (code == 0x4bc) ||
           (code == 0x4be) ||
           ((code >= 0x4c0) && (code <= 0x4c1)) ||
           (code == 0x4c3) ||
           (code == 0x4c7) ||
           (code == 0x4cb) ||
           (code == 0x4d0) ||
           (code == 0x4d2) ||
           (code == 0x4d4) ||
           (code == 0x4d6) ||
           (code == 0x4d8) ||
           (code == 0x4da) ||
           (code == 0x4dc) ||
           (code == 0x4de) ||
           (code == 0x4e0) ||
           (code == 0x4e2) ||
           (code == 0x4e4) ||
           (code == 0x4e6) ||
           (code == 0x4e8) ||
           (code == 0x4ea) ||
           (code == 0x4ec) ||
           (code == 0x4ee) ||
           (code == 0x4f0) ||
           (code == 0x4f2) ||
           (code == 0x4f4) ||
           (code == 0x4f8) ||
           ((code >= 0x531) && (code <= 0x556)) ||
           ((code >= 0x10a0) && (code <= 0x10c5)) ||
           (code == 0x1e00) ||
           (code == 0x1e02) ||
           (code == 0x1e04) ||
           (code == 0x1e06) ||
           (code == 0x1e08) ||
           (code == 0x1e0a) ||
           (code == 0x1e0c) ||
           (code == 0x1e0e) ||
           (code == 0x1e10) ||
           (code == 0x1e12) ||
           (code == 0x1e14) ||
           (code == 0x1e16) ||
           (code == 0x1e18) ||
           (code == 0x1e1a) ||
           (code == 0x1e1c) ||
           (code == 0x1e1e) ||
           (code == 0x1e20) ||
           (code == 0x1e22) ||
           (code == 0x1e24) ||
           (code == 0x1e26) ||
           (code == 0x1e28) ||
           (code == 0x1e2a) ||
           (code == 0x1e2c) ||
           (code == 0x1e2e) ||
           (code == 0x1e30) ||
           (code == 0x1e32) ||
           (code == 0x1e34) ||
           (code == 0x1e36) ||
           (code == 0x1e38) ||
           (code == 0x1e3a) ||
           (code == 0x1e3c) ||
           (code == 0x1e3e) ||
           (code == 0x1e40) ||
           (code == 0x1e42) ||
           (code == 0x1e44) ||
           (code == 0x1e46) ||
           (code == 0x1e48) ||
           (code == 0x1e4a) ||
           (code == 0x1e4c) ||
           (code == 0x1e4e) ||
           (code == 0x1e50) ||
           (code == 0x1e52) ||
           (code == 0x1e54) ||
           (code == 0x1e56) ||
           (code == 0x1e58) ||
           (code == 0x1e5a) ||
           (code == 0x1e5c) ||
           (code == 0x1e5e) ||
           (code == 0x1e60) ||
           (code == 0x1e62) ||
           (code == 0x1e64) ||
           (code == 0x1e66) ||
           (code == 0x1e68) ||
           (code == 0x1e6a) ||
           (code == 0x1e6c) ||
           (code == 0x1e6e) ||
           (code == 0x1e70) ||
           (code == 0x1e72) ||
           (code == 0x1e74) ||
           (code == 0x1e76) ||
           (code == 0x1e78) ||
           (code == 0x1e7a) ||
           (code == 0x1e7c) ||
           (code == 0x1e7e) ||
           (code == 0x1e80) ||
           (code == 0x1e82) ||
           (code == 0x1e84) ||
           (code == 0x1e86) ||
           (code == 0x1e88) ||
           (code == 0x1e8a) ||
           (code == 0x1e8c) ||
           (code == 0x1e8e) ||
           (code == 0x1e90) ||
           (code == 0x1e92) ||
           (code == 0x1e94) ||
           (code == 0x1ea0) ||
           (code == 0x1ea2) ||
           (code == 0x1ea4) ||
           (code == 0x1ea6) ||
           (code == 0x1ea8) ||
           (code == 0x1eaa) ||
           (code == 0x1eac) ||
           (code == 0x1eae) ||
           (code == 0x1eb0) ||
           (code == 0x1eb2) ||
           (code == 0x1eb4) ||
           (code == 0x1eb6) ||
           (code == 0x1eb8) ||
           (code == 0x1eba) ||
           (code == 0x1ebc) ||
           (code == 0x1ebe) ||
           (code == 0x1ec0) ||
           (code == 0x1ec2) ||
           (code == 0x1ec4) ||
           (code == 0x1ec6) ||
           (code == 0x1ec8) ||
           (code == 0x1eca) ||
           (code == 0x1ecc) ||
           (code == 0x1ece) ||
           (code == 0x1ed0) ||
           (code == 0x1ed2) ||
           (code == 0x1ed4) ||
           (code == 0x1ed6) ||
           (code == 0x1ed8) ||
           (code == 0x1eda) ||
           (code == 0x1edc) ||
           (code == 0x1ede) ||
           (code == 0x1ee0) ||
           (code == 0x1ee2) ||
           (code == 0x1ee4) ||
           (code == 0x1ee6) ||
           (code == 0x1ee8) ||
           (code == 0x1eea) ||
           (code == 0x1eec) ||
           (code == 0x1eee) ||
           (code == 0x1ef0) ||
           (code == 0x1ef2) ||
           (code == 0x1ef4) ||
           (code == 0x1ef6) ||
           (code == 0x1ef8) ||
           ((code >= 0x1f08) && (code <= 0x1f0f)) ||
           ((code >= 0x1f18) && (code <= 0x1f1d)) ||
           ((code >= 0x1f28) && (code <= 0x1f2f)) ||
           ((code >= 0x1f38) && (code <= 0x1f3f)) ||
           ((code >= 0x1f48) && (code <= 0x1f4d)) ||
           (code == 0x1f59) ||
           (code == 0x1f5b) ||
           (code == 0x1f5d) ||
           (code == 0x1f5f) ||
           ((code >= 0x1f68) && (code <= 0x1f6f)) ||
           ((code >= 0x1fb8) && (code <= 0x1fbb)) ||
           ((code >= 0x1fc8) && (code <= 0x1fcb)) ||
           ((code >= 0x1fd8) && (code <= 0x1fdb)) ||
           ((code >= 0x1fe8) && (code <= 0x1fec)) ||
           ((code >= 0x1ff8) && (code <= 0x1ffb)) ||
           (code == 0x2102) ||
           (code == 0x2107) ||
           ((code >= 0x210b) && (code <= 0x210d)) ||
           ((code >= 0x2110) && (code <= 0x2112)) ||
           (code == 0x2115) ||
           ((code >= 0x2119) && (code <= 0x211d)) ||
           (code == 0x2124) ||
           (code == 0x2126) ||
           (code == 0x2128) ||
           ((code >= 0x212a) && (code <= 0x212d)) ||
           ((code >= 0x2130) && (code <= 0x2131)) ||
           (code == 0x2133) ||
           ((code >= 0xff21) && (code <= 0xff3a)) ||
           ((code >= 0x10400) && (code <= 0x10425)) ||
           ((code >= 0x1d400) && (code <= 0x1d419)) ||
           ((code >= 0x1d434) && (code <= 0x1d44d)) ||
           ((code >= 0x1d468) && (code <= 0x1d481)) ||
           (code == 0x1d49c) ||
           ((code >= 0x1d49e) && (code <= 0x1d49f)) ||
           (code == 0x1d4a2) ||
           ((code >= 0x1d4a5) && (code <= 0x1d4a6)) ||
           ((code >= 0x1d4a9) && (code <= 0x1d4ac)) ||
           ((code >= 0x1d4ae) && (code <= 0x1d4b5)) ||
           ((code >= 0x1d4d0) && (code <= 0x1d4e9)) ||
           ((code >= 0x1d504) && (code <= 0x1d505)) ||
           ((code >= 0x1d507) && (code <= 0x1d50a)) ||
           ((code >= 0x1d50d) && (code <= 0x1d514)) ||
           ((code >= 0x1d516) && (code <= 0x1d51c)) ||
           ((code >= 0x1d538) && (code <= 0x1d539)) ||
           ((code >= 0x1d53b) && (code <= 0x1d53e)) ||
           ((code >= 0x1d540) && (code <= 0x1d544)) ||
           (code == 0x1d546) ||
           ((code >= 0x1d54a) && (code <= 0x1d550)) ||
           ((code >= 0x1d56c) && (code <= 0x1d585)) ||
           ((code >= 0x1d5a0) && (code <= 0x1d5b9)) ||
           ((code >= 0x1d5d4) && (code <= 0x1d5ed)) ||
           ((code >= 0x1d608) && (code <= 0x1d621)) ||
           ((code >= 0x1d63c) && (code <= 0x1d655)) ||
           ((code >= 0x1d670) && (code <= 0x1d689)) ||
           ((code >= 0x1d6a8) && (code <= 0x1d6c0)) ||
           ((code >= 0x1d6e2) && (code <= 0x1d6fa)) ||
           ((code >= 0x1d71c) && (code <= 0x1d734)) ||
           ((code >= 0x1d756) && (code <= 0x1d76e)) ||
           ((code >= 0x1d790) && (code <= 0x1d7a8)));
}

/**
 * xmlUCSIsCatM:
 * @code: UCS code point
 *
 * Check whether the character is part of M UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatM(int code) {
    return(((code >= 0x300) && (code <= 0x34e)) ||
           ((code >= 0x360) && (code <= 0x362)) ||
           ((code >= 0x483) && (code <= 0x486)) ||
           ((code >= 0x488) && (code <= 0x489)) ||
           ((code >= 0x591) && (code <= 0x5a1)) ||
           ((code >= 0x5a3) && (code <= 0x5b9)) ||
           ((code >= 0x5bb) && (code <= 0x5bd)) ||
           (code == 0x5bf) ||
           ((code >= 0x5c1) && (code <= 0x5c2)) ||
           (code == 0x5c4) ||
           ((code >= 0x64b) && (code <= 0x655)) ||
           (code == 0x670) ||
           ((code >= 0x6d6) && (code <= 0x6e4)) ||
           ((code >= 0x6e7) && (code <= 0x6e8)) ||
           ((code >= 0x6ea) && (code <= 0x6ed)) ||
           (code == 0x711) ||
           ((code >= 0x730) && (code <= 0x74a)) ||
           ((code >= 0x7a6) && (code <= 0x7b0)) ||
           ((code >= 0x901) && (code <= 0x903)) ||
           (code == 0x93c) ||
           ((code >= 0x93e) && (code <= 0x94d)) ||
           ((code >= 0x951) && (code <= 0x954)) ||
           ((code >= 0x962) && (code <= 0x963)) ||
           ((code >= 0x981) && (code <= 0x983)) ||
           (code == 0x9bc) ||
           ((code >= 0x9be) && (code <= 0x9c4)) ||
           ((code >= 0x9c7) && (code <= 0x9c8)) ||
           ((code >= 0x9cb) && (code <= 0x9cd)) ||
           (code == 0x9d7) ||
           ((code >= 0x9e2) && (code <= 0x9e3)) ||
           (code == 0xa02) ||
           (code == 0xa3c) ||
           ((code >= 0xa3e) && (code <= 0xa42)) ||
           ((code >= 0xa47) && (code <= 0xa48)) ||
           ((code >= 0xa4b) && (code <= 0xa4d)) ||
           ((code >= 0xa70) && (code <= 0xa71)) ||
           ((code >= 0xa81) && (code <= 0xa83)) ||
           (code == 0xabc) ||
           ((code >= 0xabe) && (code <= 0xac5)) ||
           ((code >= 0xac7) && (code <= 0xac9)) ||
           ((code >= 0xacb) && (code <= 0xacd)) ||
           ((code >= 0xb01) && (code <= 0xb03)) ||
           (code == 0xb3c) ||
           ((code >= 0xb3e) && (code <= 0xb43)) ||
           ((code >= 0xb47) && (code <= 0xb48)) ||
           ((code >= 0xb4b) && (code <= 0xb4d)) ||
           ((code >= 0xb56) && (code <= 0xb57)) ||
           ((code >= 0xb82) && (code <= 0xb83)) ||
           ((code >= 0xbbe) && (code <= 0xbc2)) ||
           ((code >= 0xbc6) && (code <= 0xbc8)) ||
           ((code >= 0xbca) && (code <= 0xbcd)) ||
           (code == 0xbd7) ||
           ((code >= 0xc01) && (code <= 0xc03)) ||
           ((code >= 0xc3e) && (code <= 0xc44)) ||
           ((code >= 0xc46) && (code <= 0xc48)) ||
           ((code >= 0xc4a) && (code <= 0xc4d)) ||
           ((code >= 0xc55) && (code <= 0xc56)) ||
           ((code >= 0xc82) && (code <= 0xc83)) ||
           ((code >= 0xcbe) && (code <= 0xcc4)) ||
           ((code >= 0xcc6) && (code <= 0xcc8)) ||
           ((code >= 0xcca) && (code <= 0xccd)) ||
           ((code >= 0xcd5) && (code <= 0xcd6)) ||
           ((code >= 0xd02) && (code <= 0xd03)) ||
           ((code >= 0xd3e) && (code <= 0xd43)) ||
           ((code >= 0xd46) && (code <= 0xd48)) ||
           ((code >= 0xd4a) && (code <= 0xd4d)) ||
           (code == 0xd57) ||
           ((code >= 0xd82) && (code <= 0xd83)) ||
           (code == 0xdca) ||
           ((code >= 0xdcf) && (code <= 0xdd4)) ||
           (code == 0xdd6) ||
           ((code >= 0xdd8) && (code <= 0xddf)) ||
           ((code >= 0xdf2) && (code <= 0xdf3)) ||
           (code == 0xe31) ||
           ((code >= 0xe34) && (code <= 0xe3a)) ||
           ((code >= 0xe47) && (code <= 0xe4e)) ||
           (code == 0xeb1) ||
           ((code >= 0xeb4) && (code <= 0xeb9)) ||
           ((code >= 0xebb) && (code <= 0xebc)) ||
           ((code >= 0xec8) && (code <= 0xecd)) ||
           ((code >= 0xf18) && (code <= 0xf19)) ||
           (code == 0xf35) ||
           (code == 0xf37) ||
           (code == 0xf39) ||
           ((code >= 0xf3e) && (code <= 0xf3f)) ||
           ((code >= 0xf71) && (code <= 0xf84)) ||
           ((code >= 0xf86) && (code <= 0xf87)) ||
           ((code >= 0xf90) && (code <= 0xf97)) ||
           ((code >= 0xf99) && (code <= 0xfbc)) ||
           (code == 0xfc6) ||
           ((code >= 0x102c) && (code <= 0x1032)) ||
           ((code >= 0x1036) && (code <= 0x1039)) ||
           ((code >= 0x1056) && (code <= 0x1059)) ||
           ((code >= 0x17b4) && (code <= 0x17d3)) ||
           (code == 0x18a9) ||
           ((code >= 0x20d0) && (code <= 0x20e3)) ||
           ((code >= 0x302a) && (code <= 0x302f)) ||
           ((code >= 0x3099) && (code <= 0x309a)) ||
           (code == 0xfb1e) ||
           ((code >= 0xfe20) && (code <= 0xfe23)) ||
           ((code >= 0x1d165) && (code <= 0x1d169)) ||
           ((code >= 0x1d16d) && (code <= 0x1d172)) ||
           ((code >= 0x1d17b) && (code <= 0x1d182)) ||
           ((code >= 0x1d185) && (code <= 0x1d18b)) ||
           ((code >= 0x1d1aa) && (code <= 0x1d1ad)));
}

/**
 * xmlUCSIsCatMc:
 * @code: UCS code point
 *
 * Check whether the character is part of Mc UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatMc(int code) {
    return((code == 0x903) ||
           ((code >= 0x93e) && (code <= 0x940)) ||
           ((code >= 0x949) && (code <= 0x94c)) ||
           ((code >= 0x982) && (code <= 0x983)) ||
           ((code >= 0x9be) && (code <= 0x9c0)) ||
           ((code >= 0x9c7) && (code <= 0x9c8)) ||
           ((code >= 0x9cb) && (code <= 0x9cc)) ||
           (code == 0x9d7) ||
           ((code >= 0xa3e) && (code <= 0xa40)) ||
           (code == 0xa83) ||
           ((code >= 0xabe) && (code <= 0xac0)) ||
           (code == 0xac9) ||
           ((code >= 0xacb) && (code <= 0xacc)) ||
           ((code >= 0xb02) && (code <= 0xb03)) ||
           (code == 0xb3e) ||
           (code == 0xb40) ||
           ((code >= 0xb47) && (code <= 0xb48)) ||
           ((code >= 0xb4b) && (code <= 0xb4c)) ||
           (code == 0xb57) ||
           (code == 0xb83) ||
           ((code >= 0xbbe) && (code <= 0xbbf)) ||
           ((code >= 0xbc1) && (code <= 0xbc2)) ||
           ((code >= 0xbc6) && (code <= 0xbc8)) ||
           ((code >= 0xbca) && (code <= 0xbcc)) ||
           (code == 0xbd7) ||
           ((code >= 0xc01) && (code <= 0xc03)) ||
           ((code >= 0xc41) && (code <= 0xc44)) ||
           ((code >= 0xc82) && (code <= 0xc83)) ||
           (code == 0xcbe) ||
           ((code >= 0xcc0) && (code <= 0xcc4)) ||
           ((code >= 0xcc7) && (code <= 0xcc8)) ||
           ((code >= 0xcca) && (code <= 0xccb)) ||
           ((code >= 0xcd5) && (code <= 0xcd6)) ||
           ((code >= 0xd02) && (code <= 0xd03)) ||
           ((code >= 0xd3e) && (code <= 0xd40)) ||
           ((code >= 0xd46) && (code <= 0xd48)) ||
           ((code >= 0xd4a) && (code <= 0xd4c)) ||
           (code == 0xd57) ||
           ((code >= 0xd82) && (code <= 0xd83)) ||
           ((code >= 0xdcf) && (code <= 0xdd1)) ||
           ((code >= 0xdd8) && (code <= 0xddf)) ||
           ((code >= 0xdf2) && (code <= 0xdf3)) ||
           ((code >= 0xf3e) && (code <= 0xf3f)) ||
           (code == 0xf7f) ||
           (code == 0x102c) ||
           (code == 0x1031) ||
           (code == 0x1038) ||
           ((code >= 0x1056) && (code <= 0x1057)) ||
           ((code >= 0x17b4) && (code <= 0x17b6)) ||
           ((code >= 0x17be) && (code <= 0x17c5)) ||
           ((code >= 0x17c7) && (code <= 0x17c8)) ||
           ((code >= 0x1d165) && (code <= 0x1d166)) ||
           ((code >= 0x1d16d) && (code <= 0x1d172)));
}

/**
 * xmlUCSIsCatMe:
 * @code: UCS code point
 *
 * Check whether the character is part of Me UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatMe(int code) {
    return(((code >= 0x488) && (code <= 0x489)) ||
           ((code >= 0x6dd) && (code <= 0x6de)) ||
           ((code >= 0x20dd) && (code <= 0x20e0)) ||
           ((code >= 0x20e2) && (code <= 0x20e3)));
}

/**
 * xmlUCSIsCatMn:
 * @code: UCS code point
 *
 * Check whether the character is part of Mn UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatMn(int code) {
    return(((code >= 0x300) && (code <= 0x34e)) ||
           ((code >= 0x360) && (code <= 0x362)) ||
           ((code >= 0x483) && (code <= 0x486)) ||
           ((code >= 0x591) && (code <= 0x5a1)) ||
           ((code >= 0x5a3) && (code <= 0x5b9)) ||
           ((code >= 0x5bb) && (code <= 0x5bd)) ||
           (code == 0x5bf) ||
           ((code >= 0x5c1) && (code <= 0x5c2)) ||
           (code == 0x5c4) ||
           ((code >= 0x64b) && (code <= 0x655)) ||
           (code == 0x670) ||
           ((code >= 0x6d6) && (code <= 0x6dc)) ||
           ((code >= 0x6df) && (code <= 0x6e4)) ||
           ((code >= 0x6e7) && (code <= 0x6e8)) ||
           ((code >= 0x6ea) && (code <= 0x6ed)) ||
           (code == 0x711) ||
           ((code >= 0x730) && (code <= 0x74a)) ||
           ((code >= 0x7a6) && (code <= 0x7b0)) ||
           ((code >= 0x901) && (code <= 0x902)) ||
           (code == 0x93c) ||
           ((code >= 0x941) && (code <= 0x948)) ||
           (code == 0x94d) ||
           ((code >= 0x951) && (code <= 0x954)) ||
           ((code >= 0x962) && (code <= 0x963)) ||
           (code == 0x981) ||
           (code == 0x9bc) ||
           ((code >= 0x9c1) && (code <= 0x9c4)) ||
           (code == 0x9cd) ||
           ((code >= 0x9e2) && (code <= 0x9e3)) ||
           (code == 0xa02) ||
           (code == 0xa3c) ||
           ((code >= 0xa41) && (code <= 0xa42)) ||
           ((code >= 0xa47) && (code <= 0xa48)) ||
           ((code >= 0xa4b) && (code <= 0xa4d)) ||
           ((code >= 0xa70) && (code <= 0xa71)) ||
           ((code >= 0xa81) && (code <= 0xa82)) ||
           (code == 0xabc) ||
           ((code >= 0xac1) && (code <= 0xac5)) ||
           ((code >= 0xac7) && (code <= 0xac8)) ||
           (code == 0xacd) ||
           (code == 0xb01) ||
           (code == 0xb3c) ||
           (code == 0xb3f) ||
           ((code >= 0xb41) && (code <= 0xb43)) ||
           (code == 0xb4d) ||
           (code == 0xb56) ||
           (code == 0xb82) ||
           (code == 0xbc0) ||
           (code == 0xbcd) ||
           ((code >= 0xc3e) && (code <= 0xc40)) ||
           ((code >= 0xc46) && (code <= 0xc48)) ||
           ((code >= 0xc4a) && (code <= 0xc4d)) ||
           ((code >= 0xc55) && (code <= 0xc56)) ||
           (code == 0xcbf) ||
           (code == 0xcc6) ||
           ((code >= 0xccc) && (code <= 0xccd)) ||
           ((code >= 0xd41) && (code <= 0xd43)) ||
           (code == 0xd4d) ||
           (code == 0xdca) ||
           ((code >= 0xdd2) && (code <= 0xdd4)) ||
           (code == 0xdd6) ||
           (code == 0xe31) ||
           ((code >= 0xe34) && (code <= 0xe3a)) ||
           ((code >= 0xe47) && (code <= 0xe4e)) ||
           (code == 0xeb1) ||
           ((code >= 0xeb4) && (code <= 0xeb9)) ||
           ((code >= 0xebb) && (code <= 0xebc)) ||
           ((code >= 0xec8) && (code <= 0xecd)) ||
           ((code >= 0xf18) && (code <= 0xf19)) ||
           (code == 0xf35) ||
           (code == 0xf37) ||
           (code == 0xf39) ||
           ((code >= 0xf71) && (code <= 0xf7e)) ||
           ((code >= 0xf80) && (code <= 0xf84)) ||
           ((code >= 0xf86) && (code <= 0xf87)) ||
           ((code >= 0xf90) && (code <= 0xf97)) ||
           ((code >= 0xf99) && (code <= 0xfbc)) ||
           (code == 0xfc6) ||
           ((code >= 0x102d) && (code <= 0x1030)) ||
           (code == 0x1032) ||
           ((code >= 0x1036) && (code <= 0x1037)) ||
           (code == 0x1039) ||
           ((code >= 0x1058) && (code <= 0x1059)) ||
           ((code >= 0x17b7) && (code <= 0x17bd)) ||
           (code == 0x17c6) ||
           ((code >= 0x17c9) && (code <= 0x17d3)) ||
           (code == 0x18a9) ||
           ((code >= 0x20d0) && (code <= 0x20dc)) ||
           (code == 0x20e1) ||
           ((code >= 0x302a) && (code <= 0x302f)) ||
           ((code >= 0x3099) && (code <= 0x309a)) ||
           (code == 0xfb1e) ||
           ((code >= 0xfe20) && (code <= 0xfe23)) ||
           ((code >= 0x1d167) && (code <= 0x1d169)) ||
           ((code >= 0x1d17b) && (code <= 0x1d182)) ||
           ((code >= 0x1d185) && (code <= 0x1d18b)) ||
           ((code >= 0x1d1aa) && (code <= 0x1d1ad)));
}

/**
 * xmlUCSIsCatN:
 * @code: UCS code point
 *
 * Check whether the character is part of N UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatN(int code) {
    return(((code >= 0x30) && (code <= 0x39)) ||
           ((code >= 0xb2) && (code <= 0xb3)) ||
           (code == 0xb9) ||
           ((code >= 0xbc) && (code <= 0xbe)) ||
           ((code >= 0x660) && (code <= 0x669)) ||
           ((code >= 0x6f0) && (code <= 0x6f9)) ||
           ((code >= 0x966) && (code <= 0x96f)) ||
           ((code >= 0x9e6) && (code <= 0x9ef)) ||
           ((code >= 0x9f4) && (code <= 0x9f9)) ||
           ((code >= 0xa66) && (code <= 0xa6f)) ||
           ((code >= 0xae6) && (code <= 0xaef)) ||
           ((code >= 0xb66) && (code <= 0xb6f)) ||
           ((code >= 0xbe7) && (code <= 0xbf2)) ||
           ((code >= 0xc66) && (code <= 0xc6f)) ||
           ((code >= 0xce6) && (code <= 0xcef)) ||
           ((code >= 0xd66) && (code <= 0xd6f)) ||
           ((code >= 0xe50) && (code <= 0xe59)) ||
           ((code >= 0xed0) && (code <= 0xed9)) ||
           ((code >= 0xf20) && (code <= 0xf33)) ||
           ((code >= 0x1040) && (code <= 0x1049)) ||
           ((code >= 0x1369) && (code <= 0x137c)) ||
           ((code >= 0x16ee) && (code <= 0x16f0)) ||
           ((code >= 0x17e0) && (code <= 0x17e9)) ||
           ((code >= 0x1810) && (code <= 0x1819)) ||
           (code == 0x2070) ||
           ((code >= 0x2074) && (code <= 0x2079)) ||
           ((code >= 0x2080) && (code <= 0x2089)) ||
           ((code >= 0x2153) && (code <= 0x2183)) ||
           ((code >= 0x2460) && (code <= 0x249b)) ||
           (code == 0x24ea) ||
           ((code >= 0x2776) && (code <= 0x2793)) ||
           (code == 0x3007) ||
           ((code >= 0x3021) && (code <= 0x3029)) ||
           ((code >= 0x3038) && (code <= 0x303a)) ||
           ((code >= 0x3192) && (code <= 0x3195)) ||
           ((code >= 0x3220) && (code <= 0x3229)) ||
           ((code >= 0x3280) && (code <= 0x3289)) ||
           ((code >= 0xff10) && (code <= 0xff19)) ||
           ((code >= 0x10320) && (code <= 0x10323)) ||
           (code == 0x1034a) ||
           ((code >= 0x1d7ce) && (code <= 0x1d7ff)));
}

/**
 * xmlUCSIsCatNd:
 * @code: UCS code point
 *
 * Check whether the character is part of Nd UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatNd(int code) {
    return(((code >= 0x30) && (code <= 0x39)) ||
           ((code >= 0x660) && (code <= 0x669)) ||
           ((code >= 0x6f0) && (code <= 0x6f9)) ||
           ((code >= 0x966) && (code <= 0x96f)) ||
           ((code >= 0x9e6) && (code <= 0x9ef)) ||
           ((code >= 0xa66) && (code <= 0xa6f)) ||
           ((code >= 0xae6) && (code <= 0xaef)) ||
           ((code >= 0xb66) && (code <= 0xb6f)) ||
           ((code >= 0xbe7) && (code <= 0xbef)) ||
           ((code >= 0xc66) && (code <= 0xc6f)) ||
           ((code >= 0xce6) && (code <= 0xcef)) ||
           ((code >= 0xd66) && (code <= 0xd6f)) ||
           ((code >= 0xe50) && (code <= 0xe59)) ||
           ((code >= 0xed0) && (code <= 0xed9)) ||
           ((code >= 0xf20) && (code <= 0xf29)) ||
           ((code >= 0x1040) && (code <= 0x1049)) ||
           ((code >= 0x1369) && (code <= 0x1371)) ||
           ((code >= 0x17e0) && (code <= 0x17e9)) ||
           ((code >= 0x1810) && (code <= 0x1819)) ||
           ((code >= 0xff10) && (code <= 0xff19)) ||
           ((code >= 0x1d7ce) && (code <= 0x1d7ff)));
}

/**
 * xmlUCSIsCatNl:
 * @code: UCS code point
 *
 * Check whether the character is part of Nl UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatNl(int code) {
    return(((code >= 0x16ee) && (code <= 0x16f0)) ||
           ((code >= 0x2160) && (code <= 0x2183)) ||
           (code == 0x3007) ||
           ((code >= 0x3021) && (code <= 0x3029)) ||
           ((code >= 0x3038) && (code <= 0x303a)) ||
           (code == 0x1034a));
}

/**
 * xmlUCSIsCatNo:
 * @code: UCS code point
 *
 * Check whether the character is part of No UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatNo(int code) {
    return(((code >= 0xb2) && (code <= 0xb3)) ||
           (code == 0xb9) ||
           ((code >= 0xbc) && (code <= 0xbe)) ||
           ((code >= 0x9f4) && (code <= 0x9f9)) ||
           ((code >= 0xbf0) && (code <= 0xbf2)) ||
           ((code >= 0xf2a) && (code <= 0xf33)) ||
           ((code >= 0x1372) && (code <= 0x137c)) ||
           (code == 0x2070) ||
           ((code >= 0x2074) && (code <= 0x2079)) ||
           ((code >= 0x2080) && (code <= 0x2089)) ||
           ((code >= 0x2153) && (code <= 0x215f)) ||
           ((code >= 0x2460) && (code <= 0x249b)) ||
           (code == 0x24ea) ||
           ((code >= 0x2776) && (code <= 0x2793)) ||
           ((code >= 0x3192) && (code <= 0x3195)) ||
           ((code >= 0x3220) && (code <= 0x3229)) ||
           ((code >= 0x3280) && (code <= 0x3289)) ||
           ((code >= 0x10320) && (code <= 0x10323)));
}

/**
 * xmlUCSIsCatP:
 * @code: UCS code point
 *
 * Check whether the character is part of P UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatP(int code) {
    return(((code >= 0x21) && (code <= 0x23)) ||
           ((code >= 0x25) && (code <= 0x2a)) ||
           ((code >= 0x2c) && (code <= 0x2f)) ||
           ((code >= 0x3a) && (code <= 0x3b)) ||
           ((code >= 0x3f) && (code <= 0x40)) ||
           ((code >= 0x5b) && (code <= 0x5d)) ||
           (code == 0x5f) ||
           (code == 0x7b) ||
           (code == 0x7d) ||
           (code == 0xa1) ||
           (code == 0xab) ||
           (code == 0xad) ||
           (code == 0xb7) ||
           (code == 0xbb) ||
           (code == 0xbf) ||
           (code == 0x37e) ||
           (code == 0x387) ||
           ((code >= 0x55a) && (code <= 0x55f)) ||
           ((code >= 0x589) && (code <= 0x58a)) ||
           (code == 0x5be) ||
           (code == 0x5c0) ||
           (code == 0x5c3) ||
           ((code >= 0x5f3) && (code <= 0x5f4)) ||
           (code == 0x60c) ||
           (code == 0x61b) ||
           (code == 0x61f) ||
           ((code >= 0x66a) && (code <= 0x66d)) ||
           (code == 0x6d4) ||
           ((code >= 0x700) && (code <= 0x70d)) ||
           ((code >= 0x964) && (code <= 0x965)) ||
           (code == 0x970) ||
           (code == 0xdf4) ||
           (code == 0xe4f) ||
           ((code >= 0xe5a) && (code <= 0xe5b)) ||
           ((code >= 0xf04) && (code <= 0xf12)) ||
           ((code >= 0xf3a) && (code <= 0xf3d)) ||
           (code == 0xf85) ||
           ((code >= 0x104a) && (code <= 0x104f)) ||
           (code == 0x10fb) ||
           ((code >= 0x1361) && (code <= 0x1368)) ||
           ((code >= 0x166d) && (code <= 0x166e)) ||
           ((code >= 0x169b) && (code <= 0x169c)) ||
           ((code >= 0x16eb) && (code <= 0x16ed)) ||
           ((code >= 0x17d4) && (code <= 0x17da)) ||
           (code == 0x17dc) ||
           ((code >= 0x1800) && (code <= 0x180a)) ||
           ((code >= 0x2010) && (code <= 0x2027)) ||
           ((code >= 0x2030) && (code <= 0x2043)) ||
           ((code >= 0x2045) && (code <= 0x2046)) ||
           ((code >= 0x2048) && (code <= 0x204d)) ||
           ((code >= 0x207d) && (code <= 0x207e)) ||
           ((code >= 0x208d) && (code <= 0x208e)) ||
           ((code >= 0x2329) && (code <= 0x232a)) ||
           ((code >= 0x3001) && (code <= 0x3003)) ||
           ((code >= 0x3008) && (code <= 0x3011)) ||
           ((code >= 0x3014) && (code <= 0x301f)) ||
           (code == 0x3030) ||
           (code == 0x30fb) ||
           ((code >= 0xfd3e) && (code <= 0xfd3f)) ||
           ((code >= 0xfe30) && (code <= 0xfe44)) ||
           ((code >= 0xfe49) && (code <= 0xfe52)) ||
           ((code >= 0xfe54) && (code <= 0xfe61)) ||
           (code == 0xfe63) ||
           (code == 0xfe68) ||
           ((code >= 0xfe6a) && (code <= 0xfe6b)) ||
           ((code >= 0xff01) && (code <= 0xff03)) ||
           ((code >= 0xff05) && (code <= 0xff0a)) ||
           ((code >= 0xff0c) && (code <= 0xff0f)) ||
           ((code >= 0xff1a) && (code <= 0xff1b)) ||
           ((code >= 0xff1f) && (code <= 0xff20)) ||
           ((code >= 0xff3b) && (code <= 0xff3d)) ||
           (code == 0xff3f) ||
           (code == 0xff5b) ||
           (code == 0xff5d) ||
           ((code >= 0xff61) && (code <= 0xff65)));
}

/**
 * xmlUCSIsCatPc:
 * @code: UCS code point
 *
 * Check whether the character is part of Pc UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatPc(int code) {
    return((code == 0x5f) ||
           ((code >= 0x203f) && (code <= 0x2040)) ||
           (code == 0x30fb) ||
           ((code >= 0xfe33) && (code <= 0xfe34)) ||
           ((code >= 0xfe4d) && (code <= 0xfe4f)) ||
           (code == 0xff3f) ||
           (code == 0xff65));
}

/**
 * xmlUCSIsCatPd:
 * @code: UCS code point
 *
 * Check whether the character is part of Pd UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatPd(int code) {
    return((code == 0x2d) ||
           (code == 0xad) ||
           (code == 0x58a) ||
           (code == 0x1806) ||
           ((code >= 0x2010) && (code <= 0x2015)) ||
           (code == 0x301c) ||
           (code == 0x3030) ||
           ((code >= 0xfe31) && (code <= 0xfe32)) ||
           (code == 0xfe58) ||
           (code == 0xfe63) ||
           (code == 0xff0d));
}

/**
 * xmlUCSIsCatPe:
 * @code: UCS code point
 *
 * Check whether the character is part of Pe UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatPe(int code) {
    return((code == 0x29) ||
           (code == 0x5d) ||
           (code == 0x7d) ||
           (code == 0xf3b) ||
           (code == 0xf3d) ||
           (code == 0x169c) ||
           (code == 0x2046) ||
           (code == 0x207e) ||
           (code == 0x208e) ||
           (code == 0x232a) ||
           (code == 0x3009) ||
           (code == 0x300b) ||
           (code == 0x300d) ||
           (code == 0x300f) ||
           (code == 0x3011) ||
           (code == 0x3015) ||
           (code == 0x3017) ||
           (code == 0x3019) ||
           (code == 0x301b) ||
           ((code >= 0x301e) && (code <= 0x301f)) ||
           (code == 0xfd3f) ||
           (code == 0xfe36) ||
           (code == 0xfe38) ||
           (code == 0xfe3a) ||
           (code == 0xfe3c) ||
           (code == 0xfe3e) ||
           (code == 0xfe40) ||
           (code == 0xfe42) ||
           (code == 0xfe44) ||
           (code == 0xfe5a) ||
           (code == 0xfe5c) ||
           (code == 0xfe5e) ||
           (code == 0xff09) ||
           (code == 0xff3d) ||
           (code == 0xff5d) ||
           (code == 0xff63));
}

/**
 * xmlUCSIsCatPf:
 * @code: UCS code point
 *
 * Check whether the character is part of Pf UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatPf(int code) {
    return((code == 0xbb) ||
           (code == 0x2019) ||
           (code == 0x201d) ||
           (code == 0x203a));
}

/**
 * xmlUCSIsCatPi:
 * @code: UCS code point
 *
 * Check whether the character is part of Pi UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatPi(int code) {
    return((code == 0xab) ||
           (code == 0x2018) ||
           ((code >= 0x201b) && (code <= 0x201c)) ||
           (code == 0x201f) ||
           (code == 0x2039));
}

/**
 * xmlUCSIsCatPo:
 * @code: UCS code point
 *
 * Check whether the character is part of Po UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatPo(int code) {
    return(((code >= 0x21) && (code <= 0x23)) ||
           ((code >= 0x25) && (code <= 0x27)) ||
           (code == 0x2a) ||
           (code == 0x2c) ||
           ((code >= 0x2e) && (code <= 0x2f)) ||
           ((code >= 0x3a) && (code <= 0x3b)) ||
           ((code >= 0x3f) && (code <= 0x40)) ||
           (code == 0x5c) ||
           (code == 0xa1) ||
           (code == 0xb7) ||
           (code == 0xbf) ||
           (code == 0x37e) ||
           (code == 0x387) ||
           ((code >= 0x55a) && (code <= 0x55f)) ||
           (code == 0x589) ||
           (code == 0x5be) ||
           (code == 0x5c0) ||
           (code == 0x5c3) ||
           ((code >= 0x5f3) && (code <= 0x5f4)) ||
           (code == 0x60c) ||
           (code == 0x61b) ||
           (code == 0x61f) ||
           ((code >= 0x66a) && (code <= 0x66d)) ||
           (code == 0x6d4) ||
           ((code >= 0x700) && (code <= 0x70d)) ||
           ((code >= 0x964) && (code <= 0x965)) ||
           (code == 0x970) ||
           (code == 0xdf4) ||
           (code == 0xe4f) ||
           ((code >= 0xe5a) && (code <= 0xe5b)) ||
           ((code >= 0xf04) && (code <= 0xf12)) ||
           (code == 0xf85) ||
           ((code >= 0x104a) && (code <= 0x104f)) ||
           (code == 0x10fb) ||
           ((code >= 0x1361) && (code <= 0x1368)) ||
           ((code >= 0x166d) && (code <= 0x166e)) ||
           ((code >= 0x16eb) && (code <= 0x16ed)) ||
           ((code >= 0x17d4) && (code <= 0x17da)) ||
           (code == 0x17dc) ||
           ((code >= 0x1800) && (code <= 0x1805)) ||
           ((code >= 0x1807) && (code <= 0x180a)) ||
           ((code >= 0x2016) && (code <= 0x2017)) ||
           ((code >= 0x2020) && (code <= 0x2027)) ||
           ((code >= 0x2030) && (code <= 0x2038)) ||
           ((code >= 0x203b) && (code <= 0x203e)) ||
           ((code >= 0x2041) && (code <= 0x2043)) ||
           ((code >= 0x2048) && (code <= 0x204d)) ||
           ((code >= 0x3001) && (code <= 0x3003)) ||
           (code == 0xfe30) ||
           ((code >= 0xfe49) && (code <= 0xfe4c)) ||
           ((code >= 0xfe50) && (code <= 0xfe52)) ||
           ((code >= 0xfe54) && (code <= 0xfe57)) ||
           ((code >= 0xfe5f) && (code <= 0xfe61)) ||
           (code == 0xfe68) ||
           ((code >= 0xfe6a) && (code <= 0xfe6b)) ||
           ((code >= 0xff01) && (code <= 0xff03)) ||
           ((code >= 0xff05) && (code <= 0xff07)) ||
           (code == 0xff0a) ||
           (code == 0xff0c) ||
           ((code >= 0xff0e) && (code <= 0xff0f)) ||
           ((code >= 0xff1a) && (code <= 0xff1b)) ||
           ((code >= 0xff1f) && (code <= 0xff20)) ||
           (code == 0xff3c) ||
           (code == 0xff61) ||
           (code == 0xff64));
}

/**
 * xmlUCSIsCatPs:
 * @code: UCS code point
 *
 * Check whether the character is part of Ps UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatPs(int code) {
    return((code == 0x28) ||
           (code == 0x5b) ||
           (code == 0x7b) ||
           (code == 0xf3a) ||
           (code == 0xf3c) ||
           (code == 0x169b) ||
           (code == 0x201a) ||
           (code == 0x201e) ||
           (code == 0x2045) ||
           (code == 0x207d) ||
           (code == 0x208d) ||
           (code == 0x2329) ||
           (code == 0x3008) ||
           (code == 0x300a) ||
           (code == 0x300c) ||
           (code == 0x300e) ||
           (code == 0x3010) ||
           (code == 0x3014) ||
           (code == 0x3016) ||
           (code == 0x3018) ||
           (code == 0x301a) ||
           (code == 0x301d) ||
           (code == 0xfd3e) ||
           (code == 0xfe35) ||
           (code == 0xfe37) ||
           (code == 0xfe39) ||
           (code == 0xfe3b) ||
           (code == 0xfe3d) ||
           (code == 0xfe3f) ||
           (code == 0xfe41) ||
           (code == 0xfe43) ||
           (code == 0xfe59) ||
           (code == 0xfe5b) ||
           (code == 0xfe5d) ||
           (code == 0xff08) ||
           (code == 0xff3b) ||
           (code == 0xff5b) ||
           (code == 0xff62));
}

/**
 * xmlUCSIsCatS:
 * @code: UCS code point
 *
 * Check whether the character is part of S UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatS(int code) {
    return((code == 0x24) ||
           (code == 0x2b) ||
           ((code >= 0x3c) && (code <= 0x3e)) ||
           (code == 0x5e) ||
           (code == 0x60) ||
           (code == 0x7c) ||
           (code == 0x7e) ||
           ((code >= 0xa2) && (code <= 0xa9)) ||
           (code == 0xac) ||
           ((code >= 0xae) && (code <= 0xb1)) ||
           (code == 0xb4) ||
           (code == 0xb6) ||
           (code == 0xb8) ||
           (code == 0xd7) ||
           (code == 0xf7) ||
           ((code >= 0x2b9) && (code <= 0x2ba)) ||
           ((code >= 0x2c2) && (code <= 0x2cf)) ||
           ((code >= 0x2d2) && (code <= 0x2df)) ||
           ((code >= 0x2e5) && (code <= 0x2ed)) ||
           ((code >= 0x374) && (code <= 0x375)) ||
           ((code >= 0x384) && (code <= 0x385)) ||
           (code == 0x482) ||
           (code == 0x6e9) ||
           ((code >= 0x6fd) && (code <= 0x6fe)) ||
           ((code >= 0x9f2) && (code <= 0x9f3)) ||
           (code == 0x9fa) ||
           (code == 0xb70) ||
           (code == 0xe3f) ||
           ((code >= 0xf01) && (code <= 0xf03)) ||
           ((code >= 0xf13) && (code <= 0xf17)) ||
           ((code >= 0xf1a) && (code <= 0xf1f)) ||
           (code == 0xf34) ||
           (code == 0xf36) ||
           (code == 0xf38) ||
           ((code >= 0xfbe) && (code <= 0xfc5)) ||
           ((code >= 0xfc7) && (code <= 0xfcc)) ||
           (code == 0xfcf) ||
           (code == 0x17db) ||
           (code == 0x1fbd) ||
           ((code >= 0x1fbf) && (code <= 0x1fc1)) ||
           ((code >= 0x1fcd) && (code <= 0x1fcf)) ||
           ((code >= 0x1fdd) && (code <= 0x1fdf)) ||
           ((code >= 0x1fed) && (code <= 0x1fef)) ||
           ((code >= 0x1ffd) && (code <= 0x1ffe)) ||
           (code == 0x2044) ||
           ((code >= 0x207a) && (code <= 0x207c)) ||
           ((code >= 0x208a) && (code <= 0x208c)) ||
           ((code >= 0x20a0) && (code <= 0x20af)) ||
           ((code >= 0x2100) && (code <= 0x2101)) ||
           ((code >= 0x2103) && (code <= 0x2106)) ||
           ((code >= 0x2108) && (code <= 0x2109)) ||
           (code == 0x2114) ||
           ((code >= 0x2116) && (code <= 0x2118)) ||
           ((code >= 0x211e) && (code <= 0x2123)) ||
           (code == 0x2125) ||
           (code == 0x2127) ||
           (code == 0x2129) ||
           (code == 0x212e) ||
           (code == 0x2132) ||
           (code == 0x213a) ||
           ((code >= 0x2190) && (code <= 0x21f3)) ||
           ((code >= 0x2200) && (code <= 0x22f1)) ||
           ((code >= 0x2300) && (code <= 0x2328)) ||
           ((code >= 0x232b) && (code <= 0x237b)) ||
           ((code >= 0x237d) && (code <= 0x239a)) ||
           ((code >= 0x2400) && (code <= 0x2426)) ||
           ((code >= 0x2440) && (code <= 0x244a)) ||
           ((code >= 0x249c) && (code <= 0x24e9)) ||
           ((code >= 0x2500) && (code <= 0x2595)) ||
           ((code >= 0x25a0) && (code <= 0x25f7)) ||
           ((code >= 0x2600) && (code <= 0x2613)) ||
           ((code >= 0x2619) && (code <= 0x2671)) ||
           ((code >= 0x2701) && (code <= 0x2704)) ||
           ((code >= 0x2706) && (code <= 0x2709)) ||
           ((code >= 0x270c) && (code <= 0x2727)) ||
           ((code >= 0x2729) && (code <= 0x274b)) ||
           (code == 0x274d) ||
           ((code >= 0x274f) && (code <= 0x2752)) ||
           (code == 0x2756) ||
           ((code >= 0x2758) && (code <= 0x275e)) ||
           ((code >= 0x2761) && (code <= 0x2767)) ||
           (code == 0x2794) ||
           ((code >= 0x2798) && (code <= 0x27af)) ||
           ((code >= 0x27b1) && (code <= 0x27be)) ||
           ((code >= 0x2800) && (code <= 0x28ff)) ||
           ((code >= 0x2e80) && (code <= 0x2e99)) ||
           ((code >= 0x2e9b) && (code <= 0x2ef3)) ||
           ((code >= 0x2f00) && (code <= 0x2fd5)) ||
           ((code >= 0x2ff0) && (code <= 0x2ffb)) ||
           (code == 0x3004) ||
           ((code >= 0x3012) && (code <= 0x3013)) ||
           (code == 0x3020) ||
           ((code >= 0x3036) && (code <= 0x3037)) ||
           ((code >= 0x303e) && (code <= 0x303f)) ||
           ((code >= 0x309b) && (code <= 0x309c)) ||
           ((code >= 0x3190) && (code <= 0x3191)) ||
           ((code >= 0x3196) && (code <= 0x319f)) ||
           ((code >= 0x3200) && (code <= 0x321c)) ||
           ((code >= 0x322a) && (code <= 0x3243)) ||
           ((code >= 0x3260) && (code <= 0x327b)) ||
           (code == 0x327f) ||
           ((code >= 0x328a) && (code <= 0x32b0)) ||
           ((code >= 0x32c0) && (code <= 0x32cb)) ||
           ((code >= 0x32d0) && (code <= 0x32fe)) ||
           ((code >= 0x3300) && (code <= 0x3376)) ||
           ((code >= 0x337b) && (code <= 0x33dd)) ||
           ((code >= 0x33e0) && (code <= 0x33fe)) ||
           ((code >= 0xa490) && (code <= 0xa4a1)) ||
           ((code >= 0xa4a4) && (code <= 0xa4b3)) ||
           ((code >= 0xa4b5) && (code <= 0xa4c0)) ||
           ((code >= 0xa4c2) && (code <= 0xa4c4)) ||
           (code == 0xa4c6) ||
           (code == 0xfb29) ||
           (code == 0xfe62) ||
           ((code >= 0xfe64) && (code <= 0xfe66)) ||
           (code == 0xfe69) ||
           (code == 0xff04) ||
           (code == 0xff0b) ||
           ((code >= 0xff1c) && (code <= 0xff1e)) ||
           (code == 0xff3e) ||
           (code == 0xff40) ||
           (code == 0xff5c) ||
           (code == 0xff5e) ||
           ((code >= 0xffe0) && (code <= 0xffe6)) ||
           ((code >= 0xffe8) && (code <= 0xffee)) ||
           ((code >= 0xfffc) && (code <= 0xfffd)) ||
           ((code >= 0x1d000) && (code <= 0x1d0f5)) ||
           ((code >= 0x1d100) && (code <= 0x1d126)) ||
           ((code >= 0x1d12a) && (code <= 0x1d164)) ||
           ((code >= 0x1d16a) && (code <= 0x1d16c)) ||
           ((code >= 0x1d183) && (code <= 0x1d184)) ||
           ((code >= 0x1d18c) && (code <= 0x1d1a9)) ||
           ((code >= 0x1d1ae) && (code <= 0x1d1dd)) ||
           (code == 0x1d6c1) ||
           (code == 0x1d6db) ||
           (code == 0x1d6fb) ||
           (code == 0x1d715) ||
           (code == 0x1d735) ||
           (code == 0x1d74f) ||
           (code == 0x1d76f) ||
           (code == 0x1d789) ||
           (code == 0x1d7a9) ||
           (code == 0x1d7c3));
}

/**
 * xmlUCSIsCatSc:
 * @code: UCS code point
 *
 * Check whether the character is part of Sc UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatSc(int code) {
    return((code == 0x24) ||
           ((code >= 0xa2) && (code <= 0xa5)) ||
           ((code >= 0x9f2) && (code <= 0x9f3)) ||
           (code == 0xe3f) ||
           (code == 0x17db) ||
           ((code >= 0x20a0) && (code <= 0x20af)) ||
           (code == 0xfe69) ||
           (code == 0xff04) ||
           ((code >= 0xffe0) && (code <= 0xffe1)) ||
           ((code >= 0xffe5) && (code <= 0xffe6)));
}

/**
 * xmlUCSIsCatSk:
 * @code: UCS code point
 *
 * Check whether the character is part of Sk UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatSk(int code) {
    return((code == 0x5e) ||
           (code == 0x60) ||
           (code == 0xa8) ||
           (code == 0xaf) ||
           (code == 0xb4) ||
           (code == 0xb8) ||
           ((code >= 0x2b9) && (code <= 0x2ba)) ||
           ((code >= 0x2c2) && (code <= 0x2cf)) ||
           ((code >= 0x2d2) && (code <= 0x2df)) ||
           ((code >= 0x2e5) && (code <= 0x2ed)) ||
           ((code >= 0x374) && (code <= 0x375)) ||
           ((code >= 0x384) && (code <= 0x385)) ||
           (code == 0x1fbd) ||
           ((code >= 0x1fbf) && (code <= 0x1fc1)) ||
           ((code >= 0x1fcd) && (code <= 0x1fcf)) ||
           ((code >= 0x1fdd) && (code <= 0x1fdf)) ||
           ((code >= 0x1fed) && (code <= 0x1fef)) ||
           ((code >= 0x1ffd) && (code <= 0x1ffe)) ||
           ((code >= 0x309b) && (code <= 0x309c)) ||
           (code == 0xff3e) ||
           (code == 0xff40) ||
           (code == 0xffe3));
}

/**
 * xmlUCSIsCatSm:
 * @code: UCS code point
 *
 * Check whether the character is part of Sm UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatSm(int code) {
    return((code == 0x2b) ||
           ((code >= 0x3c) && (code <= 0x3e)) ||
           (code == 0x7c) ||
           (code == 0x7e) ||
           (code == 0xac) ||
           (code == 0xb1) ||
           (code == 0xd7) ||
           (code == 0xf7) ||
           (code == 0x2044) ||
           ((code >= 0x207a) && (code <= 0x207c)) ||
           ((code >= 0x208a) && (code <= 0x208c)) ||
           ((code >= 0x2190) && (code <= 0x2194)) ||
           ((code >= 0x219a) && (code <= 0x219b)) ||
           (code == 0x21a0) ||
           (code == 0x21a3) ||
           (code == 0x21a6) ||
           (code == 0x21ae) ||
           ((code >= 0x21ce) && (code <= 0x21cf)) ||
           (code == 0x21d2) ||
           (code == 0x21d4) ||
           ((code >= 0x2200) && (code <= 0x22f1)) ||
           ((code >= 0x2308) && (code <= 0x230b)) ||
           ((code >= 0x2320) && (code <= 0x2321)) ||
           (code == 0x25b7) ||
           (code == 0x25c1) ||
           (code == 0x266f) ||
           (code == 0xfb29) ||
           (code == 0xfe62) ||
           ((code >= 0xfe64) && (code <= 0xfe66)) ||
           (code == 0xff0b) ||
           ((code >= 0xff1c) && (code <= 0xff1e)) ||
           (code == 0xff5c) ||
           (code == 0xff5e) ||
           (code == 0xffe2) ||
           ((code >= 0xffe9) && (code <= 0xffec)) ||
           (code == 0x1d6c1) ||
           (code == 0x1d6db) ||
           (code == 0x1d6fb) ||
           (code == 0x1d715) ||
           (code == 0x1d735) ||
           (code == 0x1d74f) ||
           (code == 0x1d76f) ||
           (code == 0x1d789) ||
           (code == 0x1d7a9) ||
           (code == 0x1d7c3));
}

/**
 * xmlUCSIsCatSo:
 * @code: UCS code point
 *
 * Check whether the character is part of So UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatSo(int code) {
    return(((code >= 0xa6) && (code <= 0xa7)) ||
           (code == 0xa9) ||
           (code == 0xae) ||
           (code == 0xb0) ||
           (code == 0xb6) ||
           (code == 0x482) ||
           (code == 0x6e9) ||
           ((code >= 0x6fd) && (code <= 0x6fe)) ||
           (code == 0x9fa) ||
           (code == 0xb70) ||
           ((code >= 0xf01) && (code <= 0xf03)) ||
           ((code >= 0xf13) && (code <= 0xf17)) ||
           ((code >= 0xf1a) && (code <= 0xf1f)) ||
           (code == 0xf34) ||
           (code == 0xf36) ||
           (code == 0xf38) ||
           ((code >= 0xfbe) && (code <= 0xfc5)) ||
           ((code >= 0xfc7) && (code <= 0xfcc)) ||
           (code == 0xfcf) ||
           ((code >= 0x2100) && (code <= 0x2101)) ||
           ((code >= 0x2103) && (code <= 0x2106)) ||
           ((code >= 0x2108) && (code <= 0x2109)) ||
           (code == 0x2114) ||
           ((code >= 0x2116) && (code <= 0x2118)) ||
           ((code >= 0x211e) && (code <= 0x2123)) ||
           (code == 0x2125) ||
           (code == 0x2127) ||
           (code == 0x2129) ||
           (code == 0x212e) ||
           (code == 0x2132) ||
           (code == 0x213a) ||
           ((code >= 0x2195) && (code <= 0x2199)) ||
           ((code >= 0x219c) && (code <= 0x219f)) ||
           ((code >= 0x21a1) && (code <= 0x21a2)) ||
           ((code >= 0x21a4) && (code <= 0x21a5)) ||
           ((code >= 0x21a7) && (code <= 0x21ad)) ||
           ((code >= 0x21af) && (code <= 0x21cd)) ||
           ((code >= 0x21d0) && (code <= 0x21d1)) ||
           (code == 0x21d3) ||
           ((code >= 0x21d5) && (code <= 0x21f3)) ||
           ((code >= 0x2300) && (code <= 0x2307)) ||
           ((code >= 0x230c) && (code <= 0x231f)) ||
           ((code >= 0x2322) && (code <= 0x2328)) ||
           ((code >= 0x232b) && (code <= 0x237b)) ||
           ((code >= 0x237d) && (code <= 0x239a)) ||
           ((code >= 0x2400) && (code <= 0x2426)) ||
           ((code >= 0x2440) && (code <= 0x244a)) ||
           ((code >= 0x249c) && (code <= 0x24e9)) ||
           ((code >= 0x2500) && (code <= 0x2595)) ||
           ((code >= 0x25a0) && (code <= 0x25b6)) ||
           ((code >= 0x25b8) && (code <= 0x25c0)) ||
           ((code >= 0x25c2) && (code <= 0x25f7)) ||
           ((code >= 0x2600) && (code <= 0x2613)) ||
           ((code >= 0x2619) && (code <= 0x266e)) ||
           ((code >= 0x2670) && (code <= 0x2671)) ||
           ((code >= 0x2701) && (code <= 0x2704)) ||
           ((code >= 0x2706) && (code <= 0x2709)) ||
           ((code >= 0x270c) && (code <= 0x2727)) ||
           ((code >= 0x2729) && (code <= 0x274b)) ||
           (code == 0x274d) ||
           ((code >= 0x274f) && (code <= 0x2752)) ||
           (code == 0x2756) ||
           ((code >= 0x2758) && (code <= 0x275e)) ||
           ((code >= 0x2761) && (code <= 0x2767)) ||
           (code == 0x2794) ||
           ((code >= 0x2798) && (code <= 0x27af)) ||
           ((code >= 0x27b1) && (code <= 0x27be)) ||
           ((code >= 0x2800) && (code <= 0x28ff)) ||
           ((code >= 0x2e80) && (code <= 0x2e99)) ||
           ((code >= 0x2e9b) && (code <= 0x2ef3)) ||
           ((code >= 0x2f00) && (code <= 0x2fd5)) ||
           ((code >= 0x2ff0) && (code <= 0x2ffb)) ||
           (code == 0x3004) ||
           ((code >= 0x3012) && (code <= 0x3013)) ||
           (code == 0x3020) ||
           ((code >= 0x3036) && (code <= 0x3037)) ||
           ((code >= 0x303e) && (code <= 0x303f)) ||
           ((code >= 0x3190) && (code <= 0x3191)) ||
           ((code >= 0x3196) && (code <= 0x319f)) ||
           ((code >= 0x3200) && (code <= 0x321c)) ||
           ((code >= 0x322a) && (code <= 0x3243)) ||
           ((code >= 0x3260) && (code <= 0x327b)) ||
           (code == 0x327f) ||
           ((code >= 0x328a) && (code <= 0x32b0)) ||
           ((code >= 0x32c0) && (code <= 0x32cb)) ||
           ((code >= 0x32d0) && (code <= 0x32fe)) ||
           ((code >= 0x3300) && (code <= 0x3376)) ||
           ((code >= 0x337b) && (code <= 0x33dd)) ||
           ((code >= 0x33e0) && (code <= 0x33fe)) ||
           ((code >= 0xa490) && (code <= 0xa4a1)) ||
           ((code >= 0xa4a4) && (code <= 0xa4b3)) ||
           ((code >= 0xa4b5) && (code <= 0xa4c0)) ||
           ((code >= 0xa4c2) && (code <= 0xa4c4)) ||
           (code == 0xa4c6) ||
           (code == 0xffe4) ||
           (code == 0xffe8) ||
           ((code >= 0xffed) && (code <= 0xffee)) ||
           ((code >= 0xfffc) && (code <= 0xfffd)) ||
           ((code >= 0x1d000) && (code <= 0x1d0f5)) ||
           ((code >= 0x1d100) && (code <= 0x1d126)) ||
           ((code >= 0x1d12a) && (code <= 0x1d164)) ||
           ((code >= 0x1d16a) && (code <= 0x1d16c)) ||
           ((code >= 0x1d183) && (code <= 0x1d184)) ||
           ((code >= 0x1d18c) && (code <= 0x1d1a9)) ||
           ((code >= 0x1d1ae) && (code <= 0x1d1dd)));
}

/**
 * xmlUCSIsCatZ:
 * @code: UCS code point
 *
 * Check whether the character is part of Z UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatZ(int code) {
    return((code == 0x20) ||
           (code == 0xa0) ||
           (code == 0x1680) ||
           ((code >= 0x2000) && (code <= 0x200b)) ||
           ((code >= 0x2028) && (code <= 0x2029)) ||
           (code == 0x202f) ||
           (code == 0x3000));
}

/**
 * xmlUCSIsCatZl:
 * @code: UCS code point
 *
 * Check whether the character is part of Zl UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatZl(int code) {
    return((code == 0x2028));
}

/**
 * xmlUCSIsCatZp:
 * @code: UCS code point
 *
 * Check whether the character is part of Zp UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatZp(int code) {
    return((code == 0x2029));
}

/**
 * xmlUCSIsCatZs:
 * @code: UCS code point
 *
 * Check whether the character is part of Zs UCS Category
 *
 * Returns 1 if true 0 otherwise
 */
int
xmlUCSIsCatZs(int code) {
    return((code == 0x20) ||
           (code == 0xa0) ||
           (code == 0x1680) ||
           ((code >= 0x2000) && (code <= 0x200b)) ||
           (code == 0x202f) ||
           (code == 0x3000));
}

/**
 * xmlUCSIsCat:
 * @code: UCS code point
 * @cat: UCS Category name
 *
 * Check whether the caracter is part of the UCS Category
 *
 * Returns 1 if true, 0 if false and -1 on unknown category
 */
int
xmlUCSIsCat(int code, const char *cat) {
    if (!strcmp(cat, "C"))
        return(xmlUCSIsCatC(code));
    if (!strcmp(cat, "Cc"))
        return(xmlUCSIsCatCc(code));
    if (!strcmp(cat, "Cf"))
        return(xmlUCSIsCatCf(code));
    if (!strcmp(cat, "Co"))
        return(xmlUCSIsCatCo(code));
    if (!strcmp(cat, "Cs"))
        return(xmlUCSIsCatCs(code));
    if (!strcmp(cat, "L"))
        return(xmlUCSIsCatL(code));
    if (!strcmp(cat, "Ll"))
        return(xmlUCSIsCatLl(code));
    if (!strcmp(cat, "Lm"))
        return(xmlUCSIsCatLm(code));
    if (!strcmp(cat, "Lo"))
        return(xmlUCSIsCatLo(code));
    if (!strcmp(cat, "Lt"))
        return(xmlUCSIsCatLt(code));
    if (!strcmp(cat, "Lu"))
        return(xmlUCSIsCatLu(code));
    if (!strcmp(cat, "M"))
        return(xmlUCSIsCatM(code));
    if (!strcmp(cat, "Mc"))
        return(xmlUCSIsCatMc(code));
    if (!strcmp(cat, "Me"))
        return(xmlUCSIsCatMe(code));
    if (!strcmp(cat, "Mn"))
        return(xmlUCSIsCatMn(code));
    if (!strcmp(cat, "N"))
        return(xmlUCSIsCatN(code));
    if (!strcmp(cat, "Nd"))
        return(xmlUCSIsCatNd(code));
    if (!strcmp(cat, "Nl"))
        return(xmlUCSIsCatNl(code));
    if (!strcmp(cat, "No"))
        return(xmlUCSIsCatNo(code));
    if (!strcmp(cat, "P"))
        return(xmlUCSIsCatP(code));
    if (!strcmp(cat, "Pc"))
        return(xmlUCSIsCatPc(code));
    if (!strcmp(cat, "Pd"))
        return(xmlUCSIsCatPd(code));
    if (!strcmp(cat, "Pe"))
        return(xmlUCSIsCatPe(code));
    if (!strcmp(cat, "Pf"))
        return(xmlUCSIsCatPf(code));
    if (!strcmp(cat, "Pi"))
        return(xmlUCSIsCatPi(code));
    if (!strcmp(cat, "Po"))
        return(xmlUCSIsCatPo(code));
    if (!strcmp(cat, "Ps"))
        return(xmlUCSIsCatPs(code));
    if (!strcmp(cat, "S"))
        return(xmlUCSIsCatS(code));
    if (!strcmp(cat, "Sc"))
        return(xmlUCSIsCatSc(code));
    if (!strcmp(cat, "Sk"))
        return(xmlUCSIsCatSk(code));
    if (!strcmp(cat, "Sm"))
        return(xmlUCSIsCatSm(code));
    if (!strcmp(cat, "So"))
        return(xmlUCSIsCatSo(code));
    if (!strcmp(cat, "Z"))
        return(xmlUCSIsCatZ(code));
    if (!strcmp(cat, "Zl"))
        return(xmlUCSIsCatZl(code));
    if (!strcmp(cat, "Zp"))
        return(xmlUCSIsCatZp(code));
    if (!strcmp(cat, "Zs"))
        return(xmlUCSIsCatZs(code));
    return(-1);
}


#endif /* LIBXML_UNICODE_ENABLED */
