/* data-entry.h
 *
 * Copyright (C) 1999 - 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __DATA_ENTRY__
#define __DATA_ENTRY__

#include <gnome.h>
#include "query.h"
#include "data-handler.h"

G_BEGIN_DECLS

#define DATA_ENTRY_TYPE          (data_entry_get_type())
#define DATA_ENTRY(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, data_entry_get_type(), DataEntry)
#define DATA_ENTRY_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, data_entry_get_type (), DataEntryClass)
#define IS_DATA_ENTRY(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, data_entry_get_type ())

/*
 * Very simple object wrapper for the widgets that will be used to display
 * the data. What is important is the "contents_modified" signal
 */

typedef struct _DataEntry      DataEntry;
typedef struct _DataEntryClass DataEntryClass;
typedef struct _DataEntryPriv  DataEntryPriv;

/* struct for the object's data */
struct _DataEntry
{
	GtkVBox         object;

	DataEntryPriv  *priv;

	gpointer        extension;
	void          (*free_extension) (DataEntry *de); /* should set extension to NULL */
};

/* struct for the object's class */
struct _DataEntryClass
{
	GtkVBoxClass    parent_class;

	void          (*contents_modified) (DataEntry * wid);
};

/* 
 * generic widget's functions
 */
guint           data_entry_get_type                (void);
GtkWidget      *data_entry_new                     (DataHandler *dh);

/*
 * widget manipulations
 */
void            data_entry_set_orig_value          (DataEntry *de, const GdaValue *value);
void            data_entry_set_query_field         (DataEntry *de, QueryField *qf);
void            data_entry_set_is_default_set      (DataEntry *de, gboolean is_default);
void            data_entry_set_is_default_allowed  (DataEntry *de, gboolean is_default_possible);
void            data_entry_set_is_null_allowed     (DataEntry *de, gboolean null_allowed);
void            data_entry_set_show_actions_menu   (DataEntry *de, gboolean show);

void            data_entry_refresh_display         (DataEntry *de);
void            data_entry_update_with_value       (DataEntry *de, 
						    const GdaValue *value, GdaValueType fallback_orig_type,
						    gboolean value_as_init);

/*
 * packing method
 */
void            data_entry_pack_default            (DataEntry * de, GtkWidget * wid);

/*
 * Getting information
 */
GdaValue       *data_entry_get_gdavalue            (DataEntry * de); /* free after usage */
gboolean        data_entry_is_value_null           (DataEntry * de);
gboolean        data_entry_is_value_default        (DataEntry * de);
gboolean        data_entry_is_value_modified       (DataEntry * de);

gboolean        data_entry_get_is_default_allowed  (DataEntry *de);
gboolean        data_entry_get_is_null_allowed     (DataEntry *de);

DataHandler    *data_entry_get_data_handler        (DataEntry *de);
const GdaValue *data_entry_get_orig_value          (DataEntry *de);
GdaValueType    data_entry_get_orig_type           (DataEntry *de);

G_END_DECLS

#endif
