#include <config.h>
#include "baseplugin.h"

#define PLUG_NAME "Test"
#define PLUG_VERSION "0.8.194"

/* functions declaration */
static gchar     *server_access_escape_chars (gchar * str);
static GtkWidget *widget_from_value          (DataHandler * dh, const GdaValue * value);
static void       widget_update              (DataHandler * dh, GtkWidget * wid, 
					      const GdaValue * value, gboolean value_as_default);
static gchar     *sql_from_value             (DataHandler * dh, const GdaValue * value);
static gchar     *str_from_value             (DataHandler * dh, const GdaValue * value);
static GdaValue  *value_from_widget          (DataHandler * dh, GtkWidget * wid);

struct plug_extension {
	GtkWidget *entry;
};
#define PLUG_EXTENSION(de) ((struct plug_extension *) (DATA_ENTRY (de)->extension))

void plug_free_extension (DataEntry *de) {
	g_free (de->extension);
	de->extension = NULL;
}


/*
 * main functions for the plugin
 */
static gchar *
get_unique_key ()
{
	gchar *retval;

	retval = g_strdup_printf ("%sV%s", PLUG_NAME, PLUG_VERSION);
	return retval;
}

DataHandler *
fetch_plugin_interface (ServerAccess *srv)
{
	DataHandler *dh;

	dh = DATA_HANDLER (data_handler_new ());
	dh->priv->descr = _("Sample plugin");
	dh->priv->detailled_descr = _("Not to be used anywhere, really!");
	dh->priv->plugin_name = PLUG_NAME;
	dh->priv->plugin_file = NULL;
	dh->priv->lib_handle = NULL;
	dh->priv->version = PLUG_VERSION;
	dh->priv->get_unique_key = get_unique_key;
	dh->priv->nb_gda_type = 1;
	dh->priv->valid_gda_types = g_new0 (GdaValueType, 1);
	dh->priv->valid_gda_types[0] = GDA_VALUE_TYPE_STRING;
	dh->priv->expand_widget = FALSE;
	dh->priv->widget_from_value = widget_from_value;
	dh->priv->value_from_widget = value_from_widget;
	dh->priv->widget_update = widget_update;
	dh->priv->sql_from_value = sql_from_value;
	dh->priv->str_from_value = str_from_value;
	dh->priv->srv = srv;
	return dh;
}

void
release_struct (DataHandler * dh)
{
	g_return_if_fail (dh && IS_DATA_HANDLER (dh));

	if (dh->priv->valid_gda_types) {
		g_free (dh->priv->valid_gda_types);
		dh->priv->valid_gda_types = NULL;
	}
}




/* 
 * functions implementation 
 */
/* signal callbacks */
static void
contents_changed_cb (GtkObject * obj, DataEntry * dd)
{
	gtk_signal_emit_by_name (GTK_OBJECT (dd), "contents_modified");
}

static GtkWidget *
widget_from_value (DataHandler * dh, const GdaValue * value)
{
	DataEntry *dd;
	GtkWidget *wid;

	dd = DATA_ENTRY (data_entry_new (dh));
	data_entry_set_orig_value (dd, value);

	wid = gtk_label_new ("Sample plugin used!!!");
	data_entry_pack_default (dd, wid);
	gtk_widget_show (wid);
	wid = gtk_entry_new ();
	data_entry_pack_default (dd, wid);
	gtk_widget_show (wid);

	dd->free_extension = plug_free_extension;
	dd->extension = g_new0 (struct plug_extension, 1);
	PLUG_EXTENSION (dd)->entry = wid;

	if (value)
		widget_update (dh, GTK_WIDGET (dd), value, TRUE);
	gtk_signal_connect (GTK_OBJECT (wid), "changed",
			    GTK_SIGNAL_FUNC (contents_changed_cb), dd);

	return GTK_WIDGET (dd);
}

static GdaValue *
value_from_widget (DataHandler * dh, GtkWidget * wid)
{
	GdaValue *value;

	g_return_val_if_fail (wid && IS_DATA_ENTRY (wid), NULL);
	value = gda_value_new_string (gtk_entry_get_text (GTK_ENTRY (PLUG_EXTENSION (wid)->entry)));
	return value;
}

static void
widget_update (DataHandler * dh, GtkWidget * dd, const GdaValue * value, gboolean value_as_default)
{
	gchar *str;

	g_return_if_fail (dd && IS_DATA_ENTRY (dd));
	
	if (value_as_default)
		data_entry_set_orig_value (DATA_ENTRY (dd), value);

	if (value && !gda_value_is_null (value)) {
		str = str_from_value (dh, value);
		if (str) {
			gtk_entry_set_text (GTK_ENTRY (PLUG_EXTENSION (dd)->entry), str);
			g_free (str);
		}
		else
			gtk_entry_set_text (GTK_ENTRY (PLUG_EXTENSION (dd)->entry), "");
	}
	else
		gtk_entry_set_text (GTK_ENTRY (PLUG_EXTENSION (dd)->entry), "");
}

static gchar *
sql_from_value (DataHandler * dh, const GdaValue * value)
{
	gchar *str, *str2, *retval;

	if ((value->type == GDA_VALUE_TYPE_STRING) &&
            !gda_value_get_string (value))
		return NULL;

	if (gda_value_is_null (value))
		retval = NULL;
	else {
		str = gda_value_stringify (value);
		str2 = server_access_escape_chars (str);
		retval = g_strdup_printf ("'%s'", str2);
		g_free (str2);
	}
	return retval;
}

static gchar *
str_from_value (DataHandler * dh, const GdaValue * value)
{
	if (value) {
		if (((value->type == GDA_VALUE_TYPE_STRING)) &&
	            !gda_value_get_string (value))
			return NULL;


		return gda_value_stringify (value);
	}
	else
		return g_strdup ("");
}

static gchar *
server_access_escape_chars (gchar * str)
{
	gchar *ptr = str, *ret, *retptr;
	gint size;

	/* determination of the new string size */
	size = 1;
	while (*ptr != '\0') {
		if (*ptr == '\'') {
			if (ptr == str)
				size += 2;
			else {
				if (*(ptr - 1) == '\\')
					size += 1;
				else
					size += 2;
			}
		}
		else
			size += 1;
		ptr++;
	}

	ptr = str;
	ret = (gchar *) malloc (sizeof (gchar) * size);
	retptr = ret;
	while (*ptr != '\0') {
		if (*ptr == '\'') {
			if (ptr == str) {
				*retptr = '\\';
				retptr++;
			}
			else if (*(ptr - 1) != '\\') {
				*retptr = '\\';
				retptr++;
			}
		}
		*retptr = *ptr;
		retptr++;
		ptr++;
	}
	*retptr = '\0';
	g_free (str);
	return ret;
}
