/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 8-*- */

/*This file is part of GNU MlView
 *
 *GNU MlView is free software; 
 *you can redistribute it and/or modify it under the terms of 
 *the GNU General Public License as published by 
 *the Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will be useful, 
 *but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the GNU General 
 *Public License along with MlView; 
 *see the file COPYING. If not, write to the 
 *Free Software Foundation, Inc., 59 
 *Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *See COPYRIGHT file for copyright informations.
 */

#ifndef __MLVIEW_APP_CONTEXT_H__
#define __MLVIEW_APP_CONTEXT_H__

#include "config.h"
#include <libxml/parser.h>
#include <libxml/catalog.h>
#include <glib.h>
#include <glib-object.h>
#include <gconf/gconf-client.h>
#include "mlview-file-selection.h"
#ifdef MLVIEW_WITH_GTK_FILE_CHOOSER
#include <gtk/gtkfilechooser.h>
#endif

/**
 *@file
 *#MlViewAppContext class declaration file.
 */
G_BEGIN_DECLS
#define MLVIEW_TYPE_APP_CONTEXT (mlview_app_context_get_type())
#define MLVIEW_APP_CONTEXT(object) (G_TYPE_CHECK_INSTANCE_CAST((object), MLVIEW_TYPE_APP_CONTEXT, MlViewAppContext))
#define MLVIEW_APP_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), MLVIEW_TYPE_APP_CONTEXT, MlViewContextClass))
#define MLVIEW_IS_APP_CONTEXT(object) (G_TYPE_CHECK_INSTANCE_TYPE((object), MLVIEW_TYPE_APP_CONTEXT))
#define MLVIEW_IS_APP_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), MLVIEW_TYPE_APP_CONTEXT))
typedef struct _MlViewAppContext MlViewAppContext;
typedef struct _MlViewAppContextClass MlViewAppContextClass;
typedef struct _MlViewAppContextPrivate MlViewAppContextPrivate;

/**
 *MlViewAppContext objects structure.
 *This structure describes the data members
 *of each instance of MlViewAppContext.
 */
struct _MlViewAppContext {
        /**
	 *The member stucture of
         *MlViewAppContext's parent class.
         */
        GObject object;

        /**
         *The private members of MlViewAppContext.
         */
        MlViewAppContextPrivate *private;
};

/**
 *MlViewAppContext class structure.
 *The class inherits GObjects.
 */
struct _MlViewAppContextClass {
        /**
         *The class structure of the parent
         *class of MlViewAppContext.
         */
        GObjectClass parent_class;

        /**
         *Signal emited when the MlViewApp has been initialized.
         */
        void (*application_initialized) (MlViewAppContext *a_this,
                                         gpointer a_user_data) ;

        /**
         *signal emited when an editing
         *widget has been requested to popup
         *a contextual menu.
         */
        void (*contextual_menu_requested) (MlViewAppContext *a_this,
                                           GtkWidget *a_request_source,
                                           GdkEvent *a_event,
                                           gpointer a_user_data) ;
        
        void (*view_swapped) (MlViewAppContext *a_this,
                              gpointer a_old_view,
                              gpointer a_new_view,
                              gpointer a_user_data) ;

        void (*document_name_changed) (MlViewAppContext *a_this,
                                       gpointer a_doc,
                                       gpointer a_user_data) ;

        void (*document_undo_state_changed) (MlViewAppContext *a_this,
                                             gpointer a_mlview_xml_doc,
                                             gpointer a_user_data) ;
};


enum MlViewTreeEditorsNodeColour {
        MLVIEW_XML_ELEMENT_NODE_COLOUR = 0,
        MLVIEW_XML_ATTR_VAL_COLOUR,
        MLVIEW_XML_TEXT_NODE_COLOUR,
        MLVIEW_XML_COMMENT_NODE_COLOUR,
        MLVIEW_XML_DOCUMENT_NODE_COLOUR,
        MLVIEW_XML_PI_NODE_COLOUR,
        MLVIEW_XML_DTD_NODE_COLOUR,
        MLVIEW_XML_ENTITY_DECL_NODE_COLOUR,
        NB_OF_TREE_NODE_COLOURS /*this must remain the last entry of the enum*/
} ;

/**
 *The public application wide settings
 *data structure.
 *This data structure is readonly for the
 *application (so far).
 */
struct MlViewAppSettings {
        struct {
                gboolean validation_is_on ;
                gboolean enable_completion_box;
                gchar *default_editing_view_type ;
        } general ;
        struct {
                gint default_doc_expansion_depth ;
                gchar * nodes_colours[NB_OF_TREE_NODE_COLOURS] ;
        } tree_editors ;
        struct {
                /*reserved for futur usage.*/
        } network;
} ;

/**
 *The structure which contains icons to
 *represent different types of XML nodes
 *used across different components of
 *the application.
 */
struct MlViewTypeIcons {
        GdkPixbuf *element;
        GdkPixbuf *open_element;
        GdkPixbuf *text;
        GdkPixbuf *root;
        GdkPixbuf *open_root;
        GdkPixbuf *comment;
        GdkPixbuf *pi;
        GdkPixbuf *entity_ref;
};

/*************************************
 *Public API of the MlViewAppContext
 *************************************/

GType mlview_app_context_get_type (void);

gint *mlview_app_context_get_last_id_ptr (MlViewAppContext *
                                          a_this);

gint mlview_app_context_get_last_id (MlViewAppContext *
                                a_this);

void mlview_app_context_set_last_id (MlViewAppContext * a_this,
                                 gint a_new_id);

void mlview_app_context_set_element (MlViewAppContext * a_context,
                                 const gchar * a_element_name,
                                 gpointer a_context_element);

gpointer mlview_app_context_get_element (MlViewAppContext * a_context,
                                const gchar * a_element_name);

MlViewAppContext *mlview_app_context_get_instance (void);

/*display a message in the app bar*/
void mlview_app_context_sbar_push_message (MlViewAppContext * a_context,
                                           const gchar * a_msg_format, ...);

void mlview_app_context_sbar_pop_message (MlViewAppContext * a_context);

void mlview_app_context_sbar_set_default_message (MlViewAppContext * a_context,
                                                  const gchar * a_msg_format, ...);

void mlview_app_context_message (MlViewAppContext * a_context,
                                 const gchar * a_msg_format, ...);

void mlview_app_context_error (MlViewAppContext * a_context,
                               const gchar * a_msg_format, ...);

void mlview_app_context_warning (MlViewAppContext * a_context,
                                 const gchar * a_msg_format, ...);

void mlview_app_context_bufferize_error (MlViewAppContext *a_context, 
                                         const gchar *a_msg_format, ...);

void mlview_app_context_display_buffered_error (MlViewAppContext * a_context);

gboolean mlview_app_context_error_buffer_is_empty (MlViewAppContext *
                                                   a_context);

void mlview_app_context_set_error_dialog_title (MlViewAppContext * a_context,
                                                const gchar * a_title);

gchar *mlview_app_context_get_error_dialog_title (MlViewAppContext * a_context);

GConfClient * mlview_app_context_get_gconf_client (MlViewAppContext *a_this) ;

struct MlViewAppSettings * mlview_app_context_get_settings (MlViewAppContext *a_this) ;


MlViewFileSelection * mlview_app_context_get_file_selector (MlViewAppContext * a_this,
                                                            const gchar * a_title);

#ifdef MLVIEW_WITH_GTK_FILE_CHOOSER
GtkFileChooser * mlview_app_context_get_file_chooser (MlViewAppContext *a_this,
                                                      const gchar *a_title) ;
#endif


gint mlview_app_context_get_xpm (MlViewAppContext * a_this,
                                 const gchar * a_xpm_name,
                                 GdkPixmap ** a_pixmap,
                                 GdkBitmap ** a_bitmap);

void mlview_app_context_set_xml_catalog (MlViewAppContext * a_this,
                                         xmlCatalog * a_xml_catalog) ;

xmlCatalog *mlview_app_context_get_xml_catalog (MlViewAppContext* a_this);


enum MlViewStatus mlview_app_context_notify_contextual_menu_request (MlViewAppContext *a_this,
                                                                     GtkWidget *a_source_widget,
                                                                     GdkEvent *a_event) ;

enum MlViewStatus mlview_app_context_notify_view_swapped (MlViewAppContext *a_this,
                                                          gpointer a_old_view,
                                                          gpointer a_new_view) ;

enum MlViewStatus mlview_app_context_notify_application_initialized (MlViewAppContext *a_this) ;

enum MlViewStatus mlview_app_context_notify_document_name_changed (MlViewAppContext *a_this,
                                                                   gpointer a_document) ;

enum MlViewStatus  mlview_app_context_notify_document_undo_state_changed (MlViewAppContext *a_this,
                                                                          gpointer a_doc) ;

gboolean mlview_app_context_ask_internal_subset_node_name (gchar **a_name) ;

void mlview_app_context_type_icons_unref (MlViewAppContext *a_this);

struct MlViewTypeIcons *mlview_app_context_type_icons_ref (MlViewAppContext *a_this);


G_END_DECLS
#endif /*__MLVIEW-APP-CONTEXT_H__*/
