/* -*- Mode: C; indent-tabs-mode:nil; c-basic-offset: 8-*- */
/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *See COPYRIGHT file for copyright information.
 */

#include <glade/glade.h>
#include "mlview-preferences.h"
#include "mlview-app-context.h"
#include "mlview-utils.h"
#include "config.h"

/**
 *@file
 *definition of the preferences editor gui.
 *This is work in progress, does not work
 *and is maybe going to be rewriten in a near
 *future.
 */
enum {                          
/* for the icon list on the prefs dialog */
        PREFS_CATEGORY,
        PREFS_CAT_N_COL
};

typedef struct _MlviewPrefCategory MlviewPrefCategory;

/* store each icon's info */
struct _MlviewPrefCategory {
        const gchar *icon_text;
        const gchar *icon_file_name;
        const gchar *widget_name;
        GdkPixbuf *icon;
        GtkWidget *page_widget;
};

MlviewPrefCategory prefs_category[] = {
        {"MlView", DATADIR "/pixmaps/mlview-app-icon.xpm",
         "prefs_xml_page", NULL, NULL},
        {NULL, NULL, NULL, NULL, NULL}
};

static GtkWidget *gv_prefs_dialog = NULL;

static void
column_set_func_pixbuf (GtkTreeViewColumn * column,
                        GtkCellRenderer * rend,
                        GtkTreeModel * model,
                        GtkTreeIter * iter, gpointer data)
{
        MlviewPrefCategory *cat;

        gtk_tree_model_get (model, iter, PREFS_CATEGORY, &cat,
                            -1);
        g_object_set (GTK_CELL_RENDERER (rend), "pixbuf",
                      cat->icon, NULL);
}

/**
 * Remove the current category (icon) selected, 
 * thus removing the whole notebook
 * widget
 */
static void
mlview_preferences_unload_current_page (void)
{
        GtkWidget *hbox;
        GtkWidget *page;

        hbox = g_object_get_data (G_OBJECT (gv_prefs_dialog),
                                  "hbox");
        page = g_object_get_data (G_OBJECT (gv_prefs_dialog),
                                  "current_page");

        if (page && hbox)
                gtk_container_remove (GTK_CONTAINER (hbox),
                                      page);
}

/*
 * This will load a new category, with notebook
 * pages for each category
 */
static void
mlview_preferences_load_page (MlviewPrefCategory * a_cat)
{
        GladeXML *gxml;
        gchar *gfile;

        g_return_if_fail (a_cat != NULL);

        if (!a_cat->page_widget) {
                gfile = gnome_program_locate_file 
                        (NULL, 
                         GNOME_FILE_DOMAIN_APP_DATADIR,
                         PACKAGE "/mlview-preferences.glade", 
                         TRUE, NULL) ;
                g_return_if_fail (gfile) ;
                gxml = glade_xml_new (gfile, a_cat->widget_name,
                                      NULL);
                g_return_if_fail (gxml) ;
                a_cat->page_widget =
                        glade_xml_get_widget (gxml,
                                              a_cat->widget_name);
                /* make a ref for each page created for the first time, so it won't be
                 * deleted when calling gtk_container_remove() when unloading
                 */
                g_object_ref (a_cat->page_widget);
                g_object_unref (gxml);
        }

        gtk_box_pack_start
                (GTK_BOX
                 (g_object_get_data
                  (G_OBJECT (gv_prefs_dialog), "hbox")),
                 a_cat->page_widget, TRUE, TRUE, 0);

        g_object_set_data (G_OBJECT (gv_prefs_dialog),
                           "current_page", a_cat->page_widget);

        gtk_widget_show_all (a_cat->page_widget);
}


static void
mlview_preferences_change_page_cb (GtkTreeSelection * a_sel,
                                   gpointer a_pointer)
{
        GtkTreeIter iter;
        GtkTreeModel *model;
        MlviewPrefCategory *cat;

        if (gtk_tree_selection_get_selected
            (a_sel, &model, &iter)) {
                gtk_tree_model_get (model, &iter, PREFS_CATEGORY,
                                    &cat, -1);

                mlview_preferences_unload_current_page ();
                mlview_preferences_load_page (cat);
        }
}

/**
 *  create the left side icon list and connect the signals
 */
static void
mlview_preferences_icon_list (GladeXML * a_gxml)
{
        GtkWidget *treeview;
        GtkListStore *store;
        GtkCellRenderer *renderer;
        GtkTreeViewColumn *column;
        GtkTreeSelection *select;
        GtkTreeIter iter;
        gint i;

        treeview =
                glade_xml_get_widget (a_gxml, "prefs_treeview");

        g_return_if_fail (treeview != NULL);

        store = gtk_list_store_new (PREFS_CAT_N_COL,
                                    G_TYPE_POINTER);
        gtk_tree_view_set_model (GTK_TREE_VIEW (treeview),
                                 GTK_TREE_MODEL (store));

        for (i = 0; prefs_category[i].icon_text != NULL; i++) {
                prefs_category[i].icon = gdk_pixbuf_new_from_file
                        (prefs_category[i].icon_file_name, NULL);

                gtk_list_store_append (store, &iter);
                gtk_list_store_set (store, &iter,
                                    PREFS_CATEGORY,
                                    &prefs_category[i], -1);
        }

        renderer = gtk_cell_renderer_pixbuf_new ();
        column = gtk_tree_view_column_new ();
        gtk_tree_view_column_pack_start (column, renderer, TRUE);
        gtk_tree_view_column_set_cell_data_func (column,
                                                 renderer,
                                                 column_set_func_pixbuf,
                                                 NULL, NULL);
        gtk_tree_view_append_column (GTK_TREE_VIEW (treeview),
                                     column);

        select = gtk_tree_view_get_selection (GTK_TREE_VIEW
                                              (treeview));
        gtk_tree_selection_set_mode (select,
                                     GTK_SELECTION_SINGLE);

        g_signal_connect (G_OBJECT (select), "changed",
                          G_CALLBACK
                          (mlview_preferences_change_page_cb),
                          NULL);

        /* select the first icon */
        gtk_tree_model_get_iter_first (GTK_TREE_MODEL (store),
                                       &iter);
        gtk_tree_selection_select_iter (select, &iter);

        gtk_widget_show_all (GTK_WIDGET (treeview));
}

static void
mlview_preferences_dialog_response_cb (GtkDialog * a_dialog,
                                       gint a_arg1,
                                       gpointer a_pointer)
{
        switch (a_arg1) {
        case GTK_RESPONSE_CLOSE:
        case GTK_RESPONSE_NONE:
        case GTK_RESPONSE_DELETE_EVENT:
                gtk_widget_hide (GTK_WIDGET (a_dialog));
                break;
        }
}

/**
 * Create (first time load) or show the dialog, when called 
 */
void
mlview_preferences_dialog_show (MlViewAppContext * a_context)
{
        GladeXML *gxml;
        GtkWidget *hbox;
        gchar *gfile;

        if (gv_prefs_dialog) {
                /* just show it if we created it already */
                gtk_window_present (GTK_WINDOW
                                    (gv_prefs_dialog));
                return;
        }

        gfile = gnome_program_locate_file
                (NULL, GNOME_FILE_DOMAIN_APP_DATADIR,
                 PACKAGE "/mlview-preferences.glade", 
                 TRUE, NULL) ;
        gxml = glade_xml_new (gfile, "prefs_dialog", NULL);
        if (!gxml) {
                mlview_app_context_error 
                        (a_context,
                         _("Unable to load Glade user interface file; "
                           "%s.\nMake sure the file is accessible."), 
                         gfile) ;
        }
        gv_prefs_dialog = glade_xml_get_widget (gxml, "prefs_dialog");

        hbox = glade_xml_get_widget (gxml, "prefs_hbox");
        g_object_set_data (G_OBJECT (gv_prefs_dialog), "hbox",
                           hbox);
        g_signal_connect (G_OBJECT (gv_prefs_dialog), "response",
                          G_CALLBACK
                          (mlview_preferences_dialog_response_cb),
                          NULL);
        g_signal_connect (G_OBJECT (gv_prefs_dialog),
                          "delete-event", G_CALLBACK (gtk_true),
                          NULL);

        /* populate the icon list */
        mlview_preferences_icon_list (gxml);
        glade_xml_signal_autoconnect (gxml);
        g_object_unref (gxml);

        g_free (gfile);
}
